//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4SystemOfUnits
//
// Import CLHEP units on global namespace.
// Restricted to internal use -only- in source code

// Author: G.Cosmo, CERN
// --------------------------------------------------------------------
#ifndef G4SystemOfUnits_hh
#define G4SystemOfUnits_hh 1

#include <CLHEP/Units/SystemOfUnits.h>

using CLHEP::ampere;
using CLHEP::angstrom;
using CLHEP::atmosphere;
using CLHEP::bar;
using CLHEP::barn;
using CLHEP::becquerel;
using CLHEP::candela;
using CLHEP::centimeter;
using CLHEP::centimeter2;
using CLHEP::centimeter3;
using CLHEP::cL;
using CLHEP::cm;
using CLHEP::cm2;
using CLHEP::cm3;
using CLHEP::coulomb;
using CLHEP::curie;
using CLHEP::day;
using CLHEP::deg;
using CLHEP::degree;
using CLHEP::dL;
using CLHEP::e_SI;
using CLHEP::electronvolt;
using CLHEP::eplus;
using CLHEP::eV;
using CLHEP::farad;
using CLHEP::fermi;
using CLHEP::g;
using CLHEP::gauss;
using CLHEP::GeV;
using CLHEP::gigaelectronvolt;
using CLHEP::gram;
using CLHEP::gray;
using CLHEP::henry;
using CLHEP::hep_pascal;
using CLHEP::hertz;
using CLHEP::hour;
using CLHEP::joule;
using CLHEP::kelvin;
using CLHEP::keV;
using CLHEP::kg;
using CLHEP::kiloelectronvolt;
using CLHEP::kilogauss;
using CLHEP::kilogram;
using CLHEP::kilohertz;
using CLHEP::kilometer;
using CLHEP::kilometer2;
using CLHEP::kilometer3;
using CLHEP::kilovolt;
using CLHEP::km;
using CLHEP::km2;
using CLHEP::km3;
using CLHEP::L;
using CLHEP::liter;
using CLHEP::lumen;
using CLHEP::lux;
using CLHEP::m;
using CLHEP::m2;
using CLHEP::m3;
using CLHEP::megaelectronvolt;
using CLHEP::megahertz;
using CLHEP::megavolt;
using CLHEP::meter;
using CLHEP::meter2;
using CLHEP::meter3;
using CLHEP::MeV;
using CLHEP::mg;
using CLHEP::microampere;
using CLHEP::microbarn;
using CLHEP::microfarad;
using CLHEP::micrometer;
using CLHEP::microsecond;
using CLHEP::milliampere;
using CLHEP::millibarn;
using CLHEP::millielectronvolt;
using CLHEP::millifarad;
using CLHEP::milligram;
using CLHEP::millimeter;
using CLHEP::millimeter2;
using CLHEP::millimeter3;
using CLHEP::milliradian;
using CLHEP::millisecond;
using CLHEP::minute;
using CLHEP::mL;
using CLHEP::mm;
using CLHEP::mm2;
using CLHEP::mm3;
using CLHEP::mole;
using CLHEP::mrad;
using CLHEP::ms;
using CLHEP::nanoampere;
using CLHEP::nanobarn;
using CLHEP::nanofarad;
using CLHEP::nanometer;
using CLHEP::nanosecond;
using CLHEP::newton;
using CLHEP::nm;
using CLHEP::ns;
using CLHEP::ohm;
using CLHEP::parsec;
using CLHEP::pc;
using CLHEP::perCent;
using CLHEP::perMillion;
using CLHEP::perThousand;
using CLHEP::petaelectronvolt;
using CLHEP::PeV;
using CLHEP::picobarn;
using CLHEP::picofarad;
using CLHEP::picosecond;
using CLHEP::ps;
using CLHEP::rad;
using CLHEP::radian;
using CLHEP::s;
using CLHEP::second;
using CLHEP::sr;
using CLHEP::steradian;
using CLHEP::teraelectronvolt;
using CLHEP::tesla;
using CLHEP::TeV;
using CLHEP::um;
using CLHEP::us;
using CLHEP::volt;
using CLHEP::watt;
using CLHEP::weber;
using CLHEP::year;  

#endif
