//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// ------------------------------------------------------------
//      GEANT 4 class header file
//
//      History:
//	 	1 July 2009 creation by L. Desorgher based on a modification of G4Ions
//
//-------------------------------------------------------------
//	Documentation:
//		Adjoint particles are used in Reverse/Adjoint Monte Carlo simulations. New adjoint
//		processes act on adjoint particles when they are  tracked backward in the geometry.
//		The use of adjoint particles instead of "normal" particles during a reverse simulation
//		is based on an idea of M. Asai.
//

#ifndef G4AdjointIons_h
#define G4AdjointIons_h 1

#include "G4ParticleDefinition.hh"
#include "G4String.hh"
#include "G4Types.hh"

class G4AdjointIons : public G4ParticleDefinition
{
    // Class Description
    //  This is the base class for all nuclei including pre-defined
    //  light nuclei such as deuteron, alpha, and proton (Hydrogen)
    //  All nuclei/ions created on the fly are objects of this class
    //  Atomic number and atomic mass are vaild only for particles derived
    //  from this class.  This class has Excitation Energy in addition to
    //  the normal particle properties.

  public:
    // clang-format off
   G4AdjointIons(
       const G4String&     aName,        G4double            mass,
       G4double            width,        G4double            charge,   
       G4int               iSpin,        G4int               iParity,    
       G4int               iConjugation, G4int               iIsospin,   
       G4int               iIsospin3,    G4int               gParity,
       const G4String&     pType,        G4int               lepton,      
       G4int               baryon,       G4int               encoding,
       G4bool              stable,       G4double            lifetime,
       G4DecayTable        *decaytable,  G4bool              shortlived,
       const G4String&     subType ="",
       G4int               anti_encoding =0,
       G4double            excitation = 0.0
   );
    // clang-format on

    ~G4AdjointIons() override = default;

    G4AdjointIons* IonsDefinition();
    G4AdjointIons* Ions();

    // Get excitation energy of nucleus
    G4double GetExcitationEnergy() const;

  protected:
    G4AdjointIons() = default;

  private:
    G4double theExcitationEnergy;
};

inline G4AdjointIons* G4AdjointIons::Ions()
{
  return this;
}

inline G4double G4AdjointIons::GetExcitationEnergy() const
{
  return theExcitationEnergy;
}

#endif
