// Copyright 2019-2023 The Inspektor Gadget authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v6.31.1
// source: api/api.proto

package api

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Kind int32

const (
	Kind_Invalid Kind = 0
	Kind_Bool    Kind = 1
	Kind_Int8    Kind = 2
	Kind_Int16   Kind = 3
	Kind_Int32   Kind = 4
	Kind_Int64   Kind = 5
	Kind_Uint8   Kind = 6
	Kind_Uint16  Kind = 7
	Kind_Uint32  Kind = 8
	Kind_Uint64  Kind = 9
	Kind_Float32 Kind = 10
	Kind_Float64 Kind = 11
	Kind_String  Kind = 12
	Kind_CString Kind = 13
	Kind_Bytes   Kind = 14
)

// Enum value maps for Kind.
var (
	Kind_name = map[int32]string{
		0:  "Invalid",
		1:  "Bool",
		2:  "Int8",
		3:  "Int16",
		4:  "Int32",
		5:  "Int64",
		6:  "Uint8",
		7:  "Uint16",
		8:  "Uint32",
		9:  "Uint64",
		10: "Float32",
		11: "Float64",
		12: "String",
		13: "CString",
		14: "Bytes",
	}
	Kind_value = map[string]int32{
		"Invalid": 0,
		"Bool":    1,
		"Int8":    2,
		"Int16":   3,
		"Int32":   4,
		"Int64":   5,
		"Uint8":   6,
		"Uint16":  7,
		"Uint32":  8,
		"Uint64":  9,
		"Float32": 10,
		"Float64": 11,
		"String":  12,
		"CString": 13,
		"Bytes":   14,
	}
)

func (x Kind) Enum() *Kind {
	p := new(Kind)
	*p = x
	return p
}

func (x Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_api_api_proto_enumTypes[0].Descriptor()
}

func (Kind) Type() protoreflect.EnumType {
	return &file_api_api_proto_enumTypes[0]
}

func (x Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Kind.Descriptor instead.
func (Kind) EnumDescriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{0}
}

type GadgetRunRequest struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	ImageName string                 `protobuf:"bytes,1,opt,name=imageName,proto3" json:"imageName,omitempty"`
	// paramValues is a combined map of all params a gadget could need (including those
	// of runtime and operators, which need specific prefixes, see implementation in
	// pkg/runtime/grpc)
	ParamValues map[string]string `protobuf:"bytes,2,rep,name=paramValues,proto3" json:"paramValues,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// args are all parameters which were not specified with a flag
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// used to inform the server about the expected protocol version
	Version uint32 `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	// sets the requested log level (see pkg/logger/logger.go)
	LogLevel uint32 `protobuf:"varint,12,opt,name=logLevel,proto3" json:"logLevel,omitempty"`
	// time that a gadget should run; use 0, if the gadget should run until it's being
	// stopped or done; time is in nanoseconds and directly converted to time.Duration
	Timeout       int64 `protobuf:"varint,13,opt,name=timeout,proto3" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetRunRequest) Reset() {
	*x = GadgetRunRequest{}
	mi := &file_api_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetRunRequest) ProtoMessage() {}

func (x *GadgetRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetRunRequest.ProtoReflect.Descriptor instead.
func (*GadgetRunRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{0}
}

func (x *GadgetRunRequest) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *GadgetRunRequest) GetParamValues() map[string]string {
	if x != nil {
		return x.ParamValues
	}
	return nil
}

func (x *GadgetRunRequest) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *GadgetRunRequest) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GadgetRunRequest) GetLogLevel() uint32 {
	if x != nil {
		return x.LogLevel
	}
	return 0
}

func (x *GadgetRunRequest) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

type GadgetAttachRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// id of the gadget to attach to
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// used to inform the server about the expected protocol version
	Version       uint32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetAttachRequest) Reset() {
	*x = GadgetAttachRequest{}
	mi := &file_api_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetAttachRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetAttachRequest) ProtoMessage() {}

func (x *GadgetAttachRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetAttachRequest.ProtoReflect.Descriptor instead.
func (*GadgetAttachRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{1}
}

func (x *GadgetAttachRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *GadgetAttachRequest) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

type GadgetEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types are specified in consts.go. Upper 16 bits are used for log severity levels
	Type          uint32 `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	Seq           uint32 `protobuf:"varint,2,opt,name=seq,proto3" json:"seq,omitempty"`
	Payload       []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	DataSourceID  uint32 `protobuf:"varint,4,opt,name=dataSourceID,proto3" json:"dataSourceID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetEvent) Reset() {
	*x = GadgetEvent{}
	mi := &file_api_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetEvent) ProtoMessage() {}

func (x *GadgetEvent) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetEvent.ProtoReflect.Descriptor instead.
func (*GadgetEvent) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{2}
}

func (x *GadgetEvent) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *GadgetEvent) GetSeq() uint32 {
	if x != nil {
		return x.Seq
	}
	return 0
}

func (x *GadgetEvent) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *GadgetEvent) GetDataSourceID() uint32 {
	if x != nil {
		return x.DataSourceID
	}
	return 0
}

type GadgetStopRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetStopRequest) Reset() {
	*x = GadgetStopRequest{}
	mi := &file_api_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetStopRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetStopRequest) ProtoMessage() {}

func (x *GadgetStopRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetStopRequest.ProtoReflect.Descriptor instead.
func (*GadgetStopRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{3}
}

type GadgetControlRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*GadgetControlRequest_RunRequest
	//	*GadgetControlRequest_StopRequest
	//	*GadgetControlRequest_AttachRequest
	Event         isGadgetControlRequest_Event `protobuf_oneof:"Event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetControlRequest) Reset() {
	*x = GadgetControlRequest{}
	mi := &file_api_api_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetControlRequest) ProtoMessage() {}

func (x *GadgetControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetControlRequest.ProtoReflect.Descriptor instead.
func (*GadgetControlRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{4}
}

func (x *GadgetControlRequest) GetEvent() isGadgetControlRequest_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *GadgetControlRequest) GetRunRequest() *GadgetRunRequest {
	if x != nil {
		if x, ok := x.Event.(*GadgetControlRequest_RunRequest); ok {
			return x.RunRequest
		}
	}
	return nil
}

func (x *GadgetControlRequest) GetStopRequest() *GadgetStopRequest {
	if x != nil {
		if x, ok := x.Event.(*GadgetControlRequest_StopRequest); ok {
			return x.StopRequest
		}
	}
	return nil
}

func (x *GadgetControlRequest) GetAttachRequest() *GadgetAttachRequest {
	if x != nil {
		if x, ok := x.Event.(*GadgetControlRequest_AttachRequest); ok {
			return x.AttachRequest
		}
	}
	return nil
}

type isGadgetControlRequest_Event interface {
	isGadgetControlRequest_Event()
}

type GadgetControlRequest_RunRequest struct {
	RunRequest *GadgetRunRequest `protobuf:"bytes,1,opt,name=runRequest,proto3,oneof"`
}

type GadgetControlRequest_StopRequest struct {
	StopRequest *GadgetStopRequest `protobuf:"bytes,2,opt,name=stopRequest,proto3,oneof"`
}

type GadgetControlRequest_AttachRequest struct {
	AttachRequest *GadgetAttachRequest `protobuf:"bytes,3,opt,name=attachRequest,proto3,oneof"`
}

func (*GadgetControlRequest_RunRequest) isGadgetControlRequest_Event() {}

func (*GadgetControlRequest_StopRequest) isGadgetControlRequest_Event() {}

func (*GadgetControlRequest_AttachRequest) isGadgetControlRequest_Event() {}

type InfoRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InfoRequest) Reset() {
	*x = InfoRequest{}
	mi := &file_api_api_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoRequest) ProtoMessage() {}

func (x *InfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoRequest.ProtoReflect.Descriptor instead.
func (*InfoRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{5}
}

func (x *InfoRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type InfoResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Experimental  bool                   `protobuf:"varint,3,opt,name=experimental,proto3" json:"experimental,omitempty"`
	ServerVersion string                 `protobuf:"bytes,4,opt,name=serverVersion,proto3" json:"serverVersion,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InfoResponse) Reset() {
	*x = InfoResponse{}
	mi := &file_api_api_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoResponse) ProtoMessage() {}

func (x *InfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoResponse.ProtoReflect.Descriptor instead.
func (*InfoResponse) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{6}
}

func (x *InfoResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *InfoResponse) GetExperimental() bool {
	if x != nil {
		return x.Experimental
	}
	return false
}

func (x *InfoResponse) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

type DataElement struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Payload       [][]byte               `protobuf:"bytes,1,rep,name=payload,proto3" json:"payload,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DataElement) Reset() {
	*x = DataElement{}
	mi := &file_api_api_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataElement) ProtoMessage() {}

func (x *DataElement) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataElement.ProtoReflect.Descriptor instead.
func (*DataElement) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{7}
}

func (x *DataElement) GetPayload() [][]byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

type GadgetData struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Node          string                 `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	Seq           uint32                 `protobuf:"varint,2,opt,name=seq,proto3" json:"seq,omitempty"`
	Data          *DataElement           `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetData) Reset() {
	*x = GadgetData{}
	mi := &file_api_api_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetData) ProtoMessage() {}

func (x *GadgetData) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetData.ProtoReflect.Descriptor instead.
func (*GadgetData) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{8}
}

func (x *GadgetData) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *GadgetData) GetSeq() uint32 {
	if x != nil {
		return x.Seq
	}
	return 0
}

func (x *GadgetData) GetData() *DataElement {
	if x != nil {
		return x.Data
	}
	return nil
}

type GadgetDataArray struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Node          string                 `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	Seq           uint32                 `protobuf:"varint,2,opt,name=seq,proto3" json:"seq,omitempty"`
	DataArray     []*DataElement         `protobuf:"bytes,3,rep,name=dataArray,proto3" json:"dataArray,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetDataArray) Reset() {
	*x = GadgetDataArray{}
	mi := &file_api_api_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetDataArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetDataArray) ProtoMessage() {}

func (x *GadgetDataArray) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetDataArray.ProtoReflect.Descriptor instead.
func (*GadgetDataArray) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{9}
}

func (x *GadgetDataArray) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *GadgetDataArray) GetSeq() uint32 {
	if x != nil {
		return x.Seq
	}
	return 0
}

func (x *GadgetDataArray) GetDataArray() []*DataElement {
	if x != nil {
		return x.DataArray
	}
	return nil
}

type Param struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	Key            string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Description    string                 `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	DefaultValue   string                 `protobuf:"bytes,3,opt,name=defaultValue,proto3" json:"defaultValue,omitempty"`
	TypeHint       string                 `protobuf:"bytes,4,opt,name=typeHint,proto3" json:"typeHint,omitempty"`
	Title          string                 `protobuf:"bytes,5,opt,name=title,proto3" json:"title,omitempty"`
	Alias          string                 `protobuf:"bytes,6,opt,name=alias,proto3" json:"alias,omitempty"`
	Tags           []string               `protobuf:"bytes,7,rep,name=tags,proto3" json:"tags,omitempty"`
	ValueHint      string                 `protobuf:"bytes,8,opt,name=valueHint,proto3" json:"valueHint,omitempty"`
	PossibleValues []string               `protobuf:"bytes,9,rep,name=possibleValues,proto3" json:"possibleValues,omitempty"`
	IsMandatory    bool                   `protobuf:"varint,10,opt,name=isMandatory,proto3" json:"isMandatory,omitempty"`
	Prefix         string                 `protobuf:"bytes,11,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Param) Reset() {
	*x = Param{}
	mi := &file_api_api_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Param) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Param) ProtoMessage() {}

func (x *Param) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Param.ProtoReflect.Descriptor instead.
func (*Param) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{10}
}

func (x *Param) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Param) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Param) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

func (x *Param) GetTypeHint() string {
	if x != nil {
		return x.TypeHint
	}
	return ""
}

func (x *Param) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Param) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *Param) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Param) GetValueHint() string {
	if x != nil {
		return x.ValueHint
	}
	return ""
}

func (x *Param) GetPossibleValues() []string {
	if x != nil {
		return x.PossibleValues
	}
	return nil
}

func (x *Param) GetIsMandatory() bool {
	if x != nil {
		return x.IsMandatory
	}
	return false
}

func (x *Param) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

type GadgetInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ImageName     string                 `protobuf:"bytes,2,opt,name=imageName,proto3" json:"imageName,omitempty"`
	DataSources   []*DataSource          `protobuf:"bytes,4,rep,name=dataSources,proto3" json:"dataSources,omitempty"`
	Annotations   map[string]string      `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Metadata      []byte                 `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Params        []*Param               `protobuf:"bytes,7,rep,name=params,proto3" json:"params,omitempty"`
	Id            string                 `protobuf:"bytes,8,opt,name=id,proto3" json:"id,omitempty"`
	ExtraInfo     *ExtraInfo             `protobuf:"bytes,9,opt,name=extraInfo,proto3" json:"extraInfo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetInfo) Reset() {
	*x = GadgetInfo{}
	mi := &file_api_api_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetInfo) ProtoMessage() {}

func (x *GadgetInfo) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetInfo.ProtoReflect.Descriptor instead.
func (*GadgetInfo) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{11}
}

func (x *GadgetInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GadgetInfo) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *GadgetInfo) GetDataSources() []*DataSource {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *GadgetInfo) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *GadgetInfo) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *GadgetInfo) GetParams() []*Param {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *GadgetInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *GadgetInfo) GetExtraInfo() *ExtraInfo {
	if x != nil {
		return x.ExtraInfo
	}
	return nil
}

type ExtraInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// key can be "wasm.upcalls", "ebpf.sections", etc
	Data          map[string]*GadgetInspectAddendum `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExtraInfo) Reset() {
	*x = ExtraInfo{}
	mi := &file_api_api_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtraInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtraInfo) ProtoMessage() {}

func (x *ExtraInfo) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtraInfo.ProtoReflect.Descriptor instead.
func (*ExtraInfo) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{12}
}

func (x *ExtraInfo) GetData() map[string]*GadgetInspectAddendum {
	if x != nil {
		return x.Data
	}
	return nil
}

type GadgetInspectAddendum struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// contentType could be application/json, text/plain, text/mermaid, text/markdown...
	ContentType   string `protobuf:"bytes,1,opt,name=contentType,proto3" json:"contentType,omitempty"`
	Content       []byte `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetInspectAddendum) Reset() {
	*x = GadgetInspectAddendum{}
	mi := &file_api_api_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetInspectAddendum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetInspectAddendum) ProtoMessage() {}

func (x *GadgetInspectAddendum) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetInspectAddendum.ProtoReflect.Descriptor instead.
func (*GadgetInspectAddendum) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{13}
}

func (x *GadgetInspectAddendum) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *GadgetInspectAddendum) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

type DataSource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            uint32                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Type          uint32                 `protobuf:"varint,3,opt,name=type,proto3" json:"type,omitempty"`
	Fields        []*Field               `protobuf:"bytes,4,rep,name=fields,proto3" json:"fields,omitempty"`
	Tags          []string               `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	Annotations   map[string]string      `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Flags         uint32                 `protobuf:"varint,7,opt,name=flags,proto3" json:"flags,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DataSource) Reset() {
	*x = DataSource{}
	mi := &file_api_api_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSource) ProtoMessage() {}

func (x *DataSource) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSource.ProtoReflect.Descriptor instead.
func (*DataSource) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{14}
}

func (x *DataSource) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *DataSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSource) GetType() uint32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *DataSource) GetFields() []*Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *DataSource) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *DataSource) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *DataSource) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

type Field struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name contains the plain field name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// fullName contains a fully qualified field name
	// e.g. when it is a sub field of another, it's called
	// otherfieldsname.name
	FullName string `protobuf:"bytes,2,opt,name=fullName,proto3" json:"fullName,omitempty"`
	// index holds the index to this field inside the
	// field array of the DataSource
	Index uint32 `protobuf:"varint,3,opt,name=index,proto3" json:"index,omitempty"`
	// payloadIndex describes in which payload this field
	// is contained
	PayloadIndex uint32 `protobuf:"varint,4,opt,name=payloadIndex,proto3" json:"payloadIndex,omitempty"`
	// offs is the offset of the fields' contents inside the
	// payload specified by payloadIndex
	Offs uint32 `protobuf:"varint,5,opt,name=offs,proto3" json:"offs,omitempty"`
	// size is (if fixed) the size of the fields' content
	Size uint32 `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
	// flags describe different attributes of the field, like
	// whether it has a parent, is virtual, etc.
	Flags uint32 `protobuf:"varint,7,opt,name=flags,proto3" json:"flags,omitempty"`
	// kind describes how the content of the field should be
	// handled
	Kind Kind `protobuf:"varint,8,opt,name=kind,proto3,enum=api.Kind" json:"kind,omitempty"`
	// tags can contain multiple tags that describe the contents
	// of the field; they are used by operators to find
	// interesting fields, for example
	Tags []string `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty"`
	// annotations are additional information that can be used
	// by operators or third party consumers
	Annotations map[string]string `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// parent holds the index of the field that is considered
	// this fields' parent; only true if the corresponding flag
	// is set in flags
	Parent uint32 `protobuf:"varint,11,opt,name=parent,proto3" json:"parent,omitempty"`
	// order determines the default position of this field when
	// ordering multiple fields
	Order         int32 `protobuf:"varint,12,opt,name=order,proto3" json:"order,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Field) Reset() {
	*x = Field{}
	mi := &file_api_api_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field.ProtoReflect.Descriptor instead.
func (*Field) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{15}
}

func (x *Field) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Field) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Field) GetIndex() uint32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *Field) GetPayloadIndex() uint32 {
	if x != nil {
		return x.PayloadIndex
	}
	return 0
}

func (x *Field) GetOffs() uint32 {
	if x != nil {
		return x.Offs
	}
	return 0
}

func (x *Field) GetSize() uint32 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Field) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *Field) GetKind() Kind {
	if x != nil {
		return x.Kind
	}
	return Kind_Invalid
}

func (x *Field) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Field) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Field) GetParent() uint32 {
	if x != nil {
		return x.Parent
	}
	return 0
}

func (x *Field) GetOrder() int32 {
	if x != nil {
		return x.Order
	}
	return 0
}

type GetGadgetInfoRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// params are the gadget's parameters
	ParamValues map[string]string `protobuf:"bytes,1,rep,name=paramValues,proto3" json:"paramValues,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ImageName   string            `protobuf:"bytes,2,opt,name=imageName,proto3" json:"imageName,omitempty"`
	// can be used to inform about the expected version of GadgetInfo
	Version uint32 `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	Flags   uint32 `protobuf:"varint,4,opt,name=flags,proto3" json:"flags,omitempty"`
	// can be used to include more info for debugging (e.g., in ig image inspect)
	RequestExtraInfo bool `protobuf:"varint,5,opt,name=requestExtraInfo,proto3" json:"requestExtraInfo,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GetGadgetInfoRequest) Reset() {
	*x = GetGadgetInfoRequest{}
	mi := &file_api_api_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGadgetInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGadgetInfoRequest) ProtoMessage() {}

func (x *GetGadgetInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGadgetInfoRequest.ProtoReflect.Descriptor instead.
func (*GetGadgetInfoRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{16}
}

func (x *GetGadgetInfoRequest) GetParamValues() map[string]string {
	if x != nil {
		return x.ParamValues
	}
	return nil
}

func (x *GetGadgetInfoRequest) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *GetGadgetInfoRequest) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GetGadgetInfoRequest) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *GetGadgetInfoRequest) GetRequestExtraInfo() bool {
	if x != nil {
		return x.RequestExtraInfo
	}
	return false
}

type GetGadgetInfoResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GadgetInfo    *GadgetInfo            `protobuf:"bytes,1,opt,name=gadgetInfo,proto3" json:"gadgetInfo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGadgetInfoResponse) Reset() {
	*x = GetGadgetInfoResponse{}
	mi := &file_api_api_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGadgetInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGadgetInfoResponse) ProtoMessage() {}

func (x *GetGadgetInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGadgetInfoResponse.ProtoReflect.Descriptor instead.
func (*GetGadgetInfoResponse) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{17}
}

func (x *GetGadgetInfoResponse) GetGadgetInfo() *GadgetInfo {
	if x != nil {
		return x.GadgetInfo
	}
	return nil
}

type CreateGadgetInstanceRequest struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	GadgetInstance    *GadgetInstance        `protobuf:"bytes,1,opt,name=gadgetInstance,proto3" json:"gadgetInstance,omitempty"`
	EventBufferLength int32                  `protobuf:"varint,2,opt,name=eventBufferLength,proto3" json:"eventBufferLength,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *CreateGadgetInstanceRequest) Reset() {
	*x = CreateGadgetInstanceRequest{}
	mi := &file_api_api_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGadgetInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGadgetInstanceRequest) ProtoMessage() {}

func (x *CreateGadgetInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGadgetInstanceRequest.ProtoReflect.Descriptor instead.
func (*CreateGadgetInstanceRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{18}
}

func (x *CreateGadgetInstanceRequest) GetGadgetInstance() *GadgetInstance {
	if x != nil {
		return x.GadgetInstance
	}
	return nil
}

func (x *CreateGadgetInstanceRequest) GetEventBufferLength() int32 {
	if x != nil {
		return x.EventBufferLength
	}
	return 0
}

type CreateGadgetInstanceResponse struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	Result         int32                  `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	GadgetInstance *GadgetInstance        `protobuf:"bytes,2,opt,name=gadgetInstance,proto3" json:"gadgetInstance,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *CreateGadgetInstanceResponse) Reset() {
	*x = CreateGadgetInstanceResponse{}
	mi := &file_api_api_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGadgetInstanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGadgetInstanceResponse) ProtoMessage() {}

func (x *CreateGadgetInstanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGadgetInstanceResponse.ProtoReflect.Descriptor instead.
func (*CreateGadgetInstanceResponse) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{19}
}

func (x *CreateGadgetInstanceResponse) GetResult() int32 {
	if x != nil {
		return x.Result
	}
	return 0
}

func (x *CreateGadgetInstanceResponse) GetGadgetInstance() *GadgetInstance {
	if x != nil {
		return x.GadgetInstance
	}
	return nil
}

type ListGadgetInstancesRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListGadgetInstancesRequest) Reset() {
	*x = ListGadgetInstancesRequest{}
	mi := &file_api_api_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGadgetInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGadgetInstancesRequest) ProtoMessage() {}

func (x *ListGadgetInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGadgetInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListGadgetInstancesRequest) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{20}
}

type GadgetInstance struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// id is the unique ID of the instance; this can be set by the client but overridden from the server, depending on the
	// environment; must contain only hex characters in lowercase
	Id           string            `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	GadgetConfig *GadgetRunRequest `protobuf:"bytes,2,opt,name=gadgetConfig,proto3" json:"gadgetConfig,omitempty"`
	// tags can hold multiple opaque strings so that users can more easily find their gadget instances
	Tags []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	// timeCreated holds the time the instance was created as a UNIX timestamp
	TimeCreated int64 `protobuf:"varint,4,opt,name=timeCreated,proto3" json:"timeCreated,omitempty"`
	// name is a (non-unique) string assigned to a gadget, set by the client
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// nodes is a list of nodes the gadget should run on; if empty, all nodes will run the gadget
	Nodes         []string `protobuf:"bytes,5,rep,name=nodes,proto3" json:"nodes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetInstance) Reset() {
	*x = GadgetInstance{}
	mi := &file_api_api_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetInstance) ProtoMessage() {}

func (x *GadgetInstance) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetInstance.ProtoReflect.Descriptor instead.
func (*GadgetInstance) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{21}
}

func (x *GadgetInstance) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *GadgetInstance) GetGadgetConfig() *GadgetRunRequest {
	if x != nil {
		return x.GadgetConfig
	}
	return nil
}

func (x *GadgetInstance) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *GadgetInstance) GetTimeCreated() int64 {
	if x != nil {
		return x.TimeCreated
	}
	return 0
}

func (x *GadgetInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GadgetInstance) GetNodes() []string {
	if x != nil {
		return x.Nodes
	}
	return nil
}

type ListGadgetInstanceResponse struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	GadgetInstances []*GadgetInstance      `protobuf:"bytes,1,rep,name=gadgetInstances,proto3" json:"gadgetInstances,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ListGadgetInstanceResponse) Reset() {
	*x = ListGadgetInstanceResponse{}
	mi := &file_api_api_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGadgetInstanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGadgetInstanceResponse) ProtoMessage() {}

func (x *ListGadgetInstanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGadgetInstanceResponse.ProtoReflect.Descriptor instead.
func (*ListGadgetInstanceResponse) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{22}
}

func (x *ListGadgetInstanceResponse) GetGadgetInstances() []*GadgetInstance {
	if x != nil {
		return x.GadgetInstances
	}
	return nil
}

type GadgetInstanceId struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GadgetInstanceId) Reset() {
	*x = GadgetInstanceId{}
	mi := &file_api_api_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GadgetInstanceId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GadgetInstanceId) ProtoMessage() {}

func (x *GadgetInstanceId) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GadgetInstanceId.ProtoReflect.Descriptor instead.
func (*GadgetInstanceId) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{23}
}

func (x *GadgetInstanceId) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type StatusResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Result        int32                  `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	Message       string                 `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StatusResponse) Reset() {
	*x = StatusResponse{}
	mi := &file_api_api_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusResponse) ProtoMessage() {}

func (x *StatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_api_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusResponse.ProtoReflect.Descriptor instead.
func (*StatusResponse) Descriptor() ([]byte, []int) {
	return file_api_api_proto_rawDescGZIP(), []int{24}
}

func (x *StatusResponse) GetResult() int32 {
	if x != nil {
		return x.Result
	}
	return 0
}

func (x *StatusResponse) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_api_api_proto protoreflect.FileDescriptor

const file_api_api_proto_rawDesc = "" +
	"\n" +
	"\rapi/api.proto\x12\x03api\"\x9e\x02\n" +
	"\x10GadgetRunRequest\x12\x1c\n" +
	"\timageName\x18\x01 \x01(\tR\timageName\x12H\n" +
	"\vparamValues\x18\x02 \x03(\v2&.api.GadgetRunRequest.ParamValuesEntryR\vparamValues\x12\x12\n" +
	"\x04args\x18\x03 \x03(\tR\x04args\x12\x18\n" +
	"\aversion\x18\x04 \x01(\rR\aversion\x12\x1a\n" +
	"\blogLevel\x18\f \x01(\rR\blogLevel\x12\x18\n" +
	"\atimeout\x18\r \x01(\x03R\atimeout\x1a>\n" +
	"\x10ParamValuesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"?\n" +
	"\x13GadgetAttachRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x18\n" +
	"\aversion\x18\x02 \x01(\rR\aversion\"q\n" +
	"\vGadgetEvent\x12\x12\n" +
	"\x04type\x18\x01 \x01(\rR\x04type\x12\x10\n" +
	"\x03seq\x18\x02 \x01(\rR\x03seq\x12\x18\n" +
	"\apayload\x18\x03 \x01(\fR\apayload\x12\"\n" +
	"\fdataSourceID\x18\x04 \x01(\rR\fdataSourceID\"\x13\n" +
	"\x11GadgetStopRequest\"\xd6\x01\n" +
	"\x14GadgetControlRequest\x127\n" +
	"\n" +
	"runRequest\x18\x01 \x01(\v2\x15.api.GadgetRunRequestH\x00R\n" +
	"runRequest\x12:\n" +
	"\vstopRequest\x18\x02 \x01(\v2\x16.api.GadgetStopRequestH\x00R\vstopRequest\x12@\n" +
	"\rattachRequest\x18\x03 \x01(\v2\x18.api.GadgetAttachRequestH\x00R\rattachRequestB\a\n" +
	"\x05Event\"'\n" +
	"\vInfoRequest\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"r\n" +
	"\fInfoResponse\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12\"\n" +
	"\fexperimental\x18\x03 \x01(\bR\fexperimental\x12$\n" +
	"\rserverVersion\x18\x04 \x01(\tR\rserverVersion\"'\n" +
	"\vDataElement\x12\x18\n" +
	"\apayload\x18\x01 \x03(\fR\apayload\"X\n" +
	"\n" +
	"GadgetData\x12\x12\n" +
	"\x04node\x18\x01 \x01(\tR\x04node\x12\x10\n" +
	"\x03seq\x18\x02 \x01(\rR\x03seq\x12$\n" +
	"\x04data\x18\x03 \x01(\v2\x10.api.DataElementR\x04data\"g\n" +
	"\x0fGadgetDataArray\x12\x12\n" +
	"\x04node\x18\x01 \x01(\tR\x04node\x12\x10\n" +
	"\x03seq\x18\x02 \x01(\rR\x03seq\x12.\n" +
	"\tdataArray\x18\x03 \x03(\v2\x10.api.DataElementR\tdataArray\"\xbb\x02\n" +
	"\x05Param\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\"\n" +
	"\fdefaultValue\x18\x03 \x01(\tR\fdefaultValue\x12\x1a\n" +
	"\btypeHint\x18\x04 \x01(\tR\btypeHint\x12\x14\n" +
	"\x05title\x18\x05 \x01(\tR\x05title\x12\x14\n" +
	"\x05alias\x18\x06 \x01(\tR\x05alias\x12\x12\n" +
	"\x04tags\x18\a \x03(\tR\x04tags\x12\x1c\n" +
	"\tvalueHint\x18\b \x01(\tR\tvalueHint\x12&\n" +
	"\x0epossibleValues\x18\t \x03(\tR\x0epossibleValues\x12 \n" +
	"\visMandatory\x18\n" +
	" \x01(\bR\visMandatory\x12\x16\n" +
	"\x06prefix\x18\v \x01(\tR\x06prefix\"\xf3\x02\n" +
	"\n" +
	"GadgetInfo\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1c\n" +
	"\timageName\x18\x02 \x01(\tR\timageName\x121\n" +
	"\vdataSources\x18\x04 \x03(\v2\x0f.api.DataSourceR\vdataSources\x12B\n" +
	"\vannotations\x18\x05 \x03(\v2 .api.GadgetInfo.AnnotationsEntryR\vannotations\x12\x1a\n" +
	"\bmetadata\x18\x06 \x01(\fR\bmetadata\x12\"\n" +
	"\x06params\x18\a \x03(\v2\n" +
	".api.ParamR\x06params\x12\x0e\n" +
	"\x02id\x18\b \x01(\tR\x02id\x12,\n" +
	"\textraInfo\x18\t \x01(\v2\x0e.api.ExtraInfoR\textraInfo\x1a>\n" +
	"\x10AnnotationsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x8e\x01\n" +
	"\tExtraInfo\x12,\n" +
	"\x04data\x18\x01 \x03(\v2\x18.api.ExtraInfo.DataEntryR\x04data\x1aS\n" +
	"\tDataEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x120\n" +
	"\x05value\x18\x02 \x01(\v2\x1a.api.GadgetInspectAddendumR\x05value:\x028\x01\"S\n" +
	"\x15GadgetInspectAddendum\x12 \n" +
	"\vcontentType\x18\x01 \x01(\tR\vcontentType\x12\x18\n" +
	"\acontent\x18\x02 \x01(\fR\acontent\"\x96\x02\n" +
	"\n" +
	"DataSource\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\rR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x12\n" +
	"\x04type\x18\x03 \x01(\rR\x04type\x12\"\n" +
	"\x06fields\x18\x04 \x03(\v2\n" +
	".api.FieldR\x06fields\x12\x12\n" +
	"\x04tags\x18\x05 \x03(\tR\x04tags\x12B\n" +
	"\vannotations\x18\x06 \x03(\v2 .api.DataSource.AnnotationsEntryR\vannotations\x12\x14\n" +
	"\x05flags\x18\a \x01(\rR\x05flags\x1a>\n" +
	"\x10AnnotationsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x8f\x03\n" +
	"\x05Field\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1a\n" +
	"\bfullName\x18\x02 \x01(\tR\bfullName\x12\x14\n" +
	"\x05index\x18\x03 \x01(\rR\x05index\x12\"\n" +
	"\fpayloadIndex\x18\x04 \x01(\rR\fpayloadIndex\x12\x12\n" +
	"\x04offs\x18\x05 \x01(\rR\x04offs\x12\x12\n" +
	"\x04size\x18\x06 \x01(\rR\x04size\x12\x14\n" +
	"\x05flags\x18\a \x01(\rR\x05flags\x12\x1d\n" +
	"\x04kind\x18\b \x01(\x0e2\t.api.KindR\x04kind\x12\x12\n" +
	"\x04tags\x18\t \x03(\tR\x04tags\x12=\n" +
	"\vannotations\x18\n" +
	" \x03(\v2\x1b.api.Field.AnnotationsEntryR\vannotations\x12\x16\n" +
	"\x06parent\x18\v \x01(\rR\x06parent\x12\x14\n" +
	"\x05order\x18\f \x01(\x05R\x05order\x1a>\n" +
	"\x10AnnotationsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x9e\x02\n" +
	"\x14GetGadgetInfoRequest\x12L\n" +
	"\vparamValues\x18\x01 \x03(\v2*.api.GetGadgetInfoRequest.ParamValuesEntryR\vparamValues\x12\x1c\n" +
	"\timageName\x18\x02 \x01(\tR\timageName\x12\x18\n" +
	"\aversion\x18\x03 \x01(\rR\aversion\x12\x14\n" +
	"\x05flags\x18\x04 \x01(\rR\x05flags\x12*\n" +
	"\x10requestExtraInfo\x18\x05 \x01(\bR\x10requestExtraInfo\x1a>\n" +
	"\x10ParamValuesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"H\n" +
	"\x15GetGadgetInfoResponse\x12/\n" +
	"\n" +
	"gadgetInfo\x18\x01 \x01(\v2\x0f.api.GadgetInfoR\n" +
	"gadgetInfo\"\x88\x01\n" +
	"\x1bCreateGadgetInstanceRequest\x12;\n" +
	"\x0egadgetInstance\x18\x01 \x01(\v2\x13.api.GadgetInstanceR\x0egadgetInstance\x12,\n" +
	"\x11eventBufferLength\x18\x02 \x01(\x05R\x11eventBufferLength\"s\n" +
	"\x1cCreateGadgetInstanceResponse\x12\x16\n" +
	"\x06result\x18\x01 \x01(\x05R\x06result\x12;\n" +
	"\x0egadgetInstance\x18\x02 \x01(\v2\x13.api.GadgetInstanceR\x0egadgetInstance\"\x1c\n" +
	"\x1aListGadgetInstancesRequest\"\xbb\x01\n" +
	"\x0eGadgetInstance\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x129\n" +
	"\fgadgetConfig\x18\x02 \x01(\v2\x15.api.GadgetRunRequestR\fgadgetConfig\x12\x12\n" +
	"\x04tags\x18\x03 \x03(\tR\x04tags\x12 \n" +
	"\vtimeCreated\x18\x04 \x01(\x03R\vtimeCreated\x12\x12\n" +
	"\x04name\x18\x06 \x01(\tR\x04name\x12\x14\n" +
	"\x05nodes\x18\x05 \x03(\tR\x05nodes\"[\n" +
	"\x1aListGadgetInstanceResponse\x12=\n" +
	"\x0fgadgetInstances\x18\x01 \x03(\v2\x13.api.GadgetInstanceR\x0fgadgetInstances\"\"\n" +
	"\x10GadgetInstanceId\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"B\n" +
	"\x0eStatusResponse\x12\x16\n" +
	"\x06result\x18\x01 \x01(\x05R\x06result\x12\x18\n" +
	"\amessage\x18\x02 \x01(\tR\amessage*\xb5\x01\n" +
	"\x04Kind\x12\v\n" +
	"\aInvalid\x10\x00\x12\b\n" +
	"\x04Bool\x10\x01\x12\b\n" +
	"\x04Int8\x10\x02\x12\t\n" +
	"\x05Int16\x10\x03\x12\t\n" +
	"\x05Int32\x10\x04\x12\t\n" +
	"\x05Int64\x10\x05\x12\t\n" +
	"\x05Uint8\x10\x06\x12\n" +
	"\n" +
	"\x06Uint16\x10\a\x12\n" +
	"\n" +
	"\x06Uint32\x10\b\x12\n" +
	"\n" +
	"\x06Uint64\x10\t\x12\v\n" +
	"\aFloat32\x10\n" +
	"\x12\v\n" +
	"\aFloat64\x10\v\x12\n" +
	"\n" +
	"\x06String\x10\f\x12\v\n" +
	"\aCString\x10\r\x12\t\n" +
	"\x05Bytes\x10\x0e2H\n" +
	"\x14BuiltInGadgetManager\x120\n" +
	"\aGetInfo\x12\x10.api.InfoRequest\x1a\x11.api.InfoResponse\"\x002\x99\x01\n" +
	"\rGadgetManager\x12H\n" +
	"\rGetGadgetInfo\x12\x19.api.GetGadgetInfoRequest\x1a\x1a.api.GetGadgetInfoResponse\"\x00\x12>\n" +
	"\tRunGadget\x12\x19.api.GadgetControlRequest\x1a\x10.api.GadgetEvent\"\x00(\x010\x012\xda\x02\n" +
	"\x15GadgetInstanceManager\x12]\n" +
	"\x14CreateGadgetInstance\x12 .api.CreateGadgetInstanceRequest\x1a!.api.CreateGadgetInstanceResponse\"\x00\x12Y\n" +
	"\x13ListGadgetInstances\x12\x1f.api.ListGadgetInstancesRequest\x1a\x1f.api.ListGadgetInstanceResponse\"\x00\x12A\n" +
	"\x11GetGadgetInstance\x12\x15.api.GadgetInstanceId\x1a\x13.api.GadgetInstance\"\x00\x12D\n" +
	"\x14RemoveGadgetInstance\x12\x15.api.GadgetInstanceId\x1a\x13.api.StatusResponse\"\x00BEZCgithub.com/inspektor-gadget/inspektor-gadget/pkg/gadget-service/apib\x06proto3"

var (
	file_api_api_proto_rawDescOnce sync.Once
	file_api_api_proto_rawDescData []byte
)

func file_api_api_proto_rawDescGZIP() []byte {
	file_api_api_proto_rawDescOnce.Do(func() {
		file_api_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_api_api_proto_rawDesc), len(file_api_api_proto_rawDesc)))
	})
	return file_api_api_proto_rawDescData
}

var file_api_api_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_api_api_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_api_api_proto_goTypes = []any{
	(Kind)(0),                            // 0: api.Kind
	(*GadgetRunRequest)(nil),             // 1: api.GadgetRunRequest
	(*GadgetAttachRequest)(nil),          // 2: api.GadgetAttachRequest
	(*GadgetEvent)(nil),                  // 3: api.GadgetEvent
	(*GadgetStopRequest)(nil),            // 4: api.GadgetStopRequest
	(*GadgetControlRequest)(nil),         // 5: api.GadgetControlRequest
	(*InfoRequest)(nil),                  // 6: api.InfoRequest
	(*InfoResponse)(nil),                 // 7: api.InfoResponse
	(*DataElement)(nil),                  // 8: api.DataElement
	(*GadgetData)(nil),                   // 9: api.GadgetData
	(*GadgetDataArray)(nil),              // 10: api.GadgetDataArray
	(*Param)(nil),                        // 11: api.Param
	(*GadgetInfo)(nil),                   // 12: api.GadgetInfo
	(*ExtraInfo)(nil),                    // 13: api.ExtraInfo
	(*GadgetInspectAddendum)(nil),        // 14: api.GadgetInspectAddendum
	(*DataSource)(nil),                   // 15: api.DataSource
	(*Field)(nil),                        // 16: api.Field
	(*GetGadgetInfoRequest)(nil),         // 17: api.GetGadgetInfoRequest
	(*GetGadgetInfoResponse)(nil),        // 18: api.GetGadgetInfoResponse
	(*CreateGadgetInstanceRequest)(nil),  // 19: api.CreateGadgetInstanceRequest
	(*CreateGadgetInstanceResponse)(nil), // 20: api.CreateGadgetInstanceResponse
	(*ListGadgetInstancesRequest)(nil),   // 21: api.ListGadgetInstancesRequest
	(*GadgetInstance)(nil),               // 22: api.GadgetInstance
	(*ListGadgetInstanceResponse)(nil),   // 23: api.ListGadgetInstanceResponse
	(*GadgetInstanceId)(nil),             // 24: api.GadgetInstanceId
	(*StatusResponse)(nil),               // 25: api.StatusResponse
	nil,                                  // 26: api.GadgetRunRequest.ParamValuesEntry
	nil,                                  // 27: api.GadgetInfo.AnnotationsEntry
	nil,                                  // 28: api.ExtraInfo.DataEntry
	nil,                                  // 29: api.DataSource.AnnotationsEntry
	nil,                                  // 30: api.Field.AnnotationsEntry
	nil,                                  // 31: api.GetGadgetInfoRequest.ParamValuesEntry
}
var file_api_api_proto_depIdxs = []int32{
	26, // 0: api.GadgetRunRequest.paramValues:type_name -> api.GadgetRunRequest.ParamValuesEntry
	1,  // 1: api.GadgetControlRequest.runRequest:type_name -> api.GadgetRunRequest
	4,  // 2: api.GadgetControlRequest.stopRequest:type_name -> api.GadgetStopRequest
	2,  // 3: api.GadgetControlRequest.attachRequest:type_name -> api.GadgetAttachRequest
	8,  // 4: api.GadgetData.data:type_name -> api.DataElement
	8,  // 5: api.GadgetDataArray.dataArray:type_name -> api.DataElement
	15, // 6: api.GadgetInfo.dataSources:type_name -> api.DataSource
	27, // 7: api.GadgetInfo.annotations:type_name -> api.GadgetInfo.AnnotationsEntry
	11, // 8: api.GadgetInfo.params:type_name -> api.Param
	13, // 9: api.GadgetInfo.extraInfo:type_name -> api.ExtraInfo
	28, // 10: api.ExtraInfo.data:type_name -> api.ExtraInfo.DataEntry
	16, // 11: api.DataSource.fields:type_name -> api.Field
	29, // 12: api.DataSource.annotations:type_name -> api.DataSource.AnnotationsEntry
	0,  // 13: api.Field.kind:type_name -> api.Kind
	30, // 14: api.Field.annotations:type_name -> api.Field.AnnotationsEntry
	31, // 15: api.GetGadgetInfoRequest.paramValues:type_name -> api.GetGadgetInfoRequest.ParamValuesEntry
	12, // 16: api.GetGadgetInfoResponse.gadgetInfo:type_name -> api.GadgetInfo
	22, // 17: api.CreateGadgetInstanceRequest.gadgetInstance:type_name -> api.GadgetInstance
	22, // 18: api.CreateGadgetInstanceResponse.gadgetInstance:type_name -> api.GadgetInstance
	1,  // 19: api.GadgetInstance.gadgetConfig:type_name -> api.GadgetRunRequest
	22, // 20: api.ListGadgetInstanceResponse.gadgetInstances:type_name -> api.GadgetInstance
	14, // 21: api.ExtraInfo.DataEntry.value:type_name -> api.GadgetInspectAddendum
	6,  // 22: api.BuiltInGadgetManager.GetInfo:input_type -> api.InfoRequest
	17, // 23: api.GadgetManager.GetGadgetInfo:input_type -> api.GetGadgetInfoRequest
	5,  // 24: api.GadgetManager.RunGadget:input_type -> api.GadgetControlRequest
	19, // 25: api.GadgetInstanceManager.CreateGadgetInstance:input_type -> api.CreateGadgetInstanceRequest
	21, // 26: api.GadgetInstanceManager.ListGadgetInstances:input_type -> api.ListGadgetInstancesRequest
	24, // 27: api.GadgetInstanceManager.GetGadgetInstance:input_type -> api.GadgetInstanceId
	24, // 28: api.GadgetInstanceManager.RemoveGadgetInstance:input_type -> api.GadgetInstanceId
	7,  // 29: api.BuiltInGadgetManager.GetInfo:output_type -> api.InfoResponse
	18, // 30: api.GadgetManager.GetGadgetInfo:output_type -> api.GetGadgetInfoResponse
	3,  // 31: api.GadgetManager.RunGadget:output_type -> api.GadgetEvent
	20, // 32: api.GadgetInstanceManager.CreateGadgetInstance:output_type -> api.CreateGadgetInstanceResponse
	23, // 33: api.GadgetInstanceManager.ListGadgetInstances:output_type -> api.ListGadgetInstanceResponse
	22, // 34: api.GadgetInstanceManager.GetGadgetInstance:output_type -> api.GadgetInstance
	25, // 35: api.GadgetInstanceManager.RemoveGadgetInstance:output_type -> api.StatusResponse
	29, // [29:36] is the sub-list for method output_type
	22, // [22:29] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_api_api_proto_init() }
func file_api_api_proto_init() {
	if File_api_api_proto != nil {
		return
	}
	file_api_api_proto_msgTypes[4].OneofWrappers = []any{
		(*GadgetControlRequest_RunRequest)(nil),
		(*GadgetControlRequest_StopRequest)(nil),
		(*GadgetControlRequest_AttachRequest)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_api_api_proto_rawDesc), len(file_api_api_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   3,
		},
		GoTypes:           file_api_api_proto_goTypes,
		DependencyIndexes: file_api_api_proto_depIdxs,
		EnumInfos:         file_api_api_proto_enumTypes,
		MessageInfos:      file_api_api_proto_msgTypes,
	}.Build()
	File_api_api_proto = out.File
	file_api_api_proto_goTypes = nil
	file_api_api_proto_depIdxs = nil
}
