/***************************************************************************
 *   Copyright (C) 2009 by Glad Deschrijver                                *
 *     <glad.deschrijver@gmail.com>                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "action.h"
#include "icon.h"

#ifdef KTIKZ_USE_KDE
#  include <KActionCollection>

KActionCollection *Action::s_actionCollection = 0;

Action::Action(QObject *parent, const QString &name) : QAction(parent)
{
    if (s_actionCollection && !name.isEmpty())
        s_actionCollection->addAction(name, this);
}

Action::Action(const QString &text, QObject *parent, const QString &name) : QAction(text, parent)
{
    if (s_actionCollection && !name.isEmpty())
        s_actionCollection->addAction(name, this);
}

Action::Action(const Icon &icon, const QString &text, QObject *parent, const QString &name)
    : QAction(icon, text, parent)
{
    if (s_actionCollection && !name.isEmpty())
        s_actionCollection->addAction(name, this);
}

void Action::setShortcut(const QKeySequence &shortcut)
{
    actionCollection()->setDefaultShortcut(this, shortcut);
}

KActionCollection *Action::actionCollection()
{
    return s_actionCollection;
}

void Action::setActionCollection(KActionCollection *actionCollection)
{
    s_actionCollection = actionCollection;
}
#else
Action::Action(QObject *parent, const QString &name) : QAction(parent)
{
    if (!name.isEmpty())
        setObjectName(name);
}

Action::Action(const QString &text, QObject *parent, const QString &name) : QAction(text, parent)
{
    if (!name.isEmpty())
        setObjectName(name);
}

Action::Action(const Icon &icon, const QString &text, QObject *parent, const QString &name)
    : QAction(icon, text, parent)
{
    if (!name.isEmpty())
        setObjectName(name);
}

void Action::setShortcut(const QKeySequence &shortcut)
{
    QAction::setShortcut(shortcut);
}
#endif
