﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Transactions.DtcProxyShim;

internal enum ShimNotificationType
{
    None = 0,
    Phase0RequestNotify = 1,
    VoteRequestNotify = 2,
    PrepareRequestNotify = 3,
    CommitRequestNotify = 4,
    AbortRequestNotify = 5,
    CommittedNotify = 6,
    AbortedNotify = 7,
    InDoubtNotify = 8,
    EnlistmentTmDownNotify = 9,
    ResourceManagerTmDownNotify = 10
}

internal enum OletxPrepareVoteType
{
    ReadOnly = 0,
    SinglePhase = 1,
    Prepared = 2,
    Failed = 3,
    InDoubt = 4
}

internal enum OletxTransactionOutcome
{
    NotKnownYet = 0,
    Committed = 1,
    Aborted = 2
}

internal enum OletxTransactionIsolationLevel
{
    ISOLATIONLEVEL_UNSPECIFIED = -1,
    ISOLATIONLEVEL_CHAOS = 0x10,
    ISOLATIONLEVEL_READUNCOMMITTED = 0x100,
    ISOLATIONLEVEL_BROWSE = 0x100,
    ISOLATIONLEVEL_CURSORSTABILITY = 0x1000,
    ISOLATIONLEVEL_READCOMMITTED = 0x1000,
    ISOLATIONLEVEL_REPEATABLEREAD = 0x10000,
    ISOLATIONLEVEL_SERIALIZABLE = 0x100000,
    ISOLATIONLEVEL_ISOLATED = 0x100000
}

[Flags]
internal enum OletxTransactionIsoFlags
{
    ISOFLAG_NONE = 0,
    ISOFLAG_RETAIN_COMMIT_DC = 1,
    ISOFLAG_RETAIN_COMMIT = 2,
    ISOFLAG_RETAIN_COMMIT_NO = 3,
    ISOFLAG_RETAIN_ABORT_DC = 4,
    ISOFLAG_RETAIN_ABORT = 8,
    ISOFLAG_RETAIN_ABORT_NO = 12,
    ISOFLAG_RETAIN_DONTCARE = ISOFLAG_RETAIN_COMMIT_DC | ISOFLAG_RETAIN_ABORT_DC,
    ISOFLAG_RETAIN_BOTH = ISOFLAG_RETAIN_COMMIT | ISOFLAG_RETAIN_ABORT,
    ISOFLAG_RETAIN_NONE = ISOFLAG_RETAIN_COMMIT_NO | ISOFLAG_RETAIN_ABORT_NO,
    ISOFLAG_OPTIMISTIC = 16,
    ISOFLAG_READONLY = 32
}

internal enum OletxXacttc : uint
{
    XACTTC_NONE = 0,
    XACTTC_SYNC_PHASEONE = 1,
    XACTTC_SYNC_PHASETWO = 2,
    XACTTC_SYNC = 2,
    XACTTC_ASYNC_PHASEONE = 4,
    XACTTC_ASYNC = 4
}

internal enum OletxXactRm : uint
{
    XACTRM_OPTIMISTICLASTWINS = 1,
    XACTRM_NOREADONLYPREPARES = 2
}

internal enum OletxTransactionStatus
{
    OLETX_TRANSACTION_STATUS_NONE = 0,
    OLETX_TRANSACTION_STATUS_OPENNORMAL = 0x1,
    OLETX_TRANSACTION_STATUS_OPENREFUSED = 0x2,
    OLETX_TRANSACTION_STATUS_PREPARING = 0x4,
    OLETX_TRANSACTION_STATUS_PREPARED = 0x8,
    OLETX_TRANSACTION_STATUS_PREPARERETAINING = 0x10,
    OLETX_TRANSACTION_STATUS_PREPARERETAINED = 0x20,
    OLETX_TRANSACTION_STATUS_COMMITTING = 0x40,
    OLETX_TRANSACTION_STATUS_COMMITRETAINING = 0x80,
    OLETX_TRANSACTION_STATUS_ABORTING = 0x100,
    OLETX_TRANSACTION_STATUS_ABORTED = 0x200,
    OLETX_TRANSACTION_STATUS_COMMITTED = 0x400,
    OLETX_TRANSACTION_STATUS_HEURISTIC_ABORT = 0x800,
    OLETX_TRANSACTION_STATUS_HEURISTIC_COMMIT = 0x1000,
    OLETX_TRANSACTION_STATUS_HEURISTIC_DAMAGE = 0x2000,
    OLETX_TRANSACTION_STATUS_HEURISTIC_DANGER = 0x4000,
    OLETX_TRANSACTION_STATUS_FORCED_ABORT = 0x8000,
    OLETX_TRANSACTION_STATUS_FORCED_COMMIT = 0x10000,
    OLETX_TRANSACTION_STATUS_INDOUBT = 0x20000,
    OLETX_TRANSACTION_STATUS_CLOSED = 0x40000,
    OLETX_TRANSACTION_STATUS_OPEN = 0x3,
    OLETX_TRANSACTION_STATUS_NOTPREPARED = 0x7ffc3,
    OLETX_TRANSACTION_STATUS_ALL = 0x7ffff
}

internal enum OletxTransactionHeuristic : uint
{
    XACTHEURISTIC_ABORT = 1,
    XACTHEURISTIC_COMMIT = 2,
    XACTHEURISTIC_DAMAGE = 3,
    XACTHEURISTIC_DANGER = 4
}

internal enum OletxXactStat : int
{
    XACTSTAT_NONE = 0,
    XACTSTAT_OPENNORMAL = 0x1,
    XACTSTAT_OPENREFUSED = 0x2,
    XACTSTAT_PREPARING = 0x4,
    XACTSTAT_PREPARED = 0x8,
    XACTSTAT_PREPARERETAINING = 0x10,
    XACTSTAT_PREPARERETAINED = 0x20,
    XACTSTAT_COMMITTING = 0x40,
    XACTSTAT_COMMITRETAINING = 0x80,
    XACTSTAT_ABORTING = 0x100,
    XACTSTAT_ABORTED = 0x200,
    XACTSTAT_COMMITTED = 0x400,
    XACTSTAT_HEURISTIC_ABORT = 0x800,
    XACTSTAT_HEURISTIC_COMMIT = 0x1000,
    XACTSTAT_HEURISTIC_DAMAGE = 0x2000,
    XACTSTAT_HEURISTIC_DANGER = 0x4000,
    XACTSTAT_FORCED_ABORT = 0x8000,
    XACTSTAT_FORCED_COMMIT = 0x10000,
    XACTSTAT_INDOUBT = 0x20000,
    XACTSTAT_CLOSED = 0x40000,
    XACTSTAT_OPEN = 0x3,
    XACTSTAT_NOTPREPARED = 0x7ffc3,
    XACTSTAT_ALL = 0x7ffff
}
