/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class Comment
extends SimpleNodeConstructor {
    @Override
    public int getInstructionNameCode() {
        return 143;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.COMMENT;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Comment exp = new Comment();
        ExpressionTool.copyLocationInfo(this, exp);
        exp.setSelect(this.getSelect().copy(rebindings));
        return exp;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        String s2;
        String s22;
        if (this.getSelect() instanceof Literal && !(s22 = this.checkContent(s2 = ((Literal)this.getSelect()).getValue().getStringValue(), visitor.getStaticContext().makeEarlyEvaluationContext())).equals(s2)) {
            this.setSelect(new StringLiteral(s22));
        }
    }

    @Override
    public void processValue(CharSequence value, XPathContext context) throws XPathException {
        String comment = this.checkContent(value.toString(), context);
        Receiver out = context.getReceiver();
        out.comment(comment, this.getLocation(), 0);
    }

    @Override
    protected String checkContent(String comment, XPathContext context) throws XPathException {
        if (this.isXSLT()) {
            return Comment.checkContentXSLT(comment);
        }
        try {
            return Comment.checkContentXQuery(comment);
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.setLocation(this.getLocation());
            throw err;
        }
    }

    public static String checkContentXSLT(String comment) {
        int hh;
        while ((hh = comment.indexOf("--")) >= 0) {
            comment = comment.substring(0, hh + 1) + ' ' + comment.substring(hh + 1);
        }
        if (comment.length() > 0 && comment.charAt(comment.length() - 1) == '-') {
            comment = comment + ' ';
        }
        return comment;
    }

    public static String checkContentXQuery(String comment) throws XPathException {
        if (comment.contains("--")) {
            throw new XPathException("Invalid characters (--) in comment", "XQDY0072");
        }
        if (comment.length() > 0 && comment.charAt(comment.length() - 1) == '-') {
            throw new XPathException("Comment cannot end in '-'", "XQDY0072");
        }
        return comment;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("comment", this);
        String flags = "";
        if (this.isLocal()) {
            flags = flags + "l";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        this.getSelect().export(out);
        out.endElement();
    }
}

