/* Copyright 1992 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of NEC
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  NEC Corporation makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

/*
 * @(#) 102.1 $Id: canna.h,v 1.11 2003/09/25 07:24:54 aida_s Exp $
 */

#ifndef _CANNA_H_
#define _CANNA_H_

#include "cannaconf.h"
#include "ccompat.h"
#include <stdio.h>

#define CANNA_NEW_WCHAR_AWARE
#include <canna/RK.h>
#include <canna/jrkanji.h>

#define POINTERINT canna_intptr_t
#define exp(x) x

#if 0
#define USE_MALLOC_FOR_BIG_ARRAY
#endif

#define	WCHARSIZE	(sizeof(cannawc))

#define MBstowcs CANNA_mbstowcs
#define WCstombs CANNA_wcstombs

#include "sglobal.h"

#define XLookupKanji2			 IROHA_G300_XLookupKanji2
#define XKanjiControl2			 IROHA_G301_XKanjiControl2
#define XwcLookupKanji2			 IROHA_G425_XwcLookupKanji2
#define XwcKanjiControl2		 IROHA_G426_XwcKanjiControl2
#define FirstTime			 CANNA_G271_FirstTime

#define STROKE_LIMIT 500 /* ȥ³ڤ */

typedef unsigned char BYTE;

/*********************************************************************
 *                      wchar_t replace begin                        *
 *********************************************************************/
#ifdef wchar_t
# error "wchar_t is already defined"
#endif
#define wchar_t cannawc

/*
 * CANNALIBDIR  -- ƥΥޥե޻Ѵ
 *                 ơ֥뤬֤ǥ쥯ȥꡣ
 */

#ifndef CANNALIBDIR
#define CANNALIBDIR "/usr/lib/canna"
#endif

/* flags ξ */
#define CANNA_KANJIMODE_TABLE_SHARED	01
#define CANNA_KANJIMODE_EMPTY_MODE	02

/* func 軰 */
#define KEY_CALL  0
#define KEY_CHECK 1
#define KEY_SET   2

extern BYTE default_kmap[];

/* menuitem -- ˥塼ɽιܤơ֥ */

typedef struct _menuitem {
  int flag; /* 򸫤 */
  union {
    struct _menustruct *menu_next; /* ˥塼ؤΥݥ */
    int fnum;    /* ǽֹ */
    char *misc;  /* ¾(lisp Υܥʤ) */
  } u;
} menuitem;

#define MENU_SUSPEND 0 /* ޤޤäƤʤ(lisp Υܥ) */
#define MENU_MENU    1 /* ˥塼 */
#define MENU_FUNC    2 /* ǽֹ */

/* menustruct -- ˥塼򤷤빽¤ */

typedef struct _menustruct {
  int     nentries; /* ˥塼ιܤο */
  wchar_t **titles; /* ˥塼θФꥹ */
  wchar_t *titledata; /* ΥꥹȤμʸ */
  menuitem *body;   /* ˥塼() */
  int     modeid;   /* ˥塼Υ⡼ֹ */
  struct _menustruct *prev; /* Υ˥塼ؤΥݥ */
} menustruct;

typedef struct _menuinfo {
  menustruct *mstruct; /* ɤΥ˥塼 */
  int        curnum;   /* ʤ򤵤줿ֹϤǤ */
  struct _menuinfo *next;
} menuinfo;

/* defselection 줿طΰȤäƤ¤ */

typedef struct {
  wchar_t	**kigo_data;	/* ɽγǤ */
  wchar_t	*kigo_str;	/* ɽǤ */
  int		kigo_size;	/* Ǥο */
  int		kigo_mode;	/* ΤȤΥ⡼ */
} kigoIchiran;

typedef struct _selectinfo {
  kigoIchiran	*ichiran;	/* ɤΰ */
  int		curnum;		/* 򤵤줿ֹ */
  struct _selectinfo *next;
} selectinfo;

/* deldicinfo -- ñκݤɬפʼξ򤤤Ƥ¤ */

#define INDPHLENGTH 16 /* ΩǰĹʻĹ */

typedef struct _deldicinfo {
  wchar_t *name;
  wchar_t hcode[INDPHLENGTH];
} deldicinfo;
  
/*
 * glineinfo -- ɽΤǼƤι¤Ρ
 * 줾ΥФϰʲΰ̣ġ
 *
 * glkosu -- ιԤˤο
 * glhead -- ιԤƬ䤬kouhoinfoβܤ(0)
 * gllen  -- ιԤɽ뤿ʸĹ
 * gldata -- ιԤɽ뤿ʸؤΥݥ
 */

typedef struct {
  int glkosu;
  int glhead;
  int gllen;
  wchar_t *gldata;
} glineinfo;

/*
 * kouhoinfo -- ΤǼƤι¤
 * 줾ΥФϰʲΰ̣ġ
 *
 * khretsu -- θ䤬
 * khpoint -- θιԤΤʤǤΰ
 * khdata -- θʸؤΥݥ
 */

typedef struct {
  int khretsu;
  int khpoint;
  wchar_t *khdata;
} kouhoinfo;

#define ROMEBUFSIZE 	1024
#define	BANGOSIZE	2	/* γƸֹΥ */
#define	BANGOMAX   	9	/* κ */

#define	KIGOBANGOMAX   	16	/* κ */
#define GOBISUU		9

#define	ON		1
#define	OFF		0

#define	NG		-1

#define NO_CALLBACK     (canna_callback_t)0
#define NCALLBACK	4

#define	JISHU_HIRA	0
#define JISHU_ZEN_KATA	1
#define JISHU_HAN_KATA	2
#define JISHU_ZEN_ALPHA	3
#define JISHU_HAN_ALPHA	4
#define MAX_JISHU	5

#define  SENTOU        0x01
#define  HENKANSUMI    0x02
#define  SUPKEY        0x04
#define  GAIRAIGO      0x08
#define  STAYROMAJI    0x10

/* ñϿʻ */
#define MEISHI       0
#define KOYUMEISHI   1
#define DOSHI        2
#define KEIYOSHI     3
#define KEIYODOSHI   4
#define FUKUSHI      5
#define TANKANJI     6
#define SUSHI        7
#define RENTAISHI    8
#define SETSUZOKUSHI 9
#define SAHENMEISHI 10
#define MEISHIN     11
#define JINMEI      12
#define KOYUMEISHIN 13
#define GODAN       14
#define RAGYODOSHI  15
#define RAGYOGODAN  16
#define KAMISHIMO   17
#define KEIYOSHIY   18
#define KEIYOSHIN   19
#define KEIYODOSHIY 20
#define KEIYODOSHIN 21
#define FUKUSHIY    22
#define FUKUSHIN    23

/* identifier for each context structures */
#define CORE_CONTEXT       ((BYTE)0)
#define YOMI_CONTEXT       ((BYTE)1)
#define ICHIRAN_CONTEXT    ((BYTE)2)
#define FORICHIRAN_CONTEXT ((BYTE)3)
#define MOUNT_CONTEXT      ((BYTE)4)
#define TOUROKU_CONTEXT    ((BYTE)5)
#define TAN_CONTEXT	   ((BYTE)6)

typedef struct _coreContextRec {
  BYTE id;
  BYTE majorMode, minorMode;
  struct _kanjiMode *prevMode; /* Υ⡼ */
  struct _coreContextRec *next;
} coreContextRec, *coreContext;

typedef coreContext mode_context;

typedef struct  _yomiContextRec {
  /* core Ʊ */
  BYTE id;
  BYTE majorMode, minorMode;
  struct _kanjiMode *prevMode;	/* Υ⡼ */
  mode_context    next;

  struct _kanjiMode *curMode;
  struct _tanContextRec	 *left, *right;

  /* ޻Ѵط */
  struct RkRxDic *romdic;	/* ޻Ѵơ֥ */
  wchar_t   romaji_buffer[ROMEBUFSIZE];
  /* ޻Хåե rStartp, rEndp ΣĤΥǥåˤäƴ
   * 롣rStartp ϥʤѴǤʤä޻κǽʸؤΥǥ
   * ǤꡢrEndp Ͽ˥޻ϤˡǼ٤ 
   * romaji_buffer ΥǥåǤ롣Ϥ޻ϡ
   * romaji_buffer + rEndp ˳Ǽ졢Υ޻򥫥ʤѴ
   * ϡromaji_buffer + rStartp  rEndp - rStartp ХȤʸ
   * оݤȤʤ롣 */
  int		  rEndp, rStartp, rCurs; /* ޻ХåեΥݥ */
  wchar_t         kana_buffer[ROMEBUFSIZE];
  BYTE            rAttr[ROMEBUFSIZE], kAttr[ROMEBUFSIZE];
  int		  kEndp; /* ʥХåեκǸ򲡤ݥ */
  int             kRStartp, kCurs;

  /* ¾Υץ */
  BYTE            myMinorMode;  /* yomiContext ͭΥޥʥ⡼ */
  struct _kanjiMode *myEmptyMode;		/* empty ⡼ɤϤɤ줫 */
  long		  generalFlags;		/* see below */
  long		  savedFlags;		/* Υե饰ΰΥ */
  BYTE		  savedMinorMode;	/* ޥʥ⡼ɤΥ */
  BYTE		  allowedChars;		/* see jrkanji.h */
  BYTE		  henkanInhibition;	/* see below */
  int             cursup;		/* ʤɤλ˻Ȥ */
#define SUSPCHARBIAS 100
  int             n_susp_chars;

/* from henkanContext */
  /* ʴѴط */
  int            context;
  int		 kouhoCount;	/*  henkanNext Ϣ³Ʋ줿 */
  wchar_t        echo_buffer[ROMEBUFSIZE];
  wchar_t        **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  int            curbun;     /* ʸ */
  int		 curIkouho;  /* ȸ */
  int            nbunsetsu;  /* ʸο */

/* ifdef MEASURE_TIME */
  long		 proctime;   /* (ѴǷ¬) */
  long		 rktime;     /* (RKˤ) */
/* endif MEASURE_TIME */
/* end of from henkanContext */

/* ༡ƥȤ */
  int		 ye, ys, status;
/* ༡ƥȤ(ޤ) */
  int		 cStartp, cRStartp; /* ༡ɤߤȤƻĤäƤʬ */

/* 拾ƥȤ */
  BYTE           inhibition;
  BYTE           jishu_kc, jishu_case;
  int            jishu_kEndp, jishu_rEndp;
  short          rmark;
/* 拾ƥȤ(ޤ) */

/* adjustContext  */
  int kanjilen, bunlen;           /* ʬʸĹ */
/* adjustContext (ޤ) */
  struct _kanjiMode *tanMode; /* ñΤȤΥ⡼ */
  int tanMinorMode;     /*                    */

  /* ѿ */
  int		  last_rule;		/* ΥѴ˻Ȥ줿롼 */
  wchar_t	  *retbuf, *retbufp;
  int		  retbufsize;
  short           pmark, cmark; /* ΥޡȺΥޡ */
  BYTE            englishtype;  /* Ѹ쥿(ʲ򸫤) */
} yomiContextRec, *yomiContext;

/* for generalFlags */
#define CANNA_YOMI_MODE_SAVED		0x01L /* savedFlags ˤȤʤ */

#define CANNA_YOMI_BREAK_ROMAN		0x01L
#define CANNA_YOMI_CHIKUJI_MODE		0x02L
#define CANNA_YOMI_CHGMODE_INHIBITTED	0x04L
#define CANNA_YOMI_END_IF_KAKUTEI	0x08L
#define CANNA_YOMI_DELETE_DONT_QUIT	0x10L

#define CANNA_YOMI_IGNORE_USERSYMBOLS	0x20L
#define CANNA_YOMI_IGNORE_HENKANKEY	0x40L

#define CANNA_YOMI_BASE_CHIKUJI		0x80L /* ༡ */

/* for generalFlags also used in savedFlags */

/* ʲ ATTRFUNCS ˥ޥӥåȤ defmode °ȤƻȤ */
#define CANNA_YOMI_KAKUTEI		0x0100L
#define CANNA_YOMI_HENKAN		0x0200L
#define CANNA_YOMI_ZENKAKU		0x0400L
#define CANNA_YOMI_HANKAKU		0x0800L /* ºݤȾ */
#define CANNA_YOMI_HIRAGANA		0x1000L
#define CANNA_YOMI_KATAKANA		0x2000L
#define CANNA_YOMI_ROMAJI		0x4000L
#define CANNA_YOMI_JISHUFUNCS		0x7c00L
#define CANNA_YOMI_ATTRFUNCS		0x7f00L

#define CANNA_YOMI_BASE_HANKAKU		0x8000L /* Ⱦ */

/* kind of allowed input keys */
#define CANNA_YOMI_INHIBIT_NONE		0
#define CANNA_YOMI_INHIBIT_HENKAN	1
#define CANNA_YOMI_INHIBIT_JISHU	2
#define CANNA_YOMI_INHIBIT_ASHEX	4
#define CANNA_YOMI_INHIBIT_ASBUSHU	8
#define CANNA_YOMI_INHIBIT_ALL		15

/* ΤΥե饰 */
#define NUMBERING 			1
#define CHARINSERT			2

#define CANNA_JISHU_UPPER		1
#define CANNA_JISHU_LOWER		2
#define CANNA_JISHU_CAPITALIZE		3
#define CANNA_JISHU_MAX_CASE		4

/* englishtype */
#define CANNA_ENG_KANA			0 /* ̾뤳 */
#define CANNA_ENG_ENG1			1
#define CANNA_ENG_ENG2			2 /* ξü˶äƤ */
#define CANNA_ENG_NO			3

/* yc->status Υե饰(༡) */

#define	CHIKUJI_ON_BUNSETSU		0x0001 /* ʸˤ */
#define	CHIKUJI_OVERWRAP		0x0002 /* ʸᤫɤ߾֡ */
#define	CHIKUJI_NULL_STATUS	        0 /* Τä */

/* yc Ȥ⡼ɤζ(ͥ) */

#define adjustp(yc) (0< (yc)->bunlen)
#define jishup(yc) (0 < (yc)->jishu_kEndp)
#define chikujip(yc) ((yc)->generalFlags & CANNA_YOMI_CHIKUJI_MODE)
#define henkanp(yc) (0 < (yc)->nbunsetsu)

#define chikujiyomiremain(yc) ((yc)->cStartp < (yc)->kEndp)

typedef struct _ichiranContextRec {
  BYTE id;
  BYTE majorMode, minorMode;
  struct _kanjiMode *prevMode;	/* Υ⡼ */
  mode_context    next;

  int            svIkouho;   /* ȸȤäƤ(ɽ) */
  int            *curIkouho; /* ȸ */
  int            nIkouho;    /* ο(ɽ) */
  int		 tooSmall;   /* ƸФʤե饰 */
  int            curIchar;   /* ̤ʸ󤢤ñϿñϤ
    							Ƭʸΰ */
  BYTE           inhibit;
  BYTE           flags;	     /* 򸫤Ƥ */
  wchar_t        **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  wchar_t        *glinebufp; /* ΤԤɽ뤿ʸ
				ؤΥݥ */
  kouhoinfo      *kouhoifp;  /* طξǼƤ¤
				ؤΥݥ */
  glineinfo      *glineifp;  /* طξǼƤ¤
				ؤΥݥ */
} ichiranContextRec, *ichiranContext;

/* ե饰ΰ̣ */
#define ICHIRAN_ALLOW_CALLBACK 1 /* Хå򤷤Ƥɤ */
#define ICHIRAN_STAY_LONG    0x02 /* ֤ȴ */
#define ICHIRAN_NEXT_EXIT    0x04 /*  quit ȴ */


typedef struct _foirchiranContextRec {
  BYTE id;
  BYTE majorMode, minorMode;
  struct _kanjiMode *prevMode;	/* Υ⡼ */
  mode_context    next;

  int            curIkouho;  /* ȸ */
  wchar_t        **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  menustruct     *table;  /* ʸȴؿΥơ֥ */
  int            *prevcurp;  /* Υȸ */
} forichiranContextRec, *forichiranContext;

typedef struct _mountContextRec {
  BYTE id;
  BYTE majorMode, minorMode;
  struct _kanjiMode *prevMode;	/* Υ⡼ */
  mode_context    next;

  BYTE            *mountOldStatus; /* ޥȤƤ뤫ʤ */
  BYTE            *mountNewStatus; /* ޥȤƤ뤫ʤ */
  char            **mountList;   /* ޥȲǽʼΰ */
  int            curIkouho;     /* ȸ */
} mountContextRec, *mountContext;

typedef struct _tourokuContextRec {
  BYTE id;
  BYTE majorMode, minorMode;
  struct _kanjiMode *prevMode;	/* Υ⡼ */
  mode_context    next;

  wchar_t        genbuf[ROMEBUFSIZE];
  wchar_t        qbuf[ROMEBUFSIZE];
  wchar_t        tango_buffer[ROMEBUFSIZE];
  int            tango_len;  /* ñϿñʸĹ */
  wchar_t        yomi_buffer[ROMEBUFSIZE];
  int            yomi_len;   /* ñϿɤߤʸĹ */
  int            curHinshi;  /* ʻ */
  int            workDic;    /* Ѥμ */
  deldicinfo     *workDic2;  /* ñǽʼ */
  int            nworkDic2;  /* ñǽʼο */
  deldicinfo     *workDic3;  /* ñ뼭 */
  int            nworkDic3;  /* ñ뼭ο */
  struct dicname *newDic;    /* ɲä뼭 */
  wchar_t        hcode[INDPHLENGTH];  /* ñϿʻ */
  int            katsuyou;   /* ñϿưγѷ */
  wchar_t        **udic;     /* ñϿǤ뼭 (̾) */
  int            nudic;      /* ñϿǤ뼭ο */
  int            delContext; /* ñǣĤμޥȤ */
} tourokuContextRec, *tourokuContext;

typedef struct _tanContextRec {
  BYTE id;
  BYTE majorMode, minorMode;
  struct _kanjiMode *prevMode;	/* Υ⡼ */
  mode_context    next;

  struct _kanjiMode *curMode;
  struct _tanContextRec	 *left, *right;

  struct RkRxDic *romdic;	/* ޻Ѵơ֥ */
  BYTE            myMinorMode;  /* yomiContext ͭΥޥʥ⡼ */
  struct _kanjiMode *myEmptyMode;		/* empty ⡼ɤϤɤ줫 */
  long generalFlags, savedFlags; /* yomiContext Υԡ */
  BYTE		  savedMinorMode;	/* ޥʥ⡼ɤΥ */
  BYTE		  allowedChars;		/* see jrkanji.h */
  BYTE		  henkanInhibition;	/* see below */

  wchar_t *kanji, *yomi, *roma;
  BYTE *kAttr, *rAttr;
} tanContextRec, *tanContext;

struct moreTodo {
  BYTE          todo; /* äȤΡ򼨤 */
  BYTE          fnum; /* ؿֹ档ʤ鼡ʸǼ뤳Ȥ򤹤 */
  int		ch;   /* ʸ */
};

/* ⡼̾Ǽǡη */

struct ModeNameRecs {
  int           alloc;
  wchar_t       *name;
};

/* ֹΥѥ졼ΥǥեȤ */

#define DEFAULTINDEXSEPARATOR     '.'

/*
   wcKanjiAttribute for internal use
 */

typedef struct {
  wcKanjiAttribute u;
  int len;
  char *sp, *ep;
} wcKanjiAttributeInternal;

/* 

  uiContext ϥ޻ѴʴѴ˻Ȥ빽¤ΤǤ롣
  XLookupKanjiString ʤɤˤѴϡɥʬΥ줿ʣ
  ϥݡȤбƤΤǡΥ޻ξ䡢ʴѴ
  ͻҤʤɤ򤽤줾ΥɥʬΥݻƤʤФ
  ʤι¤ΤϤΤ˻Ȥ빽¤ΤǤ롣
 
  ¤ΤΥФɤΤ褦ʤΤ뤫ϡ򻲾Ȥ뤳
 
 */

typedef struct _uiContext {

  /* XLookupKanjiStringΥѥ᥿ */
  wchar_t        *buffer_return;
  int            n_buffer;
  wcKanjiStatus    *kanji_status_return;

  /* XLookupKanjiStringͤǤʸĹ */
  int		 nbytes;

  /* 饯 */
  int ch;

  /* ߥХǡ */
  int		 contextCache;	 /* Ѵƥȥå */
  struct _kanjiMode *current_mode;
  BYTE		 majorMode, minorMode;	 /* ľΤ */

  short		 curkigo;	 /* ȵ() */
  char           currussia;	 /* ȵ(ʸ) */
  char           curgreek;	 /* ȵ(ꥷʸ) */
  char           curkeisen;	 /* ȵ() */
  short          curbushu;       /* ̾ */
  int            ncolumns;	 /* ԤΥλѤ */
  wchar_t        genbuf[ROMEBUFSIZE];	/* ѥХåե */
  short          strokecounter;  /* ȥΥ
				    ޻⡼ɤǥꥢ */
  wcKanjiAttributeInternal *attr;

  /* ꥹȥХåϢ */
  char           *client_data;   /* ץꥱѥǡ */
  int            (*list_func) pro((char *, int, wchar_t **, int, int *));
  jrEUCListCallbackStruct elistcb; /* EUCξμ(wc) */
                 /* ꥹȥХåؿ */
  /* ¾ */
  char		 flags;		 /* 򸫤Ƥ */
  char		 status;	 /* ɤΤ褦ʾ֤֤äΤ򼨤
				    Υ⡼ɤȤơ
				     
				     λ
				     
				     ¾
				    롣(򸫤) */

  /* Хå */
  struct callback *cb;

  /* äȤ뤳ȤȤ¤ */
  struct moreTodo more;

  /* åȥ */
  menustruct *prevMenu;

  /* ƥ˥塼Ф줿ֹϿƤ¤ΤؤΥݥ */
  menuinfo *minfo;

  /* ưФ줿ֹϿƤ¤ΤؤΥݥ */
  selectinfo *selinfo;

  /* ֥ƥȤؤΥ */
  mode_context   modec;		/* ˤĤʤͽ */
} uiContextRec, *uiContext;

/* uiContext  flags ΥӥåȤΰ̣ */
#define PLEASE_CLEAR_GLINE	1	/* GLine äƤ */
#define PCG_RECOGNIZED		2	/* GLine 򼡤Ͼäޤ */
#define MULTI_SEQUENCE_EXECUTED	4	/* äޥ󥹤Ԥ줿 */

#define EVERYTIME_CALLBACK	0
#define EXIT_CALLBACK		1
#define QUIT_CALLBACK		2
#define AUX_CALLBACK		3

/* 
 * ʴѴΤ͡ʥޥåץơ֥ 
 * ޥåץơ֥ϽؿؤΥݥ󥿤ȤʤäƤ롣
 */

struct funccfunc {
  BYTE funcid;
  int (*cfunc) pro((struct _uiContext *));
};

typedef struct _kanjiMode {
  int (*func) pro((struct _uiContext *, struct _kanjiMode *, int, int, int));
  BYTE *keytbl;
  int flags;			/* 򸫤 */
  struct funccfunc *ftbl;
} *KanjiMode, KanjiModeRec;

struct callback {
  int (*func[NCALLBACK]) pro((struct _uiContext *, int, mode_context));
  mode_context    env;
  struct callback *next;
};

/* ޻Ѵơ֥ */
     
extern struct RkRxDic *romajidic;
extern struct RkRxDic *RkwOpenRoma pro((char *));

/*
 * ̾Ƥѿ
 */

struct dicname {
  struct dicname *next;
  char *name;
  int dictype;
  unsigned long dicflag;
};

/* dictype ˤϰʲΤ줫 */
#define DIC_PLAIN 0     /* ̾ */
#define DIC_USER  1     /* ñϿѼ */
#define DIC_BUSHU 2     /* ѴѼ */
#define DIC_GRAMMAR 3   /* ʸˡ */
#define DIC_RENGO 4     /* Ϣؽ */
#define DIC_KATAKANA 5  /* ʳؽ */
#define DIC_HIRAGANA 6  /* Ҥ餬ʳؽ */

/* dicflag ˤϰʲΤ줫 */
#define DIC_NOT_MOUNTED  0
#define DIC_MOUNTED      1
#define DIC_MOUNT_FAILED 2

extern struct dicname *kanjidicnames;

/*
 * 顼ΥåƤѿ
 */

extern char *jrKanjiError;

/*
 * ǥХʸɽ뤫ɤΥե饰
 */

extern iroha_debug;

/*
 * 󥹤ȯ褦ʥ
 */

#define IrohaFunctionKey(key) \
  ((0x80 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0x8b) || \
   (0x90 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0x9b) || \
   (0xe0 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0xff) )

/* selectOne ǥХåȼɤɽޥ */

#define WITHOUT_LIST_CALLBACK 0
#define WITH_LIST_CALLBACK    1

/*
 * Rk ؿȥ졼뤿̾ν񤭴
 */

#ifdef DEBUG
#include "traceRK.h"
#endif /* DEBUG */

/*
 * ǥХåѤΥޥ
 */

#ifdef DEBUG
#define debug_message(fmt, x, y, z)	dbg_msg(fmt, x, y, z)
#else /* !DEBUG */
#define debug_message(fmt, x, y, z)
#endif /* !DEBUG */

/*
 * malloc ΥǥХ
 */

#ifdef DEBUG_ALLOC
extern char *debug_malloc pro((int));
extern int fail_malloc;
#define malloc(n) debug_malloc(n)
#endif /* DEBUG_MALLOC */

/*
 * ⡼ɤ빽¤
 */

typedef struct {
  char           *romaji_table; /* ޻Ѵơ֥̾(EUC) */
  struct RkRxDic *romdic;	 /* ޻¤ */
  int             romdic_owner;  /* ޻ʬOpen */
  long            flags;	 /* flags for yomiContext->generalFlags */
  KanjiMode       emode;	 /* current_mode 빽¤ */
} newmode;

/* ޻Ѵ­륭ʸѴơ֥ */

typedef struct {
  wchar_t	key;		/*  */
  wchar_t       xkey;
  int		groupid;	/* 롼id */
  int           ncand;          /* ο */
  wchar_t       **cand;         /*  */
  wchar_t	*fullword;	/*  (1@2@...n@@) */
#ifdef WIN_CANLISP
  int		fullwordsize;	/* sizeof fullword by wchar_t unit */
#endif
} keySupplement;

#define MAX_KEY_SUP 64

#define HEX_USUAL     0
#define HEX_IMMEDIATE 1

#define ModeInfoStyleIsString		0
#define ModeInfoStyleIsNumeric		1
#define ModeInfoStyleIsExtendedNumeric	2
#define ModeInfoStyleIsBaseNumeric      3
#define MaxModeInfoStyle                ModeInfoStyleIsBaseNumeric

#define killmenu(d) ((d)->prevMenu = (menustruct *)0)
#define	defineEnd(d) killmenu(d)
#define	deleteEnd(d) killmenu(d)

/* defmodedefselectiondefmenu Ѥι¤ */

typedef struct _extra_func {
  int  		fnum;		/* ؿֹ */
  int		keyword;	/* ⡼ɤ줿 */
  wchar_t	*display_name;	/* ⡼ɽ̾ */
  union {
    newmode 	*modeptr;	/* defmode б빽¤ */
    kigoIchiran	*kigoptr;	/* defselection б빽¤ */
    menustruct	*menuptr;	/* defmenu б빽¤ */
  } u;
#ifdef BINARY_CUSTOM
  int           mid;
  char          *symname;
#endif
  struct _extra_func *next;
} extraFunc;

#define EXTRA_FUNC_DEFMODE	1
#define EXTRA_FUNC_DEFSELECTION	2
#define EXTRA_FUNC_DEFMENU	3

#define tanbunMode(d, tan) /* tanContext Ϣ⡼ɤؤΰܹ */ \
  { extern KanjiModeRec tankouho_mode; (d)->current_mode = &tankouho_mode; \
    (d)->modec = (mode_context)(tan); currentModeInfo(d); }

#define freeForIchiranContext(fc) free((char *)fc)
#define freeIchiranContext(ic) free((char *)ic)
#define freeYomiContext(yc) free((char *)yc)
#define freeCoreContext(cc) free((char *)cc)

#ifndef DICHOME
#define DICHOME "/usr/lib/canna/dic"
#endif

#define DEFAULT_CANNA_SERVER_NAME "cannaserver"

#ifndef	_UTIL_FUNCTIONS_DEF_

#define	_UTIL_FUNCTIONS_DEF_

/* ʤΥСĴ٤ */
#define canna_version(majv, minv) ((majv) * 1024 + (minv))

/* 褯ڥߥΤǥѥˤҤä褦 */
extern RkwGoto pro((char *, int));

/* storing customize configuration to the following structure. */
struct CannaConfig { /* ʲΥȤϥʤɤ˵ҤȤʤɤ
			Ѥá! ƬˤĤƤΤϥåȿž
			Ƥ뤳Ȥɽ */
  int CannaVersion;  /* (ߴ) ʤΥС */
  int kouho_threshold; /* Ѵ򲿲ǤĤȰФ뤫 */
  int strokelimit;  /* (ߴ) ȥե٥åȤǤ */
  int indexSeparator; /* (ߴ) ΥǥåΥѥ졼 */
  BYTE ReverseWidely; /* ȿžΰ򹭤Ȥ       */
  BYTE chikuji;       /* ༡ưѴ             */
  BYTE Gakushu;       /* ؽ뤫ɤ         */
  BYTE CursorWrap;    /* üǱǺüعԤ     */
  BYTE SelectDirect;  /* ǰȴ */
  BYTE HexkeySelect;  /* (ߴ) 16ʿǤ */
  BYTE BunsetsuKugiri; /* Ѵʸ֤˶  */
  BYTE ChBasedMove;   /* !޻Ѵñ̤Υư   */
  BYTE ReverseWord;   /* (ߴ) Ǹȿž */
  BYTE QuitIchiranIfEnd; /* ǰĤ */
  BYTE kakuteiIfEndOfBunsetsu; /* ʸǱưǳꤹ */
  BYTE stayAfterValidate; /* !弡ʸذư */
  BYTE BreakIntoRoman;    /* BSǥ޻᤹ */
  BYTE grammaticalQuestion; /* (ߴ) ñϿʸˡŪ򤹤 */
  BYTE forceKana;           /* Isn't this used? */
  BYTE kCount;        /* (ߴ) 䤬ܤɽ */
  BYTE LearnNumericalType;  /* Isn't this used? */
  BYTE BackspaceBehavesAsQuit; /* ༡ưѴ BS Τɤߤ᤹ */
  BYTE iListCB;       /* (ߴ) ꥹȥХåػߤ */
  BYTE keepCursorPosition;  /* !ѴBSǸ֤˰ư */
  BYTE abandonIllegalPhono; /* ޻Ѵ˻ȤʤΤƤ */
  BYTE hexCharacterDefiningStyle; /* Isn't this used? */
  BYTE kojin;         /* Ŀͳؽ */
  BYTE indexHankaku;  /* (ߴ) ΥǥåȾѤˤ */
  BYTE allowNextInput; /* ɽϤǽˤ */
  BYTE doKatakanaGakushu; /* Isn't this used? */
  BYTE doHiraganaGakushu; /* Isn't this used? */ 
  BYTE ChikujiContinue; /* ༡ưѴϤǴѴʬꤷʤ */
  BYTE RenbunContinue;  /* ϢʸѴϤǴѴʬꤷʤ */
  BYTE MojishuContinue; /* ѴϤǴѴʬꤷʤ */
  BYTE chikujiRealBackspace; /* ༡ưѴBSɬʸõ */
  BYTE ignore_case;   /* ʸʸ̤ʤ */
  BYTE romaji_yuusen; /* ޻Ѵͥ褹 */
  BYTE auto_sync;     /* Ū˼᤹ */
  BYTE quickly_escape; /* (ߴ) ɽ¨¤˰ȴ */
  BYTE InhibitHankakuKana; /* Ⱦѥʤζػ */
  BYTE code_input;    /* (0: jis, 1: sjis, 2: ) */
  BYTE DelayConnect;  /* ˤ˥Ф³ʤ */
};

#define CANNA_CODE_JIS   0
#define CANNA_CODE_SJIS  1
#define CANNA_CODE_KUTEN 2
#define CANNA_MAX_CODE   3

extern struct CannaConfig cannaconf;
extern void InitCannaConfig pro((struct CannaConfig *));

typedef int (* canna_callback_t) pro((uiContext, int, mode_context));

extern void makeGLineMessage pro((uiContext, wchar_t *, int));
extern void makeGLineMessageFromStrings pro((uiContext, char *));
extern newmode *findExtraKanjiMode pro((int));
extern setWStrings pro((wchar_t **, char **, int));
extern WStrlen pro((wchar_t *));
extern wchar_t *WStrcat pro((wchar_t *, wchar_t *));
extern wchar_t *WStrcpy pro((wchar_t *, wchar_t *));
extern wchar_t *WStrncpy pro((wchar_t *, wchar_t *, int));
extern WStrncmp pro((wchar_t *, wchar_t *, int));
extern wchar_t *WString pro((char *));
#ifndef NO_EXTEND_MENU
extern prevMenuIfExist pro((uiContext));
extern showmenu pro((uiContext, menustruct *));
#endif
extern yomiContext
  newYomiContext pro((wchar_t *, int, int, int, int, int)),
  GetKanjiString pro((uiContext, wchar_t *, int, int, int, int, int,
		      canna_callback_t, canna_callback_t, canna_callback_t));
extern void restoreFlags pro((yomiContext));
extern void kPos2rPos pro((yomiContext, int, int, int *, int *));
extern void makeKanjiStatusReturn pro((uiContext, yomiContext));
extern wchar_t key2wchar pro((int, int *));
extern struct bukRec *internContext
  pro((unsigned int, unsigned int, uiContext));
extern void freeRomeStruct pro((uiContext));
extern void rmContext pro((unsigned int, unsigned int));
extern struct callback *pushCallback
  pro((uiContext, mode_context,
       canna_callback_t, canna_callback_t,
       canna_callback_t, canna_callback_t));
extern void popCallback pro((uiContext));
extern void makeYomiReturnStruct pro((uiContext));
extern void moveToChikujiTanMode pro((uiContext));
extern void moveToChikujiYomiMode pro((uiContext));
extern void makeGLineMessageFromString pro((uiContext, char *));
extern void addWarningMesg pro((char *));
extern int prepareHenkanMode pro((uiContext));
extern void makeAllContextToBeClosed pro((int));
extern void CannaBeep pro((void));
#ifndef NO_EXTEND_MENU
extern void freeAllMenuInfo pro((menuinfo *));
extern void freeMenu pro((menustruct *));
#endif
extern void restoreDefaultKeymaps pro((void));
#ifndef NO_EXTEND_MENU
extern void finExtMenu pro((void));
#endif
extern void freeIchiranBuf pro((ichiranContext));
extern exp(char *) RkwGetServerName pro((void));
extern void popForIchiranMode pro((uiContext));
extern void clisp_main pro((void));
extern void clisp_fin pro((void));
extern void popYomiMode pro((uiContext));
extern void freeTanContext pro((tanContext));
extern void enterJishuMode pro((uiContext, yomiContext));
extern void leaveJishuMode pro((uiContext, yomiContext));
extern void finishTanKakutei pro((uiContext));
extern void removeKana pro((uiContext, yomiContext, int, int));
extern void clearHenkanContext pro((yomiContext));
extern void doMuhenkan pro((uiContext, yomiContext));
extern void removeCurrentBunsetsu pro((uiContext, tanContext));
extern int uiUtilIchiranTooSmall pro((uiContext, int, mode_context));
extern int dicTourokuHinshiDelivery pro((uiContext));
extern int uuTTangoQuitCatch pro((uiContext, int, mode_context));
extern void freeAndPopTouroku pro((uiContext));
extern void popMountMode pro((uiContext));
extern void freeDic pro((tourokuContext));

/* for VC++ 4.0, by kon */
extern int doFunc pro((uiContext, int));
extern int _doFunc pro((uiContext, int));
extern int _afterDoFunc pro((uiContext, int));
extern int alphaMode pro((uiContext));
extern void jrKanjiPipeError pro((void));
extern int NoMoreMemory pro((void));
extern int WCinit pro((void));
extern int WStringOpen pro((void));
extern void WStringClose pro((void));
extern int WStrcmp pro((wchar_t *, wchar_t *));
extern int WSfree pro((wchar_t *));
extern void initModeNames pro((void));
extern int initKeyTables pro((void));
#ifdef BINARY_CUSTOM
extern int binparse pro((void));
#else
extern void parse pro((void));
#endif
extern int initIchiran pro((void));
extern int RomkanaInit pro((void));
extern void RomkanaFin pro((void));
extern int KanjiInit pro((void));
extern int KanjiFin pro((void));
extern void resetModeNames pro((void));
extern int escapeToBasicStat pro((uiContext, int));
extern void EmptyBaseModeInfo pro((uiContext, yomiContext));
extern void GlineClear pro((uiContext));
extern void currentModeInfo pro((uiContext));
extern int queryMode pro((uiContext, wchar_t *));
extern int RkSetServerName pro((char *));
extern int parse_string pro((char *));
extern void RomajiStoreYomi pro((uiContext, wchar_t *, wchar_t *));
extern int WWhatGPlain pro((wchar_t));
extern int WIsG0 pro((wchar_t)), WIsG1 pro((wchar_t));
extern int WIsG2 pro((wchar_t)), WIsG3 pro((wchar_t));
extern int XwcKanjiControl2
  pro((unsigned int, unsigned int, unsigned int, BYTE *));
extern int XKanjiControl2
  pro((unsigned int, unsigned int, unsigned int, BYTE *));
extern int XwcLookupKanji2 pro((unsigned int, unsigned int, wchar_t *, int,
                                int, int, wcKanjiStatus *));
extern int NothingChangedWithBeep pro((uiContext));
extern int searchfunc pro((uiContext, KanjiMode, int, int, int));
extern int initRomeStruct pro((uiContext, int));
/* extern int kanjiControl pro((int, uiContext, caddr_t)); */
extern int getBaseMode pro((yomiContext));
extern int RkwMapPhonogram
  pro((struct RkRxDic *, wchar_t *, int, wchar_t *, int, wchar_t, int,
       int *, int *, int *, int *));
extern int RkMapPhonogram
  pro((struct RkRxDic *, unsigned char *, int, unsigned char *, int,
       unsigned, int,
       int *, int *, int *, int *));
extern RkMapRoma
  pro((struct RkRxDic *, unsigned char *, int, unsigned char *, int,
       int, int *));
extern int RkCvtRoma
  pro((struct RkRxDic *, unsigned char *, int, unsigned char *, int,
       unsigned));
extern int RkwCvtRoma
  pro((struct RkRxDic *, wchar_t *, int, wchar_t *, int, int));
extern int exitJishu pro((uiContext));
extern RomajiFlushYomi pro((uiContext, wchar_t *, int));
extern void generalReplace
  pro((wchar_t *, BYTE *, int *, int *, int *, int, wchar_t *, int, int));
extern ChikujiSubstYomi pro((uiContext));
extern TanMuhenkan pro((uiContext));
extern CANNA_mbstowcs pro((wchar_t *, char *, int));
extern CANNA_wcstombs pro((char *, wchar_t *, int));
extern makeRkError pro((uiContext, char *));
extern void moveStrings pro((wchar_t *, BYTE *, int, int, int));
extern TanBackwardBunsetsu pro((uiContext));
extern TbBackward pro((uiContext));
extern NothingChanged pro((uiContext));
extern TbEndOfLine pro((uiContext));
extern TanForwardBunsetsu pro((uiContext));
extern TbForward pro((uiContext));
extern TbBeginningOfLine pro((uiContext));
extern tanMuhenkan pro((uiContext, int));
extern extractTanString pro((tanContext, wchar_t *, wchar_t *));
extern extractTanYomi pro((tanContext, wchar_t *, wchar_t *));
extern extractTanRomaji pro((tanContext, wchar_t *, wchar_t *));
extern leaveAdjustMode pro((uiContext, yomiContext));
extern wchar_t *WStraddbcpy pro((wchar_t *, wchar_t *, int));
extern YomiExit pro((uiContext, int));
extern void clearYomiContext pro((yomiContext));
extern abandonContext pro((uiContext, yomiContext));
extern void RomajiClearYomi pro((uiContext));
extern RkCvtEuc pro((unsigned char *, int, unsigned char *, int));
extern RkCvtNone pro((unsigned char *, int, unsigned char *, int));
extern selectOne
  pro((uiContext, wchar_t **, int *, int, int, unsigned, int, int,
       canna_callback_t, canna_callback_t, canna_callback_t,canna_callback_t));
extern void makeGlineStatus pro((uiContext));
extern YomiMark pro((uiContext));
extern doHenkan pro((uiContext, int, wchar_t *));
extern tanKouhoIchiran pro((uiContext, int));
extern EmptyBaseKana pro((uiContext));
extern EmptyBaseKakutei pro((uiContext));
extern EmptyBaseHenkan pro((uiContext));
extern WToupper pro((wchar_t));
extern WTolower pro((wchar_t));
extern TanKakutei pro((uiContext));
extern Yomisearchfunc pro((uiContext, KanjiMode, int, int, int));
extern CNvW2E pro((wchar_t *, int, char *, int));
extern void initKigoTable pro((void));
extern NothingForGLine pro((uiContext));
extern NothingForGLineWithBeep pro((uiContext));
extern void echostrClear pro((uiContext));
extern void freeGetIchiranList pro((wchar_t **));
extern TanKouhoIchiran pro((uiContext));
extern GLineNGReturn pro((uiContext));
extern GLineNGReturnFI pro((uiContext));
extern appendTan2Yomi pro((tanContext, yomiContext));
extern confirmContext pro((uiContext, yomiContext));
extern ChikujiTanDeletePrevious pro((uiContext));
extern YomiKakutei pro((uiContext));
extern YomiInsert pro((uiContext));
extern cutOffLeftSide pro((uiContext, yomiContext, int));
extern enterAdjustMode pro((uiContext, yomiContext));
extern TanNextKouho pro((uiContext));
extern TanPreviousKouho pro((uiContext));
extern TanBeginningOfBunsetsu pro((uiContext));
extern TanEndOfBunsetsu pro((uiContext));
extern TanDeletePrevious pro((uiContext));
extern TanBubunMuhenkan pro((uiContext));
extern xString pro((wchar_t *, int, wchar_t *, wchar_t *));
extern KanaDeletePrevious pro((uiContext));
extern findSup pro((wchar_t));
extern selectKeysup pro((uiContext, yomiContext, int));
extern containUnconvertedKey pro((yomiContext));
extern CYsearchfunc pro((uiContext, KanjiMode, int, int, int));
extern TanBubunKakutei pro((uiContext));
extern TanZenkaku pro((uiContext));
extern TanHankaku pro((uiContext));
extern TanHiragana pro((uiContext));
extern TanKatakana pro((uiContext));
extern TanRomaji pro((uiContext));
extern TanUpper pro((uiContext));
extern TanCapitalize pro((uiContext));
extern TanPrintBunpou pro((uiContext));
extern TanNop pro((uiContext));
extern YomiQuotedInsert pro((uiContext));
extern AlphaMode pro((uiContext));
extern HenkanNyuryokuMode pro((uiContext));
extern KigoIchiran pro((uiContext));
extern UiUtilMode pro((uiContext));
extern EmptyBaseHira pro((uiContext));
extern EmptyBaseKata pro((uiContext));
extern EmptyBaseEisu pro((uiContext));
extern EmptyBaseZen pro((uiContext));
extern EmptyBaseHan pro((uiContext));
extern YomiBaseHiraKataToggle pro((uiContext));
extern YomiBaseZenHanToggle pro((uiContext));
extern YomiBaseKanaEisuToggle pro((uiContext));
extern YomiBaseKakuteiHenkanToggle pro((uiContext));
extern YomiBaseRotateForw pro((uiContext));
extern YomiBaseRotateBack pro((uiContext));
extern DoFuncSequence pro((uiContext));
extern YomiModeBackup pro((uiContext));
extern UseOtherKeymap pro((uiContext));
extern JapaneseMode pro((uiContext));
extern void ichiranFin pro((uiContext));
extern IchiranForwardKouho pro((uiContext));
extern IchiranBackwardKouho pro((uiContext));
extern IchiranNextKouhoretsu pro((uiContext));
extern IchiranPreviousKouhoretsu pro((uiContext));
extern IchiranBeginningOfKouho pro((uiContext));
extern IchiranEndOfKouho pro((uiContext));
extern IchiranQuit pro((uiContext));
extern IchiranNop pro((uiContext));
extern RkwCvtNone pro((wchar_t *, int, wchar_t *, int));
extern RkwSetAppName pro((int, char *));
extern void close_engine pro((void));
extern char *KanjiInitError pro((void));
extern void prepare_autodic pro((void));
extern int doKakutei
 pro((uiContext, tanContext, tanContext, wchar_t *, wchar_t *, yomiContext *));
extern int EUCListCallback pro((char *, int, wchar_t **, int, int *));
#if SUPPORT_OLD_WCHAR
extern int owcListCallback pro((char *, int, wchar_t **, int, int *));
#endif

#endif /* _UTIL_FUNCTIONS_DEF_ */

#ifndef wchar_t
# error "wchar_t is already undefined"
#endif
#undef wchar_t
/*********************************************************************
 *                       wchar_t replace end                         *
 *********************************************************************/
#endif /* !_CANNA_H_ */
