#include "leastconn"

unsigned Leastconn::target(struct in_addr clientip,
			   BackendVector const &targetlist) {

    PROFILE("Leastconn::target");
    msg (Mstr("Starting least-connections dispatcher\n"));

    if (config.debug()) {
	ostringstream o;
	o << "Back end target list:";
	for (unsigned i = 0; i < targetlist.size(); i++)
	    o << ' ' << targetlist[i];
	o << '\n';
	_debugmsg(o.str());
    }
    
    bool found = false;
    unsigned best_weighted = 0, t = 0;

    for (unsigned i = 0; i < targetlist.size(); i++) {
	if (! balancer.backend(targetlist[i]).available()) {
	    debugmsg(Mstr("Back end ") +
		     Mstr(balancer.backend(targetlist[i]).description()) +
		     " is NOT available\n");
	    continue;
	}
	unsigned connections = balancer.backend(targetlist[i]).connections();
	unsigned anticipated = IPStore::anticipated(targetlist[i]);
	unsigned adjweight   = balancer.backend(targetlist[i]).adjustedweight();
	unsigned this_weight = (connections + anticipated) * adjweight;
	ostringstream o;

	if (config.debug())
	    o << "Back end " << balancer.backend(targetlist[i]).description()
	      << ": connections=" << connections << ", anticipated=" << anticipated
	      << ", adjweight=" << adjweight << ", thisweight=" << this_weight;
	
	if (!found || this_weight < best_weighted) {
	    t = targetlist[i];
	    best_weighted = this_weight;
	    found = true;
	    debugmsg(Mstr(o.str()) + Mstr(" is best so far\n"));
	} else
	    debugmsg(Mstr(o.str()) + Mstr(" skipped, got a better one\n"));
    }

    if (!found)
	throw Error("Least-connections algorithm: no available back ends");
    return (t);
}
