package Def;
use warnings;
use strict;
use integer;
use FindBin;

# This file defines common parameters for some of the helper scripts.

our $top            = "${FindBin::RealBin}/..";

our $out            = 'debram';
our $author         = 'Thaddeus H. Black';
our $email          = 'thb@debian.org';
our $dist           = 'experimental';
our $urgency        = 'low';
our $def_h          = "$top/src/def.h";
our $debram_txt     = "$top/docdata/$out.txt";
our $maint_txt      = "$top/docdata/maint.txt";
our $cmdsel_txt     = "$top/docdata/cmdsel.txt";
our $debram_1       = "$top/docdata/$out.1";
our $changelog      = "$top/debian/changelog";
our $descloc        = "$top/helper/DescLoc";
our $readme         = "$top/README";
our $ndig           =   4; # digits in a ramno
our $maxlen_title   =  52; # max length of a ram title
our $width          = 132; # intended wide screen width
our $width_std      =  80; # intended standard screen width
our $width_fmt      =  72; # std paragraph-wrapping width
our $width_shortbar =  16; # width of the short bar in cmdsel.txt
our $w_maint        =  18; # width of the std maint name and sep
our $w_pri          =   6; # width of the pri and sep
our $w_deb          =  29; # width of the deb name and sep
  #                        # (push if >= $w_deb-2)
our $w_whatis       =  21; # whatis cmd/sect width,
  #                        # to right before the hyphen
our $ind_shift      =   2; # indentation shift
our $pos_arrowhead  =  66; # proper xref arrowhead column
our $ndig_ram_count =   3; # digits in ram count
our $ndig_pkg_count =   5; # digits in package count
our $n_init         =   2; # maint initials
our $n_last         =  12; # chars in maint surname
our $mark_main_body = "THE RAMIFICATION\n";
our $mark_toc       = "RAMIFICATION MAP AND TABLE OF CONTENTS\n";
our $mark_commands  = "THE COMMANDS\n";
our $Maintainer     = 'Maintainer';
our $Priority       = 'Priority';
our $Package        = 'Package';
our $Source         = 'Source';
our $Section        = 'Section';
our $Version        = 'Version';
our $Description    = 'Description';
our $Ramification   = 'Ramification';
our $contrib        = 'contrib';
our $cl_entry_dflt  = '[Add changelog entries here.]';
our $utf8_unk       = '?';
our %pri            = (
  required  => 'req',
  important => 'imp',
  standard  => 'std',
  optional  => 'opt',
  extra     => 'ext',
);
our @pat_maint_early = (
    qr/^Tm /,
);
our @pat_maint_late = (
    qr/^Tm QA$/,
);

1;

