/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "exec_shell.h"

ExecShell::ExecShell(int clientNbr, OsCharacteristic *characteristics, QWidget *parent)
    :nbr(clientNbr), osInfo(characteristics), QFrame(parent)
{
    commandLineEdit = new QLineEdit(this);
    completer = new QCompleter(this);
    commandLineEdit->setCompleter(completer);

    textBrowser = new QTextEdit(this);
    commands_list = new QList<Command*>;
    textBrowser->setReadOnly(true);
    textBrowser->insertHtml(
            QString("<font color=\"#000000\">")
            +
            tr("This computer is now connected to the remote <b>") + osInfo->hostname + tr("</b> server.<br /><br />Command results will be displayed in this text area. Input commands into the field at the bottom of this window.<br /><br/><div align=\"center\" > <img src=\":/images/terminal.png\"/></div></font>")
            +
            QString("</font>"));
    remote_path = osInfo->home_path;
    path = new QLabel("<b>" + osInfo->home_path + "</b>", this);
    QScrollArea *scroller = new QScrollArea(this);
    DefinedCommand *definedCommand = new DefinedCommand(osInfo->system);
    connect(definedCommand, SIGNAL(executeCommand(QString)), this, SLOT(executeDefinedCommand(QString)));
    scroller->setWidget(definedCommand);
    QGroupBox *commandsGroupBox = new QGroupBox(tr("Pre-defined commands"), this);
    QGridLayout *commandsLayout = new QGridLayout;
    commandsLayout->addWidget(scroller);
    commandsGroupBox->setLayout(commandsLayout);
    QSplitter *commandSplitter = new QSplitter(this);

    commandSplitter->addWidget(textBrowser);
    commandSplitter->addWidget(commandsGroupBox);
    commandSplitter->setOrientation(Qt::Vertical);
    commandSplitter->setStretchFactor(0, 5);

    list = new QListView(this);
    list->setModel(new QStandardItemModel(this));
    QSplitter *splitter = new QSplitter(this);
    QSplitter *infoSplitter = new QSplitter(this);
    QFrame *leftFrame = new QFrame(this);
    QFrame *rightFrame = new QFrame(this);

    QFrame *infoBottomFrame = new QFrame(this);
    QVBoxLayout *infoBottomBox = new QVBoxLayout;
    infoBottomBox->addWidget(list);
    infoBottomFrame->setLayout(infoBottomBox);
    infoSplitter->addWidget(infoBottomFrame);
    infoSplitter->setOrientation(Qt::Vertical);
    infoSplitter->setStretchFactor(1, 0);
    QVBoxLayout *rightBox = new QVBoxLayout;
    rightBox->addWidget(path);
    rightBox->addWidget(commandSplitter);
    QVBoxLayout *leftBox = new QVBoxLayout;

    leftBox->addWidget(infoSplitter);

    rightFrame->setLayout(rightBox);
    leftFrame->setLayout(leftBox);
    splitter->addWidget(rightFrame);
    splitter->addWidget(leftFrame);
    splitter->setStretchFactor(0, 1);

    QGridLayout *layout = new QGridLayout;
    layout->addWidget(splitter);
    layout->addWidget(commandLineEdit);
    setLayout(layout);

    QObject::connect(commandLineEdit, SIGNAL(returnPressed()), this, SLOT(execute()));
    QObject::connect(list, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(double_clic_command()));
    QObject::connect(list, SIGNAL(clicked(QModelIndex)), this, SLOT(clic_command()));
}

void ExecShell::executeDefinedCommand(QString command)
{
    save_command(command);
    emit sendCommand(command, remote_path);
}

void ExecShell::execute()
{
    if (commandLineEdit->text() != "") {
        // Sending command to remote server.
        emit sendCommand(commandLineEdit->text(), remote_path);
        save_command(commandLineEdit->text());
        commandLineEdit->setText("");
    }
}

void ExecShell::set_remote_path(QString remote_path)
{
    path->setText("<b>" + remote_path + "</b>");
    this->remote_path = remote_path;
}

void ExecShell::set_command_results(QString result)
{
    textBrowser->clear();
    textBrowser->setReadOnly(true);
    textBrowser->ensureCursorVisible();
    textBrowser->textCursor().insertText(result);
}

void ExecShell::set_commands_list(QList<Command*> *commands_list)
{
    this->commands_list = commands_list;
    if (!commands_list->isEmpty()) {
        this->commands_list = commands_list;
        command_list_model = (QStandardItemModel*)list->model();
        if (command_list_model == NULL)
            command_list_model = new QStandardItemModel(this);
        for (int j = 0; j < commands_list->size(); j++) {
            Command *command = commands_list->at(j);
            QStandardItem *item = new QStandardItem(QIcon(":/images/terminal.png"), command->command);
            item->setDropEnabled(false);
            item->setEditable (false);
            command_list_model->appendRow(item);
        }
        list->setModel(command_list_model);
        completer->setModel(command_list_model);
    }
}

void ExecShell::save_command(QString command)
{
    // Creating command bean.
    Command *cmd = new Command(this);
    cmd->command = command;
    cmd->id_server = this->id_server;
    QDateTime date = QDateTime::currentDateTime();
    cmd->date = date.toString("dd/MM/yyyy");
    emit add_command_to_database(cmd);

    // Refreshing model.
    QStandardItemModel *list_model = (QStandardItemModel*)list->model();
    QStandardItem *item = new QStandardItem(QIcon(":/images/terminal.png"), cmd->command);
    item->setDropEnabled(false);
    item->setEditable (false);
    list_model->appendRow(item);
    list->setModel(list_model);
    completer->setModel(list_model);
}

void ExecShell::double_clic_command()
{
    QItemSelectionModel *selection = list->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)list->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
    QString selectedDocument = elementSelectionne.toString();
    commandLineEdit->setText(selectedDocument);
    execute();
}

void ExecShell::clic_command()
{
    QItemSelectionModel *selection = list->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)list->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
    QString selectedDocument = elementSelectionne.toString();
    commandLineEdit->setText(selectedDocument);
}
