/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.StringReader;

public final class StringPoolPerfTest
	extends junit.framework.TestCase
{
	static int times = 8;

	public static void main(String[] args) {
		for (int i = 0; i < args.length; i++) {
			if (args[i].equals("times"))
				times = Integer.parseInt(args[i+1]);
		}
		junit.textui.TestRunner.run(StringPoolPerfTest.class);
	}

	public StringPoolPerfTest(String name) {
		super(name);
	}

	long start;
	long total;
	void start() { start = System.currentTimeMillis(); }
	void stop(String s) { 
		long took = System.currentTimeMillis() - start; 
		System.out.println(s + " took: " + took); 
		total += took;
	}
	void average(String s) {
		System.out.println(s + " average: " + total / times); 
		total = 0;
	}

	static char pad[] = "abcdefgh".toCharArray();

	public void testQuick()
		throws Exception
	{
		StringBuffer sb = new StringBuffer(1024 * 1024);
		int total = 1024 * 512;
		for (int i = 0; i < total; i++) {
			sb.append("t").append(i%64).append("ggy-short-").
				append(pad, 0, i % 8).append(' ');
		}
		for (int i = 0; i < times; i++) {
			start();
			StringReader sr = new StringReader(sb.toString());
			XmlScanner xs = new XmlScanner(sr, 1024);
			for (int j = 0; j < total; j++) {
				xs.getName();
				xs.read(); // a space
			}
			stop("scanning");
			System.out.println(" " + xs.getStringPool());
			System.out.println(" " + xs.getStringPool().buckets());
		}
		average("scanning done ");
	}

}

