#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

#include "uwa-test-client.h"

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_notification_show_notification (context, "Test notification",  "Test notification with an invalid URL", "http://www.ubuntu.com/thisIsNotAnImage.jpg");
  unity_webapps_notification_show_notification (context, "Test notification",
						"Test notification with a URL pointing to an invalid picture",
						"http://www.google.com/index.html");
  unity_webapps_notification_show_notification (context, "Test notification",
						"Test notification with an invalid URI spec",
						"foo bar baz");

  printf("Sent an assortment of notification with invalid URIs");


  uwa_emit_test_finished ();
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
