.TH "LIBZIP" "3" "August 2, 2014" "NiH" "Library Functions Manual"
.SH "NAME"
\fBlibzip\fP
\- library for manipulating zip archives
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
.SH "DESCRIPTION"
\fBlibzip\fP
is a library for reading, creating, and modifying zip archives.
.PP
Below there are two sections listing functions: one for how to read
from zip archives and one for how to create/modify them.
.SH "READING ZIP ARCHIVES"
.SS "open archive"
zip_open(3)
zip_fdopen(3)
.SS "find files"
zip_name_locate(3)
.SS "read files"
zip_fopen(3)
zip_fopen_encrypted(3)
zip_fopen_index(3)
zip_fopen_index_encrypted(3)
zip_fread(3)
zip_fclose(3)
.SS "close archive"
zip_close(3)
zip_discard(3)
.SS "miscellaneous"
zip_stat(3)
zip_file_get_comment(3)
zip_get_archive_comment(3)
zip_get_archive_flag(3)
zip_get_name(3)
zip_get_num_entries(3)
zip_set_default_password(3)
.SH "CREATING/MODIFYING ZIP ARCHIVES"
.SS "create/open archive"
zip_open(3)
.SS "add/change files and directories"
zip_dir_add(3)
zip_file_add(3)
zip_file_replace(3)
zip_file_set_comment(3)
zip_set_file_compression(3)
zip_source_buffer(3)
zip_source_file(3)
zip_source_filep(3)
zip_source_free(3)
zip_source_function(3)
zip_source_zip(3)
.SS "rename files"
zip_rename(3)
.SS "delete files"
zip_delete(3)
.SS "revert changes"
zip_unchange(3)
zip_unchange_all(3)
zip_unchange_archive(3)
.SS "read/modify extra fields"
zip_file_extra_field_by_id(3)
zip_file_extra_field_delete(3)
zip_file_extra_field_delete_by_id(3)
zip_file_extra_field_get(3)
zip_file_extra_field_set(3)
zip_file_extra_fields_count(3)
zip_file_extra_fields_count_by_id(3)
.SS "close archive"
zip_close(3)
.SS "miscellaneous"
zip_set_archive_comment(3)
zip_set_archive_flag(3)
zip_source(3)
.SH "ERROR HANDLING"
zip_error_to_str(3)
zip_strerror(3)
zip_file_strerror(3)
zip_error_get(3)
zip_error_get_sys_type(3)
zip_errors(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
