% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{prefix_match}
\alias{prefix_match}
\title{Find the prefix matches in a trie}
\usage{
prefix_match(trie, to_match)
}
\arguments{
\item{trie}{a trie object, created with \code{\link{trie}}}

\item{to_match}{a character vector containing the strings to check against the
trie's keys.}
}
\value{
a list, the length of \code{to_match}, with each entry containing any trie values
where the \code{to_match} element was a prefix of the associated key. In the case that
nothing was found, the entry will contain \code{NA}.
}
\description{
\code{prefix_match} accepts a trie and a character vector
and returns the values associated with any key that has a particular
character vector entry as a prefix (see the examples).
}
\examples{
trie <- trie(keys = c("afford", "affair", "available", "binary", "bind", "blind"),
                   values = c("afford", "affair", "available", "binary", "bind", "blind"))
prefix_match(trie, "aff")

}
\seealso{
\code{\link{longest_match}} and \code{\link{greedy_match}}
for longest and greedy matching, respectively.
}

