% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_.R, R/with_.R
\name{local_}
\alias{local_}
\alias{with_}
\title{Create a new "with" or "local" function}
\usage{
local_(set, reset = set, envir = parent.frame())

with_(set, reset = set, envir = parent.frame())
}
\arguments{
\item{set}{\code{[function(...)]}\cr Function used to set the state.
The function can have arbitrarily many arguments, they will be replicated
in the formals of the returned function.}

\item{reset}{\code{[function(x)]}\cr Function used to reset the state.
The first argument can be named arbitrarily, further arguments with default
values, or a "dots" argument, are supported but not used: The function will
be called as \code{reset(old)}.}

\item{envir}{\code{[environment]}\cr Environment of the returned function.}
}
\value{
\code{[function(new, code, ...)]} A function with at least two arguments,
\itemize{
\item \code{new}: New state to use
\item \code{code}: Code to run in that state.
}
If there are more arguments to the function passed in \code{set} they are
added to the returned function.  If \code{set} does not have arguments,
the returned function only has a \code{code} argument.
}
\description{
These are constructors for \code{with_...} or \code{local_...} functions.
They are only needed if you want to alter some global state which is not
covered by the existing \code{with_...} functions, see \link{withr-package}
for an overview.
}
\details{
The \code{with_...} functions reset the state immediately after the
\code{code} argument has been evaluated. The \code{local_...} functions
reset their arguments after they go out of scope, usually at the end of the
function body.
}
\examples{
with_(setwd)

global_stack <- list()
set_global_state <- function(state, msg = "Changing global state.") {
  global_stack <- c(list(state), global_stack)
  message(msg)
  state
}
reset_global_state <- function(state) {
  old_state <- global_stack[[1]]
  global_stack <- global_stack[-1]
  stopifnot(identical(state, old_state))
}
with_(set_global_state, reset_global_state)
}
\keyword{internal}
