.\" @(#)shelltool.1 1.32 90/06/22 SMI;
.\" @(#)shelltool.1 1.30 90/02/26 SMI;
.\" Updated 6/8/90
.TH shelltool 1 "11 June 1990"
.SH NAME
.B shelltool 
\- run a shell (or other program) in an OpenWindows terminal window
.SH SYNOPSIS
.B shelltool
[
.B \-C
]
[
.B \-B
.I boldstyle
]
[
.B \-I
.I command
]
[
.I generic-tool-arguments
]
[
.I program 
[
.I arguments
] ]
.SH AVAILABILITY
This command is available with the
OpenWindows user environment,
For information about installing OpenWindows, refer to the
.I OpenWindows Installation and Start-Up Guide.
.SH DESCRIPTION
.IX shelltool "" "\fLshelltool\fR \(em shell terminal window"
.IX "shell window" "\fLshelltool\fR"
.LP
.B shelltool
is a standard 
.I OpenWindows
facility for shells or other programs
that use a standard tty-based interface.
.LP
When invoked, 
.B shelltool
runs a program, (usually a shell) in an interactive terminal emulator
based on a tty subwindow.
Keyboard input is passed to that program.
In the OpenWindows version of
.B shelltool,
a restricted pop-up menu is available from the
main display area that allows you to enable
scrolling. Selecting the
.B Enable Scrolling 
option from the restricted menu gives
.B shelltool
the full functionality of the
.B cmdtool
window, included a larger pop-up menu  from which to
select options.
Selecting
.B Disable Scrolling
from the pop-up submenu will return 
.B Shelltool 
to its original state.
.SH OPTIONS
.TP 15
.B \-C
Redirect system console output to this 
.BR shelltool .
.TP
.BI \-B " boldstyle"
Set the style for displaying bold text to
.IR boldstyle .
.I boldstyle
can be a string specifying one of the choices for the
.B term.boldstyle
default, see
.BR "Defaults Options" ,
below, or it may be a numerical value for one of those choices,
from 0 to 8, corresponding to the placement of the choice in the list.
.TP
.BI \-I " command"
Pass
.I command
to the shell. 
.SM SPACE
characters within the command must be escaped.
.TP
.I generic-tool-arguments
.B shelltool
accepts the generic tool arguments
listed in
.BR xview (1).
.LP
.SH USAGE
.SS .Xdefaults File Options
.LP
You can specify a number of defaults using the options
in the
.B .Xdefaults
file that effect the behavior of
.BR  shelltool .
The ones of interest are those that begin with
.BR text , term ,
or
.BR keyboard .
See
.BR .xview (1)
for more detailed information.
.SS "The Terminal Emulator"
.LP
The tty subwindow is a terminal emulator.
Whenever a tty subwindow is created, the startup file
.B ~/.ttyswrc
is read for initialization parameters that are specific to the
tty subwindow.
.SS The .ttyswrc File
The command format for this file is:
.LP
.RS
.PD 0
.TP 20
.B #
Comment.
.TP
.BI set " variable"
Turn on the specified variable.
.TP
.BI mapi " key text"
When
.I key
is typed pretend
.I text
was input.
.TP
.BI mapo " key text"
When
.I key
is typed pretend
.I text
was output.
.PD
.RE
.LP		       
The only currently defined variable is 
.BR pagemode .
.I key
is one of L1-L15, F1-F15, T1-T15, R1-R15,
.SM LEFT ,
or
.SM RIGHT 
(see note below).
.I text
may contain escapes such as \eE, \en, ^X, etc. 
(\s-1ESC\s0,
.SM RETURN ,
and
.SM CTRL-X ,
respectively).  
See 
.BR termcap (5) 
for the format of the string escapes that are recognized.
Note: 
.B mapi
and
.B mapo
may be replaced by another keymapping mechanism in the future.
.LP
When using the default kernel keyboard tables, the keys
L1,
.SM LEFT ,
.SM RIGHT ,
.SM BREAK ,
R8, R10, R12, and R14
cannot be mapped in this way; they send special values
to the tty subwindow.
Also, when using the default kernel keyboard tables,
L1-L10 are now used by XView.
See 
.BR input_from_defaults (1)
and
.BR kbd (4S) 
for more information on how to change the behavior of the keyboard.
.LP		
It is possible to have terminal-based p
special escape sequences.
These escape sequences may also
be sent by typing a key appropriately mapped
using the
.B mapo
function described above.
The following functions pertain to the tool in which the tty
subwindow resides, not the tty subwindow itself. 
.LP
.RS
.PD 0
.TP 20
.B \eE[1t
\- open
.TP
.B \eE[2t
\- close (become iconic)
.TP
.B \eE[3t
\- move, with interactive feedback
.TP
.B \eE[3;\s-1TOP\s0;\s-1LEFT\s0t
\- move, to
.B \s-1TOP LEFT\s0
(pixel coordinates)
.TP
.B \eE[4t
\- stretch, with interactive feedback
.TP
.B \eE[4;\s-1HT\s0;\s-1WIDTH\s0t
\- stretch, to
.B \s-1HT WIDTH\s0
size (in pixels)
.TP
.B \eE[5t
\- front
.TP
.B \eE[6t
\- back
.TP
.B \eE[7t
\- refresh
.TP
.B \eE[8;\s-1ROWS\s0;\s-1COLS\s0t
\- stretch, to
.B \s-1ROWS COLS\s0
size (in characters)
.TP
.B \eE[11t
\- report if open or iconic by sending
.B \eE[1t\fP or \fB\eE[2t
.TP
.B \eE[13t
\- report position by sending
.B \eE[3;\s-1TOP\s0;\s-1LEFT\s0t
.TP
.B \eE[14t
\- report size in pixels by sending
.B \eE[4;\s-1HT\s0;\s-1WIDTH\s0t
.TP
.B \eE[18t
\- report size in characters by sending
.B \eE[8;\s-1ROWS\s0;\s-1COLS\s0t
.TP
.B \eE[20t
\- report icon label by sending
.B \eE]Llabel\eE\e
.TP
.B \eE[21t
\- report tool header by sending
.B \eE]llabel\eE\e
.TP
.B \eE]ltext\eE\e
\- set tool header to
.RB text 
.TP
.B \eE]Ifile\eE\e
\- set icon to the icon contained in
.RB file ;
.RB file
must be in
.I iconedit
output format
.TP
.B \eE]Llabel\eE\e
\- set icon label to
.RB label
.TP
.B \eE[>\s-1OPT\s0;\|.\|.\|.h
\- turn
SB OPT
on
.RB ( \s-1OPT\s0
= 1 => pagemode), for example,
.B \eE[>1;3;4h
.TP
.B \eE[>\s-1OPT\s0;\|.\|.\|.k
\- report
.BR \s-1OPT\s0 ;
sends
.B \eE[>\s-1OPT\s0l
or
.B \eE[>\s-1OPT\s0h
for each
.B \s-1OPT\s0
.TP
.B \eE[>\s-1OPT\s0;\|.\|.\|.l
\- turn
.B \s-1OPT\s0
off
.RB ( \s-1OPT\s0
= 1 => pagemode), for .B \eE[>1;3;
.PD
.RE
.LP
See
.B \s-1EXAMPLES\s0
for an example of using this facility.
.LP
.B shelltool Windows
.LP
The window created by 
.B shelltool
is based on the text facility that is described in the 
.B textedit
man page.
The user is given a prompt at which to type commands and pop-up
menus from which to select command options.
.LP
.B shelltool
windows support cursor motions, using an
.B /etc/termcap
entry called
.BR sun-cmd .
Command windows automatically set the
.B \s-1TERM\s0
environment variable to
.BR sun-cmd .
So, if you
.BR rlogin (1C)
to a machine that does not have an entry for
.B sun-cmd
in its
.B /etc/termcap
file, the error message
.RB ` "Type sun-cmd unknown" '
results.
To rectify this, type the command
.RB ` "set \s-1TERM\s0=sun" '.
Programs written using the
.BR curses (3X)
or 
.BR curses (3V)
library packages will work in a command window, but programs
hard-coded for
.BR sun -type
terminals may not. 
When supporting a program that performs
cursor motions, the command window automatically takes on the
characteristics of a tty window (as with
.BR shelltool (1)).
When that program terminates or sleeps, the full command window
functionality is restored.
.LP
.B cmdtool
supports programs that use
.SM CBREAK
and
.SM NO ECHO
terminal modes. 
This support is normally invisible to the user.
However, programs that use
.SM RAW
mode, such as
.BR rlogin (1C)
and
.BR script (1),
inhibit command-line editing with the mouse.
In this case, however, tty-style
.SM ERASE,
word-kill and line-kill characters can still be used to edit the
current command line.
.SS The shelltool Menu
.LP
The
.B shelltool
window menu is called the
.B Term Pane
menu and contains the following options and their submenus:
.TP 10
.B Enable Page Mode 
Enables page mode within 
.B shelltool .
.TP
.B Copy
Places the highlighted text on the clipboard.
.TP
.B PastePuts the contents of 
pointed to by the cusor.
.TP
.B Scrolling
Enables scrolling within
.B shelltool .
.SH EXAMPLES
.LP
The following aliases can be put into your
.B ~/.cshrc
file:
.RS
.sp .5
.nf
.ft B
# dynamically set the name stripe of the tool:
alias header 'echo \-n "\eE]l\e!*\eE\e"'
# dynamically set the label on the icon:
alias iheader 'echo \-n "\eE]L\e!*\eE\e"'
# dynamically set the image on the icon:
alias icon 'echo \-n "\eE]I\e!*\eE\e"'
.fi
.RE
.SH FILES
.PD 0
.TP 20
.B ~/.ttyswrc
.TP
.B /usr/lib/ttyswrc
.TP
.B /usr/bin/xview/shelltool
.TP
.B /usr/demo/*
.PD
.SH "SEE ALSO"
.LP
.BR cmdtool (1) ,
.BR more (1) ,
.BR xview (1) ,
.BR rlogin (1C) ,
.BR kbd (4S) ,
.BR termcap (5)
.LP
.I "OpenWindows User's Guide" 
.SH BUGS
If more than 256 characters are input to a terminal emulator subwindow
without an intervening
.SM NEWLINE ,
the terminal emulator may hang.
If this occurs, an alert will come up with a message saying
.RB ` "Too many keystrokes in input buffer" '.
Choosing the
.B "Flush Input Buffer"
menu item may correct the problem.
This is a bug for a terminal emulator subwindow running on top of or
.BR rlogin (1C)
to a machine with pre-4.0 release kernel.
