/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2011-2012 Freescale Semiconductor, Inc.
 */

#ifndef _ASM_MPC85xx_CONFIG_H_
#define _ASM_MPC85xx_CONFIG_H_

/* SoC specific defines for Freescale MPC85xx (PQ3) and QorIQ processors */

#include <fsl_ddrc_version.h>

#if defined(CONFIG_ARCH_MPC8548)
#define CFG_SYS_FSL_SRIO_MAX_PORTS	1
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_SRIO_MSG_UNIT_NUM	2

#elif defined(CONFIG_ARCH_P1021)
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_P1023)
#define CFG_SYS_NUM_FMAN		1
#define CFG_SYS_NUM_FM1_DTSEC	2
#define CFG_SYS_QMAN_NUM_PORTALS	3
#define CFG_SYS_BMAN_NUM_PORTALS	3
#define CFG_SYS_FM_MURAM_SIZE	0x10000

/* P1025 is lower end variant of P1021 */
#elif defined(CONFIG_ARCH_P1025)
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_P2020)
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_SRIO_MSG_UNIT_NUM	2

#elif defined(CONFIG_ARCH_P2041) /* also supports P2040 */
#define CFG_SYS_NUM_FMAN		1
#define CFG_SYS_NUM_FM1_DTSEC	5
#define CFG_SYS_NUM_FM1_10GEC	1
#define CFG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_P3041)
#define CFG_SYS_NUM_FMAN		1
#define CFG_SYS_NUM_FM1_DTSEC	5
#define CFG_SYS_NUM_FM1_10GEC	1
#define CFG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_P4080) /* also supports P4040 */
#define CFG_SYS_NUM_FMAN		2
#define CFG_SYS_NUM_FM1_DTSEC	4
#define CFG_SYS_NUM_FM2_DTSEC	4
#define CFG_SYS_NUM_FM1_10GEC	1
#define CFG_SYS_NUM_FM2_10GEC	1
#define CFG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CFG_SYS_FSL_SRIO_MSG_UNIT_NUM	2
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xff000000

#elif defined(CONFIG_ARCH_P5040)
#define CFG_SYS_NUM_FMAN		2
#define CFG_SYS_NUM_FM1_DTSEC	5
#define CFG_SYS_NUM_FM1_10GEC	1
#define CFG_SYS_NUM_FM2_DTSEC	5
#define CFG_SYS_NUM_FM2_10GEC	1
#define CFG_SYS_FM_MURAM_SIZE	0x28000
#define CFG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_T4240)
#ifdef CONFIG_ARCH_T4240
#define CFG_SYS_FSL_CLUSTER_CLOCKS   { 1, 1, 4 }
#define CFG_SYS_NUM_FM1_DTSEC	8
#define CFG_SYS_NUM_FM1_10GEC	2
#define CFG_SYS_NUM_FM2_DTSEC	8
#define CFG_SYS_NUM_FM2_10GEC	2
#else
#define CFG_SYS_NUM_FM1_DTSEC	6
#define CFG_SYS_NUM_FM1_10GEC	1
#define CFG_SYS_NUM_FM2_DTSEC	8
#define CFG_SYS_NUM_FM2_10GEC	1
#endif
#define CFG_SYS_FSL_SRDS_3
#define CFG_SYS_FSL_SRDS_4
#define CFG_SYS_NUM_FMAN		2
#define CFG_SYS_PME_CLK		0
#define CFG_SYS_FM1_CLK		3
#define CFG_SYS_FM2_CLK		3
#define CFG_SYS_FM_MURAM_SIZE	0x60000
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5

#elif defined(CONFIG_ARCH_B4860) || defined(CONFIG_ARCH_B4420)
#define CFG_SYS_NUM_FMAN		1
#define CFG_SYS_FM1_CLK		0
#define CFG_SYS_FM_MURAM_SIZE	0x60000

#ifdef CONFIG_ARCH_B4860
#define CFG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4, 4, 4 }
#define CFG_SYS_NUM_FM1_DTSEC	6
#define CFG_SYS_NUM_FM1_10GEC	2
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#else
#define CFG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4 }
#define CFG_SYS_NUM_FM1_DTSEC	4
#define CFG_SYS_NUM_FM1_10GEC	0
#endif

#elif defined(CONFIG_ARCH_T1040) || defined(CONFIG_ARCH_T1042)
#define CFG_SYS_FSL_CLUSTER_CLOCKS   { 1, 1, 1, 1 }
#define CFG_SYS_NUM_FMAN		1
#define CFG_SYS_NUM_FM1_DTSEC	5
#define CFG_PME_PLAT_CLK_DIV		2
#define CFG_SYS_PME_CLK		CFG_PME_PLAT_CLK_DIV
#define CFG_FM_PLAT_CLK_DIV	1
#define CFG_SYS_FM1_CLK		CFG_FM_PLAT_CLK_DIV
#define CFG_SYS_FM_MURAM_SIZE	0x30000
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_T1024)
#define CFG_SYS_FSL_CLUSTER_CLOCKS  { 1, 1, 1, 1 }
#define CFG_SYS_NUM_FMAN		1
#define CFG_SYS_NUM_FM1_DTSEC	4
#define CFG_SYS_NUM_FM1_10GEC	1
#define CFG_SYS_FM1_CLK		0
#define CFG_QBMAN_CLK_DIV		1
#define CFG_SYS_FM_MURAM_SIZE	0x30000
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_T2080)
#define CFG_SYS_NUM_FMAN		1
#define CFG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4, 4, 4 }
#if defined(CONFIG_ARCH_T2080)
#define CFG_SYS_NUM_FM1_DTSEC	8
#define CFG_SYS_NUM_FM1_10GEC	4
#define CFG_SYS_FSL_SRIO_MAX_PORTS	2
#define CFG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CFG_SYS_FSL_SRIO_IB_WIN_NUM	5
#endif
#define CFG_PME_PLAT_CLK_DIV		1
#define CFG_SYS_PME_CLK		CFG_PME_PLAT_CLK_DIV
#define CFG_SYS_FM1_CLK		0
#define CFG_SYS_FM_MURAM_SIZE	0x28000
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE

#elif defined(CONFIG_ARCH_C29X)
#define CFG_SYS_FSL_SEC_IDX_OFFSET	0x20000

#endif

#endif /* _ASM_MPC85xx_CONFIG_H_ */
