#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# Beyond Good and Evil
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251112.7

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='beyond-good-and-evil'
GAME_NAME='Beyond Good and Evil'

ARCHIVE_BASE_0_NAME='setup_beyond_good_and_evil_2.1.0.9.exe'
ARCHIVE_BASE_0_MD5='fdfa4b94cf02e24523b01c9d54568482'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2195754'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.9'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/beyond_good_and_evil'

CONTENT_PATH_DEFAULT='app'
## bge.exe requirements
CONTENT_LIBS_BIN_FILES='
binkw32.dll'
## settingsapplication.exe crashes on launch if this library is not available.
CONTENT_LIBS0_BIN_PATH='sys'
CONTENT_LIBS0_BIN_FILES='
eax.dll'
CONTENT_GAME_BIN_FILES='
bge.exe
settingsapplication.exe'
## settingsapplication.exe fails with a critical error if any of the following binaries is missing.
CONTENT_GAME0_BIN_FILES='
checkapplication.exe
run.exe'
CONTENT_GAME_DATA_FILES='
bgemakingof.bik
jade.spe
sally_clean.bf'
CONTENT_DOC_DATA_FILES='
manual.pdf
readme.txt'

USER_PERSISTENT_FILES='
sally.idx
*.sav'

## Prevent a loss of input on loss of focus.
## (WINE 10.0)
WINE_VIRTUAL_DESKTOP='1280x1024'
WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\Ubisoft\Beyond Good & Evil\settingsapplication.INI'
## TODO: Check if setting this path is required.
# shellcheck disable=SC1003
WINE_REGISTRY_INIT='
[HKEY_LOCAL_MACHINE\Software\Ubisoft\Beyond Good & Evil]

"Install path"="C:\\'"${GAME_ID}"'"
'
## Set default settings on first launch, preventing the need to force-spawn the settings window.
WINE_REGISTRY_INIT="$WINE_REGISTRY_INIT"'
[HKEY_CURRENT_USER\Software\Ubisoft\Beyond Good & Evil\settingsapplication.INI\Basic video]
"Activate compatibility settings"=dword:00000000
"Adapter GUID"=hex:00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
"AfterFx"=dword:00000001
"Autogen mipmap"=dword:00000001
"Blurryness"=dword:0000000a
"Depth buffer"=dword:00000001
"Flare"=dword:00000001
"Flipmode"=dword:00000003
"Format"=dword:00000016
"Frame buffers"=dword:00000002
"HardwareVertexProcessing"=dword:00000001
"Mipmapping"=dword:00000001
"Mode"=dword:0000000d
"Shadows Quality"=dword:00000200
"SSE Enabled"=dword:00000001
"Vertex Streams"=dword:00000001
"Video Adapter"=dword:00000000
"VSynch"=dword:00000001
"Water quality"=dword:00000002

[HKEY_CURRENT_USER\Software\Ubisoft\Beyond Good & Evil\settingsapplication.INI\Key bindings]
"Buddy action/Compass"=dword:001200cf
"Center view"=dword:002e004c
"Crouch"=dword:001d00dd
"Down"=dword:001f00d0
"Horizontal inversion"=dword:00000001
"Inventory next"=dword:000400d1
"Inventory prev"=dword:000300c9
"Left"=dword:001e00cb
"Look mode"=dword:002a0052
"Map"=dword:000f000e
"Menu"=dword:000100c5
"Menu back"=dword:01030001
"Menu info"=dword:00390104
"Primary action"=dword:01020000
"Right"=dword:002000cd
"Run/Accelerate"=dword:0039009d
"Secondary action"=dword:01030000
"Up"=dword:001100c8
"Use object"=dword:001000d3
"Vertical inversion"=dword:00000001

[HKEY_CURRENT_USER\Software\Ubisoft\Beyond Good & Evil\settingsapplication.INI\Sound]
"Audio board FX Capable"=dword:00000001
"Audio board GUID"=hex:00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
"Sound FX"=dword:00000001
'

APP_MAIN_EXE='bge.exe'

APP_SETTINGS_ID="${GAME_ID}-settings"
APP_SETTINGS_NAME="${GAME_NAME} - settings"
APP_SETTINGS_CAT='Settings'
APP_SETTINGS_EXE='settingsapplication.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	ln --force --symbolic $(path_libraries)/* "\${PATH_PREFIX}"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
