#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Prince of Persia: The Sands of Time
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251108.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='prince-of-persia-the-sands-of-time'
GAME_NAME='Prince of Persia: The Sands of Time'

ARCHIVE_BASE_FR_0_NAME='setup_prince_of_persia_-_the_sands_of_time_181_(french)_(28548).exe'
ARCHIVE_BASE_FR_0_MD5='b71ed96b13461f56c8a47e16fbecadbb'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_PART1_NAME='setup_prince_of_persia_-_the_sands_of_time_181_(french)_(28548)-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='691e5144e34bf71ab15d45de11089b34'
ARCHIVE_BASE_FR_0_SIZE='1408358'
ARCHIVE_BASE_FR_0_VERSION='1.00.181-gog28548'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/prince_of_persia_the_sands_of_time'

ARCHIVE_BASE_EN_0_NAME='setup_prince_of_persia_-_the_sands_of_time_181_(28548).exe'
ARCHIVE_BASE_EN_0_MD5='008b4359cafb21dd4e437860dc23e2cf'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_prince_of_persia_-_the_sands_of_time_181_(28548)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='639fd428677dc8fb52e864422cbfe26d'
ARCHIVE_BASE_EN_0_SIZE='1413339'
ARCHIVE_BASE_EN_0_VERSION='1.00.181-gog28548'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/prince_of_persia_the_sands_of_time'

CONTENT_PATH_DEFAULT='.'
CONTENT_LIBS_BIN_FILES='
binkw32.dll
eax.dll
MFC71.DLL'
## Required for hardware detection on launch
CONTENT_LIBS0_BIN_FILES='
detectionapi.dll
directx9tests.dll'
## Localised error messages are included in this library.
CONTENT_LIBS_L10N_LIBS_FILES='
poplauncherres.dll'
CONTENT_GAME_BIN_FILES='
pop.exe
princeofpersia.exe
directxtests.tst
systemtests.tst'
CONTENT_GAME0_BIN_PATH='__support/app'
CONTENT_GAME0_BIN_FILES='
Hardware.ini
sound/dare.ini'
CONTENT_GAME_L10N_FILES='
popdata.bf
sound/soundlocal.big
sound/soundlocal.fat
video/loading.int'
CONTENT_GAME_DATA_FILES='
profiles
sound
video
prince.bf'
CONTENT_DOC_L10N_FILES='
manual.pdf
licence.txt
readme.txt'

USER_PERSISTENT_FILES='
Hardware.ini
sound/dare.ini'
USER_PERSISTENT_DIRECTORIES='
profiles'

APP_MAIN_EXE='princeofpersia.exe'
## Work around fog rendering problems.
## On first launch, the game runs with display problems related to fog rendering.
## Quit the game and launch it again, it should automatically be fixed on the second launch.
APP_MAIN_PRERUN='
# Work around fog rendering problems.
# On first launch, the game runs with display problems related to fog rendering.
# Quit the game and launch it again, it should automatically be fixed on the second launch.
config_file="Hardware.ini"
dos2unix --quiet "$config_file"
sed \
	--in-place \
	--expression="s/InvertFogRange=.*/InvertFogRange=0/" \
	"$config_file"
unix2dos --quiet "$config_file"
'
## Work around an override of configuration file.
APP_MAIN_POSTRUN='
# Work around an override of configuration file.
config_file="Hardware.ini"
config_file_persistent="${PATH_PERSISTENT}/${config_file}"
if \
	[ -f "$config_file" ] \
	&& [ ! -h "$config_file" ]
then
	cp --remove-destination "$config_file" "$config_file_persistent"
	rm "$config_file"
	ln --symbolic "$config_file_persistent" "$config_file"
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_L10N_LIBS
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'
## Work around fog rendering problems.
PKG_BIN_DEPENDENCIES_COMMANDS='
dos2unix'
## Easier upgrades from pre-20231018.1 packages
PKG_BIN_PROVIDES='
prince-of-persia'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localisation'
PKG_L10N_DESCRIPTION_FR='French localisation'
PKG_L10N_DEPENDENCIES_SIBLINGS='
PKG_L10N_LIBS'
## Easier upgrades from pre-20231018.1 packages
PKG_L10N_PROVIDES="$PKG_L10N_PROVIDES
prince-of-persia-l10n"

PKG_L10N_LIBS_ID_EN="${PKG_L10N_ID_EN}-libs"
PKG_L10N_LIBS_ID_FR="${PKG_L10N_ID_FR}-libs"
PKG_L10N_LIBS_PROVIDES="
${PKG_L10N_BASE_ID}-libs"
PKG_L10N_LIBS_ARCH='32'
PKG_L10N_LIBS_DESCRIPTION_EN="$PKG_L10N_DESCRIPTION_EN - libraries"
PKG_L10N_LIBS_DESCRIPTION_FR="$PKG_L10N_DESCRIPTION_FR - libraries"
## Prevent a fallback on PKG_L10N_DEPENDENCIES_SIBLINGS.
PKG_L10N_LIBS_DEPENDENCIES_SIBLINGS=' '

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20231018.1 packages
PKG_DATA_PROVIDES='
prince-of-persia-data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Work around case-related problems caused by file deletion-creation instead of in-place edition.

mv \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path 'GAME0_BIN')/hardware.ini" \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path 'GAME0_BIN')/Hardware.ini"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	ln --force --symbolic $(path_libraries)/* "\${PATH_PREFIX}"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
