/***** Autogenerated from runpath.in; changes will be overwritten *****/

#line 1 "./runtimebase.in"
/*****
 * runtimebase.in
 * Andy Hammerlindl  2009/07/28
 *
 * Common declarations needed for all code-generating .in files.
 *
 *****/


#line 1 "./runpath.in"
/*****
 * runpath.in
 *
 * Runtime functions for path operations.
 *
 *****/

#line 1 "./runtimebase.in"
#include "stack.h"
#include "types.h"
#include "builtin.h"
#include "entry.h"
#include "errormsg.h"
#include "array.h"
#include "triple.h"
#include "callable.h"
#include "opsymbols.h"

using vm::stack;
using vm::error;
using vm::array;
using vm::read;
using vm::callable;
using types::formal;
using types::function;
using camp::triple;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

void unused(void *);

namespace run {
typedef double real;

array *copyArray(array *a);
array *copyArray2(array *a);
array *copyArray3(array *a);

double *copyTripleArray2Components(array *a, size_t &N,
                                   GCPlacement placement=NoGC);
triple *copyTripleArray2C(array *a, size_t &N,
                          GCPlacement placement=NoGC);
}

function *realRealFunction();

#define CURRENTPEN processData().currentpen

#line 17 "runpath.in"
#include "path.h"
#include "arrayop.h"
#include "predicates.h"

using namespace camp;
using namespace vm;

typedef array realarray;
typedef array realarray2;
typedef array patharray;

using types::realArray;
using types::realArray2;
using types::pathArray;

Int windingnumber(array *p, camp::pair z)
{
  size_t size=checkArray(p);
  Int count=0;
  for(size_t i=0; i < size; i++)
    count += read<path *>(p,i)->windingnumber(z);
  return count;
}

// Autogenerated routines:



#ifndef NOSYM
#include "runpath.symbols.h"

#endif
namespace run {
#line 44 "./runpath.in"
void nullPath(stack *Stack)
{
#line 45 "./runpath.in"
  {Stack->push<path>(nullpath); return;}
}

#line 49 "./runpath.in"
// bool ==(path a, path b);
void gen_runpath1(stack *Stack)
{
  path b=vm::pop<path>(Stack);
  path a=vm::pop<path>(Stack);
#line 50 "./runpath.in"
  {Stack->push<bool>(a == b); return;}
}

#line 54 "./runpath.in"
// bool !=(path a, path b);
void gen_runpath2(stack *Stack)
{
  path b=vm::pop<path>(Stack);
  path a=vm::pop<path>(Stack);
#line 55 "./runpath.in"
  {Stack->push<bool>(!(a == b)); return;}
}

#line 59 "./runpath.in"
// pair point(path p, Int t);
void gen_runpath3(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 60 "./runpath.in"
  {Stack->push<pair>(p.point((Int) t)); return;}
}

#line 64 "./runpath.in"
// pair point(path p, real t);
void gen_runpath4(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 65 "./runpath.in"
  {Stack->push<pair>(p.point(t)); return;}
}

#line 69 "./runpath.in"
// pair precontrol(path p, Int t);
void gen_runpath5(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 70 "./runpath.in"
  {Stack->push<pair>(p.precontrol((Int) t)); return;}
}

#line 74 "./runpath.in"
// pair precontrol(path p, real t);
void gen_runpath6(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 75 "./runpath.in"
  {Stack->push<pair>(p.precontrol(t)); return;}
}

#line 79 "./runpath.in"
// pair postcontrol(path p, Int t);
void gen_runpath7(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 80 "./runpath.in"
  {Stack->push<pair>(p.postcontrol((Int) t)); return;}
}

#line 84 "./runpath.in"
// pair postcontrol(path p, real t);
void gen_runpath8(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 85 "./runpath.in"
  {Stack->push<pair>(p.postcontrol(t)); return;}
}

#line 89 "./runpath.in"
// pair dir(path p, Int t, Int sign=0, bool normalize=true);
void gen_runpath9(stack *Stack)
{
  bool normalize=vm::pop<bool>(Stack,true);
  Int sign=vm::pop<Int>(Stack,0);
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 90 "./runpath.in"
  {Stack->push<pair>(p.dir(t,sign,normalize)); return;}
}

#line 94 "./runpath.in"
// pair dir(path p, real t, bool normalize=true);
void gen_runpath10(stack *Stack)
{
  bool normalize=vm::pop<bool>(Stack,true);
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 95 "./runpath.in"
  {Stack->push<pair>(p.dir(t,normalize)); return;}
}

#line 99 "./runpath.in"
// pair accel(path p, Int t, Int sign=0);
void gen_runpath11(stack *Stack)
{
  Int sign=vm::pop<Int>(Stack,0);
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 100 "./runpath.in"
  {Stack->push<pair>(p.accel(t,sign)); return;}
}

#line 104 "./runpath.in"
// pair accel(path p, real t);
void gen_runpath12(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 105 "./runpath.in"
  {Stack->push<pair>(p.accel(t)); return;}
}

#line 109 "./runpath.in"
// real radius(path p, real t);
void gen_runpath13(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 110 "./runpath.in"
  pair v=p.dir(t,false);
  pair a=p.accel(t);
  real d=dot(a,v);
  real v2=v.abs2();
  real a2=a.abs2();
  real denom=v2*a2-d*d;
  real r=v2*sqrt(v2);
  {Stack->push<real>(denom > 0 ? r/sqrt(denom) : 0.0); return;}
}

#line 121 "./runpath.in"
// path reverse(path p);
void gen_runpath14(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 122 "./runpath.in"
  {Stack->push<path>(p.reverse()); return;}
}

#line 126 "./runpath.in"
// path subpath(path p, Int a, Int b);
void gen_runpath15(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 127 "./runpath.in"
  {Stack->push<path>(p.subpath((Int) a, (Int) b)); return;}
}

#line 131 "./runpath.in"
// path subpath(path p, real a, real b);
void gen_runpath16(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 132 "./runpath.in"
  {Stack->push<path>(p.subpath(a,b)); return;}
}

#line 136 "./runpath.in"
// path nurb(pair z0, pair z1, pair z2, pair z3,          real w0, real w1, real w2, real w3, Int m);
void gen_runpath17(stack *Stack)
{
  Int m=vm::pop<Int>(Stack);
  real w3=vm::pop<real>(Stack);
  real w2=vm::pop<real>(Stack);
  real w1=vm::pop<real>(Stack);
  real w0=vm::pop<real>(Stack);
  pair z3=vm::pop<pair>(Stack);
  pair z2=vm::pop<pair>(Stack);
  pair z1=vm::pop<pair>(Stack);
  pair z0=vm::pop<pair>(Stack);
#line 138 "./runpath.in"
  {Stack->push<path>(nurb(z0,z1,z2,z3,w0,w1,w2,w3,m)); return;}
}

#line 142 "./runpath.in"
// Int length(path p);
void gen_runpath18(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 143 "./runpath.in"
  {Stack->push<Int>(p.length()); return;}
}

#line 147 "./runpath.in"
// bool cyclic(path p);
void gen_runpath19(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 148 "./runpath.in"
  {Stack->push<bool>(p.cyclic()); return;}
}

#line 152 "./runpath.in"
// bool straight(path p, Int t);
void gen_runpath20(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 153 "./runpath.in"
  {Stack->push<bool>(p.straight(t)); return;}
}

#line 157 "./runpath.in"
// path unstraighten(path p);
void gen_runpath21(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 158 "./runpath.in"
  {Stack->push<path>(p.unstraighten()); return;}
}

#line 162 "./runpath.in"
// bool piecewisestraight(path p);
void gen_runpath22(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 163 "./runpath.in"
  {Stack->push<bool>(p.piecewisestraight()); return;}
}

#line 167 "./runpath.in"
// real arclength(path p);
void gen_runpath23(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 168 "./runpath.in"
  {Stack->push<real>(p.arclength()); return;}
}

#line 172 "./runpath.in"
// real arclength(pair z0, pair c0, pair c1, pair z1);
void gen_runpath24(stack *Stack)
{
  pair z1=vm::pop<pair>(Stack);
  pair c1=vm::pop<pair>(Stack);
  pair c0=vm::pop<pair>(Stack);
  pair z0=vm::pop<pair>(Stack);
#line 173 "./runpath.in"
  {Stack->push<real>(arcLength(z0,c0,c1,z1)); return;}
}

#line 177 "./runpath.in"
// real arctime(path p, real L);
void gen_runpath25(stack *Stack)
{
  real L=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 178 "./runpath.in"
  {Stack->push<real>(p.arctime(L)); return;}
}

#line 182 "./runpath.in"
// real dirtime(path p, pair z);
void gen_runpath26(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  path p=vm::pop<path>(Stack);
#line 183 "./runpath.in"
  {Stack->push<real>(p.directiontime(z)); return;}
}

#line 187 "./runpath.in"
// realarray* intersect(path p, path q, real fuzz=-1);
void gen_runpath27(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 188 "./runpath.in"
  bool exact=fuzz <= 0.0;
  if(fuzz < 0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(q.max()),length(q.min())));
  std::vector<real> S,T;
  real s,t;
  if(intersections(s,t,S,T,p,q,fuzz,true,exact)) {
    array *V=new array(2);
    (*V)[0]=s;
    (*V)[1]=t;
    {Stack->push<realarray*>(V); return;}
  }
  {Stack->push<realarray*>(new array(0)); return;}
}

#line 204 "./runpath.in"
// realarray2* intersections(path p, path q, real fuzz=-1);
void gen_runpath28(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 205 "./runpath.in"
  bool exact=fuzz <= 0.0;
  if(fuzz < 0.0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(q.max()),length(q.min())));
  real s,t;
  std::vector<real> S,T;
  intersections(s,t,S,T,p,q,fuzz,false,true);
  size_t n=S.size();
  if(n == 0 && !exact) {
    if(intersections(s,t,S,T,p,q,fuzz,true,false)) {
      array *V=new array(1);
      array *Vi=new array(2);
      (*V)[0]=Vi;
      (*Vi)[0]=s;
      (*Vi)[1]=t;
      {Stack->push<realarray2*>(V); return;}
    }
  }
  array *V=new array(n);
  for(size_t i=0; i < n; ++i) {
    array *Vi=new array(2);
    (*V)[i]=Vi;
    (*Vi)[0]=S[i];
    (*Vi)[1]=T[i];
  }
  stable_sort(V->begin(),V->end(),run::compare2<real>());
  {Stack->push<realarray2*>(V); return;}
}

#line 235 "./runpath.in"
// realarray* intersections(path p, explicit pair a, explicit pair b, real fuzz=-1);
void gen_runpath29(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
  path p=vm::pop<path>(Stack);
#line 236 "./runpath.in"
  if(fuzz < 0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(a),length(b)));
  std::vector<real> S;
  intersections(S,p,a,b,fuzz);
  sort(S.begin(),S.end());
  size_t n=S.size();
  array *V=new array(n);
  for(size_t i=0; i < n; ++i)
    (*V)[i]=S[i];
  {Stack->push<realarray*>(V); return;}
}

// Return the intersection point of the extensions of the line segments
// PQ and pq.
#line 252 "./runpath.in"
// pair extension(pair P, pair Q, pair p, pair q);
void gen_runpath30(stack *Stack)
{
  pair q=vm::pop<pair>(Stack);
  pair p=vm::pop<pair>(Stack);
  pair Q=vm::pop<pair>(Stack);
  pair P=vm::pop<pair>(Stack);
#line 253 "./runpath.in"
  pair ac=P-Q;
  pair bd=q-p;
  real det=ac.getx()*bd.gety()-ac.gety()*bd.getx();
  if(det == 0) {Stack->push<pair>(pair(infinity,infinity)); return;}
  {Stack->push<pair>(P+((p.getx()-P.getx())*bd.gety()-(p.gety()-P.gety())*bd.getx())*ac/det); return;}
}

#line 261 "./runpath.in"
// Int size(path p);
void gen_runpath31(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 262 "./runpath.in"
  {Stack->push<Int>(p.size()); return;}
}

#line 266 "./runpath.in"
// path &(path p, path q);
void gen_runpath32(stack *Stack)
{
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 267 "./runpath.in"
  {Stack->push<path>(camp::concat(p,q)); return;}
}

#line 271 "./runpath.in"
// pair min(explicit path p);
void gen_runpath33(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 272 "./runpath.in"
  {Stack->push<pair>(p.min()); return;}
}

#line 276 "./runpath.in"
// pair max(explicit path p);
void gen_runpath34(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 277 "./runpath.in"
  {Stack->push<pair>(p.max()); return;}
}

#line 281 "./runpath.in"
// Int size(patharray *p);
void gen_runpath35(stack *Stack)
{
  patharray * p=vm::pop<patharray *>(Stack);
#line 282 "./runpath.in"
  size_t size=checkArray(p);
  Int count=0;
  for (size_t i = 0; i < size; i++)
    count += read<path *>(p,i)->size();
  {Stack->push<Int>(count); return;}
}

#line 290 "./runpath.in"
// pair min(patharray *p);
void gen_runpath36(stack *Stack)
{
  patharray * p=vm::pop<patharray *>(Stack);
#line 291 "./runpath.in"
  size_t size=checkArray(p);

  if(size == 0)
    error(nopoints);

  path *g = p->read<path *>(0);
  pair z = g->min();
  double minx = z.getx(), miny = z.gety();

  for (size_t i = 1; i < size; ++i) {
    path *g = p->read<path *>(i);
    pair z = g->min();
    double x = z.getx(), y = z.gety();
    if (x < minx)
      minx = x;
    if (y < miny)
      miny = y;
  }

  {Stack->push<pair>(pair(minx, miny)); return;}
}

#line 314 "./runpath.in"
// pair max(patharray *p);
void gen_runpath37(stack *Stack)
{
  patharray * p=vm::pop<patharray *>(Stack);
#line 315 "./runpath.in"
  size_t size=checkArray(p);

  if(size == 0)
    error(nopoints);

  path *g = p->read<path *>(0);
  pair z = g->max();
  double maxx = z.getx(), maxy = z.gety();

  for (size_t i = 1; i < size; ++i) {
    path *g = p->read<path *>(i);
    pair z = g->max();
    double x = z.getx(), y = z.gety();
    if (x > maxx)
      maxx = x;
    if (y > maxy)
      maxy = y;
  }

  {Stack->push<pair>(pair(maxx, maxy)); return;}
}

#line 338 "./runpath.in"
// pair minAfterTransform(transform t, patharray *p);
void gen_runpath38(stack *Stack)
{
  patharray * p=vm::pop<patharray *>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 339 "./runpath.in"
  size_t size=checkArray(p);

  if(size == 0)
    error(nopoints);

  path g = p->read<path *>(0)->transformed(t);
  pair z = g.min();
  double minx = z.getx(), miny = z.gety();

  for (size_t i = 1; i < size; ++i) {
    path g = p->read<path *>(i)->transformed(t);
    pair z = g.min();
    double x = z.getx(), y = z.gety();
    if (x < minx)
      minx = x;
    if (y < miny)
      miny = y;
  }

  {Stack->push<pair>(pair(minx, miny)); return;}
}

#line 362 "./runpath.in"
// pair maxAfterTransform(transform t, patharray *p);
void gen_runpath39(stack *Stack)
{
  patharray * p=vm::pop<patharray *>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 363 "./runpath.in"
  size_t size=checkArray(p);

  if(size == 0)
    error(nopoints);

  path g = p->read<path *>(0)->transformed(t);
  pair z = g.max();
  double maxx = z.getx(), maxy = z.gety();

  for (size_t i = 1; i < size; ++i) {
    path g = p->read<path *>(i)->transformed(t);
    pair z = g.max();
    double x = z.getx(), y = z.gety();
    if (x > maxx)
      maxx = x;
    if (y > maxy)
      maxy = y;
  }

  {Stack->push<pair>(pair(maxx, maxy)); return;}
}

#line 386 "./runpath.in"
// realarray* mintimes(path p);
void gen_runpath40(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 387 "./runpath.in"
  array *V=new array(2);
  pair z=p.mintimes();
  (*V)[0]=z.getx();
  (*V)[1]=z.gety();
  {Stack->push<realarray*>(V); return;}
}

#line 395 "./runpath.in"
// realarray* maxtimes(path p);
void gen_runpath41(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 396 "./runpath.in"
  array *V=new array(2);
  pair z=p.maxtimes();
  (*V)[0]=z.getx();
  (*V)[1]=z.gety();
  {Stack->push<realarray*>(V); return;}
}

#line 404 "./runpath.in"
// real relativedistance(real theta, real phi, real t, bool atleast);
void gen_runpath42(stack *Stack)
{
  bool atleast=vm::pop<bool>(Stack);
  real t=vm::pop<real>(Stack);
  real phi=vm::pop<real>(Stack);
  real theta=vm::pop<real>(Stack);
#line 405 "./runpath.in"
  {Stack->push<real>(camp::velocity(theta,phi,tension(t,atleast))); return;}
}

#line 409 "./runpath.in"
// Int windingnumber(patharray *p, pair z);
void gen_runpath43(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  patharray * p=vm::pop<patharray *>(Stack);
#line 410 "./runpath.in"
  {Stack->push<Int>(windingnumber(p,z)); return;}
}

#line 414 "./runpath.in"
// bool inside(explicit patharray *g, pair z, pen fillrule=CURRENTPEN);
void gen_runpath44(stack *Stack)
{
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  pair z=vm::pop<pair>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
#line 415 "./runpath.in"
  {Stack->push<bool>(fillrule.inside(windingnumber(g,z))); return;}
}

#line 419 "./runpath.in"
// bool inside(path g, pair z, pen fillrule=CURRENTPEN);
void gen_runpath45(stack *Stack)
{
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  pair z=vm::pop<pair>(Stack);
  path g=vm::pop<path>(Stack);
#line 420 "./runpath.in"
  {Stack->push<bool>(fillrule.inside(g.windingnumber(z))); return;}
}

// Return a positive (negative) value if a--b--c--cycle is oriented
// counterclockwise (clockwise) or zero if all three points are colinear.
// Equivalently, return a positive (negative) value if c lies to the
// left (right) of the line through a and b or zero if c lies on this line.
// The value returned is the determinant
// |a.x a.y 1|
// |b.x b.y 1|
// |c.x c.y 1|
//
#line 433 "./runpath.in"
// real orient(pair a, pair b, pair c);
void gen_runpath46(stack *Stack)
{
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 434 "./runpath.in"
  {Stack->push<real>(orient2d(a,b,c)); return;}
}

// Return a positive (negative) value if d lies inside (outside)
// the circle passing through the counterclockwise-oriented points a,b,c
// or zero if d lies on this circle.
// The value returned is the determinant
// |a.x a.y a.x^2+a.y^2 1|
// |b.x b.y b.x^2+b.y^2 1|
// |c.x c.y c.x^2+c.y^2 1|
// |d.x d.y d.x^2+d.y^2 1|
#line 446 "./runpath.in"
// real incircle(pair a, pair b, pair c, pair d);
void gen_runpath47(stack *Stack)
{
  pair d=vm::pop<pair>(Stack);
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 447 "./runpath.in"
  {Stack->push<real>(incircle(a.getx(),a.gety(),b.getx(),b.gety(),c.getx(),c.gety(),
                  d.getx(),d.gety())); return;}
}

} // namespace run

namespace trans {

void gen_runpath_venv(venv &ve)
{
#line 44 "./runpath.in"
  REGISTER_BLTIN(run::nullPath,"nullPath");
#line 49 "./runpath.in"
  addFunc(ve, run::gen_runpath1, primBoolean(), SYM_EQ, formal(primPath(), SYM(a), false, false), formal(primPath(), SYM(b), false, false));
#line 54 "./runpath.in"
  addFunc(ve, run::gen_runpath2, primBoolean(), SYM_NEQ, formal(primPath(), SYM(a), false, false), formal(primPath(), SYM(b), false, false));
#line 59 "./runpath.in"
  addFunc(ve, run::gen_runpath3, primPair(), SYM(point), formal(primPath(), SYM(p), false, false), formal(primInt(), SYM(t), false, false));
#line 64 "./runpath.in"
  addFunc(ve, run::gen_runpath4, primPair(), SYM(point), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(t), false, false));
#line 69 "./runpath.in"
  addFunc(ve, run::gen_runpath5, primPair(), SYM(precontrol), formal(primPath(), SYM(p), false, false), formal(primInt(), SYM(t), false, false));
#line 74 "./runpath.in"
  addFunc(ve, run::gen_runpath6, primPair(), SYM(precontrol), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(t), false, false));
#line 79 "./runpath.in"
  addFunc(ve, run::gen_runpath7, primPair(), SYM(postcontrol), formal(primPath(), SYM(p), false, false), formal(primInt(), SYM(t), false, false));
#line 84 "./runpath.in"
  addFunc(ve, run::gen_runpath8, primPair(), SYM(postcontrol), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(t), false, false));
#line 89 "./runpath.in"
  addFunc(ve, run::gen_runpath9, primPair(), SYM(dir), formal(primPath(), SYM(p), false, false), formal(primInt(), SYM(t), false, false), formal(primInt(), SYM(sign), true, false), formal(primBoolean(), SYM(normalize), true, false));
#line 94 "./runpath.in"
  addFunc(ve, run::gen_runpath10, primPair(), SYM(dir), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(t), false, false), formal(primBoolean(), SYM(normalize), true, false));
#line 99 "./runpath.in"
  addFunc(ve, run::gen_runpath11, primPair(), SYM(accel), formal(primPath(), SYM(p), false, false), formal(primInt(), SYM(t), false, false), formal(primInt(), SYM(sign), true, false));
#line 104 "./runpath.in"
  addFunc(ve, run::gen_runpath12, primPair(), SYM(accel), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(t), false, false));
#line 109 "./runpath.in"
  addFunc(ve, run::gen_runpath13, primReal(), SYM(radius), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(t), false, false));
#line 121 "./runpath.in"
  addFunc(ve, run::gen_runpath14, primPath(), SYM(reverse), formal(primPath(), SYM(p), false, false));
#line 126 "./runpath.in"
  addFunc(ve, run::gen_runpath15, primPath(), SYM(subpath), formal(primPath(), SYM(p), false, false), formal(primInt(), SYM(a), false, false), formal(primInt(), SYM(b), false, false));
#line 131 "./runpath.in"
  addFunc(ve, run::gen_runpath16, primPath(), SYM(subpath), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(a), false, false), formal(primReal(), SYM(b), false, false));
#line 136 "./runpath.in"
  addFunc(ve, run::gen_runpath17, primPath(), SYM(nurb), formal(primPair(), SYM(z0), false, false), formal(primPair(), SYM(z1), false, false), formal(primPair(), SYM(z2), false, false), formal(primPair(), SYM(z3), false, false), formal(primReal(), SYM(w0), false, false), formal(primReal(), SYM(w1), false, false), formal(primReal(), SYM(w2), false, false), formal(primReal(), SYM(w3), false, false), formal(primInt(), SYM(m), false, false));
#line 142 "./runpath.in"
  addFunc(ve, run::gen_runpath18, primInt(), SYM(length), formal(primPath(), SYM(p), false, false));
#line 147 "./runpath.in"
  addFunc(ve, run::gen_runpath19, primBoolean(), SYM(cyclic), formal(primPath(), SYM(p), false, false));
#line 152 "./runpath.in"
  addFunc(ve, run::gen_runpath20, primBoolean(), SYM(straight), formal(primPath(), SYM(p), false, false), formal(primInt(), SYM(t), false, false));
#line 157 "./runpath.in"
  addFunc(ve, run::gen_runpath21, primPath(), SYM(unstraighten), formal(primPath(), SYM(p), false, false));
#line 162 "./runpath.in"
  addFunc(ve, run::gen_runpath22, primBoolean(), SYM(piecewisestraight), formal(primPath(), SYM(p), false, false));
#line 167 "./runpath.in"
  addFunc(ve, run::gen_runpath23, primReal(), SYM(arclength), formal(primPath(), SYM(p), false, false));
#line 172 "./runpath.in"
  addFunc(ve, run::gen_runpath24, primReal(), SYM(arclength), formal(primPair(), SYM(z0), false, false), formal(primPair(), SYM(c0), false, false), formal(primPair(), SYM(c1), false, false), formal(primPair(), SYM(z1), false, false));
#line 177 "./runpath.in"
  addFunc(ve, run::gen_runpath25, primReal(), SYM(arctime), formal(primPath(), SYM(p), false, false), formal(primReal(), SYM(l), false, false));
#line 182 "./runpath.in"
  addFunc(ve, run::gen_runpath26, primReal(), SYM(dirtime), formal(primPath(), SYM(p), false, false), formal(primPair(), SYM(z), false, false));
#line 187 "./runpath.in"
  addFunc(ve, run::gen_runpath27, realArray(), SYM(intersect), formal(primPath(), SYM(p), false, false), formal(primPath(), SYM(q), false, false), formal(primReal(), SYM(fuzz), true, false));
#line 204 "./runpath.in"
  addFunc(ve, run::gen_runpath28, realArray2(), SYM(intersections), formal(primPath(), SYM(p), false, false), formal(primPath(), SYM(q), false, false), formal(primReal(), SYM(fuzz), true, false));
#line 235 "./runpath.in"
  addFunc(ve, run::gen_runpath29, realArray(), SYM(intersections), formal(primPath(), SYM(p), false, false), formal(primPair(), SYM(a), false, true), formal(primPair(), SYM(b), false, true), formal(primReal(), SYM(fuzz), true, false));
#line 250 "./runpath.in"
  addFunc(ve, run::gen_runpath30, primPair(), SYM(extension), formal(primPair(), SYM(p), false, false), formal(primPair(), SYM(q), false, false), formal(primPair(), SYM(p), false, false), formal(primPair(), SYM(q), false, false));
#line 261 "./runpath.in"
  addFunc(ve, run::gen_runpath31, primInt(), SYM(size), formal(primPath(), SYM(p), false, false));
#line 266 "./runpath.in"
  addFunc(ve, run::gen_runpath32, primPath(), SYM_AMPERSAND, formal(primPath(), SYM(p), false, false), formal(primPath(), SYM(q), false, false));
#line 271 "./runpath.in"
  addFunc(ve, run::gen_runpath33, primPair(), SYM(min), formal(primPath(), SYM(p), false, true));
#line 276 "./runpath.in"
  addFunc(ve, run::gen_runpath34, primPair(), SYM(max), formal(primPath(), SYM(p), false, true));
#line 281 "./runpath.in"
  addFunc(ve, run::gen_runpath35, primInt(), SYM(size), formal(pathArray(), SYM(p), false, false));
#line 290 "./runpath.in"
  addFunc(ve, run::gen_runpath36, primPair(), SYM(min), formal(pathArray(), SYM(p), false, false));
#line 314 "./runpath.in"
  addFunc(ve, run::gen_runpath37, primPair(), SYM(max), formal(pathArray(), SYM(p), false, false));
#line 338 "./runpath.in"
  addFunc(ve, run::gen_runpath38, primPair(), SYM(minAfterTransform), formal(primTransform(), SYM(t), false, false), formal(pathArray(), SYM(p), false, false));
#line 362 "./runpath.in"
  addFunc(ve, run::gen_runpath39, primPair(), SYM(maxAfterTransform), formal(primTransform(), SYM(t), false, false), formal(pathArray(), SYM(p), false, false));
#line 386 "./runpath.in"
  addFunc(ve, run::gen_runpath40, realArray(), SYM(mintimes), formal(primPath(), SYM(p), false, false));
#line 395 "./runpath.in"
  addFunc(ve, run::gen_runpath41, realArray(), SYM(maxtimes), formal(primPath(), SYM(p), false, false));
#line 404 "./runpath.in"
  addFunc(ve, run::gen_runpath42, primReal(), SYM(relativedistance), formal(primReal(), SYM(theta), false, false), formal(primReal(), SYM(phi), false, false), formal(primReal(), SYM(t), false, false), formal(primBoolean(), SYM(atleast), false, false));
#line 409 "./runpath.in"
  addFunc(ve, run::gen_runpath43, primInt(), SYM(windingnumber), formal(pathArray(), SYM(p), false, false), formal(primPair(), SYM(z), false, false));
#line 414 "./runpath.in"
  addFunc(ve, run::gen_runpath44, primBoolean(), SYM(inside), formal(pathArray(), SYM(g), false, true), formal(primPair(), SYM(z), false, false), formal(primPen(), SYM(fillrule), true, false));
#line 419 "./runpath.in"
  addFunc(ve, run::gen_runpath45, primBoolean(), SYM(inside), formal(primPath(), SYM(g), false, false), formal(primPair(), SYM(z), false, false), formal(primPen(), SYM(fillrule), true, false));
#line 424 "./runpath.in"
  addFunc(ve, run::gen_runpath46, primReal(), SYM(orient), formal(primPair(), SYM(a), false, false), formal(primPair(), SYM(b), false, false), formal(primPair(), SYM(c), false, false));
#line 438 "./runpath.in"
  addFunc(ve, run::gen_runpath47, primReal(), SYM(incircle), formal(primPair(), SYM(a), false, false), formal(primPair(), SYM(b), false, false), formal(primPair(), SYM(c), false, false), formal(primPair(), SYM(d), false, false));
}

} // namespace trans
