# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gtk.glade import XML as glade_XML
from ConfigParser import ConfigParser, DuplicateSectionError
from base64 import b64encode, b64decode
from os.path import join
from os import getcwd

class Config:
    def __init__(self, plugin, config_file, get_configuration):
        self.plugin = plugin
        self.config_file = config_file
        self.get_configuration = get_configuration

    def save_config(self, name):
        if name == self.plugin['name']:
            entry_username = self.conf_widgets.get_widget('entry1')
            entry_password =self.conf_widgets.get_widget('entry2')

            username = entry_username.get_text()
            password = b64encode(entry_password.get_text())

            configparser = ConfigParser()
            configparser.read(self.config_file)

            try:
                configparser.add_section(self.plugin['name'])
            except DuplicateSectionError:
                pass

            configparser.set(self.plugin['name'], 'username', username)
            configparser.set(self.plugin['name'], 'password', password)

            configparser.write(open(self.config_file, 'w'))

    def configuration(self, args):
        (name, widgets) = args
        if name == self.plugin['name']:
            # Load the glade and put the vertical box in the module's
            # configuration one
            config = self.get_configuration()

            self.conf_widgets = glade_XML(join(getcwd(), 'plugins',
                                'jabber', 'configuration.glade'),
                                'vbox1', domain='bluemindo')

            hbox = widgets.get_widget('hbox2')

            try:
                kids = hbox.get_children()
                hbox.remove(kids[2])
            except:
                pass

            hbox.add(self.conf_widgets.get_widget('vbox1'))

            entry_username = self.conf_widgets.get_widget('entry1')
            entry_password =self.conf_widgets.get_widget('entry2')

            entry_username.set_text(config['username'])
            entry_password.set_text(b64decode(config['password']))