/*!

\if MANPAGES
\page dcmftest Test if file uses DICOM part 10 format
\else
\page dcmftest dcmftest: Test if file uses DICOM part 10 format
\endif

\section dcmftest_synopsis SYNOPSIS

\verbatim
dcmftest file...
\endverbatim

\section dcmftest_description DESCRIPTION

The \b dcmftest utility checks whether the files specified on the command line
are DICOM files in part 10 format (with meta-header).

\section dcmftest_parameters PARAMETERS

\verbatim
dcmfile-in  DICOM input filename to be checked
\endverbatim

\section dcmftest_notes NOTES

All files specified on the command line are checked for the presence of the
DICOM "magic word" 'DICM' at byte position 128.  No attempt is made to parse
the complete data set.  For each file the test result is printed to \e stdout
in the form "yes: <filename>\n" or "no: <filename>\n".  The utility terminates
with a return code corresponding to the number of files found to be non-DICOM,
i.e. if all files pass as DICOM files, the return value is 0.  This behavior
is intended for use in shell script programming.

\section dcmftest_see_also SEE ALSO

<b>dcmgpdir</b>(1), <b>dcmmkdir</b>(1)

\section dcmftest_copyright COPYRIGHT

Copyright (C) 1997-2024 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
