/* ----- decode/953x2115, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_953x2115_checksums[] = {
  "39b5338022fa2952cd9c3c6db7835107bc32c4575da8efdac2a776fd4c0f02ed",
  "2d52fd93fb72fb5224486467d1bfda7fb00feceec559befba17736f00b93f304",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_953x2115_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_953x2115_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_953x2115_ITEMBYTES

static void *storage_decode_953x2115_x;
static unsigned char *test_decode_953x2115_x;
static void *storage_decode_953x2115_s;
static unsigned char *test_decode_953x2115_s;
static void *storage_decode_953x2115_x2;
static unsigned char *test_decode_953x2115_x2;
static void *storage_decode_953x2115_s2;
static unsigned char *test_decode_953x2115_s2;

#define precomputed_decode_953x2115_NUM 4

static const int16_t precomputed_decode_953x2115_x[precomputed_decode_953x2115_NUM][crypto_decode_ITEMS] = {
  {1569,-2460,567,-897,1788,1440,2379,411,2679,2856,-291,351,-1143,-1482,-330,-2376,1716,417,-1824,138,2502,1758,-405,-2160,2172,1671,2334,-2160,-2433,-1632,-2832,1446,612,-630,1422,-2385,-2532,-1629,645,-1560,1626,915,-2613,-2136,1881,2715,-399,-522,-2976,1290,2343,-918,-1593,1743,666,-231,-882,-2127,-2568,1494,-453,2883,2139,-3,-1470,1932,723,2247,378,1701,1509,2952,528,-99,2526,1692,1467,2379,-1863,1371,-183,-2175,1128,858,-1752,1587,-3030,-2187,-1554,2883,1146,-2295,-612,969,-2871,486,-993,1971,2898,477,-1071,552,2514,-759,-3087,573,1227,222,2961,1452,-3111,2802,-2805,975,-996,-2004,-576,-2931,-1956,-621,2943,3000,375,-1482,-327,1152,309,1914,1050,-120,3153,1557,1266,-1338,597,2946,1233,-855,-2202,255,-1032,1626,-2268,-570,1680,1527,1344,150,579,2997,-105,-852,2283,-117,-1200,954,1569,2343,1713,-1578,150,-2085,24,2715,2682,-87,-564,-2562,-969,1566,-354,2649,-1221,3051,2286,-1362,-2067,-2892,-249,1002,3129,-2913,-2940,2259,447,-567,-915,1593,834,660,555,1434,309,-1350,1095,1617,1068,2697,-1401,1608,960,-1623,1737,-2940,1857,2643,915,-885,-1878,894,-2037,-888,1371,-543,-3102,-2055,-2406,-1839,2937,-1257,930,1722,-912,804,-1083,-2493,2034,1716,2451,-1890,-543,1779,3123,-420,-411,-693,960,-2520,48,-2505,2115,2700,-2877,1905,-1665,2808,-1680,1413,2919,705,-1617,-3135,-2046,1665,-2421,-2556,591,2478,-648,-1440,-3033,291,2115,1215,-2241,-2670,3060,-1755,2427,-333,1518,2901,-2898,-2424,1872,2388,-339,-2133,9,1377,894,-2613,-2529,186,-783,3123,246,-408,-1515,36,2148,789,1848,-1908,-2529,1872,1458,-2055,-1494,-2151,-1080,2886,-2796,-1632,-1743,-72,2106,-1677,-2742,1029,-2742,867,168,1098,-432,-87,555,-1281,-1461,2256,-228,1608,-3009,-408,-2433,-3030,1860,-3141,-1632,2199,-720,2847,1524,-2367,-2802,-2025,2793,2103,-2613,273,-1818,504,717,-1047,-2901,-834,267,2835,-1338,1638,-2379,147,918,-402,-552,855,-522,2538,-456,-2199,1296,-2076,-213,-1923,-702,-483,39,-2694,-69,-3081,1275,-3168,-1704,-735,-2526,-537,1239,-2928,3063,-2292,2235,-2958,1779,-2385,474,2502,2145,939,-2847,-1497,2253,312,2004,-603,-1059,-1269,1962,228,1566,1857,474,2481,-2814,2394,-516,2235,2595,-594,2301,-1113,1926,-453,1431,510,-2244,2121,-2445,1779,2616,2925,1266,3075,-2382,-237,-2937,-3159,-87,1419,3063,-2604,1203,474,2139,2676,3108,-258,-2355,-1272,1899,-288,-1272,-1287,-930,1761,1989,-135,615,-2442,336,978,-1689,-2034,558,-1623,-2646,1728,93,-2442,258,906,-2793,2478,-1530,-1401,-1440,408,-396,-2133,-3138,-1062,-1929,-714,-1206,729,-981,-1656,27,2568,-2031,-1176,-120,-3030,399,915,-2070,-759,1800,-3141,2196,-2751,2169,-2922,168,-1416,-2736,-3129,-3129,-2874,903,1308,-2085,-2784,-2478,690,120,-2547,-786,-2343,1875,-681,-3120,-252,-2226,-2034,-1236,1119,-807,-276,1398,2154,321,1218,-1407,909,714,-741,1338,-372,2241,-3159,1533,1683,2607,-1479,-1164,-1044,2967,-2946,2607,2112,201,2676,2208,1263,-2229,-441,1824,-2169,2157,-2856,-2247,945,-2784,2247,2559,1689,-1908,-3150,2544,-357,-1557,-1755,-414,1137,2658,-1719,249,984,-1875,330,12,1206,-2220,3048,-1575,2451,-414,939,570,351,1938,2676,1470,-2895,-876,-492,-2112,1695,2772,-2682,1083,27,39,-1707,507,-2703,1605,2352,-663,2127,627,363,-2187,-1422,-2373,1740,2010,1497,159,1278,48,-2985,-2112,1272,1881,1110,-1311,-2409,2238,2325,2508,2031,369,468,2010,909,1089,2877,2895,2421,-1875,-3150,3141,1152,1380,-1575,396,405,-1755,507,1137,837,2529,-1536,2292,-2790,1899,-1500,1344,273,-924,1101,-1890,-834,-2013,-717,-2865,-1866,2469,-3129,1560,1878,207,297,-1443,-99,2061,-621,-1386,2307,2541,-3087,861,66,3120,-1050,2664,-2943,2133,-1680,-1236,1374,-3159,-2991,1467,-2136,1026,-2154,-1953,-651,3072,1242,-3132,3030,816,1287,2724,267,579,-2682,-2361,2778,57,3060,843,1404,-360,69,1497,2499,-2076,1566,1305,-1455,-3039,-885,945,-1773,-1803,1590,-843,-1266,-1770,-471,2841,-1491,-2085,-165,-1701,531,-1092,468,-1254,-2343,2985,2514,123,3027,1101,42,-1101,-2943,-3171,2637,-2142,-1800,-3000,-2820,1863,1653,1269,-2913,-174,3108,-1461,-600,-2484,348,-2040,2904,-510,-1158,2967,1032,-1977,-2130,-207,-444,2106,2817,-927,-3048,-2937,-2955,2763,-3123,-2589,-2211,2694,-3063,-132,-414,-1134,-948,1092,-1140,-1488,3027,2820,2376,3108,-2856,-2247,1149,-2985,-2118,-750,-861,2418,-2901,-564,-2271,-228,-1737,-2643,-2997,2313,-1107,312,-1560,-1959,-2841,-1299,1443,1728,-2313,-1821,465,-153,696,2016,2715,1887,-2961,-2685,-1560,-36,-1005,-2001,-1122,-2703,-1245,-936,-1449,-1476,-1794,-2493,-174,2484,2070,1506,828,1869,354,-543,897,2619,-2208,-1236,1755,-1548,-2991,2979,681,-2139,-1431,-2424,-2709,2448,2913,-675,-261,2430,441,2880,-2010,387,-2754,2334,1641,-1149,-3141,30,-1581,-297,-3093,-3102,-603,-2352,609,-54,2955,2061,-1605,-2265,2841,-477,642,2517,-2187,-561,-12,1782,2250,-1011,1353,-2970,2805,-702,-2976,1293,-144,114,-2091,-1242,39,-1194,816,-2328,2166,-579,1812,1905,2376,-963,381,-1218,-1020,879,-1944,2808,-2718,1971,2004,3027,1470,12,-2394,-852,-2835,2640,-885,-363,234,-597,-3144,3102,1167,-3045,1188,-2616,-804,3030,-2994,-3048,3045,-1002,-2964,-2160,-279,1428,2658,1005},
  {1389,1158,-750,2667,-3102,-3135,-291,363,3012,-1875,1815,2829,-1002,2082,-2088,-1668,-2346,-2460,93,-342,2586,1470,-2496,2865,87,-2535,384,2733,2097,-948,1611,-969,2112,-810,-1017,1905,-345,522,-1425,-726,-984,1104,1527,-2382,900,-177,-2781,-1248,330,1935,1452,-2304,-117,750,-1623,-2925,159,-1935,-840,609,-2514,-276,939,2898,681,-597,1866,1533,1206,-1629,2655,3039,-1878,-1470,-3162,-2565,1218,1548,1494,234,-1173,2604,909,2661,-1401,-2880,-2706,1998,2328,-1761,447,-1797,2982,-2361,2535,-1857,-813,1293,-201,2193,-1194,-3102,-1431,-3069,-1863,-2247,48,-807,-225,-2292,-912,3036,-2160,-813,-201,-2517,-810,1515,3135,-657,-1254,3120,2736,99,-2430,96,-2211,-678,-2298,-324,-3138,1134,-1329,-1440,1554,150,-1989,-699,2439,-1875,1605,-1665,1557,84,-1323,2631,1677,-3,-2349,-2655,2979,1167,-2598,1833,702,-2013,2001,-336,-1545,-2904,-2739,1293,-2778,1176,2541,2061,2199,2766,-27,-2289,-1002,2334,-2238,-2277,921,1362,-2619,-2973,-1638,-1302,1863,-1668,1638,-1752,-1179,2319,-1116,615,-90,1878,-2907,-198,-156,-357,-2352,1368,2718,-2745,237,2283,-807,378,2451,-1050,2757,-1131,-2928,2268,3156,-1290,-2415,-1179,1851,1824,-1308,1371,1974,645,-2229,-129,423,-1074,2706,-2661,-1701,2085,-1347,1182,-2508,-342,-996,-2436,555,354,1203,2088,-813,-2271,-1812,3036,2427,-1701,1032,-2232,1707,2835,1788,2517,2724,-858,-3024,-2505,-954,-906,-1950,306,-903,3081,-1068,795,1563,-2712,-2664,1848,363,-1494,-291,1854,-1134,258,-1926,2148,-2880,1908,2520,1449,939,-423,2526,-1350,2664,606,279,150,3048,2880,1542,1479,-1437,1572,-2958,1944,330,1890,156,-2223,696,1959,1962,1509,-831,1401,-648,996,-969,-474,2550,-1185,177,-2040,2139,732,-813,1137,2511,-1002,-2289,-2562,2817,1584,2211,2352,1218,-246,-2949,2223,-1338,-2127,1347,-2202,1326,-1242,-2982,96,-993,1425,360,1959,3060,2373,2706,3042,-2418,-978,-2571,1950,-1050,2619,1455,2487,-2553,-870,-585,1476,-1329,1278,-1500,2313,2577,3048,2139,-1302,99,-1164,-996,546,-2724,2553,1572,18,-480,879,3165,-2445,-2901,-1527,1035,1650,2466,675,-60,-2799,1086,-2133,6,-1815,-2577,-3054,1119,-3036,-1260,2052,-2052,1935,1278,1050,1725,2403,723,2955,2682,1845,1623,-120,9,123,2229,-2223,-2046,-2247,2730,1497,2214,2418,2325,927,-2901,-3105,1065,-756,-237,1947,1350,1146,-1374,1479,1359,1497,-2409,-558,1458,2859,-2802,-2781,90,-1275,810,519,2970,-3075,630,-918,-609,-1182,699,3072,-1239,-447,-291,-870,1530,-240,2760,2541,-1269,-1716,-2175,2829,2715,-819,1929,-708,-129,-1521,129,2286,-2211,-1395,-2925,1500,-3096,2685,978,1182,2925,2136,-171,1635,1167,-2697,2604,-2562,2061,2979,954,-1116,-198,2862,2016,249,2871,309,2349,-1968,-2370,186,1500,-1323,1731,1872,2373,-1869,-1959,1830,2370,-1008,-2613,2043,2820,-2175,1926,-69,-630,-2385,393,-1428,-1428,2997,-609,3069,-2502,1080,-2415,3141,2064,2049,-2979,1977,714,2880,-2841,2616,1212,2220,-2139,-2067,2703,504,-1464,-2238,2304,411,-1986,2763,2085,1077,-1137,801,2415,-2664,-435,-3012,1695,72,897,2511,1548,-273,-2223,2283,2943,1431,2109,714,-1980,987,711,2925,-1203,-204,1296,-2955,-2028,1092,-705,2610,150,-2865,-96,-138,2175,2100,-1941,-3168,-228,-1590,-1071,3051,1191,2313,-1599,2790,2805,2166,-342,132,-306,-774,2358,2280,-2637,1677,-2601,-1386,-2733,705,1662,-771,1527,-654,-831,2781,1671,2058,1401,1104,-2484,-1752,-2511,-738,1485,1869,-3033,-1695,-1041,-1245,147,2187,1248,2511,1620,2379,945,-3027,-2742,-1098,66,18,-177,12,1947,-2712,3132,213,-2688,-1755,-786,-2151,174,1791,549,588,-2217,990,930,-393,1224,387,2520,-1812,-2127,57,-276,456,-126,-2046,96,-1563,2595,2409,-1995,-2826,-1548,-2805,801,2367,-1542,-2751,-1581,-1599,-2013,-3027,-1044,-2775,3078,-63,135,-2976,315,-621,-1992,774,-1815,-2196,2247,927,-627,567,1044,2649,-1215,-2100,-684,-156,1545,-3132,-2661,-96,-1446,-1089,1605,1602,-1005,1014,1905,-3150,2526,486,-1047,-657,-1182,-1917,-2502,921,54,-234,-2139,366,-393,1695,-849,2637,-591,1902,948,3087,1389,15,-3033,-1185,870,1017,-864,1494,-2814,582,2520,2814,531,-1842,873,-126,-2667,2013,-1305,-2217,2310,-2844,330,-2076,-1896,900,-1917,2355,-2169,291,429,255,2127,765,1080,-198,756,1734,-1518,435,3171,-1209,-1542,297,1935,-2823,-1170,-342,1992,2730,345,1026,228,1512,81,2934,-2970,1788,591,1443,2511,-3126,2310,-2436,1827,-1416,2268,-1683,759,-21,2409,2865,1113,-1719,2004,-2889,2469,-669,2364,-813,-2127,2964,-294,-3138,-1842,2454,1998,69,-1146,-1755,486,-2844,120,-3090,-882,1584,-390,-1050,3069,2232,-957,3165,-1626,1188,966,-660,-333,-1608,1086,843,1896,-2298,2460,-2979,-2862,519,-1356,-546,2247,1464,393,-1620,-2832,1164,-150,-183,1131,-2061,1788,-1647,483,1947,3096,807,1473,645,-2580,-477,681,1212,2835,660,-495,-1731,-216,2451,2334,741,408,-2745,-396,-3165,1854,-2607,2346,-1494,1203,1038,-2598,1509,-156,-1251,-63,1917,327,-1002,-2052,-2346,1401,-648,-372,2865,-651,-600,-2973,-2850,-1278,-1194,687,-2928,-3147,-2154,669,-1728,1125,-1953,-1056,-2943,-2235,-3171,2298,-597,3099,2940,2238,-753,1449,-504,-591,393,1917,-1710,414,1212,2544,2136,1941,234,2334,-870,-2244,2577,2538,2139,-2250,198,-2670},
  {2886,-621,-309,141,300,2541,-2610,2118,1866,3015,-27,-2286,2970,21,399,414,993,1626,-1785,2766,-2400,1995,-477,-1479,-189,-3147,-459,-1137,2733,-1275,2256,1158,-1878,-1056,-1290,-1818,-2895,951,87,498,-3033,-2808,1035,-2838,1647,-2181,864,-984,-1080,-1035,-861,609,-1974,2244,717,2625,2685,-1863,-2061,2481,2523,-75,1041,2037,2529,-1167,2382,2490,-1569,-402,-1389,-2373,-2730,-276,-2604,-1848,1374,1779,483,2145,-9,-249,2838,2466,909,2550,1539,1848,132,2925,-1638,-417,-1662,93,-1341,1752,-2295,33,-426,339,2028,-3051,-2970,390,738,3165,1104,-3081,-1791,-2778,1851,2124,-1479,-3060,-318,2550,3003,-2382,858,-1974,-552,-1179,393,-348,-1137,-1188,558,-294,1464,1233,-2502,-2739,-2835,540,-2964,-1812,-261,-2814,-900,744,-2340,420,861,-2778,3021,3141,-2952,552,-1527,-2250,-1974,1056,-2607,447,-1266,-1089,-330,-1266,-2223,-738,306,2613,-2121,-2301,1866,2013,-1602,1698,666,-2535,1221,408,1122,-1389,0,-1473,2193,-969,-1389,600,-2586,-279,-852,-939,2379,-1488,3069,102,1542,720,2874,-3153,-2592,1542,-1950,-2571,186,-2298,-2841,-750,-1839,-381,3054,-2538,-1395,312,-930,2484,-951,-1650,-156,882,1596,1689,-3156,2730,1923,2484,-1788,-2172,1854,2730,198,2763,2229,-1185,594,1485,1437,-1086,1080,276,1290,1707,-1968,-645,-2475,-888,480,-492,-1374,-108,2904,-978,2511,-2655,1320,2877,39,-1632,-300,-2589,-2220,-1665,558,1155,-750,-2610,-2889,-2220,2457,387,-1968,3126,-1161,45,-1791,756,-648,-1089,2832,-2256,-333,-1035,-273,585,2034,-2121,-3063,1587,837,1251,-2562,-2715,-1224,2463,-870,666,-1533,2283,1095,570,-1314,2115,-1464,2445,762,-2592,-2652,1113,981,741,-993,-141,-2439,-2538,-849,-201,-1545,-36,-1326,2538,-1662,-2730,1545,-2439,2181,-318,-1242,732,-2976,1821,-2499,867,2652,-1014,351,-759,72,1392,-2166,-2649,-366,-2700,2445,2550,2358,-1257,-894,2496,-519,282,2838,1014,-792,2865,1728,-663,-2253,-963,-1386,2397,-747,1671,-1887,-2844,1107,-1566,885,2637,-2391,-1353,981,1074,462,33,-192,1302,-2058,-1617,1218,2526,-1050,1242,-2265,-2265,-948,303,-2913,-1548,-1326,2832,753,-390,51,-3042,726,-2109,1902,-2715,-1587,2202,1275,1128,1662,-1419,1380,-1521,1719,1077,-1467,-18,-2781,315,-1929,2448,-648,-1818,-2442,-279,-1137,-552,-1881,2388,2817,-930,-627,-1440,438,-1671,1722,-1914,210,1569,165,585,690,-1041,-2607,1128,-3066,-1854,-2580,-978,-3036,-435,1500,-1038,-510,-2814,-2196,3000,1209,3063,2379,192,-585,-1716,-3111,2337,-2217,-123,630,999,-2877,540,-1479,-81,-2343,-753,2778,1224,-2820,2277,-1350,2490,-255,-1176,2607,291,-51,-450,2049,-1152,588,9,-1035,3111,1608,1134,2274,3105,-2667,-1332,2808,327,-1008,2031,-2004,2883,-2277,-1332,36,-1503,1983,-1314,-312,1209,-1737,1437,-36,-2796,-2847,3144,-2295,-603,-2565,522,1104,1902,-156,-174,-1287,-885,-585,-657,2322,2907,120,-1908,-2457,2745,1329,-2277,1839,1587,-837,1767,2817,-3069,1731,-2277,1041,2169,-963,2130,546,-1236,-939,423,2733,876,342,-492,2673,-321,2202,2385,-1485,-249,150,1086,-2802,3099,-3156,-111,-2298,2493,2517,-891,1077,-531,-2058,-1251,-2571,750,-2202,-12,1917,1695,2109,2637,-90,1536,1890,1530,-1395,3054,570,-168,-1866,-186,783,-999,-555,-606,570,-1347,2031,-546,-2949,216,-2052,-1578,-3123,-2037,918,1926,-1347,2973,864,1533,3,2532,-570,2292,-2586,2133,-876,369,-2781,-231,-2346,-1743,-1779,-1824,2640,-3159,957,1989,-2178,-906,-2115,-1875,3156,-1140,-1917,570,-1326,-1605,2925,1443,951,1860,-1317,-1554,-96,2238,963,2946,1701,-1581,-2502,2463,1719,1626,321,-2004,-1119,2967,-1152,1014,-1992,2799,-3036,-2616,1194,-2730,-1956,-2496,-2634,-2184,-1848,-465,-1074,2517,-1575,1926,-255,-711,789,-3105,2517,-915,-297,-288,1365,-1437,-1509,-2400,1512,369,-2988,-2220,1401,-2811,1680,-2271,2961,2733,2952,3129,-1230,-1257,-1680,-9,1815,-903,-1827,-1605,-1887,345,2712,1764,3018,-2073,-1020,2721,1164,-9,-1599,-2079,2229,-2016,1353,-1683,-984,2373,-1869,723,-2748,2643,-600,-630,-1386,2238,999,-2112,2187,-36,-2817,495,2880,-2754,1266,744,-1800,2523,-1491,669,1875,243,-30,2313,36,801,642,-804,1308,3117,-372,-1986,1695,-2835,864,2043,168,2124,-2544,1086,-99,-513,-414,561,-984,-393,1557,-987,-2745,2130,1827,1410,2001,-2091,-339,2784,1281,-1359,456,-1164,2058,-1938,21,585,-2658,-1677,-2484,1305,1146,1125,-1440,2562,1149,2562,2022,3033,2958,-1314,-1980,1830,-1254,1224,-798,-2058,3138,-426,1485,978,-495,-1584,2280,933,3117,-735,1875,2703,6,1962,993,-2709,-474,1659,2361,681,2508,-1668,-309,-351,-1902,-1479,-2070,-669,-333,-210,-1713,1914,2949,1335,2100,2529,-585,-981,-2829,-1566,894,648,804,-450,-2454,1341,-1134,1449,-1548,195,-2571,-957,2529,102,-99,-2469,-1050,3108,-1908,2106,-1404,-2001,-2352,732,-2949,-2433,-2712,336,3006,-1104,-1428,-2040,1623,-6,-123,777,546,2487,-387,-621,1512,90,3162,-405,-2625,-1959,-267,-1347,876,9,780,1803,1233,-2535,-726,-174,-1332,-2988,-1788,-3066,-162,-999,-2235,-2295,-345,306,-2727,1476,-2943,252,1683,957,684,-72,-2721,-1236,24,2238,-2610,-3057,-666,951,2595,402,162,2868,-945,2229,-1632,2874,-129,1041,-1932,-3069,-279,-3123,2229,1173,-2817,-2781,1569,2964,600,519,39,105,3045,2580,-3123},
  {825,-2871,963,2979,-1932,1836,2103,3018,-2562,-1971,2874,2268,-1560,303,-540,1419,1209,1680,729,-1524,-2436,-2514,1128,-2445,3060,984,1050,2073,-1308,2385,-2394,168,-2484,-2571,-2430,561,2037,1224,-1887,-798,-201,2478,2793,-1956,2463,75,180,-1749,2184,-2988,-2559,1050,-282,843,-1263,-1629,738,2037,-1161,2763,111,-1053,2166,-1173,-2430,2442,267,3030,975,2016,-300,-1266,2463,-69,2514,-1422,-2922,2814,-2511,-303,-2805,153,321,-1554,618,1881,-3093,2343,-222,2121,-264,-2781,-1653,-2604,204,-297,-2802,1014,3093,-1752,-1197,-3162,-1422,-726,-2481,2385,-231,-1005,-1044,2034,705,870,897,3021,2790,1188,186,-1947,39,-1257,2529,759,-2484,1293,-369,1002,-2433,-2922,-1806,-2754,-582,-3093,2625,1047,-408,36,1677,-1137,2781,-2436,-2868,102,2493,1620,-498,-321,2436,1575,2490,-3033,-450,-2754,678,-2499,1596,-2253,-2508,-1230,-339,153,288,1809,2526,-3075,-375,2688,222,1413,774,1494,1869,2295,3003,-1512,1917,1719,1743,-714,-2364,-561,3105,2538,-1959,1011,2892,1140,603,-477,1683,3006,-2271,-2757,-1206,-1170,537,-708,-1137,-1788,-1893,2796,342,1725,1326,-3171,1215,1530,2124,930,-1617,-285,432,2070,-1071,-2082,2934,1938,2322,729,-2457,-327,-2301,456,-2817,372,-1494,-2220,3036,-2298,-2295,1803,-2682,-1869,3063,3,1908,-861,-2241,441,-519,-3075,54,1305,2337,2283,1989,-1704,2106,2517,-2682,-2961,1410,402,-1695,222,-1713,1170,123,-849,-2019,912,-798,1929,-633,-2214,-249,1176,-1863,1824,-732,-2313,45,537,210,1428,-2265,-246,-1773,3126,408,2283,-894,588,-1581,-552,864,3063,-2556,-402,1665,-2961,1488,-2028,1344,2742,-2928,-1863,1743,-1749,-939,-2028,-384,-1944,3165,2067,-78,-1440,-510,2907,-1938,-1323,-2022,606,-153,-2181,-3126,-3003,-1455,-546,-2766,1998,-90,1911,729,894,2217,267,645,-1050,816,-2535,2376,954,1404,2160,2976,2622,-2616,-261,-1890,-1737,291,-1209,2853,-3003,-2829,1137,-2514,1881,-2892,-450,-1617,714,-2433,573,-2199,-2610,2922,2607,2529,-2334,1008,-771,-2430,-177,1437,2799,1284,-924,-2979,1224,2703,-2235,900,2394,-198,-144,543,-2919,108,1131,-3126,2478,-1110,-972,2826,-2655,-2817,-1170,-45,-693,2019,75,-1719,-570,2676,-282,759,2877,-642,-2781,-3150,2775,279,1440,-2799,-216,-231,-1206,2574,-1815,2061,-2448,-681,-912,1845,2517,-900,-1719,-2223,2427,-9,-1677,1668,-1062,2904,-1878,48,2946,-2061,-1065,2058,-2622,-1644,-1389,-2193,915,-1320,2289,-615,-1119,-2562,-648,-237,-234,144,2382,1107,1272,-2481,-174,180,-747,-2295,3060,1989,0,-1653,-2838,-1365,1713,-1344,-741,-2346,-1413,-417,1314,1956,1455,1272,2163,726,2421,2826,-840,-1680,2283,1647,-531,3000,-2886,3072,2358,2976,-2436,1917,-744,3114,-2739,2985,339,255,2226,-1095,2682,1686,1488,87,1827,3036,1299,-2565,762,-2547,303,-2010,174,-609,693,-3144,2154,-2121,354,-1950,2367,2805,558,-1638,2721,-888,-2637,-648,-1950,-1653,-2763,3063,-1440,-1845,1293,-1854,-123,2565,1710,-3093,-3165,2079,-2529,2232,-1914,-333,-603,-1623,2817,-207,-3171,2493,-1092,-822,-2814,-2628,-1197,2697,-282,-789,-84,-1680,-1884,-3045,2400,-2313,2241,-867,-1260,405,813,270,-2214,345,-453,2439,-69,1818,2172,1446,717,2211,-1035,288,-2436,1101,2727,-2454,2439,2925,-3150,2556,-2610,2121,744,234,582,909,1734,-159,-2064,144,1068,-2430,-1200,1155,1755,1521,-948,3126,-3075,2994,-1545,-168,1251,-2637,2442,3099,1266,-483,630,-2916,-33,3126,1602,426,3099,-2058,2676,3066,1647,-2247,1521,-1260,1446,2553,-1500,-147,30,2490,3063,-2133,-1296,957,-888,411,-2019,-975,-2640,-3024,936,-2697,2160,873,684,861,162,2025,-2430,-933,-897,624,-885,-345,2913,-450,-2316,-693,267,-2049,-243,-2214,2898,3147,1599,-1935,852,-642,612,-2715,2616,183,-726,-18,-1761,1572,273,-1032,-2049,582,-1314,-939,1437,75,-996,-609,-66,2256,-105,-660,1095,2154,-2193,-378,-2505,-2439,2673,-2871,1704,2868,-1686,1986,-597,1251,669,1017,2985,-669,1083,-1911,-3150,-456,1923,-1533,-942,2700,-2715,915,504,1680,-2259,2670,-756,2331,447,2751,912,-1464,1968,-1647,1350,-1275,189,-480,-1188,1338,63,-3039,-2379,1185,-321,-2004,1581,2493,2214,-1101,3153,1602,726,2700,-1872,579,-1395,2037,-624,-1137,999,-3162,-3039,2418,2661,351,1674,2742,-1914,-888,-1545,2793,-1812,1731,1149,-357,2094,177,-474,-2082,-429,-2130,-687,-1692,-2595,-714,-2412,-819,-108,489,-1515,-1650,2622,2010,1872,-2187,60,2190,-381,993,-2295,1476,1629,-933,-2073,-2985,2781,741,-1941,2514,-1182,-1329,2802,-1425,2334,3003,3087,-2415,2244,615,-2328,-1626,2367,2517,1437,759,1791,1206,-996,-3054,-81,2658,-585,-1035,-2907,-126,-1482,-1947,795,1062,2286,2154,1521,-2382,-810,1920,-2469,-2433,-1494,-2703,2163,3054,2946,-441,-654,87,-3036,-1839,-2211,-1899,285,1965,351,54,-450,-1968,-1182,-723,654,-2496,-747,1467,1752,3144,-2574,954,114,1974,-687,-2019,744,2481,1248,-825,2334,-2139,-681,-2229,1446,0,-963,3066,1806,-2058,-2277,-2619,2448,0,-2409,-2412,-2019,2433,786,1881,2259,1104,468,-1089,2634,2094,2079,252,-1302,-534,2433,-2340,-1674,-2205,1416,1260,-1449,2934,-909,-1119,2115,411,1722,-1899,-2115,-1701,573,-723,1668,1254,-2610,714,1302,2154,492,-771,1344,-1827,1236,-1449,327,-2832,834,-2601,-648,2871,93,1809,-624,1269},
} ;

static const unsigned char precomputed_decode_953x2115_s[precomputed_decode_953x2115_NUM][crypto_decode_STRBYTES] = {
  {51,172,64,123,184,160,184,143,105,221,2,231,253,45,14,145,97,159,110,154,100,13,205,227,95,29,94,231,57,143,58,171,154,90,141,122,91,151,131,89,181,250,5,35,18,88,181,130,110,253,187,67,192,222,123,165,15,62,194,47,176,35,74,27,102,231,188,77,167,109,67,228,209,16,170,87,56,186,242,221,200,186,22,93,239,48,7,150,65,34,11,114,129,140,109,87,108,83,39,70,135,15,211,249,188,70,187,133,75,195,41,65,44,154,164,144,81,152,11,112,81,106,247,47,215,132,37,184,170,215,180,228,176,189,141,210,200,239,37,220,70,157,22,252,43,144,154,191,250,94,77,246,136,225,110,98,54,87,85,41,17,179,167,85,171,52,134,144,31,248,103,159,88,241,236,124,199,1,219,231,182,206,3,106,226,7,140,66,110,59,151,142,101,155,66,135,113,37,57,107,109,172,139,130,194,145,192,156,80,188,165,144,46,75,115,1,51,85,238,158,52,168,184,197,222,77,30,153,19,207,66,67,49,160,198,171,44,6,75,46,17,47,54,155,145,83,217,81,18,186,42,101,91,7,161,158,183,201,76,162,52,62,132,53,235,100,165,67,224,142,211,87,134,9,136,211,62,46,232,240,249,5,179,29,50,184,126,189,239,129,101,160,184,156,201,64,99,7,43,251,34,43,192,142,55,88,53,25,247,46,213,112,198,240,157,48,188,89,173,99,192,108,65,185,67,133,43,89,123,198,51,192,65,172,117,84,222,195,46,13,94,138,92,222,59,36,112,160,236,189,126,178,228,206,163,82,128,109,85,120,88,205,186,112,183,237,203,37,228,251,150,79,109,54,161,86,241,162,205,124,159,81,4,123,168,11,122,61,118,2,235,126,197,166,174,120,54,151,207,28,211,209,244,221,19,43,83,192,170,42,193,67,31,159,225,238,200,64,89,155,173,54,253,144,227,98,114,100,149,33,175,59,1,237,78,94,187,110,29,10,213,70,47,17,148,175,135,220,134,166,31,61,231,171,18,180,217,219,36,224,79,197,141,12,124,130,43,46,8,176,247,111,203,246,5,79,213,192,135,119,70,136,28,249,219,243,23,89,161,139,173,180,116,229,59,116,247,49,13,52,45,43,188,137,185,186,87,235,204,207,184,102,108,60,199,40,163,39,128,78,113,59,60,230,13,41,14,34,161,105,150,61,34,59,44,228,159,115,105,220,123,234,211,185,100,95,235,205,107,106,72,72,43,73,114,79,122,59,239,76,162,61,107,91,67,166,239,182,29,171,254,25,200,231,138,124,37,58,33,232,190,236,31,254,180,212,227,89,102,74,136,108,230,195,158,13,11,112,118,1,64,9,221,209,121,213,251,61,119,224,107,4,252,204,13,20,230,52,131,38,55,253,19,42,175,234,44,21,190,47,14,125,91,137,41,49,157,124,182,146,68,35,15,158,90,32,97,0,85,18,157,247,140,37,152,103,63,10,2,123,162,86,242,82,64,14,70,117,57,240,196,238,165,215,58,217,125,123,251,16,6,231,184,239,85,40,48,246,110,29,30,129,6,181,27,250,155,3,139,71,11,0,203,11,89,60,81,222,186,4,174,246,136,123,154,151,82,15,33,57,57,129,95,13,100,26,168,87,224,212,44,40,187,234,249,47,0,177,221,149,150,118,176,122,242,192,216,198,102,235,74,204,174,143,133,170,228,219,116,91,20,171,169,62,95,52,195,89,67,113,167,85,38,83,115,205,130,84,15,49,122,172,150,236,188,222,231,174,184,179,168,107,20,122,27,84,173,220,213,238,233,177,239,112,222,223,52,59,20,89,94,142,246,164,59,65,246,30,73,157,63,88,232,72,45,85,11,81,71,12,162,184,35,137,86,210,87,62,150,104,246,10,21,242,80,198,141,99,67,0,209,241,14,120,36,185,71,249,21,122,30,81,103,226,42,133,3,129,247,202,201,150,225,30,140,218,31,160,213,170,125,234,110,223,170,173,39,8,64,157,253,254,96,87,124,173,155,73,58,28,227,149,127,162,141,138,102,230,178,106,23,158,135,178,192,56,50,38,81,56,78,231,41,178,243,244,238,95,85,160,255,158,181,164,181,77,157,178,113,228,56,119,132,239,113,222,226,60,157,29,130,186,214,16,227,114,164,3,35,203,224,98,117,241,30,50,120,52,105,169,216,242,126,224,69,179,151,67,101,104,9,128,120,11,114,65,182,21,203,34,76,140,45,138,225,25,227,236,9,167,160,70,96,207,59,54,136,84,113,171,249,159,186,83,171,218,102,77,123,4,242,119,174,69,23,172,103,239,149,212,216,56,157,26,29,205,190,38,43,55,139,154,121,28,138,80,137,65,172,210,225,81,60,158,142,146,40,84,90,251,240,224,40,120,92,213,1,165,117,240,239,182,137,220,80,79,28,220,27,74,142,5,118,80,72,164,91,40,22,201,100,111,232,177,142,154,173,145,55,217,64,3,254,109,198,255,25,141,192,73,196,69,110,137,105,49,37,100,18,62,18,95,106,237,107,112,181,128,186,25,168,194,71,190,251,100,100,247,210,187,36,138,178,54,235,1,31,102,217,100,247,199,235,93,78,173,85,165,46,224,80,12,57,74,69,53,30,205,207,145,188,119,150,47,9,219,137,119,38,219,81,224,8,184,255,163,194,224,25,10,44,178,246,37,17,209,104,219,37,199,72,82,156,122,88,148,62,173,151,130,24,95,180,158,180,9,46,158,211,213,91,255,144,207,152,23,210,110,223,245,194,37,228,120,255,53,200,156,119,241,78,144,189,221,92,154,203,96,30,153,40,6,103,30,29,199,252,116,216,142,185,220,157,112,66,145,30,207,197,253,170,51,50,10,55,225,196,90,115,144,143,249,236,64,164,106,93,21,217,229,35,102,90,121,235,238,17,26,177,22,214,104,247,147,246,174,175,8,72,77,195,184,93,114,168,18,204},
  {153,151,117,208,59,99,14,8,29,249,238,145,24,133,136,44,26,167,13,115,96,244,117,239,186,219,177,135,203,240,84,182,218,108,162,157,219,189,147,79,204,255,243,130,127,58,69,176,1,242,168,89,11,50,122,167,42,80,205,172,106,37,207,78,146,181,239,160,57,156,88,213,20,78,225,132,102,201,32,167,105,34,24,194,177,35,140,155,43,50,148,204,173,190,16,42,130,8,210,183,152,192,42,27,80,242,109,114,133,120,112,200,7,95,236,12,225,107,136,19,82,175,247,52,250,37,189,210,130,161,156,79,105,161,224,191,50,153,94,248,154,57,31,10,146,108,176,26,22,142,116,178,75,213,17,122,15,134,105,225,0,6,190,195,224,79,239,228,10,129,20,59,53,159,201,200,254,33,12,29,173,49,14,74,138,17,247,188,124,84,181,251,107,73,12,213,213,156,62,176,177,48,91,216,176,249,208,130,86,68,196,110,77,194,171,222,155,19,156,186,159,147,37,132,114,140,33,214,170,111,244,234,95,240,125,152,150,177,68,199,136,215,100,31,80,162,173,54,118,233,75,42,124,96,236,104,96,68,187,172,53,246,132,254,231,14,33,18,204,229,166,57,120,163,117,186,22,149,72,158,26,169,55,190,252,31,205,11,9,8,130,6,20,118,9,55,147,52,247,94,232,49,208,214,39,6,181,100,7,47,105,3,230,90,159,92,71,142,159,46,213,112,228,124,220,6,119,61,107,114,36,198,66,37,202,115,35,52,197,171,172,221,76,152,137,23,225,75,160,227,139,193,197,0,135,222,153,0,7,238,247,33,89,155,26,255,241,147,98,84,211,148,150,215,198,175,15,226,221,102,129,4,25,48,111,154,251,66,93,121,36,50,231,238,8,110,166,252,128,235,55,253,105,216,130,115,188,57,19,242,235,62,152,38,170,28,165,247,51,0,80,18,128,118,1,8,34,61,243,28,21,228,129,50,167,105,25,183,95,16,128,65,219,104,173,45,40,80,125,196,210,141,9,122,105,169,188,140,218,84,131,133,232,195,93,184,48,28,209,63,249,254,40,217,235,30,46,183,0,31,166,148,86,47,166,32,48,234,29,209,118,119,35,248,232,29,77,231,85,70,206,8,221,205,234,75,152,23,177,190,65,101,225,119,179,196,93,92,182,35,186,187,164,231,53,46,92,97,242,28,73,65,4,4,168,225,65,144,158,11,159,143,57,215,112,185,42,189,129,123,111,185,65,233,254,36,247,50,10,173,112,137,205,209,75,188,222,152,103,237,169,88,100,221,139,51,5,79,154,164,205,186,221,9,194,5,138,241,26,4,21,34,97,113,214,139,216,204,190,170,162,39,119,52,182,178,171,215,179,25,76,10,123,70,231,2,176,68,29,45,192,61,242,224,204,186,192,167,115,37,107,186,236,145,104,77,108,82,149,65,181,246,109,111,41,60,23,252,61,101,199,116,63,196,177,231,31,76,248,165,248,186,48,8,28,30,137,80,78,14,161,183,11,242,78,152,195,134,54,235,18,142,81,69,71,119,81,29,0,115,178,113,211,126,144,28,106,57,57,161,251,135,68,114,139,113,237,20,225,103,157,94,235,7,113,64,116,94,22,14,253,127,219,5,108,156,233,13,32,92,182,125,237,149,79,87,226,75,112,93,159,18,250,49,224,95,138,105,195,80,233,198,232,196,168,69,170,139,22,204,208,204,184,115,84,63,146,223,70,94,230,0,6,201,189,204,108,35,171,80,2,197,104,113,134,129,185,42,248,100,213,176,226,88,108,167,83,131,66,239,157,231,229,8,236,231,216,245,64,164,87,15,158,241,235,100,147,0,41,160,116,132,99,225,43,62,74,137,90,227,206,41,168,212,123,39,162,43,74,230,114,8,13,212,185,51,194,106,21,24,81,178,94,63,105,227,243,179,160,162,155,40,112,246,105,107,64,19,51,211,244,18,203,251,99,43,9,62,28,129,79,126,115,28,211,153,172,85,191,23,124,17,227,76,7,89,109,171,236,191,199,89,110,225,15,42,57,242,147,171,67,116,240,70,57,162,193,240,227,138,218,31,165,118,56,1,173,183,73,197,253,9,175,182,72,90,21,190,10,43,108,30,181,167,232,199,169,214,173,38,28,63,242,139,149,86,166,102,59,7,40,56,57,150,55,22,217,29,223,12,38,24,218,250,243,197,202,18,225,131,77,251,207,232,157,204,130,158,91,251,217,55,17,234,193,82,137,95,172,91,68,19,115,72,218,122,32,178,55,81,88,140,138,110,36,56,154,1,185,100,71,102,90,100,174,27,118,43,244,108,30,27,223,98,6,47,11,38,129,186,218,43,149,160,245,196,67,121,68,200,23,40,34,180,219,247,27,155,168,229,244,221,181,65,123,167,148,33,1,112,55,212,54,122,221,93,160,190,6,52,75,169,207,213,64,107,146,145,185,107,236,12,7,16,84,14,27,26,94,42,107,150,201,80,201,183,234,35,245,60,91,236,17,65,50,155,137,250,52,106,30,142,72,109,227,83,17,69,50,71,235,44,126,199,39,214,154,236,102,125,83,94,195,52,236,74,255,162,191,128,21,36,91,57,93,53,140,220,5,166,82,149,67,65,238,177,53,131,194,160,219,55,38,50,175,235,73,212,53,17,44,235,6,88,13,139,95,165,46,169,70,102,97,93,252,175,99,242,144,30,249,50,203,24,131,244,74,7,246,211,107,16,151,171,28,244,30,195,229,18,228,102,106,7,7,173,70,36,176,164,59,115,136,119,133,238,151,141,126,151,233,84,203,1,60,71,35,193,112,110,30,102,165,39,2,82,91,67,58,182,111,233,215,252,193,73,146,128,207,95,80,152,3,102,139,96,217,118,207,33,147,22,144,195,16,244,89,231,131,175,0,166,64,22,156,105,111,213,230,198,208,232,166,44,203,74,41,41,61,164,149,33,254,201,64,61,134},
  {89,118,170,164,213,118,36,230,57,146,77,137,119,94,103,149,233,159,191,223,175,147,30,55,131,135,250,228,24,109,186,152,50,194,124,144,246,87,83,124,217,231,135,154,164,172,12,140,17,253,198,172,246,65,180,94,188,25,134,206,130,85,212,11,64,150,24,237,167,203,240,151,34,37,40,60,193,69,134,52,8,115,152,171,105,144,253,3,29,152,65,162,183,30,221,247,168,120,201,197,61,81,236,78,215,45,107,253,21,60,121,252,227,51,208,142,223,132,172,229,49,113,235,98,165,87,216,247,61,102,143,166,47,236,212,158,239,218,128,32,92,162,137,63,184,238,20,13,125,234,82,122,94,236,29,104,228,129,125,45,31,61,68,93,207,202,208,98,123,220,243,133,13,49,67,72,22,183,77,147,15,29,189,5,13,34,169,61,150,225,250,122,234,179,239,117,136,104,163,11,34,5,84,215,43,122,66,216,149,95,130,157,49,78,210,122,249,219,244,192,88,129,17,218,74,100,23,27,229,115,64,26,93,127,239,45,19,144,120,214,142,245,58,159,106,148,121,21,113,146,131,70,159,52,65,142,24,12,85,59,186,77,234,190,46,155,99,64,235,104,164,223,10,254,114,107,97,82,58,47,254,150,147,232,11,158,188,73,240,173,235,67,145,223,41,108,162,63,105,22,176,26,44,155,45,208,32,246,157,187,116,108,112,192,0,230,221,183,2,255,193,179,38,113,194,59,2,247,76,26,217,158,190,20,105,146,45,158,90,249,177,40,236,12,173,241,45,1,210,193,19,232,146,25,51,134,151,73,248,127,158,143,189,175,63,124,26,34,5,185,184,78,192,123,56,192,247,97,237,117,26,150,185,239,115,103,185,113,99,238,205,206,213,68,35,223,223,197,246,184,73,237,160,128,209,115,82,145,63,29,33,47,165,206,77,35,83,162,143,39,8,140,235,1,4,108,217,238,199,63,8,43,22,152,221,110,42,248,156,218,160,99,142,21,157,52,77,170,152,64,38,203,189,224,33,236,198,63,6,4,42,79,189,155,60,232,215,121,140,69,113,73,239,190,81,58,210,150,202,85,155,138,23,201,243,168,163,248,171,33,153,201,177,245,183,0,213,33,222,147,204,12,87,239,44,161,247,186,34,152,98,65,226,153,176,14,101,105,120,154,10,165,218,163,156,53,212,33,178,32,96,164,88,119,85,9,166,213,114,172,191,144,74,214,62,176,179,203,28,113,180,207,121,115,249,234,67,239,80,142,216,107,243,168,217,46,218,252,34,95,144,129,166,166,180,152,97,249,218,82,28,30,162,98,45,155,255,163,199,67,197,111,110,36,254,50,252,217,96,26,161,159,169,93,250,199,123,15,209,23,254,160,167,93,83,127,157,40,136,135,228,94,112,242,108,225,255,63,5,219,118,170,69,36,123,103,226,51,7,211,14,33,97,156,219,160,91,146,38,10,186,7,91,58,152,248,40,196,120,68,206,158,203,29,243,50,189,214,104,122,234,186,56,76,65,7,46,173,109,77,237,26,52,59,92,229,213,180,12,139,149,205,129,153,203,5,90,108,94,218,104,212,48,30,217,215,209,100,127,9,80,193,203,115,180,7,129,166,104,229,195,139,6,89,52,50,209,105,121,192,72,112,66,132,82,35,135,66,48,81,104,192,131,2,177,190,118,123,101,170,6,195,166,163,31,28,72,250,50,204,226,155,43,41,51,229,176,132,3,7,39,78,244,164,51,19,224,131,208,155,96,74,212,107,1,19,97,39,103,60,102,174,197,177,255,195,252,1,214,205,234,73,48,252,176,143,5,168,239,21,33,45,180,60,4,55,240,59,186,253,225,248,64,119,132,50,190,89,67,53,181,235,3,222,131,181,18,129,33,88,108,146,119,68,118,26,142,74,143,138,179,181,195,55,238,209,245,60,62,145,138,142,2,198,95,152,144,253,172,240,140,186,94,68,240,44,91,18,100,124,113,226,22,114,150,26,141,201,114,10,232,162,177,58,19,135,56,221,164,64,92,250,246,34,103,97,164,109,3,107,251,253,235,210,114,110,96,91,101,209,10,52,173,58,221,90,55,119,46,251,254,25,94,9,106,83,131,26,125,201,0,194,124,50,99,5,211,182,250,65,207,229,87,45,15,246,87,74,215,14,115,180,71,5,78,10,75,43,126,69,39,150,158,45,97,59,194,151,0,0,22,204,222,239,232,3,255,218,37,68,58,206,238,169,233,165,30,153,54,224,99,253,37,116,190,158,152,98,134,30,127,32,205,53,52,192,101,158,191,193,152,124,228,225,198,222,38,129,163,51,154,180,128,8,16,36,22,82,85,114,242,5,246,31,189,151,227,8,241,5,234,210,76,147,166,158,78,155,234,138,197,170,104,224,114,185,12,45,235,19,64,124,154,103,77,130,191,48,132,94,81,234,200,98,20,223,177,132,69,226,119,178,119,125,182,84,125,166,138,130,77,197,226,255,206,76,68,247,26,211,242,13,148,235,212,194,202,25,85,242,29,113,200,87,92,244,38,96,247,172,100,210,206,97,10,221,221,103,206,11,76,178,180,112,65,169,9,121,7,42,156,49,247,172,122,187,139,58,26,171,230,80,22,93,100,245,105,149,25,5,166,3,87,240,31,41,124,30,78,81,125,178,217,173,116,90,199,118,57,91,157,238,142,185,196,137,136,82,5,240,6,16,8,191,167,124,126,122,126,250,19,78,166,236,146,226,170,34,34,50,152,248,215,103,123,244,113,232,123,250,113,236,251,227,179,15,4,7,235,19,80,223,61,167,156,203,53,64,252,212,56,201,86,108,178,188,46,244,155,189,134,145,126,131,230,97,19,180,194,177,251,4,74,5,216,65,157,232,115,87,221,28,195,185,5,16,130,214,236,243,145,16,78,80,102,205,49,198,169,179,90,50,253,96,218,41,166,160,25,211,16,30,131,236,66,38,247},
  {96,63,232,45,108,222,203,154,123,233,94,138,43,97,219,99,231,52,195,188,70,18,239,212,152,186,251,110,33,199,78,236,61,117,139,38,51,78,177,136,175,200,195,25,132,242,107,80,240,254,9,105,241,49,2,153,111,11,76,216,12,205,65,133,164,98,115,185,233,209,238,129,244,101,252,215,116,98,16,219,118,194,157,105,171,93,36,81,131,241,207,53,113,27,31,239,148,5,243,75,91,27,148,79,154,197,202,80,218,0,149,125,124,161,10,236,39,47,40,155,70,78,85,6,179,231,175,174,40,126,45,218,134,103,96,131,194,231,223,239,238,53,87,145,29,172,87,21,105,131,236,127,163,63,75,230,50,226,172,197,245,150,203,15,199,10,83,84,28,52,106,211,197,224,58,161,191,116,191,20,57,114,106,254,252,103,240,255,51,121,74,117,32,137,179,131,77,227,57,50,179,175,219,5,211,151,170,36,204,13,234,101,189,185,168,253,99,251,10,153,141,5,141,29,38,61,62,108,18,131,57,2,4,45,35,224,82,220,212,11,175,42,250,178,179,206,23,55,245,66,172,117,237,129,155,180,220,254,179,237,3,224,203,78,9,199,119,189,7,62,172,231,158,125,91,120,43,191,119,176,230,114,141,46,27,21,94,202,158,72,200,81,186,161,109,18,116,82,159,78,172,54,54,97,10,163,181,101,211,226,0,163,76,170,183,206,61,63,120,155,93,175,181,191,242,2,1,214,173,220,22,103,8,95,98,89,151,78,197,110,172,31,128,214,70,88,151,89,190,69,243,204,150,71,53,10,1,48,113,8,209,214,41,54,210,62,212,49,171,71,78,25,202,226,242,147,210,186,147,75,224,196,134,170,211,148,7,135,64,172,240,241,205,252,166,27,190,20,81,53,193,246,193,158,71,202,65,39,199,157,227,205,81,80,192,54,161,161,154,57,116,22,74,182,182,240,214,209,44,169,180,238,115,45,188,245,189,190,88,22,230,36,11,156,194,192,45,209,91,62,213,23,187,8,91,35,7,151,110,140,95,38,113,234,219,66,63,202,31,103,235,44,42,27,191,173,150,108,230,24,122,130,32,240,91,34,223,173,58,202,75,19,81,249,198,36,68,200,11,30,231,79,226,95,84,253,110,148,150,72,227,236,185,148,25,37,3,100,143,193,206,37,146,101,33,167,42,7,159,203,73,137,41,82,216,238,178,140,186,163,104,108,220,3,191,100,52,218,235,60,173,27,105,56,56,218,45,238,66,57,183,145,56,224,248,79,178,65,236,101,158,128,51,217,90,1,160,236,26,120,89,90,197,65,102,16,111,36,216,99,57,201,127,236,32,158,234,52,96,3,11,240,147,16,225,133,175,149,95,98,63,195,25,231,23,194,152,96,173,119,138,231,113,220,136,122,70,173,59,1,49,115,57,23,237,44,139,148,42,105,47,185,124,46,177,89,147,125,5,224,105,255,76,121,95,156,114,118,34,54,40,255,230,128,180,74,92,88,147,72,82,181,115,65,171,81,29,47,161,18,171,20,228,254,232,148,249,105,55,106,139,2,111,231,65,140,189,45,200,222,175,113,106,1,69,183,194,84,128,62,96,198,2,125,239,207,151,252,109,239,237,141,225,213,74,2,204,242,233,243,140,74,101,164,152,39,128,88,1,208,68,133,78,174,21,32,41,245,102,10,48,242,248,0,210,31,251,108,112,222,135,107,15,196,67,35,92,141,211,128,83,166,66,127,251,166,165,7,161,128,15,186,45,52,106,45,71,246,60,213,92,83,178,70,39,195,97,10,216,113,205,168,180,210,126,7,102,64,236,108,123,67,135,58,252,89,99,65,121,22,37,149,104,153,0,102,114,107,185,61,49,217,208,217,80,47,150,171,148,185,67,128,0,103,223,147,67,11,242,97,192,213,35,23,5,120,124,85,40,47,242,233,148,73,22,103,225,40,89,20,133,251,78,116,244,91,103,191,11,31,223,144,79,59,146,202,3,172,193,196,80,146,113,159,235,114,155,54,125,101,129,152,74,112,8,43,35,117,221,128,130,31,83,76,174,27,109,89,255,139,73,93,210,223,135,167,200,93,138,72,87,17,180,14,72,35,126,110,3,149,55,106,104,163,214,21,217,36,158,36,175,108,52,193,120,94,163,157,222,201,218,197,162,172,165,95,90,238,169,81,97,12,13,176,8,210,106,88,37,163,49,63,224,69,3,179,10,50,106,45,191,231,206,50,97,244,151,4,32,224,181,218,146,48,168,138,156,88,122,9,141,204,82,236,186,60,87,24,35,52,105,162,168,67,59,196,104,170,122,244,38,187,40,3,185,248,244,141,214,174,249,159,177,252,196,179,191,178,82,87,67,206,252,145,210,133,9,129,233,186,146,137,236,233,71,83,219,43,194,243,46,34,156,242,191,50,16,146,18,167,219,174,83,235,54,18,148,173,213,235,183,8,73,35,122,84,222,108,164,155,90,62,184,212,172,95,119,56,67,202,219,234,183,180,22,14,149,4,59,175,8,150,239,222,77,110,161,11,83,104,133,199,44,97,66,0,45,255,249,132,204,137,228,1,173,16,230,254,151,13,115,84,131,211,143,51,151,234,144,195,200,205,104,195,30,11,9,24,16,151,1,117,77,146,13,120,48,204,25,99,31,206,227,249,50,25,255,238,204,233,126,17,146,151,230,231,128,247,97,244,188,81,1,233,192,28,30,227,20,43,213,204,201,122,28,89,147,120,7,42,187,46,215,139,82,14,122,3,16,29,181,252,54,189,72,112,106,32,2,190,205,35,201,15,142,201,181,193,9,217,184,212,237,60,161,181,84,185,37,8,180,251,205,159,93,88,105,15,99,28,141,52,81,244,43,211,26,43,37,63,115,115,170,54,156,15,198,100,26,226,29,231,173,134,167,196,62,187,82,92,209,16,151,135,6,109,118,44,248,225,232,41,156,206,94,182,209},
} ;

static void test_decode_953x2115_impl(long long impl)
{
  unsigned char *x = test_decode_953x2115_x;
  unsigned char *s = test_decode_953x2115_s;
  unsigned char *x2 = test_decode_953x2115_x2;
  unsigned char *s2 = test_decode_953x2115_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_953x2115_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_953x2115(impl);
    printf("decode_953x2115 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953x2115_implementation(impl),ntruprime_dispatch_decode_953x2115_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_953x2115;
    printf("decode_953x2115 selected implementation %s compiler %s\n",ntruprime_decode_953x2115_implementation(),ntruprime_decode_953x2115_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_953x2115_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_953x2115_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_953x2115_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_953x2115_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_953x2115_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_953x2115_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_953x2115(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953x2115")) return;
  storage_decode_953x2115_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_953x2115_x = aligned(storage_decode_953x2115_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_953x2115_s = callocplus(crypto_decode_STRBYTES);
  test_decode_953x2115_s = aligned(storage_decode_953x2115_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_953x2115_x2 = callocplus(maxalloc);
  test_decode_953x2115_x2 = aligned(storage_decode_953x2115_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_953x2115_s2 = callocplus(maxalloc);
  test_decode_953x2115_s2 = aligned(storage_decode_953x2115_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_953x2115 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_953x2115();++impl)
      forked(test_decode_953x2115_impl,impl);
    ++test_decode_953x2115_x;
    ++test_decode_953x2115_s;
    ++test_decode_953x2115_x2;
    ++test_decode_953x2115_s2;
  }
  free(storage_decode_953x2115_s2);
  free(storage_decode_953x2115_x2);
  free(storage_decode_953x2115_s);
  free(storage_decode_953x2115_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

