# -*- Mode: python; tab-width: 4; indent-tabs-mode:nil; coding:utf-8 -*-
# vim: tabstop=4 expandtab shiftwidth=4 softtabstop=4 fileencoding=utf-8
#
# MDAnalysis --- https://www.mdanalysis.org
# Copyright (c) 2006-2017 The MDAnalysis Development Team and contributors
# (see the file AUTHORS for the full list of names)
#
# Released under the Lesser GNU Public Licence, v2.1 or any higher version
#
# Please cite your use of MDAnalysis in published work:
#
# R. J. Gowers, M. Linke, J. Barnoud, T. J. E. Reddy, M. N. Melo, S. L. Seyler,
# D. L. Dotson, J. Domanski, S. Buchoux, I. M. Kenney, and O. Beckstein.
# MDAnalysis: A Python package for the rapid analysis of molecular dynamics
# simulations. In S. Benthall and S. Rostrup editors, Proceedings of the 15th
# Python in Science Conference, pages 102-109, Austin, TX, 2016. SciPy.
# doi: 10.25080/majora-629e541a-00e
#
# N. Michaud-Agrawal, E. J. Denning, T. B. Woolf, and O. Beckstein.
# MDAnalysis: A Toolkit for the Analysis of Molecular Dynamics Simulations.
# J. Comput. Chem. 32 (2011), 2319--2327, doi:10.1002/jcc.21787
#
from numpy.testing import (
    assert_equal,
)
import pytest
import pickle
import MDAnalysis as mda

from MDAnalysisTests.datafiles import PSF, DCD


# Legacy tests from before 363
@pytest.fixture()
def res():
    universe = mda.Universe(PSF, DCD)
    return universe.residues[100]


def test_type(res):
    assert isinstance(res, mda.core.groups.Residue)
    assert_equal(res.resname, "ILE")
    assert_equal(res.resid, 101)


def test_index(res):
    atom = res.atoms[2]
    assert isinstance(atom, mda.core.groups.Atom)
    assert_equal(atom.name, "CA")
    assert_equal(atom.index, 1522)
    assert_equal(atom.resid, 101)


def test_atom_order(res):
    assert_equal(res.atoms.indices,
                 sorted(res.atoms.indices))


def test_residue_pickle(res):
    res_in = pickle.loads(pickle.dumps(res))
    assert res_in == res
