// Copyright 2025 the Fearless_SIMD Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

// This file is autogenerated by fearless_simd_gen

use crate::{Level, Simd, SimdFrom, SimdInto, seal::Seal};
use crate::{
    f32x4, f32x8, f32x16, f64x2, f64x4, f64x8, i8x16, i8x32, i8x64, i16x8, i16x16, i16x32, i32x4,
    i32x8, i32x16, mask8x16, mask8x32, mask8x64, mask16x8, mask16x16, mask16x32, mask32x4,
    mask32x8, mask32x16, mask64x2, mask64x4, mask64x8, u8x16, u8x32, u8x64, u16x8, u16x16, u16x32,
    u32x4, u32x8, u32x16,
};
use core::arch::wasm32::*;
#[doc = r#" The SIMD token for the "wasm128" level."#]
#[derive(Clone, Copy, Debug)]
pub struct WasmSimd128 {
    _private: (),
}
impl WasmSimd128 {
    #[inline]
    pub const fn new_unchecked() -> Self {
        Self { _private: () }
    }
}
impl Seal for WasmSimd128 {}
impl Simd for WasmSimd128 {
    type f32s = f32x4<Self>;
    type u8s = u8x16<Self>;
    type i8s = i8x16<Self>;
    type u16s = u16x8<Self>;
    type i16s = i16x8<Self>;
    type u32s = u32x4<Self>;
    type i32s = i32x4<Self>;
    type mask8s = mask8x16<Self>;
    type mask16s = mask16x8<Self>;
    type mask32s = mask32x4<Self>;
    #[inline(always)]
    fn level(self) -> Level {
        Level::WasmSimd128(self)
    }
    #[inline]
    fn vectorize<F: FnOnce() -> R, R>(self, f: F) -> R {
        #[inline]
        unsafe fn vectorize_simd128<F: FnOnce() -> R, R>(f: F) -> R {
            f()
        }
        unsafe { vectorize_simd128(f) }
    }
    #[inline(always)]
    fn splat_f32x4(self, val: f32) -> f32x4<Self> {
        f32x4_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn abs_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        f32x4_abs(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn neg_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        f32x4_neg(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn sqrt_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        f32x4_sqrt(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_mul(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn div_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_div(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn copysign_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        let sign_mask = f32x4_splat(-0.0_f32);
        let sign_bits = v128_and(b.into(), sign_mask.into());
        let magnitude = v128_andnot(a.into(), sign_mask.into());
        v128_or(magnitude, sign_bits).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        f32x4_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        f32x4_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        f32x4_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        f32x4_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        f32x4_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        u32x4_shuffle::<0, 4, 1, 5>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        u32x4_shuffle::<2, 6, 3, 7>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        u32x4_shuffle::<0, 2, 4, 6>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        u32x4_shuffle::<1, 3, 5, 7>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_pmax(b.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        f32x4_pmin(b.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn madd_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        a.mul(b).add(c)
    }
    #[inline(always)]
    fn msub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        a.mul(b).sub(c)
    }
    #[inline(always)]
    fn floor_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        f32x4_floor(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn fract_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        a.sub(a.trunc())
    }
    #[inline(always)]
    fn trunc_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        f32x4_trunc(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_f32x4(self, a: mask32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x8<Self> {
        let mut result = [0.0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_f64_f32x4(self, a: f32x4<Self>) -> f64x2<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_f32x4(self, a: f32x4<Self>) -> u8x16<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn cvt_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self> {
        u32x4_trunc_sat_f32x4(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn cvt_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self> {
        i32x4_trunc_sat_f32x4(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn splat_i8x16(self, val: i8) -> i8x16<Self> {
        i8x16_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_i8x16(self, a: i8x16<Self>) -> i8x16<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        i8x16_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        i8x16_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        let low = i16x8_extmul_low_i8x16(a.into(), b.into());
        let high = i16x8_extmul_high_i8x16(a.into(), b.into());
        u8x16_shuffle::<0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30>(low, high)
            .simd_into(self)
    }
    #[inline(always)]
    fn and_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn shr_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self> {
        i8x16_shr(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn shrv_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self> {
        i8x16_shl(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        i8x16_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        i8x16_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        i8x16_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        i8x16_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        i8x16_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        u8x16_shuffle::<0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23>(a.into(), b.into())
            .simd_into(self)
    }
    #[inline(always)]
    fn zip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        u8x16_shuffle::<8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31>(
            a.into(),
            b.into(),
        )
        .simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        u8x16_shuffle::<0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30>(
            a.into(),
            b.into(),
        )
        .simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        u8x16_shuffle::<1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31>(
            a.into(),
            b.into(),
        )
        .simd_into(self)
    }
    #[inline(always)]
    fn select_i8x16(self, a: mask8x16<Self>, b: i8x16<Self>, c: i8x16<Self>) -> i8x16<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        i8x16_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        i8x16_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i8x16(self, a: i8x16<Self>) -> i8x16<Self> {
        i8x16_neg(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_i8x16(self, a: i8x16<Self>) -> u8x16<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u32_i8x16(self, a: i8x16<Self>) -> u32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn splat_u8x16(self, val: u8) -> u8x16<Self> {
        u8x16_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_u8x16(self, a: u8x16<Self>) -> u8x16<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        let low = u16x8_extmul_low_u8x16(a.into(), b.into());
        let high = u16x8_extmul_high_u8x16(a.into(), b.into());
        u8x16_shuffle::<0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30>(low, high)
            .simd_into(self)
    }
    #[inline(always)]
    fn and_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn shr_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self> {
        u8x16_shr(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn shrv_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self> {
        u8x16_shl(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        u8x16_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        u8x16_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        u8x16_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        u8x16_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        u8x16_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_shuffle::<0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23>(a.into(), b.into())
            .simd_into(self)
    }
    #[inline(always)]
    fn zip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_shuffle::<8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31>(
            a.into(),
            b.into(),
        )
        .simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_shuffle::<0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30>(
            a.into(),
            b.into(),
        )
        .simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_shuffle::<1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31>(
            a.into(),
            b.into(),
        )
        .simd_into(self)
    }
    #[inline(always)]
    fn select_u8x16(self, a: mask8x16<Self>, b: u8x16<Self>, c: u8x16<Self>) -> u8x16<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        u8x16_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn widen_u8x16(self, a: u8x16<Self>) -> u16x16<Self> {
        let low = u16x8_extend_low_u8x16(a.into());
        let high = u16x8_extend_high_u8x16(a.into());
        self.combine_u16x8(low.simd_into(self), high.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_u32_u8x16(self, a: u8x16<Self>) -> u32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn splat_mask8x16(self, val: i8) -> mask8x16<Self> {
        i8x16_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_mask8x16(self, a: mask8x16<Self>) -> mask8x16<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_mask8x16(
        self,
        a: mask8x16<Self>,
        b: mask8x16<Self>,
        c: mask8x16<Self>,
    ) -> mask8x16<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        i8x16_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_i16x8(self, val: i16) -> i16x8<Self> {
        i16x8_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_i16x8(self, a: i16x8<Self>) -> i16x8<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        i16x8_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        i16x8_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        i16x8_mul(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn shr_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self> {
        i16x8_shr(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn shrv_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self> {
        i16x8_shl(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        i16x8_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        i16x8_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        i16x8_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        i16x8_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        i16x8_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        u16x8_shuffle::<0, 8, 1, 9, 2, 10, 3, 11>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        u16x8_shuffle::<4, 12, 5, 13, 6, 14, 7, 15>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        u16x8_shuffle::<0, 2, 4, 6, 8, 10, 12, 14>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        u16x8_shuffle::<1, 3, 5, 7, 9, 11, 13, 15>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_i16x8(self, a: mask16x8<Self>, b: i16x8<Self>, c: i16x8<Self>) -> i16x8<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        i16x8_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        i16x8_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i16x8(self, a: i16x8<Self>) -> i16x8<Self> {
        i16x8_neg(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_i16x8(self, a: i16x8<Self>) -> u8x16<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u32_i16x8(self, a: i16x8<Self>) -> u32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn splat_u16x8(self, val: u16) -> u16x8<Self> {
        u16x8_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_u16x8(self, a: u16x8<Self>) -> u16x8<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_mul(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn shr_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self> {
        u16x8_shr(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn shrv_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self> {
        u16x8_shl(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        u16x8_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        u16x8_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        u16x8_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        u16x8_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        u16x8_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_shuffle::<0, 8, 1, 9, 2, 10, 3, 11>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_shuffle::<4, 12, 5, 13, 6, 14, 7, 15>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_shuffle::<0, 2, 4, 6, 8, 10, 12, 14>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_shuffle::<1, 3, 5, 7, 9, 11, 13, 15>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_u16x8(self, a: mask16x8<Self>, b: u16x8<Self>, c: u16x8<Self>) -> u16x8<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        u16x8_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_u16x8(self, a: u16x8<Self>) -> u8x16<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u32_u16x8(self, a: u16x8<Self>) -> u32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn splat_mask16x8(self, val: i16) -> mask16x8<Self> {
        i16x8_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_mask16x8(self, a: mask16x8<Self>) -> mask16x8<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_mask16x8(
        self,
        a: mask16x8<Self>,
        b: mask16x8<Self>,
        c: mask16x8<Self>,
    ) -> mask16x8<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        i16x8_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_i32x4(self, val: i32) -> i32x4<Self> {
        i32x4_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_i32x4(self, a: i32x4<Self>) -> i32x4<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        i32x4_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        i32x4_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        i32x4_mul(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn shr_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self> {
        i32x4_shr(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn shrv_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self> {
        i32x4_shl(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        i32x4_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        i32x4_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        i32x4_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        i32x4_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        i32x4_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        u32x4_shuffle::<0, 4, 1, 5>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        u32x4_shuffle::<2, 6, 3, 7>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        u32x4_shuffle::<0, 2, 4, 6>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        u32x4_shuffle::<1, 3, 5, 7>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_i32x4(self, a: mask32x4<Self>, b: i32x4<Self>, c: i32x4<Self>) -> i32x4<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        i32x4_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        i32x4_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i32x4(self, a: i32x4<Self>) -> i32x4<Self> {
        i32x4_neg(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_i32x4(self, a: i32x4<Self>) -> u8x16<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u32_i32x4(self, a: i32x4<Self>) -> u32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn cvt_f32_i32x4(self, a: i32x4<Self>) -> f32x4<Self> {
        f32x4_convert_i32x4(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn splat_u32x4(self, val: u32) -> u32x4<Self> {
        u32x4_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_u32x4(self, a: u32x4<Self>) -> u32x4<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_mul(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn shr_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self> {
        u32x4_shr(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn shrv_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self> {
        u32x4_shl(a.into(), shift).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        u32x4_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        u32x4_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        u32x4_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        u32x4_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        u32x4_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_shuffle::<0, 4, 1, 5>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_shuffle::<2, 6, 3, 7>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_shuffle::<0, 2, 4, 6>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_shuffle::<1, 3, 5, 7>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_u32x4(self, a: mask32x4<Self>, b: u32x4<Self>, c: u32x4<Self>) -> u32x4<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        u32x4_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_u32x4(self, a: u32x4<Self>) -> u8x16<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn cvt_f32_u32x4(self, a: u32x4<Self>) -> f32x4<Self> {
        f32x4_convert_u32x4(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn splat_mask32x4(self, val: i32) -> mask32x4<Self> {
        i32x4_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_mask32x4(self, a: mask32x4<Self>) -> mask32x4<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_mask32x4(
        self,
        a: mask32x4<Self>,
        b: mask32x4<Self>,
        c: mask32x4<Self>,
    ) -> mask32x4<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        i32x4_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_f64x2(self, val: f64) -> f64x2<Self> {
        f64x2_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn abs_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        f64x2_abs(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn neg_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        f64x2_neg(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn sqrt_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        f64x2_sqrt(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn add_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_add(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn sub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_sub(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn mul_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_mul(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn div_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_div(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn copysign_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        let sign_mask = f64x2_splat(-0.0_f64);
        let sign_bits = v128_and(b.into(), sign_mask.into());
        let magnitude = v128_andnot(a.into(), sign_mask.into());
        v128_or(magnitude, sign_bits).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        f64x2_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_lt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        f64x2_lt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_le_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        f64x2_le(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_ge_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        f64x2_ge(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_gt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        f64x2_gt(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        u64x2_shuffle::<0, 2>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn zip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        u64x2_shuffle::<1, 3>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        u64x2_shuffle::<0, 2>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn unzip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        u64x2_shuffle::<1, 3>(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_max(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn max_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_pmax(b.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_min(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn min_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        f64x2_pmin(b.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn madd_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        a.mul(b).add(c)
    }
    #[inline(always)]
    fn msub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        a.mul(b).sub(c)
    }
    #[inline(always)]
    fn floor_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        f64x2_floor(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn fract_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        a.sub(a.trunc())
    }
    #[inline(always)]
    fn trunc_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        f64x2_trunc(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_f64x2(self, a: mask64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x4<Self> {
        let mut result = [0.0; 4usize];
        result[0..2usize].copy_from_slice(&a.val);
        result[2usize..4usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_f32_f64x2(self, a: f64x2<Self>) -> f32x4<Self> {
        <v128>::from(a).simd_into(self)
    }
    #[inline(always)]
    fn splat_mask64x2(self, val: i64) -> mask64x2<Self> {
        i64x2_splat(val).simd_into(self)
    }
    #[inline(always)]
    fn not_mask64x2(self, a: mask64x2<Self>) -> mask64x2<Self> {
        v128_not(a.into()).simd_into(self)
    }
    #[inline(always)]
    fn and_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        v128_and(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn or_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        v128_or(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn xor_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        v128_xor(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn select_mask64x2(
        self,
        a: mask64x2<Self>,
        b: mask64x2<Self>,
        c: mask64x2<Self>,
    ) -> mask64x2<Self> {
        v128_bitselect(b.into(), c.into(), a.into()).simd_into(self)
    }
    #[inline(always)]
    fn simd_eq_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        i64x2_eq(a.into(), b.into()).simd_into(self)
    }
    #[inline(always)]
    fn combine_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x4<Self> {
        let mut result = [0; 4usize];
        result[0..2usize].copy_from_slice(&a.val);
        result[2usize..4usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_f32x8(self, a: f32) -> f32x8<Self> {
        let half = self.splat_f32x4(a);
        self.combine_f32x4(half, half)
    }
    #[inline(always)]
    fn abs_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.abs_f32x4(a0), self.abs_f32x4(a1))
    }
    #[inline(always)]
    fn neg_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.neg_f32x4(a0), self.neg_f32x4(a1))
    }
    #[inline(always)]
    fn sqrt_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.sqrt_f32x4(a0), self.sqrt_f32x4(a1))
    }
    #[inline(always)]
    fn add_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.add_f32x4(a0, b0), self.add_f32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.sub_f32x4(a0, b0), self.sub_f32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.mul_f32x4(a0, b0), self.mul_f32x4(a1, b1))
    }
    #[inline(always)]
    fn div_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.div_f32x4(a0, b0), self.div_f32x4(a1, b1))
    }
    #[inline(always)]
    fn copysign_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.copysign_f32x4(a0, b0), self.copysign_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_eq_f32x4(a0, b0), self.simd_eq_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_lt_f32x4(a0, b0), self.simd_lt_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_le_f32x4(a0, b0), self.simd_le_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_ge_f32x4(a0, b0), self.simd_ge_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_gt_f32x4(a0, b0), self.simd_gt_f32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, _) = self.split_f32x8(a);
        let (b0, _) = self.split_f32x8(b);
        self.combine_f32x4(self.zip_low_f32x4(a0, b0), self.zip_high_f32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (_, a1) = self.split_f32x8(a);
        let (_, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.zip_low_f32x4(a1, b1), self.zip_high_f32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.unzip_low_f32x4(a0, a1), self.unzip_low_f32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.unzip_high_f32x4(a0, a1), self.unzip_high_f32x4(b0, b1))
    }
    #[inline(always)]
    fn max_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.max_f32x4(a0, b0), self.max_f32x4(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(
            self.max_precise_f32x4(a0, b0),
            self.max_precise_f32x4(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.min_f32x4(a0, b0), self.min_f32x4(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(
            self.min_precise_f32x4(a0, b0),
            self.min_precise_f32x4(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.madd_f32x4(a0, b0, c0), self.madd_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.msub_f32x4(a0, b0, c0), self.msub_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.floor_f32x4(a0), self.floor_f32x4(a1))
    }
    #[inline(always)]
    fn fract_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.fract_f32x4(a0), self.fract_f32x4(a1))
    }
    #[inline(always)]
    fn trunc_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.trunc_f32x4(a0), self.trunc_f32x4(a1))
    }
    #[inline(always)]
    fn select_f32x8(self, a: mask32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.select_f32x4(a0, b0, c0), self.select_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn combine_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x16<Self> {
        let mut result = [0.0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_f32x8(self, a: f32x8<Self>) -> (f32x4<Self>, f32x4<Self>) {
        let mut b0 = [0.0; 4usize];
        let mut b1 = [0.0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f64_f32x8(self, a: f32x8<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f64x2(
            self.reinterpret_f64_f32x4(a0),
            self.reinterpret_f64_f32x4(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_i32x4(
            self.reinterpret_i32_f32x4(a0),
            self.reinterpret_i32_f32x4(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u8_f32x8(self, a: f32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u8x16(self.reinterpret_u8_f32x4(a0), self.reinterpret_u8_f32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u32x4(
            self.reinterpret_u32_f32x4(a0),
            self.reinterpret_u32_f32x4(a1),
        )
    }
    #[inline(always)]
    fn cvt_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u32x4(self.cvt_u32_f32x4(a0), self.cvt_u32_f32x4(a1))
    }
    #[inline(always)]
    fn cvt_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_i32x4(self.cvt_i32_f32x4(a0), self.cvt_i32_f32x4(a1))
    }
    #[inline(always)]
    fn splat_i8x32(self, a: i8) -> i8x32<Self> {
        let half = self.splat_i8x16(a);
        self.combine_i8x16(half, half)
    }
    #[inline(always)]
    fn not_i8x32(self, a: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.not_i8x16(a0), self.not_i8x16(a1))
    }
    #[inline(always)]
    fn add_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.add_i8x16(a0, b0), self.add_i8x16(a1, b1))
    }
    #[inline(always)]
    fn sub_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.sub_i8x16(a0, b0), self.sub_i8x16(a1, b1))
    }
    #[inline(always)]
    fn mul_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.mul_i8x16(a0, b0), self.mul_i8x16(a1, b1))
    }
    #[inline(always)]
    fn and_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.and_i8x16(a0, b0), self.and_i8x16(a1, b1))
    }
    #[inline(always)]
    fn or_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.or_i8x16(a0, b0), self.or_i8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.xor_i8x16(a0, b0), self.xor_i8x16(a1, b1))
    }
    #[inline(always)]
    fn shr_i8x32(self, a: i8x32<Self>, b: u32) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.shr_i8x16(a0, b), self.shr_i8x16(a1, b))
    }
    #[inline(always)]
    fn shrv_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.shrv_i8x16(a0, b0), self.shrv_i8x16(a1, b1))
    }
    #[inline(always)]
    fn shl_i8x32(self, a: i8x32<Self>, b: u32) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.shl_i8x16(a0, b), self.shl_i8x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_eq_i8x16(a0, b0), self.simd_eq_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_lt_i8x16(a0, b0), self.simd_lt_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_le_i8x16(a0, b0), self.simd_le_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_ge_i8x16(a0, b0), self.simd_ge_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_gt_i8x16(a0, b0), self.simd_gt_i8x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, _) = self.split_i8x32(a);
        let (b0, _) = self.split_i8x32(b);
        self.combine_i8x16(self.zip_low_i8x16(a0, b0), self.zip_high_i8x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (_, a1) = self.split_i8x32(a);
        let (_, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.zip_low_i8x16(a1, b1), self.zip_high_i8x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.unzip_low_i8x16(a0, a1), self.unzip_low_i8x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.unzip_high_i8x16(a0, a1), self.unzip_high_i8x16(b0, b1))
    }
    #[inline(always)]
    fn select_i8x32(self, a: mask8x32<Self>, b: i8x32<Self>, c: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        let (c0, c1) = self.split_i8x32(c);
        self.combine_i8x16(self.select_i8x16(a0, b0, c0), self.select_i8x16(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.min_i8x16(a0, b0), self.min_i8x16(a1, b1))
    }
    #[inline(always)]
    fn max_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.max_i8x16(a0, b0), self.max_i8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i8x32(self, a: i8x32<Self>) -> (i8x16<Self>, i8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i8x32(self, a: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.neg_i8x16(a0), self.neg_i8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i8x32(self, a: i8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_u8x16(self.reinterpret_u8_i8x16(a0), self.reinterpret_u8_i8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i8x32(self, a: i8x32<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_u32x4(
            self.reinterpret_u32_i8x16(a0),
            self.reinterpret_u32_i8x16(a1),
        )
    }
    #[inline(always)]
    fn splat_u8x32(self, a: u8) -> u8x32<Self> {
        let half = self.splat_u8x16(a);
        self.combine_u8x16(half, half)
    }
    #[inline(always)]
    fn not_u8x32(self, a: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.not_u8x16(a0), self.not_u8x16(a1))
    }
    #[inline(always)]
    fn add_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.add_u8x16(a0, b0), self.add_u8x16(a1, b1))
    }
    #[inline(always)]
    fn sub_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.sub_u8x16(a0, b0), self.sub_u8x16(a1, b1))
    }
    #[inline(always)]
    fn mul_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.mul_u8x16(a0, b0), self.mul_u8x16(a1, b1))
    }
    #[inline(always)]
    fn and_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.and_u8x16(a0, b0), self.and_u8x16(a1, b1))
    }
    #[inline(always)]
    fn or_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.or_u8x16(a0, b0), self.or_u8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.xor_u8x16(a0, b0), self.xor_u8x16(a1, b1))
    }
    #[inline(always)]
    fn shr_u8x32(self, a: u8x32<Self>, b: u32) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.shr_u8x16(a0, b), self.shr_u8x16(a1, b))
    }
    #[inline(always)]
    fn shrv_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.shrv_u8x16(a0, b0), self.shrv_u8x16(a1, b1))
    }
    #[inline(always)]
    fn shl_u8x32(self, a: u8x32<Self>, b: u32) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.shl_u8x16(a0, b), self.shl_u8x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_eq_u8x16(a0, b0), self.simd_eq_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_lt_u8x16(a0, b0), self.simd_lt_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_le_u8x16(a0, b0), self.simd_le_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_ge_u8x16(a0, b0), self.simd_ge_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_gt_u8x16(a0, b0), self.simd_gt_u8x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, _) = self.split_u8x32(a);
        let (b0, _) = self.split_u8x32(b);
        self.combine_u8x16(self.zip_low_u8x16(a0, b0), self.zip_high_u8x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (_, a1) = self.split_u8x32(a);
        let (_, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.zip_low_u8x16(a1, b1), self.zip_high_u8x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.unzip_low_u8x16(a0, a1), self.unzip_low_u8x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.unzip_high_u8x16(a0, a1), self.unzip_high_u8x16(b0, b1))
    }
    #[inline(always)]
    fn select_u8x32(self, a: mask8x32<Self>, b: u8x32<Self>, c: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        let (c0, c1) = self.split_u8x32(c);
        self.combine_u8x16(self.select_u8x16(a0, b0, c0), self.select_u8x16(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.min_u8x16(a0, b0), self.min_u8x16(a1, b1))
    }
    #[inline(always)]
    fn max_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.max_u8x16(a0, b0), self.max_u8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u8x32(self, a: u8x32<Self>) -> (u8x16<Self>, u8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn widen_u8x32(self, a: u8x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u16x16(self.widen_u8x16(a0), self.widen_u8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_u8x32(self, a: u8x32<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u32x4(
            self.reinterpret_u32_u8x16(a0),
            self.reinterpret_u32_u8x16(a1),
        )
    }
    #[inline(always)]
    fn splat_mask8x32(self, a: i8) -> mask8x32<Self> {
        let half = self.splat_mask8x16(a);
        self.combine_mask8x16(half, half)
    }
    #[inline(always)]
    fn not_mask8x32(self, a: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        self.combine_mask8x16(self.not_mask8x16(a0), self.not_mask8x16(a1))
    }
    #[inline(always)]
    fn and_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.and_mask8x16(a0, b0), self.and_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn or_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.or_mask8x16(a0, b0), self.or_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.xor_mask8x16(a0, b0), self.xor_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn select_mask8x32(
        self,
        a: mask8x32<Self>,
        b: mask8x32<Self>,
        c: mask8x32<Self>,
    ) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        let (c0, c1) = self.split_mask8x32(c);
        self.combine_mask8x16(
            self.select_mask8x16(a0, b0, c0),
            self.select_mask8x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.simd_eq_mask8x16(a0, b0), self.simd_eq_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask8x32(self, a: mask8x32<Self>) -> (mask8x16<Self>, mask8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i16x16(self, a: i16) -> i16x16<Self> {
        let half = self.splat_i16x8(a);
        self.combine_i16x8(half, half)
    }
    #[inline(always)]
    fn not_i16x16(self, a: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.not_i16x8(a0), self.not_i16x8(a1))
    }
    #[inline(always)]
    fn add_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.add_i16x8(a0, b0), self.add_i16x8(a1, b1))
    }
    #[inline(always)]
    fn sub_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.sub_i16x8(a0, b0), self.sub_i16x8(a1, b1))
    }
    #[inline(always)]
    fn mul_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.mul_i16x8(a0, b0), self.mul_i16x8(a1, b1))
    }
    #[inline(always)]
    fn and_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.and_i16x8(a0, b0), self.and_i16x8(a1, b1))
    }
    #[inline(always)]
    fn or_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.or_i16x8(a0, b0), self.or_i16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.xor_i16x8(a0, b0), self.xor_i16x8(a1, b1))
    }
    #[inline(always)]
    fn shr_i16x16(self, a: i16x16<Self>, b: u32) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.shr_i16x8(a0, b), self.shr_i16x8(a1, b))
    }
    #[inline(always)]
    fn shrv_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.shrv_i16x8(a0, b0), self.shrv_i16x8(a1, b1))
    }
    #[inline(always)]
    fn shl_i16x16(self, a: i16x16<Self>, b: u32) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.shl_i16x8(a0, b), self.shl_i16x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_eq_i16x8(a0, b0), self.simd_eq_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_lt_i16x8(a0, b0), self.simd_lt_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_le_i16x8(a0, b0), self.simd_le_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_ge_i16x8(a0, b0), self.simd_ge_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_gt_i16x8(a0, b0), self.simd_gt_i16x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, _) = self.split_i16x16(a);
        let (b0, _) = self.split_i16x16(b);
        self.combine_i16x8(self.zip_low_i16x8(a0, b0), self.zip_high_i16x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (_, a1) = self.split_i16x16(a);
        let (_, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.zip_low_i16x8(a1, b1), self.zip_high_i16x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.unzip_low_i16x8(a0, a1), self.unzip_low_i16x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.unzip_high_i16x8(a0, a1), self.unzip_high_i16x8(b0, b1))
    }
    #[inline(always)]
    fn select_i16x16(self, a: mask16x16<Self>, b: i16x16<Self>, c: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        let (c0, c1) = self.split_i16x16(c);
        self.combine_i16x8(self.select_i16x8(a0, b0, c0), self.select_i16x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.min_i16x8(a0, b0), self.min_i16x8(a1, b1))
    }
    #[inline(always)]
    fn max_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.max_i16x8(a0, b0), self.max_i16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i16x16(self, a: i16x16<Self>) -> (i16x8<Self>, i16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i16x16(self, a: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.neg_i16x8(a0), self.neg_i16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i16x16(self, a: i16x16<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_u8x16(self.reinterpret_u8_i16x8(a0), self.reinterpret_u8_i16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i16x16(self, a: i16x16<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_u32x4(
            self.reinterpret_u32_i16x8(a0),
            self.reinterpret_u32_i16x8(a1),
        )
    }
    #[inline(always)]
    fn splat_u16x16(self, a: u16) -> u16x16<Self> {
        let half = self.splat_u16x8(a);
        self.combine_u16x8(half, half)
    }
    #[inline(always)]
    fn not_u16x16(self, a: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.not_u16x8(a0), self.not_u16x8(a1))
    }
    #[inline(always)]
    fn add_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.add_u16x8(a0, b0), self.add_u16x8(a1, b1))
    }
    #[inline(always)]
    fn sub_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.sub_u16x8(a0, b0), self.sub_u16x8(a1, b1))
    }
    #[inline(always)]
    fn mul_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.mul_u16x8(a0, b0), self.mul_u16x8(a1, b1))
    }
    #[inline(always)]
    fn and_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.and_u16x8(a0, b0), self.and_u16x8(a1, b1))
    }
    #[inline(always)]
    fn or_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.or_u16x8(a0, b0), self.or_u16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.xor_u16x8(a0, b0), self.xor_u16x8(a1, b1))
    }
    #[inline(always)]
    fn shr_u16x16(self, a: u16x16<Self>, b: u32) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.shr_u16x8(a0, b), self.shr_u16x8(a1, b))
    }
    #[inline(always)]
    fn shrv_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.shrv_u16x8(a0, b0), self.shrv_u16x8(a1, b1))
    }
    #[inline(always)]
    fn shl_u16x16(self, a: u16x16<Self>, b: u32) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.shl_u16x8(a0, b), self.shl_u16x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_eq_u16x8(a0, b0), self.simd_eq_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_lt_u16x8(a0, b0), self.simd_lt_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_le_u16x8(a0, b0), self.simd_le_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_ge_u16x8(a0, b0), self.simd_ge_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_gt_u16x8(a0, b0), self.simd_gt_u16x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, _) = self.split_u16x16(a);
        let (b0, _) = self.split_u16x16(b);
        self.combine_u16x8(self.zip_low_u16x8(a0, b0), self.zip_high_u16x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (_, a1) = self.split_u16x16(a);
        let (_, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.zip_low_u16x8(a1, b1), self.zip_high_u16x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.unzip_low_u16x8(a0, a1), self.unzip_low_u16x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.unzip_high_u16x8(a0, a1), self.unzip_high_u16x8(b0, b1))
    }
    #[inline(always)]
    fn select_u16x16(self, a: mask16x16<Self>, b: u16x16<Self>, c: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        let (c0, c1) = self.split_u16x16(c);
        self.combine_u16x8(self.select_u16x8(a0, b0, c0), self.select_u16x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.min_u16x8(a0, b0), self.min_u16x8(a1, b1))
    }
    #[inline(always)]
    fn max_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.max_u16x8(a0, b0), self.max_u16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u16x16(self, a: u16x16<Self>) -> (u16x8<Self>, u16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn narrow_u16x16(self, a: u16x16<Self>) -> u8x16<Self> {
        let mask = u16x8_splat(0xFF);
        let (low, high) = self.split_u16x16(a);
        let low_masked = v128_and(low.into(), mask);
        let high_masked = v128_and(high.into(), mask);
        let result = u8x16_narrow_i16x8(low_masked, high_masked);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_u16x16(self, a: u16x16<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u8x16(self.reinterpret_u8_u16x8(a0), self.reinterpret_u8_u16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_u16x16(self, a: u16x16<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u32x4(
            self.reinterpret_u32_u16x8(a0),
            self.reinterpret_u32_u16x8(a1),
        )
    }
    #[inline(always)]
    fn splat_mask16x16(self, a: i16) -> mask16x16<Self> {
        let half = self.splat_mask16x8(a);
        self.combine_mask16x8(half, half)
    }
    #[inline(always)]
    fn not_mask16x16(self, a: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        self.combine_mask16x8(self.not_mask16x8(a0), self.not_mask16x8(a1))
    }
    #[inline(always)]
    fn and_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.and_mask16x8(a0, b0), self.and_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn or_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.or_mask16x8(a0, b0), self.or_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.xor_mask16x8(a0, b0), self.xor_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn select_mask16x16(
        self,
        a: mask16x16<Self>,
        b: mask16x16<Self>,
        c: mask16x16<Self>,
    ) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        let (c0, c1) = self.split_mask16x16(c);
        self.combine_mask16x8(
            self.select_mask16x8(a0, b0, c0),
            self.select_mask16x8(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.simd_eq_mask16x8(a0, b0), self.simd_eq_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask16x16(self, a: mask16x16<Self>) -> (mask16x8<Self>, mask16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i32x8(self, a: i32) -> i32x8<Self> {
        let half = self.splat_i32x4(a);
        self.combine_i32x4(half, half)
    }
    #[inline(always)]
    fn not_i32x8(self, a: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.not_i32x4(a0), self.not_i32x4(a1))
    }
    #[inline(always)]
    fn add_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.add_i32x4(a0, b0), self.add_i32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.sub_i32x4(a0, b0), self.sub_i32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.mul_i32x4(a0, b0), self.mul_i32x4(a1, b1))
    }
    #[inline(always)]
    fn and_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.and_i32x4(a0, b0), self.and_i32x4(a1, b1))
    }
    #[inline(always)]
    fn or_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.or_i32x4(a0, b0), self.or_i32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.xor_i32x4(a0, b0), self.xor_i32x4(a1, b1))
    }
    #[inline(always)]
    fn shr_i32x8(self, a: i32x8<Self>, b: u32) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.shr_i32x4(a0, b), self.shr_i32x4(a1, b))
    }
    #[inline(always)]
    fn shrv_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.shrv_i32x4(a0, b0), self.shrv_i32x4(a1, b1))
    }
    #[inline(always)]
    fn shl_i32x8(self, a: i32x8<Self>, b: u32) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.shl_i32x4(a0, b), self.shl_i32x4(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_eq_i32x4(a0, b0), self.simd_eq_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_lt_i32x4(a0, b0), self.simd_lt_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_le_i32x4(a0, b0), self.simd_le_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_ge_i32x4(a0, b0), self.simd_ge_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_gt_i32x4(a0, b0), self.simd_gt_i32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, _) = self.split_i32x8(a);
        let (b0, _) = self.split_i32x8(b);
        self.combine_i32x4(self.zip_low_i32x4(a0, b0), self.zip_high_i32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (_, a1) = self.split_i32x8(a);
        let (_, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.zip_low_i32x4(a1, b1), self.zip_high_i32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.unzip_low_i32x4(a0, a1), self.unzip_low_i32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.unzip_high_i32x4(a0, a1), self.unzip_high_i32x4(b0, b1))
    }
    #[inline(always)]
    fn select_i32x8(self, a: mask32x8<Self>, b: i32x8<Self>, c: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        let (c0, c1) = self.split_i32x8(c);
        self.combine_i32x4(self.select_i32x4(a0, b0, c0), self.select_i32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.min_i32x4(a0, b0), self.min_i32x4(a1, b1))
    }
    #[inline(always)]
    fn max_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.max_i32x4(a0, b0), self.max_i32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i32x8(self, a: i32x8<Self>) -> (i32x4<Self>, i32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i32x8(self, a: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.neg_i32x4(a0), self.neg_i32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i32x8(self, a: i32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_u8x16(self.reinterpret_u8_i32x4(a0), self.reinterpret_u8_i32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i32x8(self, a: i32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_u32x4(
            self.reinterpret_u32_i32x4(a0),
            self.reinterpret_u32_i32x4(a1),
        )
    }
    #[inline(always)]
    fn cvt_f32_i32x8(self, a: i32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_f32x4(self.cvt_f32_i32x4(a0), self.cvt_f32_i32x4(a1))
    }
    #[inline(always)]
    fn splat_u32x8(self, a: u32) -> u32x8<Self> {
        let half = self.splat_u32x4(a);
        self.combine_u32x4(half, half)
    }
    #[inline(always)]
    fn not_u32x8(self, a: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.not_u32x4(a0), self.not_u32x4(a1))
    }
    #[inline(always)]
    fn add_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.add_u32x4(a0, b0), self.add_u32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.sub_u32x4(a0, b0), self.sub_u32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.mul_u32x4(a0, b0), self.mul_u32x4(a1, b1))
    }
    #[inline(always)]
    fn and_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.and_u32x4(a0, b0), self.and_u32x4(a1, b1))
    }
    #[inline(always)]
    fn or_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.or_u32x4(a0, b0), self.or_u32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.xor_u32x4(a0, b0), self.xor_u32x4(a1, b1))
    }
    #[inline(always)]
    fn shr_u32x8(self, a: u32x8<Self>, b: u32) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.shr_u32x4(a0, b), self.shr_u32x4(a1, b))
    }
    #[inline(always)]
    fn shrv_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.shrv_u32x4(a0, b0), self.shrv_u32x4(a1, b1))
    }
    #[inline(always)]
    fn shl_u32x8(self, a: u32x8<Self>, b: u32) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.shl_u32x4(a0, b), self.shl_u32x4(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_eq_u32x4(a0, b0), self.simd_eq_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_lt_u32x4(a0, b0), self.simd_lt_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_le_u32x4(a0, b0), self.simd_le_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_ge_u32x4(a0, b0), self.simd_ge_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_gt_u32x4(a0, b0), self.simd_gt_u32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, _) = self.split_u32x8(a);
        let (b0, _) = self.split_u32x8(b);
        self.combine_u32x4(self.zip_low_u32x4(a0, b0), self.zip_high_u32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (_, a1) = self.split_u32x8(a);
        let (_, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.zip_low_u32x4(a1, b1), self.zip_high_u32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.unzip_low_u32x4(a0, a1), self.unzip_low_u32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.unzip_high_u32x4(a0, a1), self.unzip_high_u32x4(b0, b1))
    }
    #[inline(always)]
    fn select_u32x8(self, a: mask32x8<Self>, b: u32x8<Self>, c: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        let (c0, c1) = self.split_u32x8(c);
        self.combine_u32x4(self.select_u32x4(a0, b0, c0), self.select_u32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.min_u32x4(a0, b0), self.min_u32x4(a1, b1))
    }
    #[inline(always)]
    fn max_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.max_u32x4(a0, b0), self.max_u32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u32x8(self, a: u32x8<Self>) -> (u32x4<Self>, u32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_u8_u32x8(self, a: u32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u8x16(self.reinterpret_u8_u32x4(a0), self.reinterpret_u8_u32x4(a1))
    }
    #[inline(always)]
    fn cvt_f32_u32x8(self, a: u32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_f32x4(self.cvt_f32_u32x4(a0), self.cvt_f32_u32x4(a1))
    }
    #[inline(always)]
    fn splat_mask32x8(self, a: i32) -> mask32x8<Self> {
        let half = self.splat_mask32x4(a);
        self.combine_mask32x4(half, half)
    }
    #[inline(always)]
    fn not_mask32x8(self, a: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        self.combine_mask32x4(self.not_mask32x4(a0), self.not_mask32x4(a1))
    }
    #[inline(always)]
    fn and_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.and_mask32x4(a0, b0), self.and_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn or_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.or_mask32x4(a0, b0), self.or_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.xor_mask32x4(a0, b0), self.xor_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn select_mask32x8(
        self,
        a: mask32x8<Self>,
        b: mask32x8<Self>,
        c: mask32x8<Self>,
    ) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        let (c0, c1) = self.split_mask32x8(c);
        self.combine_mask32x4(
            self.select_mask32x4(a0, b0, c0),
            self.select_mask32x4(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.simd_eq_mask32x4(a0, b0), self.simd_eq_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask32x8(self, a: mask32x8<Self>) -> (mask32x4<Self>, mask32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f64x4(self, a: f64) -> f64x4<Self> {
        let half = self.splat_f64x2(a);
        self.combine_f64x2(half, half)
    }
    #[inline(always)]
    fn abs_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.abs_f64x2(a0), self.abs_f64x2(a1))
    }
    #[inline(always)]
    fn neg_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.neg_f64x2(a0), self.neg_f64x2(a1))
    }
    #[inline(always)]
    fn sqrt_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.sqrt_f64x2(a0), self.sqrt_f64x2(a1))
    }
    #[inline(always)]
    fn add_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.add_f64x2(a0, b0), self.add_f64x2(a1, b1))
    }
    #[inline(always)]
    fn sub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.sub_f64x2(a0, b0), self.sub_f64x2(a1, b1))
    }
    #[inline(always)]
    fn mul_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.mul_f64x2(a0, b0), self.mul_f64x2(a1, b1))
    }
    #[inline(always)]
    fn div_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.div_f64x2(a0, b0), self.div_f64x2(a1, b1))
    }
    #[inline(always)]
    fn copysign_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.copysign_f64x2(a0, b0), self.copysign_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_eq_f64x2(a0, b0), self.simd_eq_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_lt_f64x2(a0, b0), self.simd_lt_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_le_f64x2(a0, b0), self.simd_le_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_ge_f64x2(a0, b0), self.simd_ge_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_gt_f64x2(a0, b0), self.simd_gt_f64x2(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, _) = self.split_f64x4(a);
        let (b0, _) = self.split_f64x4(b);
        self.combine_f64x2(self.zip_low_f64x2(a0, b0), self.zip_high_f64x2(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (_, a1) = self.split_f64x4(a);
        let (_, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.zip_low_f64x2(a1, b1), self.zip_high_f64x2(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.unzip_low_f64x2(a0, a1), self.unzip_low_f64x2(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.unzip_high_f64x2(a0, a1), self.unzip_high_f64x2(b0, b1))
    }
    #[inline(always)]
    fn max_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.max_f64x2(a0, b0), self.max_f64x2(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(
            self.max_precise_f64x2(a0, b0),
            self.max_precise_f64x2(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.min_f64x2(a0, b0), self.min_f64x2(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(
            self.min_precise_f64x2(a0, b0),
            self.min_precise_f64x2(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.madd_f64x2(a0, b0, c0), self.madd_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.msub_f64x2(a0, b0, c0), self.msub_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.floor_f64x2(a0), self.floor_f64x2(a1))
    }
    #[inline(always)]
    fn fract_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.fract_f64x2(a0), self.fract_f64x2(a1))
    }
    #[inline(always)]
    fn trunc_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.trunc_f64x2(a0), self.trunc_f64x2(a1))
    }
    #[inline(always)]
    fn select_f64x4(self, a: mask64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.select_f64x2(a0, b0, c0), self.select_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn combine_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x8<Self> {
        let mut result = [0.0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_f64x4(self, a: f64x4<Self>) -> (f64x2<Self>, f64x2<Self>) {
        let mut b0 = [0.0; 2usize];
        let mut b1 = [0.0; 2usize];
        b0.copy_from_slice(&a.val[0..2usize]);
        b1.copy_from_slice(&a.val[2usize..4usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f32_f64x4(self, a: f64x4<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f32x4(
            self.reinterpret_f32_f64x2(a0),
            self.reinterpret_f32_f64x2(a1),
        )
    }
    #[inline(always)]
    fn splat_mask64x4(self, a: i64) -> mask64x4<Self> {
        let half = self.splat_mask64x2(a);
        self.combine_mask64x2(half, half)
    }
    #[inline(always)]
    fn not_mask64x4(self, a: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        self.combine_mask64x2(self.not_mask64x2(a0), self.not_mask64x2(a1))
    }
    #[inline(always)]
    fn and_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.and_mask64x2(a0, b0), self.and_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn or_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.or_mask64x2(a0, b0), self.or_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn xor_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.xor_mask64x2(a0, b0), self.xor_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn select_mask64x4(
        self,
        a: mask64x4<Self>,
        b: mask64x4<Self>,
        c: mask64x4<Self>,
    ) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        let (c0, c1) = self.split_mask64x4(c);
        self.combine_mask64x2(
            self.select_mask64x2(a0, b0, c0),
            self.select_mask64x2(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.simd_eq_mask64x2(a0, b0), self.simd_eq_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn combine_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask64x4(self, a: mask64x4<Self>) -> (mask64x2<Self>, mask64x2<Self>) {
        let mut b0 = [0; 2usize];
        let mut b1 = [0; 2usize];
        b0.copy_from_slice(&a.val[0..2usize]);
        b1.copy_from_slice(&a.val[2usize..4usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f32x16(self, a: f32) -> f32x16<Self> {
        let half = self.splat_f32x8(a);
        self.combine_f32x8(half, half)
    }
    #[inline(always)]
    fn abs_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.abs_f32x8(a0), self.abs_f32x8(a1))
    }
    #[inline(always)]
    fn neg_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.neg_f32x8(a0), self.neg_f32x8(a1))
    }
    #[inline(always)]
    fn sqrt_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.sqrt_f32x8(a0), self.sqrt_f32x8(a1))
    }
    #[inline(always)]
    fn add_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.add_f32x8(a0, b0), self.add_f32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.sub_f32x8(a0, b0), self.sub_f32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.mul_f32x8(a0, b0), self.mul_f32x8(a1, b1))
    }
    #[inline(always)]
    fn div_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.div_f32x8(a0, b0), self.div_f32x8(a1, b1))
    }
    #[inline(always)]
    fn copysign_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.copysign_f32x8(a0, b0), self.copysign_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_eq_f32x8(a0, b0), self.simd_eq_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_lt_f32x8(a0, b0), self.simd_lt_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_le_f32x8(a0, b0), self.simd_le_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_ge_f32x8(a0, b0), self.simd_ge_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_gt_f32x8(a0, b0), self.simd_gt_f32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, _) = self.split_f32x16(a);
        let (b0, _) = self.split_f32x16(b);
        self.combine_f32x8(self.zip_low_f32x8(a0, b0), self.zip_high_f32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (_, a1) = self.split_f32x16(a);
        let (_, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.zip_low_f32x8(a1, b1), self.zip_high_f32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.unzip_low_f32x8(a0, a1), self.unzip_low_f32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.unzip_high_f32x8(a0, a1), self.unzip_high_f32x8(b0, b1))
    }
    #[inline(always)]
    fn max_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.max_f32x8(a0, b0), self.max_f32x8(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(
            self.max_precise_f32x8(a0, b0),
            self.max_precise_f32x8(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.min_f32x8(a0, b0), self.min_f32x8(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(
            self.min_precise_f32x8(a0, b0),
            self.min_precise_f32x8(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.madd_f32x8(a0, b0, c0), self.madd_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.msub_f32x8(a0, b0, c0), self.msub_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.floor_f32x8(a0), self.floor_f32x8(a1))
    }
    #[inline(always)]
    fn fract_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.fract_f32x8(a0), self.fract_f32x8(a1))
    }
    #[inline(always)]
    fn trunc_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.trunc_f32x8(a0), self.trunc_f32x8(a1))
    }
    #[inline(always)]
    fn select_f32x16(self, a: mask32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.select_f32x8(a0, b0, c0), self.select_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn split_f32x16(self, a: f32x16<Self>) -> (f32x8<Self>, f32x8<Self>) {
        let mut b0 = [0.0; 8usize];
        let mut b1 = [0.0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f64_f32x16(self, a: f32x16<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f64x4(
            self.reinterpret_f64_f32x8(a0),
            self.reinterpret_f64_f32x8(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_i32x8(
            self.reinterpret_i32_f32x8(a0),
            self.reinterpret_i32_f32x8(a1),
        )
    }
    #[inline(always)]
    fn load_interleaved_128_f32x16(self, src: &[f32; 16usize]) -> f32x16<Self> {
        let v0: v128 = unsafe { v128_load(src[0 * 4usize..].as_ptr() as *const v128) };
        let v1: v128 = unsafe { v128_load(src[1 * 4usize..].as_ptr() as *const v128) };
        let v2: v128 = unsafe { v128_load(src[2 * 4usize..].as_ptr() as *const v128) };
        let v3: v128 = unsafe { v128_load(src[3 * 4usize..].as_ptr() as *const v128) };
        let v01_lower = u32x4_shuffle::<0, 4, 1, 5>(v0, v1);
        let v23_lower = u32x4_shuffle::<0, 4, 1, 5>(v2, v3);
        let v01_upper = u32x4_shuffle::<2, 6, 3, 7>(v0, v1);
        let v23_upper = u32x4_shuffle::<2, 6, 3, 7>(v2, v3);
        let out0 = u32x4_shuffle::<0, 1, 4, 5>(v01_lower, v23_lower);
        let out1 = u32x4_shuffle::<2, 3, 6, 7>(v01_lower, v23_lower);
        let out2 = u32x4_shuffle::<0, 1, 4, 5>(v01_upper, v23_upper);
        let out3 = u32x4_shuffle::<2, 3, 6, 7>(v01_upper, v23_upper);
        let combined_lower = self.combine_f32x4(out0.simd_into(self), out1.simd_into(self));
        let combined_upper = self.combine_f32x4(out2.simd_into(self), out3.simd_into(self));
        self.combine_f32x8(combined_lower, combined_upper)
    }
    #[inline(always)]
    fn store_interleaved_128_f32x16(self, a: f32x16<Self>, dest: &mut [f32; 16usize]) -> () {
        let (lower, upper) = self.split_f32x16(a);
        let (v0_vec, v1_vec) = self.split_f32x8(lower);
        let (v2_vec, v3_vec) = self.split_f32x8(upper);
        let v0: v128 = v0_vec.into();
        let v1: v128 = v1_vec.into();
        let v2: v128 = v2_vec.into();
        let v3: v128 = v3_vec.into();
        let v02_lower = u32x4_shuffle::<0, 4, 1, 5>(v0, v2);
        let v13_lower = u32x4_shuffle::<0, 4, 1, 5>(v1, v3);
        let v02_upper = u32x4_shuffle::<2, 6, 3, 7>(v0, v2);
        let v13_upper = u32x4_shuffle::<2, 6, 3, 7>(v1, v3);
        let out0 = u32x4_shuffle::<0, 4, 1, 5>(v02_lower, v13_lower);
        let out1 = u32x4_shuffle::<2, 6, 3, 7>(v02_lower, v13_lower);
        let out2 = u32x4_shuffle::<0, 4, 1, 5>(v02_upper, v13_upper);
        let out3 = u32x4_shuffle::<2, 6, 3, 7>(v02_upper, v13_upper);
        unsafe {
            v128_store(dest[0 * 4usize..].as_mut_ptr() as *mut v128, out0);
            v128_store(dest[1 * 4usize..].as_mut_ptr() as *mut v128, out1);
            v128_store(dest[2 * 4usize..].as_mut_ptr() as *mut v128, out2);
            v128_store(dest[3 * 4usize..].as_mut_ptr() as *mut v128, out3);
        }
    }
    #[inline(always)]
    fn reinterpret_u8_f32x16(self, a: f32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u8x32(self.reinterpret_u8_f32x8(a0), self.reinterpret_u8_f32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u32x8(
            self.reinterpret_u32_f32x8(a0),
            self.reinterpret_u32_f32x8(a1),
        )
    }
    #[inline(always)]
    fn cvt_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u32x8(self.cvt_u32_f32x8(a0), self.cvt_u32_f32x8(a1))
    }
    #[inline(always)]
    fn cvt_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_i32x8(self.cvt_i32_f32x8(a0), self.cvt_i32_f32x8(a1))
    }
    #[inline(always)]
    fn splat_i8x64(self, a: i8) -> i8x64<Self> {
        let half = self.splat_i8x32(a);
        self.combine_i8x32(half, half)
    }
    #[inline(always)]
    fn not_i8x64(self, a: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.not_i8x32(a0), self.not_i8x32(a1))
    }
    #[inline(always)]
    fn add_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.add_i8x32(a0, b0), self.add_i8x32(a1, b1))
    }
    #[inline(always)]
    fn sub_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.sub_i8x32(a0, b0), self.sub_i8x32(a1, b1))
    }
    #[inline(always)]
    fn mul_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.mul_i8x32(a0, b0), self.mul_i8x32(a1, b1))
    }
    #[inline(always)]
    fn and_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.and_i8x32(a0, b0), self.and_i8x32(a1, b1))
    }
    #[inline(always)]
    fn or_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.or_i8x32(a0, b0), self.or_i8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.xor_i8x32(a0, b0), self.xor_i8x32(a1, b1))
    }
    #[inline(always)]
    fn shr_i8x64(self, a: i8x64<Self>, b: u32) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.shr_i8x32(a0, b), self.shr_i8x32(a1, b))
    }
    #[inline(always)]
    fn shrv_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.shrv_i8x32(a0, b0), self.shrv_i8x32(a1, b1))
    }
    #[inline(always)]
    fn shl_i8x64(self, a: i8x64<Self>, b: u32) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.shl_i8x32(a0, b), self.shl_i8x32(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_eq_i8x32(a0, b0), self.simd_eq_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_lt_i8x32(a0, b0), self.simd_lt_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_le_i8x32(a0, b0), self.simd_le_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_ge_i8x32(a0, b0), self.simd_ge_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_gt_i8x32(a0, b0), self.simd_gt_i8x32(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, _) = self.split_i8x64(a);
        let (b0, _) = self.split_i8x64(b);
        self.combine_i8x32(self.zip_low_i8x32(a0, b0), self.zip_high_i8x32(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (_, a1) = self.split_i8x64(a);
        let (_, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.zip_low_i8x32(a1, b1), self.zip_high_i8x32(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.unzip_low_i8x32(a0, a1), self.unzip_low_i8x32(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.unzip_high_i8x32(a0, a1), self.unzip_high_i8x32(b0, b1))
    }
    #[inline(always)]
    fn select_i8x64(self, a: mask8x64<Self>, b: i8x64<Self>, c: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        let (c0, c1) = self.split_i8x64(c);
        self.combine_i8x32(self.select_i8x32(a0, b0, c0), self.select_i8x32(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.min_i8x32(a0, b0), self.min_i8x32(a1, b1))
    }
    #[inline(always)]
    fn max_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.max_i8x32(a0, b0), self.max_i8x32(a1, b1))
    }
    #[inline(always)]
    fn split_i8x64(self, a: i8x64<Self>) -> (i8x32<Self>, i8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i8x64(self, a: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.neg_i8x32(a0), self.neg_i8x32(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i8x64(self, a: i8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_u8x32(self.reinterpret_u8_i8x32(a0), self.reinterpret_u8_i8x32(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i8x64(self, a: i8x64<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_u32x8(
            self.reinterpret_u32_i8x32(a0),
            self.reinterpret_u32_i8x32(a1),
        )
    }
    #[inline(always)]
    fn splat_u8x64(self, a: u8) -> u8x64<Self> {
        let half = self.splat_u8x32(a);
        self.combine_u8x32(half, half)
    }
    #[inline(always)]
    fn not_u8x64(self, a: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.not_u8x32(a0), self.not_u8x32(a1))
    }
    #[inline(always)]
    fn add_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.add_u8x32(a0, b0), self.add_u8x32(a1, b1))
    }
    #[inline(always)]
    fn sub_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.sub_u8x32(a0, b0), self.sub_u8x32(a1, b1))
    }
    #[inline(always)]
    fn mul_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.mul_u8x32(a0, b0), self.mul_u8x32(a1, b1))
    }
    #[inline(always)]
    fn and_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.and_u8x32(a0, b0), self.and_u8x32(a1, b1))
    }
    #[inline(always)]
    fn or_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.or_u8x32(a0, b0), self.or_u8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.xor_u8x32(a0, b0), self.xor_u8x32(a1, b1))
    }
    #[inline(always)]
    fn shr_u8x64(self, a: u8x64<Self>, b: u32) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.shr_u8x32(a0, b), self.shr_u8x32(a1, b))
    }
    #[inline(always)]
    fn shrv_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.shrv_u8x32(a0, b0), self.shrv_u8x32(a1, b1))
    }
    #[inline(always)]
    fn shl_u8x64(self, a: u8x64<Self>, b: u32) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.shl_u8x32(a0, b), self.shl_u8x32(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_eq_u8x32(a0, b0), self.simd_eq_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_lt_u8x32(a0, b0), self.simd_lt_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_le_u8x32(a0, b0), self.simd_le_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_ge_u8x32(a0, b0), self.simd_ge_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_gt_u8x32(a0, b0), self.simd_gt_u8x32(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, _) = self.split_u8x64(a);
        let (b0, _) = self.split_u8x64(b);
        self.combine_u8x32(self.zip_low_u8x32(a0, b0), self.zip_high_u8x32(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (_, a1) = self.split_u8x64(a);
        let (_, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.zip_low_u8x32(a1, b1), self.zip_high_u8x32(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.unzip_low_u8x32(a0, a1), self.unzip_low_u8x32(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.unzip_high_u8x32(a0, a1), self.unzip_high_u8x32(b0, b1))
    }
    #[inline(always)]
    fn select_u8x64(self, a: mask8x64<Self>, b: u8x64<Self>, c: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        let (c0, c1) = self.split_u8x64(c);
        self.combine_u8x32(self.select_u8x32(a0, b0, c0), self.select_u8x32(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.min_u8x32(a0, b0), self.min_u8x32(a1, b1))
    }
    #[inline(always)]
    fn max_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.max_u8x32(a0, b0), self.max_u8x32(a1, b1))
    }
    #[inline(always)]
    fn split_u8x64(self, a: u8x64<Self>) -> (u8x32<Self>, u8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u8x64(self, src: &[u8; 64usize]) -> u8x64<Self> {
        let v0: v128 = unsafe { v128_load(src[0 * 16usize..].as_ptr() as *const v128) };
        let v1: v128 = unsafe { v128_load(src[1 * 16usize..].as_ptr() as *const v128) };
        let v2: v128 = unsafe { v128_load(src[2 * 16usize..].as_ptr() as *const v128) };
        let v3: v128 = unsafe { v128_load(src[3 * 16usize..].as_ptr() as *const v128) };
        let v01_lower =
            u8x16_shuffle::<0, 4, 8, 12, 16, 20, 24, 28, 1, 5, 9, 13, 17, 21, 25, 29>(v0, v1);
        let v23_lower =
            u8x16_shuffle::<0, 4, 8, 12, 16, 20, 24, 28, 1, 5, 9, 13, 17, 21, 25, 29>(v2, v3);
        let v01_upper =
            u8x16_shuffle::<2, 6, 10, 14, 18, 22, 26, 30, 3, 7, 11, 15, 19, 23, 27, 31>(v0, v1);
        let v23_upper =
            u8x16_shuffle::<2, 6, 10, 14, 18, 22, 26, 30, 3, 7, 11, 15, 19, 23, 27, 31>(v2, v3);
        let out0 = u8x16_shuffle::<0, 1, 2, 3, 4, 5, 6, 7, 16, 17, 18, 19, 20, 21, 22, 23>(
            v01_lower, v23_lower,
        );
        let out1 = u8x16_shuffle::<8, 9, 10, 11, 12, 13, 14, 15, 24, 25, 26, 27, 28, 29, 30, 31>(
            v01_lower, v23_lower,
        );
        let out2 = u8x16_shuffle::<0, 1, 2, 3, 4, 5, 6, 7, 16, 17, 18, 19, 20, 21, 22, 23>(
            v01_upper, v23_upper,
        );
        let out3 = u8x16_shuffle::<8, 9, 10, 11, 12, 13, 14, 15, 24, 25, 26, 27, 28, 29, 30, 31>(
            v01_upper, v23_upper,
        );
        let combined_lower = self.combine_u8x16(out0.simd_into(self), out1.simd_into(self));
        let combined_upper = self.combine_u8x16(out2.simd_into(self), out3.simd_into(self));
        self.combine_u8x32(combined_lower, combined_upper)
    }
    #[inline(always)]
    fn store_interleaved_128_u8x64(self, a: u8x64<Self>, dest: &mut [u8; 64usize]) -> () {
        let (lower, upper) = self.split_u8x64(a);
        let (v0_vec, v1_vec) = self.split_u8x32(lower);
        let (v2_vec, v3_vec) = self.split_u8x32(upper);
        let v0: v128 = v0_vec.into();
        let v1: v128 = v1_vec.into();
        let v2: v128 = v2_vec.into();
        let v3: v128 = v3_vec.into();
        let v02_lower =
            u8x16_shuffle::<0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23>(v0, v2);
        let v13_lower =
            u8x16_shuffle::<0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23>(v1, v3);
        let v02_upper =
            u8x16_shuffle::<8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31>(v0, v2);
        let v13_upper =
            u8x16_shuffle::<8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31>(v1, v3);
        let out0 = u8x16_shuffle::<0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23>(
            v02_lower, v13_lower,
        );
        let out1 = u8x16_shuffle::<8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31>(
            v02_lower, v13_lower,
        );
        let out2 = u8x16_shuffle::<0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23>(
            v02_upper, v13_upper,
        );
        let out3 = u8x16_shuffle::<8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31>(
            v02_upper, v13_upper,
        );
        unsafe {
            v128_store(dest[0 * 16usize..].as_mut_ptr() as *mut v128, out0);
            v128_store(dest[1 * 16usize..].as_mut_ptr() as *mut v128, out1);
            v128_store(dest[2 * 16usize..].as_mut_ptr() as *mut v128, out2);
            v128_store(dest[3 * 16usize..].as_mut_ptr() as *mut v128, out3);
        }
    }
    #[inline(always)]
    fn reinterpret_u32_u8x64(self, a: u8x64<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u32x8(
            self.reinterpret_u32_u8x32(a0),
            self.reinterpret_u32_u8x32(a1),
        )
    }
    #[inline(always)]
    fn splat_mask8x64(self, a: i8) -> mask8x64<Self> {
        let half = self.splat_mask8x32(a);
        self.combine_mask8x32(half, half)
    }
    #[inline(always)]
    fn not_mask8x64(self, a: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        self.combine_mask8x32(self.not_mask8x32(a0), self.not_mask8x32(a1))
    }
    #[inline(always)]
    fn and_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.and_mask8x32(a0, b0), self.and_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn or_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.or_mask8x32(a0, b0), self.or_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.xor_mask8x32(a0, b0), self.xor_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn select_mask8x64(
        self,
        a: mask8x64<Self>,
        b: mask8x64<Self>,
        c: mask8x64<Self>,
    ) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        let (c0, c1) = self.split_mask8x64(c);
        self.combine_mask8x32(
            self.select_mask8x32(a0, b0, c0),
            self.select_mask8x32(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.simd_eq_mask8x32(a0, b0), self.simd_eq_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn split_mask8x64(self, a: mask8x64<Self>) -> (mask8x32<Self>, mask8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i16x32(self, a: i16) -> i16x32<Self> {
        let half = self.splat_i16x16(a);
        self.combine_i16x16(half, half)
    }
    #[inline(always)]
    fn not_i16x32(self, a: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.not_i16x16(a0), self.not_i16x16(a1))
    }
    #[inline(always)]
    fn add_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.add_i16x16(a0, b0), self.add_i16x16(a1, b1))
    }
    #[inline(always)]
    fn sub_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.sub_i16x16(a0, b0), self.sub_i16x16(a1, b1))
    }
    #[inline(always)]
    fn mul_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.mul_i16x16(a0, b0), self.mul_i16x16(a1, b1))
    }
    #[inline(always)]
    fn and_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.and_i16x16(a0, b0), self.and_i16x16(a1, b1))
    }
    #[inline(always)]
    fn or_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.or_i16x16(a0, b0), self.or_i16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.xor_i16x16(a0, b0), self.xor_i16x16(a1, b1))
    }
    #[inline(always)]
    fn shr_i16x32(self, a: i16x32<Self>, b: u32) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.shr_i16x16(a0, b), self.shr_i16x16(a1, b))
    }
    #[inline(always)]
    fn shrv_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.shrv_i16x16(a0, b0), self.shrv_i16x16(a1, b1))
    }
    #[inline(always)]
    fn shl_i16x32(self, a: i16x32<Self>, b: u32) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.shl_i16x16(a0, b), self.shl_i16x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_eq_i16x16(a0, b0), self.simd_eq_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_lt_i16x16(a0, b0), self.simd_lt_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_le_i16x16(a0, b0), self.simd_le_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_ge_i16x16(a0, b0), self.simd_ge_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_gt_i16x16(a0, b0), self.simd_gt_i16x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, _) = self.split_i16x32(a);
        let (b0, _) = self.split_i16x32(b);
        self.combine_i16x16(self.zip_low_i16x16(a0, b0), self.zip_high_i16x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (_, a1) = self.split_i16x32(a);
        let (_, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.zip_low_i16x16(a1, b1), self.zip_high_i16x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.unzip_low_i16x16(a0, a1), self.unzip_low_i16x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(
            self.unzip_high_i16x16(a0, a1),
            self.unzip_high_i16x16(b0, b1),
        )
    }
    #[inline(always)]
    fn select_i16x32(self, a: mask16x32<Self>, b: i16x32<Self>, c: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        let (c0, c1) = self.split_i16x32(c);
        self.combine_i16x16(
            self.select_i16x16(a0, b0, c0),
            self.select_i16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn min_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.min_i16x16(a0, b0), self.min_i16x16(a1, b1))
    }
    #[inline(always)]
    fn max_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.max_i16x16(a0, b0), self.max_i16x16(a1, b1))
    }
    #[inline(always)]
    fn split_i16x32(self, a: i16x32<Self>) -> (i16x16<Self>, i16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i16x32(self, a: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.neg_i16x16(a0), self.neg_i16x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i16x32(self, a: i16x32<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_u8x32(
            self.reinterpret_u8_i16x16(a0),
            self.reinterpret_u8_i16x16(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u32_i16x32(self, a: i16x32<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_u32x8(
            self.reinterpret_u32_i16x16(a0),
            self.reinterpret_u32_i16x16(a1),
        )
    }
    #[inline(always)]
    fn splat_u16x32(self, a: u16) -> u16x32<Self> {
        let half = self.splat_u16x16(a);
        self.combine_u16x16(half, half)
    }
    #[inline(always)]
    fn not_u16x32(self, a: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.not_u16x16(a0), self.not_u16x16(a1))
    }
    #[inline(always)]
    fn add_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.add_u16x16(a0, b0), self.add_u16x16(a1, b1))
    }
    #[inline(always)]
    fn sub_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.sub_u16x16(a0, b0), self.sub_u16x16(a1, b1))
    }
    #[inline(always)]
    fn mul_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.mul_u16x16(a0, b0), self.mul_u16x16(a1, b1))
    }
    #[inline(always)]
    fn and_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.and_u16x16(a0, b0), self.and_u16x16(a1, b1))
    }
    #[inline(always)]
    fn or_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.or_u16x16(a0, b0), self.or_u16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.xor_u16x16(a0, b0), self.xor_u16x16(a1, b1))
    }
    #[inline(always)]
    fn shr_u16x32(self, a: u16x32<Self>, b: u32) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.shr_u16x16(a0, b), self.shr_u16x16(a1, b))
    }
    #[inline(always)]
    fn shrv_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.shrv_u16x16(a0, b0), self.shrv_u16x16(a1, b1))
    }
    #[inline(always)]
    fn shl_u16x32(self, a: u16x32<Self>, b: u32) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.shl_u16x16(a0, b), self.shl_u16x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_eq_u16x16(a0, b0), self.simd_eq_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_lt_u16x16(a0, b0), self.simd_lt_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_le_u16x16(a0, b0), self.simd_le_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_ge_u16x16(a0, b0), self.simd_ge_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_gt_u16x16(a0, b0), self.simd_gt_u16x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, _) = self.split_u16x32(a);
        let (b0, _) = self.split_u16x32(b);
        self.combine_u16x16(self.zip_low_u16x16(a0, b0), self.zip_high_u16x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (_, a1) = self.split_u16x32(a);
        let (_, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.zip_low_u16x16(a1, b1), self.zip_high_u16x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.unzip_low_u16x16(a0, a1), self.unzip_low_u16x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(
            self.unzip_high_u16x16(a0, a1),
            self.unzip_high_u16x16(b0, b1),
        )
    }
    #[inline(always)]
    fn select_u16x32(self, a: mask16x32<Self>, b: u16x32<Self>, c: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        let (c0, c1) = self.split_u16x32(c);
        self.combine_u16x16(
            self.select_u16x16(a0, b0, c0),
            self.select_u16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn min_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.min_u16x16(a0, b0), self.min_u16x16(a1, b1))
    }
    #[inline(always)]
    fn max_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.max_u16x16(a0, b0), self.max_u16x16(a1, b1))
    }
    #[inline(always)]
    fn split_u16x32(self, a: u16x32<Self>) -> (u16x16<Self>, u16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u16x32(self, src: &[u16; 32usize]) -> u16x32<Self> {
        let v0: v128 = unsafe { v128_load(src[0 * 8usize..].as_ptr() as *const v128) };
        let v1: v128 = unsafe { v128_load(src[1 * 8usize..].as_ptr() as *const v128) };
        let v2: v128 = unsafe { v128_load(src[2 * 8usize..].as_ptr() as *const v128) };
        let v3: v128 = unsafe { v128_load(src[3 * 8usize..].as_ptr() as *const v128) };
        let v01_lower = u16x8_shuffle::<0, 4, 8, 12, 1, 5, 9, 13>(v0, v1);
        let v23_lower = u16x8_shuffle::<0, 4, 8, 12, 1, 5, 9, 13>(v2, v3);
        let v01_upper = u16x8_shuffle::<2, 6, 10, 14, 3, 7, 11, 15>(v0, v1);
        let v23_upper = u16x8_shuffle::<2, 6, 10, 14, 3, 7, 11, 15>(v2, v3);
        let out0 = u16x8_shuffle::<0, 1, 2, 3, 8, 9, 10, 11>(v01_lower, v23_lower);
        let out1 = u16x8_shuffle::<4, 5, 6, 7, 12, 13, 14, 15>(v01_lower, v23_lower);
        let out2 = u16x8_shuffle::<0, 1, 2, 3, 8, 9, 10, 11>(v01_upper, v23_upper);
        let out3 = u16x8_shuffle::<4, 5, 6, 7, 12, 13, 14, 15>(v01_upper, v23_upper);
        let combined_lower = self.combine_u16x8(out0.simd_into(self), out1.simd_into(self));
        let combined_upper = self.combine_u16x8(out2.simd_into(self), out3.simd_into(self));
        self.combine_u16x16(combined_lower, combined_upper)
    }
    #[inline(always)]
    fn store_interleaved_128_u16x32(self, a: u16x32<Self>, dest: &mut [u16; 32usize]) -> () {
        let (lower, upper) = self.split_u16x32(a);
        let (v0_vec, v1_vec) = self.split_u16x16(lower);
        let (v2_vec, v3_vec) = self.split_u16x16(upper);
        let v0: v128 = v0_vec.into();
        let v1: v128 = v1_vec.into();
        let v2: v128 = v2_vec.into();
        let v3: v128 = v3_vec.into();
        let v02_lower = u16x8_shuffle::<0, 8, 1, 9, 2, 10, 3, 11>(v0, v2);
        let v13_lower = u16x8_shuffle::<0, 8, 1, 9, 2, 10, 3, 11>(v1, v3);
        let v02_upper = u16x8_shuffle::<4, 12, 5, 13, 6, 14, 7, 15>(v0, v2);
        let v13_upper = u16x8_shuffle::<4, 12, 5, 13, 6, 14, 7, 15>(v1, v3);
        let out0 = u16x8_shuffle::<0, 8, 1, 9, 2, 10, 3, 11>(v02_lower, v13_lower);
        let out1 = u16x8_shuffle::<4, 12, 5, 13, 6, 14, 7, 15>(v02_lower, v13_lower);
        let out2 = u16x8_shuffle::<0, 8, 1, 9, 2, 10, 3, 11>(v02_upper, v13_upper);
        let out3 = u16x8_shuffle::<4, 12, 5, 13, 6, 14, 7, 15>(v02_upper, v13_upper);
        unsafe {
            v128_store(dest[0 * 8usize..].as_mut_ptr() as *mut v128, out0);
            v128_store(dest[1 * 8usize..].as_mut_ptr() as *mut v128, out1);
            v128_store(dest[2 * 8usize..].as_mut_ptr() as *mut v128, out2);
            v128_store(dest[3 * 8usize..].as_mut_ptr() as *mut v128, out3);
        }
    }
    #[inline(always)]
    fn narrow_u16x32(self, a: u16x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u8x16(self.narrow_u16x16(a0), self.narrow_u16x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_u16x32(self, a: u16x32<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u8x32(
            self.reinterpret_u8_u16x16(a0),
            self.reinterpret_u8_u16x16(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u32_u16x32(self, a: u16x32<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u32x8(
            self.reinterpret_u32_u16x16(a0),
            self.reinterpret_u32_u16x16(a1),
        )
    }
    #[inline(always)]
    fn splat_mask16x32(self, a: i16) -> mask16x32<Self> {
        let half = self.splat_mask16x16(a);
        self.combine_mask16x16(half, half)
    }
    #[inline(always)]
    fn not_mask16x32(self, a: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        self.combine_mask16x16(self.not_mask16x16(a0), self.not_mask16x16(a1))
    }
    #[inline(always)]
    fn and_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.and_mask16x16(a0, b0), self.and_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn or_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.or_mask16x16(a0, b0), self.or_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.xor_mask16x16(a0, b0), self.xor_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn select_mask16x32(
        self,
        a: mask16x32<Self>,
        b: mask16x32<Self>,
        c: mask16x32<Self>,
    ) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        let (c0, c1) = self.split_mask16x32(c);
        self.combine_mask16x16(
            self.select_mask16x16(a0, b0, c0),
            self.select_mask16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(
            self.simd_eq_mask16x16(a0, b0),
            self.simd_eq_mask16x16(a1, b1),
        )
    }
    #[inline(always)]
    fn split_mask16x32(self, a: mask16x32<Self>) -> (mask16x16<Self>, mask16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i32x16(self, a: i32) -> i32x16<Self> {
        let half = self.splat_i32x8(a);
        self.combine_i32x8(half, half)
    }
    #[inline(always)]
    fn not_i32x16(self, a: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.not_i32x8(a0), self.not_i32x8(a1))
    }
    #[inline(always)]
    fn add_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.add_i32x8(a0, b0), self.add_i32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.sub_i32x8(a0, b0), self.sub_i32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.mul_i32x8(a0, b0), self.mul_i32x8(a1, b1))
    }
    #[inline(always)]
    fn and_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.and_i32x8(a0, b0), self.and_i32x8(a1, b1))
    }
    #[inline(always)]
    fn or_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.or_i32x8(a0, b0), self.or_i32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.xor_i32x8(a0, b0), self.xor_i32x8(a1, b1))
    }
    #[inline(always)]
    fn shr_i32x16(self, a: i32x16<Self>, b: u32) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.shr_i32x8(a0, b), self.shr_i32x8(a1, b))
    }
    #[inline(always)]
    fn shrv_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.shrv_i32x8(a0, b0), self.shrv_i32x8(a1, b1))
    }
    #[inline(always)]
    fn shl_i32x16(self, a: i32x16<Self>, b: u32) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.shl_i32x8(a0, b), self.shl_i32x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_eq_i32x8(a0, b0), self.simd_eq_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_lt_i32x8(a0, b0), self.simd_lt_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_le_i32x8(a0, b0), self.simd_le_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_ge_i32x8(a0, b0), self.simd_ge_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_gt_i32x8(a0, b0), self.simd_gt_i32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, _) = self.split_i32x16(a);
        let (b0, _) = self.split_i32x16(b);
        self.combine_i32x8(self.zip_low_i32x8(a0, b0), self.zip_high_i32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (_, a1) = self.split_i32x16(a);
        let (_, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.zip_low_i32x8(a1, b1), self.zip_high_i32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.unzip_low_i32x8(a0, a1), self.unzip_low_i32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.unzip_high_i32x8(a0, a1), self.unzip_high_i32x8(b0, b1))
    }
    #[inline(always)]
    fn select_i32x16(self, a: mask32x16<Self>, b: i32x16<Self>, c: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        let (c0, c1) = self.split_i32x16(c);
        self.combine_i32x8(self.select_i32x8(a0, b0, c0), self.select_i32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.min_i32x8(a0, b0), self.min_i32x8(a1, b1))
    }
    #[inline(always)]
    fn max_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.max_i32x8(a0, b0), self.max_i32x8(a1, b1))
    }
    #[inline(always)]
    fn split_i32x16(self, a: i32x16<Self>) -> (i32x8<Self>, i32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i32x16(self, a: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.neg_i32x8(a0), self.neg_i32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i32x16(self, a: i32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_u8x32(self.reinterpret_u8_i32x8(a0), self.reinterpret_u8_i32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i32x16(self, a: i32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_u32x8(
            self.reinterpret_u32_i32x8(a0),
            self.reinterpret_u32_i32x8(a1),
        )
    }
    #[inline(always)]
    fn cvt_f32_i32x16(self, a: i32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_f32x8(self.cvt_f32_i32x8(a0), self.cvt_f32_i32x8(a1))
    }
    #[inline(always)]
    fn splat_u32x16(self, a: u32) -> u32x16<Self> {
        let half = self.splat_u32x8(a);
        self.combine_u32x8(half, half)
    }
    #[inline(always)]
    fn not_u32x16(self, a: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.not_u32x8(a0), self.not_u32x8(a1))
    }
    #[inline(always)]
    fn add_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.add_u32x8(a0, b0), self.add_u32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.sub_u32x8(a0, b0), self.sub_u32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.mul_u32x8(a0, b0), self.mul_u32x8(a1, b1))
    }
    #[inline(always)]
    fn and_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.and_u32x8(a0, b0), self.and_u32x8(a1, b1))
    }
    #[inline(always)]
    fn or_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.or_u32x8(a0, b0), self.or_u32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.xor_u32x8(a0, b0), self.xor_u32x8(a1, b1))
    }
    #[inline(always)]
    fn shr_u32x16(self, a: u32x16<Self>, b: u32) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.shr_u32x8(a0, b), self.shr_u32x8(a1, b))
    }
    #[inline(always)]
    fn shrv_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.shrv_u32x8(a0, b0), self.shrv_u32x8(a1, b1))
    }
    #[inline(always)]
    fn shl_u32x16(self, a: u32x16<Self>, b: u32) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.shl_u32x8(a0, b), self.shl_u32x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_eq_u32x8(a0, b0), self.simd_eq_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_lt_u32x8(a0, b0), self.simd_lt_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_le_u32x8(a0, b0), self.simd_le_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_ge_u32x8(a0, b0), self.simd_ge_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_gt_u32x8(a0, b0), self.simd_gt_u32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, _) = self.split_u32x16(a);
        let (b0, _) = self.split_u32x16(b);
        self.combine_u32x8(self.zip_low_u32x8(a0, b0), self.zip_high_u32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (_, a1) = self.split_u32x16(a);
        let (_, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.zip_low_u32x8(a1, b1), self.zip_high_u32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.unzip_low_u32x8(a0, a1), self.unzip_low_u32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.unzip_high_u32x8(a0, a1), self.unzip_high_u32x8(b0, b1))
    }
    #[inline(always)]
    fn select_u32x16(self, a: mask32x16<Self>, b: u32x16<Self>, c: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        let (c0, c1) = self.split_u32x16(c);
        self.combine_u32x8(self.select_u32x8(a0, b0, c0), self.select_u32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.min_u32x8(a0, b0), self.min_u32x8(a1, b1))
    }
    #[inline(always)]
    fn max_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.max_u32x8(a0, b0), self.max_u32x8(a1, b1))
    }
    #[inline(always)]
    fn split_u32x16(self, a: u32x16<Self>) -> (u32x8<Self>, u32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u32x16(self, src: &[u32; 16usize]) -> u32x16<Self> {
        let v0: v128 = unsafe { v128_load(src[0 * 4usize..].as_ptr() as *const v128) };
        let v1: v128 = unsafe { v128_load(src[1 * 4usize..].as_ptr() as *const v128) };
        let v2: v128 = unsafe { v128_load(src[2 * 4usize..].as_ptr() as *const v128) };
        let v3: v128 = unsafe { v128_load(src[3 * 4usize..].as_ptr() as *const v128) };
        let v01_lower = u32x4_shuffle::<0, 4, 1, 5>(v0, v1);
        let v23_lower = u32x4_shuffle::<0, 4, 1, 5>(v2, v3);
        let v01_upper = u32x4_shuffle::<2, 6, 3, 7>(v0, v1);
        let v23_upper = u32x4_shuffle::<2, 6, 3, 7>(v2, v3);
        let out0 = u32x4_shuffle::<0, 1, 4, 5>(v01_lower, v23_lower);
        let out1 = u32x4_shuffle::<2, 3, 6, 7>(v01_lower, v23_lower);
        let out2 = u32x4_shuffle::<0, 1, 4, 5>(v01_upper, v23_upper);
        let out3 = u32x4_shuffle::<2, 3, 6, 7>(v01_upper, v23_upper);
        let combined_lower = self.combine_u32x4(out0.simd_into(self), out1.simd_into(self));
        let combined_upper = self.combine_u32x4(out2.simd_into(self), out3.simd_into(self));
        self.combine_u32x8(combined_lower, combined_upper)
    }
    #[inline(always)]
    fn store_interleaved_128_u32x16(self, a: u32x16<Self>, dest: &mut [u32; 16usize]) -> () {
        let (lower, upper) = self.split_u32x16(a);
        let (v0_vec, v1_vec) = self.split_u32x8(lower);
        let (v2_vec, v3_vec) = self.split_u32x8(upper);
        let v0: v128 = v0_vec.into();
        let v1: v128 = v1_vec.into();
        let v2: v128 = v2_vec.into();
        let v3: v128 = v3_vec.into();
        let v02_lower = u32x4_shuffle::<0, 4, 1, 5>(v0, v2);
        let v13_lower = u32x4_shuffle::<0, 4, 1, 5>(v1, v3);
        let v02_upper = u32x4_shuffle::<2, 6, 3, 7>(v0, v2);
        let v13_upper = u32x4_shuffle::<2, 6, 3, 7>(v1, v3);
        let out0 = u32x4_shuffle::<0, 4, 1, 5>(v02_lower, v13_lower);
        let out1 = u32x4_shuffle::<2, 6, 3, 7>(v02_lower, v13_lower);
        let out2 = u32x4_shuffle::<0, 4, 1, 5>(v02_upper, v13_upper);
        let out3 = u32x4_shuffle::<2, 6, 3, 7>(v02_upper, v13_upper);
        unsafe {
            v128_store(dest[0 * 4usize..].as_mut_ptr() as *mut v128, out0);
            v128_store(dest[1 * 4usize..].as_mut_ptr() as *mut v128, out1);
            v128_store(dest[2 * 4usize..].as_mut_ptr() as *mut v128, out2);
            v128_store(dest[3 * 4usize..].as_mut_ptr() as *mut v128, out3);
        }
    }
    #[inline(always)]
    fn reinterpret_u8_u32x16(self, a: u32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u8x32(self.reinterpret_u8_u32x8(a0), self.reinterpret_u8_u32x8(a1))
    }
    #[inline(always)]
    fn cvt_f32_u32x16(self, a: u32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_f32x8(self.cvt_f32_u32x8(a0), self.cvt_f32_u32x8(a1))
    }
    #[inline(always)]
    fn splat_mask32x16(self, a: i32) -> mask32x16<Self> {
        let half = self.splat_mask32x8(a);
        self.combine_mask32x8(half, half)
    }
    #[inline(always)]
    fn not_mask32x16(self, a: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        self.combine_mask32x8(self.not_mask32x8(a0), self.not_mask32x8(a1))
    }
    #[inline(always)]
    fn and_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.and_mask32x8(a0, b0), self.and_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn or_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.or_mask32x8(a0, b0), self.or_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.xor_mask32x8(a0, b0), self.xor_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn select_mask32x16(
        self,
        a: mask32x16<Self>,
        b: mask32x16<Self>,
        c: mask32x16<Self>,
    ) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        let (c0, c1) = self.split_mask32x16(c);
        self.combine_mask32x8(
            self.select_mask32x8(a0, b0, c0),
            self.select_mask32x8(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.simd_eq_mask32x8(a0, b0), self.simd_eq_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn split_mask32x16(self, a: mask32x16<Self>) -> (mask32x8<Self>, mask32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f64x8(self, a: f64) -> f64x8<Self> {
        let half = self.splat_f64x4(a);
        self.combine_f64x4(half, half)
    }
    #[inline(always)]
    fn abs_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.abs_f64x4(a0), self.abs_f64x4(a1))
    }
    #[inline(always)]
    fn neg_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.neg_f64x4(a0), self.neg_f64x4(a1))
    }
    #[inline(always)]
    fn sqrt_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.sqrt_f64x4(a0), self.sqrt_f64x4(a1))
    }
    #[inline(always)]
    fn add_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.add_f64x4(a0, b0), self.add_f64x4(a1, b1))
    }
    #[inline(always)]
    fn sub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.sub_f64x4(a0, b0), self.sub_f64x4(a1, b1))
    }
    #[inline(always)]
    fn mul_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.mul_f64x4(a0, b0), self.mul_f64x4(a1, b1))
    }
    #[inline(always)]
    fn div_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.div_f64x4(a0, b0), self.div_f64x4(a1, b1))
    }
    #[inline(always)]
    fn copysign_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.copysign_f64x4(a0, b0), self.copysign_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_eq_f64x4(a0, b0), self.simd_eq_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_lt_f64x4(a0, b0), self.simd_lt_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_le_f64x4(a0, b0), self.simd_le_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_ge_f64x4(a0, b0), self.simd_ge_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_gt_f64x4(a0, b0), self.simd_gt_f64x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, _) = self.split_f64x8(a);
        let (b0, _) = self.split_f64x8(b);
        self.combine_f64x4(self.zip_low_f64x4(a0, b0), self.zip_high_f64x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (_, a1) = self.split_f64x8(a);
        let (_, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.zip_low_f64x4(a1, b1), self.zip_high_f64x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.unzip_low_f64x4(a0, a1), self.unzip_low_f64x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.unzip_high_f64x4(a0, a1), self.unzip_high_f64x4(b0, b1))
    }
    #[inline(always)]
    fn max_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.max_f64x4(a0, b0), self.max_f64x4(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(
            self.max_precise_f64x4(a0, b0),
            self.max_precise_f64x4(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.min_f64x4(a0, b0), self.min_f64x4(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(
            self.min_precise_f64x4(a0, b0),
            self.min_precise_f64x4(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.madd_f64x4(a0, b0, c0), self.madd_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.msub_f64x4(a0, b0, c0), self.msub_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.floor_f64x4(a0), self.floor_f64x4(a1))
    }
    #[inline(always)]
    fn fract_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.fract_f64x4(a0), self.fract_f64x4(a1))
    }
    #[inline(always)]
    fn trunc_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.trunc_f64x4(a0), self.trunc_f64x4(a1))
    }
    #[inline(always)]
    fn select_f64x8(self, a: mask64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.select_f64x4(a0, b0, c0), self.select_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn split_f64x8(self, a: f64x8<Self>) -> (f64x4<Self>, f64x4<Self>) {
        let mut b0 = [0.0; 4usize];
        let mut b1 = [0.0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f32_f64x8(self, a: f64x8<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f32x8(
            self.reinterpret_f32_f64x4(a0),
            self.reinterpret_f32_f64x4(a1),
        )
    }
    #[inline(always)]
    fn splat_mask64x8(self, a: i64) -> mask64x8<Self> {
        let half = self.splat_mask64x4(a);
        self.combine_mask64x4(half, half)
    }
    #[inline(always)]
    fn not_mask64x8(self, a: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        self.combine_mask64x4(self.not_mask64x4(a0), self.not_mask64x4(a1))
    }
    #[inline(always)]
    fn and_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.and_mask64x4(a0, b0), self.and_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn or_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.or_mask64x4(a0, b0), self.or_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn xor_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.xor_mask64x4(a0, b0), self.xor_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn select_mask64x8(
        self,
        a: mask64x8<Self>,
        b: mask64x8<Self>,
        c: mask64x8<Self>,
    ) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        let (c0, c1) = self.split_mask64x8(c);
        self.combine_mask64x4(
            self.select_mask64x4(a0, b0, c0),
            self.select_mask64x4(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.simd_eq_mask64x4(a0, b0), self.simd_eq_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn split_mask64x8(self, a: mask64x8<Self>) -> (mask64x4<Self>, mask64x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
}
impl<S: Simd> SimdFrom<v128, S> for f32x4<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f32x4<S>> for v128 {
    #[inline(always)]
    fn from(value: f32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for i8x16<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i8x16<S>> for v128 {
    #[inline(always)]
    fn from(value: i8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for u8x16<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u8x16<S>> for v128 {
    #[inline(always)]
    fn from(value: u8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for mask8x16<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask8x16<S>> for v128 {
    #[inline(always)]
    fn from(value: mask8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for i16x8<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i16x8<S>> for v128 {
    #[inline(always)]
    fn from(value: i16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for u16x8<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u16x8<S>> for v128 {
    #[inline(always)]
    fn from(value: u16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for mask16x8<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask16x8<S>> for v128 {
    #[inline(always)]
    fn from(value: mask16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for i32x4<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i32x4<S>> for v128 {
    #[inline(always)]
    fn from(value: i32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for u32x4<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u32x4<S>> for v128 {
    #[inline(always)]
    fn from(value: u32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for mask32x4<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask32x4<S>> for v128 {
    #[inline(always)]
    fn from(value: mask32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for f64x2<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f64x2<S>> for v128 {
    #[inline(always)]
    fn from(value: f64x2<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<v128, S> for mask64x2<S> {
    #[inline(always)]
    fn simd_from(arch: v128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask64x2<S>> for v128 {
    #[inline(always)]
    fn from(value: mask64x2<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
