
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_parcsr_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

hypre_IJAssumedPart *
hypre_AssumedPartitionCreate( MPI_Comm comm, HYPRE_BigInt global_num, HYPRE_BigInt start, HYPRE_BigInt end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AssumedPartitionCreate)( comm, global_num, start, end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AssumedPartitionDestroy( hypre_IJAssumedPart *apart )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AssumedPartitionDestroy)( apart );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BooleanGenerateDiagAndOffd( hypre_CSRBooleanMatrix *A, hypre_ParCSRBooleanMatrix *matrix, HYPRE_BigInt first_col_diag, HYPRE_BigInt last_col_diag )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BooleanGenerateDiagAndOffd)( A, matrix, first_col_diag, last_col_diag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BooleanMatTCommPkgCreate( hypre_ParCSRBooleanMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BooleanMatTCommPkgCreate)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BooleanMatvecCommPkgCreate( hypre_ParCSRBooleanMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BooleanMatvecCommPkgCreate)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BuildCSRBooleanMatrixMPIDataType( HYPRE_Int num_nonzeros, HYPRE_Int num_rows, HYPRE_Int *a_i, HYPRE_Int *a_j, hypre_MPI_Datatype *csr_matrix_datatype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BuildCSRBooleanMatrixMPIDataType)( num_nonzeros, num_rows, a_i, a_j, csr_matrix_datatype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BuildCSRJDataType( HYPRE_Int num_nonzeros, HYPRE_Complex *a_data, HYPRE_Int *a_j, hypre_MPI_Datatype *csr_jdata_datatype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BuildCSRJDataType)( num_nonzeros, a_data, a_j, csr_jdata_datatype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BuildCSRMatrixMPIDataType( HYPRE_Int num_nonzeros, HYPRE_Int num_rows, HYPRE_Complex *a_data, HYPRE_Int *a_i, HYPRE_Int *a_j, hypre_MPI_Datatype *csr_matrix_datatype )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BuildCSRMatrixMPIDataType)( num_nonzeros, num_rows, a_data, a_i, a_j, csr_matrix_datatype );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRBooleanMatrixBigInitialize( hypre_CSRBooleanMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixBigInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

hypre_CSRBooleanMatrix *
hypre_CSRBooleanMatrixCreate( HYPRE_Int num_rows, HYPRE_Int num_cols, HYPRE_Int num_nonzeros )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixCreate)( num_rows, num_cols, num_nonzeros );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRBooleanMatrixDestroy( hypre_CSRBooleanMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRBooleanMatrixInitialize( hypre_CSRBooleanMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRBooleanMatrixPrint( hypre_CSRBooleanMatrix *matrix, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixPrint)( matrix, file_name );
}

/*--------------------------------------------------------------------------*/

hypre_CSRBooleanMatrix *
hypre_CSRBooleanMatrixRead( const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixRead)( file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRBooleanMatrixSetDataOwner( hypre_CSRBooleanMatrix *matrix, HYPRE_Int owns_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixSetDataOwner)( matrix, owns_data );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRBooleanMatrix *
hypre_CSRBooleanMatrixToParCSRBooleanMatrix( MPI_Comm comm, hypre_CSRBooleanMatrix *A, HYPRE_BigInt *row_starts, HYPRE_BigInt *col_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRBooleanMatrixToParCSRBooleanMatrix)( comm, A, row_starts, col_starts );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_CSRMatrixToParCSRMatrix( MPI_Comm comm, hypre_CSRMatrix *A, HYPRE_BigInt *row_starts, HYPRE_BigInt *col_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixToParCSRMatrix)( comm, A, row_starts, col_starts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ExchangeExternalRowsInit( hypre_CSRMatrix *B_ext, hypre_ParCSRCommPkg *comm_pkg_A, void **request_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ExchangeExternalRowsInit)( B_ext, comm_pkg_A, request_ptr );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix*
hypre_ExchangeExternalRowsWait( void *vequest )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ExchangeExternalRowsWait)( vequest );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FillResponseIJDetermineSendProcs( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FillResponseIJDetermineSendProcs)( p_recv_contact_buf, contact_size, contact_proc, ro, comm, p_send_response_buf, response_message_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FillResponseParToCSRMatrix( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FillResponseParToCSRMatrix)( p_recv_contact_buf, contact_size, contact_proc, ro, comm, p_send_response_buf, response_message_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FillResponseParToVectorAll( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FillResponseParToVectorAll)( p_recv_contact_buf, contact_size, contact_proc, ro, comm, p_send_response_buf, response_message_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GenerateDiagAndOffd( hypre_CSRMatrix *A, hypre_ParCSRMatrix *matrix, HYPRE_BigInt first_col_diag, HYPRE_BigInt last_col_diag )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateDiagAndOffd)( A, matrix, first_col_diag, last_col_diag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetAssumedPartitionProcFromRow( MPI_Comm comm, HYPRE_BigInt row, HYPRE_BigInt global_first_row, HYPRE_BigInt global_num_rows, HYPRE_Int *proc_id )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetAssumedPartitionProcFromRow)( comm, row, global_first_row, global_num_rows, proc_id );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetAssumedPartitionRowRange( MPI_Comm comm, HYPRE_Int proc_id, HYPRE_BigInt global_first_row, HYPRE_BigInt global_num_rows, HYPRE_BigInt *row_start, HYPRE_BigInt *row_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetAssumedPartitionRowRange)( comm, proc_id, global_first_row, global_num_rows, row_start, row_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LocateAssumedPartition( MPI_Comm comm, HYPRE_BigInt row_start, HYPRE_BigInt row_end, HYPRE_BigInt global_first_row, HYPRE_BigInt global_num_rows, hypre_IJAssumedPart *part, HYPRE_Int myid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LocateAssumedPartition)( comm, row_start, row_end, global_first_row, global_num_rows, part, myid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MatTCommPkgCreate( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatTCommPkgCreate)( A );
}

/*--------------------------------------------------------------------------*/

void
hypre_MatTCommPkgCreate_core( MPI_Comm comm, HYPRE_BigInt *col_map_offd, HYPRE_BigInt first_col_diag, HYPRE_BigInt *col_starts, HYPRE_Int num_rows_diag, HYPRE_Int num_cols_diag, HYPRE_Int num_cols_offd, HYPRE_BigInt *row_starts, HYPRE_BigInt firstColDiag, HYPRE_BigInt *colMapOffd, HYPRE_Int *mat_i_diag, HYPRE_Int *mat_j_diag, HYPRE_Int *mat_i_offd, HYPRE_Int *mat_j_offd, HYPRE_Int data, HYPRE_Int *p_num_recvs, HYPRE_Int **p_recv_procs, HYPRE_Int **p_recv_vec_starts, HYPRE_Int *p_num_sends, HYPRE_Int **p_send_procs, HYPRE_Int **p_send_map_starts, HYPRE_Int **p_send_map_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatTCommPkgCreate_core)( comm, col_map_offd, first_col_diag, col_starts, num_rows_diag, num_cols_diag, num_cols_offd, row_starts, firstColDiag, colMapOffd, mat_i_diag, mat_j_diag, mat_i_offd, mat_j_offd, data, p_num_recvs, p_recv_procs, p_recv_vec_starts, p_num_sends, p_send_procs, p_send_map_starts, p_send_map_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MatvecCommPkgCreate( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatvecCommPkgCreate)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MatvecCommPkgDestroy( hypre_ParCSRCommPkg *comm_pkg )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MatvecCommPkgDestroy)( comm_pkg );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_MergeDiagAndOffd( hypre_ParCSRMatrix *par_matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MergeDiagAndOffd)( par_matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NewCommPkgDestroy( hypre_ParCSRMatrix *parcsr_A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NewCommPkgDestroy)( parcsr_A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int *
hypre_NumbersArray( hypre_NumbersNode *node )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NumbersArray)( node );
}

/*--------------------------------------------------------------------------*/

void
hypre_NumbersDeleteNode( hypre_NumbersNode *node )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NumbersDeleteNode)( node );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NumbersEnter( hypre_NumbersNode *node, const HYPRE_Int n )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NumbersEnter)( node, n );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NumbersNEntered( hypre_NumbersNode *node )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NumbersNEntered)( node );
}

/*--------------------------------------------------------------------------*/

hypre_NumbersNode *
hypre_NumbersNewNode( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NumbersNewNode)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NumbersQuery( hypre_NumbersNode *node, const HYPRE_Int n )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NumbersQuery)( node, n );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParAat_RowSizes( HYPRE_Int **C_diag_i, HYPRE_Int **C_offd_i, HYPRE_Int *B_marker, HYPRE_Int *A_diag_i, HYPRE_Int *A_diag_j, HYPRE_Int *A_offd_i, HYPRE_Int *A_offd_j, HYPRE_BigInt *A_col_map_offd, HYPRE_Int *A_ext_i, HYPRE_BigInt *A_ext_j, HYPRE_BigInt *A_ext_row_map, HYPRE_Int *C_diag_size, HYPRE_Int *C_offd_size, HYPRE_Int num_rows_diag_A, HYPRE_Int num_cols_offd_A, HYPRE_Int num_rows_A_ext, HYPRE_BigInt first_col_diag_A, HYPRE_BigInt first_row_index_A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParAat_RowSizes)( C_diag_i, C_offd_i, B_marker, A_diag_i, A_diag_j, A_offd_i, A_offd_j, A_col_map_offd, A_ext_i, A_ext_j, A_ext_row_map, C_diag_size, C_offd_size, num_rows_diag_A, num_cols_offd_A, num_rows_A_ext, first_col_diag_A, first_row_index_A );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRBooleanMatrix *
hypre_ParBooleanAAt( hypre_ParCSRBooleanMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParBooleanAAt)( A );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRBooleanMatrix *
hypre_ParBooleanMatmul( hypre_ParCSRBooleanMatrix *A, hypre_ParCSRBooleanMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParBooleanMatmul)( A, B );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRAAt( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRAAt)( A );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRBooleanMatrix *
hypre_ParCSRBooleanMatrixCreate( MPI_Comm comm, HYPRE_BigInt global_num_rows, HYPRE_BigInt global_num_cols, HYPRE_BigInt *row_starts, HYPRE_BigInt *col_starts, HYPRE_Int num_cols_offd, HYPRE_Int num_nonzeros_diag, HYPRE_Int num_nonzeros_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixCreate)( comm, global_num_rows, global_num_cols, row_starts, col_starts, num_cols_offd, num_nonzeros_diag, num_nonzeros_offd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixDestroy( hypre_ParCSRBooleanMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

hypre_CSRBooleanMatrix *
hypre_ParCSRBooleanMatrixExtractAExt( hypre_ParCSRBooleanMatrix *A, HYPRE_BigInt **pA_ext_row_map )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixExtractAExt)( A, pA_ext_row_map );
}

/*--------------------------------------------------------------------------*/

hypre_CSRBooleanMatrix *
hypre_ParCSRBooleanMatrixExtractBExt( hypre_ParCSRBooleanMatrix *B, hypre_ParCSRBooleanMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixExtractBExt)( B, A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixGetLocalRange( hypre_ParCSRBooleanMatrix *matrix, HYPRE_BigInt *row_start, HYPRE_BigInt *row_end, HYPRE_BigInt *col_start, HYPRE_BigInt *col_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixGetLocalRange)( matrix, row_start, row_end, col_start, col_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixGetRow( hypre_ParCSRBooleanMatrix *mat, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixGetRow)( mat, row, size, col_ind );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixInitialize( hypre_ParCSRBooleanMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixPrint( hypre_ParCSRBooleanMatrix *matrix, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixPrint)( matrix, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixPrintIJ( hypre_ParCSRBooleanMatrix *matrix, const char *filename )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixPrintIJ)( matrix, filename );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRBooleanMatrix *
hypre_ParCSRBooleanMatrixRead( MPI_Comm comm, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixRead)( comm, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixRestoreRow( hypre_ParCSRBooleanMatrix *matrix, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixRestoreRow)( matrix, row, size, col_ind );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixSetColStartsOwner( hypre_ParCSRBooleanMatrix *matrix, HYPRE_Int owns_col_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixSetColStartsOwner)( matrix, owns_col_starts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixSetDataOwner( hypre_ParCSRBooleanMatrix *matrix, HYPRE_Int owns_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixSetDataOwner)( matrix, owns_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixSetNNZ( hypre_ParCSRBooleanMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixSetNNZ)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRBooleanMatrixSetRowStartsOwner( hypre_ParCSRBooleanMatrix *matrix, HYPRE_Int owns_row_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRBooleanMatrixSetRowStartsOwner)( matrix, owns_row_starts );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRCommHandle *
hypre_ParCSRCommHandleCreate( HYPRE_Int job, hypre_ParCSRCommPkg *comm_pkg, void *send_data, void *recv_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommHandleCreate)( job, comm_pkg, send_data, recv_data );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRCommHandle *
hypre_ParCSRCommHandleCreate_v2( HYPRE_Int job, hypre_ParCSRCommPkg *comm_pkg, HYPRE_MemoryLocation send_memory_location, void *send_data_in, HYPRE_MemoryLocation recv_memory_location, void *recv_data_in )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommHandleCreate_v2)( job, comm_pkg, send_memory_location, send_data_in, recv_memory_location, recv_data_in );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRCommHandleDestroy( hypre_ParCSRCommHandle *comm_handle )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommHandleDestroy)( comm_handle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRCommPkgCreate( MPI_Comm comm, HYPRE_BigInt *col_map_offd, HYPRE_BigInt first_col_diag, HYPRE_BigInt *col_starts, HYPRE_Int num_cols_diag, HYPRE_Int num_cols_offd, hypre_ParCSRCommPkg *comm_pkg )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommPkgCreate)( comm, col_map_offd, first_col_diag, col_starts, num_cols_diag, num_cols_offd, comm_pkg );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRCommPkgCreateAndFill( MPI_Comm comm, HYPRE_Int num_recvs, HYPRE_Int *recv_procs, HYPRE_Int *recv_vec_starts, HYPRE_Int num_sends, HYPRE_Int *send_procs, HYPRE_Int *send_map_starts, HYPRE_Int *send_map_elmts, hypre_ParCSRCommPkg **comm_pkg_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommPkgCreateAndFill)( comm, num_recvs, recv_procs, recv_vec_starts, num_sends, send_procs, send_map_starts, send_map_elmts, comm_pkg_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRCommPkgCreateApart( MPI_Comm comm, HYPRE_BigInt *col_map_off_d, HYPRE_BigInt first_col_diag, HYPRE_Int num_cols_off_d, HYPRE_BigInt global_num_cols, hypre_IJAssumedPart *apart, hypre_ParCSRCommPkg *comm_pkg )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommPkgCreateApart)( comm, col_map_off_d, first_col_diag, num_cols_off_d, global_num_cols, apart, comm_pkg );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRCommPkgCreateApart_core( MPI_Comm comm, HYPRE_BigInt *col_map_off_d, HYPRE_BigInt first_col_diag, HYPRE_Int num_cols_off_d, HYPRE_BigInt global_num_cols, HYPRE_Int *p_num_recvs, HYPRE_Int **p_recv_procs, HYPRE_Int **p_recv_vec_starts, HYPRE_Int *p_num_sends, HYPRE_Int **p_send_procs, HYPRE_Int **p_send_map_starts, HYPRE_Int **p_send_map_elements, hypre_IJAssumedPart *apart )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommPkgCreateApart_core)( comm, col_map_off_d, first_col_diag, num_cols_off_d, global_num_cols, p_num_recvs, p_recv_procs, p_recv_vec_starts, p_num_sends, p_send_procs, p_send_map_starts, p_send_map_elements, apart );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParCSRCommPkgCreate_core( MPI_Comm comm, HYPRE_BigInt *col_map_offd, HYPRE_BigInt first_col_diag, HYPRE_BigInt *col_starts, HYPRE_Int num_cols_diag, HYPRE_Int num_cols_offd, HYPRE_Int *p_num_recvs, HYPRE_Int **p_recv_procs, HYPRE_Int **p_recv_vec_starts, HYPRE_Int *p_num_sends, HYPRE_Int **p_send_procs, HYPRE_Int **p_send_map_starts, HYPRE_Int **p_send_map_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommPkgCreate_core)( comm, col_map_offd, first_col_diag, col_starts, num_cols_diag, num_cols_offd, p_num_recvs, p_recv_procs, p_recv_vec_starts, p_num_sends, p_send_procs, p_send_map_starts, p_send_map_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRCommPkgUpdateVecStarts( hypre_ParCSRCommPkg *comm_pkg, HYPRE_Int num_components_in, HYPRE_Int vecstride, HYPRE_Int idxstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRCommPkgUpdateVecStarts)( comm_pkg, num_components_in, vecstride, idxstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRDiagScaleVector( hypre_ParCSRMatrix *par_A, hypre_ParVector *par_y, hypre_ParVector *par_x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRDiagScaleVector)( par_A, par_y, par_x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRDiagScaleVectorHost( hypre_ParCSRMatrix *par_A, hypre_ParVector *par_y, hypre_ParVector *par_x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRDiagScaleVectorHost)( par_A, par_y, par_x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRFindExtendCommPkg( MPI_Comm comm, HYPRE_BigInt global_num_cols, HYPRE_BigInt first_col_diag, HYPRE_Int num_cols_diag, HYPRE_BigInt *col_starts, hypre_IJAssumedPart *apart, HYPRE_Int indices_len, HYPRE_BigInt *indices, hypre_ParCSRCommPkg **extend_comm_pkg )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRFindExtendCommPkg)( comm, global_num_cols, first_col_diag, num_cols_diag, col_starts, apart, indices_len, indices, extend_comm_pkg );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRMatMat( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatMat)( A, B );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatMatDiag( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B, hypre_ParCSRMatrix **C_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatMatDiag)( A, B, C_ptr );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRMatMatHost( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatMatHost)( A, B );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixAdd( HYPRE_Complex alpha, hypre_ParCSRMatrix *A, HYPRE_Complex beta, hypre_ParCSRMatrix *B, hypre_ParCSRMatrix **Cout )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixAdd)( alpha, A, beta, B, Cout );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixAddHost( HYPRE_Complex alpha, hypre_ParCSRMatrix *A, HYPRE_Complex beta, hypre_ParCSRMatrix *B, hypre_ParCSRMatrix **Cout )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixAddHost)( alpha, A, beta, B, Cout );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixAminvDB( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B, HYPRE_Complex *d, hypre_ParCSRMatrix **C_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixAminvDB)( A, B, d, C_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixBlkFilter( hypre_ParCSRMatrix *A, HYPRE_Int block_size, hypre_ParCSRMatrix **B_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixBlkFilter)( A, block_size, B_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixBlockColSum( hypre_ParCSRMatrix *A, HYPRE_Int row_major, HYPRE_Int num_rows_block, HYPRE_Int num_cols_block, hypre_DenseBlockMatrix **B_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixBlockColSum)( A, row_major, num_rows_block, num_cols_block, B_ptr );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix*
hypre_ParCSRMatrixClone( hypre_ParCSRMatrix *A, HYPRE_Int copy_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixClone)( A, copy_data );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix*
hypre_ParCSRMatrixClone_v2( hypre_ParCSRMatrix *A, HYPRE_Int copy_data, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixClone_v2)( A, copy_data, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixColSum( hypre_ParCSRMatrix *A, hypre_ParVector **B_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixColSum)( A, B_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixCompressOffdMap( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCompressOffdMap)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixComputeScalingTagged( hypre_ParCSRMatrix *A, HYPRE_Int type, HYPRE_MemoryLocation memloc_tags, HYPRE_Int num_tags, HYPRE_Int *tags, hypre_ParVector **scaling_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixComputeScalingTagged)( A, type, memloc_tags, num_tags, tags, scaling_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixCopy( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B, HYPRE_Int copy_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCopy)( A, B, copy_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixCopyColMapOffdToDevice( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCopyColMapOffdToDevice)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixCopyColMapOffdToHost( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCopyColMapOffdToHost)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixCopy_C( hypre_ParCSRMatrix *P, hypre_ParCSRMatrix *C, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCopy_C)( P, C, CF_marker );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRMatrixCreate( MPI_Comm comm, HYPRE_BigInt global_num_rows, HYPRE_BigInt global_num_cols, HYPRE_BigInt *row_starts_in, HYPRE_BigInt *col_starts_in, HYPRE_Int num_cols_offd, HYPRE_Int num_nonzeros_diag, HYPRE_Int num_nonzeros_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCreate)( comm, global_num_rows, global_num_cols, row_starts_in, col_starts_in, num_cols_offd, num_nonzeros_diag, num_nonzeros_offd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixCreateAssumedPartition( hypre_ParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCreateAssumedPartition)( matrix );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix*
hypre_ParCSRMatrixCreateFromDenseBlockMatrix( MPI_Comm comm, HYPRE_BigInt global_num_rows, HYPRE_BigInt global_num_cols, HYPRE_BigInt *row_starts, HYPRE_BigInt *col_starts, hypre_DenseBlockMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCreateFromDenseBlockMatrix)( comm, global_num_rows, global_num_cols, row_starts, col_starts, B );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix*
hypre_ParCSRMatrixCreateFromParVector( hypre_ParVector *b, HYPRE_BigInt global_num_rows, HYPRE_BigInt global_num_cols, HYPRE_BigInt *row_starts, HYPRE_BigInt *col_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixCreateFromParVector)( b, global_num_rows, global_num_cols, row_starts, col_starts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixDestroy( hypre_ParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixDiagScale( hypre_ParCSRMatrix *par_A, hypre_ParVector *par_ld, hypre_ParVector *par_rd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixDiagScale)( par_A, par_ld, par_rd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixDropSmallEntries( hypre_ParCSRMatrix *A, HYPRE_Real tol, HYPRE_Int type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixDropSmallEntries)( A, tol, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixDropSmallEntriesHost( hypre_ParCSRMatrix *A, HYPRE_Real tol, HYPRE_Int type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixDropSmallEntriesHost)( A, tol, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixEliminateRowsCols( hypre_ParCSRMatrix *A, HYPRE_Int nrows, HYPRE_Int *rows )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixEliminateRowsCols)( A, nrows, rows );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_ParCSRMatrixExtractAExt( hypre_ParCSRMatrix *A, HYPRE_Int data, HYPRE_BigInt **pA_ext_row_map )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractAExt)( A, data, pA_ext_row_map );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_ParCSRMatrixExtractBExt( hypre_ParCSRMatrix *B, hypre_ParCSRMatrix *A, HYPRE_Int data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractBExt)( B, A, data );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParCSRMatrixExtractBExt_Arrays( HYPRE_Int **pB_ext_i, HYPRE_BigInt **pB_ext_j, HYPRE_Complex **pB_ext_data, HYPRE_BigInt **pB_ext_row_map, HYPRE_Int *num_nonzeros, HYPRE_Int data, HYPRE_Int find_row_map, MPI_Comm comm, hypre_ParCSRCommPkg *comm_pkg, HYPRE_Int num_cols_B, HYPRE_Int num_recvs, HYPRE_Int num_sends, HYPRE_BigInt first_col_diag, HYPRE_BigInt *row_starts, HYPRE_Int *recv_vec_starts, HYPRE_Int *send_map_starts, HYPRE_Int *send_map_elmts, HYPRE_Int *diag_i, HYPRE_Int *diag_j, HYPRE_Int *offd_i, HYPRE_Int *offd_j, HYPRE_BigInt *col_map_offd, HYPRE_Real *diag_data, HYPRE_Real *offd_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractBExt_Arrays)( pB_ext_i, pB_ext_j, pB_ext_data, pB_ext_row_map, num_nonzeros, data, find_row_map, comm, comm_pkg, num_cols_B, num_recvs, num_sends, first_col_diag, row_starts, recv_vec_starts, send_map_starts, send_map_elmts, diag_i, diag_j, offd_i, offd_j, col_map_offd, diag_data, offd_data );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParCSRMatrixExtractBExt_Arrays_Overlap( HYPRE_Int **pB_ext_i, HYPRE_BigInt **pB_ext_j, HYPRE_Complex **pB_ext_data, HYPRE_BigInt **pB_ext_row_map, HYPRE_Int *num_nonzeros, HYPRE_Int data, HYPRE_Int find_row_map, MPI_Comm comm, hypre_ParCSRCommPkg *comm_pkg, HYPRE_Int num_cols_B, HYPRE_Int num_recvs, HYPRE_Int num_sends, HYPRE_BigInt first_col_diag, HYPRE_BigInt *row_starts, HYPRE_Int *recv_vec_starts, HYPRE_Int *send_map_starts, HYPRE_Int *send_map_elmts, HYPRE_Int *diag_i, HYPRE_Int *diag_j, HYPRE_Int *offd_i, HYPRE_Int *offd_j, HYPRE_BigInt *col_map_offd, HYPRE_Real *diag_data, HYPRE_Real *offd_data, hypre_ParCSRCommHandle **comm_handle_idx, hypre_ParCSRCommHandle **comm_handle_data, HYPRE_Int *CF_marker, HYPRE_Int *CF_marker_offd, HYPRE_Int skip_fine, HYPRE_Int skip_same_sign )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractBExt_Arrays_Overlap)( pB_ext_i, pB_ext_j, pB_ext_data, pB_ext_row_map, num_nonzeros, data, find_row_map, comm, comm_pkg, num_cols_B, num_recvs, num_sends, first_col_diag, row_starts, recv_vec_starts, send_map_starts, send_map_elmts, diag_i, diag_j, offd_i, offd_j, col_map_offd, diag_data, offd_data, comm_handle_idx, comm_handle_data, CF_marker, CF_marker_offd, skip_fine, skip_same_sign );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_ParCSRMatrixExtractBExt_Overlap( hypre_ParCSRMatrix *B, hypre_ParCSRMatrix *A, HYPRE_Int data, hypre_ParCSRCommHandle **comm_handle_idx, hypre_ParCSRCommHandle **comm_handle_data, HYPRE_Int *CF_marker, HYPRE_Int *CF_marker_offd, HYPRE_Int skip_fine, HYPRE_Int skip_same_sign )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractBExt_Overlap)( B, A, data, comm_handle_idx, comm_handle_data, CF_marker, CF_marker_offd, skip_fine, skip_same_sign );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParCSRMatrixExtractRowSubmatrices( hypre_ParCSRMatrix *A_csr, HYPRE_Int *indices2, hypre_ParCSRMatrix ***submatrices )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractRowSubmatrices)( A_csr, indices2, submatrices );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParCSRMatrixExtractSubmatrices( hypre_ParCSRMatrix *A_csr, HYPRE_Int *indices2, hypre_ParCSRMatrix ***submatrices )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractSubmatrices)( A_csr, indices2, submatrices );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixExtractSubmatrixFC( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *cpts_starts, const char *job, hypre_ParCSRMatrix **B_ptr, HYPRE_Real strength_thresh )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractSubmatrixFC)( A, CF_marker, cpts_starts, job, B_ptr, strength_thresh );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_ParCSRMatrixFnorm( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixFnorm)( A );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParCSRMatrixGenSpanningTree( hypre_ParCSRMatrix *G_csr, HYPRE_Int **indices, HYPRE_Int G_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixGenSpanningTree)( G_csr, indices, G_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixGenerateFFFC( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *cpts_starts, hypre_ParCSRMatrix *S, hypre_ParCSRMatrix **A_FC_ptr, hypre_ParCSRMatrix **A_FF_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixGenerateFFFC)( A, CF_marker, cpts_starts, S, A_FC_ptr, A_FF_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixGenerateFFFC3( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *cpts_starts, hypre_ParCSRMatrix *S, hypre_ParCSRMatrix **A_FC_ptr, hypre_ParCSRMatrix **A_FF_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixGenerateFFFC3)( A, CF_marker, cpts_starts, S, A_FC_ptr, A_FF_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixGenerateFFFCD3( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *cpts_starts, hypre_ParCSRMatrix *S, hypre_ParCSRMatrix **A_FC_ptr, hypre_ParCSRMatrix **A_FF_ptr, HYPRE_Real **D_lambda_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixGenerateFFFCD3)( A, CF_marker, cpts_starts, S, A_FC_ptr, A_FF_ptr, D_lambda_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixGenerateFFFCHost( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *cpts_starts, hypre_ParCSRMatrix *S, hypre_ParCSRMatrix **A_FC_ptr, hypre_ParCSRMatrix **A_FF_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixGenerateFFFCHost)( A, CF_marker, cpts_starts, S, A_FC_ptr, A_FF_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixGetLocalRange( hypre_ParCSRMatrix *matrix, HYPRE_BigInt *row_start, HYPRE_BigInt *row_end, HYPRE_BigInt *col_start, HYPRE_BigInt *col_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixGetLocalRange)( matrix, row_start, row_end, col_start, col_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixGetRow( hypre_ParCSRMatrix *mat, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind, HYPRE_Complex **values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixGetRow)( mat, row, size, col_ind, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixInfNorm( hypre_ParCSRMatrix *A, HYPRE_Real *norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixInfNorm)( A, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixInitialize( hypre_ParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixInitialize_v2( hypre_ParCSRMatrix *matrix, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixInitialize_v2)( matrix, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Complex
hypre_ParCSRMatrixLocalSumElts( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixLocalSumElts)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixLocalTranspose( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixLocalTranspose)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixMatvec( HYPRE_Complex alpha, hypre_ParCSRMatrix *A, hypre_ParVector *x, HYPRE_Complex beta, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixMatvec)( alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixMatvecOutOfPlace( HYPRE_Complex alpha, hypre_ParCSRMatrix *A, hypre_ParVector *x, HYPRE_Complex beta, hypre_ParVector *b, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixMatvecOutOfPlace)( alpha, A, x, beta, b, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixMatvecT( HYPRE_Complex alpha, hypre_ParCSRMatrix *A, hypre_ParVector *x, HYPRE_Complex beta, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixMatvecT)( alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixMatvec_FF( HYPRE_Complex alpha, hypre_ParCSRMatrix *A, hypre_ParVector *x, HYPRE_Complex beta, hypre_ParVector *y, HYPRE_Int *CF_marker, HYPRE_Int fpt )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixMatvec_FF)( alpha, A, x, beta, y, CF_marker, fpt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixMigrate( hypre_ParCSRMatrix *A, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixMigrate)( A, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixPrint( hypre_ParCSRMatrix *matrix, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixPrint)( matrix, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixPrintBinaryIJ( hypre_ParCSRMatrix *matrix, HYPRE_Int base_i, HYPRE_Int base_j, const char *filename )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixPrintBinaryIJ)( matrix, base_i, base_j, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixPrintIJ( const hypre_ParCSRMatrix *matrix, const HYPRE_Int base_i, const HYPRE_Int base_j, const char *filename )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixPrintIJ)( matrix, base_i, base_j, filename );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRMatrixRAP( hypre_ParCSRMatrix *R, hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *P )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixRAP)( R, A, P );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRMatrixRAPKT( hypre_ParCSRMatrix *R, hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *P, HYPRE_Int keep_transpose, HYPRE_Int has_diagonal )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixRAPKT)( R, A, P, keep_transpose, has_diagonal );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix*
hypre_ParCSRMatrixRAPKTHost( hypre_ParCSRMatrix *R, hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *P, HYPRE_Int keep_transpose )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixRAPKTHost)( R, A, P, keep_transpose );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRMatrixRead( MPI_Comm comm, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixRead)( comm, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixReadIJ( MPI_Comm comm, const char *filename, HYPRE_Int *base_i_ptr, HYPRE_Int *base_j_ptr, hypre_ParCSRMatrix **matrix_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixReadIJ)( comm, filename, base_i_ptr, base_j_ptr, matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixReorder( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixReorder)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixRestoreRow( hypre_ParCSRMatrix *matrix, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind, HYPRE_Complex **values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixRestoreRow)( matrix, row, size, col_ind, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixScale( hypre_ParCSRMatrix *A, HYPRE_Complex scalar )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixScale)( A, scalar );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixSetConstantValues( hypre_ParCSRMatrix *A, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixSetConstantValues)( A, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixSetDNumNonzeros( hypre_ParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixSetDNumNonzeros)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixSetDataOwner( hypre_ParCSRMatrix *matrix, HYPRE_Int owns_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixSetDataOwner)( matrix, owns_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixSetNumNonzeros( hypre_ParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixSetNumNonzeros)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixSetNumRownnz( hypre_ParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixSetNumRownnz)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixSetPatternOnly( hypre_ParCSRMatrix *matrix, HYPRE_Int pattern_only )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixSetPatternOnly)( matrix, pattern_only );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixStatsArrayCompute( HYPRE_Int num_matrices, hypre_ParCSRMatrix **matrices, hypre_MatrixStatsArray *stats_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixStatsArrayCompute)( num_matrices, matrices, stats_array );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_ParCSRMatrixToCSRMatrixAll( hypre_ParCSRMatrix *par_matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixToCSRMatrixAll)( par_matrix );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix *
hypre_ParCSRMatrixToCSRMatrixAll_v2( hypre_ParCSRMatrix *par_matrix, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixToCSRMatrixAll_v2)( par_matrix, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixTranspose( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **AT_ptr, HYPRE_Int data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixTranspose)( A, AT_ptr, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixTransposeHost( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **AT_ptr, HYPRE_Int data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixTransposeHost)( A, AT_ptr, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixTruncate( hypre_ParCSRMatrix *A, HYPRE_Real tol, HYPRE_Int max_row_elmts, HYPRE_Int rescale, HYPRE_Int nrm_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixTruncate)( A, tol, max_row_elmts, rescale, nrm_type );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRMatrixUnion( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixUnion)( A, B );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixZero_F( hypre_ParCSRMatrix *P, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixZero_F)( P, CF_marker );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRTMatMat( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRTMatMat)( A, B );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRTMatMatKT( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B, HYPRE_Int keep_transpose )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRTMatMatKT)( A, B, keep_transpose );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParCSRTMatMatKTHost( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B, HYPRE_Int keep_transpose )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRTMatMatKTHost)( A, B, keep_transpose );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParMatMinus_F( hypre_ParCSRMatrix *P, hypre_ParCSRMatrix *C, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMatMinus_F)( P, C, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParMatScaleDiagInv_F( hypre_ParCSRMatrix *C, hypre_ParCSRMatrix *A, HYPRE_Complex weight, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMatScaleDiagInv_F)( C, A, weight, CF_marker );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParMatmul( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMatmul)( A, B );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParMatmul_FC( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *P, HYPRE_Int *CF_marker, HYPRE_Int *dof_func, HYPRE_Int *dof_func_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMatmul_FC)( A, P, CF_marker, dof_func, dof_func_offd );
}

/*--------------------------------------------------------------------------*/

void
hypre_ParMatmul_RowSizes( HYPRE_MemoryLocation memory_location, HYPRE_Int **C_diag_i, HYPRE_Int **C_offd_i, HYPRE_Int *rownnz_A, HYPRE_Int *A_diag_i, HYPRE_Int *A_diag_j, HYPRE_Int *A_offd_i, HYPRE_Int *A_offd_j, HYPRE_Int *B_diag_i, HYPRE_Int *B_diag_j, HYPRE_Int *B_offd_i, HYPRE_Int *B_offd_j, HYPRE_Int *B_ext_diag_i, HYPRE_Int *B_ext_diag_j, HYPRE_Int *B_ext_offd_i, HYPRE_Int *B_ext_offd_j, HYPRE_Int *map_B_to_C, HYPRE_Int *C_diag_size, HYPRE_Int *C_offd_size, HYPRE_Int num_rownnz_A, HYPRE_Int num_rows_diag_A, HYPRE_Int num_cols_offd_A, HYPRE_Int allsquare, HYPRE_Int num_cols_diag_B, HYPRE_Int num_cols_offd_B, HYPRE_Int num_cols_offd_C )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMatmul_RowSizes)( memory_location, C_diag_i, C_offd_i, rownnz_A, A_diag_i, A_diag_j, A_offd_i, A_offd_j, B_diag_i, B_diag_j, B_offd_i, B_offd_j, B_ext_diag_i, B_ext_diag_j, B_ext_offd_i, B_ext_offd_j, map_B_to_C, C_diag_size, C_offd_size, num_rownnz_A, num_rows_diag_A, num_cols_offd_A, allsquare, num_cols_diag_B, num_cols_offd_B, num_cols_offd_C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParMatmul_RowSizes_Marked( HYPRE_Int **C_diag_i, HYPRE_Int **C_offd_i, HYPRE_Int **B_marker, HYPRE_Int *A_diag_i, HYPRE_Int *A_diag_j, HYPRE_Int *A_offd_i, HYPRE_Int *A_offd_j, HYPRE_Int *B_diag_i, HYPRE_Int *B_diag_j, HYPRE_Int *B_offd_i, HYPRE_Int *B_offd_j, HYPRE_Int *B_ext_diag_i, HYPRE_Int *B_ext_diag_j, HYPRE_Int *B_ext_offd_i, HYPRE_Int *B_ext_offd_j, HYPRE_Int *map_B_to_C, HYPRE_Int *C_diag_size, HYPRE_Int *C_offd_size, HYPRE_Int num_rows_diag_A, HYPRE_Int num_cols_offd_A, HYPRE_Int allsquare, HYPRE_Int num_cols_diag_B, HYPRE_Int num_cols_offd_B, HYPRE_Int num_cols_offd_C, HYPRE_Int *CF_marker, HYPRE_Int *dof_func, HYPRE_Int *dof_func_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMatmul_RowSizes_Marked)( C_diag_i, C_offd_i, B_marker, A_diag_i, A_diag_j, A_offd_i, A_offd_j, B_diag_i, B_diag_j, B_offd_i, B_offd_j, B_ext_diag_i, B_ext_diag_j, B_ext_offd_i, B_ext_offd_j, map_B_to_C, C_diag_size, C_offd_size, num_rows_diag_A, num_cols_offd_A, allsquare, num_cols_diag_B, num_cols_offd_B, num_cols_offd_C, CF_marker, dof_func, dof_func_offd );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_ParMultiVectorCreate( MPI_Comm comm, HYPRE_BigInt global_size, HYPRE_BigInt *partitioning, HYPRE_Int num_vectors )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMultiVectorCreate)( comm, global_size, partitioning, num_vectors );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_ParTMatmul( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParTMatmul)( A, B );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorAxpy( HYPRE_Complex alpha, hypre_ParVector *x, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorAxpy)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorAxpyz( HYPRE_Complex alpha, hypre_ParVector *x, HYPRE_Complex beta, hypre_ParVector *y, hypre_ParVector *z )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorAxpyz)( alpha, x, beta, y, z );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_ParVectorCloneDeep_v2( hypre_ParVector *x, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorCloneDeep_v2)( x, memory_location );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_ParVectorCloneShallow( hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorCloneShallow)( x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorCopy( hypre_ParVector *x, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorCopy)( x, y );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_ParVectorCreate( MPI_Comm comm, HYPRE_BigInt global_size, HYPRE_BigInt *partitioning_in )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorCreate)( comm, global_size, partitioning_in );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorCreateAssumedPartition( hypre_ParVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorCreateAssumedPartition)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorDestroy( hypre_ParVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorDestroy)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorGetValues( hypre_ParVector *vector, HYPRE_Int num_values, HYPRE_BigInt *indices, HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorGetValues)( vector, num_values, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorGetValues2( hypre_ParVector *vector, HYPRE_Int num_values, HYPRE_BigInt *indices, HYPRE_BigInt base, HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorGetValues2)( vector, num_values, indices, base, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorGetValuesHost( hypre_ParVector *vector, HYPRE_Int num_values, HYPRE_BigInt *indices, HYPRE_BigInt base, HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorGetValuesHost)( vector, num_values, indices, base, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorInitialize( hypre_ParVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorInitialize)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorInitializeShell( hypre_ParVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorInitializeShell)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorInitialize_v2( hypre_ParVector *vector, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorInitialize_v2)( vector, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_ParVectorInnerProd( hypre_ParVector *x, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorInnerProd)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorInnerProdTagged( hypre_ParVector *x, hypre_ParVector *y, HYPRE_Int *num_tags_ptr, HYPRE_Complex **iprod_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorInnerProdTagged)( x, y, num_tags_ptr, iprod_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Complex
hypre_ParVectorLocalSumElts( hypre_ParVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorLocalSumElts)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorMassAxpy( HYPRE_Complex *alpha, hypre_ParVector **x, hypre_ParVector *y, HYPRE_Int k, HYPRE_Int unroll )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorMassAxpy)( alpha, x, y, k, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorMassDotpTwo( hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector **z, HYPRE_Int k, HYPRE_Int unroll, HYPRE_Real *prod_x, HYPRE_Real *prod_y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorMassDotpTwo)( x, y, z, k, unroll, prod_x, prod_y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorMassInnerProd( hypre_ParVector *x, hypre_ParVector **y, HYPRE_Int k, HYPRE_Int unroll, HYPRE_Real *prod )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorMassInnerProd)( x, y, k, unroll, prod );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorMigrate( hypre_ParVector *x, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorMigrate)( x, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPointwiseDivision( hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector **z_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPointwiseDivision)( x, y, z_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPointwiseDivpy( hypre_ParVector *x, hypre_ParVector *b, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPointwiseDivpy)( x, b, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPointwiseDivpyMarked( hypre_ParVector *x, hypre_ParVector *b, hypre_ParVector *y, HYPRE_Int *marker, HYPRE_Int marker_val )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPointwiseDivpyMarked)( x, b, y, marker, marker_val );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPointwiseInverse( hypre_ParVector *x, hypre_ParVector **y_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPointwiseInverse)( x, y_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPointwiseProduct( hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector **z_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPointwiseProduct)( x, y, z_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPrint( hypre_ParVector *vector, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPrint)( vector, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPrintBinaryIJ( hypre_ParVector *par_vector, const char *filename )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPrintBinaryIJ)( par_vector, filename );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorPrintIJ( hypre_ParVector *vector, HYPRE_Int base_j, const char *filename )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorPrintIJ)( vector, base_j, filename );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_ParVectorRead( MPI_Comm comm, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorRead)( comm, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorReadIJ( MPI_Comm comm, const char *filename, HYPRE_Int *base_j_ptr, hypre_ParVector **vector_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorReadIJ)( comm, filename, base_j_ptr, vector_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorResize( hypre_ParVector *vector, HYPRE_Int size, HYPRE_Int num_vectors )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorResize)( vector, size, num_vectors );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorScale( HYPRE_Complex alpha, hypre_ParVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorScale)( alpha, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetComponent( hypre_ParVector *vector, HYPRE_Int component )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetComponent)( vector, component );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetConstantValues( hypre_ParVector *v, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetConstantValues)( v, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetData( hypre_ParVector *vector, HYPRE_Complex *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetData)( vector, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetDataOwner( hypre_ParVector *vector, HYPRE_Int owns_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetDataOwner)( vector, owns_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetLocalSize( hypre_ParVector *vector, HYPRE_Int local_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetLocalSize)( vector, local_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetNumTags( hypre_ParVector *vector, HYPRE_Int num_tags )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetNumTags)( vector, num_tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetOwnsTags( hypre_ParVector *vector, HYPRE_Int owns_tags )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetOwnsTags)( vector, owns_tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetRandomValues( hypre_ParVector *v, HYPRE_Int seed )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetRandomValues)( v, seed );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetTags( hypre_ParVector *vector, HYPRE_MemoryLocation memory_location, HYPRE_Int *tags )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetTags)( vector, memory_location, tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetValuesTagged( hypre_ParVector *vector, HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetValuesTagged)( vector, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSetZeros( hypre_ParVector *v )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSetZeros)( v );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorStridedCopy( hypre_ParVector *x, HYPRE_Int istride, HYPRE_Int ostride, HYPRE_Int size, HYPRE_Complex *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorStridedCopy)( x, istride, ostride, size, data );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_ParVectorToVectorAll( hypre_ParVector *par_v )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorToVectorAll)( par_v );
}

/*--------------------------------------------------------------------------*/

hypre_Vector *
hypre_ParVectorToVectorAll_v2( hypre_ParVector *par_v, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorToVectorAll_v2)( par_v, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParcsrBdiagInvScal( hypre_ParCSRMatrix *A, HYPRE_Int blockSize, hypre_ParCSRMatrix **As )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParcsrBdiagInvScal)( A, blockSize, As );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParcsrGetExternalRowsInit( hypre_ParCSRMatrix *A, HYPRE_Int indices_len, HYPRE_BigInt *indices, hypre_ParCSRCommPkg *comm_pkg, HYPRE_Int want_data, void **request_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParcsrGetExternalRowsInit)( A, indices_len, indices, comm_pkg, want_data, request_ptr );
}

/*--------------------------------------------------------------------------*/

hypre_CSRMatrix*
hypre_ParcsrGetExternalRowsWait( void *vrequest )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParcsrGetExternalRowsWait)( vrequest );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParvecBdiagInvScal( hypre_ParVector *b, HYPRE_Int blockSize, hypre_ParVector **bs, hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParvecBdiagInvScal)( b, blockSize, bs, A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PrintCommpkg( hypre_ParCSRMatrix *A, const char *file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PrintCommpkg)( A, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RangeFillResponseIJDetermineRecvProcs( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RangeFillResponseIJDetermineRecvProcs)( p_recv_contact_buf, contact_size, contact_proc, ro, comm, p_send_response_buf, response_message_size );
}

/*--------------------------------------------------------------------------*/

void
hypre_RowsWithColumn( HYPRE_Int *rowmin, HYPRE_Int *rowmax, HYPRE_BigInt column, HYPRE_Int num_rows_diag, HYPRE_BigInt firstColDiag, HYPRE_BigInt *colMapOffd, HYPRE_Int *mat_i_diag, HYPRE_Int *mat_j_diag, HYPRE_Int *mat_i_offd, HYPRE_Int *mat_j_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RowsWithColumn)( rowmin, rowmax, column, num_rows_diag, firstColDiag, colMapOffd, mat_i_diag, mat_j_diag, mat_i_offd, mat_j_offd );
}

/*--------------------------------------------------------------------------*/

void
hypre_RowsWithColumn_original( HYPRE_Int *rowmin, HYPRE_Int *rowmax, HYPRE_BigInt column, hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RowsWithColumn_original)( rowmin, rowmax, column, A );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_VectorToParVector( MPI_Comm comm, hypre_Vector *v, HYPRE_BigInt *vec_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_VectorToParVector)( comm, v, vec_starts );
}


#endif

