// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief e+e- -> 3pi+3pi-, 2pi+pi-2pi0, 2pi+pi-K+K-
  class BABAR_2006_I709730 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BABAR_2006_I709730);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      _sqs = {"", "", ""};
      for (size_t ix=0; ix<_sqs.size(); ++ix) {
        book(_sigma[ix], 1+ix, 1,1);
        for (const string& en : _sigma[ix].binning().edges<0>()) {
          const double eval = std::stod(en)*GeV;
          if (isCompatibleWithSqrtS(eval)) {
            _sqs[ix] = en;
            break;
          }
        }
      }
      raiseBeamErrorIf(_sqs[0].empty() && _sqs[1].empty() && _sqs[2].empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }

      if (ntotal!=6) vetoEvent;
      if (nCount[-211]==3 && nCount[211]==3) {
        if (!_sqs[0].empty()) _sigma[0]->fill(_sqs[0]);
      }
      else if(nCount[-211]==2 && nCount[211]==2 && nCount[111]==2) {
        if (!_sqs[1].empty()) _sigma[1]->fill(_sqs[1]);
      }
      else if (nCount[-211]==2 &&
               nCount[211]==2  &&
               nCount[321]==1  &&
               nCount[-321]==1) {
        if(!_sqs[2].empty()) _sigma[2]->fill(_sqs[2]);
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_sigma, crossSection()/ sumOfWeights() /nanobarn);
    }

    /// @}

    // just count the number of events of the types we're looking for
    BinnedHistoPtr<string> _sigma[3];
    vector<string> _sqs;
  };


  RIVET_DECLARE_PLUGIN(BABAR_2006_I709730);


}
