// Code generated by running "go generate". DO NOT EDIT.

// Copyright 2021 The Wuffs Authors.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// https://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT

package armneonintrinsics

const stringTable = "" +
	"__a__acc__b__c__d__elem__hash_abcd__hash_e__hash_efgh__idx__imm2" +
	"__inactive__index__lane__lane1__lane2__ptr__r__src__tab__tw0_3__" +
	"v__val__vec__w0_3__w12_15__w4_7__w8_11__wkdataimm6keyvaba_s16vab" +
	"a_s32vaba_s8vaba_u16vaba_u32vaba_u8vabal_high_s16vabal_high_s32v" +
	"abal_high_s8vabal_high_u16vabal_high_u32vabal_high_u8vabal_s16va" +
	"bal_s32vabal_s8vabal_u16vabal_u32vabal_u8vabaq_s16vabaq_s32vabaq" +
	"_s8vabaq_u16vabaq_u32vabaq_u8vabd_f16vabd_f32vabd_f64vabd_s16vab" +
	"d_s32vabd_s8vabd_u16vabd_u32vabd_u8vabdd_f64vabdl_high_s16vabdl_" +
	"high_s32vabdl_high_s8vabdl_high_u16vabdl_high_u32vabdl_high_u8va" +
	"bdl_s16vabdl_s32vabdl_s8vabdl_u16vabdl_u32vabdl_u8vabdq_f16vabdq" +
	"_f32vabdq_f64vabdq_s16vabdq_s32vabdq_s8vabdq_u16vabdq_u32vabdq_u" +
	"8vabds_f32vabs_f16vabs_f32vabs_f64vabs_s16vabs_s32vabs_s64vabs_s" +
	"8vabsd_s64vabsq_f16vabsq_f32vabsq_f64vabsq_s16vabsq_s32vabsq_s64" +
	"vabsq_s8vadd_f16vadd_f32vadd_f64vadd_p16vadd_p64vadd_p8vadd_s16v" +
	"add_s32vadd_s64vadd_s8vadd_u16vadd_u32vadd_u64vadd_u8vaddd_s64va" +
	"ddd_u64vaddhn_high_s16vaddhn_high_s32vaddhn_high_s64vaddhn_high_" +
	"u16vaddhn_high_u32vaddhn_high_u64vaddhn_s16vaddhn_s32vaddhn_s64v" +
	"addhn_u16vaddhn_u32vaddhn_u64vaddl_high_s16vaddl_high_s32vaddl_h" +
	"igh_s8vaddl_high_u16vaddl_high_u32vaddl_high_u8vaddl_s16vaddl_s3" +
	"2vaddl_s8vaddl_u16vaddl_u32vaddl_u8vaddlv_s16vaddlv_s32vaddlv_s8" +
	"vaddlv_u16vaddlv_u32vaddlv_u8vaddlvq_s16vaddlvq_s32vaddlvq_s8vad" +
	"dlvq_u16vaddlvq_u32vaddlvq_u8vaddq_f16vaddq_f32vaddq_f64vaddq_p1" +
	"28vaddq_p16vaddq_p64vaddq_p8vaddq_s16vaddq_s32vaddq_s64vaddq_s8v" +
	"addq_u16vaddq_u32vaddq_u64vaddq_u8vaddv_f32vaddv_s16vaddv_s32vad" +
	"dv_s8vaddv_u16vaddv_u32vaddv_u8vaddvq_f32vaddvq_f64vaddvq_s16vad" +
	"dvq_s32vaddvq_s64vaddvq_s8vaddvq_u16vaddvq_u32vaddvq_u64vaddvq_u" +
	"8vaddw_high_s16vaddw_high_s32vaddw_high_s8vaddw_high_u16vaddw_hi" +
	"gh_u32vaddw_high_u8vaddw_s16vaddw_s32vaddw_s8vaddw_u16vaddw_u32v" +
	"addw_u8vaesdq_u8vaeseq_u8vaesimcq_u8vaesmcq_u8valvand_s16vand_s3" +
	"2vand_s64vand_s8vand_u16vand_u32vand_u64vand_u8vandq_s16vandq_s3" +
	"2vandq_s64vandq_s8vandq_u16vandq_u32vandq_u64vandq_u8vbcaxq_s16v" +
	"bcaxq_s32vbcaxq_s64vbcaxq_s8vbcaxq_u16vbcaxq_u32vbcaxq_u64vbcaxq" +
	"_u8vbfdot_f32vbfdot_lane_f32vbfdot_laneq_f32vbfdotq_f32vbfdotq_l" +
	"ane_f32vbfdotq_laneq_f32vbfmlalbq_f32vbfmlalbq_lane_f32vbfmlalbq" +
	"_laneq_f32vbfmlaltq_f32vbfmlaltq_lane_f32vbfmlaltq_laneq_f32vbfm" +
	"mlaq_f32vbic_s16vbic_s32vbic_s64vbic_s8vbic_u16vbic_u32vbic_u64v" +
	"bic_u8vbicq_s16vbicq_s32vbicq_s64vbicq_s8vbicq_u16vbicq_u32vbicq" +
	"_u64vbicq_u8vbsl_f16vbsl_f32vbsl_f64vbsl_p16vbsl_p64vbsl_p8vbsl_" +
	"s16vbsl_s32vbsl_s64vbsl_s8vbsl_u16vbsl_u32vbsl_u64vbsl_u8vbslq_f" +
	"16vbslq_f32vbslq_f64vbslq_p16vbslq_p64vbslq_p8vbslq_s16vbslq_s32" +
	"vbslq_s64vbslq_s8vbslq_u16vbslq_u32vbslq_u64vbslq_u8vcadd_rot270" +
	"_f16vcadd_rot270_f32vcadd_rot90_f16vcadd_rot90_f32vcaddq_rot270_" +
	"f16vcaddq_rot270_f32vcaddq_rot270_f64vcaddq_rot90_f16vcaddq_rot9" +
	"0_f32vcaddq_rot90_f64vcage_f16vcage_f32vcage_f64vcaged_f64vcageq" +
	"_f16vcageq_f32vcageq_f64vcages_f32vcagt_f16vcagt_f32vcagt_f64vca" +
	"gtd_f64vcagtq_f16vcagtq_f32vcagtq_f64vcagts_f32vcale_f16vcale_f3" +
	"2vcale_f64vcaled_f64vcaleq_f16vcaleq_f32vcaleq_f64vcales_f32vcal" +
	"t_f16vcalt_f32vcalt_f64vcaltd_f64vcaltq_f16vcaltq_f32vcaltq_f64v" +
	"calts_f32vceq_f16vceq_f32vceq_f64vceq_p64vceq_p8vceq_s16vceq_s32" +
	"vceq_s64vceq_s8vceq_u16vceq_u32vceq_u64vceq_u8vceqd_f64vceqd_s64" +
	"vceqd_u64vceqq_f16vceqq_f32vceqq_f64vceqq_p64vceqq_p8vceqq_s16vc" +
	"eqq_s32vceqq_s64vceqq_s8vceqq_u16vceqq_u32vceqq_u64vceqq_u8vceqs" +
	"_f32vceqz_f16vceqz_f32vceqz_f64vceqz_p64vceqz_p8vceqz_s16vceqz_s" +
	"32vceqz_s64vceqz_s8vceqz_u16vceqz_u32vceqz_u64vceqz_u8vceqzd_f64" +
	"vceqzd_s64vceqzd_u64vceqzq_f16vceqzq_f32vceqzq_f64vceqzq_p64vceq" +
	"zq_p8vceqzq_s16vceqzq_s32vceqzq_s64vceqzq_s8vceqzq_u16vceqzq_u32" +
	"vceqzq_u64vceqzq_u8vceqzs_f32vcge_f16vcge_f32vcge_f64vcge_s16vcg" +
	"e_s32vcge_s64vcge_s8vcge_u16vcge_u32vcge_u64vcge_u8vcged_f64vcge" +
	"d_s64vcged_u64vcgeq_f16vcgeq_f32vcgeq_f64vcgeq_s16vcgeq_s32vcgeq" +
	"_s64vcgeq_s8vcgeq_u16vcgeq_u32vcgeq_u64vcgeq_u8vcges_f32vcgez_f1" +
	"6vcgez_f32vcgez_f64vcgez_s16vcgez_s32vcgez_s64vcgez_s8vcgezd_f64" +
	"vcgezd_s64vcgezq_f16vcgezq_f32vcgezq_f64vcgezq_s16vcgezq_s32vcge" +
	"zq_s64vcgezq_s8vcgezs_f32vcgt_f16vcgt_f32vcgt_f64vcgt_s16vcgt_s3" +
	"2vcgt_s64vcgt_s8vcgt_u16vcgt_u32vcgt_u64vcgt_u8vcgtd_f64vcgtd_s6" +
	"4vcgtd_u64vcgtq_f16vcgtq_f32vcgtq_f64vcgtq_s16vcgtq_s32vcgtq_s64" +
	"vcgtq_s8vcgtq_u16vcgtq_u32vcgtq_u64vcgtq_u8vcgts_f32vcgtz_f16vcg" +
	"tz_f32vcgtz_f64vcgtz_s16vcgtz_s32vcgtz_s64vcgtz_s8vcgtzd_f64vcgt" +
	"zd_s64vcgtzq_f16vcgtzq_f32vcgtzq_f64vcgtzq_s16vcgtzq_s32vcgtzq_s" +
	"64vcgtzq_s8vcgtzs_f32vcle_f16vcle_f32vcle_f64vcle_s16vcle_s32vcl" +
	"e_s64vcle_s8vcle_u16vcle_u32vcle_u64vcle_u8vcled_f64vcled_s64vcl" +
	"ed_u64vcleq_f16vcleq_f32vcleq_f64vcleq_s16vcleq_s32vcleq_s64vcle" +
	"q_s8vcleq_u16vcleq_u32vcleq_u64vcleq_u8vcles_f32vclez_f16vclez_f" +
	"32vclez_f64vclez_s16vclez_s32vclez_s64vclez_s8vclezd_f64vclezd_s" +
	"64vclezq_f16vclezq_f32vclezq_f64vclezq_s16vclezq_s32vclezq_s64vc" +
	"lezq_s8vclezs_f32vcls_s16vcls_s32vcls_s8vcls_u16vcls_u32vcls_u8v" +
	"clsq_s16vclsq_s32vclsq_s8vclsq_u16vclsq_u32vclsq_u8vclt_f16vclt_" +
	"f32vclt_f64vclt_s16vclt_s32vclt_s64vclt_s8vclt_u16vclt_u32vclt_u" +
	"64vclt_u8vcltd_f64vcltd_s64vcltd_u64vcltq_f16vcltq_f32vcltq_f64v" +
	"cltq_s16vcltq_s32vcltq_s64vcltq_s8vcltq_u16vcltq_u32vcltq_u64vcl" +
	"tq_u8vclts_f32vcltz_f16vcltz_f32vcltz_f64vcltz_s16vcltz_s32vcltz" +
	"_s64vcltz_s8vcltzd_f64vcltzd_s64vcltzq_f16vcltzq_f32vcltzq_f64vc" +
	"ltzq_s16vcltzq_s32vcltzq_s64vcltzq_s8vcltzs_f32vclz_s16vclz_s32v" +
	"clz_s8vclz_u16vclz_u32vclz_u8vclzq_s16vclzq_s32vclzq_s8vclzq_u16" +
	"vclzq_u32vclzq_u8vcmla_f16vcmla_f32vcmla_lane_f16vcmla_lane_f32v" +
	"cmla_laneq_f16vcmla_laneq_f32vcmla_rot180_f16vcmla_rot180_f32vcm" +
	"la_rot180_lane_f16vcmla_rot180_lane_f32vcmla_rot180_laneq_f16vcm" +
	"la_rot180_laneq_f32vcmla_rot270_f16vcmla_rot270_f32vcmla_rot270_" +
	"lane_f16vcmla_rot270_lane_f32vcmla_rot270_laneq_f16vcmla_rot270_" +
	"laneq_f32vcmla_rot90_f16vcmla_rot90_f32vcmla_rot90_lane_f16vcmla" +
	"_rot90_lane_f32vcmla_rot90_laneq_f16vcmla_rot90_laneq_f32vcmlaq_" +
	"f16vcmlaq_f32vcmlaq_f64vcmlaq_lane_f16vcmlaq_lane_f32vcmlaq_lane" +
	"q_f16vcmlaq_laneq_f32vcmlaq_rot180_f16vcmlaq_rot180_f32vcmlaq_ro" +
	"t180_f64vcmlaq_rot180_lane_f16vcmlaq_rot180_lane_f32vcmlaq_rot18" +
	"0_laneq_f16vcmlaq_rot180_laneq_f32vcmlaq_rot270_f16vcmlaq_rot270" +
	"_f32vcmlaq_rot270_f64vcmlaq_rot270_lane_f16vcmlaq_rot270_lane_f3" +
	"2vcmlaq_rot270_laneq_f16vcmlaq_rot270_laneq_f32vcmlaq_rot90_f16v" +
	"cmlaq_rot90_f32vcmlaq_rot90_f64vcmlaq_rot90_lane_f16vcmlaq_rot90" +
	"_lane_f32vcmlaq_rot90_laneq_f16vcmlaq_rot90_laneq_f32vcnt_p8vcnt" +
	"_s8vcnt_u8vcntq_p8vcntq_s8vcntq_u8vcombine_bf16vcombine_f16vcomb" +
	"ine_f32vcombine_f64vcombine_p16vcombine_p64vcombine_p8vcombine_s" +
	"16vcombine_s32vcombine_s64vcombine_s8vcombine_u16vcombine_u32vco" +
	"mbine_u64vcombine_u8vcopy_lane_bf16vcopy_lane_f32vcopy_lane_f64v" +
	"copy_lane_p16vcopy_lane_p64vcopy_lane_p8vcopy_lane_s16vcopy_lane" +
	"_s32vcopy_lane_s64vcopy_lane_s8vcopy_lane_u16vcopy_lane_u32vcopy" +
	"_lane_u64vcopy_lane_u8vcopy_laneq_bf16vcopy_laneq_f32vcopy_laneq" +
	"_f64vcopy_laneq_p16vcopy_laneq_p64vcopy_laneq_p8vcopy_laneq_s16v" +
	"copy_laneq_s32vcopy_laneq_s64vcopy_laneq_s8vcopy_laneq_u16vcopy_" +
	"laneq_u32vcopy_laneq_u64vcopy_laneq_u8vcopyq_lane_bf16vcopyq_lan" +
	"e_f32vcopyq_lane_f64vcopyq_lane_p16vcopyq_lane_p64vcopyq_lane_p8" +
	"vcopyq_lane_s16vcopyq_lane_s32vcopyq_lane_s64vcopyq_lane_s8vcopy" +
	"q_lane_u16vcopyq_lane_u32vcopyq_lane_u64vcopyq_lane_u8vcopyq_lan" +
	"eq_bf16vcopyq_laneq_f32vcopyq_laneq_f64vcopyq_laneq_p16vcopyq_la" +
	"neq_p64vcopyq_laneq_p8vcopyq_laneq_s16vcopyq_laneq_s32vcopyq_lan" +
	"eq_s64vcopyq_laneq_s8vcopyq_laneq_u16vcopyq_laneq_u32vcopyq_lane" +
	"q_u64vcopyq_laneq_u8vcreate_bf16vcreate_f16vcreate_f32vcreate_f6" +
	"4vcreate_p16vcreate_p64vcreate_p8vcreate_s16vcreate_s32vcreate_s" +
	"64vcreate_s8vcreate_u16vcreate_u32vcreate_u64vcreate_u8vcvt_bf16" +
	"_f32vcvt_f16_f32vcvt_f16_s16vcvt_f16_u16vcvt_f32_bf16vcvt_f32_f1" +
	"6vcvt_f32_f64vcvt_f32_s32vcvt_f32_u32vcvt_f64_f32vcvt_f64_s64vcv" +
	"t_f64_u64vcvt_high_f16_f32vcvt_high_f32_f16vcvt_high_f32_f64vcvt" +
	"_high_f64_f32vcvt_n_f16_s16vcvt_n_f16_u16vcvt_n_f32_s32vcvt_n_f3" +
	"2_u32vcvt_n_f64_s64vcvt_n_f64_u64vcvt_n_s16_f16vcvt_n_s32_f32vcv" +
	"t_n_s64_f64vcvt_n_u16_f16vcvt_n_u32_f32vcvt_n_u64_f64vcvt_s16_f1" +
	"6vcvt_s32_f32vcvt_s64_f64vcvt_u16_f16vcvt_u32_f32vcvt_u64_f64vcv" +
	"ta_s16_f16vcvta_s32_f32vcvta_s64_f64vcvta_u16_f16vcvta_u32_f32vc" +
	"vta_u64_f64vcvtad_s64_f64vcvtad_u64_f64vcvtaq_s16_f16vcvtaq_s32_" +
	"f32vcvtaq_s64_f64vcvtaq_u16_f16vcvtaq_u32_f32vcvtaq_u64_f64vcvta" +
	"s_s32_f32vcvtas_u32_f32vcvtd_f64_s64vcvtd_f64_u64vcvtd_n_f64_s64" +
	"vcvtd_n_f64_u64vcvtd_n_s64_f64vcvtd_n_u64_f64vcvtd_s64_f64vcvtd_" +
	"u64_f64vcvtm_s16_f16vcvtm_s32_f32vcvtm_s64_f64vcvtm_u16_f16vcvtm" +
	"_u32_f32vcvtm_u64_f64vcvtmd_s64_f64vcvtmd_u64_f64vcvtmq_s16_f16v" +
	"cvtmq_s32_f32vcvtmq_s64_f64vcvtmq_u16_f16vcvtmq_u32_f32vcvtmq_u6" +
	"4_f64vcvtms_s32_f32vcvtms_u32_f32vcvtn_s16_f16vcvtn_s32_f32vcvtn" +
	"_s64_f64vcvtn_u16_f16vcvtn_u32_f32vcvtn_u64_f64vcvtnd_s64_f64vcv" +
	"tnd_u64_f64vcvtnq_s16_f16vcvtnq_s32_f32vcvtnq_s64_f64vcvtnq_u16_" +
	"f16vcvtnq_u32_f32vcvtnq_u64_f64vcvtns_s32_f32vcvtns_u32_f32vcvtp" +
	"_s16_f16vcvtp_s32_f32vcvtp_s64_f64vcvtp_u16_f16vcvtp_u32_f32vcvt" +
	"p_u64_f64vcvtpd_s64_f64vcvtpd_u64_f64vcvtpq_s16_f16vcvtpq_s32_f3" +
	"2vcvtpq_s64_f64vcvtpq_u16_f16vcvtpq_u32_f32vcvtpq_u64_f64vcvtps_" +
	"s32_f32vcvtps_u32_f32vcvtq_f16_s16vcvtq_f16_u16vcvtq_f32_s32vcvt" +
	"q_f32_u32vcvtq_f64_s64vcvtq_f64_u64vcvtq_high_bf16_f32vcvtq_high" +
	"_f32_bf16vcvtq_low_bf16_f32vcvtq_low_f32_bf16vcvtq_n_f16_s16vcvt" +
	"q_n_f16_u16vcvtq_n_f32_s32vcvtq_n_f32_u32vcvtq_n_f64_s64vcvtq_n_" +
	"f64_u64vcvtq_n_s16_f16vcvtq_n_s32_f32vcvtq_n_s64_f64vcvtq_n_u16_" +
	"f16vcvtq_n_u32_f32vcvtq_n_u64_f64vcvtq_s16_f16vcvtq_s32_f32vcvtq" +
	"_s64_f64vcvtq_u16_f16vcvtq_u32_f32vcvtq_u64_f64vcvts_f32_s32vcvt" +
	"s_f32_u32vcvts_n_f32_s32vcvts_n_f32_u32vcvts_n_s32_f32vcvts_n_u3" +
	"2_f32vcvts_s32_f32vcvts_u32_f32vcvtx_f32_f64vcvtx_high_f32_f64vc" +
	"vtxd_f32_f64vdiv_f16vdiv_f32vdiv_f64vdivq_f16vdivq_f32vdivq_f64v" +
	"dot_lane_s32vdot_lane_u32vdot_laneq_s32vdot_laneq_u32vdot_s32vdo" +
	"t_u32vdotq_lane_s32vdotq_lane_u32vdotq_laneq_s32vdotq_laneq_u32v" +
	"dotq_s32vdotq_u32vdup_lane_bf16vdup_lane_f16vdup_lane_f32vdup_la" +
	"ne_f64vdup_lane_p16vdup_lane_p64vdup_lane_p8vdup_lane_s16vdup_la" +
	"ne_s32vdup_lane_s64vdup_lane_s8vdup_lane_u16vdup_lane_u32vdup_la" +
	"ne_u64vdup_lane_u8vdup_laneq_bf16vdup_laneq_f16vdup_laneq_f32vdu" +
	"p_laneq_f64vdup_laneq_p16vdup_laneq_p64vdup_laneq_p8vdup_laneq_s" +
	"16vdup_laneq_s32vdup_laneq_s64vdup_laneq_s8vdup_laneq_u16vdup_la" +
	"neq_u32vdup_laneq_u64vdup_laneq_u8vdup_n_bf16vdup_n_f16vdup_n_f3" +
	"2vdup_n_f64vdup_n_p16vdup_n_p64vdup_n_p8vdup_n_s16vdup_n_s32vdup" +
	"_n_s64vdup_n_s8vdup_n_u16vdup_n_u32vdup_n_u64vdup_n_u8vdupb_lane" +
	"_p8vdupb_lane_s8vdupb_lane_u8vdupb_laneq_p8vdupb_laneq_s8vdupb_l" +
	"aneq_u8vdupd_lane_f64vdupd_lane_s64vdupd_lane_u64vdupd_laneq_f64" +
	"vdupd_laneq_s64vdupd_laneq_u64vduph_lane_bf16vduph_lane_f16vduph" +
	"_lane_p16vduph_lane_s16vduph_lane_u16vduph_laneq_bf16vduph_laneq" +
	"_f16vduph_laneq_p16vduph_laneq_s16vduph_laneq_u16vdupq_lane_bf16" +
	"vdupq_lane_f16vdupq_lane_f32vdupq_lane_f64vdupq_lane_p16vdupq_la" +
	"ne_p64vdupq_lane_p8vdupq_lane_s16vdupq_lane_s32vdupq_lane_s64vdu" +
	"pq_lane_s8vdupq_lane_u16vdupq_lane_u32vdupq_lane_u64vdupq_lane_u" +
	"8vdupq_laneq_bf16vdupq_laneq_f16vdupq_laneq_f32vdupq_laneq_f64vd" +
	"upq_laneq_p16vdupq_laneq_p64vdupq_laneq_p8vdupq_laneq_s16vdupq_l" +
	"aneq_s32vdupq_laneq_s64vdupq_laneq_s8vdupq_laneq_u16vdupq_laneq_" +
	"u32vdupq_laneq_u64vdupq_laneq_u8vdupq_n_bf16vdupq_n_f16vdupq_n_f" +
	"32vdupq_n_f64vdupq_n_p16vdupq_n_p64vdupq_n_p8vdupq_n_s16vdupq_n_" +
	"s32vdupq_n_s64vdupq_n_s8vdupq_n_u16vdupq_n_u32vdupq_n_u64vdupq_n" +
	"_u8vdups_lane_f32vdups_lane_s32vdups_lane_u32vdups_laneq_f32vdup" +
	"s_laneq_s32vdups_laneq_u32veor3q_s16veor3q_s32veor3q_s64veor3q_s" +
	"8veor3q_u16veor3q_u32veor3q_u64veor3q_u8veor_s16veor_s32veor_s64" +
	"veor_s8veor_u16veor_u32veor_u64veor_u8veorq_s16veorq_s32veorq_s6" +
	"4veorq_s8veorq_u16veorq_u32veorq_u64veorq_u8vext_f16vext_f32vext" +
	"_f64vext_p16vext_p64vext_p8vext_s16vext_s32vext_s64vext_s8vext_u" +
	"16vext_u32vext_u64vext_u8vextq_f16vextq_f32vextq_f64vextq_p16vex" +
	"tq_p64vextq_p8vextq_s16vextq_s32vextq_s64vextq_s8vextq_u16vextq_" +
	"u32vextq_u64vextq_u8vfma_f16vfma_f32vfma_f64vfma_lane_f16vfma_la" +
	"ne_f32vfma_lane_f64vfma_laneq_f16vfma_laneq_f32vfma_laneq_f64vfm" +
	"a_n_f16vfma_n_f32vfma_n_f64vfmad_lane_f64vfmad_laneq_f64vfmah_la" +
	"ne_f16vfmah_laneq_f16vfmaq_f16vfmaq_f32vfmaq_f64vfmaq_lane_f16vf" +
	"maq_lane_f32vfmaq_lane_f64vfmaq_laneq_f16vfmaq_laneq_f32vfmaq_la" +
	"neq_f64vfmaq_n_f16vfmaq_n_f32vfmaq_n_f64vfmas_lane_f32vfmas_lane" +
	"q_f32vfmlal_high_f16vfmlal_lane_high_f16vfmlal_lane_low_f16vfmla" +
	"l_laneq_high_f16vfmlal_laneq_low_f16vfmlal_low_f16vfmlalq_high_f" +
	"16vfmlalq_lane_high_f16vfmlalq_lane_low_f16vfmlalq_laneq_high_f1" +
	"6vfmlalq_laneq_low_f16vfmlalq_low_f16vfmlsl_high_f16vfmlsl_lane_" +
	"high_f16vfmlsl_lane_low_f16vfmlsl_laneq_high_f16vfmlsl_laneq_low" +
	"_f16vfmlsl_low_f16vfmlslq_high_f16vfmlslq_lane_high_f16vfmlslq_l" +
	"ane_low_f16vfmlslq_laneq_high_f16vfmlslq_laneq_low_f16vfmlslq_lo" +
	"w_f16vfms_f16vfms_f32vfms_f64vfms_lane_f16vfms_lane_f32vfms_lane" +
	"_f64vfms_laneq_f16vfms_laneq_f32vfms_laneq_f64vfms_n_f16vfms_n_f" +
	"32vfms_n_f64vfmsd_lane_f64vfmsd_laneq_f64vfmsh_lane_f16vfmsh_lan" +
	"eq_f16vfmsq_f16vfmsq_f32vfmsq_f64vfmsq_lane_f16vfmsq_lane_f32vfm" +
	"sq_lane_f64vfmsq_laneq_f16vfmsq_laneq_f32vfmsq_laneq_f64vfmsq_n_" +
	"f16vfmsq_n_f32vfmsq_n_f64vfmss_lane_f32vfmss_laneq_f32vget_high_" +
	"bf16vget_high_f16vget_high_f32vget_high_f64vget_high_p16vget_hig" +
	"h_p64vget_high_p8vget_high_s16vget_high_s32vget_high_s64vget_hig" +
	"h_s8vget_high_u16vget_high_u32vget_high_u64vget_high_u8vget_lane" +
	"_bf16vget_lane_f16vget_lane_f32vget_lane_f64vget_lane_p16vget_la" +
	"ne_p64vget_lane_p8vget_lane_s16vget_lane_s32vget_lane_s64vget_la" +
	"ne_s8vget_lane_u16vget_lane_u32vget_lane_u64vget_lane_u8vget_low" +
	"_bf16vget_low_f16vget_low_f32vget_low_f64vget_low_p16vget_low_p6" +
	"4vget_low_p8vget_low_s16vget_low_s32vget_low_s64vget_low_s8vget_" +
	"low_u16vget_low_u32vget_low_u64vget_low_u8vgetq_lane_bf16vgetq_l" +
	"ane_f16vgetq_lane_f32vgetq_lane_f64vgetq_lane_p16vgetq_lane_p64v" +
	"getq_lane_p8vgetq_lane_s16vgetq_lane_s32vgetq_lane_s64vgetq_lane" +
	"_s8vgetq_lane_u16vgetq_lane_u32vgetq_lane_u64vgetq_lane_u8vhadd_" +
	"s16vhadd_s32vhadd_s8vhadd_u16vhadd_u32vhadd_u8vhaddq_s16vhaddq_s" +
	"32vhaddq_s8vhaddq_u16vhaddq_u32vhaddq_u8vhsub_s16vhsub_s32vhsub_" +
	"s8vhsub_u16vhsub_u32vhsub_u8vhsubq_s16vhsubq_s32vhsubq_s8vhsubq_" +
	"u16vhsubq_u32vhsubq_u8vld1_bf16vld1_bf16_x2vld1_bf16_x3vld1_bf16" +
	"_x4vld1_dup_bf16vld1_dup_f16vld1_dup_f32vld1_dup_f64vld1_dup_p16" +
	"vld1_dup_p64vld1_dup_p8vld1_dup_s16vld1_dup_s32vld1_dup_s64vld1_" +
	"dup_s8vld1_dup_u16vld1_dup_u32vld1_dup_u64vld1_dup_u8vld1_f16vld" +
	"1_f16_x2vld1_f16_x3vld1_f16_x4vld1_f32vld1_f32_x2vld1_f32_x3vld1" +
	"_f32_x4vld1_f64vld1_f64_x2vld1_f64_x3vld1_f64_x4vld1_lane_bf16vl" +
	"d1_lane_f16vld1_lane_f32vld1_lane_f64vld1_lane_p16vld1_lane_p64v" +
	"ld1_lane_p8vld1_lane_s16vld1_lane_s32vld1_lane_s64vld1_lane_s8vl" +
	"d1_lane_u16vld1_lane_u32vld1_lane_u64vld1_lane_u8vld1_p16vld1_p1" +
	"6_x2vld1_p16_x3vld1_p16_x4vld1_p64vld1_p64_x2vld1_p64_x3vld1_p64" +
	"_x4vld1_p8vld1_p8_x2vld1_p8_x3vld1_p8_x4vld1_s16vld1_s16_x2vld1_" +
	"s16_x3vld1_s16_x4vld1_s32vld1_s32_x2vld1_s32_x3vld1_s32_x4vld1_s" +
	"64vld1_s64_x2vld1_s64_x3vld1_s64_x4vld1_s8vld1_s8_x2vld1_s8_x3vl" +
	"d1_s8_x4vld1_u16vld1_u16_x2vld1_u16_x3vld1_u16_x4vld1_u32vld1_u3" +
	"2_x2vld1_u32_x3vld1_u32_x4vld1_u64vld1_u64_x2vld1_u64_x3vld1_u64" +
	"_x4vld1_u8vld1_u8_x2vld1_u8_x3vld1_u8_x4vld1q_bf16vld1q_bf16_x2v" +
	"ld1q_bf16_x3vld1q_bf16_x4vld1q_dup_bf16vld1q_dup_f16vld1q_dup_f3" +
	"2vld1q_dup_f64vld1q_dup_p16vld1q_dup_p64vld1q_dup_p8vld1q_dup_s1" +
	"6vld1q_dup_s32vld1q_dup_s64vld1q_dup_u16vld1q_dup_u32vld1q_dup_u" +
	"64vld1q_dup_u8vld1q_f16vld1q_f16_x2vld1q_f16_x3vld1q_f16_x4vld1q" +
	"_f32vld1q_f32_x2vld1q_f32_x3vld1q_f32_x4vld1q_f64vld1q_f64_x2vld" +
	"1q_f64_x3vld1q_f64_x4vld1q_lane_bf16vld1q_lane_f16vld1q_lane_f32" +
	"vld1q_lane_f64vld1q_lane_p16vld1q_lane_p64vld1q_lane_p8vld1q_lan" +
	"e_s16vld1q_lane_s32vld1q_lane_s64vld1q_lane_s8vld1q_lane_u16vld1" +
	"q_lane_u32vld1q_lane_u64vld1q_lane_u8vld1q_p16vld1q_p16_x2vld1q_" +
	"p16_x3vld1q_p16_x4vld1q_p64vld1q_p64_x2vld1q_p64_x3vld1q_p64_x4v" +
	"ld1q_p8vld1q_p8_x2vld1q_p8_x3vld1q_p8_x4vld1q_s16vld1q_s16_x2vld" +
	"1q_s16_x3vld1q_s16_x4vld1q_s32vld1q_s32_x2vld1q_s32_x3vld1q_s32_" +
	"x4vld1q_s64vld1q_s64_x2vld1q_s64_x3vld1q_s64_x4vld1q_s8vld1q_s8_" +
	"x2vld1q_s8_x3vld1q_s8_x4vld1q_u16vld1q_u16_x2vld1q_u16_x3vld1q_u" +
	"16_x4vld1q_u32vld1q_u32_x2vld1q_u32_x3vld1q_u32_x4vld1q_u64vld1q" +
	"_u64_x2vld1q_u64_x3vld1q_u64_x4vld1q_u8vld1q_u8_x2vld1q_u8_x3vld" +
	"1q_u8_x4vld2_bf16vld2_dup_bf16vld2_dup_f16vld2_dup_f32vld2_dup_f" +
	"64vld2_dup_p16vld2_dup_p64vld2_dup_p8vld2_dup_s16vld2_dup_s32vld" +
	"2_dup_s64vld2_dup_s8vld2_dup_u16vld2_dup_u32vld2_dup_u64vld2_dup" +
	"_u8vld2_f16vld2_f32vld2_f64vld2_p16vld2_p64vld2_p8vld2_s16vld2_s" +
	"32vld2_s64vld2_s8vld2_u16vld2_u32vld2_u64vld2_u8vld2q_bf16vld2q_" +
	"dup_bf16vld2q_dup_f16vld2q_dup_f32vld2q_dup_f64vld2q_dup_p16vld2" +
	"q_dup_p64vld2q_dup_p8vld2q_dup_s16vld2q_dup_s32vld2q_dup_s64vld2" +
	"q_dup_s8vld2q_dup_u16vld2q_dup_u32vld2q_dup_u64vld2q_dup_u8vld2q" +
	"_f16vld2q_f32vld2q_f64vld2q_p16vld2q_p64vld2q_p8vld2q_s16vld2q_s" +
	"32vld2q_s64vld2q_s8vld2q_u16vld2q_u32vld2q_u64vld2q_u8vld3_bf16v" +
	"ld3_dup_bf16vld3_dup_f16vld3_dup_f32vld3_dup_f64vld3_dup_p16vld3" +
	"_dup_p64vld3_dup_p8vld3_dup_s16vld3_dup_s32vld3_dup_s64vld3_dup_" +
	"s8vld3_dup_u16vld3_dup_u32vld3_dup_u64vld3_dup_u8vld3_f16vld3_f3" +
	"2vld3_f64vld3_p16vld3_p64vld3_p8vld3_s16vld3_s32vld3_s64vld3_s8v" +
	"ld3_u16vld3_u32vld3_u64vld3_u8vld3q_bf16vld3q_dup_bf16vld3q_dup_" +
	"f16vld3q_dup_f32vld3q_dup_f64vld3q_dup_p16vld3q_dup_p64vld3q_dup" +
	"_p8vld3q_dup_s16vld3q_dup_s32vld3q_dup_s64vld3q_dup_s8vld3q_dup_" +
	"u16vld3q_dup_u32vld3q_dup_u64vld3q_dup_u8vld3q_f16vld3q_f32vld3q" +
	"_f64vld3q_p16vld3q_p64vld3q_p8vld3q_s16vld3q_s32vld3q_s64vld3q_s" +
	"8vld3q_u16vld3q_u32vld3q_u64vld3q_u8vld4_bf16vld4_dup_bf16vld4_d" +
	"up_f16vld4_dup_f32vld4_dup_f64vld4_dup_p16vld4_dup_p64vld4_dup_p" +
	"8vld4_dup_s16vld4_dup_s32vld4_dup_s64vld4_dup_s8vld4_dup_u16vld4" +
	"_dup_u32vld4_dup_u64vld4_dup_u8vld4_f16vld4_f32vld4_f64vld4_p16v" +
	"ld4_p64vld4_p8vld4_s16vld4_s32vld4_s64vld4_s8vld4_u16vld4_u32vld" +
	"4_u64vld4_u8vld4q_bf16vld4q_dup_bf16vld4q_dup_f16vld4q_dup_f32vl" +
	"d4q_dup_f64vld4q_dup_p16vld4q_dup_p64vld4q_dup_p8vld4q_dup_s16vl" +
	"d4q_dup_s32vld4q_dup_s64vld4q_dup_s8vld4q_dup_u16vld4q_dup_u32vl" +
	"d4q_dup_u64vld4q_dup_u8vld4q_f16vld4q_f32vld4q_f64vld4q_p16vld4q" +
	"_p64vld4q_p8vld4q_s16vld4q_s32vld4q_s64vld4q_s8vld4q_u16vld4q_u3" +
	"2vld4q_u64vld4q_u8vldrq_p128vmax_f16vmax_f32vmax_f64vmax_s16vmax" +
	"_s32vmax_s8vmax_u16vmax_u32vmax_u8vmaxnm_f16vmaxnm_f32vmaxnm_f64" +
	"vmaxnmq_f16vmaxnmq_f32vmaxnmq_f64vmaxnmv_f16vmaxnmv_f32vmaxnmvq_" +
	"f16vmaxnmvq_f32vmaxnmvq_f64vmaxq_f16vmaxq_f32vmaxq_f64vmaxq_s16v" +
	"maxq_s32vmaxq_s8vmaxq_u16vmaxq_u32vmaxq_u8vmaxv_f16vmaxv_f32vmax" +
	"v_s16vmaxv_s32vmaxv_s8vmaxv_u16vmaxv_u32vmaxv_u8vmaxvq_f16vmaxvq" +
	"_f32vmaxvq_f64vmaxvq_s16vmaxvq_s32vmaxvq_s8vmaxvq_u16vmaxvq_u32v" +
	"maxvq_u8vmin_f16vmin_f32vmin_f64vmin_s16vmin_s32vmin_s8vmin_u16v" +
	"min_u32vmin_u8vminnm_f16vminnm_f32vminnm_f64vminnmq_f16vminnmq_f" +
	"32vminnmq_f64vminnmv_f16vminnmv_f32vminnmvq_f16vminnmvq_f32vminn" +
	"mvq_f64vminq_f16vminq_f32vminq_f64vminq_s16vminq_s32vminq_s8vmin" +
	"q_u16vminq_u32vminq_u8vminv_f16vminv_f32vminv_s16vminv_s32vminv_" +
	"s8vminv_u16vminv_u32vminv_u8vminvq_f16vminvq_f32vminvq_f64vminvq" +
	"_s16vminvq_s32vminvq_s8vminvq_u16vminvq_u32vminvq_u8vmla_f32vmla" +
	"_f64vmla_lane_f32vmla_lane_s16vmla_lane_s32vmla_lane_u16vmla_lan" +
	"e_u32vmla_laneq_f32vmla_laneq_s16vmla_laneq_s32vmla_laneq_u16vml" +
	"a_laneq_u32vmla_n_f32vmla_n_s16vmla_n_s32vmla_n_u16vmla_n_u32vml" +
	"a_s16vmla_s32vmla_s8vmla_u16vmla_u32vmla_u8vmlal_high_lane_s16vm" +
	"lal_high_lane_s32vmlal_high_lane_u16vmlal_high_lane_u32vmlal_hig" +
	"h_laneq_s16vmlal_high_laneq_s32vmlal_high_laneq_u16vmlal_high_la" +
	"neq_u32vmlal_high_n_s16vmlal_high_n_s32vmlal_high_n_u16vmlal_hig" +
	"h_n_u32vmlal_high_s16vmlal_high_s32vmlal_high_s8vmlal_high_u16vm" +
	"lal_high_u32vmlal_high_u8vmlal_lane_s16vmlal_lane_s32vmlal_lane_" +
	"u16vmlal_lane_u32vmlal_laneq_s16vmlal_laneq_s32vmlal_laneq_u16vm" +
	"lal_laneq_u32vmlal_n_s16vmlal_n_s32vmlal_n_u16vmlal_n_u32vmlal_s" +
	"16vmlal_s32vmlal_s8vmlal_u16vmlal_u32vmlal_u8vmlaq_f32vmlaq_f64v" +
	"mlaq_lane_f32vmlaq_lane_s16vmlaq_lane_s32vmlaq_lane_u16vmlaq_lan" +
	"e_u32vmlaq_laneq_f32vmlaq_laneq_s16vmlaq_laneq_s32vmlaq_laneq_u1" +
	"6vmlaq_laneq_u32vmlaq_n_f32vmlaq_n_s16vmlaq_n_s32vmlaq_n_u16vmla" +
	"q_n_u32vmlaq_s16vmlaq_s32vmlaq_s8vmlaq_u16vmlaq_u32vmlaq_u8vmls_" +
	"f32vmls_f64vmls_lane_f32vmls_lane_s16vmls_lane_s32vmls_lane_u16v" +
	"mls_lane_u32vmls_laneq_f32vmls_laneq_s16vmls_laneq_s32vmls_laneq" +
	"_u16vmls_laneq_u32vmls_n_f32vmls_n_s16vmls_n_s32vmls_n_u16vmls_n" +
	"_u32vmls_s16vmls_s32vmls_s8vmls_u16vmls_u32vmls_u8vmlsl_high_lan" +
	"e_s16vmlsl_high_lane_s32vmlsl_high_lane_u16vmlsl_high_lane_u32vm" +
	"lsl_high_laneq_s16vmlsl_high_laneq_s32vmlsl_high_laneq_u16vmlsl_" +
	"high_laneq_u32vmlsl_high_n_s16vmlsl_high_n_s32vmlsl_high_n_u16vm" +
	"lsl_high_n_u32vmlsl_high_s16vmlsl_high_s32vmlsl_high_s8vmlsl_hig" +
	"h_u16vmlsl_high_u32vmlsl_high_u8vmlsl_lane_s16vmlsl_lane_s32vmls" +
	"l_lane_u16vmlsl_lane_u32vmlsl_laneq_s16vmlsl_laneq_s32vmlsl_lane" +
	"q_u16vmlsl_laneq_u32vmlsl_n_s16vmlsl_n_s32vmlsl_n_u16vmlsl_n_u32" +
	"vmlsl_s16vmlsl_s32vmlsl_s8vmlsl_u16vmlsl_u32vmlsl_u8vmlsq_f32vml" +
	"sq_f64vmlsq_lane_f32vmlsq_lane_s16vmlsq_lane_s32vmlsq_lane_u16vm" +
	"lsq_lane_u32vmlsq_laneq_f32vmlsq_laneq_s16vmlsq_laneq_s32vmlsq_l" +
	"aneq_u16vmlsq_laneq_u32vmlsq_n_f32vmlsq_n_s16vmlsq_n_s32vmlsq_n_" +
	"u16vmlsq_n_u32vmlsq_s16vmlsq_s32vmlsq_s8vmlsq_u16vmlsq_u32vmlsq_" +
	"u8vmmlaq_s32vmmlaq_u32vmov_n_f16vmov_n_f32vmov_n_f64vmov_n_p16vm" +
	"ov_n_p64vmov_n_p8vmov_n_s16vmov_n_s32vmov_n_s64vmov_n_s8vmov_n_u" +
	"16vmov_n_u32vmov_n_u64vmov_n_u8vmovl_high_s16vmovl_high_s32vmovl" +
	"_high_s8vmovl_high_u16vmovl_high_u32vmovl_high_u8vmovl_s16vmovl_" +
	"s32vmovl_s8vmovl_u16vmovl_u32vmovl_u8vmovn_high_s16vmovn_high_s3" +
	"2vmovn_high_s64vmovn_high_u16vmovn_high_u32vmovn_high_u64vmovn_s" +
	"16vmovn_s32vmovn_s64vmovn_u16vmovn_u32vmovn_u64vmovq_n_f16vmovq_" +
	"n_f32vmovq_n_f64vmovq_n_p16vmovq_n_p64vmovq_n_p8vmovq_n_s16vmovq" +
	"_n_s32vmovq_n_s64vmovq_n_s8vmovq_n_u16vmovq_n_u32vmovq_n_u64vmov" +
	"q_n_u8vmul_f16vmul_f32vmul_f64vmul_lane_f16vmul_lane_f32vmul_lan" +
	"e_f64vmul_lane_s16vmul_lane_s32vmul_lane_u16vmul_lane_u32vmul_la" +
	"neq_f16vmul_laneq_f32vmul_laneq_f64vmul_laneq_s16vmul_laneq_s32v" +
	"mul_laneq_u16vmul_laneq_u32vmul_n_f16vmul_n_f32vmul_n_f64vmul_n_" +
	"s16vmul_n_s32vmul_n_u16vmul_n_u32vmul_p8vmul_s16vmul_s32vmul_s8v" +
	"mul_u16vmul_u32vmul_u8vmuld_lane_f64vmuld_laneq_f64vmulh_lane_f1" +
	"6vmulh_laneq_f16vmull_high_lane_s16vmull_high_lane_s32vmull_high" +
	"_lane_u16vmull_high_lane_u32vmull_high_laneq_s16vmull_high_laneq" +
	"_s32vmull_high_laneq_u16vmull_high_laneq_u32vmull_high_n_s16vmul" +
	"l_high_n_s32vmull_high_n_u16vmull_high_n_u32vmull_high_p64vmull_" +
	"high_p8vmull_high_s16vmull_high_s32vmull_high_s8vmull_high_u16vm" +
	"ull_high_u32vmull_high_u8vmull_lane_s16vmull_lane_s32vmull_lane_" +
	"u16vmull_lane_u32vmull_laneq_s16vmull_laneq_s32vmull_laneq_u16vm" +
	"ull_laneq_u32vmull_n_s16vmull_n_s32vmull_n_u16vmull_n_u32vmull_p" +
	"64vmull_p8vmull_s16vmull_s32vmull_s8vmull_u16vmull_u32vmull_u8vm" +
	"ulq_f16vmulq_f32vmulq_f64vmulq_lane_f16vmulq_lane_f32vmulq_lane_" +
	"f64vmulq_lane_s16vmulq_lane_s32vmulq_lane_u16vmulq_lane_u32vmulq" +
	"_laneq_f16vmulq_laneq_f32vmulq_laneq_f64vmulq_laneq_s16vmulq_lan" +
	"eq_s32vmulq_laneq_u16vmulq_laneq_u32vmulq_n_f16vmulq_n_f32vmulq_" +
	"n_f64vmulq_n_s16vmulq_n_s32vmulq_n_u16vmulq_n_u32vmulq_p8vmulq_s" +
	"16vmulq_s32vmulq_s8vmulq_u16vmulq_u32vmulq_u8vmuls_lane_f32vmuls" +
	"_laneq_f32vmulx_f16vmulx_f32vmulx_f64vmulx_lane_f16vmulx_lane_f3" +
	"2vmulx_lane_f64vmulx_laneq_f16vmulx_laneq_f32vmulx_laneq_f64vmul" +
	"x_n_f16vmulxd_f64vmulxd_lane_f64vmulxd_laneq_f64vmulxh_lane_f16v" +
	"mulxh_laneq_f16vmulxq_f16vmulxq_f32vmulxq_f64vmulxq_lane_f16vmul" +
	"xq_lane_f32vmulxq_lane_f64vmulxq_laneq_f16vmulxq_laneq_f32vmulxq" +
	"_laneq_f64vmulxq_n_f16vmulxs_f32vmulxs_lane_f32vmulxs_laneq_f32v" +
	"mvn_p8vmvn_s16vmvn_s32vmvn_s8vmvn_u16vmvn_u32vmvn_u8vmvnq_p8vmvn" +
	"q_s16vmvnq_s32vmvnq_s8vmvnq_u16vmvnq_u32vmvnq_u8vneg_f16vneg_f32" +
	"vneg_f64vneg_s16vneg_s32vneg_s64vneg_s8vnegd_s64vnegq_f16vnegq_f" +
	"32vnegq_f64vnegq_s16vnegq_s32vnegq_s64vnegq_s8vorn_s16vorn_s32vo" +
	"rn_s64vorn_s8vorn_u16vorn_u32vorn_u64vorn_u8vornq_s16vornq_s32vo" +
	"rnq_s64vornq_s8vornq_u16vornq_u32vornq_u64vornq_u8vorr_s16vorr_s" +
	"32vorr_s64vorr_s8vorr_u16vorr_u32vorr_u64vorr_u8vorrq_s16vorrq_s" +
	"32vorrq_s64vorrq_s8vorrq_u16vorrq_u32vorrq_u64vorrq_u8vpadal_s16" +
	"vpadal_s32vpadal_s8vpadal_u16vpadal_u32vpadal_u8vpadalq_s16vpada" +
	"lq_s32vpadalq_s8vpadalq_u16vpadalq_u32vpadalq_u8vpadd_f16vpadd_f" +
	"32vpadd_s16vpadd_s32vpadd_s8vpadd_u16vpadd_u32vpadd_u8vpaddd_f64" +
	"vpaddd_s64vpaddd_u64vpaddl_s16vpaddl_s32vpaddl_s8vpaddl_u16vpadd" +
	"l_u32vpaddl_u8vpaddlq_s16vpaddlq_s32vpaddlq_s8vpaddlq_u16vpaddlq" +
	"_u32vpaddlq_u8vpaddq_f16vpaddq_f32vpaddq_f64vpaddq_s16vpaddq_s32" +
	"vpaddq_s64vpaddq_s8vpaddq_u16vpaddq_u32vpaddq_u64vpaddq_u8vpadds" +
	"_f32vpmax_f16vpmax_f32vpmax_s16vpmax_s32vpmax_s8vpmax_u16vpmax_u" +
	"32vpmax_u8vpmaxnm_f16vpmaxnm_f32vpmaxnmq_f16vpmaxnmq_f32vpmaxnmq" +
	"_f64vpmaxnmqd_f64vpmaxnms_f32vpmaxq_f16vpmaxq_f32vpmaxq_f64vpmax" +
	"q_s16vpmaxq_s32vpmaxq_s8vpmaxq_u16vpmaxq_u32vpmaxq_u8vpmaxqd_f64" +
	"vpmaxs_f32vpmin_f16vpmin_f32vpmin_s16vpmin_s32vpmin_s8vpmin_u16v" +
	"pmin_u32vpmin_u8vpminnm_f16vpminnm_f32vpminnmq_f16vpminnmq_f32vp" +
	"minnmq_f64vpminnmqd_f64vpminnms_f32vpminq_f16vpminq_f32vpminq_f6" +
	"4vpminq_s16vpminq_s32vpminq_s8vpminq_u16vpminq_u32vpminq_u8vpmin" +
	"qd_f64vpmins_f32vqabs_s16vqabs_s32vqabs_s64vqabs_s8vqabsb_s8vqab" +
	"sd_s64vqabsh_s16vqabsq_s16vqabsq_s32vqabsq_s64vqabsq_s8vqabss_s3" +
	"2vqadd_s16vqadd_s32vqadd_s64vqadd_s8vqadd_u16vqadd_u32vqadd_u64v" +
	"qadd_u8vqaddb_s8vqaddb_u8vqaddd_s64vqaddd_u64vqaddh_s16vqaddh_u1" +
	"6vqaddq_s16vqaddq_s32vqaddq_s64vqaddq_s8vqaddq_u16vqaddq_u32vqad" +
	"dq_u64vqaddq_u8vqadds_s32vqadds_u32vqdmlal_high_lane_s16vqdmlal_" +
	"high_lane_s32vqdmlal_high_laneq_s16vqdmlal_high_laneq_s32vqdmlal" +
	"_high_n_s16vqdmlal_high_n_s32vqdmlal_high_s16vqdmlal_high_s32vqd" +
	"mlal_lane_s16vqdmlal_lane_s32vqdmlal_laneq_s16vqdmlal_laneq_s32v" +
	"qdmlal_n_s16vqdmlal_n_s32vqdmlal_s16vqdmlal_s32vqdmlalh_lane_s16" +
	"vqdmlalh_laneq_s16vqdmlalh_s16vqdmlals_lane_s32vqdmlals_laneq_s3" +
	"2vqdmlals_s32vqdmlsl_high_lane_s16vqdmlsl_high_lane_s32vqdmlsl_h" +
	"igh_laneq_s16vqdmlsl_high_laneq_s32vqdmlsl_high_n_s16vqdmlsl_hig" +
	"h_n_s32vqdmlsl_high_s16vqdmlsl_high_s32vqdmlsl_lane_s16vqdmlsl_l" +
	"ane_s32vqdmlsl_laneq_s16vqdmlsl_laneq_s32vqdmlsl_n_s16vqdmlsl_n_" +
	"s32vqdmlsl_s16vqdmlsl_s32vqdmlslh_lane_s16vqdmlslh_laneq_s16vqdm" +
	"lslh_s16vqdmlsls_lane_s32vqdmlsls_laneq_s32vqdmlsls_s32vqdmulh_l" +
	"ane_s16vqdmulh_lane_s32vqdmulh_laneq_s16vqdmulh_laneq_s32vqdmulh" +
	"_n_s16vqdmulh_n_s32vqdmulh_s16vqdmulh_s32vqdmulhh_lane_s16vqdmul" +
	"hh_laneq_s16vqdmulhh_s16vqdmulhq_lane_s16vqdmulhq_lane_s32vqdmul" +
	"hq_laneq_s16vqdmulhq_laneq_s32vqdmulhq_n_s16vqdmulhq_n_s32vqdmul" +
	"hq_s16vqdmulhq_s32vqdmulhs_lane_s32vqdmulhs_laneq_s32vqdmulhs_s3" +
	"2vqdmull_high_lane_s16vqdmull_high_lane_s32vqdmull_high_laneq_s1" +
	"6vqdmull_high_laneq_s32vqdmull_high_n_s16vqdmull_high_n_s32vqdmu" +
	"ll_high_s16vqdmull_high_s32vqdmull_lane_s16vqdmull_lane_s32vqdmu" +
	"ll_laneq_s16vqdmull_laneq_s32vqdmull_n_s16vqdmull_n_s32vqdmull_s" +
	"16vqdmull_s32vqdmullh_lane_s16vqdmullh_laneq_s16vqdmullh_s16vqdm" +
	"ulls_lane_s32vqdmulls_laneq_s32vqdmulls_s32vqmovn_high_s16vqmovn" +
	"_high_s32vqmovn_high_s64vqmovn_high_u16vqmovn_high_u32vqmovn_hig" +
	"h_u64vqmovn_s16vqmovn_s32vqmovn_s64vqmovn_u16vqmovn_u32vqmovn_u6" +
	"4vqmovnd_s64vqmovnd_u64vqmovnh_s16vqmovnh_u16vqmovns_s32vqmovns_" +
	"u32vqmovun_high_s16vqmovun_high_s32vqmovun_high_s64vqmovun_s16vq" +
	"movun_s32vqmovun_s64vqmovund_s64vqmovunh_s16vqmovuns_s32vqneg_s1" +
	"6vqneg_s32vqneg_s64vqneg_s8vqnegb_s8vqnegd_s64vqnegh_s16vqnegq_s" +
	"16vqnegq_s32vqnegq_s64vqnegq_s8vqnegs_s32vqrdmlah_lane_s16vqrdml" +
	"ah_lane_s32vqrdmlah_laneq_s16vqrdmlah_laneq_s32vqrdmlah_s16vqrdm" +
	"lah_s32vqrdmlahh_lane_s16vqrdmlahh_laneq_s16vqrdmlahh_s16vqrdmla" +
	"hq_lane_s16vqrdmlahq_lane_s32vqrdmlahq_laneq_s16vqrdmlahq_laneq_" +
	"s32vqrdmlahq_s16vqrdmlahq_s32vqrdmlahs_lane_s32vqrdmlahs_laneq_s" +
	"32vqrdmlahs_s32vqrdmlsh_lane_s16vqrdmlsh_lane_s32vqrdmlsh_laneq_" +
	"s16vqrdmlsh_laneq_s32vqrdmlsh_s16vqrdmlsh_s32vqrdmlshh_lane_s16v" +
	"qrdmlshh_laneq_s16vqrdmlshh_s16vqrdmlshq_lane_s16vqrdmlshq_lane_" +
	"s32vqrdmlshq_laneq_s16vqrdmlshq_laneq_s32vqrdmlshq_s16vqrdmlshq_" +
	"s32vqrdmlshs_lane_s32vqrdmlshs_laneq_s32vqrdmlshs_s32vqrdmulh_la" +
	"ne_s16vqrdmulh_lane_s32vqrdmulh_laneq_s16vqrdmulh_laneq_s32vqrdm" +
	"ulh_n_s16vqrdmulh_n_s32vqrdmulh_s16vqrdmulh_s32vqrdmulhh_lane_s1" +
	"6vqrdmulhh_laneq_s16vqrdmulhh_s16vqrdmulhq_lane_s16vqrdmulhq_lan" +
	"e_s32vqrdmulhq_laneq_s16vqrdmulhq_laneq_s32vqrdmulhq_n_s16vqrdmu" +
	"lhq_n_s32vqrdmulhq_s16vqrdmulhq_s32vqrdmulhs_lane_s32vqrdmulhs_l" +
	"aneq_s32vqrdmulhs_s32vqrshl_s16vqrshl_s32vqrshl_s64vqrshl_s8vqrs" +
	"hl_u16vqrshl_u32vqrshl_u64vqrshl_u8vqrshlb_s8vqrshlb_u8vqrshld_s" +
	"64vqrshld_u64vqrshlh_s16vqrshlh_u16vqrshlq_s16vqrshlq_s32vqrshlq" +
	"_s64vqrshlq_s8vqrshlq_u16vqrshlq_u32vqrshlq_u64vqrshlq_u8vqrshls" +
	"_s32vqrshls_u32vqrshrn_high_n_s16vqrshrn_high_n_s32vqrshrn_high_" +
	"n_s64vqrshrn_high_n_u16vqrshrn_high_n_u32vqrshrn_high_n_u64vqrsh" +
	"rn_n_s16vqrshrn_n_s32vqrshrn_n_s64vqrshrn_n_u16vqrshrn_n_u32vqrs" +
	"hrn_n_u64vqrshrnd_n_s64vqrshrnd_n_u64vqrshrnh_n_s16vqrshrnh_n_u1" +
	"6vqrshrns_n_s32vqrshrns_n_u32vqrshrun_high_n_s16vqrshrun_high_n_" +
	"s32vqrshrun_high_n_s64vqrshrun_n_s16vqrshrun_n_s32vqrshrun_n_s64" +
	"vqrshrund_n_s64vqrshrunh_n_s16vqrshruns_n_s32vqshl_n_s16vqshl_n_" +
	"s32vqshl_n_s64vqshl_n_s8vqshl_n_u16vqshl_n_u32vqshl_n_u64vqshl_n" +
	"_u8vqshl_s16vqshl_s32vqshl_s64vqshl_s8vqshl_u16vqshl_u32vqshl_u6" +
	"4vqshl_u8vqshlb_n_s8vqshlb_n_u8vqshlb_s8vqshlb_u8vqshld_n_s64vqs" +
	"hld_n_u64vqshld_s64vqshld_u64vqshlh_n_s16vqshlh_n_u16vqshlh_s16v" +
	"qshlh_u16vqshlq_n_s16vqshlq_n_s32vqshlq_n_s64vqshlq_n_s8vqshlq_n" +
	"_u16vqshlq_n_u32vqshlq_n_u64vqshlq_n_u8vqshlq_s16vqshlq_s32vqshl" +
	"q_s64vqshlq_s8vqshlq_u16vqshlq_u32vqshlq_u64vqshlq_u8vqshls_n_s3" +
	"2vqshls_n_u32vqshls_s32vqshls_u32vqshlu_n_s16vqshlu_n_s32vqshlu_" +
	"n_s64vqshlu_n_s8vqshlub_n_s8vqshlud_n_s64vqshluh_n_s16vqshluq_n_" +
	"s16vqshluq_n_s32vqshluq_n_s64vqshluq_n_s8vqshlus_n_s32vqshrn_hig" +
	"h_n_s16vqshrn_high_n_s32vqshrn_high_n_s64vqshrn_high_n_u16vqshrn" +
	"_high_n_u32vqshrn_high_n_u64vqshrn_n_s16vqshrn_n_s32vqshrn_n_s64" +
	"vqshrn_n_u16vqshrn_n_u32vqshrn_n_u64vqshrnd_n_s64vqshrnd_n_u64vq" +
	"shrnh_n_s16vqshrnh_n_u16vqshrns_n_s32vqshrns_n_u32vqshrun_high_n" +
	"_s16vqshrun_high_n_s32vqshrun_high_n_s64vqshrun_n_s16vqshrun_n_s" +
	"32vqshrun_n_s64vqshrund_n_s64vqshrunh_n_s16vqshruns_n_s32vqsub_s" +
	"16vqsub_s32vqsub_s64vqsub_s8vqsub_u16vqsub_u32vqsub_u64vqsub_u8v" +
	"qsubb_s8vqsubb_u8vqsubd_s64vqsubd_u64vqsubh_s16vqsubh_u16vqsubq_" +
	"s16vqsubq_s32vqsubq_s64vqsubq_s8vqsubq_u16vqsubq_u32vqsubq_u64vq" +
	"subq_u8vqsubs_s32vqsubs_u32vqtbl1_p8vqtbl1_s8vqtbl1_u8vqtbl1q_p8" +
	"vqtbl1q_s8vqtbl1q_u8vqtbl2_p8vqtbl2_s8vqtbl2_u8vqtbl2q_p8vqtbl2q" +
	"_s8vqtbl2q_u8vqtbl3_p8vqtbl3_s8vqtbl3_u8vqtbl3q_p8vqtbl3q_s8vqtb" +
	"l3q_u8vqtbl4_p8vqtbl4_s8vqtbl4_u8vqtbl4q_p8vqtbl4q_s8vqtbl4q_u8v" +
	"qtbx1_p8vqtbx1_s8vqtbx1_u8vqtbx1q_p8vqtbx1q_s8vqtbx1q_u8vqtbx2_p" +
	"8vqtbx2_s8vqtbx2_u8vqtbx2q_p8vqtbx2q_s8vqtbx2q_u8vqtbx3_p8vqtbx3" +
	"_s8vqtbx3_u8vqtbx3q_p8vqtbx3q_s8vqtbx3q_u8vqtbx4_p8vqtbx4_s8vqtb" +
	"x4_u8vqtbx4q_p8vqtbx4q_s8vqtbx4q_u8vraddhn_high_s16vraddhn_high_" +
	"s32vraddhn_high_s64vraddhn_high_u16vraddhn_high_u32vraddhn_high_" +
	"u64vraddhn_s16vraddhn_s32vraddhn_s64vraddhn_u16vraddhn_u32vraddh" +
	"n_u64vrax1q_u64vrbit_p8vrbit_s8vrbit_u8vrbitq_p8vrbitq_s8vrbitq_" +
	"u8vrecpe_f16vrecpe_f32vrecpe_f64vrecpe_u32vrecped_f64vrecpeq_f16" +
	"vrecpeq_f32vrecpeq_f64vrecpeq_u32vrecpes_f32vrecps_f16vrecps_f32" +
	"vrecps_f64vrecpsd_f64vrecpsq_f16vrecpsq_f32vrecpsq_f64vrecpss_f3" +
	"2vrecpxd_f64vrecpxs_f32vreinterpret_bf16_f16vreinterpret_bf16_f3" +
	"2vreinterpret_bf16_f64vreinterpret_bf16_p16vreinterpret_bf16_p64" +
	"vreinterpret_bf16_p8vreinterpret_bf16_s16vreinterpret_bf16_s32vr" +
	"einterpret_bf16_s64vreinterpret_bf16_s8vreinterpret_bf16_u16vrei" +
	"nterpret_bf16_u32vreinterpret_bf16_u64vreinterpret_bf16_u8vreint" +
	"erpret_f16_bf16vreinterpret_f16_f32vreinterpret_f16_f64vreinterp" +
	"ret_f16_p16vreinterpret_f16_p64vreinterpret_f16_p8vreinterpret_f" +
	"16_s16vreinterpret_f16_s32vreinterpret_f16_s64vreinterpret_f16_s" +
	"8vreinterpret_f16_u16vreinterpret_f16_u32vreinterpret_f16_u64vre" +
	"interpret_f16_u8vreinterpret_f32_bf16vreinterpret_f32_f16vreinte" +
	"rpret_f32_f64vreinterpret_f32_p16vreinterpret_f32_p64vreinterpre" +
	"t_f32_p8vreinterpret_f32_s16vreinterpret_f32_s32vreinterpret_f32" +
	"_s64vreinterpret_f32_s8vreinterpret_f32_u16vreinterpret_f32_u32v" +
	"reinterpret_f32_u64vreinterpret_f32_u8vreinterpret_f64_bf16vrein" +
	"terpret_f64_f16vreinterpret_f64_f32vreinterpret_f64_p16vreinterp" +
	"ret_f64_p64vreinterpret_f64_p8vreinterpret_f64_s16vreinterpret_f" +
	"64_s32vreinterpret_f64_s64vreinterpret_f64_s8vreinterpret_f64_u1" +
	"6vreinterpret_f64_u32vreinterpret_f64_u64vreinterpret_f64_u8vrei" +
	"nterpret_p16_bf16vreinterpret_p16_f16vreinterpret_p16_f32vreinte" +
	"rpret_p16_f64vreinterpret_p16_p64vreinterpret_p16_p8vreinterpret" +
	"_p16_s16vreinterpret_p16_s32vreinterpret_p16_s64vreinterpret_p16" +
	"_s8vreinterpret_p16_u16vreinterpret_p16_u32vreinterpret_p16_u64v" +
	"reinterpret_p16_u8vreinterpret_p64_bf16vreinterpret_p64_f16vrein" +
	"terpret_p64_f32vreinterpret_p64_f64vreinterpret_p64_p16vreinterp" +
	"ret_p64_p8vreinterpret_p64_s16vreinterpret_p64_s32vreinterpret_p" +
	"64_s64vreinterpret_p64_s8vreinterpret_p64_u16vreinterpret_p64_u3" +
	"2vreinterpret_p64_u64vreinterpret_p64_u8vreinterpret_p8_bf16vrei" +
	"nterpret_p8_f16vreinterpret_p8_f32vreinterpret_p8_f64vreinterpre" +
	"t_p8_p16vreinterpret_p8_p64vreinterpret_p8_s16vreinterpret_p8_s3" +
	"2vreinterpret_p8_s64vreinterpret_p8_s8vreinterpret_p8_u16vreinte" +
	"rpret_p8_u32vreinterpret_p8_u64vreinterpret_p8_u8vreinterpret_s1" +
	"6_bf16vreinterpret_s16_f16vreinterpret_s16_f32vreinterpret_s16_f" +
	"64vreinterpret_s16_p16vreinterpret_s16_p64vreinterpret_s16_p8vre" +
	"interpret_s16_s32vreinterpret_s16_s64vreinterpret_s16_s8vreinter" +
	"pret_s16_u16vreinterpret_s16_u32vreinterpret_s16_u64vreinterpret" +
	"_s16_u8vreinterpret_s32_bf16vreinterpret_s32_f16vreinterpret_s32" +
	"_f32vreinterpret_s32_f64vreinterpret_s32_p16vreinterpret_s32_p64" +
	"vreinterpret_s32_p8vreinterpret_s32_s16vreinterpret_s32_s64vrein" +
	"terpret_s32_s8vreinterpret_s32_u16vreinterpret_s32_u32vreinterpr" +
	"et_s32_u64vreinterpret_s32_u8vreinterpret_s64_bf16vreinterpret_s" +
	"64_f16vreinterpret_s64_f32vreinterpret_s64_f64vreinterpret_s64_p" +
	"16vreinterpret_s64_p64vreinterpret_s64_p8vreinterpret_s64_s16vre" +
	"interpret_s64_s32vreinterpret_s64_s8vreinterpret_s64_u16vreinter" +
	"pret_s64_u32vreinterpret_s64_u64vreinterpret_s64_u8vreinterpret_" +
	"s8_bf16vreinterpret_s8_f16vreinterpret_s8_f32vreinterpret_s8_f64" +
	"vreinterpret_s8_p16vreinterpret_s8_p64vreinterpret_s8_p8vreinter" +
	"pret_s8_s16vreinterpret_s8_s32vreinterpret_s8_s64vreinterpret_s8" +
	"_u16vreinterpret_s8_u32vreinterpret_s8_u64vreinterpret_s8_u8vrei" +
	"nterpret_u16_bf16vreinterpret_u16_f16vreinterpret_u16_f32vreinte" +
	"rpret_u16_f64vreinterpret_u16_p16vreinterpret_u16_p64vreinterpre" +
	"t_u16_p8vreinterpret_u16_s16vreinterpret_u16_s32vreinterpret_u16" +
	"_s64vreinterpret_u16_s8vreinterpret_u16_u32vreinterpret_u16_u64v" +
	"reinterpret_u16_u8vreinterpret_u32_bf16vreinterpret_u32_f16vrein" +
	"terpret_u32_f32vreinterpret_u32_f64vreinterpret_u32_p16vreinterp" +
	"ret_u32_p64vreinterpret_u32_p8vreinterpret_u32_s16vreinterpret_u" +
	"32_s32vreinterpret_u32_s64vreinterpret_u32_s8vreinterpret_u32_u1" +
	"6vreinterpret_u32_u64vreinterpret_u32_u8vreinterpret_u64_bf16vre" +
	"interpret_u64_f16vreinterpret_u64_f32vreinterpret_u64_f64vreinte" +
	"rpret_u64_p16vreinterpret_u64_p64vreinterpret_u64_p8vreinterpret" +
	"_u64_s16vreinterpret_u64_s32vreinterpret_u64_s64vreinterpret_u64" +
	"_s8vreinterpret_u64_u16vreinterpret_u64_u32vreinterpret_u64_u8vr" +
	"einterpret_u8_bf16vreinterpret_u8_f16vreinterpret_u8_f32vreinter" +
	"pret_u8_f64vreinterpret_u8_p16vreinterpret_u8_p64vreinterpret_u8" +
	"_p8vreinterpret_u8_s16vreinterpret_u8_s32vreinterpret_u8_s64vrei" +
	"nterpret_u8_s8vreinterpret_u8_u16vreinterpret_u8_u32vreinterpret" +
	"_u8_u64vreinterpretq_bf16_f16vreinterpretq_bf16_f32vreinterpretq" +
	"_bf16_f64vreinterpretq_bf16_p128vreinterpretq_bf16_p16vreinterpr" +
	"etq_bf16_p64vreinterpretq_bf16_p8vreinterpretq_bf16_s16vreinterp" +
	"retq_bf16_s32vreinterpretq_bf16_s64vreinterpretq_bf16_s8vreinter" +
	"pretq_bf16_u16vreinterpretq_bf16_u32vreinterpretq_bf16_u64vreint" +
	"erpretq_bf16_u8vreinterpretq_f16_bf16vreinterpretq_f16_f32vreint" +
	"erpretq_f16_f64vreinterpretq_f16_p128vreinterpretq_f16_p16vreint" +
	"erpretq_f16_p64vreinterpretq_f16_p8vreinterpretq_f16_s16vreinter" +
	"pretq_f16_s32vreinterpretq_f16_s64vreinterpretq_f16_s8vreinterpr" +
	"etq_f16_u16vreinterpretq_f16_u32vreinterpretq_f16_u64vreinterpre" +
	"tq_f16_u8vreinterpretq_f32_bf16vreinterpretq_f32_f16vreinterpret" +
	"q_f32_f64vreinterpretq_f32_p128vreinterpretq_f32_p16vreinterpret" +
	"q_f32_p64vreinterpretq_f32_p8vreinterpretq_f32_s16vreinterpretq_" +
	"f32_s32vreinterpretq_f32_s64vreinterpretq_f32_s8vreinterpretq_f3" +
	"2_u16vreinterpretq_f32_u32vreinterpretq_f32_u64vreinterpretq_f32" +
	"_u8vreinterpretq_f64_bf16vreinterpretq_f64_f16vreinterpretq_f64_" +
	"f32vreinterpretq_f64_p128vreinterpretq_f64_p16vreinterpretq_f64_" +
	"p64vreinterpretq_f64_p8vreinterpretq_f64_s16vreinterpretq_f64_s3" +
	"2vreinterpretq_f64_s64vreinterpretq_f64_s8vreinterpretq_f64_u16v" +
	"reinterpretq_f64_u32vreinterpretq_f64_u64vreinterpretq_f64_u8vre" +
	"interpretq_p128_bf16vreinterpretq_p128_f16vreinterpretq_p128_f32" +
	"vreinterpretq_p128_f64vreinterpretq_p128_p16vreinterpretq_p128_p" +
	"64vreinterpretq_p128_p8vreinterpretq_p128_s16vreinterpretq_p128_" +
	"s32vreinterpretq_p128_s64vreinterpretq_p128_s8vreinterpretq_p128" +
	"_u16vreinterpretq_p128_u32vreinterpretq_p128_u64vreinterpretq_p1" +
	"28_u8vreinterpretq_p16_bf16vreinterpretq_p16_f16vreinterpretq_p1" +
	"6_f32vreinterpretq_p16_f64vreinterpretq_p16_p128vreinterpretq_p1" +
	"6_p64vreinterpretq_p16_p8vreinterpretq_p16_s16vreinterpretq_p16_" +
	"s32vreinterpretq_p16_s64vreinterpretq_p16_s8vreinterpretq_p16_u1" +
	"6vreinterpretq_p16_u32vreinterpretq_p16_u64vreinterpretq_p16_u8v" +
	"reinterpretq_p64_bf16vreinterpretq_p64_f16vreinterpretq_p64_f32v" +
	"reinterpretq_p64_f64vreinterpretq_p64_p128vreinterpretq_p64_p16v" +
	"reinterpretq_p64_p8vreinterpretq_p64_s16vreinterpretq_p64_s32vre" +
	"interpretq_p64_s64vreinterpretq_p64_s8vreinterpretq_p64_u16vrein" +
	"terpretq_p64_u32vreinterpretq_p64_u64vreinterpretq_p64_u8vreinte" +
	"rpretq_p8_bf16vreinterpretq_p8_f16vreinterpretq_p8_f32vreinterpr" +
	"etq_p8_f64vreinterpretq_p8_p128vreinterpretq_p8_p16vreinterpretq" +
	"_p8_p64vreinterpretq_p8_s16vreinterpretq_p8_s32vreinterpretq_p8_" +
	"s64vreinterpretq_p8_s8vreinterpretq_p8_u16vreinterpretq_p8_u32vr" +
	"einterpretq_p8_u64vreinterpretq_p8_u8vreinterpretq_s16_bf16vrein" +
	"terpretq_s16_f16vreinterpretq_s16_f32vreinterpretq_s16_f64vreint" +
	"erpretq_s16_p128vreinterpretq_s16_p16vreinterpretq_s16_p64vreint" +
	"erpretq_s16_p8vreinterpretq_s16_s32vreinterpretq_s16_s64vreinter" +
	"pretq_s16_s8vreinterpretq_s16_u16vreinterpretq_s16_u32vreinterpr" +
	"etq_s16_u64vreinterpretq_s16_u8vreinterpretq_s32_bf16vreinterpre" +
	"tq_s32_f16vreinterpretq_s32_f32vreinterpretq_s32_f64vreinterpret" +
	"q_s32_p128vreinterpretq_s32_p16vreinterpretq_s32_p64vreinterpret" +
	"q_s32_p8vreinterpretq_s32_s16vreinterpretq_s32_s64vreinterpretq_" +
	"s32_s8vreinterpretq_s32_u16vreinterpretq_s32_u32vreinterpretq_s3" +
	"2_u64vreinterpretq_s32_u8vreinterpretq_s64_bf16vreinterpretq_s64" +
	"_f16vreinterpretq_s64_f32vreinterpretq_s64_f64vreinterpretq_s64_" +
	"p128vreinterpretq_s64_p16vreinterpretq_s64_p64vreinterpretq_s64_" +
	"p8vreinterpretq_s64_s16vreinterpretq_s64_s32vreinterpretq_s64_s8" +
	"vreinterpretq_s64_u16vreinterpretq_s64_u32vreinterpretq_s64_u64v" +
	"reinterpretq_s64_u8vreinterpretq_s8_bf16vreinterpretq_s8_f16vrei" +
	"nterpretq_s8_f32vreinterpretq_s8_f64vreinterpretq_s8_p128vreinte" +
	"rpretq_s8_p16vreinterpretq_s8_p64vreinterpretq_s8_p8vreinterpret" +
	"q_s8_s16vreinterpretq_s8_s32vreinterpretq_s8_s64vreinterpretq_s8" +
	"_u16vreinterpretq_s8_u32vreinterpretq_s8_u64vreinterpretq_s8_u8v" +
	"reinterpretq_u16_bf16vreinterpretq_u16_f16vreinterpretq_u16_f32v" +
	"reinterpretq_u16_f64vreinterpretq_u16_p128vreinterpretq_u16_p16v" +
	"reinterpretq_u16_p64vreinterpretq_u16_p8vreinterpretq_u16_s16vre" +
	"interpretq_u16_s32vreinterpretq_u16_s64vreinterpretq_u16_s8vrein" +
	"terpretq_u16_u32vreinterpretq_u16_u64vreinterpretq_u16_u8vreinte" +
	"rpretq_u32_bf16vreinterpretq_u32_f16vreinterpretq_u32_f32vreinte" +
	"rpretq_u32_f64vreinterpretq_u32_p128vreinterpretq_u32_p16vreinte" +
	"rpretq_u32_p64vreinterpretq_u32_p8vreinterpretq_u32_s16vreinterp" +
	"retq_u32_s32vreinterpretq_u32_s64vreinterpretq_u32_s8vreinterpre" +
	"tq_u32_u16vreinterpretq_u32_u64vreinterpretq_u32_u8vreinterpretq" +
	"_u64_bf16vreinterpretq_u64_f16vreinterpretq_u64_f32vreinterpretq" +
	"_u64_f64vreinterpretq_u64_p128vreinterpretq_u64_p16vreinterpretq" +
	"_u64_p64vreinterpretq_u64_p8vreinterpretq_u64_s16vreinterpretq_u" +
	"64_s32vreinterpretq_u64_s64vreinterpretq_u64_s8vreinterpretq_u64" +
	"_u16vreinterpretq_u64_u32vreinterpretq_u64_u8vreinterpretq_u8_bf" +
	"16vreinterpretq_u8_f16vreinterpretq_u8_f32vreinterpretq_u8_f64vr" +
	"einterpretq_u8_p128vreinterpretq_u8_p16vreinterpretq_u8_p64vrein" +
	"terpretq_u8_p8vreinterpretq_u8_s16vreinterpretq_u8_s32vreinterpr" +
	"etq_u8_s64vreinterpretq_u8_s8vreinterpretq_u8_u16vreinterpretq_u" +
	"8_u32vreinterpretq_u8_u64vrev16_p8vrev16_s8vrev16_u8vrev16q_p8vr" +
	"ev16q_s8vrev16q_u8vrev32_p16vrev32_p8vrev32_s16vrev32_s8vrev32_u" +
	"16vrev32_u8vrev32q_p16vrev32q_p8vrev32q_s16vrev32q_s8vrev32q_u16" +
	"vrev32q_u8vrev64_f16vrev64_f32vrev64_p16vrev64_p8vrev64_s16vrev6" +
	"4_s32vrev64_s8vrev64_u16vrev64_u32vrev64_u8vrev64q_f16vrev64q_f3" +
	"2vrev64q_p16vrev64q_p8vrev64q_s16vrev64q_s32vrev64q_s8vrev64q_u1" +
	"6vrev64q_u32vrev64q_u8vrhadd_s16vrhadd_s32vrhadd_s8vrhadd_u16vrh" +
	"add_u32vrhadd_u8vrhaddq_s16vrhaddq_s32vrhaddq_s8vrhaddq_u16vrhad" +
	"dq_u32vrhaddq_u8vrnd32x_f32vrnd32x_f64vrnd32xq_f32vrnd32xq_f64vr" +
	"nd32z_f32vrnd32z_f64vrnd32zq_f32vrnd32zq_f64vrnd64x_f32vrnd64x_f" +
	"64vrnd64xq_f32vrnd64xq_f64vrnd64z_f32vrnd64z_f64vrnd64zq_f32vrnd" +
	"64zq_f64vrnd_f16vrnd_f32vrnd_f64vrnda_f16vrnda_f32vrnda_f64vrnda" +
	"q_f16vrndaq_f32vrndaq_f64vrndi_f16vrndi_f32vrndi_f64vrndiq_f16vr" +
	"ndiq_f32vrndiq_f64vrndm_f16vrndm_f32vrndm_f64vrndmq_f16vrndmq_f3" +
	"2vrndmq_f64vrndn_f16vrndn_f32vrndn_f64vrndnq_f16vrndnq_f32vrndnq" +
	"_f64vrndns_f32vrndp_f16vrndp_f32vrndp_f64vrndpq_f16vrndpq_f32vrn" +
	"dpq_f64vrndq_f16vrndq_f32vrndq_f64vrndx_f16vrndx_f32vrndx_f64vrn" +
	"dxq_f16vrndxq_f32vrndxq_f64vrshl_s16vrshl_s32vrshl_s64vrshl_s8vr" +
	"shl_u16vrshl_u32vrshl_u64vrshl_u8vrshld_s64vrshld_u64vrshlq_s16v" +
	"rshlq_s32vrshlq_s64vrshlq_s8vrshlq_u16vrshlq_u32vrshlq_u64vrshlq" +
	"_u8vrshr_n_s16vrshr_n_s32vrshr_n_s64vrshr_n_s8vrshr_n_u16vrshr_n" +
	"_u32vrshr_n_u64vrshr_n_u8vrshrd_n_s64vrshrd_n_u64vrshrn_high_n_s" +
	"16vrshrn_high_n_s32vrshrn_high_n_s64vrshrn_high_n_u16vrshrn_high" +
	"_n_u32vrshrn_high_n_u64vrshrn_n_s16vrshrn_n_s32vrshrn_n_s64vrshr" +
	"n_n_u16vrshrn_n_u32vrshrn_n_u64vrshrq_n_s16vrshrq_n_s32vrshrq_n_" +
	"s64vrshrq_n_s8vrshrq_n_u16vrshrq_n_u32vrshrq_n_u64vrshrq_n_u8vrs" +
	"qrte_f16vrsqrte_f32vrsqrte_f64vrsqrte_u32vrsqrted_f64vrsqrteq_f1" +
	"6vrsqrteq_f32vrsqrteq_f64vrsqrteq_u32vrsqrtes_f32vrsqrts_f16vrsq" +
	"rts_f32vrsqrts_f64vrsqrtsd_f64vrsqrtsq_f16vrsqrtsq_f32vrsqrtsq_f" +
	"64vrsqrtss_f32vrsra_n_s16vrsra_n_s32vrsra_n_s64vrsra_n_s8vrsra_n" +
	"_u16vrsra_n_u32vrsra_n_u64vrsra_n_u8vrsrad_n_s64vrsrad_n_u64vrsr" +
	"aq_n_s16vrsraq_n_s32vrsraq_n_s64vrsraq_n_s8vrsraq_n_u16vrsraq_n_" +
	"u32vrsraq_n_u64vrsraq_n_u8vrsubhn_high_s16vrsubhn_high_s32vrsubh" +
	"n_high_s64vrsubhn_high_u16vrsubhn_high_u32vrsubhn_high_u64vrsubh" +
	"n_s16vrsubhn_s32vrsubhn_s64vrsubhn_u16vrsubhn_u32vrsubhn_u64vset" +
	"_lane_bf16vset_lane_f16vset_lane_f32vset_lane_f64vset_lane_p16vs" +
	"et_lane_p64vset_lane_p8vset_lane_s16vset_lane_s32vset_lane_s64vs" +
	"et_lane_s8vset_lane_u16vset_lane_u32vset_lane_u64vset_lane_u8vse" +
	"tq_lane_bf16vsetq_lane_f16vsetq_lane_f32vsetq_lane_f64vsetq_lane" +
	"_p16vsetq_lane_p64vsetq_lane_p8vsetq_lane_s16vsetq_lane_s32vsetq" +
	"_lane_s64vsetq_lane_s8vsetq_lane_u16vsetq_lane_u32vsetq_lane_u64" +
	"vsetq_lane_u8vsha1cq_u32vsha1h_u32vsha1mq_u32vsha1pq_u32vsha1su0" +
	"q_u32vsha1su1q_u32vsha256h2q_u32vsha256hq_u32vsha256su0q_u32vsha" +
	"256su1q_u32vsha512h2q_u64vsha512hq_u64vsha512su0q_u64vsha512su1q" +
	"_u64vshl_n_s16vshl_n_s32vshl_n_s64vshl_n_s8vshl_n_u16vshl_n_u32v" +
	"shl_n_u64vshl_n_u8vshl_s16vshl_s32vshl_s64vshl_s8vshl_u16vshl_u3" +
	"2vshl_u64vshl_u8vshld_n_s64vshld_n_u64vshld_s64vshld_u64vshll_hi" +
	"gh_n_s16vshll_high_n_s32vshll_high_n_s8vshll_high_n_u16vshll_hig" +
	"h_n_u32vshll_high_n_u8vshll_n_s16vshll_n_s32vshll_n_s8vshll_n_u1" +
	"6vshll_n_u32vshll_n_u8vshlq_n_s16vshlq_n_s32vshlq_n_s64vshlq_n_s" +
	"8vshlq_n_u16vshlq_n_u32vshlq_n_u64vshlq_n_u8vshlq_s16vshlq_s32vs" +
	"hlq_s64vshlq_s8vshlq_u16vshlq_u32vshlq_u64vshlq_u8vshr_n_s16vshr" +
	"_n_s32vshr_n_s64vshr_n_s8vshr_n_u16vshr_n_u32vshr_n_u64vshr_n_u8" +
	"vshrd_n_s64vshrd_n_u64vshrn_high_n_s16vshrn_high_n_s32vshrn_high" +
	"_n_s64vshrn_high_n_u16vshrn_high_n_u32vshrn_high_n_u64vshrn_n_s1" +
	"6vshrn_n_s32vshrn_n_s64vshrn_n_u16vshrn_n_u32vshrn_n_u64vshrq_n_" +
	"s16vshrq_n_s32vshrq_n_s64vshrq_n_s8vshrq_n_u16vshrq_n_u32vshrq_n" +
	"_u64vshrq_n_u8vsli_n_p64vsli_n_s16vsli_n_s32vsli_n_s64vsli_n_s8v" +
	"sli_n_u16vsli_n_u32vsli_n_u64vsli_n_u8vslid_n_s64vslid_n_u64vsli" +
	"q_n_p64vsliq_n_s16vsliq_n_s32vsliq_n_s64vsliq_n_s8vsliq_n_u16vsl" +
	"iq_n_u32vsliq_n_u64vsliq_n_u8vsm3partw1q_u32vsm3partw2q_u32vsm3s" +
	"s1q_u32vsm3tt1aq_u32vsm3tt1bq_u32vsm3tt2aq_u32vsm3tt2bq_u32vsm4e" +
	"keyq_u32vsm4eq_u32vsqadd_u16vsqadd_u32vsqadd_u64vsqadd_u8vsqaddb" +
	"_u8vsqaddd_u64vsqaddh_u16vsqaddq_u16vsqaddq_u32vsqaddq_u64vsqadd" +
	"q_u8vsqadds_u32vsqrt_f16vsqrt_f32vsqrt_f64vsqrtq_f16vsqrtq_f32vs" +
	"qrtq_f64vsra_n_s16vsra_n_s32vsra_n_s64vsra_n_s8vsra_n_u16vsra_n_" +
	"u32vsra_n_u64vsra_n_u8vsrad_n_s64vsrad_n_u64vsraq_n_s16vsraq_n_s" +
	"32vsraq_n_s64vsraq_n_s8vsraq_n_u16vsraq_n_u32vsraq_n_u64vsraq_n_" +
	"u8vsri_n_s16vsri_n_s32vsri_n_s64vsri_n_s8vsri_n_u16vsri_n_u32vsr" +
	"i_n_u64vsri_n_u8vsrid_n_s64vsrid_n_u64vsriq_n_s16vsriq_n_s32vsri" +
	"q_n_s64vsriq_n_s8vsriq_n_u16vsriq_n_u32vsriq_n_u64vsriq_n_u8vst1" +
	"_bf16vst1_bf16_x2vst1_bf16_x3vst1_bf16_x4vst1_f16vst1_f16_x2vst1" +
	"_f16_x3vst1_f16_x4vst1_f32vst1_f32_x2vst1_f32_x3vst1_f32_x4vst1_" +
	"f64vst1_f64_x2vst1_f64_x3vst1_f64_x4vst1_lane_bf16vst1_lane_f16v" +
	"st1_lane_f32vst1_lane_f64vst1_lane_p16vst1_lane_p64vst1_lane_p8v" +
	"st1_lane_s16vst1_lane_s32vst1_lane_s64vst1_lane_s8vst1_lane_u16v" +
	"st1_lane_u32vst1_lane_u64vst1_lane_u8vst1_p16vst1_p16_x2vst1_p16" +
	"_x3vst1_p16_x4vst1_p64vst1_p64_x2vst1_p64_x3vst1_p64_x4vst1_p8vs" +
	"t1_p8_x2vst1_p8_x3vst1_p8_x4vst1_s16vst1_s16_x2vst1_s16_x3vst1_s" +
	"16_x4vst1_s32vst1_s32_x2vst1_s32_x3vst1_s32_x4vst1_s64vst1_s64_x" +
	"2vst1_s64_x3vst1_s64_x4vst1_s8vst1_s8_x2vst1_s8_x3vst1_s8_x4vst1" +
	"_u16vst1_u16_x2vst1_u16_x3vst1_u16_x4vst1_u32vst1_u32_x2vst1_u32" +
	"_x3vst1_u32_x4vst1_u64vst1_u64_x2vst1_u64_x3vst1_u64_x4vst1_u8vs" +
	"t1_u8_x2vst1_u8_x3vst1_u8_x4vst1q_bf16vst1q_bf16_x2vst1q_bf16_x3" +
	"vst1q_bf16_x4vst1q_f16vst1q_f16_x2vst1q_f16_x3vst1q_f16_x4vst1q_" +
	"f32vst1q_f32_x2vst1q_f32_x3vst1q_f32_x4vst1q_f64vst1q_f64_x2vst1" +
	"q_f64_x3vst1q_f64_x4vst1q_lane_bf16vst1q_lane_f16vst1q_lane_f32v" +
	"st1q_lane_f64vst1q_lane_p16vst1q_lane_p64vst1q_lane_p8vst1q_lane" +
	"_s16vst1q_lane_s32vst1q_lane_s64vst1q_lane_s8vst1q_lane_u16vst1q" +
	"_lane_u32vst1q_lane_u64vst1q_lane_u8vst1q_p16vst1q_p16_x2vst1q_p" +
	"16_x3vst1q_p16_x4vst1q_p64vst1q_p64_x2vst1q_p64_x3vst1q_p64_x4vs" +
	"t1q_p8vst1q_p8_x2vst1q_p8_x3vst1q_p8_x4vst1q_s16vst1q_s16_x2vst1" +
	"q_s16_x3vst1q_s16_x4vst1q_s32vst1q_s32_x2vst1q_s32_x3vst1q_s32_x" +
	"4vst1q_s64vst1q_s64_x2vst1q_s64_x3vst1q_s64_x4vst1q_s8vst1q_s8_x" +
	"2vst1q_s8_x3vst1q_s8_x4vst1q_u16vst1q_u16_x2vst1q_u16_x3vst1q_u1" +
	"6_x4vst1q_u32vst1q_u32_x2vst1q_u32_x3vst1q_u32_x4vst1q_u64vst1q_" +
	"u64_x2vst1q_u64_x3vst1q_u64_x4vst1q_u8vst1q_u8_x2vst1q_u8_x3vst1" +
	"q_u8_x4vst2_bf16vst2_f16vst2_f32vst2_f64vst2_p16vst2_p64vst2_p8v" +
	"st2_s16vst2_s32vst2_s64vst2_s8vst2_u16vst2_u32vst2_u64vst2_u8vst" +
	"2q_bf16vst2q_f16vst2q_f32vst2q_f64vst2q_p16vst2q_p64vst2q_p8vst2" +
	"q_s16vst2q_s32vst2q_s64vst2q_s8vst2q_u16vst2q_u32vst2q_u64vst2q_" +
	"u8vst3_bf16vst3_f16vst3_f32vst3_f64vst3_p16vst3_p64vst3_p8vst3_s" +
	"16vst3_s32vst3_s64vst3_s8vst3_u16vst3_u32vst3_u64vst3_u8vst3q_bf" +
	"16vst3q_f16vst3q_f32vst3q_f64vst3q_p16vst3q_p64vst3q_p8vst3q_s16" +
	"vst3q_s32vst3q_s64vst3q_s8vst3q_u16vst3q_u32vst3q_u64vst3q_u8vst" +
	"4_bf16vst4_f16vst4_f32vst4_f64vst4_p16vst4_p64vst4_p8vst4_s16vst" +
	"4_s32vst4_s64vst4_s8vst4_u16vst4_u32vst4_u64vst4_u8vst4q_bf16vst" +
	"4q_f16vst4q_f32vst4q_f64vst4q_p16vst4q_p64vst4q_p8vst4q_s16vst4q" +
	"_s32vst4q_s64vst4q_s8vst4q_u16vst4q_u32vst4q_u64vst4q_u8vstrq_p1" +
	"28vsub_f16vsub_f32vsub_f64vsub_s16vsub_s32vsub_s64vsub_s8vsub_u1" +
	"6vsub_u32vsub_u64vsub_u8vsubd_s64vsubd_u64vsubhn_high_s16vsubhn_" +
	"high_s32vsubhn_high_s64vsubhn_high_u16vsubhn_high_u32vsubhn_high" +
	"_u64vsubhn_s16vsubhn_s32vsubhn_s64vsubhn_u16vsubhn_u32vsubhn_u64" +
	"vsubl_high_s16vsubl_high_s32vsubl_high_s8vsubl_high_u16vsubl_hig" +
	"h_u32vsubl_high_u8vsubl_s16vsubl_s32vsubl_s8vsubl_u16vsubl_u32vs" +
	"ubl_u8vsubq_f16vsubq_f32vsubq_f64vsubq_s16vsubq_s32vsubq_s64vsub" +
	"q_s8vsubq_u16vsubq_u32vsubq_u64vsubq_u8vsubw_high_s16vsubw_high_" +
	"s32vsubw_high_s8vsubw_high_u16vsubw_high_u32vsubw_high_u8vsubw_s" +
	"16vsubw_s32vsubw_s8vsubw_u16vsubw_u32vsubw_u8vsudot_lane_s32vsud" +
	"ot_laneq_s32vsudotq_lane_s32vsudotq_laneq_s32vtbl1_p8vtbl1_s8vtb" +
	"l1_u8vtbl2_p8vtbl2_s8vtbl2_u8vtbl3_p8vtbl3_s8vtbl3_u8vtbl4_p8vtb" +
	"l4_s8vtbl4_u8vtbx1_p8vtbx1_s8vtbx1_u8vtbx2_p8vtbx2_s8vtbx2_u8vtb" +
	"x3_p8vtbx3_s8vtbx3_u8vtbx4_p8vtbx4_s8vtbx4_u8vtrn1_f16vtrn1_f32v" +
	"trn1_p16vtrn1_p8vtrn1_s16vtrn1_s32vtrn1_s8vtrn1_u16vtrn1_u32vtrn" +
	"1_u8vtrn1q_f16vtrn1q_f32vtrn1q_f64vtrn1q_p16vtrn1q_p64vtrn1q_p8v" +
	"trn1q_s16vtrn1q_s32vtrn1q_s64vtrn1q_s8vtrn1q_u16vtrn1q_u32vtrn1q" +
	"_u64vtrn1q_u8vtrn2_f16vtrn2_f32vtrn2_p16vtrn2_p8vtrn2_s16vtrn2_s" +
	"32vtrn2_s8vtrn2_u16vtrn2_u32vtrn2_u8vtrn2q_f16vtrn2q_f32vtrn2q_f" +
	"64vtrn2q_p16vtrn2q_p64vtrn2q_p8vtrn2q_s16vtrn2q_s32vtrn2q_s64vtr" +
	"n2q_s8vtrn2q_u16vtrn2q_u32vtrn2q_u64vtrn2q_u8vtrn_f16vtrn_f32vtr" +
	"n_p16vtrn_p8vtrn_s16vtrn_s32vtrn_s8vtrn_u16vtrn_u32vtrn_u8vtrnq_" +
	"f16vtrnq_f32vtrnq_p16vtrnq_p8vtrnq_s16vtrnq_s32vtrnq_s8vtrnq_u16" +
	"vtrnq_u32vtrnq_u8vtst_p16vtst_p64vtst_p8vtst_s16vtst_s32vtst_s64" +
	"vtst_s8vtst_u16vtst_u32vtst_u64vtst_u8vtstd_s64vtstd_u64vtstq_p1" +
	"6vtstq_p64vtstq_p8vtstq_s16vtstq_s32vtstq_s64vtstq_s8vtstq_u16vt" +
	"stq_u32vtstq_u64vtstq_u8vuqadd_s16vuqadd_s32vuqadd_s64vuqadd_s8v" +
	"uqaddb_s8vuqaddd_s64vuqaddh_s16vuqaddq_s16vuqaddq_s32vuqaddq_s64" +
	"vuqaddq_s8vuqadds_s32vusdot_lane_s32vusdot_laneq_s32vusdot_s32vu" +
	"sdotq_lane_s32vusdotq_laneq_s32vusdotq_s32vusmmlaq_s32vuzp1_f16v" +
	"uzp1_f32vuzp1_p16vuzp1_p8vuzp1_s16vuzp1_s32vuzp1_s8vuzp1_u16vuzp" +
	"1_u32vuzp1_u8vuzp1q_f16vuzp1q_f32vuzp1q_f64vuzp1q_p16vuzp1q_p64v" +
	"uzp1q_p8vuzp1q_s16vuzp1q_s32vuzp1q_s64vuzp1q_s8vuzp1q_u16vuzp1q_" +
	"u32vuzp1q_u64vuzp1q_u8vuzp2_f16vuzp2_f32vuzp2_p16vuzp2_p8vuzp2_s" +
	"16vuzp2_s32vuzp2_s8vuzp2_u16vuzp2_u32vuzp2_u8vuzp2q_f16vuzp2q_f3" +
	"2vuzp2q_f64vuzp2q_p16vuzp2q_p64vuzp2q_p8vuzp2q_s16vuzp2q_s32vuzp" +
	"2q_s64vuzp2q_s8vuzp2q_u16vuzp2q_u32vuzp2q_u64vuzp2q_u8vxarq_u64v" +
	"zip1_f16vzip1_f32vzip1_p16vzip1_p8vzip1_s16vzip1_s32vzip1_s8vzip" +
	"1_u16vzip1_u32vzip1_u8vzip1q_f16vzip1q_f32vzip1q_f64vzip1q_p16vz" +
	"ip1q_p64vzip1q_p8vzip1q_s16vzip1q_s32vzip1q_s64vzip1q_s8vzip1q_u" +
	"16vzip1q_u32vzip1q_u64vzip1q_u8vzip2_f16vzip2_f32vzip2_p16vzip2_" +
	"p8vzip2_s16vzip2_s32vzip2_s8vzip2_u16vzip2_u32vzip2_u8vzip2q_f16" +
	"vzip2q_f32vzip2q_f64vzip2q_p16vzip2q_p64vzip2q_p8vzip2q_s16vzip2" +
	"q_s32vzip2q_s64vzip2q_s8vzip2q_u16vzip2q_u32vzip2q_u64vzip2q_u8"

var elementTable = [...]element{
	{},
	{0x00B5, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x00BD, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x00C5, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x08},
	{0x00CC, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x58},
	{0x00D4, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x68},
	{0x00DC, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x48},
	{0x00E3, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x00F1, 0x0E, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x00FF, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x010C, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x011A, 0x0E, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x0128, 0x0D, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x0135, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x013E, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x0147, 0x08, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x08},
	{0x014F, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x58},
	{0x0158, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x68},
	{0x0161, 0x08, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x48},
	{0x0169, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x0172, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x017B, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x0183, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x018C, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x0195, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x019D, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x01A5, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x01AD, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x01B5, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x01BD, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x01C5, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x01CC, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x01D4, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x01DC, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x01E3, 0x09, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x01EC, 0x0E, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x01FA, 0x0E, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x0208, 0x0D, 0x1C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x0215, 0x0E, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x0223, 0x0E, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x0231, 0x0D, 0x5C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x023E, 0x09, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x0247, 0x09, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x0250, 0x08, 0x1C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x0258, 0x09, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x0261, 0x09, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x026A, 0x08, 0x5C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x0272, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x027B, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0284, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x028D, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x0296, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x029F, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x02A7, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x02B0, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x02B9, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x02C1, 0x09, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x02CA, 0x08, 0x98},
	{0x0000, 0x83, 0x98},
	{0x02D2, 0x08, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x02DA, 0x08, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x02E2, 0x08, 0x18},
	{0x0000, 0x83, 0x18},
	{0x02EA, 0x08, 0x28},
	{0x0000, 0x83, 0x28},
	{0x02F2, 0x08, 0x38},
	{0x0000, 0x83, 0x38},
	{0x02FA, 0x07, 0x08},
	{0x0000, 0x83, 0x08},
	{0x0301, 0x09, 0x34},
	{0x0000, 0x83, 0x34},
	{0x030A, 0x09, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x0313, 0x09, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x031C, 0x09, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x0325, 0x09, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x032E, 0x09, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x0337, 0x09, 0x3C},
	{0x0000, 0x83, 0x3C},
	{0x0340, 0x08, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x0348, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0350, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0358, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0360, 0x08, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0x0368, 0x08, 0xE8},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x83, 0xE8},
	{0x0370, 0x07, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0x0377, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x037F, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x0387, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x038F, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x0396, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x039E, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x03A6, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x03AE, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x03B5, 0x09, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x03BE, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x03C7, 0x0F, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x03D6, 0x0F, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x03E5, 0x0F, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x3C},
	{0x03F4, 0x0F, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x0403, 0x0F, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x0412, 0x0F, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0x0421, 0x0A, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x042B, 0x0A, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x0435, 0x0A, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x043F, 0x0A, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x0449, 0x0A, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x0453, 0x0A, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x045D, 0x0E, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x046B, 0x0E, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x0479, 0x0D, 0x1C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x0486, 0x0E, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x0494, 0x0E, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x04A2, 0x0D, 0x5C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x04AF, 0x09, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x04B8, 0x09, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x04C1, 0x08, 0x1C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x04C9, 0x09, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x04D2, 0x09, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x04DB, 0x08, 0x5C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x04E3, 0x0A, 0x24},
	{0x0000, 0x83, 0x18},
	{0x04ED, 0x0A, 0x34},
	{0x0000, 0x83, 0x28},
	{0x04F7, 0x09, 0x14},
	{0x0000, 0x83, 0x08},
	{0x0500, 0x0A, 0x64},
	{0x0000, 0x83, 0x58},
	{0x050A, 0x0A, 0x74},
	{0x0000, 0x83, 0x68},
	{0x0514, 0x09, 0x54},
	{0x0000, 0x83, 0x48},
	{0x051D, 0x0B, 0x24},
	{0x0000, 0x83, 0x1C},
	{0x0528, 0x0B, 0x34},
	{0x0000, 0x83, 0x2C},
	{0x0533, 0x0A, 0x14},
	{0x0000, 0x83, 0x0C},
	{0x053D, 0x0B, 0x64},
	{0x0000, 0x83, 0x5C},
	{0x0548, 0x0B, 0x74},
	{0x0000, 0x83, 0x6C},
	{0x0553, 0x0A, 0x54},
	{0x0000, 0x83, 0x4C},
	{0x055D, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0566, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x056F, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0578, 0x0A, 0xF4},
	{0x0000, 0x03, 0xF4},
	{0x0008, 0x83, 0xF4},
	{0x0582, 0x09, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0x058B, 0x09, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0x0594, 0x08, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0x059C, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x05A5, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x05AE, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x05B7, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x05BF, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x05C8, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x05D1, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x05DA, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x05E2, 0x09, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x05EB, 0x09, 0x14},
	{0x0000, 0x83, 0x18},
	{0x05F4, 0x09, 0x24},
	{0x0000, 0x83, 0x28},
	{0x05FD, 0x08, 0x04},
	{0x0000, 0x83, 0x08},
	{0x0605, 0x09, 0x54},
	{0x0000, 0x83, 0x58},
	{0x060E, 0x09, 0x64},
	{0x0000, 0x83, 0x68},
	{0x0617, 0x08, 0x44},
	{0x0000, 0x83, 0x48},
	{0x061F, 0x0A, 0xA4},
	{0x0000, 0x83, 0xAC},
	{0x0629, 0x0A, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x0633, 0x0A, 0x14},
	{0x0000, 0x83, 0x1C},
	{0x063D, 0x0A, 0x24},
	{0x0000, 0x83, 0x2C},
	{0x0647, 0x0A, 0x34},
	{0x0000, 0x83, 0x3C},
	{0x0651, 0x09, 0x04},
	{0x0000, 0x83, 0x0C},
	{0x065A, 0x0A, 0x54},
	{0x0000, 0x83, 0x5C},
	{0x0664, 0x0A, 0x64},
	{0x0000, 0x83, 0x6C},
	{0x066E, 0x0A, 0x74},
	{0x0000, 0x83, 0x7C},
	{0x0678, 0x09, 0x44},
	{0x0000, 0x83, 0x4C},
	{0x0681, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x1C},
	{0x068F, 0x0E, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x2C},
	{0x069D, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x0C},
	{0x06AA, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x5C},
	{0x06B8, 0x0E, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x6C},
	{0x06C6, 0x0D, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x4C},
	{0x06D3, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x18},
	{0x06DC, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x28},
	{0x06E5, 0x08, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x08},
	{0x06ED, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x58},
	{0x06F6, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x68},
	{0x06FF, 0x08, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x48},
	{0x0707, 0x09, 0x4C},
	{0x00AA, 0x04, 0x4C},
	{0x00B2, 0x83, 0x4C},
	{0x0710, 0x09, 0x4C},
	{0x00AA, 0x04, 0x4C},
	{0x00B2, 0x83, 0x4C},
	{0x0719, 0x0B, 0x4C},
	{0x00AA, 0x84, 0x4C},
	{0x0724, 0x0A, 0x4C},
	{0x00AA, 0x84, 0x4C},
	{0x0731, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x0739, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x0741, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x0749, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x0750, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x0758, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x0760, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x0768, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x076F, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x0778, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x0781, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x078A, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x0792, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x079B, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x07A4, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x07AD, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x07B5, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x07BF, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x07C9, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x3C},
	{0x07D3, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x07DC, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x07E6, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x07F0, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0x07FA, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x0803, 0x0A, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x83, 0x88},
	{0x080D, 0x0F, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x03, 0x88},
	{0x004A, 0x87, 0x25},
	{0x081C, 0x10, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x03, 0x8C},
	{0x004A, 0x87, 0x25},
	{0x082C, 0x0B, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x8C},
	{0x0837, 0x10, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x03, 0x88},
	{0x004A, 0x87, 0x25},
	{0x0847, 0x11, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x03, 0x8C},
	{0x004A, 0x87, 0x25},
	{0x0858, 0x0D, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x8C},
	{0x0865, 0x12, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x03, 0x88},
	{0x004A, 0x87, 0x25},
	{0x0877, 0x13, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x03, 0x8C},
	{0x004A, 0x87, 0x25},
	{0x088A, 0x0D, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x8C},
	{0x0897, 0x12, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x03, 0x88},
	{0x004A, 0x87, 0x25},
	{0x08A9, 0x13, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x03, 0x8C},
	{0x004A, 0x87, 0x25},
	{0x08BC, 0x0C, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x8C},
	{0x08C8, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x08D0, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x08D8, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x08E0, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x08E7, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x08EF, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x08F7, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x08FF, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x0906, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x090F, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x0918, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x0921, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x0929, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x0932, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x093B, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x0944, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x094C, 0x08, 0x98},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x83, 0x98},
	{0x0954, 0x08, 0xA8},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA8},
	{0x095C, 0x08, 0xB8},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0xB8},
	{0x0964, 0x08, 0xD8},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0xD8},
	{0x000B, 0x83, 0xD8},
	{0x096C, 0x08, 0xE8},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0xE8},
	{0x000B, 0x83, 0xE8},
	{0x0974, 0x07, 0xC8},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0xC8},
	{0x000B, 0x83, 0xC8},
	{0x097B, 0x08, 0x18},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x0983, 0x08, 0x28},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x098B, 0x08, 0x38},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0x38},
	{0x000B, 0x83, 0x38},
	{0x0993, 0x07, 0x08},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x08},
	{0x099A, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x58},
	{0x09A2, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x68},
	{0x09AA, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0x78},
	{0x000B, 0x83, 0x78},
	{0x09B2, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x48},
	{0x09B9, 0x09, 0x9C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x83, 0x9C},
	{0x09C2, 0x09, 0xAC},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xAC},
	{0x09CB, 0x09, 0xBC},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0xBC},
	{0x09D4, 0x09, 0xDC},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0xDC},
	{0x000B, 0x83, 0xDC},
	{0x09DD, 0x09, 0xEC},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0xEC},
	{0x000B, 0x83, 0xEC},
	{0x09E6, 0x08, 0xCC},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0xCC},
	{0x000B, 0x83, 0xCC},
	{0x09EE, 0x09, 0x1C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x09F7, 0x09, 0x2C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x0A00, 0x09, 0x3C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x3C},
	{0x0A09, 0x08, 0x0C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x0A11, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x0A1A, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x0A23, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0x0A2C, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x0A34, 0x10, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0A44, 0x10, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0A54, 0x0F, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0A63, 0x0F, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0A72, 0x11, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0A83, 0x11, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0A94, 0x11, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0AA5, 0x10, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0AB5, 0x10, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0AC5, 0x10, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0AD5, 0x09, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0ADE, 0x09, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0AE7, 0x09, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0AF0, 0x0A, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x0AFA, 0x0A, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0B04, 0x0A, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0B0E, 0x0A, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0B18, 0x0A, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x0B22, 0x09, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0B2B, 0x09, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0B34, 0x09, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0B3D, 0x0A, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x0B47, 0x0A, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0B51, 0x0A, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0B5B, 0x0A, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0B65, 0x0A, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x0B6F, 0x09, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0B78, 0x09, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0B81, 0x09, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0B8A, 0x0A, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x0B94, 0x0A, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0B9E, 0x0A, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0BA8, 0x0A, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0BB2, 0x0A, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x0BBC, 0x09, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0BC5, 0x09, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0BCE, 0x09, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0BD7, 0x0A, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x0BE1, 0x0A, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0BEB, 0x0A, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0BF5, 0x0A, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0BFF, 0x0A, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x0C09, 0x08, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0C11, 0x08, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0C19, 0x08, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0C21, 0x08, 0x78},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x83, 0xE8},
	{0x0C29, 0x07, 0x48},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0x0C30, 0x08, 0x58},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x0C38, 0x08, 0x68},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x0C40, 0x08, 0x78},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x0C48, 0x07, 0x48},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x0C4F, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x0C57, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x0C5F, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x0C67, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x0C6E, 0x09, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x0C77, 0x09, 0x74},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x0C80, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x0C89, 0x09, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0C92, 0x09, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0C9B, 0x09, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0CA4, 0x09, 0x7C},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0x0CAD, 0x08, 0x4C},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0x0CB5, 0x09, 0x5C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x0CBE, 0x09, 0x6C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x0CC7, 0x09, 0x7C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x0CD0, 0x08, 0x4C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x0CD8, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x0CE1, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x0CEA, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x0CF3, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x0CFB, 0x09, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x0D04, 0x09, 0x58},
	{0x0000, 0x83, 0x98},
	{0x0D0D, 0x09, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x0D16, 0x09, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x0D1F, 0x09, 0x78},
	{0x0000, 0x83, 0xE8},
	{0x0D28, 0x08, 0x48},
	{0x0000, 0x83, 0xC8},
	{0x0D30, 0x09, 0x58},
	{0x0000, 0x83, 0x18},
	{0x0D39, 0x09, 0x68},
	{0x0000, 0x83, 0x28},
	{0x0D42, 0x09, 0x78},
	{0x0000, 0x83, 0x38},
	{0x0D4B, 0x08, 0x48},
	{0x0000, 0x83, 0x08},
	{0x0D53, 0x09, 0x58},
	{0x0000, 0x83, 0x58},
	{0x0D5C, 0x09, 0x68},
	{0x0000, 0x83, 0x68},
	{0x0D65, 0x09, 0x78},
	{0x0000, 0x83, 0x78},
	{0x0D6E, 0x08, 0x48},
	{0x0000, 0x83, 0x48},
	{0x0D76, 0x0A, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x0D80, 0x0A, 0x74},
	{0x0000, 0x83, 0x34},
	{0x0D8A, 0x0A, 0x74},
	{0x0000, 0x83, 0x74},
	{0x0D94, 0x0A, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x0D9E, 0x0A, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x0DA8, 0x0A, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x0DB2, 0x0A, 0x7C},
	{0x0000, 0x83, 0xEC},
	{0x0DBC, 0x09, 0x4C},
	{0x0000, 0x83, 0xCC},
	{0x0DC5, 0x0A, 0x5C},
	{0x0000, 0x83, 0x1C},
	{0x0DCF, 0x0A, 0x6C},
	{0x0000, 0x83, 0x2C},
	{0x0DD9, 0x0A, 0x7C},
	{0x0000, 0x83, 0x3C},
	{0x0DE3, 0x09, 0x4C},
	{0x0000, 0x83, 0x0C},
	{0x0DEC, 0x0A, 0x5C},
	{0x0000, 0x83, 0x5C},
	{0x0DF6, 0x0A, 0x6C},
	{0x0000, 0x83, 0x6C},
	{0x0E00, 0x0A, 0x7C},
	{0x0000, 0x83, 0x7C},
	{0x0E0A, 0x09, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x0E13, 0x0A, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x0E1D, 0x08, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0E25, 0x08, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0E2D, 0x08, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0E35, 0x08, 0x58},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x0E3D, 0x08, 0x68},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x0E45, 0x08, 0x78},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x0E4D, 0x07, 0x48},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x0E54, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x0E5C, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x0E64, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x0E6C, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x0E73, 0x09, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x0E7C, 0x09, 0x74},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x0E85, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x0E8E, 0x09, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x0E97, 0x09, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x0EA0, 0x09, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x0EA9, 0x09, 0x5C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x0EB2, 0x09, 0x6C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x0EBB, 0x09, 0x7C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x0EC4, 0x08, 0x4C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x0ECC, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x0ED5, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x0EDE, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x0EE7, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x0EEF, 0x09, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x0EF8, 0x09, 0x58},
	{0x0000, 0x83, 0x98},
	{0x0F01, 0x09, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x0F0A, 0x09, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x0F13, 0x09, 0x58},
	{0x0000, 0x83, 0x18},
	{0x0F1C, 0x09, 0x68},
	{0x0000, 0x83, 0x28},
	{0x0F25, 0x09, 0x78},
	{0x0000, 0x83, 0x38},
	{0x0F2E, 0x08, 0x48},
	{0x0000, 0x83, 0x08},
	{0x0F36, 0x0A, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x0F40, 0x0A, 0x74},
	{0x0000, 0x83, 0x34},
	{0x0F4A, 0x0A, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x0F54, 0x0A, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x0F5E, 0x0A, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x0F68, 0x0A, 0x5C},
	{0x0000, 0x83, 0x1C},
	{0x0F72, 0x0A, 0x6C},
	{0x0000, 0x83, 0x2C},
	{0x0F7C, 0x0A, 0x7C},
	{0x0000, 0x83, 0x3C},
	{0x0F86, 0x09, 0x4C},
	{0x0000, 0x83, 0x0C},
	{0x0F8F, 0x0A, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x0F99, 0x08, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x0FA1, 0x08, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x0FA9, 0x08, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x0FB1, 0x08, 0x58},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x0FB9, 0x08, 0x68},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x0FC1, 0x08, 0x78},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x0FC9, 0x07, 0x48},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x0FD0, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x0FD8, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x0FE0, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x0FE8, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x0FEF, 0x09, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x0FF8, 0x09, 0x74},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x1001, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x100A, 0x09, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x1013, 0x09, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x101C, 0x09, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x1025, 0x09, 0x5C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x102E, 0x09, 0x6C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x1037, 0x09, 0x7C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x1040, 0x08, 0x4C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x1048, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x1051, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x105A, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x1063, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x106B, 0x09, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x1074, 0x09, 0x58},
	{0x0000, 0x83, 0x98},
	{0x107D, 0x09, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x1086, 0x09, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x108F, 0x09, 0x58},
	{0x0000, 0x83, 0x18},
	{0x1098, 0x09, 0x68},
	{0x0000, 0x83, 0x28},
	{0x10A1, 0x09, 0x78},
	{0x0000, 0x83, 0x38},
	{0x10AA, 0x08, 0x48},
	{0x0000, 0x83, 0x08},
	{0x10B2, 0x0A, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x10BC, 0x0A, 0x74},
	{0x0000, 0x83, 0x34},
	{0x10C6, 0x0A, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x10D0, 0x0A, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x10DA, 0x0A, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x10E4, 0x0A, 0x5C},
	{0x0000, 0x83, 0x1C},
	{0x10EE, 0x0A, 0x6C},
	{0x0000, 0x83, 0x2C},
	{0x10F8, 0x0A, 0x7C},
	{0x0000, 0x83, 0x3C},
	{0x1102, 0x09, 0x4C},
	{0x0000, 0x83, 0x0C},
	{0x110B, 0x0A, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x1115, 0x08, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x111D, 0x08, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x1125, 0x08, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x112D, 0x08, 0x58},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x1135, 0x08, 0x68},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x113D, 0x08, 0x78},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x1145, 0x07, 0x48},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x114C, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x1154, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x115C, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x1164, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x116B, 0x09, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x1174, 0x09, 0x74},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x117D, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x1186, 0x09, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x118F, 0x09, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x1198, 0x09, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x11A1, 0x09, 0x5C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x11AA, 0x09, 0x6C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x11B3, 0x09, 0x7C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x11BC, 0x08, 0x4C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x11C4, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x11CD, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x11D6, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x11DF, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x11E7, 0x09, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x11F0, 0x09, 0x58},
	{0x0000, 0x83, 0x98},
	{0x11F9, 0x09, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x1202, 0x09, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x120B, 0x09, 0x58},
	{0x0000, 0x83, 0x18},
	{0x1214, 0x09, 0x68},
	{0x0000, 0x83, 0x28},
	{0x121D, 0x09, 0x78},
	{0x0000, 0x83, 0x38},
	{0x1226, 0x08, 0x48},
	{0x0000, 0x83, 0x08},
	{0x122E, 0x0A, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x1238, 0x0A, 0x74},
	{0x0000, 0x83, 0x34},
	{0x1242, 0x0A, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x124C, 0x0A, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x1256, 0x0A, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x1260, 0x0A, 0x5C},
	{0x0000, 0x83, 0x1C},
	{0x126A, 0x0A, 0x6C},
	{0x0000, 0x83, 0x2C},
	{0x1274, 0x0A, 0x7C},
	{0x0000, 0x83, 0x3C},
	{0x127E, 0x09, 0x4C},
	{0x0000, 0x83, 0x0C},
	{0x1287, 0x0A, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x1291, 0x08, 0x18},
	{0x0000, 0x83, 0x18},
	{0x1299, 0x08, 0x28},
	{0x0000, 0x83, 0x28},
	{0x12A1, 0x07, 0x08},
	{0x0000, 0x83, 0x08},
	{0x12A8, 0x08, 0x18},
	{0x0000, 0x83, 0x58},
	{0x12B0, 0x08, 0x28},
	{0x0000, 0x83, 0x68},
	{0x12B8, 0x07, 0x08},
	{0x0000, 0x83, 0x48},
	{0x12BF, 0x09, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x12C8, 0x09, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x12D1, 0x08, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x12D9, 0x09, 0x1C},
	{0x0000, 0x83, 0x5C},
	{0x12E2, 0x09, 0x2C},
	{0x0000, 0x83, 0x6C},
	{0x12EB, 0x08, 0x0C},
	{0x0000, 0x83, 0x4C},
	{0x12F3, 0x08, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x12FB, 0x08, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x1303, 0x08, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x130B, 0x08, 0x58},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x1313, 0x08, 0x68},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x131B, 0x08, 0x78},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x1323, 0x07, 0x48},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x132A, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x1332, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x133A, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x1342, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x1349, 0x09, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x1352, 0x09, 0x74},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x135B, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x1364, 0x09, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x136D, 0x09, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x1376, 0x09, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x137F, 0x09, 0x5C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x1388, 0x09, 0x6C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x1391, 0x09, 0x7C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x139A, 0x08, 0x4C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x13A2, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x13AB, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x13B4, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x13BD, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x13C5, 0x09, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x13CE, 0x09, 0x58},
	{0x0000, 0x83, 0x98},
	{0x13D7, 0x09, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x13E0, 0x09, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x13E9, 0x09, 0x58},
	{0x0000, 0x83, 0x18},
	{0x13F2, 0x09, 0x68},
	{0x0000, 0x83, 0x28},
	{0x13FB, 0x09, 0x78},
	{0x0000, 0x83, 0x38},
	{0x1404, 0x08, 0x48},
	{0x0000, 0x83, 0x08},
	{0x140C, 0x0A, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x1416, 0x0A, 0x74},
	{0x0000, 0x83, 0x34},
	{0x1420, 0x0A, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x142A, 0x0A, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x1434, 0x0A, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x143E, 0x0A, 0x5C},
	{0x0000, 0x83, 0x1C},
	{0x1448, 0x0A, 0x6C},
	{0x0000, 0x83, 0x2C},
	{0x1452, 0x0A, 0x7C},
	{0x0000, 0x83, 0x3C},
	{0x145C, 0x09, 0x4C},
	{0x0000, 0x83, 0x0C},
	{0x1465, 0x0A, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x146F, 0x08, 0x18},
	{0x0000, 0x83, 0x18},
	{0x1477, 0x08, 0x28},
	{0x0000, 0x83, 0x28},
	{0x147F, 0x07, 0x08},
	{0x0000, 0x83, 0x08},
	{0x1486, 0x08, 0x58},
	{0x0000, 0x83, 0x58},
	{0x148E, 0x08, 0x68},
	{0x0000, 0x83, 0x68},
	{0x1496, 0x07, 0x48},
	{0x0000, 0x83, 0x48},
	{0x149D, 0x09, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x14A6, 0x09, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x14AF, 0x08, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x14B7, 0x09, 0x5C},
	{0x0000, 0x83, 0x5C},
	{0x14C0, 0x09, 0x6C},
	{0x0000, 0x83, 0x6C},
	{0x14C9, 0x08, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x14D1, 0x09, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x14DA, 0x09, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x14E3, 0x0E, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x14F1, 0x0E, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x14FF, 0x0F, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x150E, 0x0F, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x151D, 0x10, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x152D, 0x10, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x153D, 0x15, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x1552, 0x15, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x1567, 0x16, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x157D, 0x16, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x1593, 0x10, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x15A3, 0x10, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x15B3, 0x15, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x15C8, 0x15, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x15DD, 0x16, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x15F3, 0x16, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x1609, 0x0F, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x1618, 0x0F, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x1627, 0x14, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x163B, 0x14, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x164F, 0x15, 0x98},
	{0x006A, 0x03, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x1664, 0x15, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x1679, 0x0A, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x1683, 0x0A, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x168D, 0x0A, 0xBC},
	{0x006A, 0x03, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x1697, 0x0F, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x16A6, 0x0F, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x16B5, 0x10, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x16C5, 0x10, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x16D5, 0x11, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x16E6, 0x11, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x16F7, 0x11, 0xBC},
	{0x006A, 0x03, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x1708, 0x16, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x171E, 0x16, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x1734, 0x17, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x174B, 0x17, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x1762, 0x11, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x1773, 0x11, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x1784, 0x11, 0xBC},
	{0x006A, 0x03, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x1795, 0x16, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x17AB, 0x16, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x17C1, 0x17, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x17D8, 0x17, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x17EF, 0x10, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x17FF, 0x10, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x180F, 0x10, 0xBC},
	{0x006A, 0x03, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x181F, 0x15, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x004A, 0x87, 0x25},
	{0x1834, 0x15, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xA8},
	{0x004A, 0x87, 0x25},
	{0x1849, 0x16, 0x9C},
	{0x006A, 0x03, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x004A, 0x87, 0x25},
	{0x185F, 0x16, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x004A, 0x87, 0x25},
	{0x1875, 0x07, 0xC8},
	{0x0000, 0x83, 0xC8},
	{0x187C, 0x07, 0x08},
	{0x0000, 0x83, 0x08},
	{0x1883, 0x07, 0x48},
	{0x0000, 0x83, 0x48},
	{0x188A, 0x08, 0xCC},
	{0x0000, 0x83, 0xCC},
	{0x1892, 0x08, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x189A, 0x08, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x18A2, 0x0D, 0x8C},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x83, 0x88},
	{0x18AF, 0x0C, 0x9C},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x18BB, 0x0C, 0xAC},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x18C7, 0x0C, 0xBC},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x18D3, 0x0C, 0xDC},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0x18DF, 0x0C, 0xEC},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x83, 0xE8},
	{0x18EB, 0x0B, 0xCC},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0x18F6, 0x0C, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x1902, 0x0C, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x190E, 0x0C, 0x3C},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x191A, 0x0B, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x1925, 0x0C, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x1931, 0x0C, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x193D, 0x0C, 0x7C},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x1949, 0x0B, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x1954, 0x0F, 0x88},
	{0x0000, 0x03, 0x88},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x88},
	{0x005E, 0x87, 0x25},
	{0x1963, 0x0E, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xA8},
	{0x005E, 0x87, 0x25},
	{0x1971, 0x0E, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xB8},
	{0x005E, 0x87, 0x25},
	{0x197F, 0x0E, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xD8},
	{0x005E, 0x87, 0x25},
	{0x198D, 0x0E, 0xE8},
	{0x0000, 0x03, 0xE8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xE8},
	{0x005E, 0x87, 0x25},
	{0x199B, 0x0D, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xC8},
	{0x005E, 0x87, 0x25},
	{0x19A8, 0x0E, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x18},
	{0x005E, 0x87, 0x25},
	{0x19B6, 0x0E, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x28},
	{0x005E, 0x87, 0x25},
	{0x19C4, 0x0E, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x38},
	{0x005E, 0x87, 0x25},
	{0x19D2, 0x0D, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x08},
	{0x005E, 0x87, 0x25},
	{0x19DF, 0x0E, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x58},
	{0x005E, 0x87, 0x25},
	{0x19ED, 0x0E, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x68},
	{0x005E, 0x87, 0x25},
	{0x19FB, 0x0E, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x78},
	{0x005E, 0x87, 0x25},
	{0x1A09, 0x0D, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x48},
	{0x005E, 0x87, 0x25},
	{0x1A16, 0x10, 0x88},
	{0x0000, 0x03, 0x88},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x8C},
	{0x005E, 0x87, 0x25},
	{0x1A26, 0x0F, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xAC},
	{0x005E, 0x87, 0x25},
	{0x1A35, 0x0F, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xBC},
	{0x005E, 0x87, 0x25},
	{0x1A44, 0x0F, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xDC},
	{0x005E, 0x87, 0x25},
	{0x1A53, 0x0F, 0xE8},
	{0x0000, 0x03, 0xE8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xEC},
	{0x005E, 0x87, 0x25},
	{0x1A62, 0x0E, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xCC},
	{0x005E, 0x87, 0x25},
	{0x1A70, 0x0F, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x1C},
	{0x005E, 0x87, 0x25},
	{0x1A7F, 0x0F, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x2C},
	{0x005E, 0x87, 0x25},
	{0x1A8E, 0x0F, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x3C},
	{0x005E, 0x87, 0x25},
	{0x1A9D, 0x0E, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x0C},
	{0x005E, 0x87, 0x25},
	{0x1AAB, 0x0F, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x5C},
	{0x005E, 0x87, 0x25},
	{0x1ABA, 0x0F, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x6C},
	{0x005E, 0x87, 0x25},
	{0x1AC9, 0x0F, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x7C},
	{0x005E, 0x87, 0x25},
	{0x1AD8, 0x0E, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x4C},
	{0x005E, 0x87, 0x25},
	{0x1AE6, 0x10, 0x8C},
	{0x0000, 0x03, 0x8C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x88},
	{0x005E, 0x87, 0x25},
	{0x1AF6, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xA8},
	{0x005E, 0x87, 0x25},
	{0x1B05, 0x0F, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xB8},
	{0x005E, 0x87, 0x25},
	{0x1B14, 0x0F, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xD8},
	{0x005E, 0x87, 0x25},
	{0x1B23, 0x0F, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xE8},
	{0x005E, 0x87, 0x25},
	{0x1B32, 0x0E, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xC8},
	{0x005E, 0x87, 0x25},
	{0x1B40, 0x0F, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x18},
	{0x005E, 0x87, 0x25},
	{0x1B4F, 0x0F, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x28},
	{0x005E, 0x87, 0x25},
	{0x1B5E, 0x0F, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x38},
	{0x005E, 0x87, 0x25},
	{0x1B6D, 0x0E, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x08},
	{0x005E, 0x87, 0x25},
	{0x1B7B, 0x0F, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x58},
	{0x005E, 0x87, 0x25},
	{0x1B8A, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x68},
	{0x005E, 0x87, 0x25},
	{0x1B99, 0x0F, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x78},
	{0x005E, 0x87, 0x25},
	{0x1BA8, 0x0E, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x48},
	{0x005E, 0x87, 0x25},
	{0x1BB6, 0x11, 0x8C},
	{0x0000, 0x03, 0x8C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x8C},
	{0x005E, 0x87, 0x25},
	{0x1BC7, 0x10, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xAC},
	{0x005E, 0x87, 0x25},
	{0x1BD7, 0x10, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xBC},
	{0x005E, 0x87, 0x25},
	{0x1BE7, 0x10, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xDC},
	{0x005E, 0x87, 0x25},
	{0x1BF7, 0x10, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xEC},
	{0x005E, 0x87, 0x25},
	{0x1C07, 0x0F, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0xCC},
	{0x005E, 0x87, 0x25},
	{0x1C16, 0x10, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x1C},
	{0x005E, 0x87, 0x25},
	{0x1C26, 0x10, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x2C},
	{0x005E, 0x87, 0x25},
	{0x1C36, 0x10, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x3C},
	{0x005E, 0x87, 0x25},
	{0x1C46, 0x0F, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x0C},
	{0x005E, 0x87, 0x25},
	{0x1C55, 0x10, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x5C},
	{0x005E, 0x87, 0x25},
	{0x1C65, 0x10, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x6C},
	{0x005E, 0x87, 0x25},
	{0x1C75, 0x10, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x7C},
	{0x005E, 0x87, 0x25},
	{0x1C85, 0x0F, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0057, 0x07, 0x25},
	{0x0008, 0x03, 0x4C},
	{0x005E, 0x87, 0x25},
	{0x1C94, 0x0C, 0x88},
	{0x0000, 0x83, 0x74},
	{0x1CA0, 0x0B, 0x98},
	{0x0000, 0x83, 0x74},
	{0x1CAB, 0x0B, 0xA8},
	{0x0000, 0x83, 0x74},
	{0x1CB6, 0x0B, 0xB8},
	{0x0000, 0x83, 0x74},
	{0x1CC1, 0x0B, 0xD8},
	{0x0000, 0x83, 0x74},
	{0x1CCC, 0x0B, 0xE8},
	{0x0000, 0x83, 0x74},
	{0x1CD7, 0x0A, 0xC8},
	{0x0000, 0x83, 0x74},
	{0x1CE1, 0x0B, 0x18},
	{0x0000, 0x83, 0x74},
	{0x1CEC, 0x0B, 0x28},
	{0x0000, 0x83, 0x74},
	{0x1CF7, 0x0B, 0x38},
	{0x0000, 0x83, 0x74},
	{0x1D02, 0x0A, 0x08},
	{0x0000, 0x83, 0x74},
	{0x1D0C, 0x0B, 0x58},
	{0x0000, 0x83, 0x74},
	{0x1D17, 0x0B, 0x68},
	{0x0000, 0x83, 0x74},
	{0x1D22, 0x0B, 0x78},
	{0x0000, 0x83, 0x74},
	{0x1D2D, 0x0A, 0x48},
	{0x0000, 0x83, 0x74},
	{0x1D37, 0x0D, 0x88},
	{0x0000, 0x83, 0xAC},
	{0x1D44, 0x0C, 0x98},
	{0x0000, 0x83, 0xAC},
	{0x1D50, 0x0C, 0x98},
	{0x0000, 0x83, 0x18},
	{0x1D5C, 0x0C, 0x98},
	{0x0000, 0x83, 0x58},
	{0x1D68, 0x0D, 0xAC},
	{0x0000, 0x83, 0x88},
	{0x1D75, 0x0C, 0xAC},
	{0x0000, 0x83, 0x98},
	{0x1D81, 0x0C, 0xA8},
	{0x0000, 0x83, 0xBC},
	{0x1D8D, 0x0C, 0xA8},
	{0x0000, 0x83, 0x28},
	{0x1D99, 0x0C, 0xA8},
	{0x0000, 0x83, 0x68},
	{0x1DA5, 0x0C, 0xBC},
	{0x0000, 0x83, 0xA8},
	{0x1DB1, 0x0C, 0xB8},
	{0x0000, 0x83, 0x38},
	{0x1DBD, 0x0C, 0xB8},
	{0x0000, 0x83, 0x78},
	{0x1DC9, 0x11, 0x9C},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0xAC},
	{0x1DDA, 0x11, 0xAC},
	{0x0000, 0x83, 0x9C},
	{0x1DEB, 0x11, 0xAC},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xBC},
	{0x1DFC, 0x11, 0xBC},
	{0x0000, 0x83, 0xAC},
	{0x1E0D, 0x0E, 0x98},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x1E1B, 0x0E, 0x98},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0x1E29, 0x0E, 0xA8},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x1E37, 0x0E, 0xA8},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0x1E45, 0x0E, 0xB8},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x1E53, 0x0E, 0xB8},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0x1E61, 0x0E, 0x18},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x25},
	{0x1E6F, 0x0E, 0x28},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0x25},
	{0x1E7D, 0x0E, 0x38},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0x25},
	{0x1E8B, 0x0E, 0x58},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x25},
	{0x1E99, 0x0E, 0x68},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0x25},
	{0x1EA7, 0x0E, 0x78},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0x25},
	{0x1EB5, 0x0C, 0x18},
	{0x0000, 0x83, 0x98},
	{0x1EC1, 0x0C, 0x28},
	{0x0000, 0x83, 0xA8},
	{0x1ECD, 0x0C, 0x38},
	{0x0000, 0x83, 0xB8},
	{0x1ED9, 0x0C, 0x58},
	{0x0000, 0x83, 0x98},
	{0x1EE5, 0x0C, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x1EF1, 0x0C, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x1EFD, 0x0D, 0x18},
	{0x0000, 0x83, 0x98},
	{0x1F0A, 0x0D, 0x28},
	{0x0000, 0x83, 0xA8},
	{0x1F17, 0x0D, 0x38},
	{0x0000, 0x83, 0xB8},
	{0x1F24, 0x0D, 0x58},
	{0x0000, 0x83, 0x98},
	{0x1F31, 0x0D, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x1F3E, 0x0D, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x1F4B, 0x0E, 0x34},
	{0x0000, 0x83, 0xB4},
	{0x1F59, 0x0E, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x1F67, 0x0E, 0x1C},
	{0x0000, 0x83, 0x9C},
	{0x1F75, 0x0E, 0x2C},
	{0x0000, 0x83, 0xAC},
	{0x1F83, 0x0E, 0x3C},
	{0x0000, 0x83, 0xBC},
	{0x1F91, 0x0E, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x1F9F, 0x0E, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x1FAD, 0x0E, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x1FBB, 0x0E, 0x24},
	{0x0000, 0x83, 0xA4},
	{0x1FC9, 0x0E, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x1FD7, 0x0D, 0xB4},
	{0x0000, 0x83, 0x34},
	{0x1FE4, 0x0D, 0xB4},
	{0x0000, 0x83, 0x74},
	{0x1FF1, 0x0F, 0xB4},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x2000, 0x0F, 0xB4},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x25},
	{0x200F, 0x0F, 0x34},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0x25},
	{0x201E, 0x0F, 0x74},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0x25},
	{0x202D, 0x0D, 0x34},
	{0x0000, 0x83, 0xB4},
	{0x203A, 0x0D, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x2047, 0x0D, 0x18},
	{0x0000, 0x83, 0x98},
	{0x2054, 0x0D, 0x28},
	{0x0000, 0x83, 0xA8},
	{0x2061, 0x0D, 0x38},
	{0x0000, 0x83, 0xB8},
	{0x206E, 0x0D, 0x58},
	{0x0000, 0x83, 0x98},
	{0x207B, 0x0D, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x2088, 0x0D, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x2095, 0x0E, 0x34},
	{0x0000, 0x83, 0xB4},
	{0x20A3, 0x0E, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x20B1, 0x0E, 0x1C},
	{0x0000, 0x83, 0x9C},
	{0x20BF, 0x0E, 0x2C},
	{0x0000, 0x83, 0xAC},
	{0x20CD, 0x0E, 0x3C},
	{0x0000, 0x83, 0xBC},
	{0x20DB, 0x0E, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x20E9, 0x0E, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x20F7, 0x0E, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x2105, 0x0E, 0x24},
	{0x0000, 0x83, 0xA4},
	{0x2113, 0x0E, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x2121, 0x0D, 0x18},
	{0x0000, 0x83, 0x98},
	{0x212E, 0x0D, 0x28},
	{0x0000, 0x83, 0xA8},
	{0x213B, 0x0D, 0x38},
	{0x0000, 0x83, 0xB8},
	{0x2148, 0x0D, 0x58},
	{0x0000, 0x83, 0x98},
	{0x2155, 0x0D, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x2162, 0x0D, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x216F, 0x0E, 0x34},
	{0x0000, 0x83, 0xB4},
	{0x217D, 0x0E, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x218B, 0x0E, 0x1C},
	{0x0000, 0x83, 0x9C},
	{0x2199, 0x0E, 0x2C},
	{0x0000, 0x83, 0xAC},
	{0x21A7, 0x0E, 0x3C},
	{0x0000, 0x83, 0xBC},
	{0x21B5, 0x0E, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x21C3, 0x0E, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x21D1, 0x0E, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x21DF, 0x0E, 0x24},
	{0x0000, 0x83, 0xA4},
	{0x21ED, 0x0E, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x21FB, 0x0D, 0x18},
	{0x0000, 0x83, 0x98},
	{0x2208, 0x0D, 0x28},
	{0x0000, 0x83, 0xA8},
	{0x2215, 0x0D, 0x38},
	{0x0000, 0x83, 0xB8},
	{0x2222, 0x0D, 0x58},
	{0x0000, 0x83, 0x98},
	{0x222F, 0x0D, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x223C, 0x0D, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x2249, 0x0E, 0x34},
	{0x0000, 0x83, 0xB4},
	{0x2257, 0x0E, 0x74},
	{0x0000, 0x83, 0xB4},
	{0x2265, 0x0E, 0x1C},
	{0x0000, 0x83, 0x9C},
	{0x2273, 0x0E, 0x2C},
	{0x0000, 0x83, 0xAC},
	{0x2281, 0x0E, 0x3C},
	{0x0000, 0x83, 0xBC},
	{0x228F, 0x0E, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x229D, 0x0E, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x22AB, 0x0E, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x22B9, 0x0E, 0x24},
	{0x0000, 0x83, 0xA4},
	{0x22C7, 0x0E, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x22D5, 0x0D, 0x9C},
	{0x0000, 0x83, 0x1C},
	{0x22E2, 0x0D, 0x9C},
	{0x0000, 0x83, 0x5C},
	{0x22EF, 0x0D, 0xAC},
	{0x0000, 0x83, 0x2C},
	{0x22FC, 0x0D, 0xAC},
	{0x0000, 0x83, 0x6C},
	{0x2309, 0x0D, 0xBC},
	{0x0000, 0x83, 0x3C},
	{0x2316, 0x0D, 0xBC},
	{0x0000, 0x83, 0x7C},
	{0x2323, 0x13, 0x8C},
	{0x0040, 0x0A, 0x8C},
	{0x0000, 0x83, 0xAC},
	{0x2336, 0x13, 0xAC},
	{0x0000, 0x83, 0x8C},
	{0x2349, 0x12, 0x8C},
	{0x0000, 0x83, 0xAC},
	{0x235B, 0x12, 0xAC},
	{0x0000, 0x83, 0x8C},
	{0x236D, 0x0F, 0x9C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x237C, 0x0F, 0x9C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x238B, 0x0F, 0xAC},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x239A, 0x0F, 0xAC},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x23A9, 0x0F, 0xBC},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x23B8, 0x0F, 0xBC},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x23C7, 0x0F, 0x1C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x25},
	{0x23D6, 0x0F, 0x2C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0x25},
	{0x23E5, 0x0F, 0x3C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0x25},
	{0x23F4, 0x0F, 0x5C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x25},
	{0x2403, 0x0F, 0x6C},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0x25},
	{0x2412, 0x0F, 0x7C},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0x25},
	{0x2421, 0x0D, 0x1C},
	{0x0000, 0x83, 0x9C},
	{0x242E, 0x0D, 0x2C},
	{0x0000, 0x83, 0xAC},
	{0x243B, 0x0D, 0x3C},
	{0x0000, 0x83, 0xBC},
	{0x2448, 0x0D, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x2455, 0x0D, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x2462, 0x0D, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x246F, 0x0D, 0xA4},
	{0x0000, 0x83, 0x24},
	{0x247C, 0x0D, 0xA4},
	{0x0000, 0x83, 0x64},
	{0x2489, 0x0F, 0xA4},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x25},
	{0x2498, 0x0F, 0xA4},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x25},
	{0x24A7, 0x0F, 0x24},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0x25},
	{0x24B6, 0x0F, 0x64},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0x25},
	{0x24C5, 0x0D, 0x24},
	{0x0000, 0x83, 0xA4},
	{0x24D2, 0x0D, 0x64},
	{0x0000, 0x83, 0xA4},
	{0x24DF, 0x0D, 0xA8},
	{0x0000, 0x83, 0xBC},
	{0x24EC, 0x12, 0xAC},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xBC},
	{0x24FE, 0x0E, 0xA4},
	{0x0000, 0x83, 0xB4},
	{0x250C, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x2514, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x251C, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x2524, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x252D, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x2536, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x253F, 0x0D, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x004A, 0x87, 0x25},
	{0x254C, 0x0D, 0x68},
	{0x006A, 0x03, 0x68},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x004A, 0x87, 0x25},
	{0x2559, 0x0E, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x0C},
	{0x004A, 0x87, 0x25},
	{0x2567, 0x0E, 0x68},
	{0x006A, 0x03, 0x68},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x4C},
	{0x004A, 0x87, 0x25},
	{0x2575, 0x08, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x257D, 0x08, 0x68},
	{0x006A, 0x03, 0x68},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x2585, 0x0E, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x08},
	{0x004A, 0x87, 0x25},
	{0x2593, 0x0E, 0x6C},
	{0x006A, 0x03, 0x6C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x48},
	{0x004A, 0x87, 0x25},
	{0x25A1, 0x0F, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x004A, 0x87, 0x25},
	{0x25B0, 0x0F, 0x6C},
	{0x006A, 0x03, 0x6C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x004A, 0x87, 0x25},
	{0x25BF, 0x09, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x25C8, 0x09, 0x6C},
	{0x006A, 0x03, 0x6C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x25D1, 0x0E, 0x88},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x83, 0x25},
	{0x25DF, 0x0D, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x25},
	{0x25EC, 0x0D, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0x25},
	{0x25F9, 0x0D, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0x25},
	{0x2606, 0x0D, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0x25},
	{0x2613, 0x0D, 0xE8},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x83, 0x25},
	{0x2620, 0x0C, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0x25},
	{0x262C, 0x0D, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x2639, 0x0D, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x2646, 0x0D, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x2653, 0x0C, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0x265F, 0x0D, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0x266C, 0x0D, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0x2679, 0x0D, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0x2686, 0x0C, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0x2692, 0x0F, 0x88},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x25},
	{0x26A1, 0x0E, 0x98},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x25},
	{0x26AF, 0x0E, 0xA8},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0x25},
	{0x26BD, 0x0E, 0xB8},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0x25},
	{0x26CB, 0x0E, 0xD8},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0x25},
	{0x26D9, 0x0E, 0xE8},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0x25},
	{0x26E7, 0x0D, 0xC8},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0x25},
	{0x26F4, 0x0E, 0x18},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x2702, 0x0E, 0x28},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x2710, 0x0E, 0x38},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x271E, 0x0D, 0x08},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0x272B, 0x0E, 0x58},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x2739, 0x0E, 0x68},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x2747, 0x0E, 0x78},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x2755, 0x0D, 0x48},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0x2762, 0x0B, 0x88},
	{0x0000, 0x83, 0x84},
	{0x276D, 0x0A, 0x98},
	{0x0000, 0x83, 0x94},
	{0x2777, 0x0A, 0xA8},
	{0x0000, 0x83, 0xA4},
	{0x2781, 0x0A, 0xB8},
	{0x0000, 0x83, 0xB4},
	{0x278B, 0x0A, 0xD8},
	{0x0000, 0x83, 0xD4},
	{0x2795, 0x0A, 0xE8},
	{0x0000, 0x83, 0xE4},
	{0x279F, 0x09, 0xC8},
	{0x0000, 0x83, 0xC4},
	{0x27A8, 0x0A, 0x18},
	{0x0000, 0x83, 0x14},
	{0x27B2, 0x0A, 0x28},
	{0x0000, 0x83, 0x24},
	{0x27BC, 0x0A, 0x38},
	{0x0000, 0x83, 0x34},
	{0x27C6, 0x09, 0x08},
	{0x0000, 0x83, 0x04},
	{0x27CF, 0x0A, 0x58},
	{0x0000, 0x83, 0x54},
	{0x27D9, 0x0A, 0x68},
	{0x0000, 0x83, 0x64},
	{0x27E3, 0x0A, 0x78},
	{0x0000, 0x83, 0x74},
	{0x27ED, 0x09, 0x48},
	{0x0000, 0x83, 0x44},
	{0x27F6, 0x0D, 0xC4},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0x25},
	{0x2803, 0x0D, 0x04},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0x2810, 0x0D, 0x44},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0x281D, 0x0E, 0xC4},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0x25},
	{0x282B, 0x0E, 0x04},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0x2839, 0x0E, 0x44},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0x2847, 0x0E, 0xB4},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0x25},
	{0x2855, 0x0E, 0x34},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x2863, 0x0E, 0x74},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0x2871, 0x0F, 0xB4},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0x25},
	{0x2880, 0x0F, 0x34},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x288F, 0x0F, 0x74},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x289E, 0x0F, 0x84},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x83, 0x25},
	{0x28AD, 0x0E, 0x94},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x25},
	{0x28BB, 0x0E, 0xD4},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0x25},
	{0x28C9, 0x0E, 0x14},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x28D7, 0x0E, 0x54},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0x28E5, 0x10, 0x84},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x25},
	{0x28F5, 0x0F, 0x94},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x25},
	{0x2904, 0x0F, 0xD4},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0x25},
	{0x2913, 0x0F, 0x14},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x2922, 0x0F, 0x54},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x2931, 0x0F, 0x8C},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x83, 0x25},
	{0x2940, 0x0E, 0x9C},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x25},
	{0x294E, 0x0E, 0xAC},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0x25},
	{0x295C, 0x0E, 0xBC},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0x25},
	{0x296A, 0x0E, 0xDC},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0x25},
	{0x2978, 0x0E, 0xEC},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x83, 0x25},
	{0x2986, 0x0D, 0xCC},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0x25},
	{0x2993, 0x0E, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x29A1, 0x0E, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x29AF, 0x0E, 0x3C},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x29BD, 0x0D, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0x29CA, 0x0E, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0x29D8, 0x0E, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0x29E6, 0x0E, 0x7C},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0x29F4, 0x0D, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0x2A01, 0x10, 0x8C},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x25},
	{0x2A11, 0x0F, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x25},
	{0x2A20, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0x25},
	{0x2A2F, 0x0F, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0x25},
	{0x2A3E, 0x0F, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0x25},
	{0x2A4D, 0x0F, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0x25},
	{0x2A5C, 0x0E, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0x25},
	{0x2A6A, 0x0F, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x2A79, 0x0F, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x2A88, 0x0F, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x2A97, 0x0E, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0x2AA5, 0x0F, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x2AB4, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x2AC3, 0x0F, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x2AD2, 0x0E, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0x2AE0, 0x0C, 0x8C},
	{0x0000, 0x83, 0x84},
	{0x2AEC, 0x0B, 0x9C},
	{0x0000, 0x83, 0x94},
	{0x2AF7, 0x0B, 0xAC},
	{0x0000, 0x83, 0xA4},
	{0x2B02, 0x0B, 0xBC},
	{0x0000, 0x83, 0xB4},
	{0x2B0D, 0x0B, 0xDC},
	{0x0000, 0x83, 0xD4},
	{0x2B18, 0x0B, 0xEC},
	{0x0000, 0x83, 0xE4},
	{0x2B23, 0x0A, 0xCC},
	{0x0000, 0x83, 0xC4},
	{0x2B2D, 0x0B, 0x1C},
	{0x0000, 0x83, 0x14},
	{0x2B38, 0x0B, 0x2C},
	{0x0000, 0x83, 0x24},
	{0x2B43, 0x0B, 0x3C},
	{0x0000, 0x83, 0x34},
	{0x2B4E, 0x0A, 0x0C},
	{0x0000, 0x83, 0x04},
	{0x2B58, 0x0B, 0x5C},
	{0x0000, 0x83, 0x54},
	{0x2B63, 0x0B, 0x6C},
	{0x0000, 0x83, 0x64},
	{0x2B6E, 0x0B, 0x7C},
	{0x0000, 0x83, 0x74},
	{0x2B79, 0x0A, 0x4C},
	{0x0000, 0x83, 0x44},
	{0x2B83, 0x0E, 0xA4},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0x25},
	{0x2B91, 0x0E, 0x24},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x2B9F, 0x0E, 0x64},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0x2BAD, 0x0F, 0xA4},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0x25},
	{0x2BBC, 0x0F, 0x24},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x2BCB, 0x0F, 0x64},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x2BDA, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x2BE4, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x2BEE, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x3C},
	{0x2BF8, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x2C01, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x2C0B, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x2C15, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0x2C1F, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x2C28, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x2C30, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x2C38, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x2C40, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x2C47, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x2C4F, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x2C57, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x2C5F, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x2C66, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x2C6F, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x2C78, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x2C81, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x2C89, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x2C92, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x2C9B, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x2CA4, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x2CAC, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x83, 0x25},
	{0x2CB4, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0x25},
	{0x2CBC, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0x25},
	{0x2CC4, 0x08, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x03, 0xD8},
	{0x000B, 0x83, 0x25},
	{0x2CCC, 0x08, 0xE8},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x03, 0xE8},
	{0x000B, 0x83, 0x25},
	{0x2CD4, 0x07, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x03, 0xC8},
	{0x000B, 0x83, 0x25},
	{0x2CDB, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x2CE3, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x2CEB, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x03, 0x38},
	{0x000B, 0x83, 0x25},
	{0x2CF3, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x25},
	{0x2CFA, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x25},
	{0x2D02, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x25},
	{0x2D0A, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0x78},
	{0x000B, 0x83, 0x25},
	{0x2D12, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x25},
	{0x2D19, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x83, 0x25},
	{0x2D22, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0x25},
	{0x2D2B, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0x25},
	{0x2D34, 0x09, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x03, 0xDC},
	{0x000B, 0x83, 0x25},
	{0x2D3D, 0x09, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x03, 0xEC},
	{0x000B, 0x83, 0x25},
	{0x2D46, 0x08, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x03, 0xCC},
	{0x000B, 0x83, 0x25},
	{0x2D4E, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x2D57, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x2D60, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0x2D69, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x25},
	{0x2D71, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0x2D7A, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0x2D83, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0x2D8C, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x25},
	{0x2D94, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x83, 0x98},
	{0x2D9C, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA8},
	{0x2DA4, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0xB8},
	{0x2DAC, 0x0D, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x2DB9, 0x0D, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x2DC6, 0x0D, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x2DD3, 0x0E, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x2DE1, 0x0E, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x2DEF, 0x0E, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x2DFD, 0x0A, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x83, 0x94},
	{0x2E07, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA4},
	{0x2E11, 0x0A, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0xB4},
	{0x2E1B, 0x0E, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x03, 0xB4},
	{0x000B, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x2E29, 0x0F, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x03, 0xB4},
	{0x000B, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x2E38, 0x0E, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x94},
	{0x000B, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x2E46, 0x0F, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x94},
	{0x000B, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x2E55, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x83, 0x9C},
	{0x2E5E, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xAC},
	{0x2E67, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0xBC},
	{0x2E70, 0x0E, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x2E7E, 0x0E, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x2E8C, 0x0E, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x2E9A, 0x0F, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x2EA9, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x2EB8, 0x0F, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x2EC7, 0x0B, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x83, 0x94},
	{0x2ED2, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xA4},
	{0x2EDD, 0x0B, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0xB4},
	{0x2EE8, 0x0E, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x03, 0xA4},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x2EF6, 0x0F, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x03, 0xA4},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x2F05, 0x0F, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x2F14, 0x14, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x2F28, 0x13, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x2F3B, 0x15, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x2F50, 0x14, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x2F64, 0x0E, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x2F72, 0x10, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x2F82, 0x15, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x2F97, 0x14, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x2FAB, 0x16, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x2FC1, 0x15, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x2FD6, 0x0F, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x2FE5, 0x0F, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x2FF4, 0x14, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x3008, 0x13, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x301B, 0x15, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x3030, 0x14, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x3044, 0x0E, 0xA8},
	{0x006A, 0x03, 0xA8},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x3052, 0x10, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x3062, 0x15, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x3077, 0x14, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x308B, 0x16, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x30A1, 0x15, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x30B6, 0x0F, 0xAC},
	{0x006A, 0x03, 0xAC},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x30C5, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x83, 0x98},
	{0x30CD, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA8},
	{0x30D5, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0xB8},
	{0x30DD, 0x0D, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x30EA, 0x0D, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x30F7, 0x0D, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x3104, 0x0E, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x3112, 0x0E, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x3120, 0x0E, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x312E, 0x0A, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x000B, 0x83, 0x94},
	{0x3138, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA4},
	{0x3142, 0x0A, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0xB4},
	{0x314C, 0x0E, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x03, 0xB4},
	{0x000B, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x315A, 0x0F, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x03, 0xB4},
	{0x000B, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x3169, 0x0E, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x94},
	{0x000B, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x3177, 0x0F, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x94},
	{0x000B, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x3186, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x83, 0x9C},
	{0x318F, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xAC},
	{0x3198, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0xBC},
	{0x31A1, 0x0E, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x31AF, 0x0E, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x31BD, 0x0E, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x31CB, 0x0F, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x31DA, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x31E9, 0x0F, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x31F8, 0x0B, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x000B, 0x83, 0x94},
	{0x3203, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xA4},
	{0x320E, 0x0B, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0xB4},
	{0x3219, 0x0E, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x03, 0xA4},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x3227, 0x0F, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x03, 0xA4},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x3236, 0x0E, 0x88},
	{0x0000, 0x83, 0x8C},
	{0x3244, 0x0D, 0x98},
	{0x0000, 0x83, 0x9C},
	{0x3251, 0x0D, 0xA8},
	{0x0000, 0x83, 0xAC},
	{0x325E, 0x0D, 0xB8},
	{0x0000, 0x83, 0xBC},
	{0x326B, 0x0D, 0xD8},
	{0x0000, 0x83, 0xDC},
	{0x3278, 0x0D, 0xE8},
	{0x0000, 0x83, 0xEC},
	{0x3285, 0x0C, 0xC8},
	{0x0000, 0x83, 0xCC},
	{0x3291, 0x0D, 0x18},
	{0x0000, 0x83, 0x1C},
	{0x329E, 0x0D, 0x28},
	{0x0000, 0x83, 0x2C},
	{0x32AB, 0x0D, 0x38},
	{0x0000, 0x83, 0x3C},
	{0x32B8, 0x0C, 0x08},
	{0x0000, 0x83, 0x0C},
	{0x32C4, 0x0D, 0x58},
	{0x0000, 0x83, 0x5C},
	{0x32D1, 0x0D, 0x68},
	{0x0000, 0x83, 0x6C},
	{0x32DE, 0x0D, 0x78},
	{0x0000, 0x83, 0x7C},
	{0x32EB, 0x0C, 0x48},
	{0x0000, 0x83, 0x4C},
	{0x32F7, 0x0E, 0x84},
	{0x0000, 0x03, 0x88},
	{0x0008, 0x83, 0x25},
	{0x3305, 0x0D, 0x94},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x25},
	{0x3312, 0x0D, 0xA4},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0x25},
	{0x331F, 0x0D, 0xB4},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0x25},
	{0x332C, 0x0D, 0xD4},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0x25},
	{0x3339, 0x0D, 0xE4},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x83, 0x25},
	{0x3346, 0x0C, 0xC4},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0x25},
	{0x3352, 0x0D, 0x14},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x335F, 0x0D, 0x24},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x336C, 0x0D, 0x34},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x3379, 0x0C, 0x04},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0x3385, 0x0D, 0x54},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0x3392, 0x0D, 0x64},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0x339F, 0x0D, 0x74},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0x33AC, 0x0C, 0x44},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0x33B8, 0x0D, 0x88},
	{0x0000, 0x83, 0x8C},
	{0x33C5, 0x0C, 0x98},
	{0x0000, 0x83, 0x9C},
	{0x33D1, 0x0C, 0xA8},
	{0x0000, 0x83, 0xAC},
	{0x33DD, 0x0C, 0xB8},
	{0x0000, 0x83, 0xBC},
	{0x33E9, 0x0C, 0xD8},
	{0x0000, 0x83, 0xDC},
	{0x33F5, 0x0C, 0xE8},
	{0x0000, 0x83, 0xEC},
	{0x3401, 0x0B, 0xC8},
	{0x0000, 0x83, 0xCC},
	{0x340C, 0x0C, 0x18},
	{0x0000, 0x83, 0x1C},
	{0x3418, 0x0C, 0x28},
	{0x0000, 0x83, 0x2C},
	{0x3424, 0x0C, 0x38},
	{0x0000, 0x83, 0x3C},
	{0x3430, 0x0B, 0x08},
	{0x0000, 0x83, 0x0C},
	{0x343B, 0x0C, 0x58},
	{0x0000, 0x83, 0x5C},
	{0x3447, 0x0C, 0x68},
	{0x0000, 0x83, 0x6C},
	{0x3453, 0x0C, 0x78},
	{0x0000, 0x83, 0x7C},
	{0x345F, 0x0B, 0x48},
	{0x0000, 0x83, 0x4C},
	{0x346A, 0x0F, 0x84},
	{0x0000, 0x03, 0x8C},
	{0x0008, 0x83, 0x25},
	{0x3479, 0x0E, 0x94},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x25},
	{0x3487, 0x0E, 0xA4},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0x25},
	{0x3495, 0x0E, 0xB4},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0x25},
	{0x34A3, 0x0E, 0xD4},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0x25},
	{0x34B1, 0x0E, 0xE4},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0x25},
	{0x34BF, 0x0D, 0xC4},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0x25},
	{0x34CC, 0x0E, 0x14},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x34DA, 0x0E, 0x24},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x34E8, 0x0E, 0x34},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x34F6, 0x0D, 0x04},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0x3503, 0x0E, 0x54},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x3511, 0x0E, 0x64},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x351F, 0x0E, 0x74},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x352D, 0x0D, 0x44},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0x353A, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x3543, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x354C, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x3554, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x355D, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x3566, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x356E, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x3578, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x3582, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x358B, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x3595, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x359F, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x35A8, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x35B1, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x35BA, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x35C2, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x35CB, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x35D4, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x35DC, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x35E6, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x35F0, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x35F9, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x3603, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x360D, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x3616, 0x09, 0x88},
	{0x0000, 0x83, 0x87},
	{0x361F, 0x0C, 0x89},
	{0x0000, 0x83, 0x87},
	{0x362B, 0x0C, 0x8A},
	{0x0000, 0x83, 0x87},
	{0x3637, 0x0C, 0x8B},
	{0x0000, 0x83, 0x87},
	{0x3643, 0x0D, 0x88},
	{0x0000, 0x83, 0x87},
	{0x3650, 0x0C, 0x98},
	{0x0000, 0x83, 0x97},
	{0x365C, 0x0C, 0xA8},
	{0x0000, 0x83, 0xA7},
	{0x3668, 0x0C, 0xB8},
	{0x0000, 0x83, 0xB7},
	{0x3674, 0x0C, 0xD8},
	{0x0000, 0x83, 0xD7},
	{0x3680, 0x0C, 0xE8},
	{0x0000, 0x83, 0xE7},
	{0x368C, 0x0B, 0xC8},
	{0x0000, 0x83, 0xC7},
	{0x3697, 0x0C, 0x18},
	{0x0000, 0x83, 0x17},
	{0x36A3, 0x0C, 0x28},
	{0x0000, 0x83, 0x27},
	{0x36AF, 0x0C, 0x38},
	{0x0000, 0x83, 0x37},
	{0x36BB, 0x0B, 0x08},
	{0x0000, 0x83, 0x07},
	{0x36C6, 0x0C, 0x58},
	{0x0000, 0x83, 0x57},
	{0x36D2, 0x0C, 0x68},
	{0x0000, 0x83, 0x67},
	{0x36DE, 0x0C, 0x78},
	{0x0000, 0x83, 0x77},
	{0x36EA, 0x0B, 0x48},
	{0x0000, 0x83, 0x47},
	{0x36F5, 0x08, 0x98},
	{0x0000, 0x83, 0x97},
	{0x36FD, 0x0B, 0x99},
	{0x0000, 0x83, 0x97},
	{0x3708, 0x0B, 0x9A},
	{0x0000, 0x83, 0x97},
	{0x3713, 0x0B, 0x9B},
	{0x0000, 0x83, 0x97},
	{0x371E, 0x08, 0xA8},
	{0x0000, 0x83, 0xA7},
	{0x3726, 0x0B, 0xA9},
	{0x0000, 0x83, 0xA7},
	{0x3731, 0x0B, 0xAA},
	{0x0000, 0x83, 0xA7},
	{0x373C, 0x0B, 0xAB},
	{0x0000, 0x83, 0xA7},
	{0x3747, 0x08, 0xB8},
	{0x0000, 0x83, 0xB7},
	{0x374F, 0x0B, 0xB9},
	{0x0000, 0x83, 0xB7},
	{0x375A, 0x0B, 0xBA},
	{0x0000, 0x83, 0xB7},
	{0x3765, 0x0B, 0xBB},
	{0x0000, 0x83, 0xB7},
	{0x3770, 0x0E, 0x88},
	{0x006D, 0x05, 0x87},
	{0x0086, 0x05, 0x88},
	{0x0051, 0x86, 0x25},
	{0x377E, 0x0D, 0x98},
	{0x006D, 0x05, 0x97},
	{0x0086, 0x05, 0x98},
	{0x0051, 0x86, 0x25},
	{0x378B, 0x0D, 0xA8},
	{0x006D, 0x05, 0xA7},
	{0x0086, 0x05, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x3798, 0x0D, 0xB8},
	{0x006D, 0x05, 0xB7},
	{0x0086, 0x05, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x37A5, 0x0D, 0xD8},
	{0x006D, 0x05, 0xD7},
	{0x0086, 0x05, 0xD8},
	{0x0051, 0x86, 0x25},
	{0x37B2, 0x0D, 0xE8},
	{0x006D, 0x05, 0xE7},
	{0x0086, 0x05, 0xE8},
	{0x0051, 0x86, 0x25},
	{0x37BF, 0x0C, 0xC8},
	{0x006D, 0x05, 0xC7},
	{0x0086, 0x05, 0xC8},
	{0x0051, 0x86, 0x25},
	{0x37CB, 0x0D, 0x18},
	{0x006D, 0x05, 0x17},
	{0x0086, 0x05, 0x18},
	{0x0051, 0x86, 0x25},
	{0x37D8, 0x0D, 0x28},
	{0x006D, 0x05, 0x27},
	{0x0086, 0x05, 0x28},
	{0x0051, 0x86, 0x25},
	{0x37E5, 0x0D, 0x38},
	{0x006D, 0x05, 0x37},
	{0x0086, 0x05, 0x38},
	{0x0051, 0x86, 0x25},
	{0x37F2, 0x0C, 0x08},
	{0x006D, 0x05, 0x07},
	{0x0086, 0x05, 0x08},
	{0x0051, 0x86, 0x25},
	{0x37FE, 0x0D, 0x58},
	{0x006D, 0x05, 0x57},
	{0x0086, 0x05, 0x58},
	{0x0051, 0x86, 0x25},
	{0x380B, 0x0D, 0x68},
	{0x006D, 0x05, 0x67},
	{0x0086, 0x05, 0x68},
	{0x0051, 0x86, 0x25},
	{0x3818, 0x0D, 0x78},
	{0x006D, 0x05, 0x77},
	{0x0086, 0x05, 0x78},
	{0x0051, 0x86, 0x25},
	{0x3825, 0x0C, 0x48},
	{0x006D, 0x05, 0x47},
	{0x0086, 0x05, 0x48},
	{0x0051, 0x86, 0x25},
	{0x3831, 0x08, 0xD8},
	{0x0000, 0x83, 0xD7},
	{0x3839, 0x0B, 0xD9},
	{0x0000, 0x83, 0xD7},
	{0x3844, 0x0B, 0xDA},
	{0x0000, 0x83, 0xD7},
	{0x384F, 0x0B, 0xDB},
	{0x0000, 0x83, 0xD7},
	{0x385A, 0x08, 0xE8},
	{0x0000, 0x83, 0xE7},
	{0x3862, 0x0B, 0xE9},
	{0x0000, 0x83, 0xE7},
	{0x386D, 0x0B, 0xEA},
	{0x0000, 0x83, 0xE7},
	{0x3878, 0x0B, 0xEB},
	{0x0000, 0x83, 0xE7},
	{0x3883, 0x07, 0xC8},
	{0x0000, 0x83, 0xC7},
	{0x388A, 0x0A, 0xC9},
	{0x0000, 0x83, 0xC7},
	{0x3894, 0x0A, 0xCA},
	{0x0000, 0x83, 0xC7},
	{0x389E, 0x0A, 0xCB},
	{0x0000, 0x83, 0xC7},
	{0x38A8, 0x08, 0x18},
	{0x0000, 0x83, 0x17},
	{0x38B0, 0x0B, 0x19},
	{0x0000, 0x83, 0x17},
	{0x38BB, 0x0B, 0x1A},
	{0x0000, 0x83, 0x17},
	{0x38C6, 0x0B, 0x1B},
	{0x0000, 0x83, 0x17},
	{0x38D1, 0x08, 0x28},
	{0x0000, 0x83, 0x27},
	{0x38D9, 0x0B, 0x29},
	{0x0000, 0x83, 0x27},
	{0x38E4, 0x0B, 0x2A},
	{0x0000, 0x83, 0x67},
	{0x38EF, 0x0B, 0x2B},
	{0x0000, 0x83, 0x27},
	{0x38FA, 0x08, 0x38},
	{0x0000, 0x83, 0x37},
	{0x3902, 0x0B, 0x39},
	{0x0000, 0x83, 0x37},
	{0x390D, 0x0B, 0x3A},
	{0x0000, 0x83, 0x37},
	{0x3918, 0x0B, 0x3B},
	{0x0000, 0x83, 0x37},
	{0x3923, 0x07, 0x08},
	{0x0000, 0x83, 0x07},
	{0x392A, 0x0A, 0x09},
	{0x0000, 0x83, 0x07},
	{0x3934, 0x0A, 0x0A},
	{0x0000, 0x83, 0x47},
	{0x393E, 0x0A, 0x0B},
	{0x0000, 0x83, 0x07},
	{0x3948, 0x08, 0x58},
	{0x0000, 0x83, 0x57},
	{0x3950, 0x0B, 0x59},
	{0x0000, 0x83, 0x57},
	{0x395B, 0x0B, 0x5A},
	{0x0000, 0x83, 0x57},
	{0x3966, 0x0B, 0x5B},
	{0x0000, 0x83, 0x57},
	{0x3971, 0x08, 0x68},
	{0x0000, 0x83, 0x67},
	{0x3979, 0x0B, 0x69},
	{0x0000, 0x83, 0x67},
	{0x3984, 0x0B, 0x6A},
	{0x0000, 0x83, 0x67},
	{0x398F, 0x0B, 0x6B},
	{0x0000, 0x83, 0x67},
	{0x399A, 0x08, 0x78},
	{0x0000, 0x83, 0x77},
	{0x39A2, 0x0B, 0x79},
	{0x0000, 0x83, 0x77},
	{0x39AD, 0x0B, 0x7A},
	{0x0000, 0x83, 0x77},
	{0x39B8, 0x0B, 0x7B},
	{0x0000, 0x83, 0x77},
	{0x39C3, 0x07, 0x48},
	{0x0000, 0x83, 0x47},
	{0x39CA, 0x0A, 0x49},
	{0x0000, 0x83, 0x47},
	{0x39D4, 0x0A, 0x4A},
	{0x0000, 0x83, 0x47},
	{0x39DE, 0x0A, 0x4B},
	{0x0000, 0x83, 0x47},
	{0x39E8, 0x0A, 0x8C},
	{0x0000, 0x83, 0x87},
	{0x39F2, 0x0D, 0x8D},
	{0x0000, 0x83, 0x87},
	{0x39FF, 0x0D, 0x8E},
	{0x0000, 0x83, 0x87},
	{0x3A0C, 0x0D, 0x8F},
	{0x0000, 0x83, 0x87},
	{0x3A19, 0x0E, 0x8C},
	{0x0000, 0x83, 0x87},
	{0x3A27, 0x0D, 0x9C},
	{0x0000, 0x83, 0x97},
	{0x3A34, 0x0D, 0xAC},
	{0x0000, 0x83, 0xA7},
	{0x3A41, 0x0D, 0xBC},
	{0x0000, 0x83, 0xB7},
	{0x3A4E, 0x0D, 0xDC},
	{0x0000, 0x83, 0xD7},
	{0x3A5B, 0x0D, 0xEC},
	{0x0000, 0x83, 0xE7},
	{0x3A68, 0x0C, 0xCC},
	{0x0000, 0x83, 0xC7},
	{0x3A74, 0x0D, 0x1C},
	{0x0000, 0x83, 0x17},
	{0x3A81, 0x0D, 0x2C},
	{0x0000, 0x83, 0x27},
	{0x3A8E, 0x0D, 0x3C},
	{0x0000, 0x83, 0x37},
	{0x3A9B, 0x0D, 0x5C},
	{0x0000, 0x83, 0x57},
	{0x3AA8, 0x0D, 0x6C},
	{0x0000, 0x83, 0x67},
	{0x3AB5, 0x0D, 0x7C},
	{0x0000, 0x83, 0x77},
	{0x3AC2, 0x0C, 0x4C},
	{0x0000, 0x83, 0x47},
	{0x3ACE, 0x09, 0x9C},
	{0x0000, 0x83, 0x97},
	{0x3AD7, 0x0C, 0x9D},
	{0x0000, 0x83, 0x97},
	{0x3AE3, 0x0C, 0x9E},
	{0x0000, 0x83, 0x97},
	{0x3AEF, 0x0C, 0x9F},
	{0x0000, 0x83, 0x97},
	{0x3AFB, 0x09, 0xAC},
	{0x0000, 0x83, 0xA7},
	{0x3B04, 0x0C, 0xAD},
	{0x0000, 0x83, 0xA7},
	{0x3B10, 0x0C, 0xAE},
	{0x0000, 0x83, 0xA7},
	{0x3B1C, 0x0C, 0xAF},
	{0x0000, 0x83, 0xA7},
	{0x3B28, 0x09, 0xBC},
	{0x0000, 0x83, 0xB7},
	{0x3B31, 0x0C, 0xBD},
	{0x0000, 0x83, 0xB7},
	{0x3B3D, 0x0C, 0xBE},
	{0x0000, 0x83, 0xB7},
	{0x3B49, 0x0C, 0xBF},
	{0x0000, 0x83, 0xB7},
	{0x3B55, 0x0F, 0x8C},
	{0x006D, 0x05, 0x87},
	{0x0086, 0x05, 0x8C},
	{0x0051, 0x86, 0x25},
	{0x3B64, 0x0E, 0x9C},
	{0x006D, 0x05, 0x97},
	{0x0086, 0x05, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x3B72, 0x0E, 0xAC},
	{0x006D, 0x05, 0xA7},
	{0x0086, 0x05, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x3B80, 0x0E, 0xBC},
	{0x006D, 0x05, 0xB7},
	{0x0086, 0x05, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x3B8E, 0x0E, 0xDC},
	{0x006D, 0x05, 0xD7},
	{0x0086, 0x05, 0xDC},
	{0x0051, 0x86, 0x25},
	{0x3B9C, 0x0E, 0xEC},
	{0x006D, 0x05, 0xE7},
	{0x0086, 0x05, 0xEC},
	{0x0051, 0x86, 0x25},
	{0x3BAA, 0x0D, 0xCC},
	{0x006D, 0x05, 0xC7},
	{0x0086, 0x05, 0xCC},
	{0x0051, 0x86, 0x25},
	{0x3BB7, 0x0E, 0x1C},
	{0x006D, 0x05, 0x17},
	{0x0086, 0x05, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x3BC5, 0x0E, 0x2C},
	{0x006D, 0x05, 0x27},
	{0x0086, 0x05, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x3BD3, 0x0E, 0x3C},
	{0x006D, 0x05, 0x37},
	{0x0086, 0x05, 0x3C},
	{0x0051, 0x86, 0x25},
	{0x3BE1, 0x0D, 0x0C},
	{0x006D, 0x05, 0x07},
	{0x0086, 0x05, 0x0C},
	{0x0051, 0x86, 0x25},
	{0x3BEE, 0x0E, 0x5C},
	{0x006D, 0x05, 0x57},
	{0x0086, 0x05, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x3BFC, 0x0E, 0x6C},
	{0x006D, 0x05, 0x67},
	{0x0086, 0x05, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x3C0A, 0x0E, 0x7C},
	{0x006D, 0x05, 0x77},
	{0x0086, 0x05, 0x7C},
	{0x0051, 0x86, 0x25},
	{0x3C18, 0x0D, 0x4C},
	{0x006D, 0x05, 0x47},
	{0x0086, 0x05, 0x4C},
	{0x0051, 0x86, 0x25},
	{0x3C25, 0x09, 0xDC},
	{0x0000, 0x83, 0xD7},
	{0x3C2E, 0x0C, 0xDD},
	{0x0000, 0x83, 0xD7},
	{0x3C3A, 0x0C, 0xDE},
	{0x0000, 0x83, 0xD7},
	{0x3C46, 0x0C, 0xDF},
	{0x0000, 0x83, 0xD7},
	{0x3C52, 0x09, 0xEC},
	{0x0000, 0x83, 0xE7},
	{0x3C5B, 0x0C, 0xED},
	{0x0000, 0x83, 0xE7},
	{0x3C67, 0x0C, 0xEE},
	{0x0000, 0x83, 0xE7},
	{0x3C73, 0x0C, 0xEF},
	{0x0000, 0x83, 0xE7},
	{0x3C7F, 0x08, 0xCC},
	{0x0000, 0x83, 0xC7},
	{0x3C87, 0x0B, 0xCD},
	{0x0000, 0x83, 0xC7},
	{0x3C92, 0x0B, 0xCE},
	{0x0000, 0x83, 0xC7},
	{0x3C9D, 0x0B, 0xCF},
	{0x0000, 0x83, 0xC7},
	{0x3CA8, 0x09, 0x1C},
	{0x0000, 0x83, 0x17},
	{0x3CB1, 0x0C, 0x1D},
	{0x0000, 0x83, 0x17},
	{0x3CBD, 0x0C, 0x1E},
	{0x0000, 0x83, 0x17},
	{0x3CC9, 0x0C, 0x1F},
	{0x0000, 0x83, 0x17},
	{0x3CD5, 0x09, 0x2C},
	{0x0000, 0x83, 0x27},
	{0x3CDE, 0x0C, 0x2D},
	{0x0000, 0x83, 0x27},
	{0x3CEA, 0x0C, 0x2E},
	{0x0000, 0x83, 0x27},
	{0x3CF6, 0x0C, 0x2F},
	{0x0000, 0x83, 0x27},
	{0x3D02, 0x09, 0x3C},
	{0x0000, 0x83, 0x37},
	{0x3D0B, 0x0C, 0x3D},
	{0x0000, 0x83, 0x37},
	{0x3D17, 0x0C, 0x3E},
	{0x0000, 0x83, 0x37},
	{0x3D23, 0x0C, 0x3F},
	{0x0000, 0x83, 0x37},
	{0x3D2F, 0x08, 0x0C},
	{0x0000, 0x83, 0x07},
	{0x3D37, 0x0B, 0x0D},
	{0x0000, 0x83, 0x07},
	{0x3D42, 0x0B, 0x0E},
	{0x0000, 0x83, 0x07},
	{0x3D4D, 0x0B, 0x0F},
	{0x0000, 0x83, 0x07},
	{0x3D58, 0x09, 0x5C},
	{0x0000, 0x83, 0x57},
	{0x3D61, 0x0C, 0x5D},
	{0x0000, 0x83, 0x57},
	{0x3D6D, 0x0C, 0x5E},
	{0x0000, 0x83, 0x57},
	{0x3D79, 0x0C, 0x5F},
	{0x0000, 0x83, 0x57},
	{0x3D85, 0x09, 0x6C},
	{0x0000, 0x83, 0x67},
	{0x3D8E, 0x0C, 0x6D},
	{0x0000, 0x83, 0x67},
	{0x3D9A, 0x0C, 0x6E},
	{0x0000, 0x83, 0x67},
	{0x3DA6, 0x0C, 0x6F},
	{0x0000, 0x83, 0x67},
	{0x3DB2, 0x09, 0x7C},
	{0x0000, 0x83, 0x77},
	{0x3DBB, 0x0C, 0x7D},
	{0x0000, 0x83, 0x77},
	{0x3DC7, 0x0C, 0x7E},
	{0x0000, 0x83, 0x77},
	{0x3DD3, 0x0C, 0x7F},
	{0x0000, 0x83, 0x77},
	{0x3DDF, 0x08, 0x4C},
	{0x0000, 0x83, 0x47},
	{0x3DE7, 0x0B, 0x4D},
	{0x0000, 0x83, 0x47},
	{0x3DF2, 0x0B, 0x4E},
	{0x0000, 0x83, 0x47},
	{0x3DFD, 0x0B, 0x4F},
	{0x0000, 0x83, 0x47},
	{0x3E08, 0x09, 0x89},
	{0x0000, 0x83, 0x87},
	{0x3E11, 0x0D, 0x89},
	{0x0000, 0x83, 0x87},
	{0x3E1E, 0x0C, 0x99},
	{0x0000, 0x83, 0x97},
	{0x3E2A, 0x0C, 0xA9},
	{0x0000, 0x83, 0xA7},
	{0x3E36, 0x0C, 0xB9},
	{0x0000, 0x83, 0xB7},
	{0x3E42, 0x0C, 0xD9},
	{0x0000, 0x83, 0xD7},
	{0x3E4E, 0x0C, 0xE9},
	{0x0000, 0x83, 0xE7},
	{0x3E5A, 0x0B, 0xC9},
	{0x0000, 0x83, 0xC7},
	{0x3E65, 0x0C, 0x19},
	{0x0000, 0x83, 0x17},
	{0x3E71, 0x0C, 0x29},
	{0x0000, 0x83, 0x27},
	{0x3E7D, 0x0C, 0x39},
	{0x0000, 0x83, 0x37},
	{0x3E89, 0x0B, 0x09},
	{0x0000, 0x83, 0x07},
	{0x3E94, 0x0C, 0x59},
	{0x0000, 0x83, 0x57},
	{0x3EA0, 0x0C, 0x69},
	{0x0000, 0x83, 0x67},
	{0x3EAC, 0x0C, 0x79},
	{0x0000, 0x83, 0x77},
	{0x3EB8, 0x0B, 0x49},
	{0x0000, 0x83, 0x47},
	{0x3EC3, 0x08, 0x99},
	{0x0000, 0x83, 0x97},
	{0x3ECB, 0x08, 0xA9},
	{0x0000, 0x83, 0xA7},
	{0x3ED3, 0x08, 0xB9},
	{0x0000, 0x83, 0xB7},
	{0x3EDB, 0x08, 0xD9},
	{0x0000, 0x83, 0xD7},
	{0x3EE3, 0x08, 0xE9},
	{0x0000, 0x83, 0xE7},
	{0x3EEB, 0x07, 0xC9},
	{0x0000, 0x83, 0xC7},
	{0x3EF2, 0x08, 0x19},
	{0x0000, 0x83, 0x17},
	{0x3EFA, 0x08, 0x29},
	{0x0000, 0x83, 0x27},
	{0x3F02, 0x08, 0x39},
	{0x0000, 0x83, 0x37},
	{0x3F0A, 0x07, 0x09},
	{0x0000, 0x83, 0x07},
	{0x3F11, 0x08, 0x59},
	{0x0000, 0x83, 0x57},
	{0x3F19, 0x08, 0x69},
	{0x0000, 0x83, 0x67},
	{0x3F21, 0x08, 0x79},
	{0x0000, 0x83, 0x77},
	{0x3F29, 0x07, 0x49},
	{0x0000, 0x83, 0x47},
	{0x3F30, 0x0A, 0x8D},
	{0x0000, 0x83, 0x87},
	{0x3F3A, 0x0E, 0x8D},
	{0x0000, 0x83, 0x87},
	{0x3F48, 0x0D, 0x9D},
	{0x0000, 0x83, 0x97},
	{0x3F55, 0x0D, 0xAD},
	{0x0000, 0x83, 0xA7},
	{0x3F62, 0x0D, 0xBD},
	{0x0000, 0x83, 0xB7},
	{0x3F6F, 0x0D, 0xDD},
	{0x0000, 0x83, 0xD7},
	{0x3F7C, 0x0D, 0xED},
	{0x0000, 0x83, 0xE7},
	{0x3F89, 0x0C, 0xCD},
	{0x0000, 0x83, 0xC7},
	{0x3F95, 0x0D, 0x1D},
	{0x0000, 0x83, 0x17},
	{0x3FA2, 0x0D, 0x2D},
	{0x0000, 0x83, 0x27},
	{0x3FAF, 0x0D, 0x3D},
	{0x0000, 0x83, 0x37},
	{0x3FBC, 0x0C, 0x0D},
	{0x0000, 0x83, 0x07},
	{0x3FC8, 0x0D, 0x5D},
	{0x0000, 0x83, 0x57},
	{0x3FD5, 0x0D, 0x6D},
	{0x0000, 0x83, 0x67},
	{0x3FE2, 0x0D, 0x7D},
	{0x0000, 0x83, 0x77},
	{0x3FEF, 0x0C, 0x4D},
	{0x0000, 0x83, 0x47},
	{0x3FFB, 0x09, 0x9D},
	{0x0000, 0x83, 0x97},
	{0x4004, 0x09, 0xAD},
	{0x0000, 0x83, 0xA7},
	{0x400D, 0x09, 0xBD},
	{0x0000, 0x83, 0xB7},
	{0x4016, 0x09, 0xDD},
	{0x0000, 0x83, 0xD7},
	{0x401F, 0x09, 0xED},
	{0x0000, 0x83, 0xE7},
	{0x4028, 0x08, 0xCD},
	{0x0000, 0x83, 0xC7},
	{0x4030, 0x09, 0x1D},
	{0x0000, 0x83, 0x17},
	{0x4039, 0x09, 0x2D},
	{0x0000, 0x83, 0x27},
	{0x4042, 0x09, 0x3D},
	{0x0000, 0x83, 0x37},
	{0x404B, 0x08, 0x0D},
	{0x0000, 0x83, 0x07},
	{0x4053, 0x09, 0x5D},
	{0x0000, 0x83, 0x57},
	{0x405C, 0x09, 0x6D},
	{0x0000, 0x83, 0x67},
	{0x4065, 0x09, 0x7D},
	{0x0000, 0x83, 0x77},
	{0x406E, 0x08, 0x4D},
	{0x0000, 0x83, 0x47},
	{0x4076, 0x09, 0x8A},
	{0x0000, 0x83, 0x87},
	{0x407F, 0x0D, 0x8A},
	{0x0000, 0x83, 0x87},
	{0x408C, 0x0C, 0x9A},
	{0x0000, 0x83, 0x97},
	{0x4098, 0x0C, 0xAA},
	{0x0000, 0x83, 0xA7},
	{0x40A4, 0x0C, 0xBA},
	{0x0000, 0x83, 0xB7},
	{0x40B0, 0x0C, 0xDA},
	{0x0000, 0x83, 0xD7},
	{0x40BC, 0x0C, 0xEA},
	{0x0000, 0x83, 0xE7},
	{0x40C8, 0x0B, 0xCA},
	{0x0000, 0x83, 0xC7},
	{0x40D3, 0x0C, 0x1A},
	{0x0000, 0x83, 0x17},
	{0x40DF, 0x0C, 0x2A},
	{0x0000, 0x83, 0x27},
	{0x40EB, 0x0C, 0x3A},
	{0x0000, 0x83, 0x37},
	{0x40F7, 0x0B, 0x0A},
	{0x0000, 0x83, 0x07},
	{0x4102, 0x0C, 0x5A},
	{0x0000, 0x83, 0x57},
	{0x410E, 0x0C, 0x6A},
	{0x0000, 0x83, 0x67},
	{0x411A, 0x0C, 0x7A},
	{0x0000, 0x83, 0x77},
	{0x4126, 0x0B, 0x4A},
	{0x0000, 0x83, 0x47},
	{0x4131, 0x08, 0x9A},
	{0x0000, 0x83, 0x97},
	{0x4139, 0x08, 0xAA},
	{0x0000, 0x83, 0xA7},
	{0x4141, 0x08, 0xBA},
	{0x0000, 0x83, 0xB7},
	{0x4149, 0x08, 0xDA},
	{0x0000, 0x83, 0xD7},
	{0x4151, 0x08, 0xEA},
	{0x0000, 0x83, 0xE7},
	{0x4159, 0x07, 0xCA},
	{0x0000, 0x83, 0xC7},
	{0x4160, 0x08, 0x1A},
	{0x0000, 0x83, 0x17},
	{0x4168, 0x08, 0x2A},
	{0x0000, 0x83, 0x27},
	{0x4170, 0x08, 0x3A},
	{0x0000, 0x83, 0x37},
	{0x4178, 0x07, 0x0A},
	{0x0000, 0x83, 0x07},
	{0x417F, 0x08, 0x5A},
	{0x0000, 0x83, 0x57},
	{0x4187, 0x08, 0x6A},
	{0x0000, 0x83, 0x67},
	{0x418F, 0x08, 0x7A},
	{0x0000, 0x83, 0x77},
	{0x4197, 0x07, 0x4A},
	{0x0000, 0x83, 0x47},
	{0x419E, 0x0A, 0x8E},
	{0x0000, 0x83, 0x87},
	{0x41A8, 0x0E, 0x8E},
	{0x0000, 0x83, 0x87},
	{0x41B6, 0x0D, 0x9E},
	{0x0000, 0x83, 0x97},
	{0x41C3, 0x0D, 0xAE},
	{0x0000, 0x83, 0xA7},
	{0x41D0, 0x0D, 0xBE},
	{0x0000, 0x83, 0xB7},
	{0x41DD, 0x0D, 0xDE},
	{0x0000, 0x83, 0xD7},
	{0x41EA, 0x0D, 0xEE},
	{0x0000, 0x83, 0xE7},
	{0x41F7, 0x0C, 0xCE},
	{0x0000, 0x83, 0xC7},
	{0x4203, 0x0D, 0x1E},
	{0x0000, 0x83, 0x17},
	{0x4210, 0x0D, 0x2E},
	{0x0000, 0x83, 0x27},
	{0x421D, 0x0D, 0x3E},
	{0x0000, 0x83, 0x37},
	{0x422A, 0x0C, 0x0E},
	{0x0000, 0x83, 0x07},
	{0x4236, 0x0D, 0x5E},
	{0x0000, 0x83, 0x57},
	{0x4243, 0x0D, 0x6E},
	{0x0000, 0x83, 0x67},
	{0x4250, 0x0D, 0x7E},
	{0x0000, 0x83, 0x77},
	{0x425D, 0x0C, 0x4E},
	{0x0000, 0x83, 0x47},
	{0x4269, 0x09, 0x9E},
	{0x0000, 0x83, 0x97},
	{0x4272, 0x09, 0xAE},
	{0x0000, 0x83, 0xA7},
	{0x427B, 0x09, 0xBE},
	{0x0000, 0x83, 0xB7},
	{0x4284, 0x09, 0xDE},
	{0x0000, 0x83, 0xD7},
	{0x428D, 0x09, 0xEE},
	{0x0000, 0x83, 0xE7},
	{0x4296, 0x08, 0xCE},
	{0x0000, 0x83, 0xC7},
	{0x429E, 0x09, 0x1E},
	{0x0000, 0x83, 0x17},
	{0x42A7, 0x09, 0x2E},
	{0x0000, 0x83, 0x27},
	{0x42B0, 0x09, 0x3E},
	{0x0000, 0x83, 0x37},
	{0x42B9, 0x08, 0x0E},
	{0x0000, 0x83, 0x07},
	{0x42C1, 0x09, 0x5E},
	{0x0000, 0x83, 0x57},
	{0x42CA, 0x09, 0x6E},
	{0x0000, 0x83, 0x67},
	{0x42D3, 0x09, 0x7E},
	{0x0000, 0x83, 0x77},
	{0x42DC, 0x08, 0x4E},
	{0x0000, 0x83, 0x47},
	{0x42E4, 0x09, 0x8B},
	{0x0000, 0x83, 0x87},
	{0x42ED, 0x0D, 0x8B},
	{0x0000, 0x83, 0x87},
	{0x42FA, 0x0C, 0x9B},
	{0x0000, 0x83, 0x97},
	{0x4306, 0x0C, 0xAB},
	{0x0000, 0x83, 0xA7},
	{0x4312, 0x0C, 0xBB},
	{0x0000, 0x83, 0xB7},
	{0x431E, 0x0C, 0xDB},
	{0x0000, 0x83, 0xD7},
	{0x432A, 0x0C, 0xEB},
	{0x0000, 0x83, 0xE7},
	{0x4336, 0x0B, 0xCB},
	{0x0000, 0x83, 0xC7},
	{0x4341, 0x0C, 0x1B},
	{0x0000, 0x83, 0x17},
	{0x434D, 0x0C, 0x2B},
	{0x0000, 0x83, 0x27},
	{0x4359, 0x0C, 0x3B},
	{0x0000, 0x83, 0x37},
	{0x4365, 0x0B, 0x0B},
	{0x0000, 0x83, 0x07},
	{0x4370, 0x0C, 0x5B},
	{0x0000, 0x83, 0x57},
	{0x437C, 0x0C, 0x6B},
	{0x0000, 0x83, 0x67},
	{0x4388, 0x0C, 0x7B},
	{0x0000, 0x83, 0x77},
	{0x4394, 0x0B, 0x4B},
	{0x0000, 0x83, 0x47},
	{0x439F, 0x08, 0x9B},
	{0x0000, 0x83, 0x97},
	{0x43A7, 0x08, 0xAB},
	{0x0000, 0x83, 0xA7},
	{0x43AF, 0x08, 0xBB},
	{0x0000, 0x83, 0xB7},
	{0x43B7, 0x08, 0xDB},
	{0x0000, 0x83, 0xD7},
	{0x43BF, 0x08, 0xEB},
	{0x0000, 0x83, 0xE7},
	{0x43C7, 0x07, 0xCB},
	{0x0000, 0x83, 0xC7},
	{0x43CE, 0x08, 0x1B},
	{0x0000, 0x83, 0x17},
	{0x43D6, 0x08, 0x2B},
	{0x0000, 0x83, 0x27},
	{0x43DE, 0x08, 0x3B},
	{0x0000, 0x83, 0x37},
	{0x43E6, 0x07, 0x0B},
	{0x0000, 0x83, 0x07},
	{0x43ED, 0x08, 0x5B},
	{0x0000, 0x83, 0x57},
	{0x43F5, 0x08, 0x6B},
	{0x0000, 0x83, 0x67},
	{0x43FD, 0x08, 0x7B},
	{0x0000, 0x83, 0x77},
	{0x4405, 0x07, 0x4B},
	{0x0000, 0x83, 0x47},
	{0x440C, 0x0A, 0x8F},
	{0x0000, 0x83, 0x87},
	{0x4416, 0x0E, 0x8F},
	{0x0000, 0x83, 0x87},
	{0x4424, 0x0D, 0x9F},
	{0x0000, 0x83, 0x97},
	{0x4431, 0x0D, 0xAF},
	{0x0000, 0x83, 0xA7},
	{0x443E, 0x0D, 0xBF},
	{0x0000, 0x83, 0xB7},
	{0x444B, 0x0D, 0xDF},
	{0x0000, 0x83, 0xD7},
	{0x4458, 0x0D, 0xEF},
	{0x0000, 0x83, 0xE7},
	{0x4465, 0x0C, 0xCF},
	{0x0000, 0x83, 0xC7},
	{0x4471, 0x0D, 0x1F},
	{0x0000, 0x83, 0x17},
	{0x447E, 0x0D, 0x2F},
	{0x0000, 0x83, 0x27},
	{0x448B, 0x0D, 0x3F},
	{0x0000, 0x83, 0x37},
	{0x4498, 0x0C, 0x0F},
	{0x0000, 0x83, 0x07},
	{0x44A4, 0x0D, 0x5F},
	{0x0000, 0x83, 0x57},
	{0x44B1, 0x0D, 0x6F},
	{0x0000, 0x83, 0x67},
	{0x44BE, 0x0D, 0x7F},
	{0x0000, 0x83, 0x77},
	{0x44CB, 0x0C, 0x4F},
	{0x0000, 0x83, 0x47},
	{0x44D7, 0x09, 0x9F},
	{0x0000, 0x83, 0x97},
	{0x44E0, 0x09, 0xAF},
	{0x0000, 0x83, 0xA7},
	{0x44E9, 0x09, 0xBF},
	{0x0000, 0x83, 0xB7},
	{0x44F2, 0x09, 0xDF},
	{0x0000, 0x83, 0xD7},
	{0x44FB, 0x09, 0xEF},
	{0x0000, 0x83, 0xE7},
	{0x4504, 0x08, 0xCF},
	{0x0000, 0x83, 0xC7},
	{0x450C, 0x09, 0x1F},
	{0x0000, 0x83, 0x17},
	{0x4515, 0x09, 0x2F},
	{0x0000, 0x83, 0x27},
	{0x451E, 0x09, 0x3F},
	{0x0000, 0x83, 0x37},
	{0x4527, 0x08, 0x0F},
	{0x0000, 0x83, 0x07},
	{0x452F, 0x09, 0x5F},
	{0x0000, 0x83, 0x57},
	{0x4538, 0x09, 0x6F},
	{0x0000, 0x83, 0x67},
	{0x4541, 0x09, 0x7F},
	{0x0000, 0x83, 0x77},
	{0x454A, 0x08, 0x4F},
	{0x0000, 0x83, 0x47},
	{0x4552, 0x0A, 0xF4},
	{0x0065, 0x85, 0xF7},
	{0x455C, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x4564, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x456C, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x4574, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x457C, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x4584, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x458B, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x4593, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x459B, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x45A2, 0x0A, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x45AC, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x45B6, 0x0A, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x45C0, 0x0B, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x45CB, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x45D6, 0x0B, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x45E1, 0x0B, 0x94},
	{0x0000, 0x83, 0x98},
	{0x45EC, 0x0B, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x45F7, 0x0C, 0x94},
	{0x0000, 0x83, 0x9C},
	{0x4603, 0x0C, 0xA4},
	{0x0000, 0x83, 0xAC},
	{0x460F, 0x0C, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x461B, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x4624, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x462D, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x4636, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x463F, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x4648, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x4650, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x4659, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x4662, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x466A, 0x09, 0x94},
	{0x0000, 0x83, 0x98},
	{0x4673, 0x09, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x467C, 0x09, 0x14},
	{0x0000, 0x83, 0x18},
	{0x4685, 0x09, 0x24},
	{0x0000, 0x83, 0x28},
	{0x468E, 0x08, 0x04},
	{0x0000, 0x83, 0x08},
	{0x4696, 0x09, 0x54},
	{0x0000, 0x83, 0x58},
	{0x469F, 0x09, 0x64},
	{0x0000, 0x83, 0x68},
	{0x46A8, 0x08, 0x44},
	{0x0000, 0x83, 0x48},
	{0x46B0, 0x0A, 0x94},
	{0x0000, 0x83, 0x9C},
	{0x46BA, 0x0A, 0xA4},
	{0x0000, 0x83, 0xAC},
	{0x46C4, 0x0A, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x46CE, 0x0A, 0x14},
	{0x0000, 0x83, 0x1C},
	{0x46D8, 0x0A, 0x24},
	{0x0000, 0x83, 0x2C},
	{0x46E2, 0x09, 0x04},
	{0x0000, 0x83, 0x0C},
	{0x46EB, 0x0A, 0x54},
	{0x0000, 0x83, 0x5C},
	{0x46F5, 0x0A, 0x64},
	{0x0000, 0x83, 0x6C},
	{0x46FF, 0x09, 0x44},
	{0x0000, 0x83, 0x4C},
	{0x4708, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x4710, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x4718, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x4720, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x4728, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x4730, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x4737, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x473F, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x4747, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x474E, 0x0A, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x4758, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x4762, 0x0A, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x476C, 0x0B, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x4777, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x4782, 0x0B, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x478D, 0x0B, 0x94},
	{0x0000, 0x83, 0x98},
	{0x4798, 0x0B, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x47A3, 0x0C, 0x94},
	{0x0000, 0x83, 0x9C},
	{0x47AF, 0x0C, 0xA4},
	{0x0000, 0x83, 0xAC},
	{0x47BB, 0x0C, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x47C7, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x47D0, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x47D9, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x47E2, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x47EB, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x47F4, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x47FC, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x4805, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x480E, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x4816, 0x09, 0x94},
	{0x0000, 0x83, 0x98},
	{0x481F, 0x09, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x4828, 0x09, 0x14},
	{0x0000, 0x83, 0x18},
	{0x4831, 0x09, 0x24},
	{0x0000, 0x83, 0x28},
	{0x483A, 0x08, 0x04},
	{0x0000, 0x83, 0x08},
	{0x4842, 0x09, 0x54},
	{0x0000, 0x83, 0x58},
	{0x484B, 0x09, 0x64},
	{0x0000, 0x83, 0x68},
	{0x4854, 0x08, 0x44},
	{0x0000, 0x83, 0x48},
	{0x485C, 0x0A, 0x94},
	{0x0000, 0x83, 0x9C},
	{0x4866, 0x0A, 0xA4},
	{0x0000, 0x83, 0xAC},
	{0x4870, 0x0A, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x487A, 0x0A, 0x14},
	{0x0000, 0x83, 0x1C},
	{0x4884, 0x0A, 0x24},
	{0x0000, 0x83, 0x2C},
	{0x488E, 0x09, 0x04},
	{0x0000, 0x83, 0x0C},
	{0x4897, 0x0A, 0x54},
	{0x0000, 0x83, 0x5C},
	{0x48A1, 0x0A, 0x64},
	{0x0000, 0x83, 0x6C},
	{0x48AB, 0x09, 0x44},
	{0x0000, 0x83, 0x4C},
	{0x48B4, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA8},
	{0x48BC, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0xB8},
	{0x48C4, 0x0D, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x48D1, 0x0D, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x48DE, 0x0D, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x48EB, 0x0D, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x48F8, 0x0D, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x4905, 0x0E, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x4913, 0x0E, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x4921, 0x0E, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x492F, 0x0E, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x493D, 0x0E, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x494B, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA4},
	{0x4955, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x14},
	{0x495F, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x24},
	{0x4969, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x54},
	{0x4973, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x64},
	{0x497D, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x4985, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x498D, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x08},
	{0x4994, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x58},
	{0x499C, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x68},
	{0x49A4, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x48},
	{0x49AB, 0x13, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x007E, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x49BE, 0x13, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x007E, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x49D1, 0x13, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x007E, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x49E4, 0x13, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x007E, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x49F7, 0x14, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x007E, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x4A0B, 0x14, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x007E, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x4A1F, 0x14, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x007E, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x4A33, 0x14, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x007E, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x4A47, 0x10, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x14},
	{0x4A57, 0x10, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x24},
	{0x4A67, 0x10, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x54},
	{0x4A77, 0x10, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x64},
	{0x4A87, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x4A95, 0x0E, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x4AA3, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x4AB0, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x4ABE, 0x0E, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x4ACC, 0x0D, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x4AD9, 0x0E, 0x2C},
	{0x0003, 0x05, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x4AE7, 0x0E, 0x3C},
	{0x0003, 0x05, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x4AF5, 0x0E, 0x6C},
	{0x0003, 0x05, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x25},
	{0x4B03, 0x0E, 0x7C},
	{0x0003, 0x05, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x25},
	{0x4B11, 0x0F, 0x2C},
	{0x0003, 0x05, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x4B20, 0x0F, 0x3C},
	{0x0003, 0x05, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x4B2F, 0x0F, 0x6C},
	{0x0003, 0x05, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0x4B3E, 0x0F, 0x7C},
	{0x0003, 0x05, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0x4B4D, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x14},
	{0x4B58, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x24},
	{0x4B63, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x54},
	{0x4B6E, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x64},
	{0x4B79, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x4B82, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x4B8B, 0x08, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x08},
	{0x4B93, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x58},
	{0x4B9C, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x68},
	{0x4BA5, 0x08, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x48},
	{0x4BAD, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xAC},
	{0x4BB6, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0xBC},
	{0x4BBF, 0x0E, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x4BCD, 0x0E, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x4BDB, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x4BE9, 0x0E, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x4BF7, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x4C05, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x4C14, 0x0F, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x4C23, 0x0F, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x4C32, 0x0F, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x4C41, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x4C50, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xA4},
	{0x4C5B, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x14},
	{0x4C66, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x24},
	{0x4C71, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x54},
	{0x4C7C, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x64},
	{0x4C87, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x4C90, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x4C99, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x4CA1, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x4CAA, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x4CB3, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x4CBB, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA8},
	{0x4CC3, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x000B, 0x83, 0xB8},
	{0x4CCB, 0x0D, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x4CD8, 0x0D, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x4CE5, 0x0D, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x4CF2, 0x0D, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x4CFF, 0x0D, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x4D0C, 0x0E, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x4D1A, 0x0E, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x4D28, 0x0E, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x4D36, 0x0E, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x4D44, 0x0E, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x4D52, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x000B, 0x83, 0xA4},
	{0x4D5C, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x14},
	{0x4D66, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x24},
	{0x4D70, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x54},
	{0x4D7A, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x64},
	{0x4D84, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x4D8C, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x4D94, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x08},
	{0x4D9B, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x58},
	{0x4DA3, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x68},
	{0x4DAB, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x48},
	{0x4DB2, 0x13, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x007E, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x4DC5, 0x13, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x007E, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x4DD8, 0x13, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x007E, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x4DEB, 0x13, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x007E, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x4DFE, 0x14, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x007E, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x4E12, 0x14, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x007E, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x4E26, 0x14, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x007E, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x4E3A, 0x14, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x007E, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x4E4E, 0x10, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x14},
	{0x4E5E, 0x10, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x24},
	{0x4E6E, 0x10, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x54},
	{0x4E7E, 0x10, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x64},
	{0x4E8E, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x4E9C, 0x0E, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x4EAA, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x4EB7, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x4EC5, 0x0E, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x4ED3, 0x0D, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x4EE0, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x007E, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x4EEE, 0x0E, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x007E, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x4EFC, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x58},
	{0x007E, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x4F0A, 0x0E, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x68},
	{0x007E, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x4F18, 0x0F, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x007E, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x4F27, 0x0F, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x007E, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x4F36, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x58},
	{0x007E, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x4F45, 0x0F, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x68},
	{0x007E, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x4F54, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x14},
	{0x4F5F, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x24},
	{0x4F6A, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x54},
	{0x4F75, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x64},
	{0x4F80, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x4F89, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x4F92, 0x08, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x08},
	{0x4F9A, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x58},
	{0x4FA3, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x68},
	{0x4FAC, 0x08, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x48},
	{0x4FB4, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xAC},
	{0x4FBD, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x000B, 0x83, 0xBC},
	{0x4FC6, 0x0E, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x4FD4, 0x0E, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x4FE2, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x4FF0, 0x0E, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x4FFE, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x500C, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x501B, 0x0F, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x502A, 0x0F, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x5039, 0x0F, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x5048, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x5057, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x000B, 0x83, 0xA4},
	{0x5062, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x14},
	{0x506D, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x24},
	{0x5078, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x54},
	{0x5083, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x64},
	{0x508E, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x5097, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x50A0, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x0C},
	{0x50A8, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x50B1, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x50BA, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x4C},
	{0x50C2, 0x0A, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x50CC, 0x0A, 0x6C},
	{0x006A, 0x03, 0x6C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x50D6, 0x0A, 0x98},
	{0x0000, 0x83, 0x94},
	{0x50E0, 0x0A, 0xA8},
	{0x0000, 0x83, 0xA4},
	{0x50EA, 0x0A, 0xB8},
	{0x0000, 0x83, 0xB4},
	{0x50F4, 0x0A, 0xD8},
	{0x0000, 0x83, 0xD4},
	{0x50FE, 0x0A, 0xE8},
	{0x0000, 0x83, 0xE4},
	{0x5108, 0x09, 0xC8},
	{0x0000, 0x83, 0xC4},
	{0x5111, 0x0A, 0x18},
	{0x0000, 0x83, 0x14},
	{0x511B, 0x0A, 0x28},
	{0x0000, 0x83, 0x24},
	{0x5125, 0x0A, 0x38},
	{0x0000, 0x83, 0x34},
	{0x512F, 0x09, 0x08},
	{0x0000, 0x83, 0x04},
	{0x5138, 0x0A, 0x58},
	{0x0000, 0x83, 0x54},
	{0x5142, 0x0A, 0x68},
	{0x0000, 0x83, 0x64},
	{0x514C, 0x0A, 0x78},
	{0x0000, 0x83, 0x74},
	{0x5156, 0x09, 0x48},
	{0x0000, 0x83, 0x44},
	{0x515F, 0x0E, 0x2C},
	{0x0000, 0x83, 0x1C},
	{0x516D, 0x0E, 0x3C},
	{0x0000, 0x83, 0x2C},
	{0x517B, 0x0D, 0x1C},
	{0x0000, 0x83, 0x0C},
	{0x5188, 0x0E, 0x6C},
	{0x0000, 0x83, 0x5C},
	{0x5196, 0x0E, 0x7C},
	{0x0000, 0x83, 0x6C},
	{0x51A4, 0x0D, 0x5C},
	{0x0000, 0x83, 0x4C},
	{0x51B1, 0x09, 0x2C},
	{0x0000, 0x83, 0x18},
	{0x51BA, 0x09, 0x3C},
	{0x0000, 0x83, 0x28},
	{0x51C3, 0x08, 0x1C},
	{0x0000, 0x83, 0x08},
	{0x51CB, 0x09, 0x6C},
	{0x0000, 0x83, 0x58},
	{0x51D4, 0x09, 0x7C},
	{0x0000, 0x83, 0x68},
	{0x51DD, 0x08, 0x5C},
	{0x0000, 0x83, 0x48},
	{0x51E5, 0x0E, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x1C},
	{0x51F3, 0x0E, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x2C},
	{0x5201, 0x0E, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x3C},
	{0x520F, 0x0E, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x5C},
	{0x521D, 0x0E, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x6C},
	{0x522B, 0x0E, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x7C},
	{0x5239, 0x09, 0x08},
	{0x0000, 0x83, 0x1C},
	{0x5242, 0x09, 0x18},
	{0x0000, 0x83, 0x2C},
	{0x524B, 0x09, 0x28},
	{0x0000, 0x83, 0x3C},
	{0x5254, 0x09, 0x48},
	{0x0000, 0x83, 0x5C},
	{0x525D, 0x09, 0x58},
	{0x0000, 0x83, 0x6C},
	{0x5266, 0x09, 0x68},
	{0x0000, 0x83, 0x7C},
	{0x526F, 0x0B, 0x9C},
	{0x0000, 0x83, 0x94},
	{0x527A, 0x0B, 0xAC},
	{0x0000, 0x83, 0xA4},
	{0x5285, 0x0B, 0xBC},
	{0x0000, 0x83, 0xB4},
	{0x5290, 0x0B, 0xDC},
	{0x0000, 0x83, 0xD4},
	{0x529B, 0x0B, 0xEC},
	{0x0000, 0x83, 0xE4},
	{0x52A6, 0x0A, 0xCC},
	{0x0000, 0x83, 0xC4},
	{0x52B0, 0x0B, 0x1C},
	{0x0000, 0x83, 0x14},
	{0x52BB, 0x0B, 0x2C},
	{0x0000, 0x83, 0x24},
	{0x52C6, 0x0B, 0x3C},
	{0x0000, 0x83, 0x34},
	{0x52D1, 0x0A, 0x0C},
	{0x0000, 0x83, 0x04},
	{0x52DB, 0x0B, 0x5C},
	{0x0000, 0x83, 0x54},
	{0x52E6, 0x0B, 0x6C},
	{0x0000, 0x83, 0x64},
	{0x52F1, 0x0B, 0x7C},
	{0x0000, 0x83, 0x74},
	{0x52FC, 0x0A, 0x4C},
	{0x0000, 0x83, 0x44},
	{0x5306, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x530E, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x5316, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x531E, 0x0D, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x532B, 0x0D, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x5338, 0x0D, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x5345, 0x0D, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x5352, 0x0D, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x535F, 0x0D, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x536C, 0x0D, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x5379, 0x0E, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x5387, 0x0E, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x5395, 0x0E, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x53A3, 0x0E, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x53B1, 0x0E, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x53BF, 0x0E, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x53CD, 0x0E, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x53DB, 0x0A, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x94},
	{0x53E5, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA4},
	{0x53EF, 0x0A, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB4},
	{0x53F9, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x14},
	{0x5403, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x24},
	{0x540D, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x54},
	{0x5417, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x64},
	{0x5421, 0x07, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0x5428, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x5430, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x5438, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x543F, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x5447, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x544F, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x5456, 0x0E, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x5464, 0x0F, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x5473, 0x0E, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x5481, 0x0F, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x5490, 0x13, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x007E, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x54A3, 0x13, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x007E, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x54B6, 0x13, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x007E, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x54C9, 0x13, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x007E, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x54DC, 0x14, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x007E, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x54F0, 0x14, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x007E, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x5504, 0x14, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x007E, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x5518, 0x14, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x007E, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x552C, 0x10, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x14},
	{0x553C, 0x10, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x24},
	{0x554C, 0x10, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x54},
	{0x555C, 0x10, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x64},
	{0x556C, 0x0E, 0xF4},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0x557A, 0x0D, 0xDC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0x5587, 0x0E, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x5595, 0x0E, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x55A3, 0x0D, 0x1C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x55B0, 0x0E, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x55BE, 0x0E, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x55CC, 0x0D, 0x5C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x55D9, 0x0E, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x55E7, 0x0E, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x55F5, 0x0E, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x25},
	{0x5603, 0x0E, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x25},
	{0x5611, 0x0F, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x5620, 0x0F, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x562F, 0x0F, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0x563E, 0x0F, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0x564D, 0x0B, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x14},
	{0x5658, 0x0B, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x24},
	{0x5663, 0x0B, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x54},
	{0x566E, 0x0B, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x64},
	{0x5679, 0x09, 0xF4},
	{0x0000, 0x03, 0xE4},
	{0x0008, 0x83, 0xE4},
	{0x5682, 0x08, 0xDC},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0x568A, 0x09, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x5693, 0x09, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x569C, 0x08, 0x1C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x56A4, 0x09, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x56AD, 0x09, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x56B6, 0x08, 0x5C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x56BE, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x56C7, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x56D0, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x56D9, 0x0E, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x56E7, 0x0E, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x56F5, 0x0E, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x5703, 0x0E, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0x5711, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0x571F, 0x0E, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0x572D, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0x573B, 0x0F, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x574A, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x5759, 0x0F, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x5768, 0x0F, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0x5777, 0x0F, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0x5786, 0x0F, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0x5795, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0x57A4, 0x0B, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x94},
	{0x57AF, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xA4},
	{0x57BA, 0x0B, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xB4},
	{0x57C5, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x14},
	{0x57D0, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x24},
	{0x57DB, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x54},
	{0x57E6, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x64},
	{0x57F1, 0x08, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0x57F9, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x5802, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x580B, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x5813, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x581C, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x5825, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x582D, 0x0E, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x583B, 0x0F, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x584A, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x5853, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x585C, 0x09, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x5865, 0x0E, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x5873, 0x0E, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x007E, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x5881, 0x0E, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x007E, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x588F, 0x0F, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x589E, 0x0F, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x007E, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x58AD, 0x0F, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x007E, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x58BC, 0x0B, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x94},
	{0x58C7, 0x0A, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x58D1, 0x0F, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x007E, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x58E0, 0x10, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x007E, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x58F0, 0x0F, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x58FF, 0x10, 0x94},
	{0x0000, 0x03, 0x94},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x590F, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x5919, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x5923, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x592D, 0x0F, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0x593C, 0x0F, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x007E, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x594B, 0x0F, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x007E, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0x595A, 0x10, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0x596A, 0x10, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x007E, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x597A, 0x10, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x007E, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0x598A, 0x0C, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x94},
	{0x5996, 0x0A, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x59A0, 0x0F, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x007E, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0x59AF, 0x10, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x007E, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0x59BF, 0x07, 0xC8},
	{0x0000, 0x83, 0xC8},
	{0x59C6, 0x08, 0x18},
	{0x0000, 0x83, 0x18},
	{0x59CE, 0x08, 0x28},
	{0x0000, 0x83, 0x28},
	{0x59D6, 0x07, 0x08},
	{0x0000, 0x83, 0x08},
	{0x59DD, 0x08, 0x58},
	{0x0000, 0x83, 0x58},
	{0x59E5, 0x08, 0x68},
	{0x0000, 0x83, 0x68},
	{0x59ED, 0x07, 0x48},
	{0x0000, 0x83, 0x48},
	{0x59F4, 0x08, 0xCC},
	{0x0000, 0x83, 0xCC},
	{0x59FC, 0x09, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x5A05, 0x09, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x5A0E, 0x08, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x5A16, 0x09, 0x5C},
	{0x0000, 0x83, 0x5C},
	{0x5A1F, 0x09, 0x6C},
	{0x0000, 0x83, 0x6C},
	{0x5A28, 0x08, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x5A30, 0x08, 0x98},
	{0x0000, 0x83, 0x98},
	{0x5A38, 0x08, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x5A40, 0x08, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x5A48, 0x08, 0x18},
	{0x0000, 0x83, 0x18},
	{0x5A50, 0x08, 0x28},
	{0x0000, 0x83, 0x28},
	{0x5A58, 0x08, 0x38},
	{0x0000, 0x83, 0x38},
	{0x5A60, 0x07, 0x08},
	{0x0000, 0x83, 0x08},
	{0x5A67, 0x09, 0x34},
	{0x0000, 0x83, 0x34},
	{0x5A70, 0x09, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x5A79, 0x09, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x5A82, 0x09, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x5A8B, 0x09, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x5A94, 0x09, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x5A9D, 0x09, 0x3C},
	{0x0000, 0x83, 0x3C},
	{0x5AA6, 0x08, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x5AAE, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x5AB6, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x5ABE, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x5AC6, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x5ACD, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x5AD5, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x5ADD, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x5AE5, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x5AEC, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x5AF5, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x5AFE, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x5B07, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x5B0F, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x5B18, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x5B21, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x5B2A, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x5B32, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x5B3A, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x5B42, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x5B4A, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x5B51, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x5B59, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x5B61, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x5B69, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x5B70, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x5B79, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x5B82, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x5B8B, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x5B93, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x5B9C, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x5BA5, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x5BAE, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x5BB6, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x18},
	{0x5BC0, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x28},
	{0x5BCA, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x08},
	{0x5BD3, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x58},
	{0x5BDD, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x68},
	{0x5BE7, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x48},
	{0x5BF0, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x1C},
	{0x5BFB, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x2C},
	{0x5C06, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x0C},
	{0x5C10, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x5C},
	{0x5C1B, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x6C},
	{0x5C26, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x4C},
	{0x5C30, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x5C39, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x5C42, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x5C4B, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x5C54, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x5C5C, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x5C65, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x5C6E, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x5C76, 0x0A, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x5C80, 0x0A, 0x34},
	{0x0000, 0x83, 0x3C},
	{0x5C8A, 0x0A, 0x74},
	{0x0000, 0x83, 0x7C},
	{0x5C94, 0x0A, 0x28},
	{0x0000, 0x83, 0x18},
	{0x5C9E, 0x0A, 0x38},
	{0x0000, 0x83, 0x28},
	{0x5CA8, 0x09, 0x18},
	{0x0000, 0x83, 0x08},
	{0x5CB1, 0x0A, 0x68},
	{0x0000, 0x83, 0x58},
	{0x5CBB, 0x0A, 0x78},
	{0x0000, 0x83, 0x68},
	{0x5CC5, 0x09, 0x58},
	{0x0000, 0x83, 0x48},
	{0x5CCE, 0x0B, 0x2C},
	{0x0000, 0x83, 0x1C},
	{0x5CD9, 0x0B, 0x3C},
	{0x0000, 0x83, 0x2C},
	{0x5CE4, 0x0A, 0x1C},
	{0x0000, 0x83, 0x0C},
	{0x5CEE, 0x0B, 0x6C},
	{0x0000, 0x83, 0x5C},
	{0x5CF9, 0x0B, 0x7C},
	{0x0000, 0x83, 0x6C},
	{0x5D04, 0x0A, 0x5C},
	{0x0000, 0x83, 0x4C},
	{0x5D0E, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x5D18, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x5D22, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x5D2C, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x5D36, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x5D40, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x5D4A, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x5D53, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x5D5D, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x5D67, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x5D71, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x5D7A, 0x0A, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x5D84, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x5D8D, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x5D96, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x5D9F, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x5DA8, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x5DB0, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x5DB9, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x5DC2, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x5DCA, 0x0B, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x5DD5, 0x0B, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x5DE0, 0x0C, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x5DEC, 0x0C, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x5DF8, 0x0C, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x5E04, 0x0D, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x5E11, 0x0C, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x5E1D, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x5E27, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x5E31, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x5E3B, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x5E45, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x5E4F, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x5E58, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x5E62, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x5E6C, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x5E75, 0x0B, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x5E80, 0x0A, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x5E8A, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x5E93, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x5E9C, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x5EA5, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x5EAE, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x5EB6, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x5EBF, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x5EC8, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x5ED0, 0x0B, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x5EDB, 0x0B, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x5EE6, 0x0C, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x5EF2, 0x0C, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x5EFE, 0x0C, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x5F0A, 0x0D, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x5F17, 0x0C, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x5F23, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x5F2D, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x5F37, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x5F41, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x5F4B, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x5F55, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x5F5E, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x5F68, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x5F72, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x5F7B, 0x0B, 0xB4},
	{0x0000, 0x83, 0xBC},
	{0x5F86, 0x0A, 0xA4},
	{0x0000, 0x83, 0xA8},
	{0x5F90, 0x09, 0x18},
	{0x0000, 0x83, 0x18},
	{0x5F99, 0x09, 0x28},
	{0x0000, 0x83, 0x28},
	{0x5FA2, 0x09, 0x38},
	{0x0000, 0x83, 0x38},
	{0x5FAB, 0x08, 0x08},
	{0x0000, 0x83, 0x08},
	{0x5FB3, 0x09, 0x04},
	{0x0000, 0x83, 0x04},
	{0x5FBC, 0x0A, 0x34},
	{0x0000, 0x83, 0x34},
	{0x5FC6, 0x0A, 0x14},
	{0x0000, 0x83, 0x14},
	{0x5FD0, 0x0A, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x5FDA, 0x0A, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x5FE4, 0x0A, 0x3C},
	{0x0000, 0x83, 0x3C},
	{0x5FEE, 0x09, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x5FF7, 0x0A, 0x24},
	{0x0000, 0x83, 0x24},
	{0x6001, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x600A, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x6013, 0x09, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x601C, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x6024, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x602D, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x6036, 0x09, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x603F, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x6047, 0x09, 0x04},
	{0x0000, 0x03, 0x04},
	{0x0008, 0x83, 0x04},
	{0x6050, 0x09, 0x44},
	{0x0000, 0x03, 0x44},
	{0x0008, 0x83, 0x44},
	{0x6059, 0x0A, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x6063, 0x0A, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x606D, 0x0A, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x14},
	{0x6077, 0x0A, 0x54},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x54},
	{0x6081, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x608B, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x6095, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x609F, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x60A8, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x60B2, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x60BC, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x60C6, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x60CF, 0x0A, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x24},
	{0x60D9, 0x0A, 0x64},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x64},
	{0x60E3, 0x15, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x60F8, 0x15, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x610D, 0x16, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x6123, 0x16, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6139, 0x12, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x14},
	{0x614B, 0x12, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x24},
	{0x615D, 0x10, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x616D, 0x10, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x617D, 0x10, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x618D, 0x10, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x619D, 0x11, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x61AE, 0x11, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x61BF, 0x0D, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x14},
	{0x61CC, 0x0D, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x24},
	{0x61D9, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x61E4, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x61EF, 0x11, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x6200, 0x12, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x6212, 0x0C, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x83, 0x14},
	{0x621E, 0x11, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x622F, 0x12, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6241, 0x0C, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x83, 0x24},
	{0x624D, 0x15, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x6262, 0x15, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x6277, 0x16, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x628D, 0x16, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x62A3, 0x12, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x14},
	{0x62B5, 0x12, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x24},
	{0x62C7, 0x10, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x62D7, 0x10, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x62E7, 0x10, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x62F7, 0x10, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x6307, 0x11, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x6318, 0x11, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6329, 0x0D, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x14},
	{0x6336, 0x0D, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x24},
	{0x6343, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x634E, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x6359, 0x11, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x636A, 0x12, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x637C, 0x0C, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x83, 0x14},
	{0x6388, 0x11, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x6399, 0x12, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x63AB, 0x0C, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x83, 0x24},
	{0x63B7, 0x10, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x63C7, 0x10, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x63D7, 0x11, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x63E8, 0x11, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x63F9, 0x0D, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x14},
	{0x6406, 0x0D, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x24},
	{0x6413, 0x0B, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x641E, 0x0B, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x6429, 0x11, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x643A, 0x12, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x644C, 0x0C, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x14},
	{0x6458, 0x11, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x6469, 0x11, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x647A, 0x12, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x648C, 0x12, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x649E, 0x0E, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x14},
	{0x64AC, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x24},
	{0x64BA, 0x0C, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x64C6, 0x0C, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x64D2, 0x11, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x64E3, 0x12, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x64F5, 0x0C, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x24},
	{0x6501, 0x15, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x6516, 0x15, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x652B, 0x16, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x6541, 0x16, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x6557, 0x12, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x14},
	{0x6569, 0x12, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x24},
	{0x657B, 0x10, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x658B, 0x10, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x659B, 0x10, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x65AB, 0x10, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x65BB, 0x11, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x65CC, 0x11, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x65DD, 0x0D, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x14},
	{0x65EA, 0x0D, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x24},
	{0x65F7, 0x0B, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x6602, 0x0B, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x660D, 0x11, 0x24},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x661E, 0x12, 0x24},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x6630, 0x0C, 0x24},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x14},
	{0x663C, 0x11, 0x34},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x664D, 0x12, 0x34},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x665F, 0x0C, 0x34},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x24},
	{0x666B, 0x0F, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x1C},
	{0x667A, 0x0F, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x2C},
	{0x6689, 0x0F, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x3C},
	{0x6698, 0x0F, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x5C},
	{0x66A7, 0x0F, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x6C},
	{0x66B6, 0x0F, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x7C},
	{0x66C5, 0x0A, 0x08},
	{0x0000, 0x83, 0x1C},
	{0x66CF, 0x0A, 0x18},
	{0x0000, 0x83, 0x2C},
	{0x66D9, 0x0A, 0x28},
	{0x0000, 0x83, 0x3C},
	{0x66E3, 0x0A, 0x48},
	{0x0000, 0x83, 0x5C},
	{0x66ED, 0x0A, 0x58},
	{0x0000, 0x83, 0x6C},
	{0x66F7, 0x0A, 0x68},
	{0x0000, 0x83, 0x7C},
	{0x6701, 0x0B, 0x24},
	{0x0000, 0x83, 0x34},
	{0x670C, 0x0B, 0x64},
	{0x0000, 0x83, 0x74},
	{0x6717, 0x0B, 0x04},
	{0x0000, 0x83, 0x14},
	{0x6722, 0x0B, 0x44},
	{0x0000, 0x83, 0x54},
	{0x672D, 0x0B, 0x14},
	{0x0000, 0x83, 0x24},
	{0x6738, 0x0B, 0x54},
	{0x0000, 0x83, 0x64},
	{0x6743, 0x10, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x1C},
	{0x6753, 0x10, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x2C},
	{0x6763, 0x10, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x3C},
	{0x6773, 0x0B, 0x48},
	{0x0000, 0x83, 0x1C},
	{0x677E, 0x0B, 0x58},
	{0x0000, 0x83, 0x2C},
	{0x6789, 0x0B, 0x68},
	{0x0000, 0x83, 0x3C},
	{0x6794, 0x0C, 0x64},
	{0x0000, 0x83, 0x34},
	{0x67A0, 0x0C, 0x44},
	{0x0000, 0x83, 0x14},
	{0x67AC, 0x0C, 0x54},
	{0x0000, 0x83, 0x24},
	{0x67B8, 0x09, 0x18},
	{0x0000, 0x83, 0x18},
	{0x67C1, 0x09, 0x28},
	{0x0000, 0x83, 0x28},
	{0x67CA, 0x09, 0x38},
	{0x0000, 0x83, 0x38},
	{0x67D3, 0x08, 0x08},
	{0x0000, 0x83, 0x08},
	{0x67DB, 0x09, 0x04},
	{0x0000, 0x83, 0x04},
	{0x67E4, 0x0A, 0x34},
	{0x0000, 0x83, 0x34},
	{0x67EE, 0x0A, 0x14},
	{0x0000, 0x83, 0x14},
	{0x67F8, 0x0A, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x6802, 0x0A, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x680C, 0x0A, 0x3C},
	{0x0000, 0x83, 0x3C},
	{0x6816, 0x09, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x681F, 0x0A, 0x24},
	{0x0000, 0x83, 0x24},
	{0x6829, 0x11, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x683A, 0x11, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x684B, 0x12, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x685D, 0x12, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x686F, 0x0C, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x687B, 0x0C, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x6887, 0x12, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x6899, 0x13, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x68AC, 0x0D, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x83, 0x14},
	{0x68B9, 0x12, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x68CB, 0x12, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x68DD, 0x13, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x68F0, 0x13, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6903, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x6910, 0x0D, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x691D, 0x12, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x692F, 0x13, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6942, 0x0D, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x83, 0x24},
	{0x694F, 0x11, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x6960, 0x11, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x6971, 0x12, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x6983, 0x12, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6995, 0x0C, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x18},
	{0x69A1, 0x0C, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x28},
	{0x69AD, 0x12, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x69BF, 0x13, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x69D2, 0x0D, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x14},
	{0x000B, 0x83, 0x14},
	{0x69DF, 0x12, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x18},
	{0x000E, 0x83, 0x25},
	{0x69F1, 0x12, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x6A03, 0x13, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x03, 0x1C},
	{0x000E, 0x83, 0x25},
	{0x6A16, 0x13, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6A29, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x6A36, 0x0D, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x6A43, 0x12, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x28},
	{0x000E, 0x83, 0x25},
	{0x6A55, 0x13, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x03, 0x2C},
	{0x000E, 0x83, 0x25},
	{0x6A68, 0x0D, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x24},
	{0x000B, 0x83, 0x24},
	{0x6A75, 0x11, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x6A86, 0x11, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x6A97, 0x12, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x6AA9, 0x12, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x6ABB, 0x0E, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x14},
	{0x6AC9, 0x0E, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x24},
	{0x6AD7, 0x0C, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x6AE3, 0x0C, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x6AEF, 0x12, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x6B01, 0x13, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x6B14, 0x0D, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x14},
	{0x6B21, 0x12, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0x6B33, 0x12, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x6B45, 0x13, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x6B58, 0x13, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x6B6B, 0x0F, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x14},
	{0x6B7A, 0x0F, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x24},
	{0x6B89, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x6B96, 0x0D, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x6BA3, 0x12, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0x6BB5, 0x13, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x6BC8, 0x0D, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x24},
	{0x6BD5, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x6BDF, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x6BE9, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x6BF3, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x6BFC, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x18},
	{0x6C06, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x28},
	{0x6C10, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x38},
	{0x6C1A, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x08},
	{0x6C23, 0x0A, 0x04},
	{0x0000, 0x03, 0x04},
	{0x0008, 0x83, 0x04},
	{0x6C2D, 0x0A, 0x44},
	{0x0000, 0x03, 0x44},
	{0x0008, 0x83, 0x04},
	{0x6C37, 0x0B, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x6C42, 0x0B, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x34},
	{0x6C4D, 0x0B, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x14},
	{0x6C58, 0x0B, 0x54},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x14},
	{0x6C63, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x6C6E, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x6C79, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x6C84, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x6C8E, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x1C},
	{0x6C99, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x2C},
	{0x6CA4, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x3C},
	{0x6CAF, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x0C},
	{0x6CB9, 0x0B, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x24},
	{0x6CC4, 0x0B, 0x64},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x24},
	{0x6CCF, 0x12, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x6CE1, 0x12, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x6CF3, 0x12, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0x6D05, 0x12, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0x6D17, 0x12, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0x6D29, 0x12, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0x6D3B, 0x0D, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x6D48, 0x0D, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x6D55, 0x0D, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x6D62, 0x0D, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x6D6F, 0x0D, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x6D7C, 0x0D, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x6D89, 0x0E, 0x24},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x6D97, 0x0E, 0x64},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x25},
	{0x6DA5, 0x0E, 0x04},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x25},
	{0x6DB3, 0x0E, 0x44},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x25},
	{0x6DC1, 0x0E, 0x14},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x25},
	{0x6DCF, 0x0E, 0x54},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x25},
	{0x6DDD, 0x13, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x6DF0, 0x13, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x6E03, 0x13, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0x6E16, 0x0E, 0x48},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x6E24, 0x0E, 0x58},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x6E32, 0x0E, 0x68},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x6E40, 0x0F, 0x24},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x6E4F, 0x0F, 0x04},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x25},
	{0x6E5E, 0x0F, 0x14},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x25},
	{0x6E6D, 0x0B, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x6E78, 0x0B, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x6E83, 0x0B, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x6E8E, 0x0A, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0x6E98, 0x0B, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0x6EA3, 0x0B, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0x6EAE, 0x0B, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0x6EB9, 0x0A, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0x6EC3, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x6ECC, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x6ED5, 0x09, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x6EDE, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x6EE6, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x18},
	{0x6EEF, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x28},
	{0x6EF8, 0x09, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x38},
	{0x6F01, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x08},
	{0x6F09, 0x0B, 0x04},
	{0x0000, 0x03, 0x04},
	{0x0008, 0x83, 0x25},
	{0x6F14, 0x0B, 0x44},
	{0x0000, 0x03, 0x44},
	{0x0008, 0x83, 0x25},
	{0x6F1F, 0x09, 0x04},
	{0x0000, 0x03, 0x04},
	{0x0008, 0x83, 0x04},
	{0x6F28, 0x09, 0x44},
	{0x0000, 0x03, 0x44},
	{0x0008, 0x83, 0x04},
	{0x6F31, 0x0C, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x6F3D, 0x0C, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x25},
	{0x6F49, 0x0A, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x6F53, 0x0A, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x34},
	{0x6F5D, 0x0C, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x25},
	{0x6F69, 0x0C, 0x54},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x25},
	{0x6F75, 0x0A, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x14},
	{0x6F7F, 0x0A, 0x54},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x14},
	{0x6F89, 0x0C, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x6F95, 0x0C, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x6FA1, 0x0C, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x6FAD, 0x0B, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0x6FB8, 0x0C, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x6FC4, 0x0C, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x6FD0, 0x0C, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x6FDC, 0x0B, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0x6FE7, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x6FF1, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x6FFB, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x7005, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x700E, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x1C},
	{0x7018, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x2C},
	{0x7022, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x3C},
	{0x702C, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x0C},
	{0x7035, 0x0C, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x25},
	{0x7041, 0x0C, 0x64},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x25},
	{0x704D, 0x0A, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x24},
	{0x7057, 0x0A, 0x64},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x24},
	{0x7061, 0x0C, 0x58},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x706D, 0x0C, 0x68},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x7079, 0x0C, 0x78},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x7085, 0x0B, 0x48},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0x7090, 0x0C, 0x04},
	{0x0000, 0x03, 0x04},
	{0x0008, 0x83, 0x25},
	{0x709C, 0x0D, 0x74},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x70A9, 0x0D, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x25},
	{0x70B6, 0x0D, 0x5C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x70C3, 0x0D, 0x6C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x70D0, 0x0D, 0x7C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x70DD, 0x0C, 0x4C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0x70E9, 0x0D, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x25},
	{0x70F6, 0x11, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x7107, 0x11, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x7118, 0x11, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0x7129, 0x11, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0x713A, 0x11, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0x714B, 0x11, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0x715C, 0x0C, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x7168, 0x0C, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x7174, 0x0C, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x7180, 0x0C, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0x718C, 0x0C, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0x7198, 0x0C, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0x71A4, 0x0D, 0x24},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x71B1, 0x0D, 0x64},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x25},
	{0x71BE, 0x0D, 0x04},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x25},
	{0x71CB, 0x0D, 0x44},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x25},
	{0x71D8, 0x0D, 0x14},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x25},
	{0x71E5, 0x0D, 0x54},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x25},
	{0x71F2, 0x12, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0x7204, 0x12, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0x7216, 0x12, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0x7228, 0x0D, 0x48},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0x7235, 0x0D, 0x58},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0x7242, 0x0D, 0x68},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0x724F, 0x0E, 0x24},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x725D, 0x0E, 0x04},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x25},
	{0x726B, 0x0E, 0x14},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x25},
	{0x7279, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x7282, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x728B, 0x09, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x7294, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x729C, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x72A5, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x72AE, 0x09, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0x72B7, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x72BF, 0x09, 0x04},
	{0x0000, 0x03, 0x04},
	{0x0008, 0x83, 0x04},
	{0x72C8, 0x09, 0x44},
	{0x0000, 0x03, 0x44},
	{0x0008, 0x83, 0x44},
	{0x72D1, 0x0A, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x72DB, 0x0A, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0x72E5, 0x0A, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x14},
	{0x72EF, 0x0A, 0x54},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x54},
	{0x72F9, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x7303, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x730D, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x7317, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x7320, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x732A, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x7334, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x733E, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x7347, 0x0A, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x24},
	{0x7351, 0x0A, 0x64},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x64},
	{0x735B, 0x09, 0xC8},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0x48},
	{0x7364, 0x09, 0x08},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x48},
	{0x736D, 0x09, 0x48},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x48},
	{0x7376, 0x0A, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0x4C},
	{0x7380, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x4C},
	{0x738A, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x7394, 0x09, 0xC8},
	{0x0072, 0x05, 0xCD},
	{0x0035, 0x85, 0x48},
	{0x739D, 0x09, 0x08},
	{0x0072, 0x05, 0x0D},
	{0x0035, 0x85, 0x48},
	{0x73A6, 0x09, 0x48},
	{0x0072, 0x05, 0x4D},
	{0x0035, 0x85, 0x48},
	{0x73AF, 0x0A, 0xCC},
	{0x0072, 0x05, 0xCD},
	{0x0035, 0x85, 0x4C},
	{0x73B9, 0x0A, 0x0C},
	{0x0072, 0x05, 0x0D},
	{0x0035, 0x85, 0x4C},
	{0x73C3, 0x0A, 0x4C},
	{0x0072, 0x05, 0x4D},
	{0x0035, 0x85, 0x4C},
	{0x73CD, 0x09, 0xC8},
	{0x0072, 0x05, 0xCE},
	{0x0035, 0x85, 0x48},
	{0x73D6, 0x09, 0x08},
	{0x0072, 0x05, 0x0E},
	{0x0035, 0x85, 0x48},
	{0x73DF, 0x09, 0x48},
	{0x0072, 0x05, 0x4E},
	{0x0035, 0x85, 0x48},
	{0x73E8, 0x0A, 0xCC},
	{0x0072, 0x05, 0xCE},
	{0x0035, 0x85, 0x4C},
	{0x73F2, 0x0A, 0x0C},
	{0x0072, 0x05, 0x0E},
	{0x0035, 0x85, 0x4C},
	{0x73FC, 0x0A, 0x4C},
	{0x0072, 0x05, 0x4E},
	{0x0035, 0x85, 0x4C},
	{0x7406, 0x09, 0xC8},
	{0x0072, 0x05, 0xCF},
	{0x0035, 0x85, 0x48},
	{0x740F, 0x09, 0x08},
	{0x0072, 0x05, 0x0F},
	{0x0035, 0x85, 0x48},
	{0x7418, 0x09, 0x48},
	{0x0072, 0x05, 0x4F},
	{0x0035, 0x85, 0x48},
	{0x7421, 0x0A, 0xCC},
	{0x0072, 0x05, 0xCF},
	{0x0035, 0x85, 0x4C},
	{0x742B, 0x0A, 0x0C},
	{0x0072, 0x05, 0x0F},
	{0x0035, 0x85, 0x4C},
	{0x7435, 0x0A, 0x4C},
	{0x0072, 0x05, 0x4F},
	{0x0035, 0x85, 0x4C},
	{0x743F, 0x09, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xCC},
	{0x0035, 0x85, 0x48},
	{0x7448, 0x09, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x0C},
	{0x0035, 0x85, 0x48},
	{0x7451, 0x09, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x4C},
	{0x0035, 0x85, 0x48},
	{0x745A, 0x0A, 0xCC},
	{0x006A, 0x03, 0xCC},
	{0x0072, 0x05, 0xCC},
	{0x0035, 0x85, 0x4C},
	{0x7464, 0x0A, 0x0C},
	{0x006A, 0x03, 0x0C},
	{0x0072, 0x05, 0x0C},
	{0x0035, 0x85, 0x4C},
	{0x746E, 0x0A, 0x4C},
	{0x006A, 0x03, 0x4C},
	{0x0072, 0x05, 0x4C},
	{0x0035, 0x85, 0x4C},
	{0x7478, 0x09, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xCD},
	{0x0035, 0x85, 0x48},
	{0x7481, 0x09, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x0D},
	{0x0035, 0x85, 0x48},
	{0x748A, 0x09, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x4D},
	{0x0035, 0x85, 0x48},
	{0x7493, 0x0A, 0xCC},
	{0x006A, 0x03, 0xCC},
	{0x0072, 0x05, 0xCD},
	{0x0035, 0x85, 0x4C},
	{0x749D, 0x0A, 0x0C},
	{0x006A, 0x03, 0x0C},
	{0x0072, 0x05, 0x0D},
	{0x0035, 0x85, 0x4C},
	{0x74A7, 0x0A, 0x4C},
	{0x006A, 0x03, 0x4C},
	{0x0072, 0x05, 0x4D},
	{0x0035, 0x85, 0x4C},
	{0x74B1, 0x09, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xCE},
	{0x0035, 0x85, 0x48},
	{0x74BA, 0x09, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x0E},
	{0x0035, 0x85, 0x48},
	{0x74C3, 0x09, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x4E},
	{0x0035, 0x85, 0x48},
	{0x74CC, 0x0A, 0xCC},
	{0x006A, 0x03, 0xCC},
	{0x0072, 0x05, 0xCE},
	{0x0035, 0x85, 0x4C},
	{0x74D6, 0x0A, 0x0C},
	{0x006A, 0x03, 0x0C},
	{0x0072, 0x05, 0x0E},
	{0x0035, 0x85, 0x4C},
	{0x74E0, 0x0A, 0x4C},
	{0x006A, 0x03, 0x4C},
	{0x0072, 0x05, 0x4E},
	{0x0035, 0x85, 0x4C},
	{0x74EA, 0x09, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xCF},
	{0x0035, 0x85, 0x48},
	{0x74F3, 0x09, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x0F},
	{0x0035, 0x85, 0x48},
	{0x74FC, 0x09, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x4F},
	{0x0035, 0x85, 0x48},
	{0x7505, 0x0A, 0xCC},
	{0x006A, 0x03, 0xCC},
	{0x0072, 0x05, 0xCF},
	{0x0035, 0x85, 0x4C},
	{0x750F, 0x0A, 0x0C},
	{0x006A, 0x03, 0x0C},
	{0x0072, 0x05, 0x0F},
	{0x0035, 0x85, 0x4C},
	{0x7519, 0x0A, 0x4C},
	{0x006A, 0x03, 0x4C},
	{0x0072, 0x05, 0x4F},
	{0x0035, 0x85, 0x4C},
	{0x7523, 0x10, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0x7533, 0x10, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0x7543, 0x10, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x3C},
	{0x7553, 0x10, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0x7563, 0x10, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0x7573, 0x10, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0x7583, 0x0B, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x758E, 0x0B, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x7599, 0x0B, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x75A4, 0x0B, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x75AF, 0x0B, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x75BA, 0x0B, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x75C5, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0x75CF, 0x08, 0xC8},
	{0x0000, 0x83, 0xC8},
	{0x75D7, 0x08, 0x08},
	{0x0000, 0x83, 0x08},
	{0x75DF, 0x08, 0x48},
	{0x0000, 0x83, 0x48},
	{0x75E7, 0x09, 0xCC},
	{0x0000, 0x83, 0xCC},
	{0x75F0, 0x09, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x75F9, 0x09, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x7602, 0x0A, 0x98},
	{0x0000, 0x83, 0x98},
	{0x760C, 0x0A, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x7616, 0x0A, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x7620, 0x0A, 0x68},
	{0x0000, 0x83, 0x68},
	{0x762A, 0x0B, 0xB4},
	{0x0000, 0x83, 0xB4},
	{0x7635, 0x0B, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x7640, 0x0B, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x764B, 0x0B, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x7656, 0x0B, 0x6C},
	{0x0000, 0x83, 0x6C},
	{0x7661, 0x0B, 0xA4},
	{0x0000, 0x83, 0xA4},
	{0x766C, 0x0A, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0x7676, 0x0A, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0x7680, 0x0A, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0x768A, 0x0B, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0x7695, 0x0B, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0x76A0, 0x0B, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0x76AB, 0x0B, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0x76B6, 0x0B, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0x76C1, 0x0B, 0xB4},
	{0x0000, 0x83, 0xB4},
	{0x76CC, 0x0B, 0xA4},
	{0x0000, 0x83, 0xA4},
	{0x76D7, 0x15, 0x88},
	{0x0000, 0x83, 0x98},
	{0x76EC, 0x15, 0x88},
	{0x0000, 0x83, 0xA8},
	{0x7701, 0x15, 0x88},
	{0x0000, 0x83, 0xB8},
	{0x7716, 0x15, 0x88},
	{0x0000, 0x83, 0xD8},
	{0x772B, 0x15, 0x88},
	{0x0000, 0x83, 0xE8},
	{0x7740, 0x14, 0x88},
	{0x0000, 0x83, 0xC8},
	{0x7754, 0x15, 0x88},
	{0x0000, 0x83, 0x18},
	{0x7769, 0x15, 0x88},
	{0x0000, 0x83, 0x28},
	{0x777E, 0x15, 0x88},
	{0x0000, 0x83, 0x38},
	{0x7793, 0x14, 0x88},
	{0x0000, 0x83, 0x08},
	{0x77A7, 0x15, 0x88},
	{0x0000, 0x83, 0x58},
	{0x77BC, 0x15, 0x88},
	{0x0000, 0x83, 0x68},
	{0x77D1, 0x15, 0x88},
	{0x0000, 0x83, 0x78},
	{0x77E6, 0x14, 0x88},
	{0x0000, 0x83, 0x48},
	{0x77FA, 0x15, 0x98},
	{0x0000, 0x83, 0x88},
	{0x780F, 0x14, 0x98},
	{0x0000, 0x83, 0xA8},
	{0x7823, 0x14, 0x98},
	{0x0000, 0x83, 0xB8},
	{0x7837, 0x14, 0x98},
	{0x0000, 0x83, 0xD8},
	{0x784B, 0x14, 0x98},
	{0x0000, 0x83, 0xE8},
	{0x785F, 0x13, 0x98},
	{0x0000, 0x83, 0xC8},
	{0x7872, 0x14, 0x98},
	{0x0000, 0x83, 0x18},
	{0x7886, 0x14, 0x98},
	{0x0000, 0x83, 0x28},
	{0x789A, 0x14, 0x98},
	{0x0000, 0x83, 0x38},
	{0x78AE, 0x13, 0x98},
	{0x0000, 0x83, 0x08},
	{0x78C1, 0x14, 0x98},
	{0x0000, 0x83, 0x58},
	{0x78D5, 0x14, 0x98},
	{0x0000, 0x83, 0x68},
	{0x78E9, 0x14, 0x98},
	{0x0000, 0x83, 0x78},
	{0x78FD, 0x13, 0x98},
	{0x0000, 0x83, 0x48},
	{0x7910, 0x15, 0xA8},
	{0x0000, 0x83, 0x88},
	{0x7925, 0x14, 0xA8},
	{0x0000, 0x83, 0x98},
	{0x7939, 0x14, 0xA8},
	{0x0000, 0x83, 0xB8},
	{0x794D, 0x14, 0xA8},
	{0x0000, 0x83, 0xD8},
	{0x7961, 0x14, 0xA8},
	{0x0000, 0x83, 0xE8},
	{0x7975, 0x13, 0xA8},
	{0x0000, 0x83, 0xC8},
	{0x7988, 0x14, 0xA8},
	{0x0000, 0x83, 0x18},
	{0x799C, 0x14, 0xA8},
	{0x0000, 0x83, 0x28},
	{0x79B0, 0x14, 0xA8},
	{0x0000, 0x83, 0x38},
	{0x79C4, 0x13, 0xA8},
	{0x0000, 0x83, 0x08},
	{0x79D7, 0x14, 0xA8},
	{0x0000, 0x83, 0x58},
	{0x79EB, 0x14, 0xA8},
	{0x0000, 0x83, 0x68},
	{0x79FF, 0x14, 0xA8},
	{0x0000, 0x83, 0x78},
	{0x7A13, 0x13, 0xA8},
	{0x0000, 0x83, 0x48},
	{0x7A26, 0x15, 0xB8},
	{0x0000, 0x83, 0x88},
	{0x7A3B, 0x14, 0xB8},
	{0x0000, 0x83, 0x98},
	{0x7A4F, 0x14, 0xB8},
	{0x0000, 0x83, 0xA8},
	{0x7A63, 0x14, 0xB8},
	{0x0000, 0x83, 0xD8},
	{0x7A77, 0x14, 0xB8},
	{0x0000, 0x83, 0xE8},
	{0x7A8B, 0x13, 0xB8},
	{0x0000, 0x83, 0xC8},
	{0x7A9E, 0x14, 0xB8},
	{0x0000, 0x83, 0x18},
	{0x7AB2, 0x14, 0xB8},
	{0x0000, 0x83, 0x28},
	{0x7AC6, 0x14, 0xB8},
	{0x0000, 0x83, 0x38},
	{0x7ADA, 0x13, 0xB8},
	{0x0000, 0x83, 0x08},
	{0x7AED, 0x14, 0xB8},
	{0x0000, 0x83, 0x58},
	{0x7B01, 0x14, 0xB8},
	{0x0000, 0x83, 0x68},
	{0x7B15, 0x14, 0xB8},
	{0x0000, 0x83, 0x78},
	{0x7B29, 0x13, 0xB8},
	{0x0000, 0x83, 0x48},
	{0x7B3C, 0x15, 0xD8},
	{0x0000, 0x83, 0x88},
	{0x7B51, 0x14, 0xD8},
	{0x0000, 0x83, 0x98},
	{0x7B65, 0x14, 0xD8},
	{0x0000, 0x83, 0xA8},
	{0x7B79, 0x14, 0xD8},
	{0x0000, 0x83, 0xB8},
	{0x7B8D, 0x14, 0xD8},
	{0x0000, 0x83, 0xE8},
	{0x7BA1, 0x13, 0xD8},
	{0x0000, 0x83, 0xC8},
	{0x7BB4, 0x14, 0xD8},
	{0x0000, 0x83, 0x18},
	{0x7BC8, 0x14, 0xD8},
	{0x0000, 0x83, 0x28},
	{0x7BDC, 0x14, 0xD8},
	{0x0000, 0x83, 0x38},
	{0x7BF0, 0x13, 0xD8},
	{0x0000, 0x83, 0x08},
	{0x7C03, 0x14, 0xD8},
	{0x0000, 0x83, 0x58},
	{0x7C17, 0x14, 0xD8},
	{0x0000, 0x83, 0x68},
	{0x7C2B, 0x14, 0xD8},
	{0x0000, 0x83, 0x78},
	{0x7C3F, 0x13, 0xD8},
	{0x0000, 0x83, 0x48},
	{0x7C52, 0x15, 0xE8},
	{0x0000, 0x83, 0x88},
	{0x7C67, 0x14, 0xE8},
	{0x0000, 0x83, 0x98},
	{0x7C7B, 0x14, 0xE8},
	{0x0000, 0x83, 0xA8},
	{0x7C8F, 0x14, 0xE8},
	{0x0000, 0x83, 0xB8},
	{0x7CA3, 0x14, 0xE8},
	{0x0000, 0x83, 0xD8},
	{0x7CB7, 0x13, 0xE8},
	{0x0000, 0x83, 0xC8},
	{0x7CCA, 0x14, 0xE8},
	{0x0000, 0x83, 0x18},
	{0x7CDE, 0x14, 0xE8},
	{0x0000, 0x83, 0x28},
	{0x7CF2, 0x14, 0xE8},
	{0x0000, 0x83, 0x38},
	{0x7D06, 0x13, 0xE8},
	{0x0000, 0x83, 0x08},
	{0x7D19, 0x14, 0xE8},
	{0x0000, 0x83, 0x58},
	{0x7D2D, 0x14, 0xE8},
	{0x0000, 0x83, 0x68},
	{0x7D41, 0x14, 0xE8},
	{0x0000, 0x83, 0x78},
	{0x7D55, 0x13, 0xE8},
	{0x0000, 0x83, 0x48},
	{0x7D68, 0x14, 0xC8},
	{0x0000, 0x83, 0x88},
	{0x7D7C, 0x13, 0xC8},
	{0x0000, 0x83, 0x98},
	{0x7D8F, 0x13, 0xC8},
	{0x0000, 0x83, 0xA8},
	{0x7DA2, 0x13, 0xC8},
	{0x0000, 0x83, 0xB8},
	{0x7DB5, 0x13, 0xC8},
	{0x0000, 0x83, 0xD8},
	{0x7DC8, 0x13, 0xC8},
	{0x0000, 0x83, 0xE8},
	{0x7DDB, 0x13, 0xC8},
	{0x0000, 0x83, 0x18},
	{0x7DEE, 0x13, 0xC8},
	{0x0000, 0x83, 0x28},
	{0x7E01, 0x13, 0xC8},
	{0x0000, 0x83, 0x38},
	{0x7E14, 0x12, 0xC8},
	{0x0000, 0x83, 0x08},
	{0x7E26, 0x13, 0xC8},
	{0x0000, 0x83, 0x58},
	{0x7E39, 0x13, 0xC8},
	{0x0000, 0x83, 0x68},
	{0x7E4C, 0x13, 0xC8},
	{0x0000, 0x83, 0x78},
	{0x7E5F, 0x12, 0xC8},
	{0x0000, 0x83, 0x48},
	{0x7E71, 0x15, 0x18},
	{0x0000, 0x83, 0x88},
	{0x7E86, 0x14, 0x18},
	{0x0000, 0x83, 0x98},
	{0x7E9A, 0x14, 0x18},
	{0x0000, 0x83, 0xA8},
	{0x7EAE, 0x14, 0x18},
	{0x0000, 0x83, 0xB8},
	{0x7EC2, 0x14, 0x18},
	{0x0000, 0x83, 0xD8},
	{0x7ED6, 0x14, 0x18},
	{0x0000, 0x83, 0xE8},
	{0x7EEA, 0x13, 0x18},
	{0x0000, 0x83, 0xC8},
	{0x7EFD, 0x14, 0x18},
	{0x0000, 0x83, 0x28},
	{0x7F11, 0x14, 0x18},
	{0x0000, 0x83, 0x38},
	{0x7F25, 0x13, 0x18},
	{0x0000, 0x83, 0x08},
	{0x7F38, 0x14, 0x18},
	{0x0000, 0x83, 0x58},
	{0x7F4C, 0x14, 0x18},
	{0x0000, 0x83, 0x68},
	{0x7F60, 0x14, 0x18},
	{0x0000, 0x83, 0x78},
	{0x7F74, 0x13, 0x18},
	{0x0000, 0x83, 0x48},
	{0x7F87, 0x15, 0x28},
	{0x0000, 0x83, 0x88},
	{0x7F9C, 0x14, 0x28},
	{0x0000, 0x83, 0x98},
	{0x7FB0, 0x14, 0x28},
	{0x0000, 0x83, 0xA8},
	{0x7FC4, 0x14, 0x28},
	{0x0000, 0x83, 0xB8},
	{0x7FD8, 0x14, 0x28},
	{0x0000, 0x83, 0xD8},
	{0x7FEC, 0x14, 0x28},
	{0x0000, 0x83, 0xE8},
	{0x8000, 0x13, 0x28},
	{0x0000, 0x83, 0xC8},
	{0x8013, 0x14, 0x28},
	{0x0000, 0x83, 0x18},
	{0x8027, 0x14, 0x28},
	{0x0000, 0x83, 0x38},
	{0x803B, 0x13, 0x28},
	{0x0000, 0x83, 0x08},
	{0x804E, 0x14, 0x28},
	{0x0000, 0x83, 0x58},
	{0x8062, 0x14, 0x28},
	{0x0000, 0x83, 0x68},
	{0x8076, 0x14, 0x28},
	{0x0000, 0x83, 0x78},
	{0x808A, 0x13, 0x28},
	{0x0000, 0x83, 0x48},
	{0x809D, 0x15, 0x38},
	{0x0000, 0x83, 0x88},
	{0x80B2, 0x14, 0x38},
	{0x0000, 0x83, 0x98},
	{0x80C6, 0x14, 0x38},
	{0x0000, 0x83, 0xA8},
	{0x80DA, 0x14, 0x38},
	{0x0000, 0x83, 0xB8},
	{0x80EE, 0x14, 0x38},
	{0x0000, 0x83, 0xD8},
	{0x8102, 0x14, 0x38},
	{0x0000, 0x83, 0xE8},
	{0x8116, 0x13, 0x38},
	{0x0000, 0x83, 0xC8},
	{0x8129, 0x14, 0x38},
	{0x0000, 0x83, 0x18},
	{0x813D, 0x14, 0x38},
	{0x0000, 0x83, 0x28},
	{0x8151, 0x13, 0x38},
	{0x0000, 0x83, 0x08},
	{0x8164, 0x14, 0x38},
	{0x0000, 0x83, 0x58},
	{0x8178, 0x14, 0x38},
	{0x0000, 0x83, 0x68},
	{0x818C, 0x14, 0x38},
	{0x0000, 0x83, 0x78},
	{0x81A0, 0x13, 0x38},
	{0x0000, 0x83, 0x48},
	{0x81B3, 0x14, 0x08},
	{0x0000, 0x83, 0x88},
	{0x81C7, 0x13, 0x08},
	{0x0000, 0x83, 0x98},
	{0x81DA, 0x13, 0x08},
	{0x0000, 0x83, 0xA8},
	{0x81ED, 0x13, 0x08},
	{0x0000, 0x83, 0xB8},
	{0x8200, 0x13, 0x08},
	{0x0000, 0x83, 0xD8},
	{0x8213, 0x13, 0x08},
	{0x0000, 0x83, 0xE8},
	{0x8226, 0x12, 0x08},
	{0x0000, 0x83, 0xC8},
	{0x8238, 0x13, 0x08},
	{0x0000, 0x83, 0x18},
	{0x824B, 0x13, 0x08},
	{0x0000, 0x83, 0x28},
	{0x825E, 0x13, 0x08},
	{0x0000, 0x83, 0x38},
	{0x8271, 0x13, 0x08},
	{0x0000, 0x83, 0x58},
	{0x8284, 0x13, 0x08},
	{0x0000, 0x83, 0x68},
	{0x8297, 0x13, 0x08},
	{0x0000, 0x83, 0x78},
	{0x82AA, 0x12, 0x08},
	{0x0000, 0x83, 0x48},
	{0x82BC, 0x15, 0x58},
	{0x0000, 0x83, 0x88},
	{0x82D1, 0x14, 0x58},
	{0x0000, 0x83, 0x98},
	{0x82E5, 0x14, 0x58},
	{0x0000, 0x83, 0xA8},
	{0x82F9, 0x14, 0x58},
	{0x0000, 0x83, 0xB8},
	{0x830D, 0x14, 0x58},
	{0x0000, 0x83, 0xD8},
	{0x8321, 0x14, 0x58},
	{0x0000, 0x83, 0xE8},
	{0x8335, 0x13, 0x58},
	{0x0000, 0x83, 0xC8},
	{0x8348, 0x14, 0x58},
	{0x0000, 0x83, 0x18},
	{0x835C, 0x14, 0x58},
	{0x0000, 0x83, 0x28},
	{0x8370, 0x14, 0x58},
	{0x0000, 0x83, 0x38},
	{0x8384, 0x13, 0x58},
	{0x0000, 0x83, 0x08},
	{0x8397, 0x14, 0x58},
	{0x0000, 0x83, 0x68},
	{0x83AB, 0x14, 0x58},
	{0x0000, 0x83, 0x78},
	{0x83BF, 0x13, 0x58},
	{0x0000, 0x83, 0x48},
	{0x83D2, 0x15, 0x68},
	{0x0000, 0x83, 0x88},
	{0x83E7, 0x14, 0x68},
	{0x0000, 0x83, 0x98},
	{0x83FB, 0x14, 0x68},
	{0x0000, 0x83, 0xA8},
	{0x840F, 0x14, 0x68},
	{0x0000, 0x83, 0xB8},
	{0x8423, 0x14, 0x68},
	{0x0000, 0x83, 0xD8},
	{0x8437, 0x14, 0x68},
	{0x0000, 0x83, 0xE8},
	{0x844B, 0x13, 0x68},
	{0x0000, 0x83, 0xC8},
	{0x845E, 0x14, 0x68},
	{0x0000, 0x83, 0x18},
	{0x8472, 0x14, 0x68},
	{0x0000, 0x83, 0x28},
	{0x8486, 0x14, 0x68},
	{0x0000, 0x83, 0x38},
	{0x849A, 0x13, 0x68},
	{0x0000, 0x83, 0x08},
	{0x84AD, 0x14, 0x68},
	{0x0000, 0x83, 0x58},
	{0x84C1, 0x14, 0x68},
	{0x0000, 0x83, 0x78},
	{0x84D5, 0x13, 0x68},
	{0x0000, 0x83, 0x48},
	{0x84E8, 0x15, 0x78},
	{0x0000, 0x83, 0x88},
	{0x84FD, 0x14, 0x78},
	{0x0000, 0x83, 0x98},
	{0x8511, 0x14, 0x78},
	{0x0000, 0x83, 0xA8},
	{0x8525, 0x14, 0x78},
	{0x0000, 0x83, 0xB8},
	{0x8539, 0x14, 0x78},
	{0x0000, 0x83, 0xD8},
	{0x854D, 0x14, 0x78},
	{0x0000, 0x83, 0xE8},
	{0x8561, 0x13, 0x78},
	{0x0000, 0x83, 0xC8},
	{0x8574, 0x14, 0x78},
	{0x0000, 0x83, 0x18},
	{0x8588, 0x14, 0x78},
	{0x0000, 0x83, 0x28},
	{0x859C, 0x14, 0x78},
	{0x0000, 0x83, 0x38},
	{0x85B0, 0x13, 0x78},
	{0x0000, 0x83, 0x08},
	{0x85C3, 0x14, 0x78},
	{0x0000, 0x83, 0x58},
	{0x85D7, 0x14, 0x78},
	{0x0000, 0x83, 0x68},
	{0x85EB, 0x13, 0x78},
	{0x0000, 0x83, 0x48},
	{0x85FE, 0x14, 0x48},
	{0x0000, 0x83, 0x88},
	{0x8612, 0x13, 0x48},
	{0x0000, 0x83, 0x98},
	{0x8625, 0x13, 0x48},
	{0x0000, 0x83, 0xA8},
	{0x8638, 0x13, 0x48},
	{0x0000, 0x83, 0xB8},
	{0x864B, 0x13, 0x48},
	{0x0000, 0x83, 0xD8},
	{0x865E, 0x13, 0x48},
	{0x0000, 0x83, 0xE8},
	{0x8671, 0x12, 0x48},
	{0x0000, 0x83, 0xC8},
	{0x8683, 0x13, 0x48},
	{0x0000, 0x83, 0x18},
	{0x8696, 0x13, 0x48},
	{0x0000, 0x83, 0x28},
	{0x86A9, 0x13, 0x48},
	{0x0000, 0x83, 0x38},
	{0x86BC, 0x12, 0x48},
	{0x0000, 0x83, 0x08},
	{0x86CE, 0x13, 0x48},
	{0x0000, 0x83, 0x58},
	{0x86E1, 0x13, 0x48},
	{0x0000, 0x83, 0x68},
	{0x86F4, 0x13, 0x48},
	{0x0000, 0x83, 0x78},
	{0x8707, 0x16, 0x8C},
	{0x0000, 0x83, 0x9C},
	{0x871D, 0x16, 0x8C},
	{0x0000, 0x83, 0xAC},
	{0x8733, 0x16, 0x8C},
	{0x0000, 0x83, 0xBC},
	{0x8749, 0x17, 0x8C},
	{0x0000, 0x83, 0xF4},
	{0x8760, 0x16, 0x8C},
	{0x0000, 0x83, 0xDC},
	{0x8776, 0x16, 0x8C},
	{0x0000, 0x83, 0xEC},
	{0x878C, 0x15, 0x8C},
	{0x0000, 0x83, 0xCC},
	{0x87A1, 0x16, 0x8C},
	{0x0000, 0x83, 0x1C},
	{0x87B7, 0x16, 0x8C},
	{0x0000, 0x83, 0x2C},
	{0x87CD, 0x16, 0x8C},
	{0x0000, 0x83, 0x3C},
	{0x87E3, 0x15, 0x8C},
	{0x0000, 0x83, 0x0C},
	{0x87F8, 0x16, 0x8C},
	{0x0000, 0x83, 0x5C},
	{0x880E, 0x16, 0x8C},
	{0x0000, 0x83, 0x6C},
	{0x8824, 0x16, 0x8C},
	{0x0000, 0x83, 0x7C},
	{0x883A, 0x15, 0x8C},
	{0x0000, 0x83, 0x4C},
	{0x884F, 0x16, 0x9C},
	{0x0000, 0x83, 0x8C},
	{0x8865, 0x15, 0x9C},
	{0x0000, 0x83, 0xAC},
	{0x887A, 0x15, 0x9C},
	{0x0000, 0x83, 0xBC},
	{0x888F, 0x16, 0x9C},
	{0x0000, 0x83, 0xF4},
	{0x88A5, 0x15, 0x9C},
	{0x0000, 0x83, 0xDC},
	{0x88BA, 0x15, 0x9C},
	{0x0000, 0x83, 0xEC},
	{0x88CF, 0x14, 0x9C},
	{0x0000, 0x83, 0xCC},
	{0x88E3, 0x15, 0x9C},
	{0x0000, 0x83, 0x1C},
	{0x88F8, 0x15, 0x9C},
	{0x0000, 0x83, 0x2C},
	{0x890D, 0x15, 0x9C},
	{0x0000, 0x83, 0x3C},
	{0x8922, 0x14, 0x9C},
	{0x0000, 0x83, 0x0C},
	{0x8936, 0x15, 0x9C},
	{0x0000, 0x83, 0x5C},
	{0x894B, 0x15, 0x9C},
	{0x0000, 0x83, 0x6C},
	{0x8960, 0x15, 0x9C},
	{0x0000, 0x83, 0x7C},
	{0x8975, 0x14, 0x9C},
	{0x0000, 0x83, 0x4C},
	{0x8989, 0x16, 0xAC},
	{0x0000, 0x83, 0x8C},
	{0x899F, 0x15, 0xAC},
	{0x0000, 0x83, 0x9C},
	{0x89B4, 0x15, 0xAC},
	{0x0000, 0x83, 0xBC},
	{0x89C9, 0x16, 0xAC},
	{0x0000, 0x83, 0xF4},
	{0x89DF, 0x15, 0xAC},
	{0x0000, 0x83, 0xDC},
	{0x89F4, 0x15, 0xAC},
	{0x0000, 0x83, 0xEC},
	{0x8A09, 0x14, 0xAC},
	{0x0000, 0x83, 0xCC},
	{0x8A1D, 0x15, 0xAC},
	{0x0000, 0x83, 0x1C},
	{0x8A32, 0x15, 0xAC},
	{0x0000, 0x83, 0x2C},
	{0x8A47, 0x15, 0xAC},
	{0x0000, 0x83, 0x3C},
	{0x8A5C, 0x14, 0xAC},
	{0x0000, 0x83, 0x0C},
	{0x8A70, 0x15, 0xAC},
	{0x0000, 0x83, 0x5C},
	{0x8A85, 0x15, 0xAC},
	{0x0000, 0x83, 0x6C},
	{0x8A9A, 0x15, 0xAC},
	{0x0000, 0x83, 0x7C},
	{0x8AAF, 0x14, 0xAC},
	{0x0000, 0x83, 0x4C},
	{0x8AC3, 0x16, 0xBC},
	{0x0000, 0x83, 0x8C},
	{0x8AD9, 0x15, 0xBC},
	{0x0000, 0x83, 0x9C},
	{0x8AEE, 0x15, 0xBC},
	{0x0000, 0x83, 0xAC},
	{0x8B03, 0x16, 0xBC},
	{0x0000, 0x83, 0xF4},
	{0x8B19, 0x15, 0xBC},
	{0x0000, 0x83, 0xDC},
	{0x8B2E, 0x15, 0xBC},
	{0x0000, 0x83, 0xEC},
	{0x8B43, 0x14, 0xBC},
	{0x0000, 0x83, 0xCC},
	{0x8B57, 0x15, 0xBC},
	{0x0000, 0x83, 0x1C},
	{0x8B6C, 0x15, 0xBC},
	{0x0000, 0x83, 0x2C},
	{0x8B81, 0x15, 0xBC},
	{0x0000, 0x83, 0x3C},
	{0x8B96, 0x14, 0xBC},
	{0x0000, 0x83, 0x0C},
	{0x8BAA, 0x15, 0xBC},
	{0x0000, 0x83, 0x5C},
	{0x8BBF, 0x15, 0xBC},
	{0x0000, 0x83, 0x6C},
	{0x8BD4, 0x15, 0xBC},
	{0x0000, 0x83, 0x7C},
	{0x8BE9, 0x14, 0xBC},
	{0x0000, 0x83, 0x4C},
	{0x8BFD, 0x17, 0xF4},
	{0x0000, 0x83, 0x8C},
	{0x8C14, 0x16, 0xF4},
	{0x0000, 0x83, 0x9C},
	{0x8C2A, 0x16, 0xF4},
	{0x0000, 0x83, 0xAC},
	{0x8C40, 0x16, 0xF4},
	{0x0000, 0x83, 0xBC},
	{0x8C56, 0x16, 0xF4},
	{0x0000, 0x83, 0xDC},
	{0x8C6C, 0x16, 0xF4},
	{0x0000, 0x83, 0xEC},
	{0x8C82, 0x15, 0xF4},
	{0x0000, 0x83, 0xCC},
	{0x8C97, 0x16, 0xF4},
	{0x0000, 0x83, 0x1C},
	{0x8CAD, 0x16, 0xF4},
	{0x0000, 0x83, 0x2C},
	{0x8CC3, 0x16, 0xF4},
	{0x0000, 0x83, 0x3C},
	{0x8CD9, 0x15, 0xF4},
	{0x0000, 0x83, 0x0C},
	{0x8CEE, 0x16, 0xF4},
	{0x0000, 0x83, 0x5C},
	{0x8D04, 0x16, 0xF4},
	{0x0000, 0x83, 0x6C},
	{0x8D1A, 0x16, 0xF4},
	{0x0000, 0x83, 0x7C},
	{0x8D30, 0x15, 0xF4},
	{0x0000, 0x83, 0x4C},
	{0x8D45, 0x16, 0xDC},
	{0x0000, 0x83, 0x8C},
	{0x8D5B, 0x15, 0xDC},
	{0x0000, 0x83, 0x9C},
	{0x8D70, 0x15, 0xDC},
	{0x0000, 0x83, 0xAC},
	{0x8D85, 0x15, 0xDC},
	{0x0000, 0x83, 0xBC},
	{0x8D9A, 0x16, 0xDC},
	{0x0000, 0x83, 0xF4},
	{0x8DB0, 0x15, 0xDC},
	{0x0000, 0x83, 0xEC},
	{0x8DC5, 0x14, 0xDC},
	{0x0000, 0x83, 0xCC},
	{0x8DD9, 0x15, 0xDC},
	{0x0000, 0x83, 0x1C},
	{0x8DEE, 0x15, 0xDC},
	{0x0000, 0x83, 0x2C},
	{0x8E03, 0x15, 0xDC},
	{0x0000, 0x83, 0x3C},
	{0x8E18, 0x14, 0xDC},
	{0x0000, 0x83, 0x0C},
	{0x8E2C, 0x15, 0xDC},
	{0x0000, 0x83, 0x5C},
	{0x8E41, 0x15, 0xDC},
	{0x0000, 0x83, 0x6C},
	{0x8E56, 0x15, 0xDC},
	{0x0000, 0x83, 0x7C},
	{0x8E6B, 0x14, 0xDC},
	{0x0000, 0x83, 0x4C},
	{0x8E7F, 0x16, 0xEC},
	{0x0000, 0x83, 0x8C},
	{0x8E95, 0x15, 0xEC},
	{0x0000, 0x83, 0x9C},
	{0x8EAA, 0x15, 0xEC},
	{0x0000, 0x83, 0xAC},
	{0x8EBF, 0x15, 0xEC},
	{0x0000, 0x83, 0xBC},
	{0x8ED4, 0x16, 0xEC},
	{0x0000, 0x83, 0xF4},
	{0x8EEA, 0x15, 0xEC},
	{0x0000, 0x83, 0xDC},
	{0x8EFF, 0x14, 0xEC},
	{0x0000, 0x83, 0xCC},
	{0x8F13, 0x15, 0xEC},
	{0x0000, 0x83, 0x1C},
	{0x8F28, 0x15, 0xEC},
	{0x0000, 0x83, 0x2C},
	{0x8F3D, 0x15, 0xEC},
	{0x0000, 0x83, 0x3C},
	{0x8F52, 0x14, 0xEC},
	{0x0000, 0x83, 0x0C},
	{0x8F66, 0x15, 0xEC},
	{0x0000, 0x83, 0x5C},
	{0x8F7B, 0x15, 0xEC},
	{0x0000, 0x83, 0x6C},
	{0x8F90, 0x15, 0xEC},
	{0x0000, 0x83, 0x7C},
	{0x8FA5, 0x14, 0xEC},
	{0x0000, 0x83, 0x4C},
	{0x8FB9, 0x15, 0xCC},
	{0x0000, 0x83, 0x8C},
	{0x8FCE, 0x14, 0xCC},
	{0x0000, 0x83, 0x9C},
	{0x8FE2, 0x14, 0xCC},
	{0x0000, 0x83, 0xAC},
	{0x8FF6, 0x14, 0xCC},
	{0x0000, 0x83, 0xBC},
	{0x900A, 0x15, 0xCC},
	{0x0000, 0x83, 0xF4},
	{0x901F, 0x14, 0xCC},
	{0x0000, 0x83, 0xDC},
	{0x9033, 0x14, 0xCC},
	{0x0000, 0x83, 0xEC},
	{0x9047, 0x14, 0xCC},
	{0x0000, 0x83, 0x1C},
	{0x905B, 0x14, 0xCC},
	{0x0000, 0x83, 0x2C},
	{0x906F, 0x14, 0xCC},
	{0x0000, 0x83, 0x3C},
	{0x9083, 0x13, 0xCC},
	{0x0000, 0x83, 0x0C},
	{0x9096, 0x14, 0xCC},
	{0x0000, 0x83, 0x5C},
	{0x90AA, 0x14, 0xCC},
	{0x0000, 0x83, 0x6C},
	{0x90BE, 0x14, 0xCC},
	{0x0000, 0x83, 0x7C},
	{0x90D2, 0x13, 0xCC},
	{0x0000, 0x83, 0x4C},
	{0x90E5, 0x16, 0x1C},
	{0x0000, 0x83, 0x8C},
	{0x90FB, 0x15, 0x1C},
	{0x0000, 0x83, 0x9C},
	{0x9110, 0x15, 0x1C},
	{0x0000, 0x83, 0xAC},
	{0x9125, 0x15, 0x1C},
	{0x0000, 0x83, 0xBC},
	{0x913A, 0x16, 0x1C},
	{0x0000, 0x83, 0xF4},
	{0x9150, 0x15, 0x1C},
	{0x0000, 0x83, 0xDC},
	{0x9165, 0x15, 0x1C},
	{0x0000, 0x83, 0xEC},
	{0x917A, 0x14, 0x1C},
	{0x0000, 0x83, 0xCC},
	{0x918E, 0x15, 0x1C},
	{0x0000, 0x83, 0x2C},
	{0x91A3, 0x15, 0x1C},
	{0x0000, 0x83, 0x3C},
	{0x91B8, 0x14, 0x1C},
	{0x0000, 0x83, 0x0C},
	{0x91CC, 0x15, 0x1C},
	{0x0000, 0x83, 0x5C},
	{0x91E1, 0x15, 0x1C},
	{0x0000, 0x83, 0x6C},
	{0x91F6, 0x15, 0x1C},
	{0x0000, 0x83, 0x7C},
	{0x920B, 0x14, 0x1C},
	{0x0000, 0x83, 0x4C},
	{0x921F, 0x16, 0x2C},
	{0x0000, 0x83, 0x8C},
	{0x9235, 0x15, 0x2C},
	{0x0000, 0x83, 0x9C},
	{0x924A, 0x15, 0x2C},
	{0x0000, 0x83, 0xAC},
	{0x925F, 0x15, 0x2C},
	{0x0000, 0x83, 0xBC},
	{0x9274, 0x16, 0x2C},
	{0x0000, 0x83, 0xF4},
	{0x928A, 0x15, 0x2C},
	{0x0000, 0x83, 0xDC},
	{0x929F, 0x15, 0x2C},
	{0x0000, 0x83, 0xEC},
	{0x92B4, 0x14, 0x2C},
	{0x0000, 0x83, 0xCC},
	{0x92C8, 0x15, 0x2C},
	{0x0000, 0x83, 0x1C},
	{0x92DD, 0x15, 0x2C},
	{0x0000, 0x83, 0x3C},
	{0x92F2, 0x14, 0x2C},
	{0x0000, 0x83, 0x0C},
	{0x9306, 0x15, 0x2C},
	{0x0000, 0x83, 0x5C},
	{0x931B, 0x15, 0x2C},
	{0x0000, 0x83, 0x6C},
	{0x9330, 0x15, 0x2C},
	{0x0000, 0x83, 0x7C},
	{0x9345, 0x14, 0x2C},
	{0x0000, 0x83, 0x4C},
	{0x9359, 0x16, 0x3C},
	{0x0000, 0x83, 0x8C},
	{0x936F, 0x15, 0x3C},
	{0x0000, 0x83, 0x9C},
	{0x9384, 0x15, 0x3C},
	{0x0000, 0x83, 0xAC},
	{0x9399, 0x15, 0x3C},
	{0x0000, 0x83, 0xBC},
	{0x93AE, 0x16, 0x3C},
	{0x0000, 0x83, 0xF4},
	{0x93C4, 0x15, 0x3C},
	{0x0000, 0x83, 0xDC},
	{0x93D9, 0x15, 0x3C},
	{0x0000, 0x83, 0xEC},
	{0x93EE, 0x14, 0x3C},
	{0x0000, 0x83, 0xCC},
	{0x9402, 0x15, 0x3C},
	{0x0000, 0x83, 0x1C},
	{0x9417, 0x15, 0x3C},
	{0x0000, 0x83, 0x2C},
	{0x942C, 0x14, 0x3C},
	{0x0000, 0x83, 0x0C},
	{0x9440, 0x15, 0x3C},
	{0x0000, 0x83, 0x5C},
	{0x9455, 0x15, 0x3C},
	{0x0000, 0x83, 0x6C},
	{0x946A, 0x15, 0x3C},
	{0x0000, 0x83, 0x7C},
	{0x947F, 0x14, 0x3C},
	{0x0000, 0x83, 0x4C},
	{0x9493, 0x15, 0x0C},
	{0x0000, 0x83, 0x8C},
	{0x94A8, 0x14, 0x0C},
	{0x0000, 0x83, 0x9C},
	{0x94BC, 0x14, 0x0C},
	{0x0000, 0x83, 0xAC},
	{0x94D0, 0x14, 0x0C},
	{0x0000, 0x83, 0xBC},
	{0x94E4, 0x15, 0x0C},
	{0x0000, 0x83, 0xF4},
	{0x94F9, 0x14, 0x0C},
	{0x0000, 0x83, 0xDC},
	{0x950D, 0x14, 0x0C},
	{0x0000, 0x83, 0xEC},
	{0x9521, 0x13, 0x0C},
	{0x0000, 0x83, 0xCC},
	{0x9534, 0x14, 0x0C},
	{0x0000, 0x83, 0x1C},
	{0x9548, 0x14, 0x0C},
	{0x0000, 0x83, 0x2C},
	{0x955C, 0x14, 0x0C},
	{0x0000, 0x83, 0x3C},
	{0x9570, 0x14, 0x0C},
	{0x0000, 0x83, 0x5C},
	{0x9584, 0x14, 0x0C},
	{0x0000, 0x83, 0x6C},
	{0x9598, 0x14, 0x0C},
	{0x0000, 0x83, 0x7C},
	{0x95AC, 0x13, 0x0C},
	{0x0000, 0x83, 0x4C},
	{0x95BF, 0x16, 0x5C},
	{0x0000, 0x83, 0x8C},
	{0x95D5, 0x15, 0x5C},
	{0x0000, 0x83, 0x9C},
	{0x95EA, 0x15, 0x5C},
	{0x0000, 0x83, 0xAC},
	{0x95FF, 0x15, 0x5C},
	{0x0000, 0x83, 0xBC},
	{0x9614, 0x16, 0x5C},
	{0x0000, 0x83, 0xF4},
	{0x962A, 0x15, 0x5C},
	{0x0000, 0x83, 0xDC},
	{0x963F, 0x15, 0x5C},
	{0x0000, 0x83, 0xEC},
	{0x9654, 0x14, 0x5C},
	{0x0000, 0x83, 0xCC},
	{0x9668, 0x15, 0x5C},
	{0x0000, 0x83, 0x1C},
	{0x967D, 0x15, 0x5C},
	{0x0000, 0x83, 0x2C},
	{0x9692, 0x15, 0x5C},
	{0x0000, 0x83, 0x3C},
	{0x96A7, 0x14, 0x5C},
	{0x0000, 0x83, 0x0C},
	{0x96BB, 0x15, 0x5C},
	{0x0000, 0x83, 0x6C},
	{0x96D0, 0x15, 0x5C},
	{0x0000, 0x83, 0x7C},
	{0x96E5, 0x14, 0x5C},
	{0x0000, 0x83, 0x4C},
	{0x96F9, 0x16, 0x6C},
	{0x0000, 0x83, 0x8C},
	{0x970F, 0x15, 0x6C},
	{0x0000, 0x83, 0x9C},
	{0x9724, 0x15, 0x6C},
	{0x0000, 0x83, 0xAC},
	{0x9739, 0x15, 0x6C},
	{0x0000, 0x83, 0xBC},
	{0x974E, 0x16, 0x6C},
	{0x0000, 0x83, 0xF4},
	{0x9764, 0x15, 0x6C},
	{0x0000, 0x83, 0xDC},
	{0x9779, 0x15, 0x6C},
	{0x0000, 0x83, 0xEC},
	{0x978E, 0x14, 0x6C},
	{0x0000, 0x83, 0xCC},
	{0x97A2, 0x15, 0x6C},
	{0x0000, 0x83, 0x1C},
	{0x97B7, 0x15, 0x6C},
	{0x0000, 0x83, 0x2C},
	{0x97CC, 0x15, 0x6C},
	{0x0000, 0x83, 0x3C},
	{0x97E1, 0x14, 0x6C},
	{0x0000, 0x83, 0x0C},
	{0x97F5, 0x15, 0x6C},
	{0x0000, 0x83, 0x5C},
	{0x980A, 0x15, 0x6C},
	{0x0000, 0x83, 0x7C},
	{0x981F, 0x14, 0x6C},
	{0x0000, 0x83, 0x4C},
	{0x9833, 0x16, 0x7C},
	{0x0000, 0x83, 0x8C},
	{0x9849, 0x15, 0x7C},
	{0x0000, 0x83, 0x9C},
	{0x985E, 0x15, 0x7C},
	{0x0000, 0x83, 0xAC},
	{0x9873, 0x15, 0x7C},
	{0x0000, 0x83, 0xBC},
	{0x9888, 0x16, 0x7C},
	{0x0000, 0x83, 0xF4},
	{0x989E, 0x15, 0x7C},
	{0x0000, 0x83, 0xDC},
	{0x98B3, 0x15, 0x7C},
	{0x0000, 0x83, 0xEC},
	{0x98C8, 0x14, 0x7C},
	{0x0000, 0x83, 0xCC},
	{0x98DC, 0x15, 0x7C},
	{0x0000, 0x83, 0x1C},
	{0x98F1, 0x15, 0x7C},
	{0x0000, 0x83, 0x2C},
	{0x9906, 0x15, 0x7C},
	{0x0000, 0x83, 0x3C},
	{0x991B, 0x14, 0x7C},
	{0x0000, 0x83, 0x0C},
	{0x992F, 0x15, 0x7C},
	{0x0000, 0x83, 0x5C},
	{0x9944, 0x15, 0x7C},
	{0x0000, 0x83, 0x6C},
	{0x9959, 0x14, 0x7C},
	{0x0000, 0x83, 0x4C},
	{0x996D, 0x15, 0x4C},
	{0x0000, 0x83, 0x8C},
	{0x9982, 0x14, 0x4C},
	{0x0000, 0x83, 0x9C},
	{0x9996, 0x14, 0x4C},
	{0x0000, 0x83, 0xAC},
	{0x99AA, 0x14, 0x4C},
	{0x0000, 0x83, 0xBC},
	{0x99BE, 0x15, 0x4C},
	{0x0000, 0x83, 0xF4},
	{0x99D3, 0x14, 0x4C},
	{0x0000, 0x83, 0xDC},
	{0x99E7, 0x14, 0x4C},
	{0x0000, 0x83, 0xEC},
	{0x99FB, 0x13, 0x4C},
	{0x0000, 0x83, 0xCC},
	{0x9A0E, 0x14, 0x4C},
	{0x0000, 0x83, 0x1C},
	{0x9A22, 0x14, 0x4C},
	{0x0000, 0x83, 0x2C},
	{0x9A36, 0x14, 0x4C},
	{0x0000, 0x83, 0x3C},
	{0x9A4A, 0x13, 0x4C},
	{0x0000, 0x83, 0x0C},
	{0x9A5D, 0x14, 0x4C},
	{0x0000, 0x83, 0x5C},
	{0x9A71, 0x14, 0x4C},
	{0x0000, 0x83, 0x6C},
	{0x9A85, 0x14, 0x4C},
	{0x0000, 0x83, 0x7C},
	{0x9A99, 0x09, 0xC8},
	{0x0000, 0x83, 0xC8},
	{0x9AA2, 0x09, 0x08},
	{0x0000, 0x83, 0x08},
	{0x9AAB, 0x09, 0x48},
	{0x0000, 0x83, 0x48},
	{0x9AB4, 0x0A, 0xCC},
	{0x0000, 0x83, 0xCC},
	{0x9ABE, 0x0A, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x9AC8, 0x0A, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x9AD2, 0x0A, 0xD8},
	{0x0000, 0x83, 0xD8},
	{0x9ADC, 0x09, 0xC8},
	{0x0000, 0x83, 0xC8},
	{0x9AE5, 0x0A, 0x18},
	{0x0000, 0x83, 0x18},
	{0x9AEF, 0x09, 0x08},
	{0x0000, 0x83, 0x08},
	{0x9AF8, 0x0A, 0x58},
	{0x0000, 0x83, 0x58},
	{0x9B02, 0x09, 0x48},
	{0x0000, 0x83, 0x48},
	{0x9B0B, 0x0B, 0xDC},
	{0x0000, 0x83, 0xDC},
	{0x9B16, 0x0A, 0xCC},
	{0x0000, 0x83, 0xCC},
	{0x9B20, 0x0B, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x9B2B, 0x0A, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x9B35, 0x0B, 0x5C},
	{0x0000, 0x83, 0x5C},
	{0x9B40, 0x0A, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x9B4A, 0x0A, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9B54, 0x0A, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9B5E, 0x0A, 0xD8},
	{0x0000, 0x83, 0xD8},
	{0x9B68, 0x09, 0xC8},
	{0x0000, 0x83, 0xC8},
	{0x9B71, 0x0A, 0x18},
	{0x0000, 0x83, 0x18},
	{0x9B7B, 0x0A, 0x28},
	{0x0000, 0x83, 0x28},
	{0x9B85, 0x09, 0x08},
	{0x0000, 0x83, 0x08},
	{0x9B8E, 0x0A, 0x58},
	{0x0000, 0x83, 0x58},
	{0x9B98, 0x0A, 0x68},
	{0x0000, 0x83, 0x68},
	{0x9BA2, 0x09, 0x48},
	{0x0000, 0x83, 0x48},
	{0x9BAB, 0x0B, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9BB6, 0x0B, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9BC1, 0x0B, 0xDC},
	{0x0000, 0x83, 0xDC},
	{0x9BCC, 0x0A, 0xCC},
	{0x0000, 0x83, 0xCC},
	{0x9BD6, 0x0B, 0x1C},
	{0x0000, 0x83, 0x1C},
	{0x9BE1, 0x0B, 0x2C},
	{0x0000, 0x83, 0x2C},
	{0x9BEC, 0x0A, 0x0C},
	{0x0000, 0x83, 0x0C},
	{0x9BF6, 0x0B, 0x5C},
	{0x0000, 0x83, 0x5C},
	{0x9C01, 0x0B, 0x6C},
	{0x0000, 0x83, 0x6C},
	{0x9C0C, 0x0A, 0x4C},
	{0x0000, 0x83, 0x4C},
	{0x9C16, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x9C20, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x9C2A, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x9C33, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0x9C3D, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0x9C47, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0x9C50, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x9C5B, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x9C66, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x9C70, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0x9C7B, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0x9C86, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0x9C90, 0x0B, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9C9B, 0x0B, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9CA6, 0x0C, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9CB2, 0x0C, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9CBE, 0x0B, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9CC9, 0x0B, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9CD4, 0x0C, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9CE0, 0x0C, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9CEC, 0x0B, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9CF7, 0x0B, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9D02, 0x0C, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9D0E, 0x0C, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9D1A, 0x0B, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9D25, 0x0B, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9D30, 0x0C, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9D3C, 0x0C, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9D48, 0x08, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9D50, 0x08, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9D58, 0x08, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9D60, 0x09, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9D69, 0x09, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9D72, 0x09, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9D7B, 0x0A, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9D85, 0x0A, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9D8F, 0x0A, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9D99, 0x09, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9DA2, 0x09, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9DAB, 0x09, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9DB4, 0x0A, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9DBE, 0x0A, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9DC8, 0x0A, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9DD2, 0x09, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9DDB, 0x09, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9DE4, 0x09, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9DED, 0x0A, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9DF7, 0x0A, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9E01, 0x0A, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9E0B, 0x09, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9E14, 0x09, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9E1D, 0x09, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9E26, 0x0A, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9E30, 0x0A, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9E3A, 0x0A, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9E44, 0x0A, 0xA4},
	{0x0000, 0x83, 0xA4},
	{0x9E4E, 0x09, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9E57, 0x09, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9E60, 0x09, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9E69, 0x0A, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9E73, 0x0A, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9E7D, 0x0A, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9E87, 0x09, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9E90, 0x09, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9E99, 0x09, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9EA2, 0x09, 0x98},
	{0x0000, 0x83, 0x98},
	{0x9EAB, 0x09, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0x9EB4, 0x09, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0x9EBD, 0x0A, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0x9EC7, 0x0A, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0x9ED1, 0x0A, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0x9EDB, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0x9EE4, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0x9EED, 0x09, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0x9EF6, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0x9EFE, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x18},
	{0x9F07, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x28},
	{0x9F10, 0x09, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x38},
	{0x9F19, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x08},
	{0x9F21, 0x0A, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0x9F2B, 0x0A, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x34},
	{0x9F35, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0x9F3F, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0x9F49, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0x9F53, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0x9F5C, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x1C},
	{0x9F66, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x2C},
	{0x9F70, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x3C},
	{0x9F7A, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x0C},
	{0x9F83, 0x0B, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0x9F8E, 0x0B, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0x9F99, 0x0B, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0x9FA4, 0x0A, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0x9FAE, 0x0B, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0x9FB9, 0x0B, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0x9FC4, 0x0B, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0x9FCF, 0x0A, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0x9FD9, 0x0C, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0x9FE5, 0x0C, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x25},
	{0x9FF1, 0x11, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0xA002, 0x11, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0xA013, 0x11, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0xA024, 0x11, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0xA035, 0x11, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0xA046, 0x11, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0xA057, 0x0C, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0xA063, 0x0C, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0xA06F, 0x0C, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0xA07B, 0x0C, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0xA087, 0x0C, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0xA093, 0x0C, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0xA09F, 0x0C, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0xA0AB, 0x0C, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0xA0B7, 0x0C, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0xA0C3, 0x0B, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0xA0CE, 0x0C, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0xA0DA, 0x0C, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0xA0E6, 0x0C, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0xA0F2, 0x0B, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0xA0FD, 0x0B, 0x98},
	{0x0000, 0x83, 0x98},
	{0xA108, 0x0B, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0xA113, 0x0B, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0xA11E, 0x0B, 0x68},
	{0x0000, 0x83, 0x68},
	{0xA129, 0x0C, 0xB4},
	{0x0000, 0x83, 0xB4},
	{0xA135, 0x0C, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0xA141, 0x0C, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0xA14D, 0x0C, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0xA159, 0x0C, 0x6C},
	{0x0000, 0x83, 0x6C},
	{0xA165, 0x0C, 0xA4},
	{0x0000, 0x83, 0xA4},
	{0xA171, 0x0B, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xA17C, 0x0B, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xA187, 0x0B, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0xA192, 0x0C, 0xB4},
	{0x0000, 0x03, 0xB4},
	{0x0008, 0x83, 0xB4},
	{0xA19E, 0x0C, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xA1AA, 0x0C, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xA1B6, 0x0C, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xA1C2, 0x0C, 0xA4},
	{0x0000, 0x03, 0xA4},
	{0x0008, 0x83, 0xA4},
	{0xA1CE, 0x0B, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0xA1D9, 0x0B, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0xA1E4, 0x0B, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x03, 0x38},
	{0x000B, 0x83, 0x25},
	{0xA1EF, 0x0A, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x25},
	{0xA1F9, 0x0B, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x25},
	{0xA204, 0x0B, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x25},
	{0xA20F, 0x0B, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0x78},
	{0x000B, 0x83, 0x25},
	{0xA21A, 0x0A, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x25},
	{0xA224, 0x0C, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x34},
	{0x000B, 0x83, 0x25},
	{0xA230, 0x0C, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x03, 0x74},
	{0x000B, 0x83, 0x25},
	{0xA23C, 0x0C, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0xA248, 0x0C, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0xA254, 0x0C, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0xA260, 0x0B, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x25},
	{0xA26B, 0x0C, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0xA277, 0x0C, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0xA283, 0x0C, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0xA28F, 0x0B, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x25},
	{0xA29A, 0x10, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0xA2AA, 0x10, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0xA2BA, 0x10, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x3C},
	{0xA2CA, 0x10, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0xA2DA, 0x10, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0xA2EA, 0x10, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0xA2FA, 0x0B, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xA305, 0x0B, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xA310, 0x0B, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xA31B, 0x0B, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xA326, 0x0B, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xA331, 0x0B, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xA33C, 0x0E, 0x88},
	{0x0011, 0x06, 0x84},
	{0x0086, 0x05, 0x88},
	{0x004A, 0x87, 0x25},
	{0xA34A, 0x0D, 0x98},
	{0x0011, 0x06, 0x94},
	{0x0086, 0x05, 0x98},
	{0x004A, 0x87, 0x25},
	{0xA357, 0x0D, 0xA8},
	{0x0011, 0x06, 0xA4},
	{0x0086, 0x05, 0xA8},
	{0x004A, 0x87, 0x25},
	{0xA364, 0x0D, 0xB8},
	{0x0011, 0x06, 0xB4},
	{0x0086, 0x05, 0xB8},
	{0x004A, 0x87, 0x25},
	{0xA371, 0x0D, 0xD8},
	{0x0011, 0x06, 0xD4},
	{0x0086, 0x05, 0xD8},
	{0x004A, 0x87, 0x25},
	{0xA37E, 0x0D, 0xE8},
	{0x0011, 0x06, 0xE4},
	{0x0086, 0x05, 0xE8},
	{0x004A, 0x87, 0x25},
	{0xA38B, 0x0C, 0xC8},
	{0x0011, 0x06, 0xC4},
	{0x0086, 0x05, 0xC8},
	{0x004A, 0x87, 0x25},
	{0xA397, 0x0D, 0x18},
	{0x0011, 0x06, 0x14},
	{0x0086, 0x05, 0x18},
	{0x004A, 0x87, 0x25},
	{0xA3A4, 0x0D, 0x28},
	{0x0011, 0x06, 0x24},
	{0x0086, 0x05, 0x28},
	{0x004A, 0x87, 0x25},
	{0xA3B1, 0x0D, 0x38},
	{0x0011, 0x06, 0x34},
	{0x0086, 0x05, 0x38},
	{0x004A, 0x87, 0x25},
	{0xA3BE, 0x0C, 0x08},
	{0x0011, 0x06, 0x04},
	{0x0086, 0x05, 0x08},
	{0x004A, 0x87, 0x25},
	{0xA3CA, 0x0D, 0x58},
	{0x0011, 0x06, 0x54},
	{0x0086, 0x05, 0x58},
	{0x004A, 0x87, 0x25},
	{0xA3D7, 0x0D, 0x68},
	{0x0011, 0x06, 0x64},
	{0x0086, 0x05, 0x68},
	{0x004A, 0x87, 0x25},
	{0xA3E4, 0x0D, 0x78},
	{0x0011, 0x06, 0x74},
	{0x0086, 0x05, 0x78},
	{0x004A, 0x87, 0x25},
	{0xA3F1, 0x0C, 0x48},
	{0x0011, 0x06, 0x44},
	{0x0086, 0x05, 0x48},
	{0x004A, 0x87, 0x25},
	{0xA3FD, 0x0F, 0x8C},
	{0x0011, 0x06, 0x84},
	{0x0086, 0x05, 0x8C},
	{0x004A, 0x87, 0x25},
	{0xA40C, 0x0E, 0x9C},
	{0x0011, 0x06, 0x94},
	{0x0086, 0x05, 0x9C},
	{0x004A, 0x87, 0x25},
	{0xA41A, 0x0E, 0xAC},
	{0x0011, 0x06, 0xA4},
	{0x0086, 0x05, 0xAC},
	{0x004A, 0x87, 0x25},
	{0xA428, 0x0E, 0xBC},
	{0x0011, 0x06, 0xB4},
	{0x0086, 0x05, 0xBC},
	{0x004A, 0x87, 0x25},
	{0xA436, 0x0E, 0xDC},
	{0x0011, 0x06, 0xD4},
	{0x0086, 0x05, 0xDC},
	{0x004A, 0x87, 0x25},
	{0xA444, 0x0E, 0xEC},
	{0x0011, 0x06, 0xE4},
	{0x0086, 0x05, 0xEC},
	{0x004A, 0x87, 0x25},
	{0xA452, 0x0D, 0xCC},
	{0x0011, 0x06, 0xC4},
	{0x0086, 0x05, 0xCC},
	{0x004A, 0x87, 0x25},
	{0xA45F, 0x0E, 0x1C},
	{0x0011, 0x06, 0x14},
	{0x0086, 0x05, 0x1C},
	{0x004A, 0x87, 0x25},
	{0xA46D, 0x0E, 0x2C},
	{0x0011, 0x06, 0x24},
	{0x0086, 0x05, 0x2C},
	{0x004A, 0x87, 0x25},
	{0xA47B, 0x0E, 0x3C},
	{0x0011, 0x06, 0x34},
	{0x0086, 0x05, 0x3C},
	{0x004A, 0x87, 0x25},
	{0xA489, 0x0D, 0x0C},
	{0x0011, 0x06, 0x04},
	{0x0086, 0x05, 0x0C},
	{0x004A, 0x87, 0x25},
	{0xA496, 0x0E, 0x5C},
	{0x0011, 0x06, 0x54},
	{0x0086, 0x05, 0x5C},
	{0x004A, 0x87, 0x25},
	{0xA4A4, 0x0E, 0x6C},
	{0x0011, 0x06, 0x64},
	{0x0086, 0x05, 0x6C},
	{0x004A, 0x87, 0x25},
	{0xA4B2, 0x0E, 0x7C},
	{0x0011, 0x06, 0x74},
	{0x0086, 0x05, 0x7C},
	{0x004A, 0x87, 0x25},
	{0xA4C0, 0x0D, 0x4C},
	{0x0011, 0x06, 0x44},
	{0x0086, 0x05, 0x4C},
	{0x004A, 0x87, 0x25},
	{0xA4CD, 0x0B, 0x6C},
	{0x0017, 0x0B, 0x6C},
	{0x0022, 0x08, 0x64},
	{0x00A6, 0x84, 0x6C},
	{0xA4D8, 0x0A, 0x64},
	{0x0022, 0x88, 0x64},
	{0xA4E2, 0x0B, 0x6C},
	{0x0017, 0x0B, 0x6C},
	{0x0022, 0x08, 0x64},
	{0x00A6, 0x84, 0x6C},
	{0xA4ED, 0x0B, 0x6C},
	{0x0017, 0x0B, 0x6C},
	{0x0022, 0x08, 0x64},
	{0x00A6, 0x84, 0x6C},
	{0xA4F8, 0x0D, 0x6C},
	{0x008B, 0x06, 0x6C},
	{0x0099, 0x06, 0x6C},
	{0x009F, 0x87, 0x6C},
	{0xA505, 0x0D, 0x6C},
	{0x0077, 0x07, 0x6C},
	{0x0091, 0x88, 0x6C},
	{0xA512, 0x0E, 0x6C},
	{0x002A, 0x0B, 0x6C},
	{0x0017, 0x0B, 0x6C},
	{0x00A6, 0x84, 0x6C},
	{0xA520, 0x0D, 0x6C},
	{0x0017, 0x0B, 0x6C},
	{0x002A, 0x0B, 0x6C},
	{0x00A6, 0x84, 0x6C},
	{0xA52D, 0x0F, 0x6C},
	{0x008B, 0x06, 0x6C},
	{0x0099, 0x86, 0x6C},
	{0xA53C, 0x0F, 0x6C},
	{0x0077, 0x07, 0x6C},
	{0x009F, 0x07, 0x6C},
	{0x0091, 0x88, 0x6C},
	{0xA54B, 0x0E, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0xA559, 0x0D, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0xA566, 0x0F, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xA575, 0x0F, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0xA584, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0xA58E, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0xA598, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0xA5A2, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0xA5AB, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0xA5B5, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0xA5BF, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0xA5C9, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0xA5D2, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xA5DA, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xA5E2, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0xA5EA, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xA5F1, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x18},
	{0xA5F9, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x28},
	{0xA601, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x38},
	{0xA609, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x08},
	{0xA610, 0x0B, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0xA61B, 0x0B, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x25},
	{0xA626, 0x09, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0xA62F, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x34},
	{0xA638, 0x10, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0xA648, 0x10, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0xA658, 0x0F, 0x1C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0xA667, 0x10, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0xA677, 0x10, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0xA687, 0x0F, 0x5C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0xA696, 0x0B, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0xA6A1, 0x0B, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0xA6AC, 0x0A, 0x1C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0xA6B6, 0x0B, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0xA6C1, 0x0B, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0xA6CC, 0x0A, 0x5C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0xA6D6, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0xA6E1, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0xA6EC, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0xA6F7, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0xA701, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0xA70C, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0xA717, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0xA722, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0xA72C, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xA735, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xA73E, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xA747, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xA74F, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x1C},
	{0xA758, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x2C},
	{0xA761, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x3C},
	{0xA76A, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x0C},
	{0xA772, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x25},
	{0xA77C, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x25},
	{0xA786, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x25},
	{0xA790, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x25},
	{0xA799, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x25},
	{0xA7A3, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x25},
	{0xA7AD, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x25},
	{0xA7B7, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x25},
	{0xA7C0, 0x0B, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x25},
	{0xA7CB, 0x0B, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x25},
	{0xA7D6, 0x10, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0xA7E6, 0x10, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0xA7F6, 0x10, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0xA806, 0x10, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0xA816, 0x10, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0xA826, 0x10, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0xA836, 0x0B, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0xA841, 0x0B, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0xA84C, 0x0B, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0xA857, 0x0B, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0xA862, 0x0B, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0xA86D, 0x0B, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0xA878, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x25},
	{0xA883, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x25},
	{0xA88E, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x25},
	{0xA899, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x25},
	{0xA8A3, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x25},
	{0xA8AE, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x25},
	{0xA8B9, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x25},
	{0xA8C4, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x25},
	{0xA8CE, 0x0A, 0xE8},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x03, 0xE8},
	{0x000B, 0x83, 0x25},
	{0xA8D8, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0xA8E2, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0xA8EC, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x03, 0x38},
	{0x000B, 0x83, 0x25},
	{0xA8F6, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x25},
	{0xA8FF, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x25},
	{0xA909, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x25},
	{0xA913, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0x78},
	{0x000B, 0x83, 0x25},
	{0xA91D, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x25},
	{0xA926, 0x0B, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x34},
	{0x000B, 0x83, 0x25},
	{0xA931, 0x0B, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x03, 0x74},
	{0x000B, 0x83, 0x25},
	{0xA93C, 0x0B, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x03, 0xEC},
	{0x000B, 0x83, 0x25},
	{0xA947, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0xA952, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0xA95D, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0xA968, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x25},
	{0xA972, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0xA97D, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0xA988, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0xA993, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x25},
	{0xA99D, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0xA9AC, 0x0F, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0xA9BB, 0x0C, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0xA9C7, 0x0D, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x6C},
	{0x003A, 0x86, 0x25},
	{0xA9D4, 0x0D, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x6C},
	{0x003A, 0x86, 0x25},
	{0xA9E1, 0x0D, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x6C},
	{0x003A, 0x86, 0x25},
	{0xA9EE, 0x0D, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x03, 0x6C},
	{0x003A, 0x86, 0x25},
	{0xA9FB, 0x0D, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xAA08, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xAA12, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x18},
	{0xAA1C, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x28},
	{0xAA26, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x38},
	{0xAA30, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x08},
	{0xAA39, 0x0A, 0x44},
	{0x0000, 0x03, 0x44},
	{0x0008, 0x83, 0x04},
	{0xAA43, 0x0B, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x34},
	{0xAA4E, 0x0B, 0x54},
	{0x0000, 0x03, 0x54},
	{0x0008, 0x83, 0x14},
	{0xAA59, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x1C},
	{0xAA64, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x2C},
	{0xAA6F, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x3C},
	{0xAA7A, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x0C},
	{0xAA84, 0x0B, 0x64},
	{0x0000, 0x03, 0x64},
	{0x0008, 0x83, 0x24},
	{0xAA8F, 0x09, 0x98},
	{0x0000, 0x83, 0x98},
	{0xAA98, 0x09, 0xA8},
	{0x0000, 0x83, 0xA8},
	{0xAAA1, 0x09, 0xB8},
	{0x0000, 0x83, 0xB8},
	{0xAAAA, 0x0A, 0x9C},
	{0x0000, 0x83, 0x9C},
	{0xAAB4, 0x0A, 0xAC},
	{0x0000, 0x83, 0xAC},
	{0xAABE, 0x0A, 0xBC},
	{0x0000, 0x83, 0xBC},
	{0xAAC8, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0xAAD2, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0xAADC, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x03, 0x38},
	{0x000B, 0x83, 0x25},
	{0xAAE6, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x25},
	{0xAAEF, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x25},
	{0xAAF9, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x25},
	{0xAB03, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0x78},
	{0x000B, 0x83, 0x25},
	{0xAB0D, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x25},
	{0xAB16, 0x0B, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x34},
	{0x000B, 0x83, 0x25},
	{0xAB21, 0x0B, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x03, 0x74},
	{0x000B, 0x83, 0x25},
	{0xAB2C, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0xAB37, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0xAB42, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0xAB4D, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x25},
	{0xAB57, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0xAB62, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0xAB6D, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0xAB78, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x25},
	{0xAB82, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x18},
	{0x000B, 0x83, 0x25},
	{0xAB8C, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x28},
	{0x000B, 0x83, 0x25},
	{0xAB96, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x03, 0x38},
	{0x000B, 0x83, 0x25},
	{0xABA0, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x08},
	{0x000B, 0x83, 0x25},
	{0xABA9, 0x0A, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x58},
	{0x000B, 0x83, 0x25},
	{0xABB3, 0x0A, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x68},
	{0x000B, 0x83, 0x25},
	{0xABBD, 0x0A, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x03, 0x78},
	{0x000B, 0x83, 0x25},
	{0xABC7, 0x09, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x48},
	{0x000B, 0x83, 0x25},
	{0xABD0, 0x0B, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x03, 0x34},
	{0x000B, 0x83, 0x25},
	{0xABDB, 0x0B, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x03, 0x74},
	{0x000B, 0x83, 0x25},
	{0xABE6, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x25},
	{0xABF1, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x25},
	{0xABFC, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x25},
	{0xAC07, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x0C},
	{0x000B, 0x83, 0x25},
	{0xAC11, 0x0B, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x25},
	{0xAC1C, 0x0B, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x25},
	{0xAC27, 0x0B, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x25},
	{0xAC32, 0x0A, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x4C},
	{0x000B, 0x83, 0x25},
	{0xAC3C, 0x09, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0008, 0x83, 0x88},
	{0xAC45, 0x0C, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x89},
	{0xAC51, 0x0C, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8A},
	{0xAC5D, 0x0C, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0083, 0x83, 0x8B},
	{0xAC69, 0x08, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0008, 0x83, 0x98},
	{0xAC71, 0x0B, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x99},
	{0xAC7C, 0x0B, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9A},
	{0xAC87, 0x0B, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0083, 0x83, 0x9B},
	{0xAC92, 0x08, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0008, 0x83, 0xA8},
	{0xAC9A, 0x0B, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xA9},
	{0xACA5, 0x0B, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAA},
	{0xACB0, 0x0B, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0083, 0x83, 0xAB},
	{0xACBB, 0x08, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0008, 0x83, 0xB8},
	{0xACC3, 0x0B, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xB9},
	{0xACCE, 0x0B, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBA},
	{0xACD9, 0x0B, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0083, 0x83, 0xBB},
	{0xACE4, 0x0E, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0008, 0x03, 0x88},
	{0x0051, 0x86, 0x25},
	{0xACF2, 0x0D, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0008, 0x03, 0x98},
	{0x0051, 0x86, 0x25},
	{0xACFF, 0x0D, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0008, 0x03, 0xA8},
	{0x0051, 0x86, 0x25},
	{0xAD0C, 0x0D, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0008, 0x03, 0xB8},
	{0x0051, 0x86, 0x25},
	{0xAD19, 0x0D, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0008, 0x03, 0xD8},
	{0x0051, 0x86, 0x25},
	{0xAD26, 0x0D, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0008, 0x03, 0xE8},
	{0x0051, 0x86, 0x25},
	{0xAD33, 0x0C, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0008, 0x03, 0xC8},
	{0x0051, 0x86, 0x25},
	{0xAD3F, 0x0D, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0008, 0x03, 0x18},
	{0x0051, 0x86, 0x25},
	{0xAD4C, 0x0D, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0008, 0x03, 0x28},
	{0x0051, 0x86, 0x25},
	{0xAD59, 0x0D, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0008, 0x03, 0x38},
	{0x0051, 0x86, 0x25},
	{0xAD66, 0x0C, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0008, 0x03, 0x08},
	{0x0051, 0x86, 0x25},
	{0xAD72, 0x0D, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0008, 0x03, 0x58},
	{0x0051, 0x86, 0x25},
	{0xAD7F, 0x0D, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0008, 0x03, 0x68},
	{0x0051, 0x86, 0x25},
	{0xAD8C, 0x0D, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0008, 0x03, 0x78},
	{0x0051, 0x86, 0x25},
	{0xAD99, 0x0C, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0008, 0x03, 0x48},
	{0x0051, 0x86, 0x25},
	{0xADA5, 0x08, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0008, 0x83, 0xD8},
	{0xADAD, 0x0B, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xD9},
	{0xADB8, 0x0B, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDA},
	{0xADC3, 0x0B, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0083, 0x83, 0xDB},
	{0xADCE, 0x08, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0008, 0x83, 0xE8},
	{0xADD6, 0x0B, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xE9},
	{0xADE1, 0x0B, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xEA},
	{0xADEC, 0x0B, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0083, 0x83, 0xEB},
	{0xADF7, 0x07, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0008, 0x83, 0xC8},
	{0xADFE, 0x0A, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xC9},
	{0xAE08, 0x0A, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCA},
	{0xAE12, 0x0A, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0083, 0x83, 0xCB},
	{0xAE1C, 0x08, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0008, 0x83, 0x18},
	{0xAE24, 0x0B, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x19},
	{0xAE2F, 0x0B, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1A},
	{0xAE3A, 0x0B, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0083, 0x83, 0x1B},
	{0xAE45, 0x08, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0008, 0x83, 0x28},
	{0xAE4D, 0x0B, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x29},
	{0xAE58, 0x0B, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2A},
	{0xAE63, 0x0B, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0083, 0x83, 0x2B},
	{0xAE6E, 0x08, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0008, 0x83, 0x38},
	{0xAE76, 0x0B, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x39},
	{0xAE81, 0x0B, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3A},
	{0xAE8C, 0x0B, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0083, 0x83, 0x3B},
	{0xAE97, 0x07, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0008, 0x83, 0x08},
	{0xAE9E, 0x0A, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x09},
	{0xAEA8, 0x0A, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0A},
	{0xAEB2, 0x0A, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0083, 0x83, 0x0B},
	{0xAEBC, 0x08, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0008, 0x83, 0x58},
	{0xAEC4, 0x0B, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x59},
	{0xAECF, 0x0B, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5A},
	{0xAEDA, 0x0B, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0083, 0x83, 0x5B},
	{0xAEE5, 0x08, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0008, 0x83, 0x68},
	{0xAEED, 0x0B, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x69},
	{0xAEF8, 0x0B, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6A},
	{0xAF03, 0x0B, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0083, 0x83, 0x6B},
	{0xAF0E, 0x08, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0008, 0x83, 0x78},
	{0xAF16, 0x0B, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x79},
	{0xAF21, 0x0B, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7A},
	{0xAF2C, 0x0B, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0083, 0x83, 0x7B},
	{0xAF37, 0x07, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0008, 0x83, 0x48},
	{0xAF3E, 0x0A, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x49},
	{0xAF48, 0x0A, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4A},
	{0xAF52, 0x0A, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0083, 0x83, 0x4B},
	{0xAF5C, 0x0A, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0008, 0x83, 0x8C},
	{0xAF66, 0x0D, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8D},
	{0xAF73, 0x0D, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8E},
	{0xAF80, 0x0D, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0083, 0x83, 0x8F},
	{0xAF8D, 0x09, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0008, 0x83, 0x9C},
	{0xAF96, 0x0C, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9D},
	{0xAFA2, 0x0C, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9E},
	{0xAFAE, 0x0C, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0083, 0x83, 0x9F},
	{0xAFBA, 0x09, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0008, 0x83, 0xAC},
	{0xAFC3, 0x0C, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAD},
	{0xAFCF, 0x0C, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAE},
	{0xAFDB, 0x0C, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0083, 0x83, 0xAF},
	{0xAFE7, 0x09, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0008, 0x83, 0xBC},
	{0xAFF0, 0x0C, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBD},
	{0xAFFC, 0x0C, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBE},
	{0xB008, 0x0C, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0083, 0x83, 0xBF},
	{0xB014, 0x0F, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0008, 0x03, 0x8C},
	{0x0051, 0x86, 0x25},
	{0xB023, 0x0E, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0008, 0x03, 0x9C},
	{0x0051, 0x86, 0x25},
	{0xB031, 0x0E, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0008, 0x03, 0xAC},
	{0x0051, 0x86, 0x25},
	{0xB03F, 0x0E, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0008, 0x03, 0xBC},
	{0x0051, 0x86, 0x25},
	{0xB04D, 0x0E, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0008, 0x03, 0xDC},
	{0x0051, 0x86, 0x25},
	{0xB05B, 0x0E, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0008, 0x03, 0xEC},
	{0x0051, 0x86, 0x25},
	{0xB069, 0x0D, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0008, 0x03, 0xCC},
	{0x0051, 0x86, 0x25},
	{0xB076, 0x0E, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0008, 0x03, 0x1C},
	{0x0051, 0x86, 0x25},
	{0xB084, 0x0E, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0008, 0x03, 0x2C},
	{0x0051, 0x86, 0x25},
	{0xB092, 0x0E, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0008, 0x03, 0x3C},
	{0x0051, 0x86, 0x25},
	{0xB0A0, 0x0D, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0008, 0x03, 0x0C},
	{0x0051, 0x86, 0x25},
	{0xB0AD, 0x0E, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0008, 0x03, 0x5C},
	{0x0051, 0x86, 0x25},
	{0xB0BB, 0x0E, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0008, 0x03, 0x6C},
	{0x0051, 0x86, 0x25},
	{0xB0C9, 0x0E, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0008, 0x03, 0x7C},
	{0x0051, 0x86, 0x25},
	{0xB0D7, 0x0D, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0008, 0x03, 0x4C},
	{0x0051, 0x86, 0x25},
	{0xB0E4, 0x09, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0008, 0x83, 0xDC},
	{0xB0ED, 0x0C, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDD},
	{0xB0F9, 0x0C, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDE},
	{0xB105, 0x0C, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0083, 0x83, 0xDF},
	{0xB111, 0x09, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0008, 0x83, 0xEC},
	{0xB11A, 0x0C, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xED},
	{0xB126, 0x0C, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xEE},
	{0xB132, 0x0C, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0083, 0x83, 0xEF},
	{0xB13E, 0x08, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0008, 0x83, 0xCC},
	{0xB146, 0x0B, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCD},
	{0xB151, 0x0B, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCE},
	{0xB15C, 0x0B, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0083, 0x83, 0xCF},
	{0xB167, 0x09, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0008, 0x83, 0x1C},
	{0xB170, 0x0C, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1D},
	{0xB17C, 0x0C, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1E},
	{0xB188, 0x0C, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0083, 0x83, 0x1F},
	{0xB194, 0x09, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0008, 0x83, 0x2C},
	{0xB19D, 0x0C, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2D},
	{0xB1A9, 0x0C, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2E},
	{0xB1B5, 0x0C, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0083, 0x83, 0x2F},
	{0xB1C1, 0x09, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0008, 0x83, 0x3C},
	{0xB1CA, 0x0C, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3D},
	{0xB1D6, 0x0C, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3E},
	{0xB1E2, 0x0C, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0083, 0x83, 0x3F},
	{0xB1EE, 0x08, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0008, 0x83, 0x0C},
	{0xB1F6, 0x0B, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0D},
	{0xB201, 0x0B, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0E},
	{0xB20C, 0x0B, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0083, 0x83, 0x0F},
	{0xB217, 0x09, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0008, 0x83, 0x5C},
	{0xB220, 0x0C, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5D},
	{0xB22C, 0x0C, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5E},
	{0xB238, 0x0C, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0083, 0x83, 0x5F},
	{0xB244, 0x09, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0008, 0x83, 0x6C},
	{0xB24D, 0x0C, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6D},
	{0xB259, 0x0C, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6E},
	{0xB265, 0x0C, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0083, 0x83, 0x6F},
	{0xB271, 0x09, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0008, 0x83, 0x7C},
	{0xB27A, 0x0C, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7D},
	{0xB286, 0x0C, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7E},
	{0xB292, 0x0C, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0083, 0x83, 0x7F},
	{0xB29E, 0x08, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0008, 0x83, 0x4C},
	{0xB2A6, 0x0B, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4D},
	{0xB2B1, 0x0B, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4E},
	{0xB2BC, 0x0B, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0083, 0x83, 0x4F},
	{0xB2C7, 0x09, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x89},
	{0xB2D0, 0x08, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x99},
	{0xB2D8, 0x08, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xA9},
	{0xB2E0, 0x08, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xB9},
	{0xB2E8, 0x08, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xD9},
	{0xB2F0, 0x08, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xE9},
	{0xB2F8, 0x07, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xC9},
	{0xB2FF, 0x08, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x19},
	{0xB307, 0x08, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x29},
	{0xB30F, 0x08, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x39},
	{0xB317, 0x07, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x09},
	{0xB31E, 0x08, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x59},
	{0xB326, 0x08, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x69},
	{0xB32E, 0x08, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x79},
	{0xB336, 0x07, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x49},
	{0xB33D, 0x0A, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8D},
	{0xB347, 0x09, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9D},
	{0xB350, 0x09, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAD},
	{0xB359, 0x09, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBD},
	{0xB362, 0x09, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDD},
	{0xB36B, 0x09, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xED},
	{0xB374, 0x08, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCD},
	{0xB37C, 0x09, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1D},
	{0xB385, 0x09, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2D},
	{0xB38E, 0x09, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3D},
	{0xB397, 0x08, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0D},
	{0xB39F, 0x09, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5D},
	{0xB3A8, 0x09, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6D},
	{0xB3B1, 0x09, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7D},
	{0xB3BA, 0x08, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4D},
	{0xB3C2, 0x09, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8A},
	{0xB3CB, 0x08, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9A},
	{0xB3D3, 0x08, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAA},
	{0xB3DB, 0x08, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBA},
	{0xB3E3, 0x08, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDA},
	{0xB3EB, 0x08, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xEA},
	{0xB3F3, 0x07, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCA},
	{0xB3FA, 0x08, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1A},
	{0xB402, 0x08, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2A},
	{0xB40A, 0x08, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3A},
	{0xB412, 0x07, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0A},
	{0xB419, 0x08, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5A},
	{0xB421, 0x08, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6A},
	{0xB429, 0x08, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7A},
	{0xB431, 0x07, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4A},
	{0xB438, 0x0A, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8E},
	{0xB442, 0x09, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9E},
	{0xB44B, 0x09, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAE},
	{0xB454, 0x09, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBE},
	{0xB45D, 0x09, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDE},
	{0xB466, 0x09, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xEE},
	{0xB46F, 0x08, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCE},
	{0xB477, 0x09, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1E},
	{0xB480, 0x09, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2E},
	{0xB489, 0x09, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3E},
	{0xB492, 0x08, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0E},
	{0xB49A, 0x09, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5E},
	{0xB4A3, 0x09, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6E},
	{0xB4AC, 0x09, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7E},
	{0xB4B5, 0x08, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4E},
	{0xB4BD, 0x09, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8B},
	{0xB4C6, 0x08, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9B},
	{0xB4CE, 0x08, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAB},
	{0xB4D6, 0x08, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBB},
	{0xB4DE, 0x08, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDB},
	{0xB4E6, 0x08, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xEB},
	{0xB4EE, 0x07, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCB},
	{0xB4F5, 0x08, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1B},
	{0xB4FD, 0x08, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2B},
	{0xB505, 0x08, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3B},
	{0xB50D, 0x07, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0B},
	{0xB514, 0x08, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5B},
	{0xB51C, 0x08, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6B},
	{0xB524, 0x08, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7B},
	{0xB52C, 0x07, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4B},
	{0xB533, 0x0A, 0xF0},
	{0x0000, 0x03, 0x86},
	{0x0081, 0x85, 0x8F},
	{0xB53D, 0x09, 0xF0},
	{0x0000, 0x03, 0x96},
	{0x0081, 0x85, 0x9F},
	{0xB546, 0x09, 0xF0},
	{0x0000, 0x03, 0xA6},
	{0x0081, 0x85, 0xAF},
	{0xB54F, 0x09, 0xF0},
	{0x0000, 0x03, 0xB6},
	{0x0081, 0x85, 0xBF},
	{0xB558, 0x09, 0xF0},
	{0x0000, 0x03, 0xD6},
	{0x0081, 0x85, 0xDF},
	{0xB561, 0x09, 0xF0},
	{0x0000, 0x03, 0xE6},
	{0x0081, 0x85, 0xEF},
	{0xB56A, 0x08, 0xF0},
	{0x0000, 0x03, 0xC6},
	{0x0081, 0x85, 0xCF},
	{0xB572, 0x09, 0xF0},
	{0x0000, 0x03, 0x16},
	{0x0081, 0x85, 0x1F},
	{0xB57B, 0x09, 0xF0},
	{0x0000, 0x03, 0x26},
	{0x0081, 0x85, 0x2F},
	{0xB584, 0x09, 0xF0},
	{0x0000, 0x03, 0x36},
	{0x0081, 0x85, 0x3F},
	{0xB58D, 0x08, 0xF0},
	{0x0000, 0x03, 0x06},
	{0x0081, 0x85, 0x0F},
	{0xB595, 0x09, 0xF0},
	{0x0000, 0x03, 0x56},
	{0x0081, 0x85, 0x5F},
	{0xB59E, 0x09, 0xF0},
	{0x0000, 0x03, 0x66},
	{0x0081, 0x85, 0x6F},
	{0xB5A7, 0x09, 0xF0},
	{0x0000, 0x03, 0x76},
	{0x0081, 0x85, 0x7F},
	{0xB5B0, 0x08, 0xF0},
	{0x0000, 0x03, 0x46},
	{0x0081, 0x85, 0x4F},
	{0xB5B8, 0x0A, 0xF0},
	{0x0065, 0x05, 0xF6},
	{0x0081, 0x85, 0xF4},
	{0xB5C2, 0x08, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xB5CA, 0x08, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xB5D2, 0x08, 0xB8},
	{0x0000, 0x03, 0xB8},
	{0x0008, 0x83, 0xB8},
	{0xB5DA, 0x08, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xB5E2, 0x08, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xB5EA, 0x08, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0xB5F2, 0x07, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xB5F9, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xB601, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xB609, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0xB611, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xB618, 0x09, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0xB621, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0xB62A, 0x0F, 0x0C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x1C},
	{0x000B, 0x83, 0x1C},
	{0xB639, 0x0F, 0x1C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x03, 0x2C},
	{0x000B, 0x83, 0x2C},
	{0xB648, 0x0F, 0x2C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x03, 0x3C},
	{0x000B, 0x83, 0x3C},
	{0xB657, 0x0F, 0x4C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x5C},
	{0x000B, 0x83, 0x5C},
	{0xB666, 0x0F, 0x5C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x03, 0x6C},
	{0x000B, 0x83, 0x6C},
	{0xB675, 0x0F, 0x6C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x03, 0x7C},
	{0x000B, 0x83, 0x7C},
	{0xB684, 0x0A, 0x08},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xB68E, 0x0A, 0x18},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xB698, 0x0A, 0x28},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xB6A2, 0x0A, 0x48},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xB6AC, 0x0A, 0x58},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xB6B6, 0x0A, 0x68},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xB6C0, 0x0E, 0x2C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xB6CE, 0x0E, 0x3C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xB6DC, 0x0D, 0x1C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xB6E9, 0x0E, 0x6C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xB6F7, 0x0E, 0x7C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xB705, 0x0D, 0x5C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xB712, 0x09, 0x2C},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xB71B, 0x09, 0x3C},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xB724, 0x08, 0x1C},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xB72C, 0x09, 0x6C},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xB735, 0x09, 0x7C},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xB73E, 0x08, 0x5C},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xB746, 0x09, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xB74F, 0x09, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xB758, 0x09, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xB761, 0x09, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xB76A, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xB773, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xB77C, 0x08, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xB784, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xB78D, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xB796, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xB79F, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xB7A7, 0x0E, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x1C},
	{0xB7B5, 0x0E, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x2C},
	{0xB7C3, 0x0D, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x0C},
	{0xB7D0, 0x0E, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x5C},
	{0xB7DE, 0x0E, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x6C},
	{0xB7EC, 0x0D, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x4C},
	{0xB7F9, 0x09, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x18},
	{0xB802, 0x09, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x28},
	{0xB80B, 0x08, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x08},
	{0xB813, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x58},
	{0xB81C, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x68},
	{0xB825, 0x08, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x48},
	{0xB82D, 0x0F, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x48},
	{0x004A, 0x87, 0x25},
	{0xB83C, 0x10, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x03, 0x4C},
	{0x004A, 0x87, 0x25},
	{0xB84C, 0x10, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x48},
	{0x004A, 0x87, 0x25},
	{0xB85C, 0x11, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x03, 0x4C},
	{0x004A, 0x87, 0x25},
	{0xB86D, 0x08, 0xC8},
	{0x0072, 0x05, 0xC8},
	{0x0035, 0x85, 0x48},
	{0xB875, 0x08, 0x08},
	{0x0072, 0x05, 0x08},
	{0x0035, 0x85, 0x08},
	{0xB87D, 0x08, 0x48},
	{0x0072, 0x05, 0x48},
	{0x0035, 0x85, 0x48},
	{0xB885, 0x08, 0xC8},
	{0x0072, 0x05, 0xC9},
	{0x0035, 0x85, 0x48},
	{0xB88D, 0x08, 0x08},
	{0x0072, 0x05, 0x09},
	{0x0035, 0x85, 0x08},
	{0xB895, 0x08, 0x48},
	{0x0072, 0x05, 0x49},
	{0x0035, 0x85, 0x48},
	{0xB89D, 0x08, 0xC8},
	{0x0072, 0x05, 0xCA},
	{0x0035, 0x85, 0x48},
	{0xB8A5, 0x08, 0x08},
	{0x0072, 0x05, 0x0A},
	{0x0035, 0x85, 0x08},
	{0xB8AD, 0x08, 0x48},
	{0x0072, 0x05, 0x4A},
	{0x0035, 0x85, 0x48},
	{0xB8B5, 0x08, 0xC8},
	{0x0072, 0x05, 0xCB},
	{0x0035, 0x85, 0x48},
	{0xB8BD, 0x08, 0x08},
	{0x0072, 0x05, 0x0B},
	{0x0035, 0x85, 0x08},
	{0xB8C5, 0x08, 0x48},
	{0x0072, 0x05, 0x4B},
	{0x0035, 0x85, 0x48},
	{0xB8CD, 0x08, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xC8},
	{0x0035, 0x85, 0x48},
	{0xB8D5, 0x08, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x08},
	{0x0035, 0x85, 0x08},
	{0xB8DD, 0x08, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x48},
	{0x0035, 0x85, 0x48},
	{0xB8E5, 0x08, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xC9},
	{0x0035, 0x85, 0x48},
	{0xB8ED, 0x08, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x09},
	{0x0035, 0x85, 0x08},
	{0xB8F5, 0x08, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x49},
	{0x0035, 0x85, 0x48},
	{0xB8FD, 0x08, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xCA},
	{0x0035, 0x85, 0x48},
	{0xB905, 0x08, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x0A},
	{0x0035, 0x85, 0x08},
	{0xB90D, 0x08, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x4A},
	{0x0035, 0x85, 0x48},
	{0xB915, 0x08, 0xC8},
	{0x006A, 0x03, 0xC8},
	{0x0072, 0x05, 0xCB},
	{0x0035, 0x85, 0x48},
	{0xB91D, 0x08, 0x08},
	{0x006A, 0x03, 0x08},
	{0x0072, 0x05, 0x0B},
	{0x0035, 0x85, 0x08},
	{0xB925, 0x08, 0x48},
	{0x006A, 0x03, 0x48},
	{0x0072, 0x05, 0x4B},
	{0x0035, 0x85, 0x48},
	{0xB92D, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xB936, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xB93F, 0x09, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xB948, 0x08, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xB950, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xB959, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xB962, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xB96A, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xB973, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xB97C, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xB984, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xB98E, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xB998, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xB9A2, 0x0A, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xB9AC, 0x0A, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0xB9B6, 0x09, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xB9BF, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xB9C9, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xB9D3, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xB9DD, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xB9E6, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xB9F0, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xB9FA, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xBA04, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xBA0D, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xBA16, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xBA1F, 0x09, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xBA28, 0x08, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xBA30, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xBA39, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xBA42, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xBA4A, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xBA53, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xBA5C, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xBA64, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xBA6E, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xBA78, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xBA82, 0x0A, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xBA8C, 0x0A, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0xBA96, 0x09, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xBA9F, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xBAA9, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xBAB3, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xBABD, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xBAC6, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xBAD0, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xBADA, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xBAE4, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xBAED, 0x08, 0x99},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xBAF5, 0x08, 0xA9},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xBAFD, 0x08, 0xD9},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xBB05, 0x07, 0xC9},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xBB0C, 0x08, 0x19},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xBB14, 0x08, 0x29},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xBB1C, 0x07, 0x09},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xBB23, 0x08, 0x59},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xBB2B, 0x08, 0x69},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xBB33, 0x07, 0x49},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xBB3A, 0x09, 0x9D},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xBB43, 0x09, 0xAD},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xBB4C, 0x09, 0xDD},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xBB55, 0x08, 0xCD},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xBB5D, 0x09, 0x1D},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xBB66, 0x09, 0x2D},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xBB6F, 0x08, 0x0D},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xBB77, 0x09, 0x5D},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xBB80, 0x09, 0x6D},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xBB89, 0x08, 0x4D},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xBB91, 0x08, 0x58},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xBB99, 0x08, 0x78},
	{0x0000, 0x03, 0xE8},
	{0x0008, 0x83, 0xE8},
	{0xBBA1, 0x07, 0x48},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xBBA8, 0x08, 0x58},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xBBB0, 0x08, 0x68},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xBBB8, 0x08, 0x78},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x38},
	{0xBBC0, 0x07, 0x48},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xBBC7, 0x08, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xBBCF, 0x08, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xBBD7, 0x08, 0x78},
	{0x0000, 0x03, 0x78},
	{0x0008, 0x83, 0x78},
	{0xBBDF, 0x07, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xBBE6, 0x09, 0x74},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x34},
	{0xBBEF, 0x09, 0x74},
	{0x0000, 0x03, 0x74},
	{0x0008, 0x83, 0x74},
	{0xBBF8, 0x09, 0x5C},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xBC01, 0x09, 0x7C},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0xBC0A, 0x08, 0x4C},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xBC12, 0x09, 0x5C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xBC1B, 0x09, 0x6C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xBC24, 0x09, 0x7C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xBC2D, 0x08, 0x4C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xBC35, 0x09, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xBC3E, 0x09, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xBC47, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xBC50, 0x08, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xBC58, 0x0A, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x58},
	{0xBC62, 0x0A, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x68},
	{0xBC6C, 0x0A, 0x38},
	{0x0000, 0x03, 0x38},
	{0x0008, 0x83, 0x78},
	{0xBC76, 0x09, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x48},
	{0xBC7F, 0x0A, 0x04},
	{0x0000, 0x03, 0x04},
	{0x0008, 0x83, 0x44},
	{0xBC89, 0x0B, 0x34},
	{0x0000, 0x03, 0x34},
	{0x0008, 0x83, 0x74},
	{0xBC94, 0x0B, 0x14},
	{0x0000, 0x03, 0x14},
	{0x0008, 0x83, 0x54},
	{0xBC9F, 0x0B, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x5C},
	{0xBCAA, 0x0B, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x6C},
	{0xBCB5, 0x0B, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x7C},
	{0xBCC0, 0x0A, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x4C},
	{0xBCCA, 0x0B, 0x24},
	{0x0000, 0x03, 0x24},
	{0x0008, 0x83, 0x64},
	{0xBCD5, 0x0F, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x08},
	{0x004A, 0x87, 0x25},
	{0xBCE4, 0x10, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x03, 0x0C},
	{0x004A, 0x87, 0x25},
	{0xBCF4, 0x0A, 0x28},
	{0x006A, 0x03, 0x28},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x08},
	{0xBCFE, 0x10, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x08},
	{0x004A, 0x87, 0x25},
	{0xBD0E, 0x11, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x03, 0x0C},
	{0x004A, 0x87, 0x25},
	{0xBD1F, 0x0B, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x0C},
	{0xBD2A, 0x0C, 0x2C},
	{0x006A, 0x03, 0x2C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x0C},
	{0xBD36, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xBD3F, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xBD48, 0x09, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xBD51, 0x08, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xBD59, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xBD62, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xBD6B, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xBD73, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xBD7C, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xBD85, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xBD8D, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xBD97, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xBDA1, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xBDAB, 0x0A, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xBDB5, 0x0A, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0xBDBF, 0x09, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xBDC8, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xBDD2, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xBDDC, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xBDE6, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xBDEF, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xBDF9, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xBE03, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xBE0D, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xBE16, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xBE1F, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xBE28, 0x09, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xBE31, 0x08, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xBE39, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xBE42, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xBE4B, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xBE53, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xBE5C, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xBE65, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xBE6D, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xBE77, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xBE81, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xBE8B, 0x0A, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xBE95, 0x0A, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0xBE9F, 0x09, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xBEA8, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xBEB2, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xBEBC, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xBEC6, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xBECF, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xBED9, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xBEE3, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xBEED, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xBEF6, 0x09, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x03, 0x7C},
	{0x00AE, 0x84, 0x25},
	{0xBEFF, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xBF08, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xBF11, 0x09, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xBF1A, 0x08, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xBF22, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xBF2B, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xBF34, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xBF3C, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xBF45, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xBF4E, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xBF56, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xBF60, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xBF6A, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xBF74, 0x0A, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xBF7E, 0x0A, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0xBF88, 0x09, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xBF91, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xBF9B, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xBFA5, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xBFAF, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xBFB8, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xBFC2, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xBFCC, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xBFD6, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
	{0xBFDF, 0x09, 0x98},
	{0x0000, 0x03, 0x98},
	{0x0008, 0x83, 0x98},
	{0xBFE8, 0x09, 0xA8},
	{0x0000, 0x03, 0xA8},
	{0x0008, 0x83, 0xA8},
	{0xBFF1, 0x09, 0xD8},
	{0x0000, 0x03, 0xD8},
	{0x0008, 0x83, 0xD8},
	{0xBFFA, 0x08, 0xC8},
	{0x0000, 0x03, 0xC8},
	{0x0008, 0x83, 0xC8},
	{0xC002, 0x09, 0x18},
	{0x0000, 0x03, 0x18},
	{0x0008, 0x83, 0x18},
	{0xC00B, 0x09, 0x28},
	{0x0000, 0x03, 0x28},
	{0x0008, 0x83, 0x28},
	{0xC014, 0x08, 0x08},
	{0x0000, 0x03, 0x08},
	{0x0008, 0x83, 0x08},
	{0xC01C, 0x09, 0x58},
	{0x0000, 0x03, 0x58},
	{0x0008, 0x83, 0x58},
	{0xC025, 0x09, 0x68},
	{0x0000, 0x03, 0x68},
	{0x0008, 0x83, 0x68},
	{0xC02E, 0x08, 0x48},
	{0x0000, 0x03, 0x48},
	{0x0008, 0x83, 0x48},
	{0xC036, 0x0A, 0x9C},
	{0x0000, 0x03, 0x9C},
	{0x0008, 0x83, 0x9C},
	{0xC040, 0x0A, 0xAC},
	{0x0000, 0x03, 0xAC},
	{0x0008, 0x83, 0xAC},
	{0xC04A, 0x0A, 0xBC},
	{0x0000, 0x03, 0xBC},
	{0x0008, 0x83, 0xBC},
	{0xC054, 0x0A, 0xDC},
	{0x0000, 0x03, 0xDC},
	{0x0008, 0x83, 0xDC},
	{0xC05E, 0x0A, 0xEC},
	{0x0000, 0x03, 0xEC},
	{0x0008, 0x83, 0xEC},
	{0xC068, 0x09, 0xCC},
	{0x0000, 0x03, 0xCC},
	{0x0008, 0x83, 0xCC},
	{0xC071, 0x0A, 0x1C},
	{0x0000, 0x03, 0x1C},
	{0x0008, 0x83, 0x1C},
	{0xC07B, 0x0A, 0x2C},
	{0x0000, 0x03, 0x2C},
	{0x0008, 0x83, 0x2C},
	{0xC085, 0x0A, 0x3C},
	{0x0000, 0x03, 0x3C},
	{0x0008, 0x83, 0x3C},
	{0xC08F, 0x09, 0x0C},
	{0x0000, 0x03, 0x0C},
	{0x0008, 0x83, 0x0C},
	{0xC098, 0x0A, 0x5C},
	{0x0000, 0x03, 0x5C},
	{0x0008, 0x83, 0x5C},
	{0xC0A2, 0x0A, 0x6C},
	{0x0000, 0x03, 0x6C},
	{0x0008, 0x83, 0x6C},
	{0xC0AC, 0x0A, 0x7C},
	{0x0000, 0x03, 0x7C},
	{0x0008, 0x83, 0x7C},
	{0xC0B6, 0x09, 0x4C},
	{0x0000, 0x03, 0x4C},
	{0x0008, 0x83, 0x4C},
}

var hashTable = [8192]uint16{
	0x0005: 0x1DF5,
	0x0007: 0x1AA2,
	0x000C: 0x1CF3,
	0x000D: 0x1D53,
	0x000F: 0x173C,
	0x0019: 0x219E,
	0x001A: 0x126B,
	0x001B: 0x292E,
	0x001C: 0x1B57,
	0x001D: 0x2A12,
	0x001E: 0x280D,
	0x001F: 0x1AA8,
	0x0020: 0x094F,
	0x0023: 0x020D,
	0x0024: 0x1FC0,
	0x0027: 0x0019,
	0x0029: 0x1F86,
	0x002B: 0x0CCE,
	0x002C: 0x260C,
	0x002D: 0x1F34,
	0x002E: 0x1593,
	0x0030: 0x1BC3,
	0x0032: 0x0E0B,
	0x0033: 0x0145,
	0x0034: 0x145B,
	0x0035: 0x24AA,
	0x0041: 0x01D3,
	0x0045: 0x2010,
	0x004B: 0x05B8,
	0x004E: 0x03C3,
	0x004F: 0x1D0E,
	0x0054: 0x0570,
	0x0055: 0x179F,
	0x0056: 0x21E8,
	0x0059: 0x0C67,
	0x005B: 0x1B0D,
	0x005F: 0x0D3D,
	0x0060: 0x120F,
	0x0061: 0x1F0C,
	0x0062: 0x0410,
	0x0063: 0x1E79,
	0x0064: 0x2C24,
	0x0067: 0x2B2F,
	0x006A: 0x196A,
	0x006B: 0x0DDB,
	0x006D: 0x1095,
	0x006E: 0x2568,
	0x0072: 0x0D2F,
	0x0073: 0x15C2,
	0x0074: 0x2110,
	0x0078: 0x1B4F,
	0x007A: 0x0D7E,
	0x007B: 0x042C,
	0x0085: 0x23EE,
	0x0086: 0x1706,
	0x0087: 0x0C15,
	0x0088: 0x107B,
	0x0089: 0x1E01,
	0x0092: 0x032D,
	0x0093: 0x201E,
	0x0095: 0x08B5,
	0x0097: 0x06DA,
	0x009E: 0x0BB5,
	0x00A0: 0x08F3,
	0x00A1: 0x210A,
	0x00A7: 0x2A30,
	0x00A8: 0x0988,
	0x00AB: 0x0267,
	0x00AC: 0x1FDA,
	0x00B0: 0x1047,
	0x00B2: 0x059D,
	0x00B3: 0x062F,
	0x00B4: 0x199D,
	0x00B5: 0x2378,
	0x00B9: 0x0560,
	0x00BA: 0x2474,
	0x00BB: 0x0E44,
	0x00BC: 0x20B2,
	0x00BD: 0x12DB,
	0x00BE: 0x1330,
	0x00C7: 0x0539,
	0x00C8: 0x178A,
	0x00CD: 0x25A3,
	0x00CF: 0x1577,
	0x00D0: 0x10F5,
	0x00D1: 0x11F3,
	0x00D2: 0x10C1,
	0x00D3: 0x057E,
	0x00D4: 0x0B3D,
	0x00D5: 0x1948,
	0x00D6: 0x21D2,
	0x00D7: 0x2BD8,
	0x00D8: 0x16CD,
	0x00DA: 0x1F47,
	0x00DB: 0x2044,
	0x00E0: 0x0BA5,
	0x00E1: 0x1FF6,
	0x00E2: 0x223E,
	0x00E3: 0x07AF,
	0x00E6: 0x087D,
	0x00E8: 0x1FEC,
	0x00E9: 0x106D,
	0x00EA: 0x1885,
	0x00EB: 0x2016,
	0x00EF: 0x2949,
	0x00F1: 0x2741,
	0x00F2: 0x1859,
	0x00F3: 0x1930,
	0x00F4: 0x2A6F,
	0x00F9: 0x28B3,
	0x00FA: 0x1D4D,
	0x00FB: 0x205A,
	0x0101: 0x1189,
	0x0102: 0x0E87,
	0x0103: 0x1E52,
	0x0104: 0x2B3E,
	0x0105: 0x0CEA,
	0x0106: 0x1F62,
	0x010A: 0x026C,
	0x010B: 0x0B3F,
	0x010C: 0x0B27,
	0x010D: 0x1A18,
	0x010E: 0x1E8B,
	0x0111: 0x179B,
	0x0112: 0x27F6,
	0x0113: 0x1349,
	0x0114: 0x2AD8,
	0x0115: 0x017B,
	0x0119: 0x2856,
	0x011C: 0x0D06,
	0x011E: 0x180B,
	0x012E: 0x1F2E,
	0x012F: 0x27E7,
	0x0130: 0x0D79,
	0x0131: 0x1563,
	0x0132: 0x06F2,
	0x0137: 0x2CCC,
	0x013A: 0x2C39,
	0x013C: 0x1591,
	0x013D: 0x1456,
	0x013E: 0x257A,
	0x013F: 0x1A9B,
	0x0144: 0x2D94,
	0x0146: 0x0DA1,
	0x0147: 0x0E97,
	0x0148: 0x10F7,
	0x014B: 0x172B,
	0x014D: 0x10EB,
	0x0153: 0x10D7,
	0x0154: 0x0A8F,
	0x0157: 0x0F21,
	0x015D: 0x0A6D,
	0x015E: 0x016F,
	0x0162: 0x04E1,
	0x0163: 0x0F63,
	0x0164: 0x239A,
	0x0165: 0x208C,
	0x0168: 0x247A,
	0x0169: 0x1FE2,
	0x016C: 0x090B,
	0x016E: 0x18C4,
	0x0171: 0x2BA6,
	0x0172: 0x0100,
	0x0173: 0x0ACE,
	0x0174: 0x1654,
	0x0175: 0x214E,
	0x0176: 0x1123,
	0x0177: 0x0859,
	0x0178: 0x1DF2,
	0x0179: 0x2D6D,
	0x017F: 0x2268,
	0x0180: 0x2448,
	0x0182: 0x2706,
	0x0183: 0x0DBD,
	0x0185: 0x1AF9,
	0x0186: 0x20EA,
	0x0188: 0x019C,
	0x0192: 0x0911,
	0x0194: 0x1D5C,
	0x0198: 0x1249,
	0x0199: 0x0D6A,
	0x019A: 0x007C,
	0x019B: 0x2C5A,
	0x019E: 0x2B4D,
	0x019F: 0x08A6,
	0x01A1: 0x1F12,
	0x01A2: 0x206C,
	0x01A3: 0x0F17,
	0x01A5: 0x1269,
	0x01A6: 0x01B2,
	0x01AB: 0x20F0,
	0x01AD: 0x0486,
	0x01B2: 0x21C6,
	0x01B4: 0x2CE7,
	0x01B6: 0x1ACF,
	0x01B8: 0x03C6,
	0x01B9: 0x0213,
	0x01BA: 0x0BF1,
	0x01BB: 0x2615,
	0x01BF: 0x099D,
	0x01C0: 0x0C5F,
	0x01C1: 0x1C4A,
	0x01C3: 0x06CD,
	0x01C9: 0x0A6F,
	0x01CE: 0x0A7D,
	0x01CF: 0x22DC,
	0x01D1: 0x0548,
	0x01D2: 0x10D9,
	0x01D4: 0x153F,
	0x01D5: 0x1A93,
	0x01D6: 0x2A39,
	0x01D8: 0x1940,
	0x01DC: 0x1B22,
	0x01DD: 0x272A,
	0x01DF: 0x1321,
	0x01E1: 0x134D,
	0x01E6: 0x1CE4,
	0x01E9: 0x0527,
	0x01ED: 0x0CBB,
	0x01EE: 0x1AAF,
	0x01EF: 0x0B22,
	0x01F2: 0x04CF,
	0x01F3: 0x14DD,
	0x01F4: 0x0C95,
	0x01F6: 0x22E2,
	0x0202: 0x16E1,
	0x0203: 0x1DEB,
	0x0204: 0x14D5,
	0x0207: 0x0A04,
	0x020C: 0x0935,
	0x020F: 0x119B,
	0x0210: 0x2958,
	0x0211: 0x2CAB,
	0x0213: 0x189B,
	0x0216: 0x0877,
	0x0217: 0x1019,
	0x0218: 0x1AF6,
	0x0219: 0x2066,
	0x021A: 0x0E23,
	0x021B: 0x0336,
	0x0220: 0x01F0,
	0x0221: 0x12B1,
	0x0223: 0x1F09,
	0x0225: 0x089C,
	0x0226: 0x0566,
	0x0227: 0x0F45,
	0x0228: 0x11A4,
	0x0229: 0x2BC4,
	0x022A: 0x0F47,
	0x022C: 0x128C,
	0x022D: 0x1A7E,
	0x022E: 0x2046,
	0x022F: 0x1E46,
	0x0230: 0x0907,
	0x0231: 0x0D2A,
	0x0232: 0x2C75,
	0x0233: 0x207C,
	0x0234: 0x2D1E,
	0x0235: 0x1991,
	0x0237: 0x2769,
	0x023C: 0x2DB8,
	0x023F: 0x1C23,
	0x0240: 0x297F,
	0x0241: 0x0175,
	0x0242: 0x039C,
	0x0243: 0x2825,
	0x0245: 0x18FC,
	0x024B: 0x2C6F,
	0x024C: 0x05DF,
	0x024D: 0x2D5B,
	0x0250: 0x0061,
	0x0253: 0x2E49,
	0x0257: 0x0B52,
	0x0258: 0x0BBD,
	0x0259: 0x06AD,
	0x025A: 0x08B8,
	0x025B: 0x17EA,
	0x025C: 0x2104,
	0x0260: 0x2811,
	0x0261: 0x0692,
	0x0263: 0x2052,
	0x026A: 0x247D,
	0x026B: 0x213A,
	0x026F: 0x2036,
	0x0271: 0x18D7,
	0x0273: 0x1397,
	0x0274: 0x2DE6,
	0x0277: 0x1AD2,
	0x027C: 0x0FCB,
	0x027F: 0x0F25,
	0x0285: 0x222C,
	0x0286: 0x22AE,
	0x0289: 0x0787,
	0x028D: 0x1460,
	0x028E: 0x1942,
	0x0291: 0x27A1,
	0x0292: 0x2202,
	0x0299: 0x0BD1,
	0x029D: 0x1D3B,
	0x02A1: 0x0E9D,
	0x02A4: 0x1FC4,
	0x02A5: 0x155D,
	0x02A6: 0x0C75,
	0x02A7: 0x17AD,
	0x02A8: 0x1817,
	0x02AB: 0x036F,
	0x02AF: 0x2BEB,
	0x02B0: 0x0F33,
	0x02B3: 0x2737,
	0x02BB: 0x0E4A,
	0x02BD: 0x19A5,
	0x02BE: 0x2886,
	0x02C1: 0x04D2,
	0x02C2: 0x110F,
	0x02C3: 0x2436,
	0x02C4: 0x2ACC,
	0x02C8: 0x1E16,
	0x02C9: 0x1FB0,
	0x02CA: 0x1228,
	0x02CB: 0x2118,
	0x02CC: 0x1107,
	0x02CD: 0x1FAC,
	0x02CF: 0x1E22,
	0x02D0: 0x2669,
	0x02D1: 0x28A4,
	0x02D7: 0x1883,
	0x02D8: 0x0951,
	0x02D9: 0x0F19,
	0x02DA: 0x14EF,
	0x02DC: 0x1388,
	0x02DF: 0x2C8D,
	0x02E3: 0x1003,
	0x02E5: 0x1AEE,
	0x02E8: 0x152B,
	0x02EA: 0x12BD,
	0x02EC: 0x1179,
	0x02EE: 0x0769,
	0x02EF: 0x0B71,
	0x02F0: 0x2880,
	0x02F1: 0x06D6,
	0x02F4: 0x07DC,
	0x02F8: 0x05A9,
	0x02F9: 0x0909,
	0x02FA: 0x0F0F,
	0x02FB: 0x1939,
	0x02FC: 0x2CA8,
	0x02FF: 0x1E58,
	0x0302: 0x1881,
	0x0303: 0x1251,
	0x0304: 0x25AF,
	0x0306: 0x1029,
	0x0307: 0x1D8F,
	0x0308: 0x11C3,
	0x0309: 0x17BF,
	0x030A: 0x2000,
	0x030B: 0x203E,
	0x030C: 0x1143,
	0x0310: 0x1FBA,
	0x0317: 0x06DE,
	0x031C: 0x13BB,
	0x031D: 0x20CC,
	0x031E: 0x1C07,
	0x0321: 0x1263,
	0x0327: 0x1AD6,
	0x032A: 0x1D59,
	0x032D: 0x15FD,
	0x032E: 0x1621,
	0x032F: 0x1573,
	0x0330: 0x2264,
	0x0332: 0x0348,
	0x0333: 0x0C0D,
	0x0337: 0x01BC,
	0x0338: 0x08E9,
	0x0339: 0x0A7B,
	0x033A: 0x10C3,
	0x033B: 0x0745,
	0x033C: 0x1F2C,
	0x033D: 0x22CC,
	0x033E: 0x2DA9,
	0x0341: 0x11F1,
	0x0342: 0x2014,
	0x0343: 0x2D97,
	0x0345: 0x0FE7,
	0x0346: 0x211C,
	0x0347: 0x2266,
	0x0348: 0x17A7,
	0x0349: 0x2901,
	0x034A: 0x28FD,
	0x034C: 0x097A,
	0x034E: 0x0342,
	0x0351: 0x03C9,
	0x0352: 0x23F7,
	0x0353: 0x1850,
	0x0354: 0x2C7B,
	0x0355: 0x2DF8,
	0x0358: 0x0F7F,
	0x0359: 0x0688,
	0x035A: 0x0438,
	0x035B: 0x1C8D,
	0x035C: 0x2E31,
	0x035D: 0x1A3C,
	0x035E: 0x0EA5,
	0x0361: 0x0620,
	0x0364: 0x2A5D,
	0x0365: 0x086B,
	0x0366: 0x2CC6,
	0x0375: 0x0DD2,
	0x0376: 0x073F,
	0x037B: 0x0FB9,
	0x037F: 0x16ED,
	0x0384: 0x0891,
	0x0386: 0x058A,
	0x0388: 0x11D7,
	0x0389: 0x0EA9,
	0x038B: 0x006A,
	0x038C: 0x10AD,
	0x038D: 0x1887,
	0x0396: 0x2D11,
	0x0397: 0x0E6B,
	0x0399: 0x05E5,
	0x039A: 0x1C93,
	0x039B: 0x0067,
	0x039D: 0x2C36,
	0x03A2: 0x230A,
	0x03A4: 0x0B16,
	0x03A5: 0x21A0,
	0x03A6: 0x272D,
	0x03AA: 0x109B,
	0x03AB: 0x0EB3,
	0x03AC: 0x0FC1,
	0x03AD: 0x1844,
	0x03AF: 0x1B65,
	0x03B0: 0x225A,
	0x03B1: 0x2B0E,
	0x03BA: 0x20A4,
	0x03C0: 0x19AF,
	0x03C1: 0x2246,
	0x03C2: 0x1603,
	0x03C4: 0x068D,
	0x03C9: 0x0C70,
	0x03CA: 0x12A5,
	0x03CB: 0x198E,
	0x03CC: 0x1547,
	0x03CD: 0x2182,
	0x03CE: 0x28E0,
	0x03CF: 0x2BD0,
	0x03D3: 0x2090,
	0x03D4: 0x2356,
	0x03D6: 0x148D,
	0x03D8: 0x00EE,
	0x03DC: 0x122E,
	0x03DE: 0x012D,
	0x03E1: 0x1411,
	0x03E2: 0x10BF,
	0x03E3: 0x1035,
	0x03E4: 0x1EE9,
	0x03E5: 0x20DC,
	0x03E6: 0x2312,
	0x03E7: 0x2815,
	0x03E9: 0x21FA,
	0x03ED: 0x13F3,
	0x03F2: 0x229C,
	0x03F5: 0x20C6,
	0x03F6: 0x10C7,
	0x03F7: 0x0366,
	0x03FA: 0x261B,
	0x03FD: 0x1039,
	0x03FF: 0x1EC9,
	0x0400: 0x01D6,
	0x0401: 0x0DC9,
	0x0402: 0x0EA3,
	0x0403: 0x0EC1,
	0x0404: 0x0A26,
	0x0405: 0x1808,
	0x0406: 0x1A81,
	0x0407: 0x13A1,
	0x0408: 0x0576,
	0x0409: 0x20C0,
	0x040A: 0x09C5,
	0x040B: 0x0F81,
	0x040C: 0x2333,
	0x040D: 0x2B1D,
	0x0418: 0x1375,
	0x0419: 0x18CD,
	0x041A: 0x2B5F,
	0x041B: 0x283E,
	0x041C: 0x22E6,
	0x041D: 0x23DF,
	0x0420: 0x0939,
	0x0425: 0x1933,
	0x0428: 0x215C,
	0x042A: 0x0B01,
	0x042B: 0x289E,
	0x042C: 0x2A7B,
	0x042D: 0x14D9,
	0x0430: 0x1CF0,
	0x0434: 0x182F,
	0x0435: 0x20E0,
	0x0437: 0x2DE3,
	0x0438: 0x0662,
	0x0439: 0x0B59,
	0x043B: 0x2D3A,
	0x0442: 0x0B2B,
	0x0444: 0x03B1,
	0x0445: 0x1BAB,
	0x0447: 0x194C,
	0x0448: 0x1F84,
	0x0449: 0x27D8,
	0x0450: 0x2520,
	0x0452: 0x03AE,
	0x0453: 0x1240,
	0x0457: 0x075F,
	0x0459: 0x223C,
	0x045A: 0x1A88,
	0x045E: 0x2A45,
	0x0460: 0x17CF,
	0x0461: 0x29CA,
	0x0462: 0x18F9,
	0x0466: 0x0E05,
	0x0468: 0x03EA,
	0x0469: 0x208A,
	0x046A: 0x250C,
	0x046B: 0x0EC9,
	0x046F: 0x0730,
	0x0470: 0x0EBD,
	0x0471: 0x1273,
	0x0472: 0x133F,
	0x0473: 0x084A,
	0x0474: 0x17DB,
	0x0475: 0x2074,
	0x0476: 0x24B6,
	0x0477: 0x275D,
	0x0479: 0x03DB,
	0x047A: 0x22DA,
	0x047F: 0x00BE,
	0x0480: 0x1970,
	0x0481: 0x21B2,
	0x0482: 0x1A97,
	0x0483: 0x2775,
	0x0487: 0x07F5,
	0x0488: 0x26A3,
	0x0489: 0x2224,
	0x048B: 0x2E25,
	0x048D: 0x1791,
	0x0490: 0x2302,
	0x0493: 0x161B,
	0x0495: 0x0BA2,
	0x0496: 0x1EBD,
	0x049C: 0x0997,
	0x04A0: 0x23B4,
	0x04A1: 0x2DCE,
	0x04A2: 0x1218,
	0x04A3: 0x14A6,
	0x04AA: 0x1C8A,
	0x04AB: 0x025E,
	0x04AC: 0x1561,
	0x04AD: 0x27EA,
	0x04B0: 0x00DD,
	0x04B1: 0x199A,
	0x04B2: 0x22F4,
	0x04B5: 0x1055,
	0x04B6: 0x12C9,
	0x04B7: 0x1820,
	0x04BA: 0x023E,
	0x04BB: 0x139C,
	0x04BC: 0x1CC3,
	0x04BE: 0x09A0,
	0x04BF: 0x156B,
	0x04C1: 0x1371,
	0x04C2: 0x1069,
	0x04C3: 0x2232,
	0x04C6: 0x0614,
	0x04C7: 0x0965,
	0x04C8: 0x10EF,
	0x04C9: 0x088D,
	0x04CC: 0x02AB,
	0x04CD: 0x194E,
	0x04D8: 0x117F,
	0x04D9: 0x178D,
	0x04DA: 0x2A3C,
	0x04DC: 0x0B4C,
	0x04E0: 0x2831,
	0x04E3: 0x25D6,
	0x04E4: 0x18BE,
	0x04E6: 0x0B9F,
	0x04E7: 0x09A4,
	0x04E8: 0x17ED,
	0x04E9: 0x1CED,
	0x04EA: 0x25C7,
	0x04EB: 0x1D68,
	0x04EC: 0x2678,
	0x04EE: 0x0109,
	0x04EF: 0x1111,
	0x04F0: 0x1DE3,
	0x04F2: 0x0854,
	0x04F3: 0x15B5,
	0x04F4: 0x0D59,
	0x04F5: 0x206E,
	0x04F7: 0x0733,
	0x04F9: 0x0FF3,
	0x04FA: 0x02F2,
	0x04FB: 0x1783,
	0x04FC: 0x159B,
	0x04FD: 0x2BDF,
	0x050A: 0x17A5,
	0x050E: 0x01DC,
	0x0510: 0x0712,
	0x0511: 0x1282,
	0x0512: 0x2636,
	0x0513: 0x298E,
	0x0515: 0x1B55,
	0x0516: 0x1BFF,
	0x0519: 0x0E59,
	0x051A: 0x1F1B,
	0x051C: 0x29D0,
	0x051E: 0x1C66,
	0x051F: 0x1678,
	0x0522: 0x1FEE,
	0x0523: 0x197F,
	0x0526: 0x2761,
	0x0529: 0x1A4C,
	0x052E: 0x1CD9,
	0x052F: 0x2548,
	0x0530: 0x10F3,
	0x0531: 0x2ABD,
	0x0533: 0x07FF,
	0x0535: 0x0051,
	0x053B: 0x1F44,
	0x0544: 0x0262,
	0x0545: 0x0A11,
	0x0546: 0x13CB,
	0x0547: 0x20AE,
	0x0548: 0x2288,
	0x054E: 0x2E55,
	0x054F: 0x0327,
	0x0550: 0x0903,
	0x0551: 0x0FA5,
	0x0554: 0x1D44,
	0x0556: 0x2889,
	0x0558: 0x04DB,
	0x055A: 0x1165,
	0x055B: 0x1F8C,
	0x055D: 0x1A5F,
	0x055E: 0x0F15,
	0x0561: 0x1F26,
	0x0565: 0x23BC,
	0x0568: 0x2BF4,
	0x0569: 0x19B4,
	0x056C: 0x218E,
	0x056D: 0x2406,
	0x056F: 0x2380,
	0x0571: 0x1C87,
	0x0572: 0x263C,
	0x0574: 0x1E61,
	0x0575: 0x0A59,
	0x0576: 0x2D8E,
	0x0577: 0x2915,
	0x0578: 0x1847,
	0x057A: 0x03AB,
	0x057C: 0x0E3E,
	0x057D: 0x044A,
	0x057E: 0x1E73,
	0x057F: 0x14F4,
	0x0580: 0x169B,
	0x0581: 0x235E,
	0x0582: 0x2B59,
	0x0584: 0x0DAF,
	0x0586: 0x0A73,
	0x0587: 0x1744,
	0x0588: 0x04B1,
	0x0589: 0x1049,
	0x058A: 0x2A4E,
	0x058C: 0x01A2,
	0x058D: 0x2154,
	0x058F: 0x2589,
	0x0592: 0x105F,
	0x0593: 0x2CF0,
	0x0595: 0x036C,
	0x0596: 0x2170,
	0x0597: 0x2853,
	0x059B: 0x115F,
	0x059C: 0x27F3,
	0x059E: 0x1ED5,
	0x05A0: 0x1005,
	0x05A1: 0x10CB,
	0x05A3: 0x2C09,
	0x05A4: 0x11B6,
	0x05A7: 0x2E34,
	0x05AA: 0x0DB7,
	0x05AB: 0x2062,
	0x05B0: 0x0378,
	0x05B1: 0x24BE,
	0x05B3: 0x0F53,
	0x05B4: 0x11E1,
	0x05BB: 0x02EA,
	0x05BC: 0x2D40,
	0x05BE: 0x292B,
	0x05BF: 0x16DD,
	0x05C0: 0x1203,
	0x05C4: 0x2BEE,
	0x05C6: 0x2C7E,
	0x05C7: 0x2326,
	0x05C8: 0x2919,
	0x05CB: 0x1952,
	0x05CD: 0x2156,
	0x05CE: 0x2862,
	0x05CF: 0x08C9,
	0x05D1: 0x1B81,
	0x05D4: 0x22FA,
	0x05D6: 0x0AC2,
	0x05D7: 0x1644,
	0x05D8: 0x219C,
	0x05D9: 0x2DA0,
	0x05DA: 0x002D,
	0x05DB: 0x141D,
	0x05DC: 0x23B6,
	0x05DE: 0x27C9,
	0x05E1: 0x1612,
	0x05E5: 0x1E31,
	0x05E8: 0x1259,
	0x05E9: 0x23E2,
	0x05ED: 0x09BE,
	0x05EE: 0x2709,
	0x05EF: 0x2838,
	0x05F1: 0x10C5,
	0x05F2: 0x22D0,
	0x05F4: 0x08B2,
	0x05F6: 0x109F,
	0x05F7: 0x1E13,
	0x05F8: 0x2028,
	0x05F9: 0x246A,
	0x05FC: 0x0C05,
	0x0604: 0x0E2F,
	0x0605: 0x11F5,
	0x0606: 0x179D,
	0x0607: 0x2460,
	0x0608: 0x17F6,
	0x0609: 0x2883,
	0x060A: 0x0D4A,
	0x060F: 0x18B5,
	0x0610: 0x2877,
	0x0612: 0x2310,
	0x0614: 0x2148,
	0x0616: 0x29CD,
	0x0617: 0x2B9A,
	0x0618: 0x1278,
	0x0619: 0x17E7,
	0x061A: 0x202C,
	0x061B: 0x224C,
	0x061C: 0x2AF1,
	0x0620: 0x1569,
	0x0621: 0x1997,
	0x0626: 0x0921,
	0x0627: 0x0AA4,
	0x0628: 0x221A,
	0x062A: 0x2056,
	0x062F: 0x05D0,
	0x0631: 0x212C,
	0x0634: 0x234E,
	0x0636: 0x071E,
	0x0637: 0x0A17,
	0x0638: 0x0494,
	0x0639: 0x0FFF,
	0x063A: 0x01E2,
	0x063B: 0x1045,
	0x063C: 0x2096,
	0x063D: 0x286E,
	0x063E: 0x0D01,
	0x0642: 0x2D30,
	0x0644: 0x1033,
	0x0649: 0x1902,
	0x064A: 0x28AA,
	0x064B: 0x0F5D,
	0x064C: 0x02FE,
	0x064F: 0x1065,
	0x0650: 0x2168,
	0x0652: 0x1B1E,
	0x0653: 0x2544,
	0x0656: 0x2248,
	0x0658: 0x143D,
	0x0659: 0x1DE7,
	0x065A: 0x20E8,
	0x065B: 0x2672,
	0x0663: 0x0DFE,
	0x0665: 0x2A5A,
	0x0668: 0x21BE,
	0x0669: 0x1E55,
	0x066A: 0x07F0,
	0x066B: 0x1D26,
	0x066D: 0x2514,
	0x0670: 0x05F4,
	0x0676: 0x0151,
	0x0677: 0x2296,
	0x0679: 0x0471,
	0x067A: 0x200E,
	0x067C: 0x24D2,
	0x067F: 0x0ADD,
	0x0680: 0x0836,
	0x0684: 0x0FEB,
	0x0685: 0x1071,
	0x0686: 0x12A9,
	0x0687: 0x1FFA,
	0x0689: 0x0955,
	0x068A: 0x0B49,
	0x068E: 0x2210,
	0x068F: 0x2092,
	0x0690: 0x2759,
	0x0692: 0x1D89,
	0x0693: 0x00FD,
	0x0694: 0x04F6,
	0x0695: 0x03A2,
	0x069C: 0x1A32,
	0x069E: 0x1F32,
	0x069F: 0x057C,
	0x06A0: 0x27ED,
	0x06A1: 0x235A,
	0x06A2: 0x118F,
	0x06A3: 0x1C90,
	0x06A4: 0x2020,
	0x06A5: 0x2272,
	0x06A6: 0x0A50,
	0x06A7: 0x2DEF,
	0x06AA: 0x0BB9,
	0x06B3: 0x0F8D,
	0x06B4: 0x1447,
	0x06B5: 0x1D1A,
	0x06B6: 0x21F8,
	0x06B9: 0x0430,
	0x06BC: 0x1137,
	0x06BD: 0x0B75,
	0x06BE: 0x037B,
	0x06BF: 0x0FE1,
	0x06C0: 0x163C,
	0x06C1: 0x0113,
	0x06C2: 0x191F,
	0x06C3: 0x0D8B,
	0x06C4: 0x106F,
	0x06C5: 0x120C,
	0x06C6: 0x1186,
	0x06C7: 0x170C,
	0x06C8: 0x2697,
	0x06C9: 0x1648,
	0x06CB: 0x2675,
	0x06CD: 0x2C18,
	0x06CE: 0x11DB,
	0x06D2: 0x03CF,
	0x06D3: 0x25F4,
	0x06D4: 0x2274,
	0x06D7: 0x16A1,
	0x06D9: 0x0AF5,
	0x06DA: 0x2BD4,
	0x06E0: 0x20E4,
	0x06E8: 0x2AC9,
	0x06E9: 0x1442,
	0x06EA: 0x1BC7,
	0x06EC: 0x191A,
	0x06F0: 0x027E,
	0x06F3: 0x2DFB,
	0x06F4: 0x2CDB,
	0x06F5: 0x08AC,
	0x06F8: 0x22F6,
	0x06F9: 0x0778,
	0x06FA: 0x1CA1,
	0x06FD: 0x297C,
	0x06FF: 0x0E11,
	0x0705: 0x18D5,
	0x0707: 0x1D08,
	0x0709: 0x00B5,
	0x070A: 0x2DB5,
	0x070C: 0x26BB,
	0x070E: 0x170F,
	0x0714: 0x09C2,
	0x0716: 0x21CC,
	0x0717: 0x1AFD,
	0x0718: 0x2128,
	0x0719: 0x2C99,
	0x071A: 0x0F03,
	0x071C: 0x01D0,
	0x071D: 0x056C,
	0x071E: 0x2C0C,
	0x0721: 0x0564,
	0x0725: 0x2847,
	0x0726: 0x0EB1,
	0x072F: 0x288C,
	0x0732: 0x14D1,
	0x0733: 0x0AA1,
	0x0734: 0x014E,
	0x0735: 0x0DB3,
	0x0736: 0x25F1,
	0x0737: 0x28DD,
	0x073A: 0x0369,
	0x073B: 0x21DE,
	0x073C: 0x1F22,
	0x073D: 0x274D,
	0x073F: 0x231E,
	0x0748: 0x01A8,
	0x0749: 0x0FD3,
	0x074A: 0x0ACB,
	0x074B: 0x215A,
	0x074D: 0x03BA,
	0x074E: 0x27C5,
	0x074F: 0x2D0E,
	0x0750: 0x02FA,
	0x0752: 0x034B,
	0x0755: 0x0CEF,
	0x0756: 0x262A,
	0x0758: 0x0F43,
	0x0759: 0x1A04,
	0x075A: 0x0AE3,
	0x075B: 0x226A,
	0x075C: 0x258D,
	0x0760: 0x2A6C,
	0x0761: 0x0A83,
	0x0764: 0x11D9,
	0x0766: 0x1735,
	0x0768: 0x0BC1,
	0x0769: 0x039F,
	0x0774: 0x10FB,
	0x077A: 0x000D,
	0x077B: 0x0387,
	0x077D: 0x104F,
	0x077E: 0x24C2,
	0x077F: 0x21D8,
	0x0783: 0x0C19,
	0x0787: 0x2A96,
	0x0789: 0x0BF9,
	0x078E: 0x040A,
	0x078F: 0x17C1,
	0x0790: 0x2C54,
	0x0792: 0x12EA,
	0x0793: 0x1FE0,
	0x0794: 0x112D,
	0x0795: 0x22D4,
	0x0799: 0x0BDD,
	0x079A: 0x2180,
	0x07A0: 0x1F82,
	0x07A2: 0x0025,
	0x07A3: 0x1EB5,
	0x07A7: 0x0381,
	0x07A8: 0x215E,
	0x07AC: 0x23EB,
	0x07AD: 0x125F,
	0x07AE: 0x1523,
	0x07B1: 0x160F,
	0x07BA: 0x28A7,
	0x07BD: 0x29E5,
	0x07C1: 0x1967,
	0x07C4: 0x03ED,
	0x07C6: 0x0E00,
	0x07C7: 0x11B0,
	0x07C8: 0x13C3,
	0x07CB: 0x1ADA,
	0x07CD: 0x2176,
	0x07D2: 0x0642,
	0x07D4: 0x237E,
	0x07D7: 0x034E,
	0x07D8: 0x228E,
	0x07DA: 0x0EA7,
	0x07DB: 0x1865,
	0x07E0: 0x16F5,
	0x07E3: 0x2A24,
	0x07E5: 0x0204,
	0x07E6: 0x2DE0,
	0x07E9: 0x09F5,
	0x07EA: 0x117B,
	0x07EF: 0x2C81,
	0x07F2: 0x0536,
	0x07F3: 0x0FE3,
	0x07F5: 0x0CD3,
	0x07F7: 0x1361,
	0x07FA: 0x0064,
	0x07FB: 0x12A0,
	0x07FC: 0x19A0,
	0x07FD: 0x22DE,
	0x07FE: 0x2D8B,
	0x07FF: 0x1694,
	0x0802: 0x1265,
	0x0803: 0x2C0F,
	0x0804: 0x05CA,
	0x080A: 0x290D,
	0x080C: 0x091D,
	0x080D: 0x2345,
	0x080E: 0x29A3,
	0x080F: 0x243F,
	0x0810: 0x1712,
	0x0812: 0x0AB6,
	0x0814: 0x1497,
	0x0815: 0x1198,
	0x0816: 0x12F9,
	0x0817: 0x1D62,
	0x081B: 0x0AD1,
	0x081E: 0x27CC,
	0x0821: 0x158B,
	0x0824: 0x079B,
	0x0828: 0x26B3,
	0x0829: 0x0E8D,
	0x082B: 0x25F7,
	0x0833: 0x2480,
	0x0835: 0x10CF,
	0x0836: 0x20C8,
	0x083C: 0x0C6B,
	0x0841: 0x0E2C,
	0x0842: 0x1B8A,
	0x0843: 0x0DE4,
	0x0844: 0x26E3,
	0x0848: 0x1B43,
	0x0849: 0x0A7F,
	0x084C: 0x05EA,
	0x084D: 0x090D,
	0x084E: 0x243C,
	0x084F: 0x1C7B,
	0x0850: 0x2172,
	0x0851: 0x103F,
	0x0855: 0x0AE6,
	0x0856: 0x186D,
	0x0857: 0x0406,
	0x0858: 0x0B7B,
	0x0859: 0x1E10,
	0x085A: 0x2BF1,
	0x085B: 0x0773,
	0x085C: 0x1402,
	0x0860: 0x114F,
	0x0864: 0x1C75,
	0x0865: 0x0432,
	0x0866: 0x1EAD,
	0x0867: 0x0363,
	0x0868: 0x2086,
	0x0869: 0x2A42,
	0x086A: 0x045C,
	0x086B: 0x283B,
	0x086C: 0x2084,
	0x086D: 0x2026,
	0x086E: 0x27F0,
	0x086F: 0x2946,
	0x0870: 0x2AFC,
	0x0871: 0x2B11,
	0x0872: 0x2C15,
	0x0873: 0x195E,
	0x0874: 0x2C3C,
	0x0875: 0x2D49,
	0x0877: 0x2008,
	0x0878: 0x1D80,
	0x0879: 0x1F30,
	0x087A: 0x0DF6,
	0x087C: 0x1F0F,
	0x087F: 0x168C,
	0x0880: 0x2A69,
	0x0881: 0x018A,
	0x0882: 0x0F95,
	0x0886: 0x1950,
	0x0887: 0x1DCB,
	0x088A: 0x05CD,
	0x088C: 0x1469,
	0x088E: 0x1841,
	0x088F: 0x1081,
	0x0890: 0x09AC,
	0x0896: 0x2CA2,
	0x0897: 0x2B56,
	0x0899: 0x0D0F,
	0x08A2: 0x02A2,
	0x08A3: 0x069E,
	0x08A4: 0x1BA1,
	0x08A5: 0x0AF8,
	0x08A6: 0x248A,
	0x08A7: 0x272F,
	0x08AD: 0x2A1B,
	0x08AE: 0x1799,
	0x08AF: 0x216E,
	0x08B0: 0x0E71,
	0x08BA: 0x2006,
	0x08BC: 0x2D22,
	0x08BF: 0x15FA,
	0x08C0: 0x0D4F,
	0x08C1: 0x219A,
	0x08C2: 0x224E,
	0x08C3: 0x07E6,
	0x08C4: 0x0281,
	0x08C5: 0x2B20,
	0x08C6: 0x11AD,
	0x08C7: 0x00D9,
	0x08CB: 0x165D,
	0x08CD: 0x015F,
	0x08CE: 0x08E3,
	0x08D0: 0x04BA,
	0x08D1: 0x1AE5,
	0x08D2: 0x194A,
	0x08D3: 0x0BE1,
	0x08D4: 0x0822,
	0x08D5: 0x0B99,
	0x08D6: 0x2208,
	0x08D7: 0x15A9,
	0x08D8: 0x0671,
	0x08D9: 0x03C0,
	0x08DA: 0x1700,
	0x08DB: 0x2B14,
	0x08DE: 0x1319,
	0x08DF: 0x2733,
	0x08E0: 0x0A68,
	0x08E1: 0x0CFC,
	0x08E2: 0x1F72,
	0x08E3: 0x0A56,
	0x08E4: 0x0A20,
	0x08E5: 0x0E65,
	0x08E8: 0x2642,
	0x08EA: 0x2594,
	0x08EF: 0x0650,
	0x08F0: 0x05AF,
	0x08F2: 0x009D,
	0x08F3: 0x1135,
	0x08F6: 0x27E1,
	0x08FC: 0x2160,
	0x0902: 0x04FE,
	0x0903: 0x02BE,
	0x0904: 0x22BC,
	0x0906: 0x248E,
	0x090E: 0x29BE,
	0x0911: 0x1EB9,
	0x0916: 0x00E2,
	0x0917: 0x156D,
	0x0918: 0x21E2,
	0x0919: 0x0E7D,
	0x091B: 0x162C,
	0x091D: 0x0899,
	0x091F: 0x2781,
	0x0920: 0x29F4,
	0x0923: 0x267E,
	0x0925: 0x0079,
	0x0926: 0x0F6B,
	0x0927: 0x2AAE,
	0x092B: 0x0929,
	0x092D: 0x1021,
	0x092E: 0x18B8,
	0x0930: 0x20D6,
	0x0932: 0x1795,
	0x0935: 0x1B2C,
	0x0938: 0x2400,
	0x0939: 0x0DD5,
	0x093A: 0x1F80,
	0x093E: 0x0049,
	0x093F: 0x0490,
	0x0940: 0x0F2D,
	0x0941: 0x11DD,
	0x0942: 0x1B99,
	0x0943: 0x1D29,
	0x0944: 0x26DF,
	0x0945: 0x296D,
	0x0947: 0x0F4B,
	0x0949: 0x031A,
	0x094A: 0x03FC,
	0x094C: 0x13D7,
	0x094D: 0x2703,
	0x0952: 0x0082,
	0x0953: 0x124F,
	0x0954: 0x21FE,
	0x0955: 0x2AFF,
	0x0956: 0x1802,
	0x0957: 0x27BD,
	0x0958: 0x2D14,
	0x0959: 0x211A,
	0x095D: 0x23BE,
	0x0962: 0x1031,
	0x0963: 0x2967,
	0x0966: 0x1A28,
	0x0967: 0x0339,
	0x096D: 0x1365,
	0x0971: 0x1091,
	0x0973: 0x1D17,
	0x0974: 0x0931,
	0x0975: 0x288F,
	0x0978: 0x2ACF,
	0x097A: 0x00DB,
	0x097B: 0x0967,
	0x097D: 0x16BC,
	0x097E: 0x23D0,
	0x097F: 0x2216,
	0x0981: 0x22BE,
	0x0983: 0x1DBB,
	0x0984: 0x1537,
	0x0985: 0x1BD9,
	0x0986: 0x2102,
	0x0987: 0x0DE6,
	0x0988: 0x2442,
	0x0989: 0x033C,
	0x098A: 0x04C0,
	0x098B: 0x1057,
	0x098C: 0x142D,
	0x098D: 0x175A,
	0x098E: 0x214A,
	0x098F: 0x22A0,
	0x0990: 0x119E,
	0x0991: 0x04A8,
	0x0992: 0x0578,
	0x0993: 0x1415,
	0x0994: 0x23FD,
	0x0995: 0x2B9D,
	0x0998: 0x294C,
	0x099A: 0x0933,
	0x099B: 0x10B1,
	0x099D: 0x18FF,
	0x099E: 0x088F,
	0x09A0: 0x0596,
	0x09A1: 0x1BE8,
	0x09A3: 0x2D4F,
	0x09A7: 0x0DF8,
	0x09AB: 0x158E,
	0x09AD: 0x2492,
	0x09B6: 0x1FD0,
	0x09B8: 0x1A24,
	0x09B9: 0x25D9,
	0x09BB: 0x204C,
	0x09C1: 0x1908,
	0x09C4: 0x0E77,
	0x09C5: 0x1A37,
	0x09C8: 0x1326,
	0x09C9: 0x2C48,
	0x09CC: 0x0F39,
	0x09CD: 0x19CE,
	0x09D0: 0x1C13,
	0x09D1: 0x22EA,
	0x09D2: 0x21D6,
	0x09D4: 0x1A64,
	0x09D8: 0x2AA2,
	0x09D9: 0x0302,
	0x09DB: 0x067A,
	0x09DC: 0x14B9,
	0x09DD: 0x2C60,
	0x09DE: 0x2DDD,
	0x09E1: 0x1555,
	0x09E2: 0x1FFE,
	0x09E5: 0x08D5,
	0x09E6: 0x13AF,
	0x09E7: 0x06BA,
	0x09E8: 0x0CC9,
	0x09E9: 0x1875,
	0x09EA: 0x21D0,
	0x09EC: 0x0C9A,
	0x09ED: 0x2336,
	0x09EF: 0x1F7C,
	0x09F5: 0x1D8C,
	0x09F6: 0x25B8,
	0x09F7: 0x2CEA,
	0x09F9: 0x0EF9,
	0x09FC: 0x1F1E,
	0x09FF: 0x0E95,
	0x0A0F: 0x2721,
	0x0A10: 0x108B,
	0x0A11: 0x0E17,
	0x0A12: 0x22E8,
	0x0A13: 0x182C,
	0x0A14: 0x1FF0,
	0x0A15: 0x0142,
	0x0A17: 0x22A6,
	0x0A18: 0x06D2,
	0x0A19: 0x07A5,
	0x0A1A: 0x06B6,
	0x0A20: 0x1F2A,
	0x0A21: 0x0736,
	0x0A22: 0x2292,
	0x0A23: 0x1CD5,
	0x0A24: 0x0193,
	0x0A25: 0x2E40,
	0x0A28: 0x23E8,
	0x0A2A: 0x1392,
	0x0A2B: 0x25C1,
	0x0A2C: 0x2A57,
	0x0A2D: 0x00A0,
	0x0A31: 0x043E,
	0x0A32: 0x2088,
	0x0A37: 0x0275,
	0x0A3B: 0x22F8,
	0x0A3C: 0x0E26,
	0x0A3D: 0x0883,
	0x0A3E: 0x0E6E,
	0x0A3F: 0x20DE,
	0x0A40: 0x2DFE,
	0x0A41: 0x0171,
	0x0A42: 0x10E1,
	0x0A44: 0x28CE,
	0x0A45: 0x29E2,
	0x0A47: 0x060C,
	0x0A4A: 0x2624,
	0x0A4B: 0x02B2,
	0x0A4C: 0x1AB6,
	0x0A4D: 0x20B0,
	0x0A4E: 0x0408,
	0x0A4F: 0x2970,
	0x0A50: 0x2A0C,
	0x0A51: 0x0E93,
	0x0A53: 0x150D,
	0x0A54: 0x18A1,
	0x0A56: 0x2451,
	0x0A57: 0x0C30,
	0x0A5C: 0x01A4,
	0x0A5D: 0x0AC5,
	0x0A5E: 0x1C99,
	0x0A5F: 0x20BC,
	0x0A60: 0x1F4D,
	0x0A61: 0x0B19,
	0x0A62: 0x2B29,
	0x0A66: 0x1B60,
	0x0A69: 0x1F15,
	0x0A6F: 0x1CF9,
	0x0A70: 0x0C01,
	0x0A71: 0x1F28,
	0x0A72: 0x20E2,
	0x0A74: 0x17B7,
	0x0A75: 0x157D,
	0x0A76: 0x26D7,
	0x0A77: 0x2C69,
	0x0A78: 0x059A,
	0x0A79: 0x1087,
	0x0A7A: 0x10F9,
	0x0A7C: 0x0399,
	0x0A7F: 0x0FE5,
	0x0A81: 0x18B2,
	0x0A82: 0x190E,
	0x0A83: 0x29C7,
	0x0A84: 0x2A0F,
	0x0A86: 0x080E,
	0x0A87: 0x227C,
	0x0A88: 0x28E6,
	0x0A89: 0x2BCC,
	0x0A8C: 0x0E53,
	0x0A90: 0x0F3F,
	0x0A92: 0x209A,
	0x0A9A: 0x11C9,
	0x0A9B: 0x13F8,
	0x0A9C: 0x0721,
	0x0A9D: 0x11A1,
	0x0A9E: 0x2242,
	0x0A9F: 0x1A68,
	0x0AA0: 0x050A,
	0x0AA1: 0x106B,
	0x0AA2: 0x230C,
	0x0AA3: 0x2A06,
	0x0AA5: 0x1257,
	0x0AA7: 0x11AA,
	0x0AAB: 0x214C,
	0x0AAE: 0x246E,
	0x0AB2: 0x2550,
	0x0AB3: 0x2C30,
	0x0AB7: 0x21DC,
	0x0ABC: 0x1C84,
	0x0ABE: 0x0ED5,
	0x0ABF: 0x0DA5,
	0x0AC0: 0x1D05,
	0x0AC3: 0x1988,
	0x0AC4: 0x0612,
	0x0AC5: 0x096F,
	0x0AC7: 0x2C96,
	0x0AC8: 0x09C0,
	0x0ACD: 0x1B3F,
	0x0ACE: 0x16D9,
	0x0ACF: 0x28D1,
	0x0AD2: 0x0D87,
	0x0AD6: 0x014B,
	0x0AD7: 0x0372,
	0x0ADA: 0x1E5B,
	0x0ADB: 0x00BB,
	0x0ADC: 0x0A4A,
	0x0ADD: 0x17BB,
	0x0ADE: 0x1E70,
	0x0ADF: 0x2030,
	0x0AE0: 0x2252,
	0x0AE1: 0x1EED,
	0x0AE6: 0x1CFC,
	0x0AE7: 0x04D5,
	0x0AE8: 0x1B47,
	0x0AEE: 0x1D20,
	0x0AEF: 0x08FA,
	0x0AF4: 0x013F,
	0x0AF6: 0x10E3,
	0x0AFE: 0x0199,
	0x0B01: 0x17F9,
	0x0B07: 0x2528,
	0x0B08: 0x1171,
	0x0B0A: 0x0FF9,
	0x0B0B: 0x10AB,
	0x0B0F: 0x2108,
	0x0B13: 0x2370,
	0x0B14: 0x1715,
	0x0B15: 0x19C9,
	0x0B16: 0x2E3D,
	0x0B19: 0x041A,
	0x0B1F: 0x0F09,
	0x0B20: 0x02DE,
	0x0B29: 0x217E,
	0x0B2A: 0x26B7,
	0x0B2E: 0x2A93,
	0x0B31: 0x2558,
	0x0B33: 0x2BB4,
	0x0B34: 0x1721,
	0x0B36: 0x10A1,
	0x0B37: 0x2244,
	0x0B38: 0x08D1,
	0x0B3A: 0x10FD,
	0x0B3C: 0x0287,
	0x0B42: 0x159D,
	0x0B43: 0x1F78,
	0x0B44: 0x0510,
	0x0B45: 0x0D45,
	0x0B46: 0x1DE0,
	0x0B47: 0x1F6C,
	0x0B48: 0x2AD5,
	0x0B49: 0x27FD,
	0x0B4B: 0x0F37,
	0x0B4C: 0x0512,
	0x0B50: 0x0181,
	0x0B51: 0x1E28,
	0x0B52: 0x00E5,
	0x0B53: 0x21C4,
	0x0B54: 0x01FB,
	0x0B55: 0x29DC,
	0x0B57: 0x0C63,
	0x0B58: 0x20CA,
	0x0B5A: 0x2A03,
	0x0B5C: 0x17D5,
	0x0B5E: 0x123D,
	0x0B60: 0x1599,
	0x0B61: 0x19D3,
	0x0B62: 0x186F,
	0x0B63: 0x1AEB,
	0x0B69: 0x102F,
	0x0B6B: 0x1FFC,
	0x0B6F: 0x240C,
	0x0B74: 0x05A6,
	0x0B75: 0x07CD,
	0x0B76: 0x193E,
	0x0B77: 0x1C5D,
	0x0B78: 0x2409,
	0x0B79: 0x197C,
	0x0B7C: 0x01DF,
	0x0B7E: 0x114B,
	0x0B7F: 0x2795,
	0x0B85: 0x22C0,
	0x0B87: 0x1579,
	0x0B8D: 0x1BFA,
	0x0B8E: 0x13B3,
	0x0B8F: 0x0963,
	0x0B91: 0x21AA,
	0x0B99: 0x0402,
	0x0B9B: 0x2874,
	0x0BA1: 0x1838,
	0x0BA2: 0x255C,
	0x0BA3: 0x087B,
	0x0BAB: 0x08A1,
	0x0BAC: 0x166C,
	0x0BAE: 0x0E7F,
	0x0BAF: 0x0284,
	0x0BB2: 0x0F1F,
	0x0BB3: 0x13B7,
	0x0BB4: 0x1954,
	0x0BB5: 0x0A9E,
	0x0BB6: 0x1985,
	0x0BB7: 0x0521,
	0x0BB8: 0x003D,
	0x0BB9: 0x0869,
	0x0BBA: 0x26F4,
	0x0BBD: 0x0DB1,
	0x0BBF: 0x04CC,
	0x0BC0: 0x07FA,
	0x0BC1: 0x098B,
	0x0BC2: 0x17E4,
	0x0BC3: 0x1CD2,
	0x0BC4: 0x278D,
	0x0BC6: 0x23F1,
	0x0BC7: 0x2C33,
	0x0BC9: 0x03CC,
	0x0BCB: 0x05F2,
	0x0BCC: 0x01D9,
	0x0BCD: 0x1AA5,
	0x0BCE: 0x2C6C,
	0x0BD1: 0x1E2B,
	0x0BD2: 0x205C,
	0x0BD3: 0x1153,
	0x0BD4: 0x24F2,
	0x0BD5: 0x2576,
	0x0BD6: 0x2098,
	0x0BD7: 0x1EF1,
	0x0BDB: 0x0551,
	0x0BDC: 0x0A98,
	0x0BDD: 0x22C8,
	0x0BDE: 0x24E6,
	0x0BE1: 0x0F59,
	0x0BE4: 0x07B4,
	0x0BE5: 0x14C9,
	0x0BE6: 0x1559,
	0x0BE7: 0x2B68,
	0x0BEA: 0x03D5,
	0x0BEB: 0x2C00,
	0x0BEF: 0x287D,
	0x0BF2: 0x0BA9,
	0x0BF3: 0x0393,
	0x0BF4: 0x1013,
	0x0BF5: 0x0DEC,
	0x0BF6: 0x0F91,
	0x0BF7: 0x01F2,
	0x0BF8: 0x1083,
	0x0BF9: 0x10BB,
	0x0BFA: 0x1856,
	0x0BFB: 0x2120,
	0x0BFC: 0x15EA,
	0x0BFD: 0x2415,
	0x0BFE: 0x269B,
	0x0BFF: 0x27AD,
	0x0C00: 0x293A,
	0x0C01: 0x21D4,
	0x0C03: 0x1E4C,
	0x0C06: 0x00C9,
	0x0C07: 0x0580,
	0x0C08: 0x2D02,
	0x0C09: 0x1315,
	0x0C0A: 0x2403,
	0x0C0B: 0x2988,
	0x0C0C: 0x0290,
	0x0C11: 0x1AC9,
	0x0C12: 0x0500,
	0x0C18: 0x1E7C,
	0x0C19: 0x24CE,
	0x0C1A: 0x1835,
	0x0C1E: 0x1527,
	0x0C23: 0x2CFF,
	0x0C2A: 0x038D,
	0x0C2C: 0x25A6,
	0x0C32: 0x2290,
	0x0C33: 0x18F2,
	0x0C34: 0x0994,
	0x0C36: 0x2D19,
	0x0C37: 0x2A1E,
	0x0C38: 0x06E8,
	0x0C39: 0x0DC0,
	0x0C3A: 0x13D3,
	0x0C41: 0x25AC,
	0x0C42: 0x016B,
	0x0C43: 0x1D35,
	0x0C44: 0x25E2,
	0x0C49: 0x0871,
	0x0C4A: 0x17C9,
	0x0C4C: 0x232A,
	0x0C4E: 0x233C,
	0x0C4F: 0x2DA6,
	0x0C50: 0x064B,
	0x0C51: 0x013C,
	0x0C52: 0x0900,
	0x0C55: 0x14C1,
	0x0C56: 0x1B39,
	0x0C58: 0x20B8,
	0x0C59: 0x2AE5,
	0x0C5E: 0x1F56,
	0x0C60: 0x01F8,
	0x0C6D: 0x12B5,
	0x0C70: 0x0EE9,
	0x0C75: 0x16AD,
	0x0C76: 0x1A6C,
	0x0C78: 0x27B5,
	0x0C79: 0x052D,
	0x0C7C: 0x1DA7,
	0x0C7D: 0x2130,
	0x0C7E: 0x11BD,
	0x0C7F: 0x15CE,
	0x0C80: 0x1F98,
	0x0C83: 0x28B6,
	0x0C84: 0x1291,
	0x0C86: 0x1553,
	0x0C87: 0x058E,
	0x0C88: 0x0E68,
	0x0C89: 0x12C1,
	0x0C8A: 0x2284,
	0x0C8B: 0x1ECD,
	0x0C8C: 0x1001,
	0x0C8D: 0x2D82,
	0x0C90: 0x1877,
	0x0C91: 0x1F01,
	0x0C92: 0x01C2,
	0x0C93: 0x02DA,
	0x0C94: 0x05A0,
	0x0C95: 0x1FEA,
	0x0C9B: 0x2B65,
	0x0C9D: 0x09DE,
	0x0CA2: 0x1301,
	0x0CA4: 0x00AF,
	0x0CAF: 0x210E,
	0x0CB4: 0x0DFA,
	0x0CB5: 0x0FD1,
	0x0CBD: 0x2C51,
	0x0CBF: 0x083B,
	0x0CC1: 0x0123,
	0x0CC2: 0x04DE,
	0x0CC3: 0x1709,
	0x0CC4: 0x125D,
	0x0CC5: 0x20AC,
	0x0CC6: 0x022E,
	0x0CC7: 0x246C,
	0x0CC8: 0x0B61,
	0x0CC9: 0x2AF5,
	0x0CCA: 0x1161,
	0x0CCC: 0x16AA,
	0x0CCD: 0x1B10,
	0x0CCE: 0x077D,
	0x0CD0: 0x0E1D,
	0x0CD1: 0x22B6,
	0x0CD2: 0x0091,
	0x0CD3: 0x06F6,
	0x0CD4: 0x1226,
	0x0CD5: 0x270C,
	0x0CD7: 0x1606,
	0x0CD8: 0x25FA,
	0x0CD9: 0x097F,
	0x0CDA: 0x050C,
	0x0CDC: 0x26DB,
	0x0CDD: 0x2A09,
	0x0CE0: 0x29C1,
	0x0CE7: 0x0424,
	0x0CE8: 0x0716,
	0x0CE9: 0x0E29,
	0x0CEA: 0x1C2A,
	0x0CEB: 0x08C4,
	0x0CEC: 0x1D86,
	0x0CED: 0x244E,
	0x0CEE: 0x0FC3,
	0x0CEF: 0x1853,
	0x0CF0: 0x2278,
	0x0CF1: 0x29A6,
	0x0CF5: 0x2681,
	0x0CF9: 0x156F,
	0x0CFA: 0x0157,
	0x0CFB: 0x2A75,
	0x0D00: 0x210C,
	0x0D01: 0x08A3,
	0x0D04: 0x0E50,
	0x0D0A: 0x04E4,
	0x0D0B: 0x1C2E,
	0x0D0E: 0x015D,
	0x0D11: 0x1117,
	0x0D1A: 0x25A9,
	0x0D1D: 0x0FD5,
	0x0D24: 0x06A3,
	0x0D25: 0x0ED1,
	0x0D26: 0x10DD,
	0x0D2C: 0x28BC,
	0x0D2F: 0x2BA3,
	0x0D32: 0x1B3D,
	0x0D33: 0x09FA,
	0x0D37: 0x0B29,
	0x0D38: 0x0708,
	0x0D3C: 0x18E9,
	0x0D3D: 0x1B4B,
	0x0D3E: 0x12FD,
	0x0D41: 0x2E28,
	0x0D49: 0x0133,
	0x0D4A: 0x0616,
	0x0D4C: 0x1CDD,
	0x0D4D: 0x1431,
	0x0D4E: 0x0F7D,
	0x0D4F: 0x082C,
	0x0D50: 0x144C,
	0x0D51: 0x1E5E,
	0x0D53: 0x1C16,
	0x0D54: 0x25D3,
	0x0D55: 0x20D4,
	0x0D58: 0x048A,
	0x0D59: 0x10E7,
	0x0D5A: 0x08DB,
	0x0D5B: 0x0542,
	0x0D5E: 0x1C9D,
	0x0D63: 0x0F0D,
	0x0D64: 0x1234,
	0x0D65: 0x023A,
	0x0D66: 0x223A,
	0x0D69: 0x05DC,
	0x0D6A: 0x14B5,
	0x0D6D: 0x0DF4,
	0x0D6F: 0x23B2,
	0x0D73: 0x20C2,
	0x0D77: 0x2684,
	0x0D78: 0x2AB4,
	0x0D7A: 0x0887,
	0x0D7B: 0x29F1,
	0x0D7C: 0x2DC4,
	0x0D81: 0x268D,
	0x0D84: 0x0E7B,
	0x0D88: 0x1C7E,
	0x0D8B: 0x1E1C,
	0x0D8D: 0x11EB,
	0x0D8E: 0x176F,
	0x0D90: 0x211E,
	0x0D91: 0x1471,
	0x0D92: 0x1419,
	0x0D94: 0x1ED1,
	0x0D96: 0x2A27,
	0x0D99: 0x07E1,
	0x0D9C: 0x293D,
	0x0D9E: 0x00FA,
	0x0D9F: 0x0AE0,
	0x0DA2: 0x0E20,
	0x0DA3: 0x2850,
	0x0DAA: 0x1059,
	0x0DB0: 0x0F2F,
	0x0DB7: 0x101B,
	0x0DB8: 0x1C96,
	0x0DBA: 0x0F2B,
	0x0DBB: 0x2C42,
	0x0DBC: 0x177F,
	0x0DBD: 0x0867,
	0x0DBE: 0x1E49,
	0x0DBF: 0x249A,
	0x0DC1: 0x04AB,
	0x0DC2: 0x2A3F,
	0x0DC5: 0x2985,
	0x0DC7: 0x27A5,
	0x0DC8: 0x08D9,
	0x0DC9: 0x0D65,
	0x0DCA: 0x1D14,
	0x0DCF: 0x01CA,
	0x0DD0: 0x1E67,
	0x0DD1: 0x2204,
	0x0DD4: 0x236E,
	0x0DD5: 0x23F4,
	0x0DD6: 0x05C7,
	0x0DD7: 0x124D,
	0x0DD8: 0x1DC5,
	0x0DE9: 0x0B41,
	0x0DEB: 0x048E,
	0x0DED: 0x0039,
	0x0DEE: 0x13DF,
	0x0DEF: 0x0B39,
	0x0DF0: 0x24E2,
	0x0DF1: 0x2905,
	0x0DF4: 0x0021,
	0x0DF5: 0x2A21,
	0x0DF7: 0x201A,
	0x0DF8: 0x1958,
	0x0DFB: 0x1CF6,
	0x0DFD: 0x2B41,
	0x0E01: 0x0D83,
	0x0E02: 0x234B,
	0x0E03: 0x04A5,
	0x0E04: 0x2B74,
	0x0E05: 0x23CD,
	0x0E0B: 0x15A3,
	0x0E0C: 0x2964,
	0x0E0F: 0x2430,
	0x0E10: 0x2841,
	0x0E11: 0x00F7,
	0x0E13: 0x1221,
	0x0E16: 0x1231,
	0x0E18: 0x1675,
	0x0E1B: 0x0184,
	0x0E1F: 0x0447,
	0x0E20: 0x067E,
	0x0E21: 0x240F,
	0x0E25: 0x2384,
	0x0E26: 0x1FDC,
	0x0E27: 0x242C,
	0x0E28: 0x26BF,
	0x0E2B: 0x0B5D,
	0x0E2C: 0x1994,
	0x0E2D: 0x15EE,
	0x0E2E: 0x20B4,
	0x0E2F: 0x2132,
	0x0E33: 0x1159,
	0x0E34: 0x25BB,
	0x0E35: 0x1CE1,
	0x0E36: 0x2D7C,
	0x0E37: 0x2262,
	0x0E3A: 0x2E37,
	0x0E3B: 0x2457,
	0x0E3C: 0x257E,
	0x0E3E: 0x1EC5,
	0x0E3F: 0x09BC,
	0x0E40: 0x0DEA,
	0x0E44: 0x028A,
	0x0E48: 0x2B1A,
	0x0E4A: 0x252C,
	0x0E4B: 0x2911,
	0x0E4E: 0x049E,
	0x0E51: 0x0A09,
	0x0E52: 0x2693,
	0x0E53: 0x17D8,
	0x0E54: 0x2230,
	0x0E58: 0x1DAF,
	0x0E59: 0x2DB2,
	0x0E5D: 0x0EAB,
	0x0E5F: 0x2633,
	0x0E60: 0x042A,
	0x0E64: 0x0724,
	0x0E65: 0x1BF1,
	0x0E66: 0x2E3A,
	0x0E6B: 0x2126,
	0x0E6E: 0x08C7,
	0x0E70: 0x28E3,
	0x0E72: 0x2E16,
	0x0E73: 0x13E4,
	0x0E74: 0x0590,
	0x0E75: 0x236C,
	0x0E79: 0x09E8,
	0x0E7A: 0x2A33,
	0x0E7B: 0x2B88,
	0x0E7C: 0x0F73,
	0x0E7D: 0x1823,
	0x0E7E: 0x18C7,
	0x0E7F: 0x0C9F,
	0x0E80: 0x20AA,
	0x0E81: 0x2AC0,
	0x0E82: 0x1D7D,
	0x0E8E: 0x189E,
	0x0E95: 0x1FC6,
	0x0E96: 0x2314,
	0x0E98: 0x104B,
	0x0E99: 0x1FA2,
	0x0E9A: 0x0A2F,
	0x0E9B: 0x2892,
	0x0E9E: 0x0480,
	0x0E9F: 0x0E8F,
	0x0EA0: 0x2C84,
	0x0EA2: 0x12B9,
	0x0EA3: 0x190B,
	0x0EA4: 0x0608,
	0x0EA5: 0x2236,
	0x0EA6: 0x0873,
	0x0EA7: 0x0584,
	0x0EA8: 0x05A3,
	0x0EAC: 0x0976,
	0x0EAD: 0x1D9B,
	0x0EAE: 0x2270,
	0x0EB0: 0x1A00,
	0x0EB2: 0x0FD7,
	0x0EB4: 0x0953,
	0x0EB6: 0x2C3F,
	0x0EB7: 0x2AC6,
	0x0EB8: 0x00C7,
	0x0EB9: 0x17AF,
	0x0EBA: 0x23AA,
	0x0EBB: 0x2A60,
	0x0EBC: 0x029F,
	0x0EBD: 0x154D,
	0x0EBE: 0x299D,
	0x0EBF: 0x13C7,
	0x0EC0: 0x1AE8,
	0x0EC1: 0x2961,
	0x0EC2: 0x2B35,
	0x0EC3: 0x066C,
	0x0EC6: 0x212A,
	0x0ECB: 0x2844,
	0x0ECC: 0x1D0B,
	0x0ECD: 0x2973,
	0x0ED2: 0x13E9,
	0x0ED4: 0x0EB9,
	0x0ED5: 0x0646,
	0x0ED6: 0x1961,
	0x0ED7: 0x1D65,
	0x0ED9: 0x01CD,
	0x0EDA: 0x1756,
	0x0EDC: 0x0AFB,
	0x0EDD: 0x011F,
	0x0EDE: 0x0D54,
	0x0EDF: 0x1155,
	0x0EE0: 0x27D5,
	0x0EE1: 0x0222,
	0x0EE3: 0x0557,
	0x0EE4: 0x181D,
	0x0EE5: 0x11FD,
	0x0EE8: 0x2DEC,
	0x0EED: 0x0BCD,
	0x0EEE: 0x042E,
	0x0EF0: 0x2CD5,
	0x0EF2: 0x29E8,
	0x0EF3: 0x204A,
	0x0EF5: 0x115D,
	0x0EF6: 0x1C03,
	0x0EF7: 0x1E3D,
	0x0EF8: 0x108F,
	0x0EF9: 0x270F,
	0x0EFC: 0x212E,
	0x0EFF: 0x1085,
	0x0F00: 0x1D56,
	0x0F01: 0x02E6,
	0x0F02: 0x09CA,
	0x0F03: 0x1169,
	0x0F04: 0x0562,
	0x0F08: 0x045F,
	0x0F09: 0x23D9,
	0x0F11: 0x0F57,
	0x0F17: 0x2DC8,
	0x0F18: 0x2925,
	0x0F19: 0x1B34,
	0x0F1C: 0x0482,
	0x0F1D: 0x29FD,
	0x0F1F: 0x1FCE,
	0x0F21: 0x20A2,
	0x0F22: 0x1597,
	0x0F23: 0x0029,
	0x0F24: 0x23A0,
	0x0F25: 0x0598,
	0x0F26: 0x0E99,
	0x0F27: 0x28CB,
	0x0F29: 0x17C3,
	0x0F2A: 0x0236,
	0x0F2C: 0x21A8,
	0x0F2E: 0x2534,
	0x0F2F: 0x0F1D,
	0x0F33: 0x1C57,
	0x0F38: 0x105D,
	0x0F3E: 0x0242,
	0x0F3F: 0x11B8,
	0x0F40: 0x137E,
	0x0F47: 0x1DD1,
	0x0F49: 0x0B1F,
	0x0F4A: 0x091B,
	0x0F4B: 0x29B8,
	0x0F4C: 0x1015,
	0x0F4E: 0x0F61,
	0x0F4F: 0x0E8B,
	0x0F50: 0x2661,
	0x0F51: 0x09B9,
	0x0F57: 0x0D74,
	0x0F59: 0x04C3,
	0x0F5C: 0x172F,
	0x0F60: 0x2D4C,
	0x0F68: 0x21EC,
	0x0F6C: 0x1B31,
	0x0F6D: 0x0CF3,
	0x0F72: 0x0360,
	0x0F75: 0x2306,
	0x0F76: 0x0420,
	0x0F77: 0x2A81,
	0x0F78: 0x1FBE,
	0x0F79: 0x11E7,
	0x0F7A: 0x2639,
	0x0F7B: 0x229E,
	0x0F7C: 0x0E32,
	0x0F7D: 0x2439,
	0x0F7F: 0x1D50,
	0x0F81: 0x050E,
	0x0F82: 0x2B50,
	0x0F8A: 0x2D9D,
	0x0F8B: 0x191D,
	0x0F8F: 0x26C3,
	0x0F91: 0x2394,
	0x0F92: 0x1640,
	0x0F95: 0x16FD,
	0x0F96: 0x24C6,
	0x0F9C: 0x2630,
	0x0F9D: 0x0923,
	0x0F9E: 0x24EF,
	0x0FA4: 0x1EDD,
	0x0FA5: 0x298B,
	0x0FA7: 0x0C50,
	0x0FA8: 0x0EE1,
	0x0FA9: 0x256C,
	0x0FAB: 0x0345,
	0x0FAC: 0x008B,
	0x0FAD: 0x053C,
	0x0FAE: 0x28A1,
	0x0FAF: 0x2CD8,
	0x0FB1: 0x2B5C,
	0x0FB2: 0x102B,
	0x0FB8: 0x08DD,
	0x0FB9: 0x1571,
	0x0FBA: 0x1E9D,
	0x0FBB: 0x05E2,
	0x0FBC: 0x2477,
	0x0FBD: 0x0E5C,
	0x0FBE: 0x1351,
	0x0FC2: 0x10A7,
	0x0FC4: 0x03FE,
	0x0FC5: 0x10FF,
	0x0FC8: 0x1131,
	0x0FC9: 0x2B44,
	0x0FCB: 0x2606,
	0x0FCF: 0x01E8,
	0x0FD0: 0x23E5,
	0x0FD1: 0x1101,
	0x0FD2: 0x0459,
	0x0FD3: 0x20A8,
	0x0FD4: 0x26D3,
	0x0FD5: 0x0FB1,
	0x0FD7: 0x0E9B,
	0x0FD8: 0x198B,
	0x0FD9: 0x0AAA,
	0x0FDA: 0x15CA,
	0x0FDB: 0x1703,
	0x0FDC: 0x2690,
	0x0FDD: 0x111B,
	0x0FDE: 0x1173,
	0x0FE8: 0x01B6,
	0x0FEA: 0x0441,
	0x0FEB: 0x15BF,
	0x0FEC: 0x07AA,
	0x0FED: 0x1B24,
	0x0FEE: 0x2144,
	0x0FEF: 0x11D2,
	0x0FF0: 0x155F,
	0x0FF1: 0x2258,
	0x0FF3: 0x2308,
	0x0FF6: 0x1914,
	0x0FF9: 0x0187,
	0x0FFB: 0x0D25,
	0x0FFD: 0x22E0,
	0x0FFE: 0x2CBD,
	0x1000: 0x012A,
	0x1001: 0x035A,
	0x1002: 0x1A09,
	0x1003: 0x10BD,
	0x100D: 0x06FE,
	0x100E: 0x227A,
	0x1013: 0x2E46,
	0x1014: 0x22C6,
	0x1017: 0x04A2,
	0x1018: 0x18A4,
	0x101A: 0x1017,
	0x101B: 0x1B45,
	0x101E: 0x2645,
	0x1020: 0x1B94,
	0x1022: 0x2574,
	0x1024: 0x08F5,
	0x1026: 0x046B,
	0x1029: 0x0498,
	0x102B: 0x0DA3,
	0x102C: 0x1E1F,
	0x102D: 0x104D,
	0x1030: 0x221E,
	0x1031: 0x1BE3,
	0x1033: 0x1E4F,
	0x1035: 0x05F8,
	0x1036: 0x1D11,
	0x1038: 0x0426,
	0x1039: 0x12CD,
	0x103A: 0x2994,
	0x103B: 0x27C1,
	0x1040: 0x2158,
	0x1042: 0x2294,
	0x1043: 0x0DC3,
	0x1044: 0x0F27,
	0x1047: 0x0893,
	0x1048: 0x095D,
	0x1049: 0x0F31,
	0x104B: 0x0CA3,
	0x104C: 0x2BFD,
	0x1054: 0x0813,
	0x1057: 0x1638,
	0x1058: 0x2B94,
	0x105A: 0x2C21,
	0x105B: 0x0865,
	0x105C: 0x0DD8,
	0x105D: 0x1660,
	0x105E: 0x23B0,
	0x105F: 0x18CA,
	0x1060: 0x2A48,
	0x1061: 0x28F9,
	0x1063: 0x1177,
	0x1064: 0x1C63,
	0x1065: 0x05D9,
	0x1066: 0x0BFD,
	0x1067: 0x22B2,
	0x1068: 0x0456,
	0x106B: 0x0DCF,
	0x106D: 0x1113,
	0x1077: 0x0B0A,
	0x1079: 0x180E,
	0x107A: 0x1FCC,
	0x107B: 0x259F,
	0x1082: 0x0161,
	0x1083: 0x040E,
	0x1087: 0x0A65,
	0x108B: 0x265D,
	0x108F: 0x0FAD,
	0x1091: 0x030A,
	0x1092: 0x071C,
	0x1093: 0x1025,
	0x1094: 0x174C,
	0x1095: 0x2952,
	0x109B: 0x0F1B,
	0x109C: 0x16B6,
	0x109D: 0x0DCC,
	0x109E: 0x1492,
	0x109F: 0x15A5,
	0x10A0: 0x2032,
	0x10A1: 0x20F4,
	0x10A2: 0x0E74,
	0x10A3: 0x19B8,
	0x10A4: 0x2471,
	0x10A9: 0x2AE1,
	0x10AF: 0x103B,
	0x10B4: 0x2D76,
	0x10B8: 0x20CE,
	0x10B9: 0x15AD,
	0x10BB: 0x0E85,
	0x10BC: 0x24CA,
	0x10BD: 0x1105,
	0x10BE: 0x200C,
	0x10C3: 0x004D,
	0x10C4: 0x022A,
	0x10C5: 0x228C,
	0x10C7: 0x1634,
	0x10C8: 0x1E85,
	0x10CB: 0x0961,
	0x10CC: 0x1C78,
	0x10CD: 0x23C0,
	0x10D1: 0x1FBC,
	0x10D2: 0x2358,
	0x10D7: 0x0F49,
	0x10DD: 0x1379,
	0x10E0: 0x0A0D,
	0x10E3: 0x1FA4,
	0x10E4: 0x0041,
	0x10E5: 0x10AF,
	0x10E6: 0x159F,
	0x10E7: 0x12E0,
	0x10E8: 0x2B02,
	0x10EC: 0x21C0,
	0x10EF: 0x18AC,
	0x10F0: 0x13CF,
	0x10F5: 0x1D1D,
	0x10F7: 0x1936,
	0x10F9: 0x2DC1,
	0x10FB: 0x099A,
	0x10FC: 0x0E41,
	0x10FD: 0x107D,
	0x1101: 0x0CAD,
	0x1102: 0x00DF,
	0x1106: 0x0357,
	0x1108: 0x0AFE,
	0x1109: 0x220E,
	0x110A: 0x0C8D,
	0x110E: 0x15B1,
	0x110F: 0x2004,
	0x1110: 0x2D52,
	0x1111: 0x10B3,
	0x1112: 0x0502,
	0x1113: 0x0506,
	0x1114: 0x1255,
	0x1115: 0x0592,
	0x1116: 0x1FF8,
	0x1117: 0x21F0,
	0x1118: 0x16F9,
	0x1119: 0x1D02,
	0x111B: 0x08CB,
	0x111C: 0x13EE,
	0x111E: 0x1D6B,
	0x111F: 0x11A7,
	0x1120: 0x14F9,
	0x1121: 0x28D4,
	0x1122: 0x20BE,
	0x1124: 0x0EED,
	0x1127: 0x27D2,
	0x1128: 0x16F1,
	0x1129: 0x06ED,
	0x112B: 0x2192,
	0x112D: 0x03FA,
	0x112E: 0x0655,
	0x112F: 0x269F,
	0x1130: 0x2AC3,
	0x1131: 0x2C1E,
	0x1132: 0x0EF3,
	0x1133: 0x21A6,
	0x1138: 0x1089,
	0x1139: 0x021C,
	0x113B: 0x0117,
	0x113C: 0x092F,
	0x113D: 0x11B2,
	0x1140: 0x1DA4,
	0x1141: 0x2CD2,
	0x114C: 0x20A0,
	0x114D: 0x1489,
	0x114E: 0x1D92,
	0x114F: 0x2398,
	0x1151: 0x15B3,
	0x1153: 0x09D6,
	0x1155: 0x0A14,
	0x1156: 0x2254,
	0x1157: 0x0A1D,
	0x1159: 0x02B6,
	0x115A: 0x135D,
	0x115F: 0x233F,
	0x1167: 0x0232,
	0x116A: 0x1145,
	0x116D: 0x0BC5,
	0x116F: 0x2162,
	0x1170: 0x2582,
	0x1171: 0x285C,
	0x1172: 0x09AA,
	0x117A: 0x02AE,
	0x1181: 0x0FBD,
	0x1183: 0x0791,
	0x1184: 0x2362,
	0x1185: 0x102D,
	0x1189: 0x0D39,
	0x118A: 0x1D4A,
	0x118B: 0x2034,
	0x118C: 0x2564,
	0x118D: 0x0A79,
	0x118E: 0x192A,
	0x118F: 0x19E4,
	0x1190: 0x21E6,
	0x1191: 0x21FC,
	0x1192: 0x2A8A,
	0x1193: 0x2C87,
	0x119D: 0x2072,
	0x119E: 0x1C36,
	0x119F: 0x0190,
	0x11A0: 0x0B31,
	0x11A1: 0x0B6D,
	0x11A2: 0x1FC8,
	0x11A6: 0x2188,
	0x11A9: 0x0B3B,
	0x11AA: 0x1964,
	0x11AB: 0x254C,
	0x11AC: 0x25BE,
	0x11AD: 0x21F2,
	0x11B0: 0x073C,
	0x11B6: 0x0DFC,
	0x11B8: 0x0EFD,
	0x11BD: 0x2590,
	0x11C1: 0x1181,
	0x11C5: 0x2E52,
	0x11C6: 0x2C8A,
	0x11C8: 0x15DE,
	0x11CA: 0x1103,
	0x11CC: 0x08E1,
	0x11CD: 0x0F85,
	0x11D4: 0x0E0E,
	0x11D5: 0x1CB1,
	0x11D6: 0x113D,
	0x11D7: 0x2054,
	0x11D8: 0x0A71,
	0x11D9: 0x1147,
	0x11DA: 0x1305,
	0x11DB: 0x224A,
	0x11DC: 0x241C,
	0x11E0: 0x24D6,
	0x11E1: 0x2712,
	0x11E3: 0x1FE4,
	0x11E8: 0x0BC9,
	0x11E9: 0x14C5,
	0x11EA: 0x17B1,
	0x11EB: 0x1E19,
	0x11EC: 0x018D,
	0x11ED: 0x0FE9,
	0x11F5: 0x095B,
	0x11F7: 0x0E14,
	0x11F8: 0x2560,
	0x11F9: 0x2B0B,
	0x11FB: 0x1738,
	0x1202: 0x1BCB,
	0x1203: 0x1051,
	0x1204: 0x218A,
	0x1208: 0x171E,
	0x1209: 0x2C45,
	0x120B: 0x12F4,
	0x120D: 0x0FED,
	0x1212: 0x1F5E,
	0x1215: 0x1F74,
	0x1219: 0x23D3,
	0x121C: 0x1A9F,
	0x121F: 0x0B69,
	0x1220: 0x1D6E,
	0x1221: 0x2038,
	0x1222: 0x22F2,
	0x1223: 0x0F69,
	0x1225: 0x2E2B,
	0x1226: 0x1127,
	0x122C: 0x295B,
	0x1233: 0x1D5F,
	0x1234: 0x1944,
	0x1235: 0x0210,
	0x1236: 0x1097,
	0x1237: 0x09D3,
	0x1238: 0x1567,
	0x1239: 0x1873,
	0x123F: 0x1195,
	0x1242: 0x2A90,
	0x1246: 0x239C,
	0x1247: 0x0B96,
	0x1248: 0x0E4D,
	0x1249: 0x00CF,
	0x124A: 0x0E91,
	0x124B: 0x15F6,
	0x124C: 0x18A7,
	0x1250: 0x0B35,
	0x1253: 0x2B83,
	0x1255: 0x29AF,
	0x125A: 0x01E5,
	0x125C: 0x2829,
	0x125D: 0x0F4D,
	0x125E: 0x2D67,
	0x1260: 0x08E7,
	0x1261: 0x2260,
	0x1263: 0x2058,
	0x1265: 0x0E62,
	0x1266: 0x1B49,
	0x1269: 0x1684,
	0x126A: 0x2D34,
	0x126C: 0x1B41,
	0x1272: 0x0F07,
	0x1277: 0x15D2,
	0x1278: 0x1D32,
	0x127B: 0x07B9,
	0x127C: 0x2328,
	0x127D: 0x06A8,
	0x1283: 0x29EB,
	0x1284: 0x232D,
	0x1285: 0x154F,
	0x1286: 0x2A51,
	0x1287: 0x1982,
	0x1288: 0x2352,
	0x1289: 0x18D3,
	0x128A: 0x203A,
	0x128B: 0x25FD,
	0x1290: 0x100F,
	0x1291: 0x1588,
	0x1292: 0x1D83,
	0x1293: 0x20F8,
	0x1294: 0x2D88,
	0x1299: 0x20D2,
	0x129C: 0x1011,
	0x12A2: 0x0703,
	0x12A3: 0x1EB1,
	0x12A4: 0x084F,
	0x12A5: 0x261E,
	0x12A6: 0x28E9,
	0x12A8: 0x0610,
	0x12A9: 0x0E79,
	0x12AD: 0x05EC,
	0x12AF: 0x183E,
	0x12B0: 0x0FC5,
	0x12B2: 0x0001,
	0x12B3: 0x0011,
	0x12B4: 0x287A,
	0x12B7: 0x10C9,
	0x12B9: 0x0982,
	0x12BF: 0x25E8,
	0x12C0: 0x0C35,
	0x12C1: 0x086D,
	0x12C2: 0x1421,
	0x12C3: 0x1DCE,
	0x12C4: 0x1215,
	0x12C5: 0x0D17,
	0x12C6: 0x1CBA,
	0x12C7: 0x2A7E,
	0x12C9: 0x21BA,
	0x12CA: 0x2BE5,
	0x12CB: 0x094B,
	0x12CC: 0x14AB,
	0x12CE: 0x1FA6,
	0x12D0: 0x2C1B,
	0x12D4: 0x1595,
	0x12D6: 0x14E5,
	0x12D7: 0x2585,
	0x12D9: 0x186B,
	0x12DE: 0x2648,
	0x12DF: 0x1F3A,
	0x12E4: 0x0453,
	0x12E5: 0x2765,
	0x12E6: 0x2600,
	0x12E9: 0x0533,
	0x12EB: 0x19AA,
	0x12F3: 0x1753,
	0x12F4: 0x1F58,
	0x12F5: 0x21BC,
	0x12F9: 0x208E,
	0x12FC: 0x24FC,
	0x12FE: 0x14B0,
	0x12FF: 0x0462,
	0x1301: 0x154B,
	0x1302: 0x21B6,
	0x1307: 0x25EB,
	0x1309: 0x0A23,
	0x130A: 0x05BE,
	0x130B: 0x151B,
	0x130C: 0x1E6D,
	0x130D: 0x1879,
	0x130F: 0x0F11,
	0x1310: 0x01C4,
	0x1311: 0x2B05,
	0x1315: 0x152F,
	0x1316: 0x1369,
	0x1317: 0x1BB4,
	0x1318: 0x06B2,
	0x131A: 0x2779,
	0x131B: 0x1F5A,
	0x131D: 0x09B0,
	0x131F: 0x2122,
	0x1321: 0x0E9F,
	0x1322: 0x033F,
	0x1323: 0x0D41,
	0x1324: 0x15BC,
	0x1325: 0x23C2,
	0x1328: 0x0DEE,
	0x1330: 0x09D0,
	0x1334: 0x010F,
	0x1335: 0x245E,
	0x1337: 0x187B,
	0x1338: 0x2C5D,
	0x133F: 0x07A0,
	0x1340: 0x2200,
	0x1341: 0x2050,
	0x1342: 0x2082,
	0x1343: 0x217A,
	0x1345: 0x2178,
	0x1346: 0x16C2,
	0x1347: 0x23AE,
	0x1348: 0x0412,
	0x134B: 0x184D,
	0x134D: 0x093B,
	0x134F: 0x0925,
	0x1351: 0x0226,
	0x1353: 0x15E2,
	0x1357: 0x035D,
	0x135E: 0x1041,
	0x135F: 0x22BA,
	0x1364: 0x0351,
	0x1366: 0x0ED9,
	0x136A: 0x2206,
	0x136E: 0x0B65,
	0x136F: 0x16C5,
	0x1375: 0x2940,
	0x1377: 0x075A,
	0x1379: 0x105B,
	0x137F: 0x0941,
	0x1382: 0x15A1,
	0x1383: 0x244B,
	0x1384: 0x08E5,
	0x1387: 0x0465,
	0x1388: 0x065A,
	0x1389: 0x0E81,
	0x138C: 0x2D6A,
	0x1390: 0x1892,
	0x1391: 0x207A,
	0x1393: 0x0384,
	0x139B: 0x0959,
	0x139C: 0x0D94,
	0x139D: 0x1465,
	0x139E: 0x0588,
	0x139F: 0x15B7,
	0x13A1: 0x2080,
	0x13A6: 0x17D2,
	0x13A9: 0x0B84,
	0x13AE: 0x201C,
	0x13B0: 0x1BBE,
	0x13B2: 0x115B,
	0x13B3: 0x2AA8,
	0x13B4: 0x2BC0,
	0x13B6: 0x00A3,
	0x13B7: 0x2136,
	0x13B8: 0x166F,
	0x13B9: 0x2E1C,
	0x13BA: 0x24A2,
	0x13BE: 0x0F77,
	0x13C1: 0x2466,
	0x13C5: 0x16B3,
	0x13C6: 0x216A,
	0x13C7: 0x2504,
	0x13CA: 0x12EF,
	0x13CD: 0x098E,
	0x13CE: 0x0A53,
	0x13D0: 0x2821,
	0x13D1: 0x0A77,
	0x13D4: 0x0428,
	0x13D8: 0x1F64,
	0x13DB: 0x11B4,
	0x13DC: 0x1073,
	0x13DE: 0x0AF2,
	0x13DF: 0x2E10,
	0x13E1: 0x18F6,
	0x13E2: 0x1CEA,
	0x13E3: 0x260F,
	0x13E4: 0x2CE1,
	0x13E5: 0x0CF7,
	0x13E7: 0x0917,
	0x13EB: 0x116D,
	0x13EC: 0x0CA8,
	0x13ED: 0x1B18,
	0x13EE: 0x1EF9,
	0x13EF: 0x15B9,
	0x13F1: 0x09D9,
	0x13F3: 0x22EE,
	0x13F5: 0x056E,
	0x13F6: 0x2809,
	0x13F7: 0x0947,
	0x13F8: 0x14BD,
	0x13FB: 0x1FE8,
	0x13FF: 0x0F67,
	0x1401: 0x0818,
	0x1403: 0x0A35,
	0x1404: 0x2A4B,
	0x1407: 0x1797,
	0x1408: 0x0270,
	0x140D: 0x2ADB,
	0x140E: 0x169E,
	0x140F: 0x17AB,
	0x1410: 0x0B43,
	0x1412: 0x0468,
	0x1413: 0x2500,
	0x1414: 0x22FC,
	0x1415: 0x2524,
	0x1416: 0x0B04,
	0x1417: 0x0009,
	0x1418: 0x1200,
	0x1419: 0x1769,
	0x141A: 0x181A,
	0x141D: 0x1C69,
	0x1421: 0x1DFB,
	0x1422: 0x0764,
	0x1423: 0x193C,
	0x1424: 0x2E22,
	0x1426: 0x1F6A,
	0x1429: 0x0EF5,
	0x142A: 0x235C,
	0x142B: 0x1777,
	0x142C: 0x1F76,
	0x142E: 0x038A,
	0x142F: 0x20BA,
	0x1430: 0x2166,
	0x1433: 0x0293,
	0x143A: 0x209E,
	0x143D: 0x0622,
	0x143E: 0x0742,
	0x1441: 0x0F01,
	0x1443: 0x08EF,
	0x1445: 0x24F5,
	0x1448: 0x107F,
	0x144A: 0x04AE,
	0x144B: 0x0E89,
	0x144C: 0x1C72,
	0x144D: 0x19F6,
	0x1452: 0x229A,
	0x1461: 0x2152,
	0x1462: 0x25DC,
	0x1463: 0x19E8,
	0x1464: 0x00B2,
	0x1465: 0x0C3F,
	0x1467: 0x18DD,
	0x1468: 0x2212,
	0x1469: 0x29B5,
	0x146B: 0x26EB,
	0x146C: 0x1663,
	0x146D: 0x0927,
	0x146E: 0x220A,
	0x146F: 0x2BA9,
	0x1470: 0x2076,
	0x1471: 0x2CC3,
	0x1472: 0x11E9,
	0x1473: 0x054B,
	0x1474: 0x0D61,
	0x1475: 0x1946,
	0x1476: 0x19C0,
	0x1477: 0x1F60,
	0x1478: 0x1F9C,
	0x1479: 0x0045,
	0x147A: 0x108D,
	0x147B: 0x0FFD,
	0x1480: 0x14CD,
	0x1481: 0x1D98,
	0x1484: 0x0AA7,
	0x148A: 0x0B87,
	0x148B: 0x2D08,
	0x1491: 0x1077,
	0x1494: 0x1618,
	0x1495: 0x0B1C,
	0x1496: 0x2D05,
	0x1497: 0x1A5A,
	0x1498: 0x01AA,
	0x1499: 0x020A,
	0x149A: 0x0CB2,
	0x149D: 0x273D,
	0x149E: 0x245C,
	0x14A5: 0x1ABE,
	0x14A7: 0x0F41,
	0x14A8: 0x281D,
	0x14A9: 0x1924,
	0x14AA: 0x2A54,
	0x14B2: 0x27CF,
	0x14B5: 0x04B4,
	0x14B6: 0x0B13,
	0x14B7: 0x0E08,
	0x14B8: 0x221C,
	0x14B9: 0x1DD4,
	0x14BA: 0x24A6,
	0x14BB: 0x09B3,
	0x14BC: 0x1D7A,
	0x14C0: 0x07C8,
	0x14C1: 0x206A,
	0x14C5: 0x087F,
	0x14C6: 0x1FDE,
	0x14C7: 0x1565,
	0x14C8: 0x2068,
	0x14C9: 0x138D,
	0x14CA: 0x2316,
	0x14CB: 0x0250,
	0x14CC: 0x1151,
	0x14CD: 0x25B5,
	0x14CE: 0x2C66,
	0x14CF: 0x21B8,
	0x14DA: 0x21B4,
	0x14DB: 0x009A,
	0x14DC: 0x1B3B,
	0x14DE: 0x076E,
	0x14DF: 0x0AEF,
	0x14E2: 0x19BC,
	0x14E3: 0x1FB4,
	0x14E7: 0x10A9,
	0x14E8: 0x27F9,
	0x14E9: 0x00D5,
	0x14EA: 0x0CD7,
	0x14EB: 0x202A,
	0x14EC: 0x028D,
	0x14ED: 0x2412,
	0x14EE: 0x2B47,
	0x14F0: 0x2324,
	0x14F2: 0x2819,
	0x14F3: 0x2943,
	0x14F5: 0x12D6,
	0x14F7: 0x2134,
	0x14F9: 0x2C27,
	0x14FA: 0x20D0,
	0x14FD: 0x0BE9,
	0x1503: 0x05FA,
	0x1507: 0x1533,
	0x1509: 0x0396,
	0x150B: 0x100D,
	0x1510: 0x2C90,
	0x1515: 0x18AF,
	0x1516: 0x016D,
	0x1517: 0x200A,
	0x1518: 0x22D2,
	0x1519: 0x27B1,
	0x151A: 0x2865,
	0x151D: 0x0492,
	0x151F: 0x09ED,
	0x1520: 0x2991,
	0x1522: 0x1724,
	0x1524: 0x1A51,
	0x1525: 0x0FD9,
	0x1526: 0x1D47,
	0x1527: 0x2374,
	0x1529: 0x1D41,
	0x152A: 0x294F,
	0x152C: 0x11F7,
	0x152E: 0x1AF2,
	0x152F: 0x20EE,
	0x1533: 0x16E5,
	0x1535: 0x1F5C,
	0x1536: 0x2496,
	0x1537: 0x17A1,
	0x153A: 0x1F7A,
	0x153C: 0x2718,
	0x153D: 0x238A,
	0x153E: 0x19D8,
	0x153F: 0x2A15,
	0x1540: 0x2DAF,
	0x1542: 0x2CF3,
	0x1543: 0x2B91,
	0x1544: 0x2D27,
	0x1545: 0x2060,
	0x1546: 0x1FE6,
	0x1547: 0x0C2B,
	0x1549: 0x2AB1,
	0x154B: 0x1037,
	0x154C: 0x21E0,
	0x154D: 0x1582,
	0x154F: 0x0088,
	0x1550: 0x0EAF,
	0x1551: 0x0DE1,
	0x1552: 0x0A41,
	0x1553: 0x0EE5,
	0x1554: 0x1B07,
	0x1555: 0x2715,
	0x1556: 0x1B28,
	0x1559: 0x01AC,
	0x155A: 0x0508,
	0x155B: 0x1F94,
	0x155C: 0x24B2,
	0x155D: 0x2B53,
	0x1561: 0x2E43,
	0x1562: 0x23A6,
	0x1564: 0x23CA,
	0x1569: 0x13DB,
	0x156A: 0x0C47,
	0x156C: 0x0C09,
	0x156D: 0x0E02,
	0x156E: 0x1DFE,
	0x156F: 0x1927,
	0x1573: 0x0B9C,
	0x1574: 0x121B,
	0x1575: 0x1121,
	0x1576: 0x17DE,
	0x1577: 0x24BA,
	0x1578: 0x2937,
	0x1579: 0x29BB,
	0x157C: 0x1DF8,
	0x157E: 0x140C,
	0x1581: 0x001D,
	0x1582: 0x1EC1,
	0x1587: 0x17FF,
	0x1588: 0x043B,
	0x158E: 0x21EE,
	0x158F: 0x1A8C,
	0x1590: 0x031E,
	0x1591: 0x0905,
	0x1592: 0x0879,
	0x1595: 0x0CB7,
	0x1596: 0x0BD9,
	0x1598: 0x1C54,
	0x159A: 0x097C,
	0x159E: 0x29A0,
	0x159F: 0x236A,
	0x15A0: 0x0BF5,
	0x15A1: 0x16C9,
	0x15A3: 0x1EF5,
	0x15A4: 0x2D61,
	0x15A6: 0x1AE2,
	0x15A9: 0x2E07,
	0x15AA: 0x1E99,
	0x15AB: 0x2955,
	0x15AD: 0x1E2E,
	0x15AE: 0x1551,
	0x15AF: 0x28C5,
	0x15B0: 0x0CC4,
	0x15B3: 0x14A1,
	0x15B4: 0x1C43,
	0x15B5: 0x20C4,
	0x15B6: 0x01C7,
	0x15B7: 0x2124,
	0x15B8: 0x2C72,
	0x15BB: 0x2012,
	0x15BE: 0x16E9,
	0x15C0: 0x047A,
	0x15C1: 0x04BD,
	0x15C2: 0x1585,
	0x15C5: 0x2CF9,
	0x15C8: 0x0165,
	0x15CB: 0x0755,
	0x15CF: 0x0435,
	0x15D0: 0x28AD,
	0x15D3: 0x2354,
	0x15D4: 0x03B7,
	0x15D5: 0x1F70,
	0x15D6: 0x0696,
	0x15D7: 0x25C4,
	0x15DB: 0x1D74,
	0x15DD: 0x0A85,
	0x15DF: 0x2518,
	0x15E1: 0x1868,
	0x15E2: 0x2142,
	0x15E8: 0x2C4B,
	0x15ED: 0x0444,
	0x15F8: 0x2322,
	0x15F9: 0x2DF2,
	0x15FB: 0x0EFF,
	0x1601: 0x1FB6,
	0x1605: 0x1183,
	0x1606: 0x0A1A,
	0x160B: 0x147D,
	0x160C: 0x0634,
	0x160D: 0x2655,
	0x1610: 0x0B33,
	0x1611: 0x1BB9,
	0x1612: 0x1C46,
	0x1613: 0x2BFA,
	0x1614: 0x21DA,
	0x1615: 0x160C,
	0x1616: 0x2114,
	0x1619: 0x238E,
	0x161B: 0x0EAD,
	0x161C: 0x2396,
	0x1620: 0x070D,
	0x1623: 0x23C7,
	0x162A: 0x1B5B,
	0x162B: 0x22A2,
	0x162D: 0x0FDF,
	0x1630: 0x1D3E,
	0x1636: 0x1C6C,
	0x163A: 0x0554,
	0x163B: 0x0484,
	0x163C: 0x0CDB,
	0x163D: 0x2CCF,
	0x163F: 0x207E,
	0x1640: 0x093D,
	0x1641: 0x2CB1,
	0x1643: 0x2376,
	0x1644: 0x0937,
	0x1645: 0x27B9,
	0x1646: 0x0AD4,
	0x1647: 0x092D,
	0x1648: 0x0B78,
	0x1649: 0x0639,
	0x164A: 0x184A,
	0x164B: 0x2D64,
	0x164C: 0x225E,
	0x164D: 0x08C1,
	0x164E: 0x0A62,
	0x164F: 0x2A00,
	0x1650: 0x26EF,
	0x1653: 0x13FD,
	0x1654: 0x2DBE,
	0x1656: 0x0354,
	0x1658: 0x0163,
	0x1659: 0x271B,
	0x165C: 0x1973,
	0x165D: 0x1B2E,
	0x1660: 0x08DF,
	0x1662: 0x04C6,
	0x1666: 0x060A,
	0x1668: 0x0C7A,
	0x166B: 0x00C3,
	0x166C: 0x055D,
	0x166D: 0x0BE5,
	0x166E: 0x03F3,
	0x166F: 0x1407,
	0x1670: 0x1DD7,
	0x1671: 0x26C7,
	0x1677: 0x0D20,
	0x167A: 0x2651,
	0x167B: 0x2DD1,
	0x167C: 0x1CCF,
	0x1680: 0x0748,
	0x1683: 0x0A29,
	0x1685: 0x1F9A,
	0x1686: 0x0F4F,
	0x1687: 0x23C4,
	0x1688: 0x0606,
	0x168C: 0x03DE,
	0x168D: 0x227E,
	0x168F: 0x0097,
	0x1690: 0x2BF7,
	0x1693: 0x19E0,
	0x1694: 0x2976,
	0x1696: 0x0804,
	0x1697: 0x0306,
	0x169B: 0x0488,
	0x16A1: 0x061A,
	0x16A3: 0x1296,
	0x16A4: 0x1E3A,
	0x16A6: 0x093F,
	0x16A7: 0x05BB,
	0x16A8: 0x12AD,
	0x16A9: 0x29D6,
	0x16AA: 0x2D0B,
	0x16AB: 0x0450,
	0x16AC: 0x05EE,
	0x16AD: 0x2A78,
	0x16AE: 0x2DF5,
	0x16B2: 0x1ADE,
	0x16B3: 0x0714,
	0x16B5: 0x072D,
	0x16B6: 0x0881,
	0x16B7: 0x10D3,
	0x16B9: 0x03A8,
	0x16BA: 0x08AF,
	0x16C2: 0x1EE5,
	0x16C5: 0x1680,
	0x16C9: 0x2445,
	0x16CA: 0x17B9,
	0x16CB: 0x217C,
	0x16CC: 0x28BF,
	0x16D7: 0x0F05,
	0x16DA: 0x1F90,
	0x16DB: 0x2C78,
	0x16DE: 0x05F6,
	0x16E0: 0x21E4,
	0x16E1: 0x0C84,
	0x16E3: 0x253C,
	0x16E4: 0x0085,
	0x16E5: 0x1435,
	0x16E6: 0x195B,
	0x16E7: 0x2570,
	0x16E8: 0x0DA7,
	0x16EE: 0x251C,
	0x16F0: 0x124B,
	0x16F8: 0x279D,
	0x16F9: 0x109D,
	0x16FA: 0x113B,
	0x16FB: 0x2B38,
	0x16FD: 0x1237,
	0x1703: 0x1832,
	0x1705: 0x2218,
	0x170A: 0x1718,
	0x170E: 0x0809,
	0x1711: 0x0F6F,
	0x1713: 0x2CC9,
	0x1714: 0x157B,
	0x1715: 0x0831,
	0x1716: 0x2A72,
	0x1717: 0x0FC7,
	0x171A: 0x02CE,
	0x171D: 0x1C19,
	0x1720: 0x08FD,
	0x1721: 0x112F,
	0x1722: 0x2E1F,
	0x1723: 0x051B,
	0x1727: 0x112B,
	0x1731: 0x08A9,
	0x1732: 0x0207,
	0x1733: 0x0897,
	0x1734: 0x0BB1,
	0x1735: 0x1139,
	0x1736: 0x20EC,
	0x1739: 0x1B26,
	0x173A: 0x2024,
	0x173C: 0x2D91,
	0x173E: 0x1D23,
	0x173F: 0x284D,
	0x1741: 0x1425,
	0x1745: 0x0A9B,
	0x1746: 0x15E6,
	0x1747: 0x17CB,
	0x1748: 0x11DF,
	0x1749: 0x146D,
	0x174A: 0x08F7,
	0x174B: 0x05D6,
	0x174C: 0x2749,
	0x1750: 0x0312,
	0x1751: 0x1732,
	0x1752: 0x183B,
	0x1753: 0x171B,
	0x1754: 0x2D43,
	0x1757: 0x21A4,
	0x175A: 0x00F1,
	0x1760: 0x2D58,
	0x1763: 0x017E,
	0x1764: 0x220C,
	0x1767: 0x0DA9,
	0x1769: 0x213E,
	0x176B: 0x10F1,
	0x176C: 0x1287,
	0x176D: 0x1224,
	0x176E: 0x2BBC,
	0x1770: 0x2BDC,
	0x1773: 0x0BAD,
	0x1774: 0x26AF,
	0x1778: 0x0FEF,
	0x1779: 0x1212,
	0x177A: 0x17B5,
	0x177D: 0x0885,
	0x1784: 0x0EA1,
	0x1785: 0x1FF4,
	0x178B: 0x019F,
	0x178C: 0x1149,
	0x178D: 0x10A5,
	0x178E: 0x1209,
	0x178F: 0x149C,
	0x1790: 0x1D95,
	0x1791: 0x0C26,
	0x1793: 0x2220,
	0x1796: 0x1B53,
	0x1797: 0x1DA1,
	0x1798: 0x1E0A,
	0x1799: 0x2392,
	0x179C: 0x0296,
	0x179D: 0x0324,
	0x17A0: 0x0515,
	0x17A1: 0x1F6E,
	0x17A2: 0x0C4B,
	0x17A3: 0x2751,
	0x17A5: 0x0667,
	0x17A6: 0x1762,
	0x17A8: 0x1243,
	0x17AA: 0x04B7,
	0x17AB: 0x230E,
	0x17AD: 0x0973,
	0x17AE: 0x2222,
	0x17AF: 0x05C1,
	0x17B1: 0x0076,
	0x17B7: 0x10B5,
	0x17B8: 0x19C4,
	0x17B9: 0x1FD2,
	0x17BA: 0x2234,
	0x17BB: 0x2320,
	0x17BC: 0x0B2F,
	0x17BE: 0x088B,
	0x17C0: 0x23A8,
	0x17C4: 0x1A74,
	0x17C8: 0x0600,
	0x17C9: 0x2CC0,
	0x17CA: 0x2282,
	0x17CB: 0x0A8C,
	0x17CF: 0x205E,
	0x17D1: 0x01BA,
	0x17D2: 0x0E47,
	0x17D3: 0x1BF5,
	0x17D6: 0x01A6,
	0x17D9: 0x16A7,
	0x17DD: 0x0B55,
	0x17DE: 0x092B,
	0x17DF: 0x0C3A,
	0x17E0: 0x16BF,
	0x17E1: 0x1AC6,
	0x17E3: 0x00A9,
	0x17E6: 0x0A38,
	0x17E7: 0x1FB8,
	0x17E8: 0x268A,
	0x17E9: 0x29D9,
	0x17EA: 0x2A2D,
	0x17EC: 0x08F1,
	0x17ED: 0x2791,
	0x17F2: 0x10CD,
	0x17F3: 0x117D,
	0x17F4: 0x2B23,
	0x17F5: 0x010C,
	0x17F8: 0x116B,
	0x17FC: 0x203C,
	0x17FF: 0x03E4,
	0x1800: 0x2BB8,
	0x1801: 0x06C3,
	0x1802: 0x1067,
	0x1805: 0x1698,
	0x1807: 0x0FC9,
	0x1809: 0x05E8,
	0x180A: 0x0919,
	0x180B: 0x1B6F,
	0x180F: 0x2DD4,
	0x1811: 0x2D2C,
	0x1812: 0x18E6,
	0x1813: 0x1C40,
	0x1816: 0x11D5,
	0x181B: 0x2618,
	0x181C: 0x1630,
	0x181E: 0x00D3,
	0x1823: 0x0073,
	0x1825: 0x0E56,
	0x1826: 0x0F9D,
	0x182E: 0x07EB,
	0x182F: 0x0422,
	0x1830: 0x06BE,
	0x1831: 0x0985,
	0x1832: 0x1750,
	0x1834: 0x25B2,
	0x1837: 0x044D,
	0x1838: 0x12E5,
	0x183E: 0x0676,
	0x183F: 0x07D7,
	0x1843: 0x2AA5,
	0x1846: 0x0333,
	0x184A: 0x1129,
	0x184B: 0x1F8E,
	0x184C: 0x055A,
	0x184D: 0x2C03,
	0x184E: 0x1E7F,
	0x184F: 0x101F,
	0x1853: 0x2428,
	0x1857: 0x05FC,
	0x1858: 0x2B08,
	0x185A: 0x266F,
	0x185C: 0x0B2D,
	0x185E: 0x08D7,
	0x1861: 0x1CC9,
	0x1863: 0x2C2D,
	0x1864: 0x0AD7,
	0x1865: 0x2070,
	0x1866: 0x2510,
	0x1869: 0x22B8,
	0x186B: 0x133A,
	0x186C: 0x0246,
	0x186D: 0x1429,
	0x186F: 0x2A84,
	0x1870: 0x0F51,
	0x1871: 0x0154,
	0x1872: 0x0216,
	0x1873: 0x0FDD,
	0x1874: 0x2304,
	0x1877: 0x1C3D,
	0x1879: 0x01B4,
	0x187C: 0x1DAB,
	0x187D: 0x161E,
	0x187E: 0x1F36,
	0x187F: 0x1027,
	0x1880: 0x2603,
	0x1881: 0x2B6B,
	0x1885: 0x27DE,
	0x1886: 0x0C1D,
	0x1887: 0x0A95,
	0x1888: 0x2659,
	0x1889: 0x2C93,
	0x188A: 0x2B26,
	0x188B: 0x185C,
	0x188C: 0x11CC,
	0x189A: 0x2727,
	0x189B: 0x0094,
	0x189C: 0x1D2F,
	0x189E: 0x2E0A,
	0x189F: 0x1F24,
	0x18A0: 0x27A9,
	0x18A1: 0x0A2C,
	0x18A2: 0x21C2,
	0x18A3: 0x11C6,
	0x18A4: 0x1A1C,
	0x18A5: 0x2BB0,
	0x18A7: 0x0ADA,
	0x18A8: 0x1508,
	0x18A9: 0x1F9E,
	0x18AA: 0x24DE,
	0x18AD: 0x1309,
	0x18AE: 0x0F65,
	0x18AF: 0x20F2,
	0x18B0: 0x1B2A,
	0x18B1: 0x1DB3,
	0x18B2: 0x216C,
	0x18B3: 0x2789,
	0x18B4: 0x18EF,
	0x18B5: 0x05C4,
	0x18B6: 0x0F83,
	0x18B8: 0x28B9,
	0x18B9: 0x2A66,
	0x18BA: 0x0DF0,
	0x18BB: 0x24E9,
	0x18BE: 0x0139,
	0x18BF: 0x01BE,
	0x18C0: 0x0DBA,
	0x18C1: 0x00F4,
	0x18C2: 0x1F50,
	0x18C3: 0x25EE,
	0x18C4: 0x2CDE,
	0x18C6: 0x2B62,
	0x18C7: 0x28DA,
	0x18D2: 0x0A87,
	0x18D5: 0x1956,
	0x18D6: 0x2D70,
	0x18D7: 0x0330,
	0x18D8: 0x1C51,
	0x18D9: 0x2BA0,
	0x18DA: 0x0A75,
	0x18DB: 0x1167,
	0x18E5: 0x2106,
	0x18E6: 0x094D,
	0x18EA: 0x08ED,
	0x18EE: 0x030E,
	0x18EF: 0x1141,
	0x18F0: 0x1A70,
	0x18F1: 0x0B0D,
	0x18F5: 0x1657,
	0x18F7: 0x2934,
	0x18F9: 0x1311,
	0x18FC: 0x0F55,
	0x18FD: 0x1624,
	0x18FE: 0x2801,
	0x18FF: 0x114D,
	0x1903: 0x24EC,
	0x1905: 0x060E,
	0x1906: 0x1007,
	0x1907: 0x291D,
	0x190B: 0x02E2,
	0x190D: 0x1EA1,
	0x190E: 0x02EE,
	0x1913: 0x0B7E,
	0x1914: 0x0F6D,
	0x191B: 0x2390,
	0x191C: 0x048C,
	0x191D: 0x0594,
	0x191E: 0x0AE9,
	0x1927: 0x222E,
	0x1929: 0x1439,
	0x192B: 0x2468,
	0x192D: 0x1FCA,
	0x192F: 0x23FA,
	0x1931: 0x21A2,
	0x1932: 0x238C,
	0x1934: 0x0718,
	0x1938: 0x1063,
	0x193A: 0x2CB4,
	0x193B: 0x164C,
	0x1941: 0x15A7,
	0x1942: 0x0845,
	0x1943: 0x0D9D,
	0x1944: 0x2368,
	0x1945: 0x074B,
	0x1946: 0x0FCF,
	0x1947: 0x2DCB,
	0x1948: 0x00AC,
	0x1949: 0x015A,
	0x194D: 0x0A92,
	0x194E: 0x0D5D,
	0x1950: 0x196D,
	0x1959: 0x091F,
	0x195A: 0x157F,
	0x195B: 0x024B,
	0x195C: 0x069A,
	0x195D: 0x20E6,
	0x195E: 0x22EC,
	0x195F: 0x29FA,
	0x1962: 0x0602,
	0x1965: 0x21B0,
	0x1966: 0x2226,
	0x1969: 0x047D,
	0x196A: 0x19ED,
	0x196C: 0x061E,
	0x196D: 0x1BAF,
	0x196E: 0x0586,
	0x196F: 0x1C0F,
	0x1972: 0x01B8,
	0x1973: 0x1FA0,
	0x1974: 0x0C91,
	0x1976: 0x0F7B,
	0x1977: 0x0375,
	0x1978: 0x03D2,
	0x1979: 0x1650,
	0x197A: 0x2B2C,
	0x197D: 0x14E1,
	0x197E: 0x1009,
	0x1983: 0x2BC8,
	0x1988: 0x03F8,
	0x1989: 0x1355,
	0x198A: 0x1898,
	0x198B: 0x1C81,
	0x198C: 0x1E0D,
	0x198F: 0x05F0,
	0x1994: 0x07C3,
	0x1995: 0x2040,
	0x1996: 0x0545,
	0x1998: 0x1C0B,
	0x199C: 0x02A8,
	0x199D: 0x26A7,
	0x199E: 0x0299,
	0x199F: 0x1CCC,
	0x19A0: 0x2755,
	0x19A1: 0x2B71,
	0x19A2: 0x2DDA,
	0x19A3: 0x29EE,
	0x19A4: 0x0827,
	0x19A5: 0x0EF7,
	0x19A6: 0x1FB2,
	0x19A7: 0x22AA,
	0x19A9: 0x25CA,
	0x19AA: 0x0321,
	0x19AB: 0x0F13,
	0x19AC: 0x0400,
	0x19AD: 0x09A2,
	0x19AE: 0x1911,
	0x19AF: 0x10DB,
	0x19B0: 0x1AAB,
	0x19B1: 0x1F53,
	0x19B2: 0x2002,
	0x19B3: 0x0F29,
	0x19B4: 0x05FE,
	0x19B5: 0x04F4,
	0x19B6: 0x222A,
	0x19B7: 0x23A2,
	0x19B9: 0x1EE1,
	0x19BA: 0x262D,
	0x19BC: 0x0FA9,
	0x19BD: 0x18D0,
	0x19BE: 0x1F18,
	0x19C4: 0x0AB0,
	0x19C5: 0x1383,
	0x19C8: 0x26CB,
	0x19CC: 0x0477,
	0x19CD: 0x0103,
	0x19CE: 0x1CC0,
	0x19CF: 0x0F23,
	0x19D0: 0x2048,
	0x19D4: 0x0178,
	0x19D5: 0x2A8D,
	0x19D9: 0x22B0,
	0x19DA: 0x23AC,
	0x19DB: 0x26AB,
	0x19DC: 0x28ED,
	0x19DD: 0x0F5B,
	0x19DE: 0x1B13,
	0x19DF: 0x2B79,
	0x19E0: 0x1766,
	0x19E3: 0x1690,
	0x19E5: 0x041C,
	0x19F0: 0x1A84,
	0x19F1: 0x22D8,
	0x19F2: 0x1A7B,
	0x19F3: 0x0201,
	0x19F4: 0x2835,
	0x19FA: 0x2CA5,
	0x19FB: 0x18F4,
	0x19FD: 0x1359,
	0x1A00: 0x02D6,
	0x1A01: 0x07D2,
	0x1A02: 0x123A,
	0x1A03: 0x1E04,
	0x1A04: 0x2598,
	0x1A07: 0x051E,
	0x1A08: 0x116F,
	0x1A13: 0x00C1,
	0x1A14: 0x23B8,
	0x1A15: 0x1600,
	0x1A16: 0x00D1,
	0x1A17: 0x1206,
	0x1A18: 0x25DF,
	0x1A19: 0x111D,
	0x1A1A: 0x2E4F,
	0x1A20: 0x1043,
	0x1A21: 0x0863,
	0x1A22: 0x20FA,
	0x1A23: 0x2140,
	0x1A26: 0x1787,
	0x1A28: 0x28C2,
	0x1A2A: 0x188F,
	0x1A30: 0x1CB4,
	0x1A33: 0x052A,
	0x1A34: 0x20DA,
	0x1A37: 0x0F5F,
	0x1A39: 0x0DF2,
	0x1A3A: 0x1B59,
	0x1A3C: 0x2250,
	0x1A3E: 0x113F,
	0x1A3F: 0x1557,
	0x1A40: 0x1D38,
	0x1A41: 0x204E,
	0x1A46: 0x2C9C,
	0x1A47: 0x00B8,
	0x1A49: 0x0136,
	0x1A4A: 0x0127,
	0x1A4B: 0x1C6F,
	0x1A4C: 0x0FF7,
	0x1A4D: 0x17A9,
	0x1A4E: 0x1FF2,
	0x1A4F: 0x2286,
	0x1A50: 0x2C12,
	0x1A56: 0x2022,
	0x1A59: 0x1485,
	0x1A5E: 0x0969,
	0x1A62: 0x2064,
	0x1A63: 0x17A3,
	0x1A64: 0x0ABC,
	0x1A65: 0x05D3,
	0x1A66: 0x01AE,
	0x1A67: 0x1895,
	0x1A68: 0x2554,
	0x1A69: 0x2A99,
	0x1A6C: 0x0F0B,
	0x1A6D: 0x2997,
	0x1A70: 0x1E6A,
	0x1A78: 0x289B,
	0x1A7B: 0x1979,
	0x1A7C: 0x2AED,
	0x1A7D: 0x111F,
	0x1A7E: 0x1B20,
	0x1A80: 0x0840,
	0x1A83: 0x0626,
	0x1A84: 0x0E1A,
	0x1A86: 0x2256,
	0x1A8D: 0x03B4,
	0x1A8F: 0x1829,
	0x1A91: 0x1BD0,
	0x1A9A: 0x2ABA,
	0x1A9E: 0x24DA,
	0x1A9F: 0x100B,
	0x1AA0: 0x053F,
	0x1AA1: 0x165A,
	0x1AA6: 0x09F1,
	0x1AAA: 0x1773,
	0x1AAB: 0x0A5C,
	0x1AAC: 0x2433,
	0x1AB0: 0x2A9C,
	0x1AB1: 0x1253,
	0x1AB2: 0x1C3A,
	0x1AB3: 0x0106,
	0x1AB6: 0x0259,
	0x1AB7: 0x2612,
	0x1AB8: 0x0B93,
	0x1AB9: 0x04E7,
	0x1ABA: 0x0173,
	0x1ABB: 0x05B5,
	0x1ABC: 0x086F,
	0x1ABD: 0x1A13,
	0x1AC0: 0x2C06,
	0x1AC2: 0x218C,
	0x1AC7: 0x01F5,
	0x1AC8: 0x096D,
	0x1AC9: 0x0D9F,
	0x1ACD: 0x22C2,
	0x1AD0: 0x1061,
	0x1AD1: 0x1023,
	0x1AD2: 0x09A8,
	0x1AD3: 0x129B,
	0x1AD4: 0x1E91,
	0x1AD5: 0x11C0,
	0x1AD6: 0x17E1,
	0x1AD7: 0x0D8F,
	0x1AD8: 0x2228,
	0x1AD9: 0x16A4,
	0x1ADB: 0x1CC6,
	0x1ADD: 0x0B25,
	0x1ADE: 0x237C,
	0x1AE1: 0x2150,
	0x1AE3: 0x285F,
	0x1AE6: 0x10B9,
	0x1AE7: 0x0DAB,
	0x1AEB: 0x0F79,
	0x1AEC: 0x08BE,
	0x1AED: 0x167C,
	0x1AEF: 0x0A4D,
	0x1AF0: 0x046E,
	0x1AF1: 0x0FFB,
	0x1AF2: 0x2609,
	0x1AF3: 0x0518,
	0x1AF5: 0x22C4,
	0x1AF6: 0x2BE2,
	0x1AFA: 0x00E8,
	0x1AFD: 0x2364,
	0x1AFE: 0x0219,
	0x1B02: 0x02D2,
	0x1B05: 0x1175,
	0x1B06: 0x192D,
	0x1B07: 0x2386,
	0x1B09: 0x00D7,
	0x1B0A: 0x1628,
	0x1B0B: 0x1F38,
	0x1B0C: 0x2B7E,
	0x1B0D: 0x007F,
	0x1B10: 0x2928,
	0x1B11: 0x0EF1,
	0x1B15: 0x2DBB,
	0x1B16: 0x21CA,
	0x1B19: 0x0A3B,
	0x1B1A: 0x006D,
	0x1B26: 0x1871,
	0x1B27: 0x0005,
	0x1B28: 0x1F4A,
	0x1B29: 0x296A,
	0x1B2B: 0x25E5,
	0x1B2D: 0x0D34,
	0x1B2E: 0x10DF,
	0x1B2F: 0x1517,
	0x1B30: 0x2895,
	0x1B34: 0x1A78,
	0x1B36: 0x0B46,
	0x1B37: 0x2B4A,
	0x1B3B: 0x1748,
	0x1B3D: 0x2665,
	0x1B42: 0x1BED,
	0x1B44: 0x1B1C,
	0x1B46: 0x118C,
	0x1B47: 0x0B90,
	0x1B48: 0x0D1B,
	0x1B49: 0x26F9,
	0x1B4A: 0x2186,
	0x1B4B: 0x2C4E,
	0x1B4E: 0x1E82,
	0x1B4F: 0x0F75,
	0x1B50: 0x03D8,
	0x1B51: 0x095F,
	0x1B52: 0x1267,
	0x1B53: 0x1D2C,
	0x1B54: 0x2E19,
	0x1B55: 0x11CF,
	0x1B57: 0x126F,
	0x1B58: 0x13AB,
	0x1B59: 0x1A40,
	0x1B5B: 0x2E4C,
	0x1B5C: 0x1A20,
	0x1B5D: 0x0C21,
	0x1B5E: 0x2190,
	0x1B63: 0x0F3D,
	0x1B64: 0x1669,
	0x1B65: 0x1E25,
	0x1B66: 0x090F,
	0x1B67: 0x0254,
	0x1B68: 0x264B,
	0x1B6B: 0x2214,
	0x1B6C: 0x1EA5,
	0x1B6E: 0x1ABA,
	0x1B6F: 0x0418,
	0x1B74: 0x058C,
	0x1B7A: 0x17B3,
	0x1B7B: 0x1079,
	0x1B7C: 0x1DC2,
	0x1B82: 0x12C5,
	0x1B84: 0x00C5,
	0x1B85: 0x0895,
	0x1B87: 0x2AF9,
	0x1B88: 0x1F92,
	0x1B8B: 0x0F71,
	0x1B8D: 0x101D,
	0x1B8F: 0x0568,
	0x1B90: 0x1811,
	0x1B91: 0x2C2A,
	0x1B92: 0x02F6,
	0x1B93: 0x09FF,
	0x1B94: 0x09B6,
	0x1B95: 0x2CB7,
	0x1B9A: 0x0DC6,
	0x1B9B: 0x0FF1,
	0x1B9C: 0x226E,
	0x1BA8: 0x2420,
	0x1BAD: 0x0D6F,
	0x1BB3: 0x284A,
	0x1BB4: 0x185F,
	0x1BB5: 0x1F88,
	0x1BB6: 0x187F,
	0x1BB7: 0x29B2,
	0x1BB8: 0x2D9A,
	0x1BBA: 0x09CD,
	0x1BBC: 0x16D5,
	0x1BBD: 0x2AD2,
	0x1BBE: 0x136D,
	0x1BBF: 0x17C5,
	0x1BC0: 0x1543,
	0x1BC1: 0x2298,
	0x1BC4: 0x0E38,
	0x1BC8: 0x0875,
	0x1BC9: 0x1AB3,
	0x1BCA: 0x1246,
	0x1BCC: 0x18C1,
	0x1BCD: 0x029C,
	0x1BCE: 0x11E3,
	0x1BD0: 0x2BE8,
	0x1BD1: 0x10E5,
	0x1BD3: 0x04F0,
	0x1BD4: 0x0B8A,
	0x1BD5: 0x1503,
	0x1BD6: 0x2280,
	0x1BD7: 0x110B,
	0x1BD8: 0x056A,
	0x1BD9: 0x22B4,
	0x1BDB: 0x0A6B,
	0x1BDC: 0x027A,
	0x1BE3: 0x20FE,
	0x1BE4: 0x0031,
	0x1BE5: 0x22CA,
	0x1BE6: 0x0EB5,
	0x1BE7: 0x177B,
	0x1BE8: 0x2196,
	0x1BE9: 0x2348,
	0x1BEA: 0x125B,
	0x1BEC: 0x03BD,
	0x1BEF: 0x1E40,
	0x1BF2: 0x2366,
	0x1BF5: 0x1DDD,
	0x1BF7: 0x1075,
	0x1BF8: 0x2AAB,
	0x1BF9: 0x21F4,
	0x1BFD: 0x231A,
	0x1BFE: 0x27DB,
	0x1BFF: 0x1B6A,
	0x1C00: 0x0148,
	0x1C01: 0x2184,
	0x1C02: 0x2198,
	0x1C03: 0x2771,
	0x1C04: 0x2B97,
	0x1C0B: 0x2735,
	0x1C0D: 0x1575,
	0x1C0E: 0x228A,
	0x1C0F: 0x28B0,
	0x1C10: 0x2E04,
	0x1C13: 0x15C6,
	0x1C14: 0x286B,
	0x1C15: 0x2A9F,
	0x1C16: 0x15DA,
	0x1C18: 0x1814,
	0x1C19: 0x1CB7,
	0x1C1A: 0x1EFD,
	0x1C1B: 0x22A4,
	0x1C1C: 0x2382,
	0x1C1D: 0x00CD,
	0x1C23: 0x22FE,
	0x1C24: 0x2116,
	0x1C2B: 0x2A2A,
	0x1C30: 0x0EC5,
	0x1C31: 0x17BD,
	0x1C37: 0x1CBD,
	0x1C38: 0x20D8,
	0x1C39: 0x2138,
	0x1C3B: 0x063E,
	0x1C3C: 0x0EFB,
	0x1C3D: 0x1CA9,
	0x1C3E: 0x0991,
	0x1C3F: 0x23DC,
	0x1C44: 0x130D,
	0x1C47: 0x1B73,
	0x1C48: 0x266C,
	0x1C49: 0x28F1,
	0x1C4D: 0x1B85,
	0x1C4F: 0x23D6,
	0x1C50: 0x2979,
	0x1C51: 0x1C60,
	0x1C52: 0x2360,
	0x1C55: 0x1B7C,
	0x1C59: 0x213C,
	0x1C5A: 0x0416,
	0x1C5F: 0x081D,
	0x1C60: 0x202E,
	0x1C63: 0x0524,
	0x1C64: 0x1666,
	0x1C66: 0x0504,
	0x1C69: 0x01B0,
	0x1C6B: 0x065E,
	0x1C6C: 0x2B17,
	0x1C6D: 0x209C,
	0x1C72: 0x21CE,
	0x1C79: 0x1FD4,
	0x1C7A: 0x2174,
	0x1C7E: 0x08CF,
	0x1C7F: 0x23BA,
	0x1C81: 0x2E01,
	0x1C91: 0x1FA8,
	0x1C92: 0x231C,
	0x1C94: 0x25CD,
	0x1C98: 0x0015,
	0x1C99: 0x1740,
	0x1C9A: 0x2339,
	0x1C9B: 0x2B6E,
	0x1C9C: 0x06FA,
	0x1C9D: 0x0F99,
	0x1C9E: 0x0FA1,
	0x1C9F: 0x1DC8,
	0x1CA0: 0x2A18,
	0x1CA2: 0x0B07,
	0x1CA3: 0x0B4F,
	0x1CA5: 0x05AC,
	0x1CAA: 0x0978,
	0x1CAB: 0x1B77,
	0x1CAD: 0x1A48,
	0x1CAE: 0x1E07,
	0x1CAF: 0x237A,
	0x1CB2: 0x0D13,
	0x1CB3: 0x049C,
	0x1CB5: 0x01EB,
	0x1CBA: 0x127D,
	0x1CBB: 0x1FD8,
	0x1CBC: 0x2871,
	0x1CBD: 0x131D,
	0x1CBE: 0x0169,
	0x1CBF: 0x1B4D,
	0x1CC0: 0x2350,
	0x1CC2: 0x0A5F,
	0x1CC3: 0x1B51,
	0x1CC4: 0x005D,
	0x1CC5: 0x1A8F,
	0x1CC6: 0x20F6,
	0x1CC8: 0x0070,
	0x1CC9: 0x078C,
	0x1CCA: 0x09E3,
	0x1CD2: 0x1F68,
	0x1CD3: 0x00EB,
	0x1CD4: 0x2418,
	0x1CD6: 0x2931,
	0x1CD7: 0x0196,
	0x1CD8: 0x2483,
	0x1CDA: 0x1261,
	0x1CDB: 0x29C4,
	0x1CDE: 0x175E,
	0x1CE0: 0x1905,
	0x1CE3: 0x06C8,
	0x1CE5: 0x1FC2,
	0x1CE6: 0x1512,
	0x1CE7: 0x0943,
	0x1CE8: 0x1D77,
	0x1CE9: 0x29F7,
	0x1CEB: 0x239E,
	0x1CF1: 0x09A6,
	0x1CF2: 0x1481,
	0x1CF3: 0x2508,
	0x1CF4: 0x0957,
	0x1CF5: 0x0B37,
	0x1CF6: 0x02BA,
	0x1CF7: 0x1F3E,
	0x1CF8: 0x2530,
	0x1CF9: 0x2909,
	0x1CFA: 0x1E8E,
	0x1CFC: 0x0B10,
	0x1D00: 0x0618,
	0x1D02: 0x2DD7,
	0x1D06: 0x1F05,
	0x1D10: 0x0C55,
	0x1D11: 0x2094,
	0x1D12: 0x0F35,
	0x1D16: 0x08D3,
	0x1D1A: 0x2E0D,
	0x1D1B: 0x2CED,
	0x1D21: 0x0C7F,
	0x1D22: 0x29AC,
	0x1D25: 0x2164,
	0x1D27: 0x10B7,
	0x1D28: 0x226C,
	0x1D29: 0x11FA,
	0x1D2E: 0x061C,
	0x1D31: 0x17FC,
	0x1D33: 0x08BB,
	0x1D34: 0x259C,
	0x1D35: 0x2982,
	0x1D36: 0x2859,
	0x1D39: 0x0A81,
	0x1D3B: 0x04C9,
	0x1D3C: 0x2300,
	0x1D43: 0x17F0,
	0x1D44: 0x271E,
	0x1D45: 0x1B1A,
	0x1D48: 0x16B9,
	0x1D49: 0x1615,
	0x1D4A: 0x122A,
	0x1D4C: 0x01FE,
	0x1D4D: 0x1053,
	0x1D55: 0x2DA3,
	0x1D56: 0x282D,
	0x1D59: 0x0496,
	0x1D5A: 0x0574,
	0x1D5B: 0x2799,
	0x1D5C: 0x2D79,
	0x1D5F: 0x021F,
	0x1D63: 0x1C4E,
	0x1D64: 0x04D8,
	0x1D65: 0x1DB7,
	0x1D66: 0x1E43,
	0x1D69: 0x2146,
	0x1D6B: 0x1475,
	0x1D6C: 0x0727,
	0x1D6D: 0x08CD,
	0x1D6F: 0x1D71,
	0x1D74: 0x04A0,
	0x1D75: 0x18DA,
	0x1D76: 0x08EB,
	0x1D77: 0x18BB,
	0x1D85: 0x0971,
	0x1D86: 0x11ED,
	0x1D89: 0x20FC,
	0x1D8A: 0x2739,
	0x1D8B: 0x0683,
	0x1D8D: 0x0ECD,
	0x1D8E: 0x040C,
	0x1D8F: 0x072A,
	0x1D90: 0x085E,
	0x1D94: 0x2CF6,
	0x1D97: 0x1D9E,
	0x1D98: 0x0604,
	0x1D99: 0x10E9,
	0x1D9A: 0x2921,
	0x1D9B: 0x295E,
	0x1DA2: 0x2A87,
	0x1DA3: 0x1099,
	0x1DA4: 0x1688,
	0x1DA5: 0x20A6,
	0x1DA6: 0x249E,
	0x1DA7: 0x2D46,
	0x1DA9: 0x16B0,
	0x1DAA: 0x24AE,
	0x1DAD: 0x01C0,
	0x1DAE: 0x1F20,
	0x1DB4: 0x0A32,
	0x1DB5: 0x26E7,
	0x1DB7: 0x0572,
	0x1DB8: 0x21F6,
	0x1DB9: 0x04ED,
	0x1DBA: 0x1826,
	0x1DBB: 0x0AB9,
	0x1DBE: 0x0796,
	0x1DBF: 0x1DEF,
	0x1DC0: 0x0FCD,
	0x1DC1: 0x1E34,
	0x1DC2: 0x2078,
	0x1DC4: 0x1CFF,
	0x1DC5: 0x2D55,
	0x1DC7: 0x1B01,
	0x1DC8: 0x2785,
	0x1DC9: 0x1E76,
	0x1DCA: 0x1C1C,
	0x1DCB: 0x2D37,
	0x1DCD: 0x155B,
	0x1DCE: 0x0E3B,
	0x1DCF: 0x032A,
	0x1DD1: 0x0889,
	0x1DD2: 0x0D9B,
	0x1DD3: 0x1163,
	0x1DD4: 0x0530,
	0x1DD6: 0x0913,
	0x1DD7: 0x225C,
	0x1DD8: 0x2627,
	0x1DD9: 0x13A6,
	0x1DDA: 0x1A2D,
	0x1DDB: 0x1EA9,
	0x1DDC: 0x2687,
	0x1DDD: 0x1DBF,
	0x1DDE: 0x0055,
	0x1DDF: 0x0945,
	0x1DE0: 0x1CE7,
	0x1DE1: 0x28D7,
	0x1DE2: 0x2A63,
	0x1DE3: 0x2D7F,
	0x1DE6: 0x1C27,
	0x1DEB: 0x0CE5,
	0x1DEC: 0x17F3,
	0x1DED: 0x263F,
	0x1DEE: 0x054E,
	0x1DF0: 0x2372,
	0x1DF1: 0x2464,
	0x1DF3: 0x1C1F,
	0x1DF4: 0x089E,
	0x1DF5: 0x2540,
	0x1DF6: 0x15AF,
	0x1DF7: 0x2CBA,
	0x1DF8: 0x187D,
	0x1DFA: 0x0F89,
	0x1DFB: 0x1A56,
	0x1DFC: 0x1E64,
	0x1DFD: 0x0DDE,
	0x1DFE: 0x2018,
	0x1DFF: 0x2B8E,
	0x1E01: 0x0130,
	0x1E02: 0x1CAD,
	0x1E04: 0x07BE,
	0x1E06: 0x21C8,
	0x1E0C: 0x1479,
	0x1E0E: 0x2342,
	0x1E10: 0x0AB3,
	0x1E12: 0x0582,
	0x1E14: 0x09AE,
	0x1E15: 0x2724,
	0x1E16: 0x037E,
	0x1E17: 0x0167,
	0x1E18: 0x0C43,
	0x1E19: 0x110D,
	0x1E1A: 0x15F2,
	0x1E29: 0x0AAD,
	0x1E2A: 0x1109,
	0x1E2B: 0x0C11,
	0x1E2C: 0x1B0A,
	0x1E2D: 0x245A,
	0x1E2E: 0x2AB7,
	0x1E30: 0x1FAA,
	0x1E31: 0x057A,
	0x1E32: 0x2DE9,
	0x1E34: 0x26CF,
	0x1E35: 0x0CE0,
	0x1E36: 0x2AE9,
	0x1E3B: 0x2C57,
	0x1E3C: 0x29D3,
	0x1E3D: 0x188C,
	0x1E3E: 0x03F0,
	0x1E41: 0x2388,
	0x1E42: 0x2731,
	0x1E46: 0x1672,
	0x1E4A: 0x041E,
	0x1E4D: 0x0BD5,
	0x1E4E: 0x062A,
	0x1E4F: 0x0BED,
	0x1E50: 0x071A,
	0x1E51: 0x1B9D,
	0x1E58: 0x0ABF,
	0x1E5A: 0x0316,
	0x1E5B: 0x03F6,
	0x1E5C: 0x0D0B,
	0x1E5D: 0x1E95,
	0x1E5E: 0x1F3C,
	0x1E5F: 0x049A,
	0x1E64: 0x1E88,
	0x1E65: 0x2454,
	0x1E68: 0x22A8,
	0x1E6B: 0x2CFC,
	0x1E6C: 0x06E3,
	0x1E6E: 0x0A89,
	0x1E70: 0x1DDA,
	0x1E71: 0x22F0,
	0x1E72: 0x2B3B,
	0x1E73: 0x2D3D,
	0x1E76: 0x23A4,
	0x1E7A: 0x0E35,
	0x1E7B: 0x1093,
	0x1E7E: 0x0A44,
	0x1E7F: 0x19F2,
	0x1E81: 0x1BD5,
	0x1E88: 0x18EC,
	0x1E8B: 0x1F7E,
	0x1E8E: 0x0059,
	0x1E8F: 0x0DAD,
	0x1E90: 0x02CA,
	0x1E91: 0x1A0E,
	0x1E92: 0x05B2,
	0x1E93: 0x2A36,
	0x1E94: 0x2DAC,
	0x1E95: 0x0DE8,
	0x1E98: 0x0B8D,
	0x1E9C: 0x1727,
	0x1E9E: 0x2621,
	0x1EA2: 0x0750,
	0x1EA3: 0x11EF,
	0x1EA4: 0x1AC2,
	0x1EA5: 0x2100,
	0x1EA6: 0x24F8,
	0x1EA9: 0x10A3,
	0x1EAB: 0x04FC,
	0x1EAC: 0x2745,
	0x1EAD: 0x1192,
	0x1EAE: 0x0E5F,
	0x1EAF: 0x11E5,
	0x1EB2: 0x29A9,
	0x1EB4: 0x1F41,
	0x1EB6: 0x17CD,
	0x1EB7: 0x1335,
	0x1EB8: 0x15AB,
	0x1EB9: 0x1B37,
	0x1EBA: 0x0B81,
	0x1EC0: 0x151F,
	0x1EC1: 0x04F8,
	0x1EC2: 0x22CE,
	0x1EC3: 0x21EA,
	0x1EC4: 0x2BAC,
	0x1EC8: 0x0A3E,
	0x1EC9: 0x0FF5,
	0x1ECC: 0x1125,
	0x1ECD: 0x153B,
	0x1ECE: 0x18E0,
	0x1ED2: 0x299A,
	0x1ED9: 0x18E3,
	0x1EDA: 0x1BA6,
	0x1EDF: 0x1115,
	0x1EE0: 0x267B,
	0x1EE6: 0x04F2,
	0x1EE7: 0x1921,
	0x1EE8: 0x2ADE,
	0x1EEC: 0x0FB5,
	0x1EEF: 0x1889,
	0x1EF0: 0x008E,
	0x1EF1: 0x19FB,
	0x1EF2: 0x28F5,
	0x1EF4: 0x2CE4,
	0x1EF8: 0x17C7,
	0x1EFB: 0x2898,
	0x1EFE: 0x22D6,
	0x1EFF: 0x2538,
	0x1F00: 0x21AC,
	0x1F04: 0x2C9F,
	0x1F05: 0x22AC,
	0x1F06: 0x0FDB,
	0x1F08: 0x15D6,
	0x1F0A: 0x18AA,
	0x1F0B: 0x176C,
	0x1F12: 0x0AEC,
	0x1F14: 0x1FAE,
	0x1F15: 0x09C7,
	0x1F17: 0x0C5A,
	0x1F18: 0x2D85,
	0x1F1C: 0x00A6,
	0x1F1D: 0x1976,
	0x1F21: 0x276D,
	0x1F22: 0x0DB5,
	0x1F23: 0x2B32,
	0x1F25: 0x13BF,
	0x1F29: 0x2462,
	0x1F2C: 0x28C8,
	0x1F2D: 0x2424,
	0x1F32: 0x0E83,
	0x1F33: 0x01EE,
	0x1F34: 0x0739,
	0x1F36: 0x0A47,
	0x1F39: 0x2D73,
	0x1F3A: 0x25D0,
	0x1F3B: 0x2E2E,
	0x1F3C: 0x1FD6,
	0x1F3E: 0x1805,
	0x1F3F: 0x0D99,
	0x1F40: 0x1133,
	0x1F41: 0x1B04,
	0x1F49: 0x14EA,
	0x1F4A: 0x2D5E,
	0x1F4F: 0x21AE,
	0x1F50: 0x1BDE,
	0x1F51: 0x1CA5,
	0x1F53: 0x03E1,
	0x1F55: 0x02C2,
	0x1F5B: 0x103D,
	0x1F5C: 0x03E7,
	0x1F5D: 0x1344,
	0x1F5E: 0x1B8F,
	0x1F5F: 0x264E,
	0x1F60: 0x2194,
	0x1F62: 0x1451,
	0x1F63: 0x27E4,
	0x1F6A: 0x10D5,
	0x1F6B: 0x1157,
	0x1F6C: 0x277D,
	0x1F6D: 0x29DF,
	0x1F73: 0x1E37,
	0x1F74: 0x1C5A,
	0x1F75: 0x1ACC,
	0x1F76: 0x0915,
	0x1F7A: 0x1C32,
	0x1F7C: 0x2240,
	0x1F80: 0x10D1,
	0x1F81: 0x1119,
	0x1F82: 0x04EA,
	0x1F83: 0x121E,
	0x1F84: 0x1F66,
	0x1F85: 0x2330,
	0x1F86: 0x2E13,
	0x1F8C: 0x1F8A,
	0x1F8E: 0x0949,
	0x1F8F: 0x0414,
	0x1F91: 0x122C,
	0x1F95: 0x26FE,
	0x1F96: 0x0CBF,
	0x1F9B: 0x2486,
	0x1F9E: 0x2805,
	0x1FA0: 0x02A5,
	0x1FA6: 0x2276,
	0x1FAA: 0x0390,
	0x1FAB: 0x0404,
	0x1FAC: 0x16D1,
	0x1FAD: 0x011B,
	0x1FAE: 0x2868,
	0x1FAF: 0x1862,
	0x1FB0: 0x2318,
	0x1FB2: 0x20B6,
	0x1FB4: 0x22E4,
	0x1FB5: 0x2112,
	0x1FB6: 0x1609,
	0x1FB7: 0x04FA,
	0x1FB8: 0x12D1,
	0x1FB9: 0x1A44,
	0x1FBD: 0x00CB,
	0x1FC1: 0x1ED9,
	0x1FC2: 0x0782,
	0x1FC6: 0x2B8B,
	0x1FC9: 0x1917,
	0x1FCA: 0x1B16,
	0x1FCB: 0x02C6,
	0x1FCE: 0x2C63,
	0x1FD0: 0x2238,
	0x1FD3: 0x19DC,
	0x1FD5: 0x03A5,
	0x1FD6: 0x0035,
	0x1FD7: 0x2CAE,
	0x1FDB: 0x14FE,
	0x1FE2: 0x096B,
	0x1FE3: 0x1F96,
	0x1FE4: 0x0F3B,
	0x1FE8: 0x0AC8,
	0x1FE9: 0x0474,
	0x1FEA: 0x132B,
	0x1FEC: 0x0C89,
	0x1FF4: 0x10ED,
	0x1FF7: 0x2042,
	0x1FF9: 0x11BA,
	0x1FFD: 0x0EDD,
}

// sizeof(stringTable)  = 49343 × 1 = 49343
// sizeof(elementTable) = 11864 × 4 = 47456
// sizeof(hashTable)    =  8192 × 2 = 16384

// hashTable statistics:
// 8192 size
// 4028 entries
// ----
// 3034 entries have  0  probes
//  601 entries have  1  probes
//  187 entries have  2  probes
//  104 entries have  3  probes
//   47 entries have  4  probes
//   20 entries have  5  probes
//   13 entries have  6  probes
//    8 entries have  7  probes
//    7 entries have  8  probes
//    2 entries have  9  probes
//    3 entries have 10  probes
//    1 entries have 11  probes
//    0 entries have 12  probes
//    0 entries have 13  probes
//    0 entries have 14  probes
//    1 entries have 15+ probes
