package net.sourceforge.plantuml.math;

import static org.assertj.core.api.Assertions.assertThat;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class ASCIIMathTeXImgUnitTest {
	ASCIIMathTeXImg cut = new ASCIIMathTeXImg();

	@ParameterizedTest(name = "[{index}] {0} => {1}")
	@CsvSource({
		" !=                                                       , \\ne ",
		" !in                                                      , \\notin ",
		" (                                                        , {(} ",
		" (:                                                       , {\\langle} ",
		" )                                                        , {)} ",
		" *                                                        , \\cdot ",
		" **                                                       , \\ast ",
		" ***                                                      , \\star ",
		" +-                                                       , \\pm ",
		" -                                                        , - ",
		" -:                                                       , \\div ",
		" -<                                                       , \\prec ",
		" -<=                                                      , \\preceq ",
		" -=                                                       , \\equiv ",
		" ->                                                       , \\to ",
		" ->>                                                      , \\twoheadrightarrow ",
		" -lt                                                      , \\-lt ",
		" ...                                                      , \\ldots ",
		" /                                                        , / ",
		" //                                                       , / ",
		" /_                                                       , \\angle ",
		" /_\\                                                     , \\triangle ",
		" :)                                                       , {\\rangle} ",
		" :.                                                       , \\therefore ",
		" :=                                                       , \\:= ",
		" :}                                                       , {\\:}} ",
		" <<                                                       , {\\langle} ",
		" <=                                                       , \\le ",
		" <=>                                                      , \\Leftrightarrow ",
		" =>                                                       , \\Rightarrow ",
		" >-                                                       , \\succ ",
		" >-=                                                      , \\succeq ",
		" >->                                                      , \\rightarrowtail ",
		" >->>                                                     , \\twoheadrightarrowtail ",
		" ><|                                                      , \\rtimes ",
		" >=                                                       , \\ge ",
		" >>                                                       , {\\rangle} ",
		" @                                                        , \\circ ",
		" AA                                                       , \\forall ",
		" CC                                                       , \\mathbb{C} ",
		" Delta                                                    , \\Delta ",
		" EE                                                       , \\exists ",
		" Gamma                                                    , \\Gamma ",
		" Lambda                                                   , \\Lambda ",
		" Lamda                                                    , \\Lambda ",
		" Leftarrow                                                , \\Leftarrow ",
		" Leftrightarrow                                           , \\Leftrightarrow ",
		" Lim                                                      , \\Lim ",
		" NN                                                       , \\mathbb{N} ",
		" O/                                                       , \\emptyset ",
		" Omega                                                    , \\Omega ",
		" Phi                                                      , \\Phi ",
		" Pi                                                       , \\Pi ",
		" Psi                                                      , \\Psi ",
		" QQ                                                       , \\mathbb{Q} ",
		" RR                                                       , \\mathbb{R} ",
		" Rightarrow                                               , \\Rightarrow ",
		" Sigma                                                    , \\Sigma ",
		" TT                                                       , \\top ",
		" Theta                                                    , \\Theta ",
		" Xi                                                       , \\Xi ",
		" ZZ                                                       , \\mathbb{Z} ",
		" [                                                        , {[} ",
		" \\                                                       , \\  ",
		" \\\\                                                     , \\backslash ",
		" ]                                                        , {]} ",
		" ^                                                        , ^ ",
		" ^^                                                       , \\wedge ",
		" ^^^                                                      , \\bigwedge ",
		" _                                                        , _ ",
		" __|                                                      , \\rfloor ",
		" _|_                                                      , \\bot ",
		" abs                                                      , {\\left|\\right|} ",
		" aleph                                                    , \\aleph ",
		" alpha                                                    , \\alpha ",
		" and                                                      , {\\quad\\text{and}\\quad} ",
		" angle                                                    , \\angle ",
		" approx                                                   , \\approx ",
		" arccos                                                   , {\\arccos{}} ",
		" arcsin                                                   , {\\arcsin{}} ",
		" arctan                                                   , {\\arctan{}} ",
		" ast                                                      , \\ast ",
		" backslash                                                , \\backslash ",
		" bar                                                      , \\overline{} ",
		" bb                                                       , {\\mathbf{}} ",
		" bbb                                                      , {\\mathbb{}} ",
		" beta                                                     , \\beta ",
		" bigcap                                                   , \\bigcap ",
		" bigcup                                                   , \\bigcup ",
		" bigvee                                                   , \\bigvee ",
		" bigwedge                                                 , \\bigwedge ",
		" bot                                                      , \\bot ",
		" bowtie                                                   , \\bowtie ",
		" cap                                                      , \\cap ",
		" cdot                                                     , \\cdot ",
		" cdots                                                    , \\cdots ",
		" ceil                                                     , {\\left\\lceil\\right\\rceil} ",
		" chi                                                      , \\chi ",
		" circ                                                     , \\circ ",
		" cong                                                     , \\stackrel{\\sim}{=} ",
		" cos                                                      , {\\cos{}} ",
		" cosh                                                     , {\\cosh{}} ",
		" cot                                                      , {\\cot{}} ",
		" coth                                                     , {\\coth{}} ",
		" csc                                                      , {\\csc{}} ",
		" csch                                                     , {\\csch{}} ",
		" cup                                                      , \\cup ",
		" darr                                                     , \\downarrow ",
		" ddot                                                     , \\ddot{} ",
		" ddots                                                    , \\ddots ",
		" del                                                      , \\partial ",
		" delta                                                    , \\delta ",
		" det                                                      , {\\det{}} ",
		" diamond                                                  , \\diamond ",
		" dim                                                      , \\dim ",
		" div                                                      , \\div ",
		" divide                                                   , \\div ",
		" dot                                                      , \\dot{} ",
		" downarrow                                                , \\downarrow ",
		" dt                                                       , {\\left.{d}{t}\\right.} ",
		" dx                                                       , {\\left.{d}{x}\\right.} ",
		" dy                                                       , {\\left.{d}{y}\\right.} ",
		" dz                                                       , {\\left.{d}{z}\\right.} ",
		" emptyset                                                 , \\emptyset ",
		" epsi                                                     , \\epsilon ",
		" epsilon                                                  , \\epsilon ",
		" equiv                                                    , \\equiv ",
		" eta                                                      , \\eta ",
		" exists                                                   , \\exists ",
		" exp                                                      , {\\exp{}} ",
		" f                                                        , {f} ",
		" floor                                                    , {\\left\\lfloor\\right\\rfloor} ",
		" forall                                                   , \\forall ",
		" frown                                                    , \\frown ",
		" g                                                        , {g} ",
		" gamma                                                    , \\gamma ",
		" gcd                                                      , {\\gcd{}} ",
		" ge                                                       , \\ge ",
		" geq                                                      , \\geq ",
		" glb                                                      , \\glb ",
		" grad                                                     , \\nabla ",
		" gt                                                       , \\gt ",
		" mgt                                                      , \\gg ",
		" gt=                                                      , \\geq ",
		" hArr                                                     , \\Leftrightarrow ",
		" harr                                                     , \\leftrightarrow ",
		" hat                                                      , \\hat{} ",
		" if                                                       , {\\quad\\text{if}\\quad} ",
		" iff                                                      , \\Leftrightarrow ",
		" implies                                                  , \\Rightarrow ",
		" in                                                       , \\in ",
		" infty                                                    , \\infty ",
		" int                                                      , \\int ",
		" iota                                                     , \\iota ",
		" kappa                                                    , \\kappa ",
		" lArr                                                     , \\Leftarrow ",
		" lambda                                                   , \\lambda ",
		" lamda                                                    , \\lambda ",
		" langle                                                   , {\\langle} ",
		" larr                                                     , \\leftarrow ",
		" lceiling                                                 , \\lceil ",
		" lcm                                                      , {\\text{lcm}{}} ",
		" ldots                                                    , \\ldots ",
		" le                                                       , \\le ",
		" leftarrow                                                , \\leftarrow ",
		" leftrightarrow                                           , \\leftrightarrow ",
		" leq                                                      , \\leq ",
		" lfloor                                                   , \\lfloor ",
		" lim                                                      , \\lim ",
		" ln                                                       , {\\ln{}} ",
		" log                                                      , {\\log{}} ",
		" lt                                                       , \\lt ",
		" mlt                                                      , \\ll ",
		" lt=                                                      , \\leq ",
		" ltimes                                                   , \\ltimes ",
		" lub                                                      , \\lub ",
		" mapsto                                                   , \\mapsto ",
		" max                                                      , \\max ",
		" min                                                      , \\min ",
		" mod                                                      , \\text{mod} ",
		" models                                                   , \\models ",
		" mu                                                       , \\mu ",
		" nabla                                                    , \\nabla ",
		" ne                                                       , \\ne ",
		" neg                                                      , \\neg ",
		" nn                                                       , \\cap ",
		" nnn                                                      , \\bigcap ",
		" norm                                                     , {\\left\\|\\right\\|} ",
		" not                                                      , \\neg ",
		" notin                                                    , \\notin ",
		" nu                                                       , \\nu ",
		" o+                                                       , \\oplus ",
		" o.                                                       , \\odot ",
		" obrace                                                   , \\overbrace{} ",
		" odot                                                     , \\odot ",
		" oint                                                     , \\oint ",
		" omega                                                    , \\omega ",
		" oo                                                       , \\infty ",
		" oplus                                                    , \\oplus ",
		" or                                                       , {\\quad\\text{or}\\quad} ",
		" otimes                                                   , \\otimes ",
		" overbrace                                                , \\overbrace{} ",
		" overline                                                 , \\overline{} ",
		" ox                                                       , \\otimes ",
		" partial                                                  , \\partial ",
		" phi                                                      , \\phi ",
		" pi                                                       , \\pi ",
		" pm                                                       , \\pm ",
		" prec                                                     , \\prec ",
		" preceq                                                   , \\preceq ",
		" prod                                                     , \\prod ",
		" prop                                                     , \\propto ",
		" propto                                                   , \\propto ",
		" psi                                                      , \\psi ",
		" qquad                                                    , \\qquad ",
		" quad                                                     , \\quad ",
		" rArr                                                     , \\Rightarrow ",
		" rangle                                                   , {\\rangle} ",
		" rarr                                                     , \\rightarrow ",
		" rceiling                                                 , \\rceil ",
		" rfloor                                                   , \\rfloor ",
		" rho                                                      , \\rho ",
		" rightarrow                                               , \\rightarrow ",
		" rightarrowtail                                           , \\rightarrowtail ",
		" root                                                     , {\\sqrt[]{}} ",
		" rtimes                                                   , \\rtimes ",
		" sec                                                      , {\\sec{}} ",
		" sech                                                     , {\\sech{}} ",
		" setminus                                                 , \\setminus ",
		" sigma                                                    , \\sigma ",
		" sin                                                      , {\\sin{}} ",
		" sinh                                                     , {\\sinh{}} ",
		" sqrt                                                     , \\sqrt{} ",
		" square                                                   , \\boxempty ",
		" stackrel                                                 , {\\stackrel{}{}} ",
		" star                                                     , \\star ",
		" sub                                                      , \\subset ",
		" sube                                                     , \\subseteq ",
		" subset                                                   , \\subset ",
		" subseteq                                                 , \\subseteq ",
		" succ                                                     , \\succ ",
		" succeq                                                   , \\succeq ",
		" sum                                                      , \\sum ",
		" sup                                                      , \\supset ",
		" supe                                                     , \\supseteq ",
		" supset                                                   , \\supset ",
		" supseteq                                                 , \\supseteq ",
		" tan                                                      , {\\tan{}} ",
		" tanh                                                     , {\\tanh{}} ",
		" tau                                                      , \\tau ",
		" therefore                                                , \\therefore ",
		" theta                                                    , \\theta ",
		" tilde                                                    , \\tilde{} ",
		" times                                                    , \\times ",
		" to                                                       , \\to ",
		" top                                                      , \\top ",
		" triangle                                                 , \\triangle ",
		" twoheadrightarrow                                        , \\twoheadrightarrow ",
		" twoheadrightarrowtail                                    , \\twoheadrightarrowtail ",
		" uarr                                                     , \\uparrow ",
		" ubrace                                                   , \\underbrace{} ",
		" ul                                                       , \\underline{} ",
		" underbrace                                               , \\underbrace{} ",
		" underline                                                , \\underline{} ",
		" underset                                                 , {\\underset{}{}} ",
		" uparrow                                                  , \\uparrow ",
		" upsilon                                                  , \\upsilon ",
		" uu                                                       , \\cup ",
		" uuu                                                      , \\bigcup ",
		" varepsilon                                               , \\varepsilon ",
		" varphi                                                   , \\varphi ",
		" vartheta                                                 , \\vartheta ",
		" vdash                                                    , \\vdash ",
		" vdots                                                    , \\vdots ",
		" vec                                                      , \\vec{} ",
		" vee                                                      , \\vee ",
		" vv                                                       , \\vee ",
		" vvv                                                      , \\bigvee ",
		" wedge                                                    , \\wedge ",
		" xi                                                       , \\xi ",
		" xx                                                       , \\times ",
		" zeta                                                     , \\zeta ",
		" {                                                        , {\\lbrace} ",
		" |                                                        , {\\mid} ",
		" |--                                                      , \\vdash ",
		" |->                                                      , \\mapsto ",
		" |==                                                      , \\models ",
		" |><                                                      , \\ltimes ",
		" |><|                                                     , \\bowtie ",
		" |__                                                      , \\lfloor ",
		" |~                                                       , \\lceil ",
		" }                                                        , {\\rbrace} ",
		" ~=                                                       , \\stackrel{\\sim}{=} ",
		" ~|                                                       , \\rceil ",
		" ~~                                                       , \\approx ",
		" f(x)/g(x)                                                , \\frac{{f{{\\left({x}\\right)}}}}{{g{{\\left({x}\\right)}}}} ",
		" sin(x)/2                                                 , \\frac{{\\sin{{\\left({x}\\right)}}}}{{2}} ",
		" cosx/2                                                   , \\frac{{\\cos{{x}}}}{{2}} ",
		" absx                                                     , {\\left|{x}\\right|} ",
		" norm x                                                   , {\\left\\|{x}\\right\\|} ",
		" floor x/2                                                , \\frac{{\\left\\lfloor{x}\\right\\rfloor}}{{2}} ",
		" ceil 5.2                                                 , {\\left\\lceil{5.2}\\right\\rceil} ",
		" min_x 3                                                  , \\min_{{x}}{3} ",
		" sqrt4                                                    , \\sqrt{{4}} ",
		" sqrt(x+1)                                                , \\sqrt{{{x}+{1}}} ",
		" root(3)(x)                                               , {\\sqrt[{{3}}]{{{x}}}} ",
		" root3x                                                   , {\\sqrt[{3}]{{x}}} ",
		" stackrel3=                                               , {\\stackrel{{3}}{=}} ",
		" stackrel(3)(=)                                           , {\\stackrel{{{3}}}{{=}}} ",
		" overset(k)(=)                                            , {\\overset{{{k}}}{{=}}} ",
		" underset(k)(=)                                           , {\\underset{{{k}}}{{=}}} ",
		" tilde x                                                  , \\tilde{{x}} ",
		" hat x                                                    , \\hat{{x}} ",
		" hat(xy)                                                  , \\hat{{{x}{y}}} ",
		" bar x                                                    , \\overline{{x}} ",
		" vec x                                                    , \\vec{{x}} ",
		" vec(xy)                                                  , \\vec{{{x}{y}}} ",
		" dot x                                                    , \\dot{{x}} ",
		" ddot x                                                   , \\ddot{{x}} ",
		" ul x                                                     , \\underline{{x}} ",
		" ubrace(x+1)                                              , \\underbrace{{{x}+{1}}} ",
		" obrace(x+1)                                              , \\overbrace{{{x}+{1}}} ",
		" mbox(hi)                                                 , \\text{hi} ",
		" text(hi)                                                 , \\text{hi} ",
		" \"hi\"                                                   , \\text{hi} ",
		" cancel(x)                                                , \\cancel{{{x}}} ",
		" color(red)(x)                                            , {\\textcolor{red}{{x}}} ",
		" bb(x)                                                    , {\\mathbf{{{x}}}} ",
		" sf(x)                                                    , {\\mathsf{{{x}}}} ",
		" bbb(x)                                                   , {\\mathbb{{{x}}}} ",
		" cc(x)                                                    , {\\mathcal{{{x}}}} ",
		" tt(x)                                                    , {\\mathtt{{{x}}}} ",
		" fr(x)                                                    , {\\mathfrak{{{x}}}} ",
		" x                                                        , {x} ",
		" 2                                                        , {2} ",
		" x^2                                                      , {x}^{{2}} ",
		" x_2                                                      , {x}_{{2}} ",
		" x_2^3                                                    , {{x}_{{2}}^{{3}}} ",
		" 2/3                                                      , \\frac{{2}}{{3}} ",
		" -2/3                                                     , -\\frac{{2}}{{3}} ",
		" 2-3                                                      , {2}-{3} ",
		" (2+3)                                                    , {\\left({2}+{3}\\right)} ",
		" 2+(3/4+1)                                                , {2}+{\\left(\\frac{{3}}{{4}}+{1}\\right)} ",
		" 2+[3/4+1]                                                , {2}+{\\left[\\frac{{3}}{{4}}+{1}\\right]} ",
		" 2+|3/4+1|                                                , {2}+{\\left|\\frac{{3}}{{4}}+{1}\\right|} ",
		" '[2/3,4)'                                                , '{\\left[\\frac{{2}}{{3}},{4}\\right)}' ",
		" '{:2,3:}'                                                , '{\\left.{2},{3}\\right.}' ",
		" '<<2,3>>'                                                , '{\\left\\langle{2},{3}\\right\\rangle}' ",
		" '(:2,3:)'                                                , '{\\left\\langle{2},{3}\\right\\rangle}' ",
		" '[(2,3),(4,5)]'                                          , {\\left[\\begin{array}{cc} {2}&{3}\\\\{4}&{5}\\end{array}\\right]} ",
		" '[(2,3,4,5)]'                                            , {\\left[\\begin{array}{cccc} {2}&{3}&{4}&{5}\\end{array}\\right]} ",
		" '((1),(2))'                                              , {\\left(\\begin{array}{c} {1}\\\\{2}\\end{array}\\right)} ",
		" '{(1,if,x ge 3),(2,if,x gt 3):}'                         , {\\left\\lbrace\\begin{array}{ccc} {1}&{\\quad\\text{if}\\quad}&{x}\\ge{3}\\\\{2}&{\\quad\\text{if}\\quad}&{x}\\gt{3}\\end{array}\\right.} ",
		" '[(1,2,|,3),(4,5,|,6)]'                                  , {\\left[\\begin{array}{cc|c} {1}&{2}&{3}\\\\{4}&{5}&{6}\\end{array}\\right]} ",
		" int_2^3 3dx                                              , {\\int_{{2}}^{{3}}}{3}{\\left.{d}{x}\\right.} ",
		" sum_(n=1)^3 n                                            , {\\sum_{{{n}={1}}}^{{3}}}{n} ",
		" lim_(h->0)(f(x+h)-f(x))/h                                , \\lim_{{{h}\\to{0}}}\\frac{{{f{{\\left({x}+{h}\\right)}}}-{f{{\\left({x}\\right)}}}}}{{h}} ",
		" sin^-1(x)                                                , {{\\sin}^{{-{{1}}}}{\\left({x}\\right)}} ",
		" f(x)=sum_(n=0)^oo(f^((n))(a))/(n!)(x-a)^n                , {f{{\\left({x}\\right)}}}={\\sum_{{{n}={0}}}^{\\infty}}\\frac{{{{f}^{{{\\left({n}\\right)}}}{\\left({a}\\right)}}}}{{{n}!}}{\\left({x}-{a}\\right)}^{{n}} ",
		" f(x)=\\sum_{n=0}^\\infty\\frac{f^{(n)}(a)}{n!}(x-a)^n    , {f{{\\left({x}\\right)}}}={\\sum_{{{n}={0}}}^{\\infty}}{\\frac{{{{f}^{{{\\left({n}\\right)}}}{\\left({a}\\right)}}}}{{{n}!}}}{\\left({x}-{a}\\right)}^{{n}} ",
		" '(a,b]={x in RR | a < x <= b}'                           , '{\\left({a},{b}\\right]}={\\left\\lbrace{x}\\in\\mathbb{R}{\\mid}{a}<{x}\\le{b}\\right\\rbrace}' ",
		" abc-123.45^-1.1                                          , {a}{b}{c}-{123.45}^{{-{{1.1}}}} ",
		" stackrel\"def\"= or \\stackrel{\\Delta}{=}               , {\\stackrel{\\text{def}}{=}}{\\quad\\text{or}\\quad}{\\stackrel{{\\Delta}}{{=}}} ",
		" {::}_(\\ 92)^238U                                        , {{}_{{\\ {92}}}^{{238}}}{U} ",
		" (cancel((x+1))(x-2))/(cancel((x+1))(x+3))                , \\frac{{\\cancel{{{\\left({x}+{1}\\right)}}}{\\left({x}-{2}\\right)}}}{{\\cancel{{{\\left({x}+{1}\\right)}}}{\\left({x}+{3}\\right)}}} ",
		" a//b                                                     , {a}/{b} ",
		" int_1^3 2x dx = x^2|_1^3                                 , {\\int_{{1}}^{{3}}}{2}{x}{\\left.{d}{x}\\right.}={x}^{{2}}{{\\mid}_{{1}}^{{3}}} ",
		" log_2(x)/5                                               , \\frac{{{\\log}_{{2}}{\\left({x}\\right)}}}{{5}} ",
		" log_2(x)+5                                               , {{\\log}_{{2}}{\\left({x}\\right)}}+{5} ",
		" log_sqrt(5)3/5                                           , \\frac{{{\\log}_{\\sqrt{{{5}}}}{3}}}{{5}} ",
		" log_2^5(x)+5                                             , {{{\\log}_{{2}}^{{5}}}{\\left({x}\\right)}}+{5} ",
		" 2^f_2-3                                                  , {2}^{{f}}_{2}-{3} ",
		" f_3(x)/5                                                 , \\frac{{{f}_{{3}}{\\left({x}\\right)}}}{{5}} ",
		" 2^(f_3(x)/5)                                             , {2}^{{\\frac{{{f}_{{3}}{\\left({x}\\right)}}}{{5}}}} ",
		" log_3x^2/5                                               , \\frac{{{\\log}_{{3}}{x}^{{2}}}}{{5}} ",
		" log_3x_0/5                                               , \\frac{{{\\log}_{{3}}{x}_{{0}}}}{{5}} ",
		" sin^2(x)/5                                               , \\frac{{{\\sin}^{{2}}{\\left({x}\\right)}}}{{5}} ",
		" 3+ -4                                                    , {3}+-{4} ",
		" 3+-4                                                     , {3}\\pm{4} ",
		" 3^5.234                                                  , {3}^{{5.234}} ",
		" '3^5,233'                                                , '{3}^{{5}},{233}' ",
		" (x+1)/4                                                  , \\frac{{{x}+{1}}}{{4}} ",
		" sqrtx/4                                                  , \\frac{\\sqrt{{x}}}{{4}} ",
		" root(3)(5)/4                                             , \\frac{{\\sqrt[{{3}}]{{{5}}}}}{{4}} ",
		" 3^2/4^2                                                  , \\frac{{3}^{{2}}}{{4}^{{2}}} ",
		" 3_2/4_2                                                  , \\frac{{3}_{{2}}}{{4}_{{2}}} ",
		" 3^2/4^2                                                  , \\frac{{3}^{{2}}}{{4}^{{2}}} ",
		" 3_2/4_2                                                  , \\frac{{3}_{{2}}}{{4}_{{2}}} ",
		" 3_2^3/4_2                                                , \\frac{{{3}_{{2}}^{{3}}}}{{4}_{{2}}} ",
		" vecx/hat3+vecx^2+(vec x)^2 + vec(x^2)                    , \\frac{\\vec{{x}}}{\\hat{{3}}}+\\vec{{x}}^{{2}}+{\\left(\\vec{{x}}\\right)}^{{2}}+\\vec{{{x}^{{2}}}} ",
		" -3-4                                                     , -{3}-{4} ",
		" '(-3,-4)'                                                , '{\\left(-{3},-{4}\\right)}' ",
		" -(-2-4)-5                                                , -{\\left(-{2}-{4}\\right)}-{5} ",
		" 2_-4^-5                                                  , {{2}_{{-{{4}}}}^{{-{{5}}}}} ",
		" int_-sqrt(3)^4                                           , {\\int_{{-{\\sqrt{{{3}}}}}}^{{4}}} ",
		" -2/-3                                                    , -\\frac{{2}}{{-{{3}}}} ",
		" (-2)/-3                                                  , \\frac{{-{2}}}{{-{{3}}}} ",
		" -2/3-3/4                                                 , -\\frac{{2}}{{3}}-\\frac{{3}}{{4}} ",
		" -2^2                                                     , -{2}^{{2}} ",
		" -(x+1)/-(x+3)                                            , -\\frac{{{x}+{1}}}{{-{{\\left({x}+{3}\\right)}}}} ",
		" {:{:x:}:}                                                , {\\left.{\\left.{x}\\right.}\\right.} ",
		" {:1+{:x:}+3:}                                            , {\\left.{1}+{\\left.{x}\\right.}+{3}\\right.} ",
		" '(:2,3]'                                                 , '{\\left\\langle{2},{3}\\right]}' ",
		" '[2,3rangle'                                             , '{\\left[{2},{3}\\right\\rangle}' ",
		" '2,3)'                                                   , '{2},{3}{)}' ",
		" '(2,3'                                                   , '{\\left({2},{3}\\right.}' ",
		" '[(1,2,3,|,4),(5,6,7, |,8)]'                             , {\\left[\\begin{array}{ccc|c} {1}&{2}&{3}&{4}\\\\{5}&{6}&{7}&{8}\\end{array}\\right]} ",
		" '[(1,2,3, | ,4,5),(5,6,7, | ,8,9)]'                      , {\\left[\\begin{array}{ccc|cc} {1}&{2}&{3}&{4}&{5}\\\\{5}&{6}&{7}&{8}&{9}\\end{array}\\right]} ",
		" '[(1,|,2,3,4),(5,|,6,7,8)]'                              , {\\left[\\begin{array}{c|ccc} {1}&{2}&{3}&{4}\\\\{5}&{6}&{7}&{8}\\end{array}\\right]} ",
		" '[(1,|,3,|,4),(5,|,7,|,8)]'                              , {\\left[\\begin{array}{c|c|c} {1}&{3}&{4}\\\\{5}&{7}&{8}\\end{array}\\right]} ",
		" '[(2,|x|,5),(3,|y|,4)]'                                  , {\\left[\\begin{array}{ccc} {2}&{\\left|{x}\\right|}&{5}\\\\{3}&{\\left|{y}\\right|}&{4}\\end{array}\\right]} ",
		" '[(1,|,2,|x|,5),(3,|,4,|y|,7)]'                          , {\\left[\\begin{array}{c|ccc} {1}&{2}&{\\left|{x}\\right|}&{5}\\\\{3}&{4}&{\\left|{y}\\right|}&{7}\\end{array}\\right]} ",
		" '[(1,2,3,|,4),(5,6,7,8,9)]'                              , '{\\left[{\\left({1},{2},{3},{\\mid},{4}\\right)},{\\left({5},{6},{7},{8},{9}\\right)}\\right]}' ",
		" '[(1,2,3,|,4),(5,6,7,8)]'                                , {\\left[\\begin{array}{ccc|c} {1}&{2}&{3}&{4}\\\\{5}&{6}&{7}&{8}\\end{array}\\right]} ",
		" '[(1,2,3,4,5),(5,6,7,|,9)]'                              , '{\\left[{\\left({1},{2},{3},{4},{5}\\right)},{\\left({5},{6},{7},{\\mid},{9}\\right)}\\right]}' ",
		" '[(1,2,3,4),(5,6,7,|,9)]'                                , {\\left[\\begin{array}{cccc} {1}&{2}&{3}&{4}\\\\{5}&{6}&{7}&{9}\\end{array}\\right]} ",
		" '[(1,2,3,|),(5,6,7,|)]'                                  , {\\left[\\begin{array}{ccc|} {1}&{2}&{3}\\\\{5}&{6}&{7}\\end{array}\\right]} ",
		" '|x/2+3|,|x-4/5|'                                        , '{\\left|\\frac{{x}}{{2}}+{3}\\right|},{\\left|{x}-\\frac{{4}}{{5}}\\right|}' ",
		" int_2^4 2x dx = x^2|_2^4                                 , {\\int_{{2}}^{{4}}}{2}{x}{\\left.{d}{x}\\right.}={x}^{{2}}{{\\mid}_{{2}}^{{4}}} ",
		" 3+sin(x)/5-2Sin(x)                                       , {3}+\\frac{{\\sin{{\\left({x}\\right)}}}}{{5}}-{2}{\\Sin{{\\left({x}\\right)}}} ",
		" 5+sin(x)+Sin(x)+\"test Since\"                           , {5}+{\\sin{{\\left({x}\\right)}}}+{\\Sin{{\\left({x}\\right)}}}+\\text{test Since} ",
		" Log(x)/3 +log(x)/3                                       , \\frac{{\\Log{{\\left({x}\\right)}}}}{{3}}+\\frac{{\\log{{\\left({x}\\right)}}}}{{3}} ",
		" Abs(3) + abs(3)                                          , {\\left|{{3}}\\right|}+{\\left|{{3}}\\right|} ",
		" 3 + id(hi)(x^2)+class(red)(4)                            , {3}+{i}{d}{\\left({h}{i}\\right)}{\\left({x}^{{2}}\\right)}+{c}{l}{a}{s}{s}{\\left({r}{e}{d}\\right)}{\\left({4}\\right)} ",
		" f^2(x)/5                                                 , \\frac{{{f}^{{2}}{\\left({x}\\right)}}}{{5}} ",
		" f^2x/5                                                   , {f}^{{2}}\\frac{{x}}{{5}} ",
		" 1/f^2x^2                                                 , \\frac{{1}}{{f}^{{2}}}{x}^{{2}} ",
		" 1/fx^2                                                   , \\frac{{1}}{{f}}{x}^{{2}} ",
		" f'(x)/5                                                  , {f}'\\frac{{{x}}}{{5}} ",
		" '[[1,2]]/4'                                              , \\frac{{\\begin{array}{cc} {1}&{2}\\end{array}}}{{4}} ",
		" (x+2)/3                                                  , \\frac{{{x}+{2}}}{{3}} ",
		" u_-3 + u_- 3                                             , {u}_{{-{{3}}}}+{u}_{-}{3} ",
		" 2^- +3                                                   , {2}^{-}+{3} ",
		" '3~2,5sim4'                                              , '{3}\\sim{2},{5}\\sim{4}' ",
		" overparen(AB)                                            , \\stackrel{\\frown}{{{A}{B}}} ",
		" overarc(AB)                                              , \\stackrel{\\frown}{{{A}{B}}} ",
		" (x-+5)(xmp5)                                             , {\\left({x}\\mp{5}\\right)}{\\left({x}\\mp{5}\\right)} ",
		" 3/                                                       , \\frac{{3}}{} ",
		" 2^                                                       , {2}^{} ",
		" 2^+3                                                     , {2}^{+}{3} ",
		" /4                                                       , /{4} ",
		" lim_(x rarr 2^-) f(x)                                    , \\lim_{{{x}\\rightarrow{2}^{{-}}}}{f{{\\left({x}\\right)}}} ",
		" 1/2*(:A:|*1/2 text(bra)                                  , \\frac{{1}}{{2}}\\cdot{\\left\\langle{A}\\right|}\\cdot\\frac{{1}}{{2}}\\text{bra} ",
		" 1/2*|:B:)*1/2 text(ket)                                  , \\frac{{1}}{{2}}\\cdot{\\mid}{B}{\\rangle}\\cdot\\frac{{1}}{{2}}\\text{ket} ",
		" 1/2*(:A:|:B:)*1/2 text(bra-ket)                          , \\frac{{1}}{{2}}\\cdot{\\left\\langle{A}|{B}\\right\\rangle}\\cdot\\frac{{1}}{{2}}\\text{bra-ket} ",
		" 1/2*(:A:|:B:|:C:)*1/2 text(sandwich)                     , \\frac{{1}}{{2}}\\cdot{\\left\\langle{A}|{B}|{C}\\right\\rangle}\\cdot\\frac{{1}}{{2}}\\text{sandwich} ",
		" 1/(2/3)*(:1/2*D:|:E:)*4/(5/6) text(stretch)              , \\frac{{1}}{{\\frac{{2}}{{3}}}}\\cdot{\\left\\langle\\frac{{1}}{{2}}\\cdot{D}|{E}\\right\\rangle}\\cdot\\frac{{4}}{{\\frac{{5}}{{6}}}}\\text{stretch} ",
		" vec(x)                                                   , \\vec{{{x}}} ",
		" vecx                                                     , \\vec{{x}} ",
		" vecxyz                                                   , \\vec{{x}}{y}{z} ",
		" vec(xyx)                                                 , \\vec{{{x}{y}{x}}} ",
		" vec(x+y)                                                 , \\vec{{{x}+{y}}} ",
		" vec(sqrt(x))                                             , \\vec{{\\sqrt{{{x}}}}} ",
		" vecsqrtx                                                 , \\vec{\\sqrt{{x}}} ",
		" vecsqrt3                                                 , \\vec{\\sqrt{{3}}} ",
		" vec\"F\"                                                 , \\vec{\\text{F}} ",
		" hat(x)                                                   , \\hat{{{x}}} ",
		" hatx                                                     , \\hat{{x}} ",
		" hatxyz                                                   , \\hat{{x}}{y}{z} ",
		" hat(xyx)                                                 , \\hat{{{x}{y}{x}}} ",
		" ul(x)                                                    , \\underline{{{x}}} ",
		" ulx                                                      , \\underline{{x}} ",
		" ulxyz                                                    , \\underline{{x}}{y}{z} ",
		" ul(xyx)                                                  , \\underline{{{x}{y}{x}}} ",
		" vec()                                                    , \\vec{{()}} ",
		" text(f)                                                  , \\text{f} ",
		" text({f})                                                , \\text{{f}} ",
		" text([f])                                                , \\text{[f]} ",
		" text(  a)                                                , \\ \\text{  a} ",
		" text(  a  )b                                             , \\ \\text{  a  }\\ {b} ",
		" text<a>                                                  , \\text{<}{a}> ",
		" text<a >                                                 , \\text{<}{a}> ",
		" text{f}                                                  , \\text{f} ",
		" text[f]                                                  , \\text{f} ",
		" text{f                                                   , \\text{f} ",
		" text[f                                                   , \\text{f} ",
		" text{f abc                                               , \\text{f abc} ",
		" f'                                                       , {f}' ",
		" fprime                                                   , {f}' ",
		" f''                                                      , {f}'' ",
		" f'''                                                     , {f}''' ",
		" uArr                                                     , \\Uparrow ",
		" dArr                                                     , \\Downarrow ",
		" newline                                                  , \\\\ ",
		" a newline b                                              , {a}\\\\{b} ",
		" anewlineb                                                , {a}\\\\{b} ",
		" a^2newlinea^3                                            , {a}^{{2}}\\\\{a}^{{3}} ",
	})
	void mathUnitTest(String input, String expected) {
		final String res = cut.getTeX(input);
		assertThat(res).isEqualTo(expected);
	}
}