// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by ./generator. DO NOT EDIT.
package dynrpcserver

import (
	"context"
	"sync"

	packages "github.com/hashicorp/terraform/internal/rpcapi/terraform1/packages"
)

type Packages struct {
	impl packages.PackagesServer
	mu   sync.RWMutex
}

var _ packages.PackagesServer = (*Packages)(nil)

func NewPackagesStub() *Packages {
	return &Packages{}
}

func (s *Packages) FetchModulePackage(a0 context.Context, a1 *packages.FetchModulePackage_Request) (*packages.FetchModulePackage_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.FetchModulePackage(a0, a1)
}

func (s *Packages) FetchProviderPackage(a0 context.Context, a1 *packages.FetchProviderPackage_Request) (*packages.FetchProviderPackage_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.FetchProviderPackage(a0, a1)
}

func (s *Packages) ModulePackageSourceAddr(a0 context.Context, a1 *packages.ModulePackageSourceAddr_Request) (*packages.ModulePackageSourceAddr_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.ModulePackageSourceAddr(a0, a1)
}

func (s *Packages) ModulePackageVersions(a0 context.Context, a1 *packages.ModulePackageVersions_Request) (*packages.ModulePackageVersions_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.ModulePackageVersions(a0, a1)
}

func (s *Packages) ProviderPackageVersions(a0 context.Context, a1 *packages.ProviderPackageVersions_Request) (*packages.ProviderPackageVersions_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.ProviderPackageVersions(a0, a1)
}

func (s *Packages) ActivateRPCServer(impl packages.PackagesServer) {
	s.mu.Lock()
	s.impl = impl
	s.mu.Unlock()
}

func (s *Packages) realRPCServer() (packages.PackagesServer, error) {
	s.mu.RLock()
	impl := s.impl
	s.mu.RUnlock()
	if impl == nil {
		return nil, unavailableErr
	}
	return impl, nil
}
