/***************************************************************
 * Name:      passdialog.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#include <wx/clipbrd.h>
#include "passdialog.h"
#include "dxsettings.h"
#include "dxdefs.h"

IMPLEMENT_DYNAMIC_CLASS(PassDialog, wxDialog)

BEGIN_EVENT_TABLE(PassDialog, wxDialog)
    EVT_BUTTON(ID_BTN_COPYTO, PassDialog::OnCopyto)
END_EVENT_TABLE()

PassDialog::PassDialog(wxWindow* parent)
: wxDialog(parent, wxID_ANY, _("Information"))
{

    wxBoxSizer *mainSizer = new wxBoxSizer(wxVERTICAL);

    wxFlexGridSizer *gridSizer = new wxFlexGridSizer(2, 5, 5);
    gridSizer->Add(new wxStaticText(this, wxID_ANY, wxString::Format(_("Database password:\n\n%s\n\n(Please save it, needed for import)"), dxsettings.pk())),
                   wxSizerFlags().Align(wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL).Border(wxALL, 5));
    wxButton *copy = new wxButton(this, ID_BTN_COPYTO, _("Copy to clipboard"));
    gridSizer->Add(copy, wxSizerFlags().Align(wxALIGN_CENTER_VERTICAL).Border(wxALL, 5));
    mainSizer->Add(gridSizer, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 5);

    wxStdDialogButtonSizer *btnSizer = new wxStdDialogButtonSizer();
    wxButton* okButton = new wxButton(this, wxID_OK, "", wxDefaultPosition, wxDefaultSize, 0);
    btnSizer->AddButton(okButton);
    btnSizer->Realize();
    mainSizer->Add(btnSizer, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 5);

    this->SetSizer(mainSizer);
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
}

void PassDialog::OnCopyto(wxCommandEvent& /*event*/)
{
    if(wxTheClipboard->Open())
    {
        wxTheClipboard->SetData(new wxTextDataObject(dxsettings.pk()));
        wxTheClipboard->Close();
    }
}
