/*

NsisMultiUser.nsh - NSIS plugin that allows "per-user" (no admin required) and "per-machine" (asks elevation *only when necessary*) installations

Full source code, documentation and demos at https://github.com/Drizin/NsisMultiUser/

Copyright 2016-2023 Ricardo Drizin, Alex Mitev

File   : Include\NsisMultiUserLang.nsh
Version: 2023-02-223

*/

!ifdef LANG_ENGLISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_ENGLISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ENGLISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ENGLISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ENGLISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ENGLISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ENGLISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ENGLISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ENGLISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ENGLISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ENGLISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ENGLISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ENGLISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ENGLISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ENGLISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ENGLISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ENGLISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ENGLISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ENGLISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ENGLISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ENGLISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ENGLISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ENGLISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ENGLISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ENGLISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ENGLISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ENGLISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ENGLISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ENGLISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ENGLISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ENGLISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ENGLISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ENGLISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ENGLISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ENGLISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ENGLISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ENGLISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ENGLISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ENGLISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ENGLISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ENGLISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ENGLISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ENGLISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ENGLISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ENGLISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ENGLISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ENGLISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ENGLISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ENGLISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ENGLISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ENGLISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ENGLISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ENGLISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_AFRIKAANS
	LangString MULTIUSER_PAGE_TITLE ${LANG_AFRIKAANS} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_AFRIKAANS} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_AFRIKAANS} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_AFRIKAANS} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_AFRIKAANS} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_AFRIKAANS} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_AFRIKAANS} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_AFRIKAANS} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_AFRIKAANS} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_AFRIKAANS} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_AFRIKAANS} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_AFRIKAANS} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_AFRIKAANS} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_AFRIKAANS} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_AFRIKAANS} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_AFRIKAANS} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_AFRIKAANS} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_AFRIKAANS} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_AFRIKAANS} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_AFRIKAANS} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_AFRIKAANS} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_AFRIKAANS} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_AFRIKAANS} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_AFRIKAANS} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_AFRIKAANS} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_AFRIKAANS} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_AFRIKAANS} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_AFRIKAANS} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_AFRIKAANS} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_AFRIKAANS} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_AFRIKAANS} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_AFRIKAANS} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_AFRIKAANS} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_AFRIKAANS} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_AFRIKAANS} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_AFRIKAANS} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_AFRIKAANS} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_AFRIKAANS} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_AFRIKAANS} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_AFRIKAANS} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_AFRIKAANS} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_AFRIKAANS} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_AFRIKAANS} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_AFRIKAANS} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_AFRIKAANS} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_AFRIKAANS} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_AFRIKAANS} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_AFRIKAANS} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_AFRIKAANS} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_AFRIKAANS} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_AFRIKAANS} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_AFRIKAANS} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ALBANIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_ALBANIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ALBANIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ALBANIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ALBANIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ALBANIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ALBANIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ALBANIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ALBANIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ALBANIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ALBANIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ALBANIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ALBANIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ALBANIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ALBANIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ALBANIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ALBANIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ALBANIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ALBANIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ALBANIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ALBANIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ALBANIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ALBANIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ALBANIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ALBANIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ALBANIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ALBANIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ALBANIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ALBANIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ALBANIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ALBANIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ALBANIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ALBANIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ALBANIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ALBANIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ALBANIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ALBANIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ALBANIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ALBANIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ALBANIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ALBANIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ALBANIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ALBANIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ALBANIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ALBANIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ALBANIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ALBANIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ALBANIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ALBANIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ALBANIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ALBANIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ALBANIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ALBANIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ARABIC
	LangString MULTIUSER_PAGE_TITLE ${LANG_ARABIC} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ARABIC} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ARABIC} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ARABIC} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ARABIC} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ARABIC} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ARABIC} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ARABIC} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ARABIC} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ARABIC} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ARABIC} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ARABIC} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ARABIC} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ARABIC} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ARABIC} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ARABIC} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ARABIC} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ARABIC} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ARABIC} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ARABIC} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ARABIC} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ARABIC} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ARABIC} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ARABIC} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ARABIC} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ARABIC} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ARABIC} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ARABIC} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ARABIC} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ARABIC} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ARABIC} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ARABIC} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ARABIC} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ARABIC} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ARABIC} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ARABIC} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ARABIC} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ARABIC} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ARABIC} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ARABIC} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ARABIC} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ARABIC} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ARABIC} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ARABIC} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ARABIC} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ARABIC} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ARABIC} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ARABIC} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ARABIC} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ARABIC} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ARABIC} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ARABIC} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ARMENIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_ARMENIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ARMENIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ARMENIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ARMENIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ARMENIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ARMENIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ARMENIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ARMENIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ARMENIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ARMENIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ARMENIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ARMENIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ARMENIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ARMENIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ARMENIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ARMENIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ARMENIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ARMENIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ARMENIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ARMENIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ARMENIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ARMENIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ARMENIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ARMENIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ARMENIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ARMENIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ARMENIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ARMENIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ARMENIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ARMENIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ARMENIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ARMENIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ARMENIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ARMENIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ARMENIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ARMENIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ARMENIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ARMENIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ARMENIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ARMENIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ARMENIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ARMENIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ARMENIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ARMENIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ARMENIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ARMENIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ARMENIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ARMENIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ARMENIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ARMENIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ARMENIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ARMENIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ASTURIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_ASTURIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ASTURIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ASTURIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ASTURIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ASTURIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ASTURIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ASTURIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ASTURIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ASTURIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ASTURIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ASTURIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ASTURIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ASTURIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ASTURIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ASTURIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ASTURIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ASTURIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ASTURIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ASTURIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ASTURIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ASTURIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ASTURIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ASTURIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ASTURIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ASTURIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ASTURIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ASTURIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ASTURIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ASTURIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ASTURIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ASTURIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ASTURIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ASTURIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ASTURIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ASTURIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ASTURIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ASTURIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ASTURIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ASTURIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ASTURIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ASTURIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ASTURIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ASTURIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ASTURIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ASTURIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ASTURIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ASTURIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ASTURIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ASTURIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ASTURIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ASTURIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ASTURIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_BASQUE
	LangString MULTIUSER_PAGE_TITLE ${LANG_BASQUE} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_BASQUE} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_BASQUE} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_BASQUE} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_BASQUE} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_BASQUE} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_BASQUE} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_BASQUE} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_BASQUE} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_BASQUE} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_BASQUE} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_BASQUE} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_BASQUE} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_BASQUE} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_BASQUE} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_BASQUE} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_BASQUE} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_BASQUE} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_BASQUE} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_BASQUE} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_BASQUE} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_BASQUE} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_BASQUE} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_BASQUE} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_BASQUE} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_BASQUE} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_BASQUE} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_BASQUE} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_BASQUE} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_BASQUE} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_BASQUE} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_BASQUE} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_BASQUE} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_BASQUE} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_BASQUE} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_BASQUE} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_BASQUE} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_BASQUE} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_BASQUE} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_BASQUE} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_BASQUE} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_BASQUE} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_BASQUE} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_BASQUE} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_BASQUE} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_BASQUE} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_BASQUE} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_BASQUE} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_BASQUE} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_BASQUE} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_BASQUE} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_BASQUE} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_BELARUSIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_BELARUSIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_BELARUSIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_BELARUSIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_BELARUSIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_BELARUSIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_BELARUSIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_BELARUSIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_BELARUSIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_BELARUSIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_BELARUSIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_BELARUSIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_BELARUSIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_BELARUSIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_BELARUSIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_BELARUSIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_BELARUSIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_BELARUSIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_BELARUSIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_BELARUSIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_BELARUSIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_BELARUSIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_BELARUSIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_BELARUSIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_BELARUSIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_BELARUSIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_BELARUSIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_BELARUSIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_BELARUSIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_BELARUSIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_BELARUSIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_BELARUSIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_BELARUSIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_BELARUSIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_BELARUSIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_BELARUSIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_BELARUSIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_BELARUSIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_BELARUSIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_BELARUSIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_BELARUSIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_BELARUSIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_BELARUSIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_BELARUSIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_BELARUSIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_BELARUSIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_BELARUSIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_BELARUSIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_BELARUSIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_BELARUSIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_BELARUSIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_BELARUSIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_BELARUSIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_BOSNIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_BOSNIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_BOSNIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_BOSNIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_BOSNIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_BOSNIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_BOSNIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_BOSNIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_BOSNIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_BOSNIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_BOSNIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_BOSNIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_BOSNIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_BOSNIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_BOSNIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_BOSNIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_BOSNIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_BOSNIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_BOSNIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_BOSNIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_BOSNIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_BOSNIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_BOSNIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_BOSNIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_BOSNIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_BOSNIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_BOSNIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_BOSNIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_BOSNIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_BOSNIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_BOSNIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_BOSNIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_BOSNIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_BOSNIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_BOSNIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_BOSNIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_BOSNIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_BOSNIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_BOSNIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_BOSNIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_BOSNIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_BOSNIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_BOSNIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_BOSNIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_BOSNIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_BOSNIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_BOSNIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_BOSNIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_BOSNIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_BOSNIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_BOSNIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_BOSNIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_BOSNIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_BRETON
	LangString MULTIUSER_PAGE_TITLE ${LANG_BRETON} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_BRETON} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_BRETON} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_BRETON} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_BRETON} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_BRETON} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_BRETON} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_BRETON} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_BRETON} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_BRETON} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_BRETON} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_BRETON} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_BRETON} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_BRETON} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_BRETON} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_BRETON} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_BRETON} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_BRETON} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_BRETON} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_BRETON} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_BRETON} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_BRETON} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_BRETON} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_BRETON} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_BRETON} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_BRETON} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_BRETON} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_BRETON} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_BRETON} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_BRETON} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_BRETON} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_BRETON} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_BRETON} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_BRETON} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_BRETON} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_BRETON} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_BRETON} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_BRETON} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_BRETON} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_BRETON} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_BRETON} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_BRETON} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_BRETON} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_BRETON} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_BRETON} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_BRETON} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_BRETON} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_BRETON} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_BRETON} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_BRETON} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_BRETON} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_BRETON} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_BULGARIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_BULGARIAN} "Избор на потребители"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_BULGARIAN} "Изберете за кои потребители да се инсталира $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_BULGARIAN} "Изберете за кои потребители да се премахне $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_BULGARIAN} "Изберете дали да инсталирате $(^NameDA) за всички потребители или за текущия потребител."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_BULGARIAN} "$(^NameDA) е инсталиран едновременно за всички потребители и за текущия потребител.$\r$\nИзберете коя инсталация премахнете."
	LangString MULTIUSER_ALL_USERS ${LANG_BULGARIAN} "За &всеки, който използва този компютър (всички потребители)"
	LangString MULTIUSER_CURRENT_USER ${LANG_BULGARIAN} "За &мен ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_BULGARIAN} "За всеки, който използва този компютър (всички потребители)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_BULGARIAN} "За мен ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_BULGARIAN} "Нова инсталация за всички потребители."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_BULGARIAN} "Нова инсталация за текущия потребител."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_BULGARIAN} "Версия {VERSION} е инсталирана за всички потребители в $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_BULGARIAN} "Версия {VERSION} е инсалирана за текущия потребител в $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_BULGARIAN} "Преинсталиране на версия {VERSION} за всички потребители."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_BULGARIAN} "Преинсталиране на версия {VERSION} за текущия потребител."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_BULGARIAN} "Деинсталиране на версия {OLD_VERSION} и инсталиране на версия {VERSION} за всички потребители."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_BULGARIAN} "Деинсталиране на версия {OLD_VERSION} и инсталиране на версия {VERSION} за текущия потребител."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_BULGARIAN} "Трябва да стартирате тази програма като администратор."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_BULGARIAN} "Изисква се администраторска идентификация."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_BULGARIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_BULGARIAN} "Невалидна комбинация от параметри."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_BULGARIAN} "Няма инсталация на $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_BULGARIAN} "Операционната система не поддържа инсталации за текущия потребител."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_BULGARIAN} "Трябва да влезете с профил, който е член на администраторската група, за да продължите."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_BULGARIAN} "Операционната система не поддържа повишаване на привилегиите."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_BULGARIAN} "Не е възможно повишаване на привилегиите, услугата Secondary Logon не е пусната."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_BULGARIAN} "Не е възможно повишаване на привилегиите, грешка {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_BULGARIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_BULGARIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_BULGARIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_BULGARIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_BULGARIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_BULGARIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_BULGARIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_BULGARIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_BULGARIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_BULGARIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_BULGARIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_BULGARIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_BULGARIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_BULGARIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_BULGARIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_BULGARIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_BULGARIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_BULGARIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_BULGARIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_BULGARIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_BULGARIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_BULGARIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_BULGARIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_BULGARIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_BULGARIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_CATALAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_CATALAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_CATALAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_CATALAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_CATALAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_CATALAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_CATALAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_CATALAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_CATALAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_CATALAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_CATALAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_CATALAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_CATALAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_CATALAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_CATALAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_CATALAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_CATALAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_CATALAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_CATALAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_CATALAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_CATALAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_CATALAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_CATALAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_CATALAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_CATALAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_CATALAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_CATALAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_CATALAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_CATALAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_CATALAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_CATALAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_CATALAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_CATALAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_CATALAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_CATALAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_CATALAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_CATALAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_CATALAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_CATALAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_CATALAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_CATALAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_CATALAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_CATALAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_CATALAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_CATALAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_CATALAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_CATALAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_CATALAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_CATALAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_CATALAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_CATALAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_CATALAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_CATALAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_CORSICAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_CORSICAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_CORSICAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_CORSICAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_CORSICAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_CORSICAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_CORSICAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_CORSICAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_CORSICAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_CORSICAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_CORSICAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_CORSICAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_CORSICAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_CORSICAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_CORSICAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_CORSICAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_CORSICAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_CORSICAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_CORSICAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_CORSICAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_CORSICAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_CORSICAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_CORSICAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_CORSICAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_CORSICAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_CORSICAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_CORSICAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_CORSICAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_CORSICAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_CORSICAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_CORSICAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_CORSICAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_CORSICAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_CORSICAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_CORSICAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_CORSICAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_CORSICAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_CORSICAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_CORSICAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_CORSICAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_CORSICAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_CORSICAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_CORSICAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_CORSICAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_CORSICAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_CORSICAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_CORSICAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_CORSICAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_CORSICAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_CORSICAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_CORSICAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_CORSICAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_CORSICAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_CROATIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_CROATIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_CROATIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_CROATIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_CROATIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_CROATIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_CROATIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_CROATIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_CROATIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_CROATIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_CROATIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_CROATIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_CROATIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_CROATIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_CROATIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_CROATIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_CROATIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_CROATIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_CROATIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_CROATIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_CROATIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_CROATIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_CROATIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_CROATIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_CROATIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_CROATIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_CROATIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_CROATIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_CROATIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_CROATIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_CROATIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_CROATIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_CROATIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_CROATIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_CROATIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_CROATIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_CROATIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_CROATIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_CROATIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_CROATIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_CROATIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_CROATIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_CROATIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_CROATIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_CROATIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_CROATIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_CROATIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_CROATIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_CROATIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_CROATIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_CROATIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_CROATIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_CROATIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_CZECH
	LangString MULTIUSER_PAGE_TITLE ${LANG_CZECH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_CZECH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_CZECH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_CZECH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_CZECH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_CZECH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_CZECH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_CZECH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_CZECH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_CZECH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_CZECH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_CZECH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_CZECH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_CZECH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_CZECH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_CZECH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_CZECH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_CZECH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_CZECH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_CZECH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_CZECH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_CZECH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_CZECH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_CZECH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_CZECH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_CZECH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_CZECH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_CZECH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_CZECH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_CZECH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_CZECH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_CZECH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_CZECH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_CZECH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_CZECH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_CZECH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_CZECH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_CZECH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_CZECH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_CZECH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_CZECH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_CZECH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_CZECH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_CZECH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_CZECH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_CZECH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_CZECH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_CZECH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_CZECH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_CZECH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_CZECH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_CZECH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_DANISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_DANISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_DANISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_DANISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_DANISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_DANISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_DANISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_DANISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_DANISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_DANISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_DANISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_DANISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_DANISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_DANISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_DANISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_DANISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_DANISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_DANISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_DANISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_DANISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_DANISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_DANISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_DANISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_DANISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_DANISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_DANISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_DANISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_DANISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_DANISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_DANISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_DANISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_DANISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_DANISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_DANISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_DANISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_DANISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_DANISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_DANISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_DANISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_DANISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_DANISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_DANISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_DANISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_DANISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_DANISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_DANISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_DANISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_DANISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_DANISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_DANISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_DANISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_DANISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_DANISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_DUTCH
	LangString MULTIUSER_PAGE_TITLE ${LANG_DUTCH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_DUTCH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_DUTCH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_DUTCH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_DUTCH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_DUTCH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_DUTCH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_DUTCH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_DUTCH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_DUTCH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_DUTCH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_DUTCH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_DUTCH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_DUTCH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_DUTCH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_DUTCH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_DUTCH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_DUTCH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_DUTCH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_DUTCH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_DUTCH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_DUTCH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_DUTCH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_DUTCH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_DUTCH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_DUTCH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_DUTCH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_DUTCH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_DUTCH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_DUTCH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_DUTCH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_DUTCH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_DUTCH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_DUTCH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_DUTCH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_DUTCH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_DUTCH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_DUTCH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_DUTCH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_DUTCH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_DUTCH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_DUTCH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_DUTCH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_DUTCH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_DUTCH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_DUTCH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_DUTCH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_DUTCH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_DUTCH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_DUTCH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_DUTCH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_DUTCH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ESPERANTO
	LangString MULTIUSER_PAGE_TITLE ${LANG_ESPERANTO} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ESPERANTO} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ESPERANTO} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ESPERANTO} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ESPERANTO} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ESPERANTO} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ESPERANTO} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ESPERANTO} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ESPERANTO} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ESPERANTO} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ESPERANTO} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ESPERANTO} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ESPERANTO} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ESPERANTO} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ESPERANTO} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ESPERANTO} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ESPERANTO} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ESPERANTO} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ESPERANTO} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ESPERANTO} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ESPERANTO} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ESPERANTO} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ESPERANTO} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ESPERANTO} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ESPERANTO} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ESPERANTO} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ESPERANTO} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ESPERANTO} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ESPERANTO} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ESPERANTO} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ESPERANTO} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ESPERANTO} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ESPERANTO} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ESPERANTO} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ESPERANTO} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ESPERANTO} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ESPERANTO} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ESPERANTO} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ESPERANTO} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ESPERANTO} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ESPERANTO} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ESPERANTO} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ESPERANTO} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ESPERANTO} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ESPERANTO} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ESPERANTO} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ESPERANTO} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ESPERANTO} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ESPERANTO} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ESPERANTO} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ESPERANTO} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ESPERANTO} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ESTONIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_ESTONIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ESTONIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ESTONIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ESTONIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ESTONIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ESTONIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ESTONIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ESTONIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ESTONIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ESTONIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ESTONIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ESTONIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ESTONIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ESTONIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ESTONIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ESTONIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ESTONIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ESTONIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ESTONIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ESTONIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ESTONIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ESTONIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ESTONIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ESTONIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ESTONIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ESTONIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ESTONIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ESTONIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ESTONIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ESTONIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ESTONIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ESTONIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ESTONIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ESTONIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ESTONIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ESTONIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ESTONIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ESTONIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ESTONIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ESTONIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ESTONIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ESTONIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ESTONIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ESTONIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ESTONIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ESTONIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ESTONIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ESTONIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ESTONIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ESTONIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ESTONIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ESTONIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_FARSI
	LangString MULTIUSER_PAGE_TITLE ${LANG_FARSI} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_FARSI} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_FARSI} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_FARSI} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_FARSI} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_FARSI} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_FARSI} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_FARSI} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_FARSI} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_FARSI} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_FARSI} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_FARSI} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_FARSI} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_FARSI} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_FARSI} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_FARSI} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_FARSI} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_FARSI} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_FARSI} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_FARSI} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_FARSI} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_FARSI} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_FARSI} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_FARSI} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_FARSI} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_FARSI} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_FARSI} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_FARSI} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_FARSI} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_FARSI} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_FARSI} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_FARSI} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_FARSI} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_FARSI} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_FARSI} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_FARSI} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_FARSI} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_FARSI} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_FARSI} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_FARSI} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_FARSI} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_FARSI} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_FARSI} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_FARSI} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_FARSI} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_FARSI} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_FARSI} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_FARSI} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_FARSI} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_FARSI} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_FARSI} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_FARSI} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_FINNISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_FINNISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_FINNISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_FINNISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_FINNISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_FINNISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_FINNISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_FINNISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_FINNISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_FINNISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_FINNISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_FINNISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_FINNISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_FINNISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_FINNISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_FINNISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_FINNISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_FINNISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_FINNISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_FINNISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_FINNISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_FINNISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_FINNISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_FINNISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_FINNISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_FINNISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_FINNISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_FINNISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_FINNISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_FINNISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_FINNISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_FINNISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_FINNISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_FINNISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_FINNISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_FINNISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_FINNISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_FINNISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_FINNISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_FINNISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_FINNISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_FINNISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_FINNISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_FINNISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_FINNISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_FINNISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_FINNISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_FINNISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_FINNISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_FINNISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_FINNISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_FINNISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_FINNISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_FRENCH
	LangString MULTIUSER_PAGE_TITLE ${LANG_FRENCH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_FRENCH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_FRENCH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_FRENCH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_FRENCH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_FRENCH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_FRENCH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_FRENCH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_FRENCH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_FRENCH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_FRENCH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_FRENCH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_FRENCH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_FRENCH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_FRENCH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_FRENCH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_FRENCH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_FRENCH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_FRENCH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_FRENCH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_FRENCH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_FRENCH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_FRENCH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_FRENCH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_FRENCH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_FRENCH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_FRENCH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_FRENCH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_FRENCH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_FRENCH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_FRENCH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_FRENCH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_FRENCH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_FRENCH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_FRENCH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_FRENCH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_FRENCH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_FRENCH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_FRENCH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_FRENCH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_FRENCH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_FRENCH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_FRENCH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_FRENCH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_FRENCH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_FRENCH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_FRENCH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_FRENCH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_FRENCH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_FRENCH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_FRENCH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_FRENCH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_GALICIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_GALICIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_GALICIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_GALICIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_GALICIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_GALICIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_GALICIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_GALICIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_GALICIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_GALICIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_GALICIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_GALICIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_GALICIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_GALICIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_GALICIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_GALICIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_GALICIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_GALICIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_GALICIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_GALICIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_GALICIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_GALICIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_GALICIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_GALICIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_GALICIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_GALICIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_GALICIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_GALICIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_GALICIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_GALICIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_GALICIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_GALICIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_GALICIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_GALICIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_GALICIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_GALICIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_GALICIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_GALICIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_GALICIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_GALICIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_GALICIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_GALICIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_GALICIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_GALICIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_GALICIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_GALICIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_GALICIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_GALICIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_GALICIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_GALICIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_GALICIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_GALICIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_GALICIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_GEORGIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_GEORGIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_GEORGIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_GEORGIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_GEORGIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_GEORGIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_GEORGIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_GEORGIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_GEORGIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_GEORGIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_GEORGIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_GEORGIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_GEORGIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_GEORGIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_GEORGIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_GEORGIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_GEORGIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_GEORGIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_GEORGIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_GEORGIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_GEORGIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_GEORGIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_GEORGIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_GEORGIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_GEORGIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_GEORGIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_GEORGIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_GEORGIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_GEORGIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_GEORGIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_GEORGIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_GEORGIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_GEORGIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_GEORGIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_GEORGIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_GEORGIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_GEORGIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_GEORGIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_GEORGIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_GEORGIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_GEORGIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_GEORGIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_GEORGIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_GEORGIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_GEORGIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_GEORGIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_GEORGIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_GEORGIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_GEORGIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_GEORGIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_GEORGIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_GEORGIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_GEORGIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_GERMAN
	; Translation on 2019-03-29 done by: https://github.com/Tobias-B-Besemer
	LangString MULTIUSER_PAGE_TITLE ${LANG_GERMAN} "Wähle Benutzer"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_GERMAN} "Wähle für welche Benutzer $(^NameDA) installiert werden soll."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_GERMAN} "Wähle für welche Benutzer $(^NameDA) entfernt werden soll."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_GERMAN} "Selektiere entweder $(^NameDA) zu installieren für alle Benutzer, oder für aktuellen Benutzer."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_GERMAN} "$(^NameDA) ist installiert für beides, für alle Benutzer und für aktuellen Benutzer.$\r$\nWähle, welche Installation entfernt werden soll."
	LangString MULTIUSER_ALL_USERS ${LANG_GERMAN} "Für &jeden, der diesen Computer benutzt (alle Benutzer)"
	LangString MULTIUSER_CURRENT_USER ${LANG_GERMAN} "Für &mich ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_GERMAN} "Für jeden, der diesen Computer benutzt (alle Benutzer)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_GERMAN} "Für mich ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_GERMAN} "Frische Installation für alle Benutzer."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_GERMAN} "Frische Installation für aktuellen Benutzer."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_GERMAN} "Version {VERSION} ist installiert für alle Benutzer in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_GERMAN} "Version {VERSION} ist installiert für aktuellen Benutzer in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_GERMAN} "Neuinstallation Version {VERSION} für alle Benutzer."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_GERMAN} "Neuinstallation Version {VERSION} für aktuellen Benutzer."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_GERMAN} "Deinstallation Version {OLD_VERSION} und Installation Version {VERSION} für alle Benutzer."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_GERMAN} "Deinstallation Version {OLD_VERSION} und Installation Version {VERSION} für aktuellen Benutzer."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_GERMAN} "Du musst dieses Programm als Administrator ausführen."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_GERMAN} "Administrator Anmeldedaten benötigt."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_GERMAN} "Administrator Anmeldedaten benötigt für Deinstallation."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_GERMAN} "Unzulässige Kombination von Parametern."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_GERMAN} "Dort ist keine Installation von $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_GERMAN} "Das Betriebssystem unterstützt nicht Aktuelle-Benutzer-Installationen."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_GERMAN} "Du musst Dich mit einem Konto, dass ein Mitglied der Administratoren Gruppe ist, anmelden um fortzufahren."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_GERMAN} "Das Betriebssystem unterstützt nicht Hochstuffung."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_GERMAN} "Hochstuffung nicht möglich, zweiter Anmelde-Service läuft nicht."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_GERMAN} "Hochstuffung nicht möglich, Fehler {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_GERMAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_GERMAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_GERMAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_GERMAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_GERMAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_GERMAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_GERMAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_GERMAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_GERMAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_GERMAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_GERMAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_GERMAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_GERMAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_GERMAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_GERMAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_GERMAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_GERMAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_GERMAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_GERMAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_GERMAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_GERMAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_GERMAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_GERMAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_GERMAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_GERMAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_GREEK
	LangString MULTIUSER_PAGE_TITLE ${LANG_GREEK} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_GREEK} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_GREEK} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_GREEK} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_GREEK} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_GREEK} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_GREEK} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_GREEK} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_GREEK} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_GREEK} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_GREEK} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_GREEK} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_GREEK} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_GREEK} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_GREEK} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_GREEK} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_GREEK} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_GREEK} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_GREEK} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_GREEK} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_GREEK} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_GREEK} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_GREEK} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_GREEK} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_GREEK} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_GREEK} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_GREEK} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_GREEK} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_GREEK} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_GREEK} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_GREEK} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_GREEK} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_GREEK} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_GREEK} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_GREEK} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_GREEK} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_GREEK} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_GREEK} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_GREEK} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_GREEK} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_GREEK} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_GREEK} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_GREEK} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_GREEK} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_GREEK} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_GREEK} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_GREEK} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_GREEK} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_GREEK} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_GREEK} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_GREEK} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_GREEK} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_HEBREW
	LangString MULTIUSER_PAGE_TITLE ${LANG_HEBREW} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_HEBREW} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_HEBREW} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_HEBREW} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_HEBREW} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_HEBREW} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_HEBREW} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_HEBREW} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_HEBREW} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_HEBREW} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_HEBREW} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_HEBREW} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_HEBREW} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_HEBREW} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_HEBREW} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_HEBREW} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_HEBREW} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_HEBREW} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_HEBREW} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_HEBREW} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_HEBREW} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_HEBREW} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_HEBREW} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_HEBREW} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_HEBREW} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_HEBREW} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_HEBREW} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_HEBREW} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_HEBREW} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_HEBREW} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_HEBREW} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_HEBREW} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_HEBREW} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_HEBREW} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_HEBREW} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_HEBREW} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_HEBREW} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_HEBREW} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_HEBREW} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_HEBREW} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_HEBREW} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_HEBREW} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_HEBREW} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_HEBREW} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_HEBREW} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_HEBREW} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_HEBREW} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_HEBREW} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_HEBREW} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_HEBREW} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_HEBREW} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_HEBREW} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_HUNGARIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_HUNGARIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_HUNGARIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_HUNGARIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_HUNGARIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_HUNGARIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_HUNGARIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_HUNGARIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_HUNGARIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_HUNGARIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_HUNGARIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_HUNGARIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_HUNGARIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_HUNGARIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_HUNGARIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_HUNGARIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_HUNGARIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_HUNGARIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_HUNGARIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_HUNGARIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_HUNGARIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_HUNGARIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_HUNGARIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_HUNGARIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_HUNGARIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_HUNGARIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_HUNGARIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_HUNGARIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_HUNGARIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_HUNGARIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_HUNGARIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_HUNGARIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_HUNGARIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_HUNGARIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_HUNGARIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_HUNGARIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_HUNGARIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_HUNGARIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_HUNGARIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_HUNGARIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_HUNGARIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_HUNGARIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_HUNGARIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_HUNGARIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_HUNGARIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_HUNGARIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_HUNGARIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_HUNGARIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_HUNGARIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_HUNGARIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_HUNGARIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_HUNGARIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_HUNGARIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ICELANDIC
	LangString MULTIUSER_PAGE_TITLE ${LANG_ICELANDIC} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ICELANDIC} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ICELANDIC} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ICELANDIC} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ICELANDIC} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ICELANDIC} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ICELANDIC} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ICELANDIC} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ICELANDIC} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ICELANDIC} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ICELANDIC} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ICELANDIC} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ICELANDIC} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ICELANDIC} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ICELANDIC} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ICELANDIC} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ICELANDIC} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ICELANDIC} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ICELANDIC} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ICELANDIC} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ICELANDIC} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ICELANDIC} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ICELANDIC} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ICELANDIC} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ICELANDIC} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ICELANDIC} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ICELANDIC} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ICELANDIC} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ICELANDIC} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ICELANDIC} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ICELANDIC} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ICELANDIC} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ICELANDIC} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ICELANDIC} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ICELANDIC} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ICELANDIC} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ICELANDIC} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ICELANDIC} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ICELANDIC} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ICELANDIC} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ICELANDIC} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ICELANDIC} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ICELANDIC} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ICELANDIC} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ICELANDIC} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ICELANDIC} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ICELANDIC} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ICELANDIC} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ICELANDIC} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ICELANDIC} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ICELANDIC} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ICELANDIC} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_INDONESIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_INDONESIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_INDONESIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_INDONESIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_INDONESIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_INDONESIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_INDONESIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_INDONESIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_INDONESIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_INDONESIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_INDONESIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_INDONESIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_INDONESIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_INDONESIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_INDONESIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_INDONESIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_INDONESIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_INDONESIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_INDONESIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_INDONESIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_INDONESIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_INDONESIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_INDONESIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_INDONESIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_INDONESIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_INDONESIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_INDONESIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_INDONESIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_INDONESIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_INDONESIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_INDONESIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_INDONESIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_INDONESIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_INDONESIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_INDONESIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_INDONESIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_INDONESIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_INDONESIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_INDONESIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_INDONESIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_INDONESIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_INDONESIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_INDONESIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_INDONESIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_INDONESIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_INDONESIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_INDONESIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_INDONESIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_INDONESIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_INDONESIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_INDONESIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_INDONESIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_INDONESIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_IRISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_IRISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_IRISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_IRISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_IRISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_IRISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_IRISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_IRISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_IRISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_IRISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_IRISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_IRISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_IRISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_IRISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_IRISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_IRISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_IRISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_IRISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_IRISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_IRISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_IRISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_IRISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_IRISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_IRISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_IRISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_IRISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_IRISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_IRISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_IRISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_IRISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_IRISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_IRISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_IRISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_IRISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_IRISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_IRISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_IRISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_IRISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_IRISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_IRISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_IRISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_IRISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_IRISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_IRISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_IRISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_IRISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_IRISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_IRISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_IRISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_IRISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_IRISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_IRISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_IRISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ITALIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_ITALIAN} "Scegli utente"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ITALIAN} "Scegli per quali utenti installare '$(^NameDA)'."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ITALIAN} "Scegli per quali utenti rimuovere '$(^NameDA)'."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ITALIAN} "Seleziona se installare $(^NameDA) per tutti gli utenti o per l'utente attuale."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ITALIAN} "$(^NameDA) è installato sia per tutti gli utenti che per l'utente attuale.$\r$\nSeleziona quale installazione rimuovere."
	LangString MULTIUSER_ALL_USERS ${LANG_ITALIAN} "Per &chiunque usa questo computer (tutti gli utenti)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ITALIAN} "Per &l'utente attuale ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ITALIAN} "Per chiunque usa questo computer (tutti gli utenti)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ITALIAN} "Per l'utente attuale ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ITALIAN} "Nuova installazione per tutti gli utenti."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ITALIAN} "Nuova installazione per l'utente attuale."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ITALIAN} "La versione '{VERSION}' è installata per tutti gli utenti in '{FOLDER}'."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ITALIAN} "La versione '{VERSION}' è installata per l'utente attuale in '{FOLDER}'."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ITALIAN} "Reinstalla la versione '{VERSION}' per tutti gli utenti."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ITALIAN} "Reinstalla la versione '{VERSION}' per l'utente attuale."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ITALIAN} "Disinstalla la versione '{OLD_VERSION}' e installa la versione '{VERSION}' per tutti gli utenti."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ITALIAN} "Disinstalla la versione '{OLD_VERSION}' e installa la versione '{VERSION}' per l'utente attuale."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ITALIAN} "Devi eseguire questo programma come amministratore."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ITALIAN} "Per l'installazione sono richiesti i diritti di amministratore."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ITALIAN} "Per la disinstallazione sono richiesti i diritti di amministratore."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ITALIAN} "Combinazione di parametri non valida."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ITALIAN} "Non è prevista l'installazione di $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ITALIAN} "Il sistema operativo non supporta le installazioni degli utenti attuali."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ITALIAN} "Per continuare devi accedere con un account che è un membro del gruppo amministratori."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ITALIAN} "Il sistema operativo non supporta l'elevazione."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ITALIAN} "Impossibile eseguire l'elevazione, il servizio di accesso secondario non è in esecuzione."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ITALIAN} "Impossibile elevare, errore '{ERROR}'."
	; overwrite default text string
	LangString MUI_TEXT_FINISH_INFO_REBOOT ${LANG_ITALIAN} "Per completare l'installazione di $(^NameDA) il computer deve essere riavviato.$\r$\n$\r$\nVuoi riavviarlo ora?"
	LangString MUI_UNTEXT_FINISH_INFO_REBOOT ${LANG_ITALIAN} "Per completare la disinstallazione di $(^NameDA) il computer deve essere riavviato.$\r$\n$\r$\nVuoi riavviarlo ora?"
	LangString MUI_TEXT_LICENSE_SUBTITLE ${LANG_ITALIAN} "Prima di installare $(^NameDA) leggi le condizioni dell'accordo di licenza."
	LangString MUI_UNTEXT_LICENSE_SUBTITLE ${LANG_ITALIAN} "Prima di installare $(^NameDA) leggi le condizioni dell'accordo di licenza."
	LangString MUI_INNERTEXT_LICENSE_BOTTOM_RADIOBUTTONS ${LANG_ITALIAN} "Se accetti i termini dell'accordo di licenza, seleziona la prima opzione sottostante.$\r$\nPer installare $(^NameDA) è necessario accettare i termini della licenza d'uso.$\r$\n$_CLICK"
	LangString MUI_TEXT_WELCOME_INFO_TEXT ${LANG_ITALIAN} "Questo programma installerà $(^NameDA) nel computer.$\r$\n$\r$\nPrima di iniziare l'installazione ti consigliamo di chiudere tutte le altre applicazioni.$\r$\n$\r$\nQuesto permetterà al programma di installazione di aggiornare i file di sistema senza dover riavviare il computer.$\r$\n$\r$\n$_CLICK"
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ITALIAN} "File programma (richiesti)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ITALIAN} "Questi sono i file di base necessari per il funzionamento di ${prodname} (richiesti)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ITALIAN} "Collegamenti"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ITALIAN} "Crea i collegamenti a ${prodname}"
	LangString SECTION_START_MENU_NAME ${LANG_ITALIAN} "Menu Start"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ITALIAN} "Crea un collegamento nel menu Start."
	LangString SECTION_DESKTOP_NAME ${LANG_ITALIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ITALIAN} "Crea un collegamento sul desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ITALIAN} "Avvio rapido"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ITALIAN} "Crea un collegamento in Avvio rapido."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ITALIAN} "File traduzione interfaccia"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ITALIAN} "Installa i file della lingua necessari per usare ${prodname} nella tua lingua."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ITALIAN} "Modulo sovrascrittura"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ITALIAN} "Aggiunge un'opzione per eliminare i file dal menu di scelta rapida dei file in Esplora risorse."
	LangString SECTION_UNINSTALL_NAME ${LANG_ITALIAN} "Modulo disinstallazione"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ITALIAN} "Installa il modulo per la disinstallazione del programma."
	LangString UNINSTALL_TEXT ${LANG_ITALIAN} "${prodname} verrà disinstallato dalla seguente cartella.$\r$\nAVVISO: il programma di disinstallazione rimuove completamente la cartella di installazione, inclusi tutti i file (come i programmi di pulizia personalizzati) eventualmente aggiunti o modificati."
	LangString ALREADY_INSTALLED ${LANG_ITALIAN} "${prodname} è già installato.$\r$\nSeleziona 'OK' per disinstallare prima la versione installata, o 'Annulla' per interrompere l'aggiornamento."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ITALIAN} "Sovrascrivi con ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ITALIAN} "Visita il sito di ${prodname}"
	LangString MULTIPRINT1 ${LANG_ITALIAN} "Il passaggio successivo è la creazione della cache delle font, durante la quale potresti vedere una finestra nera."
	LangString MULTIPRINT2 ${LANG_ITALIAN} "Di solito questo passaggio richiede un minuto, ma a volte ci possono volere dieci minuti."
	LangString SHORTCUT_NO_UAC ${LANG_ITALIAN} "${prodname} senza UAC"
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ITALIAN} "${prodname} con terminale debug"
	LangString INSTALLER_CAPTION ${LANG_ITALIAN} "Installazione di ${prodname} ${VERSION}"
!endif

!ifdef LANG_JAPANESE
	LangString MULTIUSER_PAGE_TITLE ${LANG_JAPANESE} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_JAPANESE} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_JAPANESE} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_JAPANESE} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_JAPANESE} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_JAPANESE} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_JAPANESE} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_JAPANESE} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_JAPANESE} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_JAPANESE} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_JAPANESE} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_JAPANESE} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_JAPANESE} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_JAPANESE} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_JAPANESE} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_JAPANESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_JAPANESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_JAPANESE} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_JAPANESE} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_JAPANESE} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_JAPANESE} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_JAPANESE} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_JAPANESE} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_JAPANESE} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_JAPANESE} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_JAPANESE} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_JAPANESE} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_JAPANESE} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_JAPANESE} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_JAPANESE} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_JAPANESE} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_JAPANESE} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_JAPANESE} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_JAPANESE} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_JAPANESE} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_JAPANESE} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_JAPANESE} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_JAPANESE} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_JAPANESE} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_JAPANESE} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_JAPANESE} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_JAPANESE} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_JAPANESE} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_JAPANESE} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_JAPANESE} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_JAPANESE} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_JAPANESE} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_JAPANESE} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_JAPANESE} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_JAPANESE} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_JAPANESE} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_JAPANESE} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_KOREAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_KOREAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_KOREAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_KOREAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_KOREAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_KOREAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_KOREAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_KOREAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_KOREAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_KOREAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_KOREAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_KOREAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_KOREAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_KOREAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_KOREAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_KOREAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_KOREAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_KOREAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_KOREAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_KOREAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_KOREAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_KOREAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_KOREAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_KOREAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_KOREAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_KOREAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_KOREAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_KOREAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_KOREAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_KOREAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_KOREAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_KOREAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_KOREAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_KOREAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_KOREAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_KOREAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_KOREAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_KOREAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_KOREAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_KOREAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_KOREAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_KOREAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_KOREAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_KOREAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_KOREAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_KOREAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_KOREAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_KOREAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_KOREAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_KOREAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_KOREAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_KOREAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_KOREAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_KURDISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_KURDISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_KURDISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_KURDISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_KURDISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_KURDISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_KURDISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_KURDISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_KURDISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_KURDISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_KURDISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_KURDISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_KURDISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_KURDISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_KURDISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_KURDISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_KURDISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_KURDISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_KURDISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_KURDISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_KURDISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_KURDISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_KURDISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_KURDISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_KURDISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_KURDISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_KURDISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_KURDISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_KURDISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_KURDISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_KURDISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_KURDISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_KURDISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_KURDISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_KURDISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_KURDISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_KURDISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_KURDISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_KURDISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_KURDISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_KURDISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_KURDISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_KURDISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_KURDISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_KURDISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_KURDISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_KURDISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_KURDISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_KURDISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_KURDISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_KURDISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_KURDISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_KURDISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_LATVIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_LATVIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_LATVIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_LATVIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_LATVIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_LATVIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_LATVIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_LATVIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_LATVIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_LATVIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_LATVIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_LATVIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_LATVIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_LATVIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_LATVIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_LATVIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_LATVIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_LATVIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_LATVIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_LATVIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_LATVIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_LATVIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_LATVIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_LATVIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_LATVIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_LATVIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_LATVIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_LATVIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_LATVIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_LATVIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_LATVIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_LATVIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_LATVIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_LATVIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_LATVIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_LATVIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_LATVIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_LATVIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_LATVIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_LATVIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_LATVIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_LATVIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_LATVIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_LATVIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_LATVIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_LATVIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_LATVIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_LATVIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_LATVIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_LATVIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_LATVIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_LATVIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_LATVIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_LITHUANIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_LITHUANIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_LITHUANIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_LITHUANIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_LITHUANIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_LITHUANIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_LITHUANIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_LITHUANIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_LITHUANIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_LITHUANIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_LITHUANIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_LITHUANIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_LITHUANIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_LITHUANIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_LITHUANIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_LITHUANIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_LITHUANIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_LITHUANIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_LITHUANIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_LITHUANIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_LITHUANIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_LITHUANIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_LITHUANIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_LITHUANIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_LITHUANIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_LITHUANIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_LITHUANIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_LITHUANIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_LITHUANIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_LITHUANIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_LITHUANIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_LITHUANIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_LITHUANIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_LITHUANIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_LITHUANIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_LITHUANIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_LITHUANIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_LITHUANIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_LITHUANIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_LITHUANIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_LITHUANIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_LITHUANIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_LITHUANIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_LITHUANIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_LITHUANIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_LITHUANIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_LITHUANIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_LITHUANIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_LITHUANIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_LITHUANIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_LITHUANIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_LITHUANIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_LITHUANIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_LUXEMBOURGISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_LUXEMBOURGISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_LUXEMBOURGISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_LUXEMBOURGISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_LUXEMBOURGISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_LUXEMBOURGISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_LUXEMBOURGISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_LUXEMBOURGISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_LUXEMBOURGISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_LUXEMBOURGISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_LUXEMBOURGISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_LUXEMBOURGISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_LUXEMBOURGISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_LUXEMBOURGISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_LUXEMBOURGISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_LUXEMBOURGISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_LUXEMBOURGISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_LUXEMBOURGISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_LUXEMBOURGISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_LUXEMBOURGISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_LUXEMBOURGISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_LUXEMBOURGISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_LUXEMBOURGISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_LUXEMBOURGISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_LUXEMBOURGISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_LUXEMBOURGISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_LUXEMBOURGISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_LUXEMBOURGISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_LUXEMBOURGISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_LUXEMBOURGISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_LUXEMBOURGISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_LUXEMBOURGISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_LUXEMBOURGISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_LUXEMBOURGISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_LUXEMBOURGISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_LUXEMBOURGISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_LUXEMBOURGISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_LUXEMBOURGISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_LUXEMBOURGISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_LUXEMBOURGISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_LUXEMBOURGISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_LUXEMBOURGISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_LUXEMBOURGISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_LUXEMBOURGISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_LUXEMBOURGISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_LUXEMBOURGISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_LUXEMBOURGISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_LUXEMBOURGISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_LUXEMBOURGISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_LUXEMBOURGISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_LUXEMBOURGISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_LUXEMBOURGISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_LUXEMBOURGISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_MACEDONIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_MACEDONIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_MACEDONIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_MACEDONIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_MACEDONIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_MACEDONIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_MACEDONIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_MACEDONIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_MACEDONIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_MACEDONIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_MACEDONIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_MACEDONIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_MACEDONIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_MACEDONIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_MACEDONIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_MACEDONIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_MACEDONIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_MACEDONIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_MACEDONIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_MACEDONIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_MACEDONIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_MACEDONIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_MACEDONIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_MACEDONIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_MACEDONIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_MACEDONIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_MACEDONIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_MACEDONIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_MACEDONIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_MACEDONIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_MACEDONIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_MACEDONIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_MACEDONIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_MACEDONIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_MACEDONIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_MACEDONIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_MACEDONIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_MACEDONIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_MACEDONIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_MACEDONIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_MACEDONIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_MACEDONIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_MACEDONIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_MACEDONIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_MACEDONIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_MACEDONIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_MACEDONIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_MACEDONIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_MACEDONIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_MACEDONIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_MACEDONIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_MACEDONIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_MACEDONIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_MALAY
	LangString MULTIUSER_PAGE_TITLE ${LANG_MALAY} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_MALAY} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_MALAY} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_MALAY} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_MALAY} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_MALAY} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_MALAY} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_MALAY} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_MALAY} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_MALAY} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_MALAY} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_MALAY} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_MALAY} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_MALAY} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_MALAY} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_MALAY} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_MALAY} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_MALAY} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_MALAY} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_MALAY} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_MALAY} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_MALAY} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_MALAY} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_MALAY} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_MALAY} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_MALAY} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_MALAY} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_MALAY} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_MALAY} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_MALAY} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_MALAY} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_MALAY} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_MALAY} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_MALAY} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_MALAY} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_MALAY} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_MALAY} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_MALAY} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_MALAY} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_MALAY} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_MALAY} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_MALAY} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_MALAY} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_MALAY} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_MALAY} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_MALAY} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_MALAY} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_MALAY} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_MALAY} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_MALAY} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_MALAY} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_MALAY} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_MONGOLIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_MONGOLIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_MONGOLIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_MONGOLIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_MONGOLIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_MONGOLIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_MONGOLIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_MONGOLIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_MONGOLIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_MONGOLIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_MONGOLIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_MONGOLIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_MONGOLIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_MONGOLIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_MONGOLIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_MONGOLIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_MONGOLIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_MONGOLIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_MONGOLIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_MONGOLIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_MONGOLIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_MONGOLIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_MONGOLIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_MONGOLIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_MONGOLIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_MONGOLIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_MONGOLIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_MONGOLIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_MONGOLIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_MONGOLIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_MONGOLIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_MONGOLIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_MONGOLIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_MONGOLIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_MONGOLIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_MONGOLIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_MONGOLIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_MONGOLIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_MONGOLIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_MONGOLIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_MONGOLIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_MONGOLIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_MONGOLIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_MONGOLIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_MONGOLIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_MONGOLIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_MONGOLIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_MONGOLIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_MONGOLIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_MONGOLIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_MONGOLIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_MONGOLIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_MONGOLIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_NORWEGIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_NORWEGIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_NORWEGIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_NORWEGIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_NORWEGIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_NORWEGIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_NORWEGIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_NORWEGIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_NORWEGIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_NORWEGIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_NORWEGIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_NORWEGIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_NORWEGIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_NORWEGIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_NORWEGIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_NORWEGIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_NORWEGIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_NORWEGIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_NORWEGIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_NORWEGIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_NORWEGIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_NORWEGIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_NORWEGIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_NORWEGIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_NORWEGIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_NORWEGIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_NORWEGIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_NORWEGIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_NORWEGIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_NORWEGIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_NORWEGIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_NORWEGIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_NORWEGIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_NORWEGIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_NORWEGIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_NORWEGIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_NORWEGIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_NORWEGIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_NORWEGIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_NORWEGIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_NORWEGIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_NORWEGIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_NORWEGIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_NORWEGIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_NORWEGIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_NORWEGIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_NORWEGIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_NORWEGIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_NORWEGIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_NORWEGIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_NORWEGIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_NORWEGIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_NORWEGIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_NORWEGIANNYNORSK
	LangString MULTIUSER_PAGE_TITLE ${LANG_NORWEGIANNYNORSK} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_NORWEGIANNYNORSK} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_NORWEGIANNYNORSK} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_NORWEGIANNYNORSK} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_NORWEGIANNYNORSK} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_NORWEGIANNYNORSK} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_NORWEGIANNYNORSK} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_NORWEGIANNYNORSK} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_NORWEGIANNYNORSK} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_NORWEGIANNYNORSK} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_NORWEGIANNYNORSK} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_NORWEGIANNYNORSK} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_NORWEGIANNYNORSK} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_NORWEGIANNYNORSK} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_NORWEGIANNYNORSK} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_NORWEGIANNYNORSK} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_NORWEGIANNYNORSK} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_NORWEGIANNYNORSK} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_NORWEGIANNYNORSK} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_NORWEGIANNYNORSK} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_NORWEGIANNYNORSK} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_NORWEGIANNYNORSK} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_NORWEGIANNYNORSK} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_NORWEGIANNYNORSK} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_NORWEGIANNYNORSK} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_NORWEGIANNYNORSK} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_NORWEGIANNYNORSK} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_NORWEGIANNYNORSK} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_NORWEGIANNYNORSK} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_NORWEGIANNYNORSK} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_NORWEGIANNYNORSK} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_NORWEGIANNYNORSK} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_NORWEGIANNYNORSK} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_NORWEGIANNYNORSK} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_NORWEGIANNYNORSK} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_NORWEGIANNYNORSK} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_NORWEGIANNYNORSK} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_NORWEGIANNYNORSK} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_NORWEGIANNYNORSK} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_NORWEGIANNYNORSK} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_NORWEGIANNYNORSK} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_NORWEGIANNYNORSK} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_NORWEGIANNYNORSK} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_NORWEGIANNYNORSK} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_NORWEGIANNYNORSK} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_PASHTO
	LangString MULTIUSER_PAGE_TITLE ${LANG_PASHTO} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_PASHTO} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_PASHTO} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_PASHTO} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_PASHTO} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_PASHTO} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_PASHTO} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_PASHTO} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_PASHTO} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_PASHTO} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_PASHTO} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_PASHTO} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_PASHTO} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_PASHTO} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_PASHTO} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_PASHTO} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_PASHTO} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_PASHTO} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_PASHTO} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_PASHTO} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_PASHTO} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_PASHTO} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_PASHTO} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_PASHTO} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_PASHTO} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_PASHTO} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_PASHTO} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_PASHTO} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_PASHTO} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_PASHTO} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_PASHTO} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_PASHTO} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_PASHTO} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_PASHTO} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_PASHTO} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_PASHTO} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_PASHTO} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_PASHTO} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_PASHTO} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_PASHTO} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_PASHTO} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_PASHTO} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_PASHTO} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_PASHTO} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_PASHTO} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_PASHTO} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_PASHTO} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_PASHTO} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_PASHTO} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_PASHTO} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_PASHTO} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_PASHTO} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_POLISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_POLISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_POLISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_POLISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_POLISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_POLISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_POLISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_POLISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_POLISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_POLISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_POLISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_POLISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_POLISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_POLISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_POLISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_POLISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_POLISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_POLISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_POLISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_POLISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_POLISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_POLISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_POLISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_POLISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_POLISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_POLISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_POLISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_POLISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_POLISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_POLISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_POLISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_POLISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_POLISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_POLISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_POLISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_POLISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_POLISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_POLISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_POLISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_POLISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_POLISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_POLISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_POLISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_POLISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_POLISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_POLISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_POLISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_POLISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_POLISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_POLISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_POLISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_POLISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_POLISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_PORTUGUESE
	LangString MULTIUSER_PAGE_TITLE ${LANG_PORTUGUESE} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_PORTUGUESE} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_PORTUGUESE} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_PORTUGUESE} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_PORTUGUESE} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_PORTUGUESE} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_PORTUGUESE} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_PORTUGUESE} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_PORTUGUESE} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_PORTUGUESE} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_PORTUGUESE} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_PORTUGUESE} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_PORTUGUESE} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_PORTUGUESE} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_PORTUGUESE} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_PORTUGUESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_PORTUGUESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_PORTUGUESE} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_PORTUGUESE} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_PORTUGUESE} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_PORTUGUESE} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_PORTUGUESE} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_PORTUGUESE} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_PORTUGUESE} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_PORTUGUESE} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_PORTUGUESE} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_PORTUGUESE} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_PORTUGUESE} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_PORTUGUESE} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_PORTUGUESE} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_PORTUGUESE} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_PORTUGUESE} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_PORTUGUESE} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_PORTUGUESE} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_PORTUGUESE} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_PORTUGUESE} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_PORTUGUESE} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_PORTUGUESE} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_PORTUGUESE} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_PORTUGUESE} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_PORTUGUESE} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_PORTUGUESE} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_PORTUGUESE} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_PORTUGUESE} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_PORTUGUESE} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_PORTUGUESE} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_PORTUGUESE} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_PORTUGUESE} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_PORTUGUESE} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_PORTUGUESE} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_PORTUGUESE} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_PORTUGUESE} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_PORTUGUESEBR
	LangString MULTIUSER_PAGE_TITLE ${LANG_PORTUGUESEBR} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_PORTUGUESEBR} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_PORTUGUESEBR} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_PORTUGUESEBR} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_PORTUGUESEBR} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_PORTUGUESEBR} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_PORTUGUESEBR} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_PORTUGUESEBR} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_PORTUGUESEBR} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_PORTUGUESEBR} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_PORTUGUESEBR} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_PORTUGUESEBR} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_PORTUGUESEBR} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_PORTUGUESEBR} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_PORTUGUESEBR} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_PORTUGUESEBR} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_PORTUGUESEBR} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_PORTUGUESEBR} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_PORTUGUESEBR} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_PORTUGUESEBR} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_PORTUGUESEBR} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_PORTUGUESEBR} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_PORTUGUESEBR} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_PORTUGUESEBR} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_PORTUGUESEBR} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_PORTUGUESEBR} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_PORTUGUESEBR} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_PORTUGUESEBR} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_PORTUGUESEBR} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_PORTUGUESEBR} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_PORTUGUESEBR} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_PORTUGUESEBR} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_PORTUGUESEBR} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_PORTUGUESEBR} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_PORTUGUESEBR} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_PORTUGUESEBR} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_PORTUGUESEBR} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_PORTUGUESEBR} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_PORTUGUESEBR} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_PORTUGUESEBR} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_PORTUGUESEBR} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_PORTUGUESEBR} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_PORTUGUESEBR} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_PORTUGUESEBR} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_PORTUGUESEBR} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_PORTUGUESEBR} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_PORTUGUESEBR} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_PORTUGUESEBR} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_PORTUGUESEBR} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_PORTUGUESEBR} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_PORTUGUESEBR} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_PORTUGUESEBR} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_ROMANIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_ROMANIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_ROMANIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_ROMANIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_ROMANIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_ROMANIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_ROMANIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_ROMANIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_ROMANIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_ROMANIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_ROMANIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_ROMANIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_ROMANIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_ROMANIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_ROMANIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_ROMANIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_ROMANIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_ROMANIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_ROMANIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_ROMANIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_ROMANIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_ROMANIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_ROMANIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_ROMANIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_ROMANIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_ROMANIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_ROMANIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_ROMANIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_ROMANIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_ROMANIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_ROMANIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_ROMANIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_ROMANIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_ROMANIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_ROMANIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_ROMANIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_ROMANIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_ROMANIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_ROMANIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_ROMANIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_ROMANIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_ROMANIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_ROMANIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_ROMANIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_ROMANIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_ROMANIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_ROMANIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_ROMANIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_ROMANIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_ROMANIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_ROMANIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_ROMANIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_ROMANIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_RUSSIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_RUSSIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_RUSSIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_RUSSIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_RUSSIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_RUSSIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_RUSSIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_RUSSIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_RUSSIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_RUSSIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_RUSSIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_RUSSIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_RUSSIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_RUSSIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_RUSSIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_RUSSIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_RUSSIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_RUSSIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_RUSSIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_RUSSIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_RUSSIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_RUSSIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_RUSSIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_RUSSIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_RUSSIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_RUSSIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_RUSSIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_RUSSIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_RUSSIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_RUSSIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_RUSSIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_RUSSIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_RUSSIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_RUSSIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_RUSSIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_RUSSIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_RUSSIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_RUSSIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_RUSSIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_RUSSIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_RUSSIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_RUSSIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_RUSSIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_RUSSIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_RUSSIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_RUSSIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_RUSSIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_RUSSIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_RUSSIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_RUSSIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_RUSSIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_RUSSIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_RUSSIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SCOTSGAELIC
	LangString MULTIUSER_PAGE_TITLE ${LANG_SCOTSGAELIC} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SCOTSGAELIC} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SCOTSGAELIC} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SCOTSGAELIC} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SCOTSGAELIC} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SCOTSGAELIC} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SCOTSGAELIC} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SCOTSGAELIC} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SCOTSGAELIC} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SCOTSGAELIC} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SCOTSGAELIC} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SCOTSGAELIC} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SCOTSGAELIC} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SCOTSGAELIC} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SCOTSGAELIC} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SCOTSGAELIC} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SCOTSGAELIC} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SCOTSGAELIC} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SCOTSGAELIC} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SCOTSGAELIC} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SCOTSGAELIC} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SCOTSGAELIC} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SCOTSGAELIC} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SCOTSGAELIC} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SCOTSGAELIC} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SCOTSGAELIC} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SCOTSGAELIC} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SCOTSGAELIC} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SCOTSGAELIC} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SCOTSGAELIC} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SCOTSGAELIC} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SCOTSGAELIC} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SCOTSGAELIC} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SCOTSGAELIC} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SCOTSGAELIC} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SCOTSGAELIC} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SCOTSGAELIC} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SCOTSGAELIC} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SCOTSGAELIC} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SCOTSGAELIC} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SCOTSGAELIC} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SCOTSGAELIC} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SCOTSGAELIC} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SCOTSGAELIC} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SCOTSGAELIC} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SCOTSGAELIC} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SCOTSGAELIC} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SCOTSGAELIC} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SCOTSGAELIC} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SCOTSGAELIC} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SCOTSGAELIC} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SCOTSGAELIC} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SERBIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_SERBIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SERBIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SERBIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SERBIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SERBIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SERBIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SERBIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SERBIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SERBIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SERBIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SERBIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SERBIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SERBIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SERBIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SERBIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SERBIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SERBIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SERBIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SERBIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SERBIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SERBIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SERBIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SERBIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SERBIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SERBIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SERBIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SERBIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SERBIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SERBIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SERBIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SERBIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SERBIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SERBIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SERBIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SERBIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SERBIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SERBIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SERBIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SERBIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SERBIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SERBIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SERBIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SERBIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SERBIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SERBIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SERBIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SERBIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SERBIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SERBIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SERBIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SERBIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SERBIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SERBIANLATIN
	LangString MULTIUSER_PAGE_TITLE ${LANG_SERBIANLATIN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SERBIANLATIN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SERBIANLATIN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SERBIANLATIN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SERBIANLATIN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SERBIANLATIN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SERBIANLATIN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SERBIANLATIN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SERBIANLATIN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SERBIANLATIN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SERBIANLATIN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SERBIANLATIN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SERBIANLATIN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SERBIANLATIN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SERBIANLATIN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SERBIANLATIN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SERBIANLATIN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SERBIANLATIN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SERBIANLATIN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SERBIANLATIN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SERBIANLATIN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SERBIANLATIN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SERBIANLATIN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SERBIANLATIN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SERBIANLATIN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SERBIANLATIN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SERBIANLATIN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SERBIANLATIN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SERBIANLATIN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SERBIANLATIN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SERBIANLATIN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SERBIANLATIN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SERBIANLATIN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SERBIANLATIN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SERBIANLATIN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SERBIANLATIN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SERBIANLATIN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SERBIANLATIN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SERBIANLATIN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SERBIANLATIN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SERBIANLATIN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SERBIANLATIN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SERBIANLATIN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SERBIANLATIN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SERBIANLATIN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SERBIANLATIN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SERBIANLATIN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SERBIANLATIN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SERBIANLATIN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SERBIANLATIN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SERBIANLATIN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SERBIANLATIN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SIMPCHINESE
	LangString MULTIUSER_PAGE_TITLE ${LANG_SIMPCHINESE} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SIMPCHINESE} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SIMPCHINESE} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SIMPCHINESE} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SIMPCHINESE} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SIMPCHINESE} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SIMPCHINESE} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SIMPCHINESE} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SIMPCHINESE} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SIMPCHINESE} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SIMPCHINESE} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SIMPCHINESE} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SIMPCHINESE} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SIMPCHINESE} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SIMPCHINESE} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SIMPCHINESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SIMPCHINESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SIMPCHINESE} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SIMPCHINESE} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SIMPCHINESE} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SIMPCHINESE} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SIMPCHINESE} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SIMPCHINESE} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SIMPCHINESE} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SIMPCHINESE} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SIMPCHINESE} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SIMPCHINESE} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SIMPCHINESE} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SIMPCHINESE} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SIMPCHINESE} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SIMPCHINESE} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SIMPCHINESE} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SIMPCHINESE} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SIMPCHINESE} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SIMPCHINESE} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SIMPCHINESE} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SIMPCHINESE} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SIMPCHINESE} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SIMPCHINESE} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SIMPCHINESE} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SIMPCHINESE} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SIMPCHINESE} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SIMPCHINESE} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SIMPCHINESE} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SIMPCHINESE} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SIMPCHINESE} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SIMPCHINESE} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SIMPCHINESE} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SIMPCHINESE} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SIMPCHINESE} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SIMPCHINESE} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SIMPCHINESE} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SLOVAK
	LangString MULTIUSER_PAGE_TITLE ${LANG_SLOVAK} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SLOVAK} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SLOVAK} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SLOVAK} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SLOVAK} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SLOVAK} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SLOVAK} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SLOVAK} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SLOVAK} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SLOVAK} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SLOVAK} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SLOVAK} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SLOVAK} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SLOVAK} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SLOVAK} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SLOVAK} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SLOVAK} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SLOVAK} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SLOVAK} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SLOVAK} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SLOVAK} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SLOVAK} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SLOVAK} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SLOVAK} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SLOVAK} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SLOVAK} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SLOVAK} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SLOVAK} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SLOVAK} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SLOVAK} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SLOVAK} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SLOVAK} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SLOVAK} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SLOVAK} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SLOVAK} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SLOVAK} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SLOVAK} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SLOVAK} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SLOVAK} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SLOVAK} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SLOVAK} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SLOVAK} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SLOVAK} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SLOVAK} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SLOVAK} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SLOVAK} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SLOVAK} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SLOVAK} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SLOVAK} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SLOVAK} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SLOVAK} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SLOVAK} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SLOVENIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_SLOVENIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SLOVENIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SLOVENIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SLOVENIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SLOVENIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SLOVENIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SLOVENIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SLOVENIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SLOVENIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SLOVENIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SLOVENIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SLOVENIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SLOVENIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SLOVENIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SLOVENIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SLOVENIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SLOVENIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SLOVENIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SLOVENIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SLOVENIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SLOVENIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SLOVENIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SLOVENIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SLOVENIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SLOVENIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SLOVENIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SLOVENIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SLOVENIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SLOVENIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SLOVENIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SLOVENIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SLOVENIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SLOVENIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SLOVENIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SLOVENIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SLOVENIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SLOVENIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SLOVENIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SLOVENIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SLOVENIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SLOVENIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SLOVENIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SLOVENIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SLOVENIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SLOVENIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SLOVENIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SLOVENIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SLOVENIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SLOVENIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SLOVENIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SLOVENIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SLOVENIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SPANISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_SPANISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SPANISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SPANISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SPANISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SPANISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SPANISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SPANISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SPANISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SPANISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SPANISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SPANISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SPANISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SPANISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SPANISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SPANISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SPANISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SPANISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SPANISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SPANISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SPANISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SPANISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SPANISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SPANISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SPANISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SPANISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SPANISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SPANISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SPANISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SPANISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SPANISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SPANISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SPANISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SPANISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SPANISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SPANISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SPANISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SPANISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SPANISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SPANISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SPANISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SPANISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SPANISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SPANISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SPANISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SPANISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SPANISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SPANISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SPANISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SPANISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SPANISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SPANISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SPANISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SPANISHINTERNATIONAL
	LangString MULTIUSER_PAGE_TITLE ${LANG_SPANISHINTERNATIONAL} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SPANISHINTERNATIONAL} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SPANISHINTERNATIONAL} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SPANISHINTERNATIONAL} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SPANISHINTERNATIONAL} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SPANISHINTERNATIONAL} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SPANISHINTERNATIONAL} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SPANISHINTERNATIONAL} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SPANISHINTERNATIONAL} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SPANISHINTERNATIONAL} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SPANISHINTERNATIONAL} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SPANISHINTERNATIONAL} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SPANISHINTERNATIONAL} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SPANISHINTERNATIONAL} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SPANISHINTERNATIONAL} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SPANISHINTERNATIONAL} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SPANISHINTERNATIONAL} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SPANISHINTERNATIONAL} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SPANISHINTERNATIONAL} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SPANISHINTERNATIONAL} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SPANISHINTERNATIONAL} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SPANISHINTERNATIONAL} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SPANISHINTERNATIONAL} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SPANISHINTERNATIONAL} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SPANISHINTERNATIONAL} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SPANISHINTERNATIONAL} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SPANISHINTERNATIONAL} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SPANISHINTERNATIONAL} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SPANISHINTERNATIONAL} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SPANISHINTERNATIONAL} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SPANISHINTERNATIONAL} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SPANISHINTERNATIONAL} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SPANISHINTERNATIONAL} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SPANISHINTERNATIONAL} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SPANISHINTERNATIONAL} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SPANISHINTERNATIONAL} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SPANISHINTERNATIONAL} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SPANISHINTERNATIONAL} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SPANISHINTERNATIONAL} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SPANISHINTERNATIONAL} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SPANISHINTERNATIONAL} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SPANISHINTERNATIONAL} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SPANISHINTERNATIONAL} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SPANISHINTERNATIONAL} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SPANISHINTERNATIONAL} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_SWEDISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_SWEDISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_SWEDISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_SWEDISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_SWEDISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_SWEDISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_SWEDISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_SWEDISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_SWEDISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_SWEDISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_SWEDISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_SWEDISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_SWEDISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_SWEDISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_SWEDISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_SWEDISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_SWEDISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_SWEDISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_SWEDISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_SWEDISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_SWEDISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_SWEDISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_SWEDISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_SWEDISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_SWEDISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_SWEDISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_SWEDISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_SWEDISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_SWEDISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_SWEDISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_SWEDISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_SWEDISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_SWEDISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_SWEDISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_SWEDISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_SWEDISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_SWEDISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_SWEDISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_SWEDISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_SWEDISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_SWEDISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_SWEDISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_SWEDISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_SWEDISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_SWEDISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_SWEDISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_SWEDISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_SWEDISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_SWEDISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_SWEDISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_SWEDISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_SWEDISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_SWEDISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_TATAR
	LangString MULTIUSER_PAGE_TITLE ${LANG_TATAR} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_TATAR} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_TATAR} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_TATAR} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_TATAR} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_TATAR} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_TATAR} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_TATAR} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_TATAR} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_TATAR} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_TATAR} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_TATAR} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_TATAR} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_TATAR} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_TATAR} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_TATAR} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_TATAR} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_TATAR} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_TATAR} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_TATAR} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_TATAR} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_TATAR} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_TATAR} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_TATAR} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_TATAR} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_TATAR} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_TATAR} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_TATAR} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_TATAR} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_TATAR} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_TATAR} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_TATAR} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_TATAR} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_TATAR} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_TATAR} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_TATAR} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_TATAR} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_TATAR} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_TATAR} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_TATAR} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_TATAR} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_TATAR} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_TATAR} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_TATAR} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_TATAR} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_TATAR} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_TATAR} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_TATAR} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_TATAR} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_TATAR} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_TATAR} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_TATAR} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_THAI
	LangString MULTIUSER_PAGE_TITLE ${LANG_THAI} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_THAI} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_THAI} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_THAI} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_THAI} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_THAI} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_THAI} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_THAI} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_THAI} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_THAI} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_THAI} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_THAI} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_THAI} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_THAI} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_THAI} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_THAI} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_THAI} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_THAI} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_THAI} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_THAI} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_THAI} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_THAI} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_THAI} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_THAI} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_THAI} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_THAI} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_THAI} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_THAI} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_THAI} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_THAI} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_THAI} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_THAI} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_THAI} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_THAI} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_THAI} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_THAI} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_THAI} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_THAI} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_THAI} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_THAI} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_THAI} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_THAI} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_THAI} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_THAI} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_THAI} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_THAI} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_THAI} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_THAI} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_THAI} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_THAI} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_THAI} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_THAI} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_TRADCHINESE
	LangString MULTIUSER_PAGE_TITLE ${LANG_TRADCHINESE} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_TRADCHINESE} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_TRADCHINESE} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_TRADCHINESE} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_TRADCHINESE} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_TRADCHINESE} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_TRADCHINESE} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_TRADCHINESE} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_TRADCHINESE} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_TRADCHINESE} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_TRADCHINESE} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_TRADCHINESE} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_TRADCHINESE} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_TRADCHINESE} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_TRADCHINESE} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_TRADCHINESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_TRADCHINESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_TRADCHINESE} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_TRADCHINESE} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_TRADCHINESE} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_TRADCHINESE} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_TRADCHINESE} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_TRADCHINESE} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_TRADCHINESE} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_TRADCHINESE} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_TRADCHINESE} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_TRADCHINESE} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_TRADCHINESE} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_TRADCHINESE} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_TRADCHINESE} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_TRADCHINESE} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_TRADCHINESE} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_TRADCHINESE} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_TRADCHINESE} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_TRADCHINESE} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_TRADCHINESE} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_TRADCHINESE} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_TRADCHINESE} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_TRADCHINESE} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_TRADCHINESE} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_TRADCHINESE} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_TRADCHINESE} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_TRADCHINESE} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_TRADCHINESE} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_TRADCHINESE} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_TRADCHINESE} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_TRADCHINESE} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_TRADCHINESE} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_TRADCHINESE} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_TRADCHINESE} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_TRADCHINESE} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_TRADCHINESE} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_TURKISH
	LangString MULTIUSER_PAGE_TITLE ${LANG_TURKISH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_TURKISH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_TURKISH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_TURKISH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_TURKISH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_TURKISH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_TURKISH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_TURKISH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_TURKISH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_TURKISH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_TURKISH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_TURKISH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_TURKISH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_TURKISH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_TURKISH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_TURKISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_TURKISH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_TURKISH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_TURKISH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_TURKISH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_TURKISH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_TURKISH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_TURKISH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_TURKISH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_TURKISH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_TURKISH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_TURKISH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_TURKISH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_TURKISH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_TURKISH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_TURKISH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_TURKISH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_TURKISH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_TURKISH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_TURKISH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_TURKISH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_TURKISH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_TURKISH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_TURKISH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_TURKISH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_TURKISH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_TURKISH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_TURKISH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_TURKISH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_TURKISH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_TURKISH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_TURKISH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_TURKISH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_TURKISH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_TURKISH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_TURKISH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_TURKISH} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_UKRAINIAN
	LangString MULTIUSER_PAGE_TITLE ${LANG_UKRAINIAN} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_UKRAINIAN} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_UKRAINIAN} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_UKRAINIAN} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_UKRAINIAN} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_UKRAINIAN} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_UKRAINIAN} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_UKRAINIAN} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_UKRAINIAN} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_UKRAINIAN} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_UKRAINIAN} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_UKRAINIAN} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_UKRAINIAN} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_UKRAINIAN} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_UKRAINIAN} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_UKRAINIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_UKRAINIAN} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_UKRAINIAN} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_UKRAINIAN} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_UKRAINIAN} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_UKRAINIAN} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_UKRAINIAN} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_UKRAINIAN} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_UKRAINIAN} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_UKRAINIAN} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_UKRAINIAN} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_UKRAINIAN} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_UKRAINIAN} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_UKRAINIAN} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_UKRAINIAN} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_UKRAINIAN} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_UKRAINIAN} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_UKRAINIAN} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_UKRAINIAN} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_UKRAINIAN} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_UKRAINIAN} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_UKRAINIAN} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_UKRAINIAN} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_UKRAINIAN} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_UKRAINIAN} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_UKRAINIAN} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_UKRAINIAN} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_UKRAINIAN} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_UKRAINIAN} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_UKRAINIAN} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_UKRAINIAN} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_UKRAINIAN} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_UKRAINIAN} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_UKRAINIAN} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_UKRAINIAN} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_UKRAINIAN} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_UKRAINIAN} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_UZBEK
	LangString MULTIUSER_PAGE_TITLE ${LANG_UZBEK} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_UZBEK} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_UZBEK} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_UZBEK} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_UZBEK} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_UZBEK} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_UZBEK} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_UZBEK} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_UZBEK} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_UZBEK} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_UZBEK} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_UZBEK} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_UZBEK} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_UZBEK} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_UZBEK} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_UZBEK} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_UZBEK} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_UZBEK} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_UZBEK} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_UZBEK} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_UZBEK} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_UZBEK} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_UZBEK} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_UZBEK} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_UZBEK} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_UZBEK} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_UZBEK} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_UZBEK} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_UZBEK} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_UZBEK} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_UZBEK} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_UZBEK} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_UZBEK} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_UZBEK} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_UZBEK} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_UZBEK} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_UZBEK} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_UZBEK} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_UZBEK} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_UZBEK} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_UZBEK} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_UZBEK} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_UZBEK} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_UZBEK} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_UZBEK} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_UZBEK} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_UZBEK} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_UZBEK} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_UZBEK} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_UZBEK} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_UZBEK} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_UZBEK} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_VIETNAMESE
	LangString MULTIUSER_PAGE_TITLE ${LANG_VIETNAMESE} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_VIETNAMESE} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_VIETNAMESE} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_VIETNAMESE} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_VIETNAMESE} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_VIETNAMESE} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_VIETNAMESE} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_VIETNAMESE} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_VIETNAMESE} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_VIETNAMESE} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_VIETNAMESE} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_VIETNAMESE} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_VIETNAMESE} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_VIETNAMESE} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_VIETNAMESE} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_VIETNAMESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_VIETNAMESE} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_VIETNAMESE} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_VIETNAMESE} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_VIETNAMESE} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_VIETNAMESE} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_VIETNAMESE} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_VIETNAMESE} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_VIETNAMESE} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_VIETNAMESE} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_VIETNAMESE} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_VIETNAMESE} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_VIETNAMESE} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_VIETNAMESE} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_VIETNAMESE} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_VIETNAMESE} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_VIETNAMESE} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_VIETNAMESE} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_VIETNAMESE} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_VIETNAMESE} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_VIETNAMESE} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_VIETNAMESE} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_VIETNAMESE} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_VIETNAMESE} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_VIETNAMESE} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_VIETNAMESE} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_VIETNAMESE} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_VIETNAMESE} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_VIETNAMESE} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_VIETNAMESE} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_VIETNAMESE} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_VIETNAMESE} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_VIETNAMESE} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_VIETNAMESE} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_VIETNAMESE} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_VIETNAMESE} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_VIETNAMESE} "${prodname} ${VERSION} Setup"
!endif

!ifdef LANG_WELSH
	LangString MULTIUSER_PAGE_TITLE ${LANG_WELSH} "Choose Users"
	LangString MULTIUSER_INSTALL_PAGE_SUBTITLE ${LANG_WELSH} "Choose for which users to install $(^NameDA)."
	LangString MULTIUSER_UNINSTALL_PAGE_SUBTITLE ${LANG_WELSH} "Choose for which users to remove $(^NameDA)."
	LangString MULTIUSER_INSTALL_HEADER ${LANG_WELSH} "Select whether to install $(^NameDA) for all users or for current user."
	LangString MULTIUSER_UNINSTALL_HEADER ${LANG_WELSH} "$(^NameDA) is installed both for all users and for current user.$\r$\nSelect which installation to remove."
	LangString MULTIUSER_ALL_USERS ${LANG_WELSH} "For &anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER ${LANG_WELSH} "For &me ({USER})"
	LangString MULTIUSER_ALL_USERS_UMUI ${LANG_WELSH} "For anyone who uses this computer (all users)"
	LangString MULTIUSER_CURRENT_USER_UMUI ${LANG_WELSH} "For me ({USER})"
	LangString MULTIUSER_NEW_INSTALLATION_ALL_USERS ${LANG_WELSH} "Fresh install for all users."
	LangString MULTIUSER_NEW_INSTALLATION_CURRENT_USER ${LANG_WELSH} "Fresh install for current user."
	LangString MULTIUSER_INSTALLED_ALL_USERS ${LANG_WELSH} "Version {VERSION} is installed for all users in $\"{FOLDER}$\"."
	LangString MULTIUSER_INSTALLED_CURRENT_USER ${LANG_WELSH} "Version {VERSION} is installed for current user in $\"{FOLDER}$\"."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_ALL_USERS ${LANG_WELSH} "Reinstall version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_SAME_VERSION_CURRENT_USER ${LANG_WELSH} "Reinstall version {VERSION} for current user."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_ALL_USERS ${LANG_WELSH} "Uninstall version {OLD_VERSION} and install version {VERSION} for all users."
	LangString MULTIUSER_REINSTALL_DIFF_VERSION_CURRENT_USER ${LANG_WELSH} "Uninstall version {OLD_VERSION} and install version {VERSION} for current user."
	LangString MULTIUSER_RUN_AS_ADMIN ${LANG_WELSH} "You need to run this program as administrator."
	LangString MULTIUSER_ADMIN_CREDENTIALS_REQUIRED ${LANG_WELSH} "Administrator credentials required."
	LangString MULTIUSER_ADMIN_UNINSTALL_CREDENTIALS_REQUIRED ${LANG_WELSH} "Administrator credentials required for uninstall."
	; error messages - not so important
	LangString MULTIUSER_INVALID_PARAMS ${LANG_WELSH} "Invalid combination of paramaters."
	LangString MULTIUSER_NOT_INSTALLED ${LANG_WELSH} "There is no installation of $(^NameDA)."
	LangString MULTIUSER_INSTALLATION_FOR_CURRENT_USER_NOT_SUPPORTED ${LANG_WELSH} "The operating system doesn't support current user installations."
	LangString MULTIUSER_ADMIN_ACCOUNT_LOGIN_REQUIRED ${LANG_WELSH} "You need to login with an account that is a member of the administrators group to continue."
	LangString MULTIUSER_ELEVATION_NOT_SUPPORTED ${LANG_WELSH} "The operating system doesn't support elevation."
	LangString MULTIUSER_LOGON_SERVICE_NOT_RUNNING ${LANG_WELSH} "Unable to elevate, Secondary Logon service not running."
	LangString MULTIUSER_ELEVATION_ERROR ${LANG_WELSH} "Unable to elevate, error {ERROR}."
	; text string for installer section
	LangString SECTION_CORE_NAME ${LANG_WELSH} "Core files (required)"
	LangString SECTION_CORE_DESCRIPTION ${LANG_WELSH} "This are the basic files needed for ${prodname} to function (required)."
	LangString SECTION_SHORTCUTS_NAME ${LANG_WELSH} "Shortcuts"
	LangString SECTION_SHORTCUTS_DESCRIPTION ${LANG_WELSH} "Create shortcuts to ${prodname} on -"
	LangString SECTION_START_MENU_NAME ${LANG_WELSH} "Start menu"
	LangString SECTION_START_MENU_DESCRIPTION ${LANG_WELSH} "Create the shortcut in Start menu."
	LangString SECTION_DESKTOP_NAME ${LANG_WELSH} "Desktop"
	LangString SECTION_DESKTOP_DESCRIPTION ${LANG_WELSH} "Create the shortcut on desktop."
	LangString SECTION_QUICK_LAUNCH_NAME ${LANG_WELSH} "Quick launch"
	LangString SECTION_QUICK_LAUNCH_DESCRIPTION ${LANG_WELSH} "Create the shortcut on Quick Launch."
	LangString SECTION_TRANSLATIONS_NAME ${LANG_WELSH} "Translations"
	LangString SECTION_TRANSLATIONS_DESCRIPTION ${LANG_WELSH} "Use ${prodname} in your preferred local system language, install the needed language files."
	LangString SECTION_INTEGRATE_SHRED_NAME ${LANG_WELSH} "Integrate Shred"
	LangString SECTION_INTEGRATE_SHRED_DESCRIPTION ${LANG_WELSH} "Add an option to delete files from the file context menu in Windows explorer."
	LangString SECTION_UNINSTALL_NAME ${LANG_WELSH} "Uninstall"
	LangString SECTION_UNINSTALL_DESCRIPTION ${LANG_WELSH} "Add uninstall program."
	LangString UNINSTALL_TEXT ${LANG_WELSH} "${prodname} will be uninstalled from the following folder.$\r$\nClick Uninstall to start the uninstallation.$\r$\nWARNING: The uninstaller completely removes the installation directory including any files (such as custom cleaners) that you may have added or changed."
	LangString ALREADY_INSTALLED ${LANG_WELSH} "${prodname} is already installed.$\r$\nClick 'OK' to uninstall the old version before upgrading, or click 'Cancel' to abort the upgrade."
	; shred shell integration menu name
	LangString SHRED_SHELL_MENU ${LANG_WELSH} "Shred with ${prodname}"
	; Finish message
	LangString BLEACHBIT_MUI_FINISHPAGE_LINK ${LANG_WELSH} "Visit the ${prodname} web site"
	LangString MULTIPRINT1 ${LANG_WELSH} "The next step is building font cache, during which you may see a black window."
	LangString MULTIPRINT2 ${LANG_WELSH} "It usually finishes in one minute, but sometimes it takes ten minutes."
	LangString SHORTCUT_NO_UAC ${LANG_WELSH} "${prodname} No UAC."
	LangString SHORTCUT_DEBUGGING_TERMINAL ${LANG_WELSH} "${prodname} Debugging Terminal"
	LangString INSTALLER_CAPTION ${LANG_WELSH} "${prodname} ${VERSION} Setup"
!endif
