#include "exam.h"
#include <cln/integer.h>
#include <cln/integer_io.h>

static floor_test integer_floor_tests[] = {

{ "7853255233330224291", "-3336928547114505419",
  "-3", "-2157530408013291966" },

{ "14068934522023857270", "16292006600125740074",
  "0", "14068934522023857270" },

{ "10985143198741137410", "2820546847025452162",
  "3", "2523502657664780924" },

{ "-8108344024060626734", "17657489924906565585",
  "-1", "9549145900845938851" },

{ "9793321542618752251", "18086526939764980195",
  "0", "9793321542618752251" },

{ "-17146297557940039430", "12031974228591547856",
  "-2", "6917650899243056282" },

{ "-11002425733929018635", "317353195315898710776749437474283191162",
  "-1", "317353195315898710765747011740354172527" },

{ "-7045772845268193739", "-89864936462331315327547597221973588375",
  "0", "-7045772845268193739" },

{ "-3519209948682231610", "336646025916394184314065151550367317320",
  "-1", "336646025916394184310545941601685085710" },

{ "-14043580588957562420", "-222396907959379818229719625081455476397",
  "0", "-14043580588957562420" },

{ "-9551193686327136711", "75278849342865310446781730521816023755",
  "-1", "75278849342865310437230536835488887044" },

{ "-5159693807678286583", "-271047212583781769863421872046042817014",
  "0", "-5159693807678286583" },

{ "-468628810409465000", "4096333242794181573565417750313678008664626221486481835906739336082806890901464399325558358976385254948318232837795406709018062193288308568894691407903633",
  "-1", "4096333242794181573565417750313678008664626221486481835906739336082806890901464399325558358976385254948318232837795406709018062193288308100265880998438633" },

{ "-5244261521146873643", "4921965954460062114436531997676458648483262898583452823054595308486273272424691697564822554202559195140246785942292198280651275061385828405859241079703409",
  "-1", "4921965954460062114436531997676458648483262898583452823054595308486273272424691697564822554202559195140246785942292198280651275061385823161597719932829766" },

{ "-7155077620310044967", "8812163272024170253854686552273644496512722723120222844613502711675792665532423218585794856067792762737333036865054171911349107383532358686613366666267909",
  "-1", "8812163272024170253854686552273644496512722723120222844613502711675792665532423218585794856067792762737333036865054171911349107383532351531535746356222942" },

{ "-6816314458740361202", "12075686527410596248188273566406493470578404199548730085391183041200273406509336777783445118538744079686672261898288597639090345296674064493442338947240247",
  "-1", "12075686527410596248188273566406493470578404199548730085391183041200273406509336777783445118538744079686672261898288597639090345296674057677127880206879045" },

{ "-1890766085089344496", "-7408951123352997019624764400646833541081866912262454311449242781355699966135127365870537542305320515188627454777019144990896651509964466134772403923321917",
  "0", "-1890766085089344496" },

{ "-17760474272160473768", "10671898954663586353020741847122236830297651230263271051052178674502913972809415507874936117140992859978582852208528956402833042707438860216609301338079639",
  "-1", "10671898954663586353020741847122236830297651230263271051052178674502913972809415507874936117140992859978582852208528956402833042707438842456135029177605871" },

{ "17203040353218460773", "-2087162439393804055245476778327445230668947133920484097696589818636894139336038424853265430700117127209095408439503149361955520500062568298413951113007815520417010757436097548975086796164496676384718866185751276003374984886645837833063272909444571294955778352876647505220277070946109654595325494251711661808952794932834009121950804034627054856954463330684354292113876259596011570415522831755074832239680022834732540878425796300024337145992774113324576942861121693541507092307262607720008434123040550199401165667835993232451530119579950363100932584067714571588474895040209606410481479858029354372704983248137195749442",
  "-1", "-2087162439393804055245476778327445230668947133920484097696589818636894139336038424853265430700117127209095408439503149361955520500062568298413951113007815520417010757436097548975086796164496676384718866185751276003374984886645837833063272909444571294955778352876647505220277070946109654595325494251711661808952794932834009121950804034627054856954463330684354292113876259596011570415522831755074832239680022834732540878425796300024337145992774113324576942861121693541507092307262607720008434123040550199401165667835993232451530119579950363100932584067714571588474895040209606410481479858029354372687780207783977288669" },

{ "-669078238914427842", "-2079683283534812796000190145696654156804430677578086735229530182730363039425073862859919937645919418081821481495275802097707156965850792454067873053943961704938117974314269568411834037549827330778321735965757574814268024643310969429104824266062514450939201453648232801402417276979456869834703061150723202264463831469016146310260625377771326468627250569024458585844135123967133684658903385261562998370487428947011971199332502829621504477139578507890165895257527873153869666215808793006714467381179632834850697420959155528830942491523671012905291756947015477293335637719271764878661266856465788562934083754663149622043",
  "0", "-669078238914427842" },

{ "7327608361251253460", "-11696871058150243071087622230096689496181624466205249401376348902965608647385664229774648233384515557654898456058685820740766304363182039373157014626506361274439760335671626498691756724181737933201816787306863365879304649516313681157144055793349950077334014446025781487249267998958541998722387302987853596488202173446477234627919885268339967510098356435511938337505060706688248914394292741973765745281640737883810857064447143652281758869836897346742791897670275478332406904414773228555812810686551346417028168391700814494167715137071887755902595471083839770070956620494992791342919563605887139693691074220696797086954",
  "-1", "-11696871058150243071087622230096689496181624466205249401376348902965608647385664229774648233384515557654898456058685820740766304363182039373157014626506361274439760335671626498691756724181737933201816787306863365879304649516313681157144055793349950077334014446025781487249267998958541998722387302987853596488202173446477234627919885268339967510098356435511938337505060706688248914394292741973765745281640737883810857064447143652281758869836897346742791897670275478332406904414773228555812810686551346417028168391700814494167715137071887755902595471083839770070956620494992791342919563605887139693683746612335545833494" },

{ "294675307927425004", "-9548883545732446060252072829565833006884749934819836721462955213854827688043000170303649263042149519854567992890424662453846646328000352698376041008580371118805742958892669824820331301849741711055204656684075622499980143446475914450482604391515448002257899292716976191315018524528823574850034894770209999447615978958086058881855069519056370913875205852377738400734853568252684386414540818555760214483168738870291995504569592275824832746669965860852593991220739290892286776371571179317949624919667076576237866033103387061005489130212740740367035039239029315995502459013799346342754507246725497131746887762156527202924",
  "-1", "-9548883545732446060252072829565833006884749934819836721462955213854827688043000170303649263042149519854567992890424662453846646328000352698376041008580371118805742958892669824820331301849741711055204656684075622499980143446475914450482604391515448002257899292716976191315018524528823574850034894770209999447615978958086058881855069519056370913875205852377738400734853568252684386414540818555760214483168738870291995504569592275824832746669965860852593991220739290892286776371571179317949624919667076576237866033103387061005489130212740740367035039239029315995502459013799346342754507246725497131746593086848599777920" },

{ "14347605674351973575", "16781108313723465798753322947549009969874803839178924211234447140560213638432451682705091051257464849827979202356053729300113370530117630421654608371240669238603643549128642643200948947465613904905607632005913664436128507306181734648889038561843797684348733053132088104433891457988693229945931772136047702319895617567109469705064237812979865949533824478284021673220084274688077361876364538071423609125747407610677136416454538389383594373243559248761308999294417964846813960148782443892858983199711111035244418968070018974928177662516580063782128203214203321005133744081558995859628472663680467632605080081460859254457",
  "0", "14347605674351973575" },

{ "-13687180458303546035", "-19965807258690898827399047857329749541944041888361526571512375013574840494217451526698619297248029675659091093507275385543103914023886879938416253663550378748995953654394575052030527774451712268159052917447058332864628753215292671454945836228787137495936035900814206996568155366945096185932229795907560606361081170245972586794828085080152240904698184990372898689089164281206741448028676272453255619644103230837682506759429084083781590844603079867247577101977877828608823440256009103689824572652465343135798570848914557962085239341382269526989381779235955669274286569338275810475113610787290242075588029043316765795281",
  "0", "-13687180458303546035" },

{ "-18925243707105550517292233464727657082", "9190307209239173280",
  "-2059261271274988371", "2728041824926269798" },

{ "-2268729715267556753620172461333386061", "2091801429708129323",
  "-1084581778674907194", "1902605633041663601" },

{ "240105871177433673480858499581307555362", "-18137436669813972164",
  "-13238136984210147236", "-7622864679137983342" },

{ "-262280851402380072992262860428676408462", "-16900353177245877861",
  "15519252683754978805", "-1413263307002672357" },

{ "232088877459084367318095567773397104766", "6879279671528853911",
  "33737380734733937751", "5401711328350210605" },

{ "28127709642032836544705999676759725409", "10932535648386303235",
  "2572844081801336427", "10537089091686284064" },

{ "-306937202176830380291551701368328539229", "-296436198830834971825518518346845101512",
  "1", "-10501003345995408466033183021483437717" },

{ "53182351345555180643155906117731554036", "-239211638592486301383761475381736024507",
  "-1", "-186029287246931120740605569264004470471" },

{ "280879521805922529084106054377533635149", "86259942955448859132329436894499980462",
  "3", "22099692939575951687117743694033693763" },

{ "270479016313808755540727122565065208981", "324912300098276215771804552548480817149",
  "0", "270479016313808755540727122565065208981" },

{ "-36931767825051824504116995033958612864", "319307981922121038618879980001580483695",
  "-1", "282376214097069214114762984967621870831" },

{ "107405040163562716679444439233633957914", "-141652913538112981614728925754765362880",
  "-1", "-34247873374550264935284486521131404966" },

{ "184790583924323275311064238756309559899", "9405763068924930772523308542613843828189472529194204592633223103364008985533829727911596099340788835060163612329614413033927995456162272921833539208882402",
  "0", "184790583924323275311064238756309559899" },

{ "-232146313651929815140292892576650425884", "127874042542498530491272428412953321188339770863893691736473766303033699167382382296818126363236257463426694846772750451609560841554300961480864245159756",
  "-1", "127874042542498530491272428412953321188339770863893691736473766303033699167382382296818126363236257463426694846772518305295908911739160668588287594733872" },

{ "8728026917336931021644334642968359261", "-4025737651718879467086249421940400743845718511565541383201031450532496911741243591880148294568060736532264934821412351158153056198557273134546519285439196",
  "-1", "-4025737651718879467086249421940400743845718511565541383201031450532496911741243591880148294568060736532264934821412342430126138861626251490211876317079935" },

{ "-21247806463473594155821742168531145877", "9874623814693251335287095436063900170315895560443374584548447111313954604343515085076726174459237734570523327188441412904116251434030306488421699399082287",
  "-1", "9874623814693251335287095436063900170315895560443374584548447111313954604343515085076726174459237734570523327188441391656309787960436150666679530867936410" },

{ "286071012976663674972497644839812778135", "8117963470049102990205107814791130105126121536354646949522748212681559213640860255350655907507344188574393108661850973221437234442503731759547377868482253",
  "0", "286071012976663674972497644839812778135" },

{ "-31984072490103846239901254171623218449", "5692584577100138206704178766874348327662006017031045734962382737701553237360572309466111381682998567474445884555969155997528896962520199289069413649945515",
  "-1", "5692584577100138206704178766874348327662006017031045734962382737701553237360572309466111381682998567474445884555969124013456406858673959387815242026727066" },

{ "-118786321298036108045826901623494422286", "-13104687393529855246189161514016061367829206536234756076440701117699438900634808212710497707688898041370523685367660273492555927331371333817584456923437812254937564791326005224466260676246116823279440552837098144298072108885163702544652442198253976130758036230979750526665070549806140578651660117367824058664768255971820333797528263566114021182845197585116811208610765478558726491630221448907739229750716647693886681440731920621825762708622208585945445501310666367635378515829380161368994361558247741326227866296163878689192696502960274515396418704173356117106149549811507516298161494760216869495774889685228097554343",
  "0", "-118786321298036108045826901623494422286" },

{ "-243504960196882294351576664380857968998", "-21587937181410571895883243216668490389074705797891859245233974857468088393972175783210897703383951091997858590608339069503309630378648345491373074180865032523580053667127292664354305946146706860083207200717386662398495588729927890691458790805600368902559075452315483293077820819619965677979632040202844747133012382862591603017396270452230496812292060122531819615885125296991557805051862986461441377986436031061301043809602913037623299360710776463563079053501286633046825608308134411478010516309133407298319800662521169341026639016773610132691088293480775753098006068864600975258749129292334356727402877150032641596013",
  "0", "-243504960196882294351576664380857968998" },

{ "-232153120215337418381368832017470265942", "30369869998519160635038439385899036531726274899243107662193573776561025086030508184579231487739439638990032661366370630132003795988534362627493292132764049369361254377811101088096885616264297545296183017838644655031800075015262568240918564555865889092855166242732548296118581123607728694721796055009838837557999873738362196508994398492388283391000153200151108985088421583241872508945550713986000643154770628316896294096213588875028875159647959209523043158262383137987983806573391208706198841017176042216759223869369001945418516819972673432636326816040752486579776281338052626173120273068890045743383055115108151149136",
  "-1", "30369869998519160635038439385899036531726274899243107662193573776561025086030508184579231487739439638990032661366370630132003795988534362627493292132764049369361254377811101088096885616264297545296183017838644655031800075015262568240918564555865889092855166242732548296118581123607728694721796055009838837557999873738362196508994398492388283391000153200151108985088421583241872508945550713986000643154770628316896294096213588875028875159647959209523043158262383137987983806573391208706198841017176042216759223869369001945418516819972673432636326816040752486579776281338052626172888119948674708325001686283090680883194" },

{ "-259060284965774946595436776839639567158", "-21169437398760148980356190208468018621145492999838564155598571671707045137252408058263155870788514173361612648418947991691931017566701206182096411121805142388703524692384188551391839307655250861401059757668540803453257330609840260191124331324376455691656017965418225557221321063048013134701879342357330536176553693912196231407222911508076200690973402778332647229863066211873019193191946948707769594605725700542299351271155436324879464212647734978854222464094486372144771948169422844206687239103281296767882465060755610256361348437002775612357787333990788742488962974294617778863800504758143312112916148210635178700875",
  "0", "-259060284965774946595436776839639567158" },

{ "-306407220440527520801126245152934343544", "23776904469041910002999929986640006577749806048379780143306978176280330224333859620859305982085584460504452577150094943864349273103240498588108336792264540481132832425653265046674475461727185564436156797869482735166850827691928781085870354146365177855543550807539877079785312955597311473866546268560309551339704009052837019611095284429480282839060448969927393502922337023493529232757886223011597039473438267362519775173848264262428693937605086393282678388857244739695710639089112115821491015511241179389623611704128686301802869094211111183507607222840602723592206395532989319304742353354849715544201896997806941793031",
  "-1", "23776904469041910002999929986640006577749806048379780143306978176280330224333859620859305982085584460504452577150094943864349273103240498588108336792264540481132832425653265046674475461727185564436156797869482735166850827691928781085870354146365177855543550807539877079785312955597311473866546268560309551339704009052837019611095284429480282839060448969927393502922337023493529232757886223011597039473438267362519775173848264262428693937605086393282678388857244739695710639089112115821491015511241179389623611704128686301802869094211111183507607222840602723592206395532989319304435946134409188023400770752654007449487" },

{ "-195344089877883615473604540022799066156", "3662747206396136814780716441352319011395583880744440623779519524132715621398922492090110915810914165138435343905061143614931233310311653264955206314385113727380922840781471233570237875610273247058183529977038444774890036917021403875269188605058323112809901006876685005810599540694986877767813641408707144817551209014119080068666341132956917595575721029282915413432788003670940873484464479035116187361986468817764174983360339341760904395062935668506379254915132158079325547293981795720009601997338615068852024788929328937759791477545407878160402653256560646902444406842976796122784294159073232675729939439754133572694",
  "-1", "3662747206396136814780716441352319011395583880744440623779519524132715621398922492090110915810914165138435343905061143614931233310311653264955206314385113727380922840781471233570237875610273247058183529977038444774890036917021403875269188605058323112809901006876685005810599540694986877767813641408707144817551209014119080068666341132956917595575721029282915413432788003670940873484464479035116187361986468817764174983360339341760904395062935668506379254915132158079325547293981795720009601997338615068852024788929328937759791477545407878160402653256560646902444406842976796122588950069195349060256334899731334506538" },

{ "9264891165355739565190184416501921531110089392234481682785663537978152834210043205322426048946857682928713233093454298987718151514375312698287977140085629", "7037874176512351849",
  "1316433191754927814343121270936699199595699278862016004420926865721433832616431797693201713416985056700387482358940219476958754936526117", "3725966351458345296" },

{ "4200307032774171266112621290628586259036811354993551074625290503853725932886889027855146647188583607214617803535833936888841730747156500044307235280341823", "1284895891758199540",
  "3268986273297707492966046995014614916998242647231210827092764188090140439361457237468815188241626314878458369000334553644889671709204514", "686385384999618263" },

{ "4633581426210593840116821588308941075113609939505374670564216205139790589811590001728944069668539972864711443927654873778749890460797761818777105143436310", "-2962967916964005701",
  "-1563831116658993795279542101101791208522139405163357327177345954575873595639420625598557391282445499923781922172975036467881769387028636", "-2305528351410817526" },

{ "12717552468498637611743035736272812618998169576927971614333302239794587794960622996075191568720328790968571121428403438724885597787608886055291630047062012", "13314634913503466421",
  "955155928128432692468469826248574845938797371431354312846155816839032798664341688948121282840353830287784283921940330056923616110441287", "3054936783550538185" },

{ "12062294501874959722722826646961478850437392058690935960962546316456440331759806886386062852332964852589981740852222339370133938328830299239599161668985128", "-16763340409247566945",
  "-719563894032763567901416565485723597235798340734444183600832520303761799320002945942723929422229544393458648487318438477478730610009081", "-8784252901936442417" },

{ "3044847544275515285523698330617680562098304367055502952571345800359603621492376638228899902071703358030930686556600015395721763778348780143354036450288026", "-346996692199522190",
  "-8774860431593785670059820118794469144363980632658525112469174051232043754755411530275560319174086707639904288765947602493995823751245651", "-238735003065207664" },

{ "2509912747961300370421908848463238376627618739583712646450568707494390365647434163992939257405972498499963653610934135188560348612028561201284997136414467", "-103539220471632131715513528655357150478",
  "-24241178719797015812049763065806339919024561304709065585003455368093218973185992185403749066840410575011438662859226", "-96472873114015658715754743886276195561" },

{ "903584156603757584665316743639288345339689627067279191353819345586609786559389840933430566508676924801215959188934167984436460131912383813696092800782502", "331768089796013775863175470747253254043",
  "2723541486944457282998823558887230609702011905460231484608706829329099534108144630923237396663979818212898288888162", "206235332161320659528701690369799443536" },

{ "5673315779132616764913839385550510388979090539569302085655840858178135330568442902409259209441411672724870197775936862625748838206738247202566588717953664", "174314453261637397091517016624017866910",
  "32546445076572334426551736182476341541840123356058415149120265601377736759669652080905093959104527787429999911903291", "116692109360780668718335531020688952854" },

{ "-1042174796681883628708939541235268651605049912220225874766096393016094308719465113556241387514699104237113811358810257758037463299809921161083533137718034", "-222161050831883826404696847740663687900",
  "4691077903977550484144586938760520043889189188344556635834217114054282381408390083982959968194813858480017307031811", "-99596643070173880773679158795261931134" },

{ "514620852714641065399283188571474686623886013323210978774935263256584816823822985571618774823719005380283570413767760460152207111047429811764462688164598", "-249379962778237023348159084806351533829",
  "-2063601449697349844851896329155481297775287042332288194884672211603708613220802144442049441368964502372230090742486", "-95322380544583572818596570976868394296" },

{ "4269600385716644031357008587416832262633392539755787971157199376810061034292825362806383550016756143465036715717235613514913396047178769910869994174370663", "285417980748490192096950554131180300340",
  "14959114960171371128118740711875740516756226597819143207915053559296218628291049058344647983358827408473567791787490", "241314195989544958480263376470519624063" },

{ "6257762944066060502889009610562625466881502649685643619949901701091938859953222566838296129679249506961399045004819501125771060525963805468605899184284857", "2403901388951678895074087838271029994884292204266026258064846860089259517515609086601789420041871201768080771502802345608184755582676267305500365461987443",
  "2", "1449960166162702712740833934020565477112918241153591103820207980913419824922004393634717289595507103425237501999214809909401549360611270857605168260309971" },

{ "-11993484600336960787296361130458404039545119394875472848786275539588308627572632551925095053909141197737731742215007587172062102742960429155637516154567478", "-10601606227266649325153572936490025724316912773656025997862708934485961793376598665748396482615905529759961488391911046336857148489489874009257983913322770",
  "1", "-1391878373070311462142788193968378315228206621219446850923566605102346834196033886176698571293235667977770253823096540835204954253470555146379532241244708" },

{ "-8099353584218727402496117482244315513694479151831901237119469501251316930293170263154474101121202090352876083340578448720444998702069748972927117400667238", "3544314361305784888681580682051379178614889611356920001389193108853540699763802421224233206957629368752496825814976307915371579698349690086107445288844845",
  "-3", "2533589499698627263548624563909822022150189682238858767048109825309305168998237000518225519751686015904614394104350475025669740392979321285395218465867297" },

{ "-2978635751180326260478380464684854159186938695694356726729544155114559498149136630265180287452727795680214540092030170434165319182046797389540988376220992", "-11044560433803724847345327269572156674554851849210901400046696801586678634230888624140822828361962132102290537138655249676050009778590939633587416463610415",
  "0", "-2978635751180326260478380464684854159186938695694356726729544155114559498149136630265180287452727795680214540092030170434165319182046797389540988376220992" },

{ "13340538348613289212198643243040710073441733600226599862111857175429956610033827913042723029883753278922272401272143183977342753296395660841047710386806625", "-12505012580354283714273335370179473407347376833608196161777727706326565713505585671787333065372262611606233460666323939469037058474587043990269917174242835",
  "-2", "-11669486812095278216348027497318236741253020066989792461443598237223174816977343430531943100860771944290194520060504694960731363652778427139492123961679045" },

{ "-3452499360915990528305851079744650498637858290301947784400848134276013289408593218875969649149167701046100505360083493320272180164238716241369492874982856", "-2841735595132421145030480470066423226109731223189024018875906078709951146850527470934664784555907173906888591079310297248898808599295604861461544021697908",
  "1", "-610763765783569383275370609678227272528127067112923765524942055566062142558065747941304864593260527139211914280773196071373371564943111379907948853284948" },

{ "-12837726014506093148099404481188410844577204272048603185395045047349565142592994407238657335674129551317417810603584063833795494760777857363295221929632592", "-5400672038070763758928059302309515863608512780764658336296609520612929827128710430832496604060142364086061442480255889774184624927820479974807630834638627053061502551989845184646873008822134065011205730341955561862333543891572685472831543459711809182159609688999832404181689665081467086838440500602969410420032314939424736094367166550148605570451238900811316075091818613634658092771400323953464835124475741159313252328998401218032670762735091435255199537815920258090766640501899817468173756745613666544200642455036991967916355826412137450931256645775349763991939102903236911444655964118925598580974976427195132959063",
  "0", "-12837726014506093148099404481188410844577204272048603185395045047349565142592994407238657335674129551317417810603584063833795494760777857363295221929632592" },

{ "6578123342051874578301723989032639872736755816906003001838468752363433436477439123182015773040480790196872643618542950300401093404997067180920740266777136", "30227534847135453106177887048045830910966009330493682541426640262878585964314188306388368740002450969080153107270718818194095421631888634061517731024627240634873991685067246458822125591350775226166707968203074411304172314390138208453777131423508042090910198631120304798774511984974823253005683386272038346156403540545900138637964682890471751795844957640450350739073841005154467987598913264762974403365908691068629911370262907886883158252280853615622312950774196097179304856495254526220900137020823369927850276669023897589972466867500466273084668060310345544901231841857904496215091732346299276586847479136514947400671",
  "0", "6578123342051874578301723989032639872736755816906003001838468752363433436477439123182015773040480790196872643618542950300401093404997067180920740266777136" },

{ "12403944923950846249231475663107427245396603223802100275104415443763524399953865335344297718622152249002880852792246968794311649331174399649925724682365691", "-12888526328266820415927145054786787145889555649382608442248161845973745960691528655550360088202102799744537495406020539568745771467756467183613368156733378808019164713600978887019905699871417123365613340681673916006626966649924170996253273073733852663021384681382051909095614154557333966638418401258055946731820806422207820872515345183005729150326803604361512295955159943694411555067679327842378949865992521340416781113735936437694218150384351520004302169462501770232864597266654390198260481651327159066598217103147752784312005857617885666670915444340917773878003125490279146098981790584757296196254721882965728596834",
  "-1", "-12888526328266820415927145054786787145889555649382608442248161845973745960691528655550360088202102799744537495406020539568745771467756467183613368156733378808019164713600978887019905699871417123365613340681673916006626966649924170996253273073733852663021384681382051909095614154557333966638418401258055946731820806422207820872515345183005729150326803604361512295955159943694411555067679327842378949865992521340416781113735936437694218150384351520004302169462501757828919673315808140966784818543899913669994993301047477679896562094093485712805580100043199151725754122609426353852012996273107965021855071957241046231143" },

{ "10948926687039959668263034501276830818625159748756208667794639002017960671515169323966433371280908617310031465455790806503858320395456591407286777524363944", "15489368888944605373650389556533647343231613227589912336942045556008797399070972592836944702007913599282985878262526911196097512734678645706417084706692047107683744531285802197270639216129852640210205547180574081479052109734758880839510339349237982383997307379952940072013079809351763653427560483156946719035644278683384662348499193303099798764213152890786143522348717903997482162057330324665060570551176318195643585920374603137371921517627526609290876303058743280212715019326447206678291320236859616579863769668727778545628289338458285997742887048186232356815344233169348134282594953756462483528235310248146271138654",
  "0", "10948926687039959668263034501276830818625159748756208667794639002017960671515169323966433371280908617310031465455790806503858320395456591407286777524363944" },

{ "11464576772189320419261665628466949872551044398628568459420638211702970737332076526558331636045640676437486199912474581890841933557822038200509907802936313", "-22467560825853172479037421968188386486420879368653733048793951227030601094142939166908251610058992921146938740897141065727494001469172869273657374887890530345239013255211792126218659779037493454354985213639803588241949068595974842726845550080803721118359501094994460828504625140423100683538018569820187798018489678377090273255263020908779694768888896507998040871877361662889436371169588814603494476932238384716309803290555316924487478792149178773379217766514013266795383492328680695659480010501872205935050314706513127406414046031915649062646891311739001532048668245929929298605152418405630093221583825629790103566902",
  "-1", "-22467560825853172479037421968188386486420879368653733048793951227030601094142939166908251610058992921146938740897141065727494001469172869273657374887890530345239013255211792126218659779037493454354985213639803588241949068595974842726845550080803721118359501094994460828504625140423100683538018569820187798018489678377090273255263020908779694768888896507998040871877361662889436371169588814603494476932238384716309803290555316924487478792149178773379217766514013255330806720139360276397814382034922333384005916077944667985775834328944911730570364753407365486407991808443729386130570527563696535399545625119882300630589" },

{ "8938867625495530153186421114297747048040597826172184076413640033054738602015847458230139602813250873350372960139469151926251587994978713194477868118851140", "32078375072910127937267277353555359769886046039319229674839329288579279294400524798815635423380870475101996161416889444654312193048344262195882716890119398121411812112449203794619431500846260449790771355510015457009235934372609093350279916863051987911050185220414029935306290325311701907978862607656115228781358052463349741922708496995681137879712967466047121123132315277071458202185149672157950295326835513685167006326116804121841993768353882369640078584371838201520000042076939249781755766637255305083290727182613012935978235950698890245889658464214791358409590524627630419359189066595841389501082705783042993303059",
  "0", "8938867625495530153186421114297747048040597826172184076413640033054738602015847458230139602813250873350372960139469151926251587994978713194477868118851140" },

{ "8722682937170431050833187146084378340001260037987475887522226657702929497643381574300242436757970258082372353322466430729560481174965555877218498123235127972650642792093407571195465205419575987213014443482975328738475261835806620444520634849116095235065774422144459742716160248838471185163698000228745859478158104063095766855794756463409807333016407203497851105737138480852953389782284594500871170431951978989370255765328498664056929197514187424012915608945460596104718351333193752820591185791608965252963085687083606400804224201063308456591357967802486377986437493144904666736661926951141864058594174814702200209409", "17412472792254218853",
  "500944526446044913245854704095754296476914947449773601840238266000641308362538841153234090543298285278030309320940403936325404298435972916448525262079072487832742313980507689645024811947475736929391921911894727993931203210832413457668815952782782949239897550712034201783959782842323270598876666346488371315244615931371511266927466746002593260083813695350859233907674818312186201150675556646229110170730257749054381148001252368819048293261475322932890858943640868603051493461480912552795132518076648186629059596407623028993206501153697237322059149347109211519809718392500920402797396035977014151301", "13717640401691531656" },

{ "28355649069936648964480577421600521514076854589748655538478527484386692848040560920378270353295750065522502408426901852657385194373002516782134462463403619404085937808470896616603996134884288656277511001166614643845546560002367982733683422291378278295503032478358197654941019479109634084898326003113897170044006328598213579789377859798284810297339455100733353158770429621612618690067430491463355522146151298846940191011096497912423339688256950368577997428204387561345591508638698782496102293891198658979297125431373501637906166414269821235570899541062164735301390814949753951678580623524363615439367796948526661114273", "8633859053023126034",
  "3284238125245742016855698157684933898976923158153988299571059835059738533454483417199061360717949675767825259147742326435714596823475742487511565640155717557287585352355724513814056546156034557507060565711152037955657280498048473524523497495066421726381315710512047045674071154161308957202034177182801687183543929989744017034272683534975659632492076519296858840261469439577557507171156150551483889412665000065287799665100306570592222219949067222441707356112651967102951988787499729560738632591896472356839552808850928783757605816255738706660766653939585897846868373880810762740938652879077841365007", "8480542101902822035" },

{ "695804210379264643979583966247939985121477063798866833769029083451619832314943028815111717357207629373097980486420088049066444875218919515464168730784010670913213630418336413807551517181427706050442981412812560910674568907086122536915068847926867597666432252300779682993163510641754139318056267379096886236384894321926559804092457910184502775704660359338939407870665678723351102313495695271753077268239934810069567863069912893064736153816317584230084541663742856849855885433861537874945479324326871485256528265492542514387227516996450338546971631790859699133015684902494112907242906699969802617955900147949678000702", "6681774530135049718",
  "104134643759851814351147451693200005177949603843035721223567744815305881538588822665583702468671678158123657386652154620049781061631961328262453617035662063853637317024464861861946266314086911857166878173456014196637218631863393572542109069255296051532325807248516303174349857623773438852122643289226264801658953137748153296436411578898337203701260654377419646372368642303334799023574274991890918545934625239992964365706183254509198057965378271765137299881104144690382322308740670412140492093203922319672781421992523823019735773183797196153517598307995654976625437636949948229208840097078305544042", "753510048969320546" },

{ "23793846839231724395641481096168600821165863841834871677817770057997115862268350281729411419898015728222764385314741974298570203231459954889026804768374989204737469979104608191592488617915776065920825549826544170491376474603565313317103382409887303248767928207436610335921923003830631904883475966155908755916279914050461058817604412376332860234542206749755476863494453482771627934874030957391163592500144106720406855489772599751499515034904792907346159848425450017939743424553771285003901024075692162881112993617392057913260097840038314973483416617082316428401467936188718832437149607288888734084245887947167600476942", "14251636779665730013",
  "1669551870223134151303903342674455433642542678166026329327716199552424270739267924882373474967130314854205248773422856606186537084529373808518256136223710801915037299873741750309033582768093390015183894640465684163714303454407585554851774795653260663343812169894506517621409762650950455752948417517702896344204545008148927831629685230911115972567815995382195887880974480058637498609515045000261275580213450984765289759768577989085446697886224919418538617830152205807256503108619376475835548388022966261347231830397100233962945745245326537590040744120991719469590787920917431072137837209281279829978", "13846244437708747228" },

{ "5157109352853249971318864071100809054313778706912280725237530653514718017885603638808994268309662830522966266131723296476071219223553003512249189605920498878997009866938158487186969488205976122254188731320527219934117903279062529020046834522969499499006879142996400588997334123741485390256248878878301063076286830584096271875934275097457786951285271567141607668681320623976130528011279831938224824782139301311433982239041406699687231975177586985955350651094601995816681979048980035660883809964491229857363116776116215144288428315817606755704237448380042774619545204701291306469557276264456990236770565662987790837189", "-10013270743141522218",
  "-515027455577944332776599219259294388811187969682242219239790206822600106136108551964834930674442778634657645567794824061780492131991288077428371773780758138983535394992930162959647831148714333399217585802721010849103285390761891312665489859363343081240130486926587552859706337223282598959658826457912110150229463850079329163597771797337822709730777565370953422223408595882843118286956939988955846229075579330815290845722563420243422752650828997772215730429207767090119357203878107337884921705286570049639435686342039828502912430702417787311741719990865608911989344378016685337998208215872207554274", "-920760231421022543" },

{ "6494479986256116541104296929948745881595810377963953264991072983439840586308068782167240611739100078965050725068818882183756338815160036859027539278041681781661292616356111680897493765185363894557565156777508945778492400417041556530072176186473028646756075186621344659621007329706013704866019055199752880400583535752226648517005237843095412900402261752786336175778761394870284838510406493285835836510084377115102990988520712094164167646661458280428910514014249834132126729469995977022911113044853980749549364759880528586645949565758303087716543654543586861828638440479331739588108393797432477382024670823562517526646", "5646044948886972124",
  "1150270684178027997729638025310141697535651329313468129284627631873742535270359534840413194117215304029010709513909008920532146218787185595227269977210380838656683242728568521891853665038056999715825712357842110695616824097006318159870253326008969365677078769387050477555367309756230306675796151995910498740461667569866473279089249936015985131524549691332989894205425117195925594673141706705491188937755834316410829046680432307112608812689099288880996341318638564624566449876699247700823589547245730672763432749619618807750355174780947014272103851229064036660484535227006468477136474311066305263226", "3785857158573214622" },

{ "-31360864680221422030140415094508859225037184177278863690330048646310966010764143021431123151508104188281687033827937090369965061135751835578522568620174870624326364591751719134017727476315825913896303730502231987133828454596458972192605628269836766485752863341723932456882638706013143064500915331711791221807863285445277518932935928879510111580179238430718068897684115464091110803073393785115849134031970572952341156248906594900067269723116623961645695573540685417690666812895681389324387236630659047254288574908905115640816788218380202062908240234242061857266935270268131606785945960533363545765413571210356588614272", "158731480268028865375787109312788454557",
  "-197571802564094255018835618501836237470451780852464910702917947610328490115600879542277218044587953977482033832066853445897949746594340123621010571525423525283265694134335278880857970722363261435835440841138075424370755023622549046990506755720823389094963930373207384718204282462412342807880786115573288541223692700693236309165845190755419998468567231783954117079063183652374494384463667165956585068985935341133217173168221529758860606207789154326413767211275484817995028454435144966634656180655573506329003296926488159246532512031996848763667993503525898127688305577417054301089", "22128982064863884081225183621483498301" },

{ "6972688127252138459564959519023672734797720350352562732688801457617542500099509865574973489633915033719003377224851429368921013349700580153017928134596084737004044411366993842119504403376959959480789333673755655063117787017101298662107070542628327980482897959181812093955456006698786827411711446400770298021381400926276799694253767942575674933967663793055141073318481678170963516082521833862017762649825976536694779299584090771859213561628651925244725218133964348562464473355036335901024895778660125505334188112559810228121975479770611339038859346371817450184722764849484125019138077786325611240207689562646177214862", "212229494710249959442576275005814060115",
  "32854472639496801513625266171869868980490382632885983229822011721729192329270622778562010916862699719016516950898363598128121229189750116863530046554995732003476968354657890095157193194509736774942176733534056571834590366060961121671289385934253368995757730753667329275656966343378668081666905678760988072374390324867142186156887369444294667350127131255070935565628787125782523108523608392770938414227072810340675454608542379054058487857197652824285799185253955626498482144435788461420918351383205430463919873128183751743772403931916447474872579786344165522578418757820262494633", "202602247999430336716424978770050352067" },

{ "16146477881044981814872185978005786543642189695578037880128585850657582227346785609949631520306446259385630057714250080634804935779512167368598228578137970013047546260870411704532863029107179381174130047754949458719207263855344249323475379597824225167477700328511898116621808311449385399905867898699564040099050435706021172544369947305690899952295406293447506146823515423102232662385522802025721933657658703659553626211653699561780784625213816227416468145185123310306319508640423290747072654284738002434784128270456278391972933415297337582959158202392632248570451671740383769937167912379559021602080900933189192375421", "-20310422672054016316639412907518719590",
  "-794984828319777650694385094127543908631549711061207837016795411776676915426259473368853160688756737034823729254185786121643208845684214393842790938031685686187522759314947140818495607328399712740082388950671812621562726517214947696883370445215206445278987678057453772575168165658852145270562955365137991966349779422574705948837912807073553643238677887356778699590679423929808592396737386221680984966466476609537799000714595283015387280145210362603689829188312020767177147038887361232908826207585485585717770550283815412266616448789002231614634998653868395118016500112836083648523", "-11799925147898511149643800539362290149" },

{ "-13333386402689284528955650425278647711888918022382802858930735354762601039626630790596510115878972126652469762677159574447095103432811719733783031083771953511074739306201836852090205483055377050725227473420407492132102122918222222661174330427122421429872287465154597256840268514193104109407101719163350519145025605863849817679140939130213133277602018019855074419919415918787364400403970284236218639542926948339939839929520062948689163759711059171596722904754429438151009753108425737178467425999202826949155777669899192519705543679208977557190789421238295365156644743397621766685402593133067165504533347334868817548870", "107895899863035416090758241115761545328",
  "-123576395577726995467509810094692559795501216776624732643654929468261569953970620516962817836961555200657486752392956631475337670018968072148956742753944568338154539759184635744464807131713977468703479999463417456632584312098725347773265375061594795112459950102134313707118281441803361728717545150343139196161174674989680811767284271234273952364761695483244122531302983909975719498713709629935106791776293856798291478157380963024628448230576871460269799644149756524167414024818290038046315016119726155391403548599527926110598142014566712845146844517328059271906387663525750970076", "88916219636034843584282198824028056058" },

{ "17396957313719309181655810621342598276769983942993211094806395284201495622288603530182348401034532670779772026613959220329662328631746748840677422913897389222211979435071300283979361385673923168895608787064277711550661080470385607194607715097404666355341496134600730286695020337462621706659365279865288817231582460135505994785679557826378614057840182487774381015927951405829305139118747627556929090278010945530871104877221509669969637405745641517281958386251071953311649218819211648218403974139963448683937267881136641329201897530450274203549882462469989176813129608929688681288830465486480047730094845155570312862849", "104186547224209978415781641589908237686",
  "166978921724711432713743436094800137505239032223722714964309089009506614535895519867110422644603923287110323367280581626196181748165083370852210731028149827924135420402322644021166934074442323617970930798783252483767604446788478644579242675426052418474560530381252273076756647943610269802844827006798614570113552490465455602498689920520721194207399033534120048155924790694559525815508064767545247429922864279482054330586837508112647624007190343625308333109186981945018060033849826856038685383194624273212670683254990051450794748656874003602039616482791671154071071940218956513118", "9689041137085346765396894259391897901" },

{ "26296668029363560180578472840636347646283515109787546573773133131169235303278230292620358193183994696837168281782424510501462932715289179113988102147665778902989371433141498385910026219307721742927641650208826808587628688330897125412814594284814050899367007933796796475217266168539594147019546294897573039387284123267787652073296654465797846788961105602455421819896924940988943972769457383697764285807789932427485615761627567609238909525216550007481876466503244451415718439500787125259366798747857812030734235875561021422659158282642054300429948383202431010170473103089719168265166132037042278884136592980721399898848", "-145151976679874338336058059363314537",
  "-181166447959297097309632649706277310462287087273328158550559504514077025970552462585976881228509338936991115036681066334762526041621219901153411893847383132947014037561714726163730996723689359625350327562359371926025189504119439124542211108302015324941630060663441114185165191476531119095379776949183747807676488899740428054170566283213350742091333006110702325305863276507428847828894436119391753135134140918882254262557249907254757481730047992171259860818951015886963391969368286964814563381601392580107247382831740092922947642920341973871311541502943677603328463821550096331015449", "-110577937214275422567781046193383265" },

{ "-19994387832358687564296482880955715923586831477222916410597818184152857711804843023778287694318724091304456899035183525127967566364649938785565453184727547598671504088541688780249133503129117660562371945085803761853547276588271572826270417538713473845464667687405215144939251922714172491714494707146884856110703801489923219443900691887441959990915961809557008130581221371957930424791112777130507507175854695038524747304496126685506502272017923871345301904089286401283977464945598827719321374155830270851832155999413594990591210770207211404582078047399265487243377424091264415562555479103296829671606309227114918559411", "-12290727751262531359522445814787932748157034294075544178515373320704162497192584943859172528304649072004548036058435558708785921268699678655127651925033127",
  "1626786325187686206254527912536268233229423573477257270053889346415589499220953871015742625081244397640382477041911954315181713027690095532216560352291641519082404655148801601548476351855968135320238312168182690718232048560912434032449056943124604465352409935769208624710904989903415445402236977791654195811881494578919123294926181940156782515461241607944723498957864382829554865120206763098110715049165623436566759235599826844834593966722456940122296028858654743", "-9304614710679256891239598861411560332304324920434685965899525875715186019084445758952863067134832791421060008856516918122255022315420901512824783987888050" },

{ "29916764548363516315213840380698377536192609328827808911066465815108876776179490417834258307994776308911573596103626976278007330105709262864909645777842169226871227147054313657605129607087589187123503174807369386299991859056839377153696490642393964375926230602462747312790529261100240727992473466712957240583216041201088172946856263144111813006598318253235946940685055230369936673556047728831107329646718919450916347559724523856479721600705891348359262178740659519774585983326669798219391447115538287743254388570949370216658299333436961807924794235560183973249587386381643272943817567729138289488897133971529039695757", "8476334091496252719253471844340714224307718865976339399900779938495486609491382968889867250990569753004524377073297071391348967807704774866029247355531618",
  "3529446129120492576886933802306348265603546401021071145489371491655402978871242160302127070993421776756377896228018319062438889879832901903630775379375474362476945682118589732246954574638082665328364641573132346715748566497144048040413137331852635046499249704620713985392482170976329565026453768403409435575238922748145312555307402543771398751056417238642358386670853730480256387244547289563589645563705382910276075835741806800308617595407635175179549186349623407", "1121598720662440742988451944089192258208677258393969079460095922943603039995215206852920630773807538691962340221388452566848135314318278502721876458313231" },

{ "-30744743258986840974825934925400463284355151584175701001085034454282509186617636999187209301942468580138651572968436145883508307958710953672541548503099036345172087541186583358599035971842953063792288589346835317805238011836025866089112384348158834439025788655670125182111347815257445264926636792871229400549827577321670531162443103810493815924151448637886392962948822485797619344455378736429734156821345757186019132123507024835777255364976075865806996283635073664232613154449751312293463363442122204887362535000774934247468263702545257658938264075634847752288018235968497021028555508346290918717339789336670514080457", "9934634309555858804270980126309615970053320780519373855793924975583204316518242194797388422238716941854010764960600214725109000476250489194524103405530739",
  "-3094703066162616114961725586598761886126440000450319657542750158557542422972265973994772432239434133706930345695126019787070526540238058168248601279554005834087067802027491094801318957724338773860374084056857766237802500357570852135835098188033303615905411388899090151866056131910609183545491275118194384669083917607888152562507000146957250511707959497676133004912560741040750644659008842081402439245159076407113469036885418577123982203712293205143214370192534124", "4583596897489701137708573201509728063693689464812281935974761545728663079569821440573072545991527054461975034582959468944964678550288258358252037074357179" },

{ "24643502519803888691586762836893695554672668882609252497967357925433058477865049537403781351424439957461939549800248300068008928283760882152105280755728186165336818042947891471506568092832294726444765034759769551554808855491501013689374698042749154404230203678454785382207604303955330803002216399957247238380783055267792042696128953561495320963977422797650867160007702447898131066450706964885725041540562948429789541526915479497874153956586286026740960933319749986950590370162278200833957789772606366304927219928607487195862425188567871883130961914293433624774413725427494180502314592349900074269004608052919421088368", "2717450167284225996753981867457220829510500841312068511238048532529427648370573174539553585183069673827813696207263846346713773366926177883038970327669336",
  "9068612486988930041452615817812610262395413380750714216172624755617167719146150429506179809229439286481063525474263171526993584649905549895379552966354856688607031124385144196292585204982548068977456744404073207215088901248836694827956726571697679223311674675917482789361649212542123782029147076771863216074461137218175127751607336902080642274682219411530926094644805942929937073627694007279189212959755881318530033893691479717411893927131774283641886860168845194", "2630363844657415178536247490974293939778607568925570410250370678327072798984411202414449734187268017772490491616031334354084510652181851150192386816317184" },

{ "1857471144762621226078309760048781819853808902834007243224510947324703640579895884811355396539307768563652552656687272466757001311647739575925654454617797724205998847128737511426204839085303003071906438273332520201294499647651016586411018765198623236956366866836742835368817430092030307634950795461633849978479504285561783793523293571899866834127333885745234267982498066548934305641020559144124243564372784715821253591393010485777361901806233522170298666402318233462164642692695586402286093353406704474285764942607399336515494566976327035651095257443119526233432484730549923908643983835638400244551332963304703341991", "362612878824948204766041465498605121983038344328923889813821008133012829955553725429013872301357114460102737976404433762806451909620639548491755012601032",
  "5122463247256360173380682454830667735994909336257131094636868172398931453441644851286253058553683806107714242214425234484025628771776577335533690016729030113210376620329656025707882934177847398968795670307669192526890837607471635669459016090183544133427748745285201703705268883110778706355536331762965138118319801447738265213248123408984033840769670544118622199016226728679039309116650227118501163822195946867970684116882706924781160720494209768961175300546225784", "299760236823448232299335077352435634442705524236228994156709162318327253866985319237312495500717724311867426639654094420477947147244359720759776119932903" },

{ "-15512250050509017569431653406374218468191654707236673402325185299702995515514048891881128604127259128940966966514594946451486134694476273851559935124397715410737724278746590654901453457150411276548615199767807502093455391898384739629715289928761836102897197661380120487438391395985221415090269132778914962364055598932950972975325423902250870789291669816092405224971234605691036355433974706922342506063057313987759468269851537540937400869685698983579620650290591582484180497444639057157757973753179907365231695893268694300775677678977541920955165836544926807198464657683328635157477957240884116233992874779933793654204", "3358541127950670805593397985550958371637657834938091938230318311713415017140090677340291997759883758478618605945079413061265904587739160855880393703427541",
  "-4618746491270258642196486131268015112521835423420717615093174172980857448220383551186758990917205762587881579670823547496170992786073126440511182401809159567300795932372630208424356476743332043619346311088384079059435373790499576304419282368802375623485321283238175405485184862968207039638749406944454331623523507687428477960605913568521627594126207284882249627708423470608914416155986620408793531083231293214124556072929628635430705354422888702360112306375650944", "3005102575063606384680566102915562580638230938191281335082512965430334791588194853068845397234960243041587407778382851298719244486316278864423824018594500" },

{ "-7795907266149417935880848054805638357926463272237741460640947569644048588447722511612181517607450880049915905557897989678236704307693907736247058983016545076253121570693500226105057772914231058133990872553093077477246778482972908671114493634160355090012802248700706280069417479488180111886570768297449284497993155476453139747448123977064178202693174347058572053686548952330935409613585349836865130827901523001778569465270141666026392762544863707172069660941583975586471593214627992137708766736399392527511202198595607734119123667475481080585901379489987633325665012548140296404667154265922084962379380813206642961141", "3266322496024458154155982586177367205241879884975448114046439840444265881425140636480586339953113858345978121218157346057285955670573379845528853928778649121198573716895875372950665878135491926664618467827249347334921049358968885123014320008238518111491029267663871866232098994215220584035091470875989416180732388925174422587186795087858194659347743269411322176680238569785902471836835335166112452646235228206195081915725782645939016905926964169376697807870023636080042287120562847150399762713196525578131013908505157176421364232903071413436786302567498639276925676203136397430977438669196132229839190136276524068288",
  "-3", "2003060221923956526587099703726463257799176382688602881498371951688749055827699397829577502251890694988018458096574048493621162704026231800339502803319402287342599579994125892746939861492244721859864530928654964527516369593933746697928466390555199244460285554290909318626879503157481640218703644330518964044204011299070128014112261286510405775350055461175394476354166757026772005896920655661472227110804161616806676281907206271790657955236028800958023762668486932653655268147060549313490521403190184206881839526919863795144969031233733159724457528212508284505112016061268895888265161741666311727138189595622929243723" },

{ "11613527140000568192482756738253388762224453894786686024705324634643336086154640452808765642911437980109688560443031730927780624431102238262306897218656077453053740901919490705730434109001630505554615644472687423755323577388664893480041595787444776915986509240983988768996984961291424649229547505632144971266842770877960364848817464904515794389771780820407027606373375049573795106795237627834701205331678265805568350911815774813018183599320960878173351437520785364220474506113269284418886794765499703487689302735252054649064328797761871733823998210784410557300554983737071496100764692702245794941065431902323619975581", "7587249511488455291481574592043097850017617150850944854151430663857438629054661904725186504711545142985024178310267212940242316767124495452290378757849233879415880641974894427201010329762690544890887138507664079244754338469394276854749839357593153274763991475638253761900794536890806900100092838214316658164432730592513062527370014192403678448098350118128696785002089891158354556141292773760767431084006166964515144211080310413063362654706066932594296395740249062444674285627590937186704887659632200604451417990996813320236575100574875972599186794102474813935877205799664448604353627460661673753990274449050152179527",
  "1", "4026277628512112901001182146210290912206836743935741170553893970785897457099978548083579138199892837124664382132764517987538307663977742810016518460806843573637860259944596278529423779238939960663728505965023344510569238919270616625291756429851623641222517765345735007096190424400617749129454667417828313102410040285447302321447450712112115941673430702278330821371285158415440550653944854073933774247672098841053206700735464399954820944614893945579055041780536301775800220485678347232181907105867502883237884744255241328827753697186995761224811416681935743364677777937407047496411065241584121187075157453273467796054" },

{ "-7305781671042805086205879027901218372025263744748476920370936801215407682690507181906856060500614379569331564964369672229742583709815447579920249246854986585035499467980872113078927984775191185433409825799075510115669850322522523768142598684481781858254267858499128954637862215107851239397355311785880257523971110240017078879170794103136756816178851155500522519324993786026829680880063502983144325993463559477297984845168078230705008144229777150602704982383890956566628052218375163513110904344758464487972471262152773773566261138354198738738504010228322403241824600361830597196538559114936352203702189317843297305612", "-11937423884971453925821024083751259499642447259766781297912835275709052311299551864192658177304486399283699058384364751376568714457361090099824205847610164922413207048832164141112741434740690851620879666916091683114805059397520385319965609291355819302668926633114618391597972110270104195729524521712155052417250364832858246777602394209216012243471719585422463867924602236259070514326289155605995143153426519592268534452020820494702940294360007255909971183689215427975382460838239606147437401771039532404179010791325434773433170447691511043481857627662741058910094855501029573945308325534013127380693322055343068093073",
  "0", "-7305781671042805086205879027901218372025263744748476920370936801215407682690507181906856060500614379569331564964369672229742583709815447579920249246854986585035499467980872113078927984775191185433409825799075510115669850322522523768142598684481781858254267858499128954637862215107851239397355311785880257523971110240017078879170794103136756816178851155500522519324993786026829680880063502983144325993463559477297984845168078230705008144229777150602704982383890956566628052218375163513110904344758464487972471262152773773566261138354198738738504010228322403241824600361830597196538559114936352203702189317843297305612" },

{ "17209502052655993695999949678678881817732805080961191774214537634467104669997820051278559964292611469011761231649311262525642916746094372962648405298787080759403024379693612743720557853611946286870304197122036126838107226222151419136402861650399432372524638862075613534601535719033760228742681750726602275976151585576407980278472053570791272866409613117043122126348697545507835143620584132787128003876247255766444872271317786602207376422907474443135464267851639815814827163426470735478362760843575789201717413221027220343295978806345517086041608240978720520050196395624694268550345436208830801369557317350938753101681", "-25492366031674865714603800130440722297248675391454036922399382654290017832413394991423912006244487394226853780856833445493556957899686872020567315114599762113500546176766623020864155665149937580279148318691466089932874147998457966225079089491216886106456935347049916843309661581230809710698689198580162954443484103521650233141750002940462046212610545804018834324858009370780731978549694951052575612824613445810777717659953126577086301947235560041125102454055651800601741899891885690488712713049609045874194541526013910595588271596050758340197535035493872183554373796733932414738278642683363241812520579194986842248406",
  "-1", "-8282863979018872018603850451761840479515870310492845148184845019822913162415574940145352041951875925215092549207522182967914041153592499057918909815812681354097521797073010277143597811537991293408844121569429963094766921776306547088676227840817453733932296484974303308708125862197049481956007447853560678467332517945242252863277949369670773346200932686975712198509311825272896834929110818265447608948366190044332845388635339974878925524328085597989638186204011984786914736465414955010349952206033256672477128304986690252292292789705241254155926794515151663504177401109238146187933206474532440442963261844048089146725" },

{ "-8264418404762904935971540586212553189369665581268178138984287355704267971035469114147004054957406066365602520300857203610010249719556414712966642864630190534880504909484466848336120976452116710282569157883499369927614177722612839620755683557142607127318366680113418741529273669250116389195268121444810596743918472573214391707744942602210637166261703132552343842498400457951297867678005414165609775233338084350550320105330065321705398390488050253072298385134487973139665686164664754618413684815943926055617247418686500187322182211450203615430634564054858334306443836925011966962933359925972720453678168762605413687214", "5659270408666391096654451960229302202479994399681938594290004159630195588392730314741316662127233421095165804881532974934939182755121225362126950700260935754690609887023434283325604581248499606543036334396521593447377999307285561199879892626309791285854660250329582118972672086769638010239857182094917068742207521552140484875546416914612991626798295801703343486711676899362639653362756374154843829963089403048720579483739833657436575344900585844370562669493206999896738589003961397524062927929845521761767153927579517203070144813897742036471334901681673999002492983666998353060616069539877603853178826800408499832716",
  "-2", "3054122412569877257337363334246051215590323218095699049595720963556123205749991515335629269297060775824729089462208746259868115790686036011287258535891680974500714864562401718315088186044882502803503510909543816967141820891958282779004101695476975444390953820545745496416070504289159631284446242745023540740496570531066578043347891227015346087334888470854343130924953340773981439047507334144077884692840721746890838862149601993167752299313121435668826953851926026653811491843258040429712171043747117467917060436472534218818107416345280457512035239308489663698542130408984739158298779153782487252679484838211585978218" },

{ "4195250682093770808206657488351701663023767531608220002369022288787894743733460069813218793361969185403525213558437941222523116136985128137372308027033996674188008302853626391013869026313385724383785051935256506784450227965020957296318645208598488161413279403683346821629439117327209071527878791167163980953326296620631874274522101994118890706372879111377721965738161511000396672294975037034526549811513789043244305969633354034500541113123255063232374386942908997046756046017320772897856114275234707703184161983806610888947627465435762937561231247173215724615365040435541390265704981699351563837340527277633975576176", "-11523670060248463390302653643248573080204626895667435502164973305972185748470395654926094006744012148505197326052121545710242241891352369937317053719774706293090545099894988182012473466703170157783937873302934404896538337261995680454862441735502556865637909145839304694688324140057229642104588273654096346180116632418345589170248829444934471179206795690822184585196864577932274205101316913141872261673241280391442045565990088555353753789476615480189520529331131737084431448177942371080785938641454814169544682945510387155405628842164935394830439534834414364899293061798829902686953424000191565445443376301466821322836",
  "-1", "-7328419378154692582095996154896871417180859364059215499795951017184291004736935585112875213382042963101672112493683604487719125754367241799944745692740709618902536797041361790998604440389784433400152821367677898112088109296974723158543796526904068704224629742155957873058885022730020570576709482486932365226790335797713714895726727450815580472833916579444462619458703066931877532806341876107345711861727491348197739596356734520853212676353360416957146142388222740037675402160621598182929824366220106466360520961703776266458001376729172457269208287661198640283928021363288512421248442300840001608102849023832845746660" },

{ "2823618260546496405819033080103700734250203999069672146446", "18374686479688400895",
  "153668921843524129851264278497298119153", "18374686475930304511" },

};
