/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_SOUND_H
#define GATOS_SOUND_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_SOUND_C
#define WHERE       
#else
#define WHERE	extern
#endif

#include <stdlib.h>
#if defined (__linux__)
#include <linux/version.h>
#include <sys/soundcard.h>
#elif defined (__NetBSD__)
#include <soundcard.h>
#else
#include <machine/soundcard.h>
#endif

#ifdef NEWSOUNDMIXER
#if defined(__FreeBSD__) || defined(__NetBSD__) || LINUX_VERSION_CODE >= 0x20200
#define MIXER_FILTER_NRDEVICES 14
#define MIXER_FILTER_NAMES { \
	"bass", "dig1", "dig2", "dig3", "igain", "mix", "ogain", \
	"pcm", "pcm2", "phin", "phout", "rec", "synth", "treble" }
#else
#define MIXER_FILTER_NRDEVICES 9
#define MIXER_FILTER_NAMES { \
	"bass", "igain", "mix", "ogain", "pcm", "pcm2", "rec", \
	"synth", "treble" }
#endif /* (__FreeBSD__) || (__NetBSD__) || LINUX_VERSION_CODE >= 0x20200 */

#define GATOS_MIXER_NRDEVICES (SOUND_MIXER_NRDEVICES - MIXER_FILTER_NRDEVICES)
#endif /* NEWSOUNDMIXER */


#ifdef GATOS_SOUND_C
WHERE char *mixer_names[SOUND_MIXER_NRDEVICES] = SOUND_DEVICE_NAMES ;
WHERE char *mixer_labels[SOUND_MIXER_NRDEVICES] = SOUND_DEVICE_LABELS ;
#ifdef NEWSOUNDMIXER
char *mixer_filter_names[MIXER_FILTER_NRDEVICES] = MIXER_FILTER_NAMES ;
#endif /* NEWSOUNDMIXER */
#else
WHERE char *mixer_names[SOUND_MIXER_NRDEVICES] ;
WHERE char *mixer_labels[SOUND_MIXER_NRDEVICES] ;
#ifdef NEWSOUNDMIXER
WHERE char *mixer_filter_names[MIXER_FILTER_NRDEVICES] ;
#endif /* NEWSOUNDMIXER */
#endif /* GATOS_SOUND_C */

#ifdef NEWSOUNDMIXER
char *gatos_mixer_names[GATOS_MIXER_NRDEVICES] ;
char *gatos_mixer_labels[GATOS_MIXER_NRDEVICES];
int  gatos_mixernum[GATOS_MIXER_NRDEVICES] ;
#endif /* NEWSOUNDMIXER */

/* Sound function declarations */

int	sound_init(void) ;
int	sound_restore(void) ;
int	sound_setvol(int) ;
int	sound_setmixer(int) ;
int	sound_nummixers() ;
char*	sound_mixername(int) ;
char**	sound_mixernames() ;
char**	sound_mixerlabels() ;
#ifdef NEWSOUNDMIXER
void	sound_filter_mixers(void) ;
int     sound_getfiltnummixer(int) ;
#endif /* NEWSOUNDMIXER */

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
