package CParse::Op::Unary::BitNot;

use 5.6.0;
use strict;
use warnings;

use CParse::Op::Unary;

use CExpr::Unary::BitNot;

our @ISA = qw/CParse::Op::Unary/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $arg = shift;

    my $self = {arg => $arg,
               };
    bless $self, $class;
    return $self;
  }

sub args
  {
    my $self = shift;
    return ($self->{arg});
  }

sub dump_c
  {
    my $self = shift;
    my $arg = $self->{arg}->dump_c;

    return "(~$arg)";
  }

sub get_expr
  {
    my $self = shift;
    my $namespace = shift;

    my $arg = $self->{arg}->get_expr($namespace);

    return new CExpr::Unary::BitNot $arg;
  }

1;
