/*
 * Copyright (C) 2011 Jean-Philippe Orsini <jeanfi@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "ui_unity.h"

#ifdef HAVE_LIBUNITY

#include <feedlist.h>

#include <unity.h>

static UnityLauncherEntry *entry;

void ui_unity_update (void)
{
	int count;

	if (!entry)
		entry = unity_launcher_entry_get_for_desktop_file
			("liferea.desktop");

	if (entry) {
		count = feedlist_get_unread_item_count ();

		if (count) {
			unity_launcher_entry_set_count (entry, count);
			unity_launcher_entry_set_count_visible (entry, TRUE);
		} else {
			unity_launcher_entry_set_count_visible (entry, FALSE);
		}
	}
}

void ui_unity_destroy (void)
{
	if (entry) {
		unity_launcher_entry_set_count_visible (entry, FALSE);
		g_main_context_iteration(NULL, FALSE);
	}
}

#else

void ui_unity_update (void) {}
void ui_unity_destroy (void) {}

#endif  /* HAVE_LIBUNITY */
