#! /usr/bin/perl

use strict;
my $year = 2003;

# Usage:
#   find ... -exec gpl2mit.pl {} \;
#

# Global constants
my $LGPLHeader1 = qq[ *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
];
my $LGPLHeader2 = qq[ * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
];

my $MITHeader = qq[ *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
];


die "You must specify a source file to parse as the first argument."
    if ($#ARGV < 0);
my $file = $ARGV[0];

open ORIG, $file ||
    die "Could not open file $file for reading.";

# Read in the file
my $contents = "";
while (<ORIG>) {
    $contents .= $_;
}
close ORIG;
my $changed = 0;


my $pos = index( $contents, $LGPLHeader1 );
if ($pos >= 0) {
    substr( $contents, $pos, length( $LGPLHeader1 ) ) = $MITHeader;
    $changed = 1;
}

$pos = index( $contents, $LGPLHeader2 );
if ($pos >= 0) {
    substr( $contents, $pos, length( $LGPLHeader2 ) ) = $MITHeader;
    $changed = 1;
}
#print STDERR "File $file does not contain a LGPL License.\n" if (!$changed);

if ($contents =~ /^(\s+\*\s+Copyright\s+\(C\)\s+[0-9,-]+\s+.+)$/m) {
    my $cpline = "$1";
    my $cplineIndex = index( $contents, $cpline );
    my $cplineLen = length( $cpline );
    $cpline =~ /^\s+\*\s+Copyright\s+\(C\)\s+([^\s]+)\s+.+$/;
    my $dates = "$1";
    my $datesIndex = index( $cpline, $dates );
    my $datesLen = length( $dates );
    
    my $prevyear = $year - 1;
    my $yearRE = $year . "\$";
    my $prevyearRE = $prevyear . "\$";
    if ($dates !~ /$yearRE/) {
        if ($dates !~ /$prevyearRE/) {
            $dates .= ",$year";
        } else {
            # comma and dash logic
            if ($dates =~ /-$prevyearRE/) {
                $dates = s/-$prevyearRE/-$yearRE/;
            } else {
                # stand-alone date or comma then date
                $dates .= "-$year";
            }
        }
        
        # replace the copyright
        substr( $cpline, $datesIndex, $datesLen ) = $dates;
        substr( $contents, $cplineIndex, $cplineLen ) = $cpline;
        $changed = 1;
    }
    # else copyright is up-to-date
}



if ($changed) {
    open ORIG, ">".$file ||
        die "Could not open file $file for writing.";
    print ORIG $contents;
    close ORIG;
}



