/*
 * @(#)IProblemManagerUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the IProblemManager interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     July 14, 2002
 * @version   $Date: 2003/02/10 22:52:01 $
 */
public class IProblemManagerUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IProblemManagerUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IProblemManagerUTestI( String name, ImplFactory f )
    {
        super( name, IProblemManager.class, f );
    }

    
    public IProblemManager createIProblemManager()
    {
        return (IProblemManager)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testGetIssueIDs1()
            throws ProblemManagerException
    {
        IProblemManager pm = createIProblemManager();
        String[] ids = pm.getIssueIDs();
        assertNotNull(
            "ID list is null.",
            ids );
        for (int i = 0; i < ids.length; ++i)
        {
            assertNotNull(
                "ID index "+i+" is null.",
                ids[i] );
            assertTrue(
                "ID index "+i+" is empty.",
                ids[i].trim().length() > 0 );
        }
    }
    
    
    public void testGetIssueByID1()
            throws ProblemManagerException
    {
        IProblemManager pm = createIProblemManager();
        String[] ids = pm.getIssueIDs();
        for (int i = 0; i < ids.length; ++i)
        {
            IIssue issue = pm.getIssueByID( ids[i] );
            assertNotNull(
                "Issue id "+ids[i]+" is null.",
                issue );
        }
    }
    
    
    public void testGetProblemManagerInfo()
    {
        IProblemManager pm = createIProblemManager();
        IProblemManagerInfo pmi = pm.getProblemManagerInfo();
        assertNotNull(
            "Null info.",
            pmi );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

