/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-popup.h"

#include "mn-popup-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "src/mn-popup.gob"

#include <glib/gi18n.h>
#include "mn-conf.h"
#include "mn-shell.h"
#include "mn-util.h"

#line 33 "mn-popup.c"
/* self casting macros */
#define SELF(x) MN_POPUP(x)
#define SELF_CONST(x) MN_POPUP_CONST(x)
#define IS_SELF(x) MN_IS_POPUP(x)
#define TYPE_SELF MN_TYPE_POPUP
#define SELF_CLASS(x) MN_POPUP_CLASS(x)

#define SELF_GET_CLASS(x) MN_POPUP_GET_CLASS(x)

/* self typedefs */
typedef MNPopup Self;
typedef MNPopupClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-popup.gob"
static void mn_popup_init (MNPopup * o);
#line 52 "mn-popup.c"
#line 0 "src/mn-popup.gob"
static void mn_popup_class_init (MNPopupClass * c);
#line 55 "mn-popup.c"
#line 40 "src/mn-popup.gob"
static void mn_popup_constructor (MNPopup * self);
#line 58 "mn-popup.c"
#line 66 "src/mn-popup.gob"
static void mn_popup_add_actions (MNPopup * self);
#line 61 "mn-popup.c"
#line 102 "src/mn-popup.gob"
static void mn_popup_action_cb (NotifyNotification * notification, char * id, gpointer user_data);
#line 64 "mn-popup.c"
#line 115 "src/mn-popup.gob"
static void mn_popup_action_done_cb (MNMessageAction * action, GError * err, gpointer data);
#line 67 "mn-popup.c"
#line 122 "src/mn-popup.gob"
static void mn_popup_closed_h (NotifyNotification * notification, gpointer user_data);
#line 70 "mn-popup.c"
#line 129 "src/mn-popup.gob"
static void mn_popup_append_row (GString * body, const char * name, const char * value);
#line 73 "mn-popup.c"
#line 146 "src/mn-popup.gob"
static int mn_popup_get_conf_timeout (void);
#line 76 "mn-popup.c"

enum {
	PROP_0,
	PROP_MESSAGE
};

/* pointer to the class of our parent */
static NotifyNotificationClass *parent_class = NULL;

/* Short form macros */
#define self_add_actions mn_popup_add_actions
#define self_action_cb mn_popup_action_cb
#define self_action_done_cb mn_popup_action_done_cb
#define self_closed_h mn_popup_closed_h
#define self_append_row mn_popup_append_row
#define self_get_conf_timeout mn_popup_get_conf_timeout
#define self_show mn_popup_show
#define self_close mn_popup_close
#define self_new mn_popup_new
GType
mn_popup_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPopupClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_popup_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPopup),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_popup_init,
			NULL
		};

		type = g_type_register_static (NOTIFY_TYPE_NOTIFICATION, "MNPopup", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPopup *)g_object_new(mn_popup_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPopup * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPopup *
GET_NEW_VARG (const char *first, ...)
{
	MNPopup *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPopup *)g_object_new_valist (mn_popup_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static GObject *
___constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
#define __GOB_FUNCTION__ "MN:Popup::constructor"
	GObject *obj_self;
	MNPopup *self;
	obj_self = G_OBJECT_CLASS (parent_class)->constructor (type, n_construct_properties, construct_properties);
	self = MN_POPUP (obj_self);
#line 40 "src/mn-popup.gob"
	mn_popup_constructor (self);
#line 149 "mn-popup.c"
	return obj_self;
}
#undef __GOB_FUNCTION__


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Popup::dispose"
	MNPopup *self G_GNUC_UNUSED = MN_POPUP (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 34 "src/mn-popup.gob"
	if(self->_priv->message) { g_object_unref ((gpointer) self->_priv->message); self->_priv->message = NULL; }
#line 164 "mn-popup.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Popup::finalize"
	MNPopup *self G_GNUC_UNUSED = MN_POPUP (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
mn_popup_init (MNPopup * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Popup::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_POPUP,MNPopupPrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_popup_class_init (MNPopupClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Popup::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNPopupPrivate));

	parent_class = g_type_class_ref (NOTIFY_TYPE_NOTIFICATION);

	g_object_class->constructor = ___constructor;
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_object
		("message" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_MESSAGE /* object_type */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Popup::set_property"
{
	MNPopup *self G_GNUC_UNUSED;

	self = MN_POPUP (object);

	switch (property_id) {
	case PROP_MESSAGE:
		{
#line 35 "src/mn-popup.gob"
{ GObject *___old = (GObject *)self->_priv->message; self->_priv->message = (MNMessage *)g_value_dup_object (VAL); if (___old != NULL) { g_object_unref (G_OBJECT (___old)); } }
#line 234 "mn-popup.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Popup::get_property"
{
	MNPopup *self G_GNUC_UNUSED;

	self = MN_POPUP (object);

	switch (property_id) {
	case PROP_MESSAGE:
		{
#line 35 "src/mn-popup.gob"
g_value_set_object (VAL, (gpointer)self->_priv->message);
#line 265 "mn-popup.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 40 "src/mn-popup.gob"
static void 
mn_popup_constructor (MNPopup * self)
{
#line 286 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::constructor"
{
#line 41 "src/mn-popup.gob"
	
    GString *body;

    body = g_string_new(NULL);
    self_append_row(body, _("Mailbox:"), selfp->message->mailbox->runtime_name);
    self_append_row(body, _("From:"), selfp->message->from);
    self_append_row(body, _("Subject:"), selfp->message->subject);

    g_object_set(self,
		 "body", body->str,
		 "icon-name", "stock_mail",
		 NULL);

    if (mn_conf_get_enum_value(MN_TYPE_POPUP_POSITION, MN_CONF_POPUPS_POSITION) == MN_POPUP_POSITION_ATTACHED)
      g_object_set(self, "attach-widget", mn_shell->icon, NULL);

    g_string_free(body, TRUE);

    self_add_actions(self);

    notify_notification_set_timeout(NOTIFY_NOTIFICATION(self), self_get_conf_timeout());

    g_signal_connect(self, "closed", G_CALLBACK(self_closed_h), NULL);
  }}
#line 314 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 66 "src/mn-popup.gob"
static void 
mn_popup_add_actions (MNPopup * self)
{
#line 321 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::add_actions"
#line 66 "src/mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 66 "src/mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 327 "mn-popup.c"
{
#line 68 "src/mn-popup.gob"
	
    GSList *actions;
    GSList *l;

    /*
     * Note that notification-daemon currently assigns icons to
     * actions by prepending "stock_" to the action ID.
     */

    actions = mn_conf_get_string_list(MN_CONF_POPUPS_ACTIONS);

    MN_LIST_FOREACH(l, actions)
      {
	char *name = l->data;
	MNMessageAction *action;

	action = mn_message_get_action(name);
	if (action)
	  {
	    if (mn_message_can_perform_action(selfp->message, action))
	      notify_notification_add_action(NOTIFY_NOTIFICATION(self),
					     action->icon,
					     _(action->label),
					     self_action_cb,
					     action,
					     NULL);
	  }
	else
	  g_warning(_("configuration key %s: there is no action named \"%s\""), MN_CONF_POPUPS_ACTIONS, name);
      }

    mn_g_slist_free_deep(actions);
  }}
#line 363 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 102 "src/mn-popup.gob"
static void 
mn_popup_action_cb (NotifyNotification * notification, char * id, gpointer user_data)
{
#line 370 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::action_cb"
{
#line 104 "src/mn-popup.gob"
	
    Self *self = SELF(notification);
    MNMessageAction *action = user_data;

    GDK_THREADS_ENTER();

    mn_message_perform_action(selfp->message, action, self_action_done_cb, self);

    GDK_THREADS_LEAVE();
  }}
#line 384 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 115 "src/mn-popup.gob"
static void 
mn_popup_action_done_cb (MNMessageAction * action, GError * err, gpointer data)
{
#line 391 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::action_done_cb"
{
#line 117 "src/mn-popup.gob"
	
    if (err && ! g_error_matches(err, MN_MESSAGE_ACTION_ERROR, MN_MESSAGE_ACTION_ERROR_CANCELLED))
      mn_show_error_dialog(NULL, _(action->error_message), "%s", err->message);
  }}
#line 399 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 122 "src/mn-popup.gob"
static void 
mn_popup_closed_h (NotifyNotification * notification, gpointer user_data)
{
#line 406 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::closed_h"
{
#line 124 "src/mn-popup.gob"
	
    Self *self = SELF(notification);
    self->visible = FALSE;
  }}
#line 414 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 129 "src/mn-popup.gob"
static void 
mn_popup_append_row (GString * body, const char * name, const char * value)
{
#line 421 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::append_row"
#line 129 "src/mn-popup.gob"
	g_return_if_fail (body != NULL);
#line 129 "src/mn-popup.gob"
	g_return_if_fail (name != NULL);
#line 129 "src/mn-popup.gob"
	g_return_if_fail (value != NULL);
#line 429 "mn-popup.c"
{
#line 133 "src/mn-popup.gob"
	
      char *escaped;

      if (*body->str)
	g_string_append_c(body, '\n');

      g_string_append_printf(body, "<span weight=\"bold\">%s</span>", name);

      escaped = g_markup_escape_text(value, -1);
      g_string_append_printf(body, " %s", escaped);
      g_free(escaped);
    }}
#line 444 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 146 "src/mn-popup.gob"
static int 
mn_popup_get_conf_timeout (void)
{
#line 451 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::get_conf_timeout"
{
#line 148 "src/mn-popup.gob"
	
    switch (mn_conf_get_enum_value(MN_TYPE_EXPIRATION_ENABLED, MN_CONF_POPUPS_EXPIRATION_ENABLED))
      {
      case MN_EXPIRATION_ENABLED_DEFAULT:
	return NOTIFY_EXPIRES_DEFAULT;

      case MN_EXPIRATION_ENABLED_FALSE:
	return NOTIFY_EXPIRES_NEVER;

      case MN_EXPIRATION_ENABLED_TRUE:
	return mn_conf_get_int(MN_CONF_POPUPS_EXPIRATION_DELAY) * 1000;

      default:
	g_assert_not_reached();
	return 0;
      }
  }}
#line 472 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 166 "src/mn-popup.gob"
void 
mn_popup_show (MNPopup * self)
{
#line 479 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::show"
#line 166 "src/mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 166 "src/mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 485 "mn-popup.c"
{
#line 168 "src/mn-popup.gob"
	
    GError *err = NULL;

    if (self->visible)
      return;

    if (! notify_notification_show(NOTIFY_NOTIFICATION(self), &err))
      {
	g_warning(_("unable to show popup: %s"), err->message);
	g_error_free(err);
      }

    self->visible = TRUE;
    g_get_current_time(&self->show_timestamp);
  }}
#line 503 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 184 "src/mn-popup.gob"
void 
mn_popup_close (MNPopup * self)
{
#line 510 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::close"
#line 184 "src/mn-popup.gob"
	g_return_if_fail (self != NULL);
#line 184 "src/mn-popup.gob"
	g_return_if_fail (MN_IS_POPUP (self));
#line 516 "mn-popup.c"
{
#line 186 "src/mn-popup.gob"
	
    GError *err = NULL;

    if (! self->visible)
      return;

    if (! notify_notification_close(NOTIFY_NOTIFICATION(self), &err))
      {
	g_warning(_("unable to close popup: %s"), err->message);
	g_error_free(err);
      }
  }}
#line 531 "mn-popup.c"
#undef __GOB_FUNCTION__

#line 199 "src/mn-popup.gob"
MNPopup * 
mn_popup_new (MNMessage * message)
{
#line 538 "mn-popup.c"
#define __GOB_FUNCTION__ "MN:Popup::new"
#line 199 "src/mn-popup.gob"
	g_return_val_if_fail (message != NULL, (MNPopup * )0);
#line 199 "src/mn-popup.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (message), (MNPopup * )0);
#line 544 "mn-popup.c"
{
#line 201 "src/mn-popup.gob"
	
    /* we set the summary here because libnotify requires it */

    /* translators: header capitalization */
    return GET_NEW_VARG("summary", _("New Message"),
			MN_POPUP_PROP_MESSAGE(message),
			NULL);
  }}
#line 555 "mn-popup.c"
#undef __GOB_FUNCTION__
