/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2019 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QMainWindow>


/////////////////////// pappsomspp includes
#include <pappsomspp/widget/plotwidget/ticxicchromtraceplotwidget.h>


/////////////////////// Local includes
#include "ui_TicChromPreviewerMassDataLoadDlg.h"
#include "BasePlotCompositeWidget.hpp"
#include "../nongui/MassDataIntegrator.hpp"


namespace msxps
{
namespace minexpert
{

enum class IonMobilityUnit
{
  NONE,
  ONE_OVER_KO,
  SCAN,
};

struct MsRunDataPreviewInfo
{
  double retentionTimeBeginInSeconds;
  double retentionTimeEndInSeconds;
  IonMobilityUnit ionMobilityUnit;
  double ionMobilityScansBegin;
  double ionMobilityScansEnd;
  double ionMobilityOneOverKoBegin;
  double ionMobilityOneOverKoEnd;
  std::vector<std::size_t> msLevels;
  std::size_t ms1SpectraCount;
  std::size_t ms2SpectraCount;
  int mzBinCount;
  double mzBegin               = -1;
  double mzEnd                 = -1;
  int mzBinsMergeWindow        = -1;
  bool flattenIonMobilityScans = false;

  // Constructors
  MsRunDataPreviewInfo(){};
  MsRunDataPreviewInfo(const MsRunDataPreviewInfo &other)
  {
    retentionTimeBeginInSeconds = other.retentionTimeBeginInSeconds;
    retentionTimeEndInSeconds   = other.retentionTimeEndInSeconds;
    ionMobilityUnit             = other.ionMobilityUnit;
    ionMobilityScansBegin       = other.ionMobilityScansBegin;
    ionMobilityScansEnd         = other.ionMobilityScansEnd;
    ionMobilityOneOverKoBegin   = other.ionMobilityOneOverKoBegin;
    ionMobilityOneOverKoEnd     = other.ionMobilityOneOverKoEnd;
    msLevels                    = other.msLevels;
    ms1SpectraCount             = other.ms1SpectraCount;
    ms2SpectraCount             = other.ms2SpectraCount;
    mzBinCount                 = other.mzBinCount;
    mzBegin                     = other.mzBegin;
    mzEnd                       = other.mzEnd;
    mzBinsMergeWindow           = other.mzBinsMergeWindow;
    flattenIonMobilityScans     = other.flattenIonMobilityScans;
  }
};


class MsRunDataSet;
class ProgramWindow;
class DataPlottableNode;

class TicChromPreviewerMassDataLoadDlg : public QDialog
{
  Q_OBJECT

  public:
  // Construction/destruction
  TicChromPreviewerMassDataLoadDlg(
    QWidget *parent,
    const QString &title,
    const QString &settingsTitle,
    const QString &description,
    pappso::MsRunIdCstSPtr ms_run_id_csp,
    MsRunDataPreviewInfo &ms_run_data_preview_info);
  virtual ~TicChromPreviewerMassDataLoadDlg();

  virtual void writeSettings();
  virtual void readSettings();

  virtual bool initialize();
  virtual void closeEvent(QCloseEvent *event) override;

  ProgramWindow *getProgramWindow();

  virtual void show();

  void showWindow();


  public slots:

  signals:

  protected:
  pappso::TicXicChromTracePlotWidget *mp_plotWidget;

  bool m_areRtTimeUnitSeconds = true;

  Ui::TicChromPreviewerMassDataLoadDlg m_ui;

  ProgramWindow *mp_programWindow = nullptr;

  QString m_title;
  QString m_settingsTitle;
  QString m_description;

  pappso::MsRunIdCstSPtr m_msRunIdCstSPtr;

  MsRunDataPreviewInfo &m_msRunDataPreviewInfo;

  void convertTicChromatogramRetTimeUnit();

  void updateRtRangeSpinBoxes();

  bool validateData();
};


} // namespace minexpert

} // namespace msxps
