## Usage

```js
const strip = require('{%= name %}');
```

## API

{%= apidocs("index.js") %}

## Options

### removeRawNumbers

Remove "raw" trailing numbers that might not actually be increments. Use this with caution.

**Type**: `boolean`

**Default**: `undefined`

**Example**:

```js
console.log(strip('foo 1')); //=> 'foo 1'
console.log(strip('foo 1', { removeRawNumbers: true })); //=> 'foo'

console.log(strip('foo (1) 1')); //=> 'foo (1) 1'
console.log(strip('foo (1) 1', { removeRawNumbers: true })); //=> 'foo'

// This following example is not touched either way, 
// since it's definitely not an increment.
console.log(strip('foo [1]')); //=> 'foo [1]'
console.log(strip('foo [1]', { removeRawNumbers: true })); //=> 'foo [1]'
```

## Examples

### Windows path increments

All of the following would return `foo`

```js
console.log(strip('foo (1)'));  
console.log(strip('foo (2)'));  
console.log(strip('foo (22)')); 
```

All of the following would return `foo.txt`

```js
console.log(strip('foo (1).txt'));  
console.log(strip('foo (2).txt'));  
console.log(strip('foo (22).txt')); 
```

### MacOS path increments

All of the following would return `foo`

```js
console.log(strip('foo copy'));
console.log(strip('foo copy 1'));
console.log(strip('foo copy 2'));
console.log(strip('foo copy 21'));
console.log(strip('foo copy 219 copy 219'));
```

All of the following would return `foo.txt`

```js
console.log(strip('foo copy.txt'));
console.log(strip('foo copy 1.txt'));
console.log(strip('foo copy 2.txt'));
console.log(strip('foo copy 21.txt'));
console.log(strip('foo copy 219 copy 219.txt'));
```