if (typeof T === 'undefined') require('../setup');

T('sinh', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).sinh().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('0', 20, 4, '0');
  t('-0', 20, 4, '-0');
  t('Infinity', 40, 4, 'Infinity');
  t('-Infinity', 40, 4, '-Infinity');

  t('-0.01117212161', 7, 3, '-0.01117236');
  t('-0.01', 3, 6, '-0.01');
  t('0.4855939', 4, 0, '0.505');
  t('-0.35', 4, 6, '-0.3572');
  t('0.595', 3, 0, '0.631');
  t('-0.7', 10, 1, '-0.7585837018');
  t('0.477765550220420530146451989244265', 1, 5, '0.5');
  t('-0.6', 4, 6, '-0.6367');
  t('-0.7298937853748771062243', 8, 1, '-0.79645001');
  t('0.6654323353551357716363059061801908595169', 9, 2, '0.715640069');
  t('-0.822057582744136479779814788208915217619870720324021379213318423992919063068', 2, 6, '-0.92');
  t('0.930187069407449026594918410064', 8, 6, '1.0702517');
  t('-0.71551536', 7, 1, '-0.7781501');
  t('-0.02477', 9, 2, '-0.024772533');
  t('-0.5092804474897748330778251373356860713', 5, 3, '-0.53159');
  t('-0.88527349524064252', 7, 3, '-1.005523');
  t('0.92', 1, 5, '1');
  t('0.9', 9, 5, '1.02651673');
  t('0.01952', 4, 6, '0.01952');
  t('-0.7', 6, 5, '-0.758584');
  t('-0.9367', 1, 4, '-1');
  t('0.713075', 2, 1, '0.77');
  t('-0.80641', 4, 5, '-0.8967');
  t('0.1', 7, 3, '0.1001667');
  t('0.742', 4, 3, '0.8119');
  t('0.19164777', 8, 5, '0.19282309');
  t('-0.959128669199452184605687414702700501745933588051855', 5, 3, '-1.1131');
  t('-0.82', 3, 5, '-0.915');
  t('-0.54', 3, 4, '-0.567');
  t('0.6187', 9, 3, '0.658934392');
  t('0.5', 1, 1, '0.5');
  t('0.1713', 1, 6, '0.2');
  t('-0.09', 3, 2, '-0.0901');
  t('-0.149', 9, 4, '-0.149551937');
  t('-0.54', 1, 1, '-0.5');
  t('0.5286', 2, 5, '0.55');
  t('-0.2218560302782240024444484', 3, 1, '-0.223');
  t('0.4206503074024213359239066760263937373', 4, 3, '0.4331');
  t('-0.90343297229335446769185848339321460217', 7, 6, '-1.031443');
  t('0.29824', 3, 3, '0.302');
  t('0.970160998338313076097814326701945459022', 8, 2, '1.1296736');
  t('0.9', 1, 5, '1');
  t('0.66968', 7, 6, '0.7208699');
  t('-0.73978789', 4, 6, '-0.8091');
  t('0.4', 1, 5, '0.4');
  t('-0.33319', 2, 2, '-0.33');
  t('-0.05094763', 6, 6, '-0.0509697');
  t('0.147', 2, 4, '0.15');
  t('-0.7521', 3, 1, '-0.825');
  t('0.966', 2, 1, '1.1');
  t('-0.2', 6, 4, '-0.201336');
  t('0.3', 5, 6, '0.30452');
  t('0.2297417916367587719174729947877594919', 4, 2, '0.2318');
  t('0.7409761', 8, 4, '0.81066696');
  t('-0.09', 9, 6, '-0.0901215492');
  t('-0.18', 10, 4, '-0.1809735759');
  t('-0.5', 74, 0, '-0.5210953054937473616224256264114915591059289826114805279460935764528022509');
  t('0.949452626313209516617699142908712', 60, 1, '1.09867096195815727081614237630458180228025051136935234032153');
  t('-0.82630505', 54, 4, '-0.923598615474838199854541207197320474034631988093767029');
  t('-0.14360721351237246987568757034881684526233784917328314', 51, 6, '-0.144101325429405622590434840215545338787652919410578');
  t('-0.4733', 23, 1, '-0.49116986771004112197472');
  t('-0.5044771449885283269', 58, 3, '-0.5261490899404374562669581230733559491094381606214659786475');
  t('0.5292602', 35, 4, '0.55431766127533774367181438483674235');
  t('0.3540955931426128907807', 61, 2, '0.361541756843620905162708539502960691569195176490187925093063');
  t('-0.10396270844781004445623314451335288', 42, 5, '-0.104150085412880845209759850184027732716498');
  t('0.34005327', 75, 6, '0.346645013173896201527795410362292912629770127776147273389479491565524413729');
  t('-0.465', 56, 3, '-0.48193954184873018412767665045542782421613788403587256476');
  t('0.6', 31, 4, '0.6366535821482412711234543754651');
  t('-0.5481208052771', 80, 6, '-0.57598196281877562249156649817140676025943322140952007665313949431943795521753859');
  t('0.4658', 43, 2, '0.4828277558817488705330396156695883903876349');
  t('0.658924', 67, 0, '0.7076519258213409489258117150888493713909348882371351431016717177769');
  t('0.84095', 76, 4, '0.9436339889105945408359964397732399439736824767663826815978864604057978720873');
  t('0.1', 42, 1, '0.10016675001984402582372938352190502351492');
  t('-0.546469309180216992488477103741682161392', 53, 0, '-0.57407689286989186234869758011224724765162964238150871');
  t('0.952940960228', 79, 6, '1.103860008709590589328393540207693314047991810042822431557364905168130459211928');
  t('0.5412557', 49, 6, '0.5680730254090400844499466841744626100138640781665');
  t('-0.4', 48, 2, '-0.410752325802815508540210013844698104353150924363');
  t('0.40959', 40, 2, '0.4211388569626912767627807558369832974574');
  t('-0.2071333563131394184890351', 55, 5, '-0.2086176863728173404729808287424406991153510048007845957');
  t('-0.006158312564838233045293421864257772700745093081', 113, 5, '-0.0061583514903881113191917490082260881905532636435605944044826372766861550655521768577200191192576920019205813951089');
  t('-0.94735419679918088022811807376056681040587805226146', 33, 0, '-1.09555590192578368678418405664044');
  t('0.3858706779532718096507434549', 90, 4, '0.395517999377232409663582197928235951630498131157951753386415315480929149180554295455429916');
  t('-0.54290785843486103750513205980437253195531977198208721625688182147166538076323037457917540157093128639', 47, 6, '-0.56997393244891117340616510127151254831177604424');
  t('-0.557397920603136432530648049076469730271228686196969657', 23, 0, '-0.58671285120863734551043');
  t('-0.116426108886043214339286002636572559104915423316062689133928015970375', 86, 0, '-0.11668931394827265385287124886310892715353176113654298509501455004648909379387424934137');
  t('0.20004668', 65, 4, '0.20138361947662140883950941306502243833641683553233187922633602303');
  t('-0.72854338143449469754924045207742119688876235959260851289818192195120823675633348027917164866022227116150939180735340401518132565983221327345338239572304554973', 57, 0, '-0.794724373946660205913430120299005955752529862100864743743');
  t('0.7075348682409645', 33, 3, '0.768062858516298468179764221964258');
  t('0.9656450627407202186276140853108319189098662197785614356229', 112, 6, '1.122871917243193329250848114954520140832952763020717131988745064541821469254295854275194543068093878175092993757');
  t('-0.3074887163636747690696589824464611540801585', 75, 5, '-0.312357149174629557268287563048266380887783749410576774474545432310552964774');
  t('0.35414105198707877919833655237627933385061464419', 75, 3, '0.361590095862779887666259058403870675910577905319211259160227815980416737104');
  t('-0.22861250504316830507', 15, 4, '-0.230609070338079');
  t('0.3531311134837489181774304448792305788668900001541312879645273208393370689493465894263207269785178211563373399080451907494623164005742217451839584169072958609799133150259273', 104, 0, '0.36051634575023901465038196038262241500129988486533222911437937013660152976667815350655235742420924031229');
  t('0.04434967092552732411292905', 99, 2, '0.0443642108672289452509083305837598955470962269229557910757510910026528522969230426477915847556546583');
  t('-0.20001290733229792426683137634566153903', 21, 4, '-0.201349168898446405328');
});
