% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowWeightedMads.R
\name{rowWeightedMads}
\alias{rowWeightedMads}
\alias{rowWeightedMads,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowWeightedMads,ANY-method}
\alias{colWeightedMads}
\alias{colWeightedMads,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colWeightedMads,ANY-method}
\title{Calculates the weighted median absolute deviation for each row (column) of a
matrix-like object}
\usage{
rowWeightedMads(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE,
  constant = 1.4826, center = NULL, ...)

\S4method{rowWeightedMads}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL,
  rows = NULL, cols = NULL, na.rm = FALSE, constant = 1.4826,
  center = NULL, ..., useNames = NA)

\S4method{rowWeightedMads}{ANY}(x, w = NULL, rows = NULL, cols = NULL,
  na.rm = FALSE, constant = 1.4826, center = NULL, ...)

colWeightedMads(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE,
  constant = 1.4826, center = NULL, ..., useNames = NA)

\S4method{colWeightedMads}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL,
  rows = NULL, cols = NULL, na.rm = FALSE, constant = 1.4826,
  center = NULL, ..., useNames = NA)

\S4method{colWeightedMads}{ANY}(x, w = NULL, rows = NULL, cols = NULL,
  na.rm = FALSE, constant = 1.4826, center = NULL, ..., useNames = NA)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{constant}{A scale factor. See \code{stats::\link[stats]{mad}()} for
details.}

\item{center}{(optional) the center, defaults to the row means}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted  median absolute deviation for each row (column) of
a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowWeightedMads}
/ \code{matrixStats::colWeightedMads}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  w <- rnorm(n = 5, mean = 3)
  rowWeightedMads(mat, w = w[1:3])
  colWeightedMads(mat, w = w)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:weightedMad]{rowWeightedMads}()} and
\code{matrixStats::\link[matrixStats:weightedMad]{colWeightedMads}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link{rowMads} for the corresponding unweighted function.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
