% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aaClasses.R, R/methods-BFodds.R
\docType{class}
\name{BFodds-class}
\alias{*,BFodds,BFBayesFactor-method}
\alias{/,BFodds,BFodds-method}
\alias{/,numeric,BFodds-method}
\alias{BFodds-class}
\alias{[,BFodds,index,missing,missing-method}
\title{General S4 class for representing multiple odds model comparisons, all against the same model}
\usage{
\S4method{/}{numeric,BFodds}(e1, e2)

\S4method{/}{BFodds,BFodds}(e1, e2)

\S4method{*}{BFodds,BFBayesFactor}(e1, e2)

\S4method{[}{BFodds,index,missing,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{e1}{Numerator of the ratio}

\item{e2}{Denominator of the ratio}

\item{x}{BFodds object}

\item{i}{indices indicating elements to extract}

\item{j}{unused for BFodds objects}

\item{...}{further arguments passed to related methods}

\item{drop}{unused}
}
\description{
The \code{BFodds} class is a general S4 class for representing models model comparison via prior or posterior odds.
}
\details{
\code{BFodds} objects can be inverted by taking the reciprocal and can
   be divided by one another, provided both objects have the same denominator. In addition,
   the \code{t} (transpose) method can be used to invert odds objects.
  \describe{
  The \code{BFodds} class has the following slots defined:
   \item{numerator}{a list of models all inheriting \code{BFmodel}, each providing a single numerator}
   \item{denominator}{a single \code{BFmodel} object serving as the denominator for all model comparisons}
   \item{logodds}{a data frame containing information about the (log) prior odds between each numerator and the denominator}
   \item{bayesFactor}{a \code{BFBayesFactor} object (possibly) containing the evidence from the data.}
   \item{version}{character string giving the version and revision number of the package that the model was created in}
   }
}

