% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential.R
\name{req_perform_sequential}
\alias{req_perform_sequential}
\title{Perform multiple requests in sequence}
\usage{
req_perform_sequential(
  reqs,
  paths = NULL,
  on_error = c("stop", "return", "continue"),
  progress = TRUE
)
}
\arguments{
\item{reqs}{A list of \link{request}s.}

\item{paths}{An optional list of paths, if you want to download the request
bodies to disks. If supplied, must be the same length as \code{reqs}.}

\item{on_error}{What should happen if one of the requests fails?
\itemize{
\item \code{stop}, the default: stop iterating with an error.
\item \code{return}: stop iterating, returning all the successful responses
received so far, as well as an error object for the failed request.
\item \code{continue}: continue iterating, recording errors in the result.
}}

\item{progress}{Display a progress bar? Use \code{TRUE} to turn on a basic
progress bar, use a string to give it a name, or see \link{progress_bars} to
customise it in other ways.}
}
\value{
A list, the same length as \code{reqs}, containing \link{response}s and possibly
error objects, if \code{on_error} is \code{"return"} or \code{"continue"} and one of the
responses errors. If \code{on_error} is \code{"return"} and it errors on the ith
request, the ith element of the result will be an error object, and the
remaining elements will be \code{NULL}. If \code{on_error} is \code{"continue"}, it will
be a mix of requests and error objects.

Only httr2 errors are captured; see \code{\link[=req_error]{req_error()}} for more details.
}
\description{
Given a list of requests, this function performs each in turn, returning
a list of responses. It's slower than \code{\link[=req_perform_parallel]{req_perform_parallel()}} but
has fewer limitations.
}
\examples{
# One use of req_perform_sequential() is if the API allows you to request
# data for multiple objects, you want data for more objects than can fit
# in one request.
req <- request("https://api.restful-api.dev/objects")

# Imagine we have 50 ids:
ids <- sort(sample(100, 50))

# But the API only allows us to request 10 at time. So we first use split
# and some modulo arithmetic magic to generate chunks of length 10
chunks <- unname(split(ids, (seq_along(ids) - 1) \%/\% 10))

# Then we use lapply to generate one request for each chunk:
reqs <- chunks |> lapply(\(idx) req |> req_url_query(id = idx, .multi = "comma"))

# Then we can perform them all and get the results
\dontrun{
resps <- reqs |> req_perform_sequential()
resps_data(resps, \(resp) resp_body_json(resp))
}
}
