#' Chloroplast alignment
#'
#' Amino acid alignment of 15 genes of 19 different chloroplast.
#'
#'
#' @name chloroplast
#' @docType data
#' @keywords datasets
#' @examples
#'
#' data(chloroplast)
#' chloroplast
#'
NULL



#' Laurasiatherian data (AWCMEE)
#'
#' Laurasiatherian RNA sequence data
#'
#'
#' @name Laurasiatherian
#' @docType data
#' @source Data have been taken from the former repository of the Allan Wilson
#' Centre and were converted to R format by \email{klaus.schliep@gmail.com}.
#' @keywords datasets
#' @examples
#'
#' data(Laurasiatherian)
#' str(Laurasiatherian)
#'
NULL


#' @keywords internal
"_PACKAGE"


#' Internal phangorn Functions
#'
#' Internal \pkg{phangorn} functions.
#'
#' @name phangorn-internal
#' @aliases phangorn-internal threshStateC coords map_duplicates
#' @keywords internal
NULL

#' Yeast alignment (Rokas et al.)
#'
#' Alignment of 106 genes of 8 different species of yeast.
#'
#'
#' @name yeast
#' @docType data
#' @references Rokas, A., Williams, B. L., King, N., and Carroll, S. B. (2003)
#' Genome-scale approaches to resolving incongruence in molecular phylogenies.
#' \emph{Nature}, \bold{425}(6960): 798--804
#' @keywords datasets
#' @examples
#'
#' data(yeast)
#' str(yeast)
#'
NULL



