% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map-if-at.R
\name{map_if}
\alias{map_if}
\alias{map_at}
\title{Apply a function to each element of a vector conditionally}
\usage{
map_if(.x, .p, .f, ..., .else = NULL)

map_at(.x, .at, .f, ..., .progress = FALSE)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{.f}{A function, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. You must use \code{.x} to refer to the first
argument. Only recommended if you require backward compatibility with
older versions of R.
\item A string, integer, or list, e.g. \code{"idx"}, \code{1}, or \code{list("idx", 1)} which
are shorthand for \verb{\\(x) pluck(x, "idx")}, \verb{\\(x) pluck(x, 1)}, and
\verb{\\(x) pluck(x, "idx", 1)} respectively. Optionally supply \code{.default} to
set a default value if the indexed element is \code{NULL} or does not exist.
}}

\item{...}{Additional arguments passed on to the mapped function.

We now generally recommend against using \code{...} to pass additional
(constant) arguments to \code{.f}. Instead use a shorthand anonymous function:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Instead of
x |> map(f, 1, 2, collapse = ",")
# do:
x |> map(\\(x) f(x, 1, 2, collapse = ","))
}\if{html}{\out{</div>}}

This makes it easier to understand which arguments belong to which
function and will tend to yield better error messages.}

\item{.else}{A function applied to elements of \code{.x} for which \code{.p}
returns \code{FALSE}.}

\item{.at}{A logical, integer, or character vector giving the elements
to select. Alternatively, a function that takes a vector of names,
and returns a logical, integer, or character vector of elements to select.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: if the tidyselect package is
installed, you can use \code{vars()} and tidyselect helpers to select
elements.}

\item{.progress}{Whether to show a progress bar. Use \code{TRUE} to turn on
a basic progress bar, use a string to give it a name, or see
\link{progress_bars} for more details.}
}
\description{
The functions \code{map_if()} and \code{map_at()} take \code{.x} as input, apply
the function \code{.f} to some of the elements of \code{.x}, and return a
list of the same length as the input.
\itemize{
\item \code{map_if()} takes a predicate function \code{.p} as input to determine
which elements of \code{.x} are transformed with \code{.f}.
\item \code{map_at()} takes a vector of names or positions \code{.at} to specify
which elements of \code{.x} are transformed with \code{.f}.
}
}
\examples{
# Use a predicate function to decide whether to map a function:
iris |> map_if(is.factor, as.character) |> str()

# Specify an alternative with the `.else` argument:
iris |> map_if(is.factor, as.character, .else = as.integer) |> str()

# Use numeric vector of positions select elements to change:
iris |> map_at(c(4, 5), is.numeric) |> str()

# Use vector of names to specify which elements to change:
iris |> map_at("Species", toupper) |> str()
}
\seealso{
Other map variants: 
\code{\link{imap}()},
\code{\link{lmap}()},
\code{\link{map2}()},
\code{\link{map_depth}()},
\code{\link{map}()},
\code{\link{modify}()},
\code{\link{pmap}()}
}
\concept{map variants}
