% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probeInteraction.R
\name{probe2WayRC}
\alias{probe2WayRC}
\title{Probing two-way interaction on the residual-centered latent interaction}
\usage{
probe2WayRC(fit, nameX, nameY, modVar, valProbe, group = 1L,
  omit.imps = c("no.conv", "no.se"))
}
\arguments{
\item{fit}{A fitted \code{\linkS4class{lavaan}} or
\code{\linkS4class{lavaan.mi}} object with a latent 2-way interaction.}

\item{nameX}{\code{character} vector of all 3 factor names used as the
predictors. The lower-order factors must be listed first, and the final
name must be the latent interaction factor.}

\item{nameY}{The name of factor that is used as the dependent variable.}

\item{modVar}{The name of factor that is used as a moderator. The effect of
the other independent factor will be probed at each value of the
moderator variable listed in \code{valProbe}.}

\item{valProbe}{The values of the moderator that will be used to probe the
effect of the focal predictor.}

\item{group}{In multigroup models, the label of the group for which the
results will be returned. Must correspond to one of
\code{\link[lavaan]{lavInspect}(fit, "group.label")}, or an integer
corresponding to which of those group labels.}

\item{omit.imps}{\code{character} vector specifying criteria for omitting
imputations from pooled results. Ignored unless \code{fit} is of
class \code{\linkS4class{lavaan.mi}}. Can include any of
\code{c("no.conv", "no.se", "no.npd")}, the first 2 of which are the
default setting, which excludes any imputations that did not
converge or for which standard errors could not be computed.  The
last option (\code{"no.npd"}) would exclude any imputations which
yielded a nonpositive definite covariance matrix for observed or
latent variables, which would include any "improper solutions" such
as Heywood cases.  NPD solutions are not excluded by default because
they are likely to occur due to sampling error, especially in small
samples.  However, gross model misspecification could also cause
NPD solutions, users can compare pooled results with and without
this setting as a sensitivity analysis to see whether some
imputations warrant further investigation.}
}
\value{
A list with two elements:
\enumerate{
 \item \code{SimpleIntercept}: The intercepts given each value of the
  moderator. This element will be \code{NULL} unless the factor intercept is
  estimated (e.g., not fixed at 0).
 \item \code{SimpleSlope}: The slopes given each value of the moderator.
}
In each element, the first column represents the values of the moderators
specified in the \code{valProbe} argument. The second column is the simple
intercept or simple slope. The third column is the standard error of the
simple intercept or simple slope. The fourth column is the Wald (\emph{z})
statistic. The fifth column is the \emph{p} value testing whether the simple
intercepts or slopes are different from 0.
}
\description{
Probing interaction for simple intercept and simple slope for the
residual-centered latent two-way interaction (Geldhof et al., 2013)
}
\details{
Before using this function, researchers need to make the products of the
indicators between the first-order factors and residualize the products by
the original indicators (Lance, 1988; Little, Bovaird, & Widaman, 2006). The
process can be automated by the \code{\link{indProd}} function. Note that
the indicator products can be made for all possible combination or
matched-pair approach (Marsh et al., 2004). Next, the hypothesized model
with the regression with latent interaction will be used to fit all original
indicators and the product terms. To use this function the model must be fit
with a mean structure. See the example for how to fit the product term
below. Once the lavaan result is obtained, this function will be used to
probe the interaction.

The probing process on residual-centered latent interaction is based on
transforming the residual-centered result into the no-centered result. See
Geldhof et al. (2013) for further details. Note that this approach based on
a strong assumption that the first-order latent variables are normally
distributed. The probing process is applied after the no-centered result
(parameter estimates and their covariance matrix among parameter estimates)
has been computed. See the \code{\link{probe2WayMC}} for further details.
}
\examples{

dat2wayRC <- orthogonalize(dat2way, 1:3, 4:6)

model1 <- "
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
f12 =~ x1.x4 + x2.x5 + x3.x6
f3 =~ x7 + x8 + x9
f3 ~ f1 + f2 + f12
f12 ~~ 0*f1 + 0*f2
x1 + x4 + x1.x4 + x7 ~ 0*1 # identify latent means
f1 + f2 + f12 + f3 ~ NA*1
"

fitRC2way <- sem(model1, data = dat2wayRC, meanstructure = TRUE)
summary(fitRC2way)

probe2WayRC(fitRC2way, nameX = c("f1", "f2", "f12"), nameY = "f3",
            modVar = "f2", valProbe = c(-1, 0, 1))


## can probe multigroup models, one group at a time
dat2wayRC$g <- 1:2

model2 <- "
f1  =~ x1 + x2 + x3
f2  =~ x4 + x5 + x6
f12 =~ x1.x4 + x2.x5 + x3.x6
f3  =~ x7 + x8 + x9
f3 ~ c(b1.g1, b1.g2)*f1 + c(b2.g1, b2.g2)*f2 + c(b12.g1, b12.g2)*f12
f12 ~~ 0*f1 + 0*f2
x1 + x4 + x1.x4 + x7 ~ 0*1 # identify latent means
f1 + f2 + f12 ~ NA*1
f3 ~ NA*1 + c(b0.g1, b0.g2)*1
"
fit2 <- sem(model2, data = dat2wayRC, group = "g")
probe2WayRC(fit2, nameX = c("f1", "f2", "f12"), nameY = "f3",
            modVar = "f2", valProbe = c(-1, 0, 1)) # group = 1 by default
probe2WayRC(fit2, nameX = c("f1", "f2", "f12"), nameY = "f3",
            modVar = "f2", valProbe = c(-1, 0, 1), group = 2)

}
\references{
Lance, C. E. (1988). Residual centering, exploratory and confirmatory
moderator analysis, and decomposition of effects in path models containing
interactions. \emph{Applied Psychological Measurement, 12}(2), 163--175.
\doi{10.1177/014662168801200205}

Little, T. D., Bovaird, J. A., & Widaman, K. F. (2006). On the merits of
orthogonalizing powered and product terms: Implications for modeling
interactions. \emph{Structural Equation Modeling, 13}(4), 497--519.
\doi{10.1207/s15328007sem1304_1}

Marsh, H. W., Wen, Z., & Hau, K. T. (2004). Structural equation models of
latent interactions: Evaluation of alternative estimation strategies and
indicator construction. \emph{Psychological Methods, 9}(3), 275--300.
\doi{10.1037/1082-989X.9.3.275}

Geldhof, G. J., Pornprasertmanit, S., Schoemann, A. M., & Little, T. D.
(2013). Orthogonalizing through residual centering: Extended applications
and caveats. \emph{Educational and Psychological Measurement, 73}(1), 27--46.
\doi{10.1177/0013164412445473}
}
\seealso{
\itemize{
 \item \code{\link{indProd}} For creating the indicator products with no
  centering, mean centering, double-mean centering, or residual centering.
 \item \code{\link{probe2WayMC}} For probing the two-way latent interaction
  when the results are obtained from mean-centering, or double-mean centering
 \item \code{\link{probe3WayMC}} For probing the three-way latent interaction
  when the results are obtained from mean-centering, or double-mean centering
 \item \code{\link{probe3WayRC}} For probing the two-way latent interaction
  when the results are obtained from residual-centering approach.
 \item \code{\link{plotProbe}} Plot the simple intercepts and slopes of the
  latent interaction.
}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})

Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})
}
