#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 


int check_CrouzeixRaviart() {

    initSyFi(2); 

    cout <<"2D ----------------------------"<<endl; 
    ReferenceTriangle triangle; 
    CrouzeixRaviart fe; 
    fe.set_polygon(triangle); 
    fe.compute_basis_functions(); 

    usage(fe); 

    Dof dof; 
    std::map<std::pair<unsigned int,unsigned int>, ex> A;
    compute_Poisson_element_matrix(fe, dof, A);  
    print(A); 


    initSyFi(3); 

    cout <<"3D ----------------------------"<<endl; 
    ReferenceTetrahedron tetrahedron; 
    CrouzeixRaviart fe2; 
    fe2.set_polygon(tetrahedron); 
    fe2.compute_basis_functions(); 
    usage(fe2); 

    Dof dof2; 
    std::map<std::pair<unsigned int,unsigned int>, ex> A2;
    compute_Poisson_element_matrix(fe2, dof2, A2);  
    print(A); 


    // regression test 

    archive ar; 
    for (unsigned int i=0; i<fe.nbf(); i++) {
	    ar.archive_ex(fe.N(i), istr("N",i).c_str()); 
    }

    std::map<std::pair<unsigned int,unsigned int>, ex>::iterator iter; 
    for (iter = A.begin(); iter != A.end() ; iter++) {
	    ar.archive_ex((*iter).second, istr("A", (*iter).first.first, (*iter).first.second).c_str());
    }

    for (unsigned int i=0; i<fe2.nbf(); i++) {
	    ar.archive_ex(fe2.N(i), istr("N2_",i).c_str()); 
    }

    for (iter = A2.begin(); iter != A2.end() ; iter++) {
	    ar.archive_ex((*iter).second, istr("A2_", (*iter).first.first, (*iter).first.second).c_str());
    }



    ofstream vfile("crouzeixraviart_ex.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("crouzeixraviart_ex.gar.v", "crouzeixraviart_ex.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 
}


int main() {
    return check_CrouzeixRaviart(); 
}



