/*
 * Copyright (C) 2003-2015 FreeIPMI Core Team
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef IPMI_SENSOR_AND_EVENT_CODE_TABLES_OEM_INTEL_NODE_MANAGER_SPEC_H
#define IPMI_SENSOR_AND_EVENT_CODE_TABLES_OEM_INTEL_NODE_MANAGER_SPEC_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Intel Node Manager
 *
 * For Intel Chips, not just Intel Motherboards.  Confirmed for:
 *
 * Intel S5500WB/Penguin Computing Relion 700
 * Intel S2600JF/Appro 512X
 * Intel S2600WP
 * Intel S2600KP
 * Intel S2600WT2
 * Intel S2600WTT
 * Intel S2600GZ
 * Inventec 5441/Dell Xanadu II
 * Inventec 5442/Dell Xanadu III
 * Quanta S99Q/Dell FS12-TY
 * Quanta QSSC-S4R/Appro GB812X-CN
 */

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_OEM_INTEL_NODE_MANAGER_EXCEPTION_EVENT
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_EXCEPTION_EVENT_EVENT_DATA1_NODE_MANAGER_POLICY_EVENT_BITMASK 0x08
#define IPMI_OEM_INTEL_NODE_MANAGER_EXCEPTION_EVENT_EVENT_DATA1_NODE_MANAGER_POLICY_EVENT_SHIFT   3

#define IPMI_OEM_INTEL_NODE_MANAGER_EXCEPTION_EVENT_EVENT_DATA1_NODE_MANAGER_POLICY_EVENT_POLICY_CORRECTION_TIME_EXCEEDED 0x1

#define IPMI_OEM_INTEL_NODE_MANAGER_EXCEPTION_EVENT_EVENT_DATA2_DOMAIN_ID_BITMASK 0x0F
#define IPMI_OEM_INTEL_NODE_MANAGER_EXCEPTION_EVENT_EVENT_DATA2_DOMAIN_ID_SHIFT   0

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_EVENT_DATA1_POLICY_INTERFACE_CAPABILITY_BITMASK 0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_EVENT_DATA1_POLICY_INTERFACE_CAPABILITY_SHIFT   0

#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_EVENT_DATA1_MONITORING_CAPABILITY_BITMASK       0x02
#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_EVENT_DATA1_MONITORING_CAPABILITY_SHIFT         1

#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_EVENT_DATA1_POWER_LIMITING_CAPABILITY_BITMASK   0x04
#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_EVENT_DATA1_POWER_LIMITING_CAPABILITY_SHIFT     2

#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_NOT_AVAILABLE 0
#define IPMI_OEM_INTEL_NODE_MANAGER_OPERATIONAL_CAPABILITIES_CHANGE_EVENT_AVAILABLE     1

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA1_THRESHOLD_NUMBER_BITMASK 0x03
#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA1_THRESHOLD_NUMBER_SHIFT   0

#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA1_NODE_MANAGER_POLICY_EVENT_BITMASK 0x08
#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA1_NODE_MANAGER_POLICY_EVENT_SHIFT   3

#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA1_NODE_MANAGER_POLICY_EVENT_THRESHOLD_EXCEEDED              0x0
#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA1_NODE_MANAGER_POLICY_EVENT_POLICY_CORRECTION_TIME_EXCEEDED 0x1

#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA2_DOMAIN_ID_BITMASK 0x0F
#define IPMI_OEM_INTEL_NODE_MANAGER_ALERT_THRESHOLD_EXCEEDED_EVENT_DATA2_DOMAIN_ID_SHIFT   0

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_OEM_INTEL_ME_FIRMWARE_HEALTH_EVENT
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_FIRMWARE_STATUS                 0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_SERVER_PLATFORM_SERVICES_FIRMWARE_HEALTH_EVENT_FIRMWARE_STATUS IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_FIRMWARE_STATUS

/* Recovery GPIO forced. Recovery Image loaded due to MGPIO pin
 * asserted.  Pin number is configurable in factory presets, Default
 * recovery pin is MGPIO1.  Repair action: Deassert MGPIO1 and reset
 * the Intel ME
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_RECOVERY_GPIO_FORCED                   0x00
/* Image execution failed. Recovery Image or backup operational image
 * loaded because operational image is corrupted. This may be caused
 * by Flash device corruption or failed upgrade procedure.  Repair
 * action: Either the flash device must be replaced (if error is
 * persistent) or the upgrade procedure must be started again.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_IMAGE_EXECUTION_FAILED                 0x01
/* Flash erase error. Error during Flash erasure procedure probably
 * due to flash part corruption.  Repair action: The flash device
 * must be replaced.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FLASH_ERASE_ERROR                      0x02
/* Flash state information.  Repair action: Check extended info byte
 * in Event Data 3 (byte 7) whether wearout protection is causing this
 * event.  If so, wait until wearout protection expires; otherwise
 * probably the flash device must be replaced (if error is
 * persistent).
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FLASH_STATE_INFORMATION                0x03
/* Internal error. Error during firmware execution - if Event Data 3
 * (byte 7) contains 0 then FW Watchdog Timeout; otherwise please
 * contact Intel representative for support.  Repair action:
 * Operational image shall be updated to other version or hardware
 * board repair is needed (if error is persistent).
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_INTERNAL_ERROR                         0x04
/* BMC did not respond to cold reset request and Intel ME rebooted
 * the platform.  Repair action: Verify the Intel NM configuration.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_BMC_COLD_RESET_ERROR                   0x05
/* Direct flash update requested by the BIOS.  Intel ME firmware
 * will switch to recovery mode to perform full update from BIOS.
 * Repair action: This is transient state.  Intel ME firmware should
 * return to operational mode after successful image update
 * performed b the BIOS.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_DIRECT_FLASH_UPDATE                    0x06
/* Manufacturing error.  Wrong manufacturing configuration detected
 * by Intel ME firmware Repair action: The flash device must be
 * replaced (if error is persistent).
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_MANUFACTURING_ERROR                    0x07
/* Persistent storage integrity error.  Flash file system error
 * detected.  Repair action.  If error is persistent, restore
 * factory presets using "Force ME Recovery" IPMI command or by
 * doing AC power cycle with Recovery jumper asserted.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_PERSISTENT_STORAGE_INTEGRITY_ERROR     0x08
/* Firmware exception.  Repair action: Restore factory presets using
 * "Force ME Recovery" IPMI command or by doing AC power cycle with
 * Recovery jumper asserted.  If this does not clear the issue,
 * reflash the SPI flash.  If the issue persists, provide the
 * content of Event Data 3 to Intel support team for interpretation.
 * (Event Data 3 codes are not documented because they only provide
 * clues that must be interpreted individually.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FIRMWARE_EXCEPTION                     0x09
/* Flash Wear-Out Protection Warning.  Warning threshold for number
 * of flash operations has been exceeded.  Repair action: No immediate
 * repair action needed.  This i sjust a warning event.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FLASH_WEAR_OUT_PROTECTION_WARNING      0x0A
/* PECI over DMI interface error.  This is a notification that PECI
 * over DMI interface failure was detected and it is not functional
 * any more.  It may indicatethe situation when PECI over DMI was not
 * configured by BIOS or a defect which may require a CPU Host reset
 * to recover from.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_PECI_OVER_DMI_INTERFACE_ERROR          0x0D
/* MCTP interface error.  This is a notification that MCTP interface
 * failure was detected and it is not functional any more.  It may
 * indicate the situation when MCTP was not configured by BIOS or a
 * defect which may need a Host reset to recover from.  Repair action:
 * Recovery via CPU Host reset or platform reset.
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_MCTP_INTERFACE_ERROR                   0x0E
/* Auto-configuration finished.  Operational image finished power
 * source auto-configuration.  Repair action: Auto-configuration could
 * be enforced by restore to factory defaults
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_AUTO_CONFIGURATION_FINISHED            0x0F

/* Legacy macros, changed b/c of new names in Intel NM 2.0 specification */
#define IPMI_OEM_INTEL_NODE_MANAGER_SERVER_PLATFORM_SERVICES_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FORCED_GPIO_RECOVER    IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_RECOVERY_GPIO_FORCED
#define IPMI_OEM_INTEL_NODE_MANAGER_SERVER_PLATFORM_SERVICES_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_IMAGE_EXECUTION_FAILED IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_IMAGE_EXECUTION_FAILED
#define IPMI_OEM_INTEL_NODE_MANAGER_SERVER_PLATFORM_SERVICES_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FLASH_ERASE_ERROR      IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FLASH_ERASE_ERROR
#define IPMI_OEM_INTEL_NODE_MANAGER_SERVER_PLATFORM_SERVICES_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FLASH_CORRUPTED        IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_FLASH_STATE_INFORMATION
#define IPMI_OEM_INTEL_NODE_MANAGER_SERVER_PLATFORM_SERVICES_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_INTERNAL_ERROR         IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA2_INTERNAL_ERROR

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_FLASH_STATE_INFORMATION_IMAGE_CORRUPTED           0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_FLASH_STATE_INFORMATION_FLASH_ERASE_LIMIT_REACHED 0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_FLASH_STATE_INFORMATION_FLASH_WRITE_LIMIT_REACHED 0x02
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_FLASH_STATE_INFORMATION_WRITING_TO_FLASH_ENABLED  0x03

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_INTERNAL_ERROR_FW_WATCHDOG_TIMEOUT                0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_INTERNAL_ERROR_LOADER_MANIFEST_VALIDATION_FAILURE 0x1D
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_INTERNAL_ERROR_UNKNOWN_POWER_MANAGEMENT_EVENT     0x37
/* Spec says "None graceful", assuming typo */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_INTERNAL_ERROR_NON_GRACEFUL_PMC_RESET_EVENT       0x45
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_INTERNAL_ERROR_FLASH_WEAROUT_PROTECTION           0x8E

#if 0
/* In Intel Node Manager 2.0 spec this was 0x04, but changed in 3.0 spec */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_INTEL_ME_FW_CONFIGURATION_BAD 0x04
#endif
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_GENERIC_ERROR                                                  0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_WRONG_OR_MISSING_VSCC_TABLE                                    0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_WRONG_SENSOR_SCANNING_PERIOD_IN_PIA                            0x02
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_WRONG_DEVICE_DEFINITION_IN_PIA                                 0x03
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_WRONG_SMART_CLST_CONFIGURATION                                 0x04
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_INTEL_ME_FW_CONFIGURATION_IS_INCONSISTENT_OR_OUT_OF_RANGE      0x05
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MANUFACTURING_ERROR_PERCENTAGE_OF_FLASH_WRITE_OPERATIONS_WHICH_HAVE_BEEN_CONDUCTED 0x0A

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_DRAM_INIT_DONE_EVENT_NOT_RECEIVED                  0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_MCTP_SAD_REGISTER_NOT_CORRECTLY_CONFIGURED_BY_BIOS 0x02
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_DMI_TIMEOUT_OF_PECI_REQUEST                        0x03

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_BITMASK 0x80
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SHIFT   7

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS 0
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_FAILURE 1

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_DC_POWER_SOURCE_BITMASK 0x60
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_DC_POWER_SOURCE_SHIFT   5

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_DC_POWER_SOURCE_BMC                   0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_DC_POWER_SOURCE_PSU                   0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_DC_POWER_SOURCE_ON_BOARD_POWER_SENSOR 0x02

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_CHASSIS_POWER_INPUT_SOURCE_BITMASK 0x18
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_CHASSIS_POWER_INPUT_SOURCE_SHIFT   3

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_CHASSIS_POWER_INPUT_SOURCE_BMC                                  0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_CHASSIS_POWER_INPUT_SOURCE_PSU                                  0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_CHASSIS_POWER_INPUT_SOURCE_ON_BOARD_POWER_SENSOR_PSU_EFFICIENCY 0x02
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_CHASSIS_POWER_INPUT_SOURCE_NOT_SUPPORTED                        0x03

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_PSU_EFFICIENCY_SOURCE_BITMASK 0x06
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_PSU_EFFICIENCY_SOURCE_SHIFT   1

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_PSU_EFFICIENCY_SOURCE_BMC           0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_PSU_EFFICIENCY_SOURCE_PSU           0x01
/* Not a typo, jumps to 0x03 */
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_PSU_EFFICIENCY_SOURCE_NOT_SUPPORTED 0x03

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_UNMANAGED_POWER_SOURCE_BITMASK 0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_UNMANAGED_POWER_SOURCE_SHIFT   0

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_UNMANAGED_POWER_SOURCE_BMC       0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_SUCCESS_UNMANAGED_POWER_SOURCE_ESTIMATED 0x01

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_FAILURE_FAILURE_BITMASK 0x60
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_FAILURE_FAILURE_SHIFT   5

#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_FAILURE_FAILURE_BMC_DISCOVERY_FAILURE              0x00
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_FAILURE_FAILURE_INSUFFICIENT_FACTORY_CONFIGURATION 0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_FAILURE_FAILURE_UNKNOWN_SENSOR_TYPE                0x02
#define IPMI_OEM_INTEL_NODE_MANAGER_INTEL_ME_FIRMWARE_HEALTH_EVENT_EVENT_DATA3_AUTO_CONFIGURATION_FINISHED_RESULT_FAILURE_FAILURE_OTHER_ERROR_ENCOUNTERED            0x03

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_SENSOR_NODE_MANAGER 0x02

#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_DOMAIN_ID_BITMASK 0x0F
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_DOMAIN_ID_SHIFT   0

#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_BITMASK 0xF0
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_SHIFT   4

#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_OUTLET_TEMPERATURE_READING_FAILURE             0x8
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_VOLUMETRIC_AIRFLOW_READING_FAILURE             0x9
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_POLICY_MISCONFIGURATION                        0xA
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_POWER_SENSOR_READING_FAILURE                   0xB
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_INLET_TEMPERATURE_READING_FAILURE              0xC
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_HOST_COMMUNICATION_ERROR                       0xD
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_REAL_TIME_CLOCK_SYNCHRONIZATION_FAILURE        0xE
#define IPMI_OEM_INTEL_NODE_MANAGER_HEALTH_EVENT_EVENT_DATA2_ERROR_TYPE_PLATFORM_SHUTDOWN_INITIATED_BY_INTEL_NM_POLICY 0xF

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_OEM_INTEL_THERMAL_SENSOR_ON_DIMM
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_0_MEMORY_CONTROLLER_0_BITMASK 0x01
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_0_MEMORY_CONTROLLER_0_SHIFT   0

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_0_MEMORY_CONTROLLER_1_BITMASK 0x02
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_0_MEMORY_CONTROLLER_1_SHIFT   1

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_1_MEMORY_CONTROLLER_0_BITMASK 0x04
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_1_MEMORY_CONTROLLER_0_SHIFT   2

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_1_MEMORY_CONTROLLER_1_BITMASK 0x08
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_1_MEMORY_CONTROLLER_1_SHIFT   3

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_2_MEMORY_CONTROLLER_0_BITMASK 0x10
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_2_MEMORY_CONTROLLER_0_SHIFT   4

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_2_MEMORY_CONTROLLER_1_BITMASK 0x20
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_2_MEMORY_CONTROLLER_1_SHIFT   5

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_3_MEMORY_CONTROLLER_0_BITMASK 0x40
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_3_MEMORY_CONTROLLER_0_SHIFT   6

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_3_MEMORY_CONTROLLER_1_BITMASK 0x80
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_CPU_3_MEMORY_CONTROLLER_1_SHIFT   7

#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_AVAILABLE     0
#define IPMI_OEM_INTEL_NODE_MANAGER_THERMAL_SENSOR_ON_DIMM_NOT_AVAILABLE 1

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_OEM_INTEL_NODE_MANAGER_CUPS_EVENT
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_CUPS_EVENT_EVENT_DATA1_THRESHOLD_NUMBER_BITMASK 0x03
#define IPMI_OEM_INTEL_NODE_MANAGER_CUPS_EVENT_EVENT_DATA1_THRESHOLD_NUMBER_SHIFT   0

#define IPMI_OEM_INTEL_NODE_MANAGER_CUPS_EVENT_EVENT_DATA1_CUPS_POLICY_EVENT_BITMASK 0x08
#define IPMI_OEM_INTEL_NODE_MANAGER_CUPS_EVENT_EVENT_DATA1_CUPS_POLICY_EVENT_SHIFT   3

#define IPMI_OEM_INTEL_NODE_MANAGER_CUPS_EVENT_EVENT_DATA1_CUPS_EVENT_EVENT_THRESHOLD_EXCEEDED              0x0

#define IPMI_OEM_INTEL_NODE_MANAGER_CUPS_EVENT_EVENT_DATA2_DOMAIN_ID_BITMASK 0x0F
#define IPMI_OEM_INTEL_NODE_MANAGER_CUPS_EVENT_EVENT_DATA2_DOMAIN_ID_SHIFT   0

/* Event Reading Type Code = IPMI_EVENT_READING_TYPE_CODE_STATE
 * Sensor Type = IPMI_SENSOR_TYPE_OEM_INTEL_NODE_MANAGER
 */
#define IPMI_OEM_INTEL_NODE_MANAGER_NM_SMART_CLST_SENSOR_EVENT_DATA2_OFFSET_FROM_SEVERITY_BITMASK 0xF0
#define IPMI_OEM_INTEL_NODE_MANAGER_NM_SMART_CLST_SENSOR_EVENT_DATA2_OFFSET_FROM_SEVERITY_SHIFT   4

#define IPMI_OEM_INTEL_NODE_MANAGER_NM_SMART_CLST_SENSOR_EVENT_DATA3_EXTERNAL 0

#ifdef __cplusplus
}
#endif

#endif /* IPMI_SENSOR_AND_EVENT_CODE_TABLES_OEM_INTEL_NODE_MANAGER_SPEC_H */
